
; Quiz Game

; CPU configuration
	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc


;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF
; Define variables at memory locations

; EEPROM
EEPROM0		equ	H'20'	; folder selection

; RAM
; bank 0 

TEMP		equ	H'20'	; temporary
VALUE_1		equ	H'21'	; delay
VALUE_2		equ	H'22'	; delay	
ACCESS		equ	H'23'	; serial transmission delay
RESPOND		equ	H'24'	; respond flag
COUNTER		equ	H'25'	; timer counter
TIMER		equ	H'26'	; timer value
ANSWER		equ	H'27'	; answer flag (allow S1-S4 operation during answer period)
SET1		equ	H'28'	; LED flasher
TIME_RUN	equ	H'29'	; timer running flag
SWITCH_FLG	equ	H'2A'	; switch flag
TEMP1		equ	H'2B'	; temporary
TEMP2		equ	H'2C'	; temp
BUSY		equ	H'2D'	; busy indicator	
SEND_STO	equ	H'2E'	; switch dependent previous sent value

	ORG     H'2120'		; preprogram EEPROM locations
	DE		H'F1'		; set to folder 01 (root directory)

; define reset and interrupt vector start addresses

	org		0			; start at address 0000h
	goto	MAIN		; normal service routines from Reset vector
	org		4			; interrupt starts here (not used)

; **************************************

MAIN
; set inputs/outputs
	
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'01111111'	; Inputs/outputs
	movwf	TRISB		; port B data direction register
	movlw	B'00000000'	; 
	movwf	OPTION_REG	; PORTB pullups enabled
	movlw   B'00101110'	; Inputs/ outputs 
	movwf   TRISA		; port A data direction register

; analog inputs, A/D
	movlw	B'00001110'	; AN1, AN2 and AN3 are analog inputs
	movwf	ANSEL
	movlw	B'00000000'	; * 4MHz operation left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'01010000'	; Fosc, channel 2 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
; oscillator
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01101000'	; * 4MHz operation
	movwf	OSCCON		; 
	bcf		STATUS,RP0	; select memory bank 0
; timer 1
	movlw	B'00100000'	; * 4MHz operation timer 1 prescaler /4, fosc/4
	movwf	T1CON
	
; serial output
	bsf		STATUS,RP0	; select memory bank 1
	movlw	D'51'		; SPBRG=51 for 4800 baud (4MHz/(16 x (1+SPBRG)))
; tested for baud rates either side of 4800
; with values in SPBRG: 48 (no go. plays file 0 for all switches), 49 ok, 50 ok, 52 ok, 53 ok,
; 54 ok, 55, ok, 56 no play.
	movwf	SPBRG		; set baud rate
	bcf		TXSTA,SYNC	; enable asynchronous serial port
	bcf		STATUS,RP0	; select memory bank 0
	bsf		RCSTA,SPEN	; enable receive asynchronous port
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TXSTA,BRGH	; set high baud rate 
	bsf		TXSTA,TXEN	; enable transmission
	bcf		STATUS,RP0	; select memory bank 0
	
; Initial
	bcf		PIR1,TMR1IF	; overflow flag for timer 1
	movlw	D'0'
	movwf	PORTA	; LEDs off
	bcf		PORTB,7 
	clrf	RESPOND	; respond flag
	clrf	ANSWER	; answer flag
	clrf	TIME_RUN	; buzzer sound
	clrf	SET1	; flashing LED count
	call	DELAY
	clrf	SWITCH_FLG	; switch flag
	clrf	TEMP
	clrf	TEMP1
	clrf	TEMP2

; check if a switch is pressed to change folders

	movf	PORTB,w		; switches at RB0,1,3,4,6
	movwf	TEMP
	iorlw	B'10100100'	; 
	xorlw	H'FF'		; if all high, no switches pressed
	btfsc	STATUS,Z
	goto	START
; switch pressed
; setup EEADR address
	movlw	EEPROM0
	call	EEREAD		; sets EEADR
; Check switch
	btfss	TEMP,0
	goto	SW_5
	btfss	TEMP,3
	goto	SW_4
	btfss	TEMP,1
	goto	SW_3	
	btfss	TEMP,6
	goto	SW_2
	btfss	TEMP,4
	goto	SW_1
	goto	START
	
SW_1
	bsf		PORTA,0		; LED1 on
	movf	PORTA,w
	movwf	TEMP1		; store LED on bit
	movlw	H'F1'		; folder 01
	call 	EEWRITE		; write value
	goto 	WAIT_OPEN
SW_2
	bsf		PORTA,7		; LED2 on
	movf	PORTA,w
	movwf	TEMP1		; store LED on bit
	movlw	H'F2'		; folder 02
	call 	EEWRITE		; write value
	goto 	WAIT_OPEN
SW_3
	bsf		PORTA,6		; LED3 on
	movf	PORTA,w
	movwf	TEMP1		; store LED on bit
	movlw	H'F3'		; folder 03
	call 	EEWRITE		; write value
	goto 	WAIT_OPEN
SW_4
	bsf		PORTB,7		; LED4 on
	movf	PORTB,w
	movwf	TEMP2		; store LED on bit
	movlw	H'F4'		; folder 04
	call 	EEWRITE		; write value
	goto 	WAIT_OPEN
SW_5
	bsf		PORTA,4		; LED5 on
	movf	PORTA,w
	movwf	TEMP1		; store LED on bit
	movlw	H'F5'		; folder 05
	call 	EEWRITE		; write value
;	goto 	WAIT_OPEN
WAIT_OPEN
; wait for switch open
	movlw	D'200'
	call	DELAYT		; switch debounce
	movf	PORTB,w		; switches at RB0,1,3,4,6
	iorlw	B'10100100'	; 
	xorlw	H'FF'		; if all high, no switches pressed
	btfsc	STATUS,Z
	goto	START
	
; LED blink on/off
	incf	SET1,f
; PORTA LEDS
	movlw	D'0'
	btfsc	SET1,0
	movf	TEMP1,w
	movwf	PORTA	; LEDs on/off
; PORTB LED
	movlw	D'0'
	btfsc	SET1,0
	movf	TEMP2,w
	movwf	PORTB	; LED on/off
	goto	WAIT_OPEN

START
	movlw	B'11010001'
	movwf	PORTA	; LEDs on
	bsf		PORTB,7

; wait for MP3 player
	movlw	D'20'
	movwf	TEMP	
MORE_DELAY
	call	DELAY	; wait for MP3 player to start
	decfsz	TEMP,F
	goto	MORE_DELAY
	movwf	PORTA	; LEDs off
	bcf		PORTB,7
	
; get folder selection
	movlw	EEPROM0		; folder
	call	EEREAD
	call	SEND		; set folder
	movlw	D'231'		; max. volume set
	call	SEND


; *************************************************
; scan switches and timer operation
SCAN
; check if timer running
	btfss	TIME_RUN,0	; timer running flag
	goto	SWITCH
; check if timer >228 for timeout set by file length
	movf	TIMER,w
	sublw	D'228'
	btfsc	STATUS,C
	goto	DECREASE_TIMER
; timeout by file length
	btfss	RESPOND,0	; when set, answer period
	goto	T_OUT_BUSY
; answer timeout by busy signal. High for ended
	call	BUSY_CHK	; checks busy signal
	btfss	BUSY,1		; check busy flag		
	goto	SWITCH
	goto	CK_RESPOND
T_OUT_BUSY
; timeout by busy signal. High for ended
	call	BUSY_CHK	; checks busy signal
	btfss	BUSY,1		; check busy flag		
	goto	SWITCH
	clrf	TIME_RUN
	movlw	D'239'		; stop
	call	SEND
	goto	SWITCH

DECREASE_TIMER
; check timer flag
	btfss	PIR1,TMR1IF
	goto	SWITCH		; check switches
	bcf		PIR1,TMR1IF	; overflow for timer 1 flag cleared
	movf	COUNTER,w
	btfsc	STATUS,Z
	goto	CK_RESPOND
	decfsz	COUNTER,f
	goto	SWITCH
	
; timer/busy signal end
; check RESPOND flag
CK_RESPOND
	btfss	RESPOND,0	; when set play buzzer
	goto	END_TIME
	movlw	D'239'		; stop
	call	SEND
	movlw	D'06'		; file 6, buzzer or end of answer period
	movwf	SEND_STO	; store sent value
	call 	SEND
; set buzzer play period with play timer setting 
	clrf	RESPOND		; clear respond flag 
	clrf	ANSWER		; 					 ; remark out for file length only set by file
	goto	SW_END1		; sets timer; 		 ; remark out for file length only set by file

	clrf	TIME_RUN	; for timeout by file length only
	goto	SWITCH		; for timeout by file length only
END_TIME
	clrf	TIME_RUN
	movlw	D'239'		; stop
	call	SEND

; check switches		
SWITCH

; if SWITCH_FLG,0 set (switch 5) wait till open again before acting on a closed switch
; if SWITCH_FLG,1 set (switches 1-4) closed wait till open but check for S5

; 1-4
	btfss	SWITCH_FLG,1	; if set wait for switches to open but check SWITCH 5
	goto	SWITCH_CK5
; check for S5 closed (high priority)(RB0 low)
	btfss	PORTB,0
	goto	SW5	
	movf	PORTB,w		; switches at RB0,1,3,4,6
	iorlw	B'10100100'	; 
	xorlw	H'FF'		; if all high, no switches pressed
	btfss	STATUS,Z
	goto	SCAN
	bcf		SWITCH_FLG,1; switch flag cleared
	goto	SWITCH_NORMAL

SWITCH_CK5
	btfss	SWITCH_FLG,0; switch 5 closed
	goto	SWITCH_NORMAL
	movf	PORTB,w		; switches at RB0,1,3,4,6
	iorlw	B'10100100'	; 
	xorlw	H'FF'		; if all high, no switches pressed
	btfss	STATUS,Z
	goto	SCAN
	bcf		SWITCH_FLG,0; switch flag cleared

SWITCH_NORMAL
	movf	PORTB,w		; switches at RB0,1,3,4,6
	movwf	TEMP
	iorlw	B'10100100'	; 
	xorlw	H'FF'		; if all high, no switches pressed
	btfss	STATUS,Z
	goto	SWITCH_CLOSED
; if busy flag off clear LEDs
	call	BUSY_CHK	; checks busy signal
	btfss	BUSY,1		; check busy flag
	goto	SCAN
	movlw	D'0'
	movwf	PORTA	; LEDs off
	bcf		PORTB,7
	goto	SCAN	
	
SWITCH_CLOSED
	btfss	TEMP,0
	goto	SW5
	btfss	TEMP,3
	goto	SW4
	btfss	TEMP,1
	goto	SW3	
	btfss	TEMP,6
	goto	SW2
	btfss	TEMP,4
	goto	SW1
	goto	SCAN

SW1
; if ANSWER flag set then can respond
	btfsc	ANSWER,0
	goto	ANSWER1	
; if busy then bypass
	call	BUSY_CHK	; checks busy signal
	btfss	BUSY,1		; check busy flag
	goto	SW_END
ANSWER1
	clrf	RESPOND	; clear respond flag
	clrf	ANSWER
	movlw	D'0'
	movwf	PORTA	; LEDs off
	bcf		PORTB,7
	bsf		PORTA,0	; LED1 on
	movlw	D'239'	; stop
	call	SEND
	movlw	D'01'	; file 1
	movwf	SEND_STO; store sent value
	call	SEND
	goto	SW_END1

SW2
; if ANSWER flag set then can respond
	btfsc	ANSWER,0
	goto	ANSWER2	
; if busy then bypass
	call	BUSY_CHK	; checks busy signal
	btfss	BUSY,1		; check busy flag
	goto	SW_END
ANSWER2
	clrf	ANSWER
	clrf	RESPOND	; clear respond flag
	movlw	D'0'
	movwf	PORTA	; LEDs off
	bcf		PORTB,7
	bsf		PORTA,7	; LED2 on
	movlw	D'239'	; stop
	call	SEND
	movlw	D'02'	; file 2
	movwf	SEND_STO; store sent value
	call	SEND
	goto	SW_END1

SW3
; if ANSWER flag set then can respond
	btfsc	ANSWER,0
	goto	ANSWER3	
; if busy then bypass
	call	BUSY_CHK	; checks busy signal
	btfss	BUSY,1		; check busy flag
	goto	SW_END
ANSWER3
	clrf	ANSWER
	clrf	RESPOND	; clear respond flag
	movlw	D'0'
	movwf	PORTA	; LEDs off
	bcf		PORTB,7
	bsf		PORTA,6	; LED3 on
	movlw	D'239'	; stop
	call	SEND
	movlw	D'03'	; file 3
	movwf	SEND_STO; store sent value
	call	SEND
	goto	SW_END1

SW4
; if ANSWER flag set then can respond
	btfsc	ANSWER,0
	goto	ANSWER4	
; if busy then bypass
	call	BUSY_CHK	; checks busy signal
	btfss	BUSY,1		; check busy flag
	goto	SW_END
ANSWER4
	clrf	ANSWER
	clrf	RESPOND	; clear respond flag
	movlw	D'0'
	movwf	PORTA	; LEDs off
	bcf		PORTB,7
	bsf		PORTB,7	; LED4 on
	movlw	D'239'	; stop
	call	SEND
	movlw	D'04'	; file 4
	movwf	SEND_STO; store sent value
	call	SEND
	goto	SW_END1

SW5
; Adjudicator's switch.
; if switch flag for Switch 5 is set then bypass
	btfsc	SWITCH_FLG,0
	goto	SCAN 
	movlw	D'0'
	movwf	PORTA		; LEDs off
	bcf		PORTB,7
	bsf		PORTA,4		; LED5 on
; if no sound then play a file, Cancels sounds otherwise  
; check if busy (playing a file)

	call	BUSY_CHK	; checks busy signal
	btfss	BUSY,1		; check busy flag
	goto	CANCEL
	movlw	D'239'		; stop
	call	SEND
	movlw	D'05'		; play file
	movwf	SEND_STO; store sent value
	call	SEND
; set timer for timeout
	bsf		RESPOND,0	; respond flag set
	bsf		ANSWER,0	; answer flag
; read A/D AN2
	movlw	B'01010000'	; Fosc, channel 2 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	call	ACQUIRE_AD
	movwf	TIMER		; timer value
	movwf	COUNTER		; working countdown timer
; set timer range
; divide by 2 for 0-127
	bcf		STATUS,C
	rrf		COUNTER,w
	addlw	D'5'		; minimum time 
	movwf	COUNTER		; working countdown timer
; clear timer 1
	bcf		T1CON,0		; timer 1 off
	clrf	TMR1L
	clrf	TMR1H
	bsf		T1CON,0		; timer 1 on

	bcf		PIE1,TMR1IF	; clear overflow flag 
	bsf		TIME_RUN,0	; timer running flag

; wait for busy flag to go low.
	movlw	D'4'		; test busy flag 
	movwf	TEMP
BUSY5
	call	BUSY_CHK	; checks busy signal
	btfss	BUSY,1		; check busy flag
	goto	SW_END5
	call	DELAY	
	decfsz	TEMP,f	
	goto	BUSY5
; no busy signal, resend
	movlw	D'239'		; stop
	call	SEND
	movf	SEND_STO,w	; switch dependent previous sent value
	call	SEND
	goto	SW_END5
CANCEL
	movlw	D'239'		; stop
	call	SEND
	clrf	TIME_RUN
	movlw	D'100'
	call	DELAYT		; switch debounce
	bsf		SWITCH_FLG,0	; set switch closed flag
	goto	SCAN		; scan switches

; end for S5
SW_END5
	movlw	D'100'
	call	DELAYT		; switch debounce
	bsf		SWITCH_FLG,0	; set switch closed flag
; wait for busy flag to go low.
	movlw	D'4'		; test busy flag 
	movwf	TEMP
BUSY5R
	call	BUSY_CHK	; checks busy signal
	btfss	BUSY,1		; check busy flag
	goto	SCAN
	call	DELAY	
	decfsz	TEMP,f	
	goto	BUSY5R
; no busy signal, resend
	movlw	D'239'		; stop
	call	SEND
	movf	SEND_STO,w	; switch dependent previous sent value
	call	SEND
; wait for busy flag to go low.
	movlw	D'4'		; test busy flag 
	movwf	TEMP
BUSY_5R1
	call	BUSY_CHK	; checks busy signal
	btfss	BUSY,1		; check busy flag
	goto	SCAN
	call	DELAY	
	decfsz	TEMP,f
	goto	BUSY_5R1	
	goto	SCAN		; scan switches

; end for S1-S4
SW_END1
; set play time
; read A/D. AN3
	movlw	B'01011000'	; Fosc, channel 3 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	call	ACQUIRE_AD
	movwf	TIMER		; timer value
	movwf	COUNTER		; working countdown timer
; set timer range
; divide by 4 for 0-63
	bcf		STATUS,C
	rrf		COUNTER,f
	bcf		STATUS,C
	rrf		COUNTER,w
	addlw	D'5'		; minimum time 
	movwf	COUNTER		; working countdown timer

; clear timer 1
	bcf		T1CON,0		; timer 1 off
	clrf	TMR1L
	clrf	TMR1H
	bsf		T1CON,0		; timer 1 on

	bcf		PIE1,TMR1IF	; clear overflow flag 
	bsf		TIME_RUN,0	; timer running flag

; wait for busy flag to go low.
	movlw	D'4'		; test busy flag 
	movwf	TEMP
BUSY1_4
	call	BUSY_CHK	; checks busy signal
	btfss	BUSY,1		; check busy flag
	goto	SW_END
	call	DELAY	
	decfsz	TEMP,f	
	goto	BUSY1_4
; no busy signal, resend
	movlw	D'239'		; stop
	call	SEND
	movf	SEND_STO,w	; switch dependent previous sent value
	call	SEND

SW_END ; for S1-S4
	movlw	D'100'
	call	DELAYT		; switch debounce
	bsf		SWITCH_FLG,1; switch flag 1-4 
; wait for busy flag to go low.
	movlw	D'4'		; test busy flag 
	movwf	TEMP
BUSY1_4R
	call	BUSY_CHK	; checks busy signal
	btfss	BUSY,1		; check busy flag
	goto	SCAN
	call	DELAY	
	decfsz	TEMP,f
	goto	BUSY1_4R
; no busy signal, resend
	movlw	D'239'		; stop
	call	SEND
	movf	SEND_STO,w	; switch dependent previous sent value
	call	SEND
; wait for busy flag to go low.
	movlw	D'4'		; test busy flag 
	movwf	TEMP
BUSY1_4R1
	call	BUSY_CHK	; checks busy signal
	btfss	BUSY,1		; check busy flag
	goto	SCAN
	call	DELAY	
	decfsz	TEMP,f
	goto	BUSY1_4R1	
	goto	SCAN		; scan switches

; end of normal run routine

; **********************************************************************
; subroutines

; send data and wait till data sent
SEND
	movwf	TXREG		; transmit register
	bsf		STATUS,RP0	; select memory bank 1
	bcf		STATUS,RP1
WAIT_CLEAR
	btfsc	TXSTA,TRMT	; wait till TRMT is clear
	goto	WAIT_CLEAR
CHK_XMS
	btfss	TXSTA,TRMT	; if set transmission complete
	goto	CHK_XMS
	bcf		STATUS,RP0	; select memory bank 0

; delay for serial transmission to complete
	movlw	0xFF
	movwf	ACCESS
WAIT_ACCESS
	decfsz	ACCESS,f
	goto	WAIT_ACCESS
	return

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,2	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	movf	ADRESH,w
	return

; subroutine to check busy signal
BUSY_CHK
; read A/D AN1, busy level 0-2.2V
	movlw	B'01001000'	; Fosc, channel 1 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	call	ACQUIRE_AD
; A/D value if >56 (1.1V) then not busy
	sublw	D'56'
	clrf	BUSY		; set as busy
	btfss	STATUS,C	
	bsf		BUSY,1		; set for not busy
	return

; delay subroutine
DELAY	
	movlw	D'255'		; about .26s
DELAYT
	movwf	VALUE_1		; VALUE_1 = w
LP_X
	movlw	D'255'		; set delay period value 2 
	movwf	VALUE_2		; VALUE_2 = w
LP_Y
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_Y
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_X
	return

; subroutine to read EEPROM memory 

EEREAD
	bsf 	STATUS,RP1	; select memory bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM

EEWRITE
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf		STATUS,RP0	; bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
WRITE1	

	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE1		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0
	bcf		STATUS,RP1	; bank 0 
	return				; value written
	
	
	end
