
#define _CRT_SECURE_NO_WARNINGS
#include "targetver.h"
#include "WindowsShell.h"
#include <windows.h>
#include <ShlObj.h>

extern const wchar_t* wcProgramPath;
#define MYAPP L"DigitalLightingController"

bool RegisterExtensions(const wchar_t** extensions, int num_extensions) {
	HKEY CLC;
	DWORD Disposition;
	bool bRet = false;
	if( RegCreateKeyEx(HKEY_CLASSES_ROOT, MYAPP L"\\shell\\open\\command", 0, NULL, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE, NULL, &CLC, &Disposition) == ERROR_SUCCESS ) {
		wchar_t wcExePath[_MAX_PATH+32];
		if( GetModuleFileName((HMODULE)NULL, wcExePath+1, sizeof(wcExePath)/sizeof(*wcExePath)-32) ) {
			wcExePath[0] = L'"';
			wcscat(wcExePath, L"\" \"%1\"");
			if( RegSetValueEx(CLC, NULL, NULL, REG_SZ, (const BYTE*)wcExePath, wcslen(wcExePath)*sizeof(wchar_t)) == ERROR_SUCCESS ) {
				bRet = true;
				for( int i = 0; i < num_extensions; ++i ) {
					HKEY Ext;
					if( RegCreateKeyEx(HKEY_CLASSES_ROOT, extensions[i], 0, NULL, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE, NULL, &Ext, &Disposition) == ERROR_SUCCESS ) {
						if( RegSetValueEx(Ext, NULL, NULL, REG_SZ, (const BYTE*)MYAPP, sizeof(MYAPP)-sizeof(wchar_t)) != ERROR_SUCCESS )
							bRet = false;
						RegCloseKey(Ext);
					} else {
						bRet = false;
					}
				}
			}
		}
		RegCloseKey(CLC);
	}
	SHChangeNotify(SHCNE_ASSOCCHANGED, 0, 0, 0);
	return bRet;
}

bool UnregisterExtensions(const wchar_t** extensions, int num_extensions) {
	bool bRet = true;
	for( int i = 0; i < num_extensions; ++i ) {
		HKEY Ext;
		if( RegOpenKey(HKEY_CLASSES_ROOT, extensions[i], &Ext) == ERROR_SUCCESS ) {
			wchar_t buf[_MAX_PATH];
			LONG size = sizeof(buf);
			if( RegQueryValue(Ext, NULL, buf, &size) == ERROR_SUCCESS ) {
				if( !wcscmp(buf, MYAPP) ) {
					if( RegDeleteKey(HKEY_CLASSES_ROOT, extensions[i]) != ERROR_SUCCESS )
						bRet = false;
				}
			} else {
				bRet = false;
			}
		}
	}
	RegDeleteKey(HKEY_CLASSES_ROOT, MYAPP L"\\shell\\open\\command");
	RegDeleteKey(HKEY_CLASSES_ROOT, MYAPP L"\\shell\\open");
	RegDeleteKey(HKEY_CLASSES_ROOT, MYAPP L"\\shell");
	if( RegDeleteKey(HKEY_CLASSES_ROOT, MYAPP) != ERROR_SUCCESS )
		bRet = false;
	SHChangeNotify(SHCNE_ASSOCCHANGED, 0, 0, 0);
	return bRet;
}

bool AreExtensionsRegistered(const wchar_t** extensions, int num_extensions) {
	HKEY temp;
	wchar_t buf[_MAX_PATH];
	if( RegOpenKey(HKEY_CLASSES_ROOT, MYAPP L"\\shell\\open\\command", &temp) != ERROR_SUCCESS )
		return false;
	LONG size = sizeof(buf);
	if( RegQueryValue(temp, NULL, buf, &size) != ERROR_SUCCESS ) {
		RegCloseKey(temp);
		return false;
	}
	RegCloseKey(temp);

	wchar_t wcExePath[_MAX_PATH+32];
	if( !GetModuleFileName((HMODULE)NULL, wcExePath+1, sizeof(wcExePath)/sizeof(*wcExePath)-32) )
		return false;
	wcExePath[0] = L'"';
	wcscat(wcExePath, L"\" \"%1\"");
	if( wcscmp(buf, wcExePath) )
		return false;

	for( int i = 0; i < num_extensions; ++i ) {
		if( RegOpenKey(HKEY_CLASSES_ROOT, extensions[i], &temp) != ERROR_SUCCESS )
			return false;
		LONG size = sizeof(buf);
		if( RegQueryValue(temp, NULL, buf, &size) != ERROR_SUCCESS ) {
			RegCloseKey(temp);
			return false;
		}
		RegCloseKey(temp);
		if( wcscmp(buf, MYAPP) )
			return false;
	}
	return true;
}

