
#pragma once

struct sequence {
	unsigned short* commands;
	int len, used;
};

struct sequence_state {
	int pos, ms_pos, ms_remain, brightness;
	short ramp, ramp_remainder, ramp_ms;
};

#define IS_DELAY_CMD(x) ((((x)>>8)>=1)&&(((x)>>8)<=3))
#define DELAY_MS(x) ((((x)&255)+1)<<((((x)>>8)-1)<<1))
#define DELAY_MS_REMAINDER(x) ((x)>1024?((x)&15):(x)>256?((x)&3):0)
#define IS_RAMP_CMD(x) (((x)>>13)>=2)

extern sequence sequences[32];

bool sequence_load(const wchar_t* filename, int max_ms = -1);
void sequence_init(const sequence* sq, sequence_state* ss);
void sequence_execute_command(const sequence* sq, sequence_state* ss);
void sequence_advance(const sequence* sq, sequence_state* ss, int ms, bool bUpTo = false, bool bConsumeMax = true);
void sequence_advance_past(const sequence* sq, sequence_state* ss, int ms);
void sequence_do_ramp(sequence_state* ss, int ms);
void sequence_destroy(sequence* dest);
void sequence_close();
bool sequence_save(const wchar_t* filename, bool bBackup);
int sequence_append_delay(sequence* sq, int milliseconds);
void sequence_append_command(sequence* dest, unsigned short command);
void sequence_insert_command(sequence* dest, int index, unsigned short command);
void sequence_remove_command(sequence* dest, int index, int count = 1);
void sequence_break_delay(sequence* dest, sequence_state* state, sequence_state* other_state);
int sequence_insert_delay(sequence* dest, int milliseconds, sequence_state* state, sequence_state* other_state);
int sequence_insert_set_brightness(sequence* dest, int which, int brightness, sequence_state* state, sequence_state* other_state);
int sequence_append_ramp(sequence* dest, int which, int direction, int duration);
void sequence_append_long_ramp(sequence* dest, int which, int start_brightness, int final_brightness, int duration);
int sequence_insert_ramp(sequence* dest, int which, int direction, int duration, sequence_state* state, sequence_state* other_state);
void sequence_compact(sequence* dest, int start, int finish);
int sequence_append_translated_commands(sequence* dest, sequence* source, int start, int finish, int new_light);
int sequence_replace_translated_commands(sequence* dest, sequence* source, int start, int finish, int new_light, int max_ms = -1);
int sequence_get_length_ms(sequence* pSeq);
void sequence_merge(sequence* pDest, sequence* pSource1, sequence_state* pState1, sequence* pSource2, sequence_state* pState2, int which, int max_length);
void sequence_copy(sequence* pDest, sequence* pSource);
void sequence_stretch(sequence* pDest, sequence* pSource, int new_len_ms);
void sequence_mix(sequence* pDest, sequence* pSource1, sequence_state* pState1, sequence* pSource2, sequence_state* pState2, int which, int max_length);
void sequence_truncate(sequence* pDest, int max_len_ms, int min_len_ms);
