
#include <windows.h>

extern HWND hToolbar;
extern int follow_playback_pos, scroll_follows_playback, loop_playback;

typedef bool IsEnabled(const wchar_t** pReason);

struct ToolbarEntry {
	wchar_t* tooltip;
	DWORD cmd;
	char shortcut;
	bool bOnToolbar, bCheck, bDefaultState, bDropdown;
	int alt_vkey_shortcut;
	IsEnabled* CheckEnabled;
};

typedef struct {
	int start, finish;
	DWORD selected_lights, current_light;
} selection;

extern selection selection_storage[9];

HWND CreateToolbar(HWND hWnd, HINSTANCE hInst);
void SetupMenus(HWND hWnd, HINSTANCE hInst);
void SetCheckedMenuItem(HWND hWnd, int MenuItemID, bool bChecked);
void SetMenuItemDisabled(HWND hWnd, int MenuItemID, bool bDisabled);
ToolbarEntry* FindToolbarEntry(DWORD cmd, bool bIncludeMenus = true);
ToolbarEntry* FindToolbarEntry(char shortcut, bool bIncludeMenus = true);
ToolbarEntry* FindToolbarEntryByVKey(int VKey, bool bIncludeMenus = true);
void UpdateLightBarTooltips(HWND hWnd, HINSTANCE HInst, wchar_t light_names[32][256]);
void UpdateDisabledState(HWND hWnd);
void UpdateRecentFilesMenu(HWND hWnd, HINSTANCE hInst = (HINSTANCE)NULL);
void UpdateSelectionStorageMenu(HWND hWnd, HINSTANCE hInst = (HINSTANCE)NULL);
void UpdateCopyBufferStorageMenu(HWND hWnd, HINSTANCE hInst = (HINSTANCE)NULL);
void UpdatePasteSpecialMenu(HWND hWnd, HINSTANCE hInst = (HINSTANCE)NULL);
void ToggleFollowPlaybackPos(HWND hWnd);
void ToggleLoopPlayback(HWND hWnd);
void SetFollowPlaybackPos(HWND hWnd, bool bFollow);
void SetLoopPlayback(HWND hWnd, bool bLoop);
void UpdatePublishEnabledStatus(HWND hWnd);
