
#define _CRT_SECURE_NO_WARNINGS
#include "Progress.h"
#include "Resource.h"
#include "Win32Utilities.h"
#ifdef _DEBUG
#include "assert.h"
#endif

int ProgressNest;
DWORD ProgressStartTicks;
HWND hProgress, hOldFocus;
wchar_t wcOrigProgressMessage[256], wcProgressMessage[256];
int ProgressTotal, ProgressPos, ProgressWeight, ProgressSubTotal, ProgressSubPos, ProgressSubWeight, ProgressLastPos, ProgressLastFinish, LastProgress;
bool g_bProgressCancelled;
extern HWND hDialog, hDropdown;
extern HACCEL hAccelTable;
extern HINSTANCE hInst;

static void MessageLoop() {
	MSG msg;
	while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
	{
		if ((!IsWindow(hDialog) || !IsDialogMessage(hDialog, &msg)) && (!IsWindow(hDropdown) || !IsDialogMessage(hDropdown, &msg)) && (!IsWindow(hProgress) || !IsDialogMessage(hProgress, &msg)) && !TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
}

static INT_PTR CALLBACK PleaseWaitDialogProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg) {
	case WM_INITDIALOG:
		SendMessage(GetSubWindow(hWnd, IDC_PROGRESS), PBM_SETRANGE, 0, 1000<<16);
		SendMessage(GetSubWindow(hWnd, IDC_PROGRESS), PBM_SETPOS, 0, 0);
		return TRUE;
	case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam);
			int wmEvent = HIWORD(wParam);
			if( wmEvent == 0 ) {
				switch(wmId) {
				case IDCANCEL:
					g_bProgressCancelled = true;
					return TRUE;
				}
			}
			break;
		}
	case WM_CLOSE:
		DestroyWindow(hWnd);
		return TRUE;
	case WM_DESTROY:
		hProgress = (HWND)NULL;
		SetFocus(hOldFocus);
		break;
	}
	return FALSE;
}

static void OpenProgressDialog(HWND hWnd) {
	hOldFocus = GetFocus();
	hProgress = CreateDialog(hInst, MAKEINTRESOURCE(IDD_PLEASEWAIT), hWnd, PleaseWaitDialogProc);
	LastProgress = 0;
	MessageLoop();
}

static void UpdateProgressDialog() {
	wchar_t buf[16];
#ifdef _DEBUG
	wchar_t debug[512];
#endif
	int Progress = ((long long)ProgressLastPos * (ProgressSubWeight * ProgressWeight) + (long long)ProgressLastFinish * (ProgressPos * ProgressSubTotal + ProgressSubPos * ProgressWeight)) / (ProgressTotal * ProgressSubTotal) * 1000LL / ProgressLastFinish;
	if( Progress != LastProgress ) {
#ifdef _DEBUG
		assert(Progress+1 >= LastProgress); // +1 accounts for possible rounding errors
#endif
		LastProgress = Progress;
#ifdef _DEBUG
		wsprintf(debug, L"%d pos=%d weight=%d total=%d subpos=%d subweight=%d subtotal=%d lastpos=%d lastfinish=%d\n", Progress, ProgressPos, ProgressWeight, ProgressTotal, ProgressSubPos, ProgressSubWeight, ProgressSubTotal, ProgressLastPos, ProgressLastFinish);
		OutputDebugString(debug);
#endif
		SendMessage(GetSubWindow(hProgress, IDC_PROGRESS), PBM_SETPOS, Progress, 0);
		wsprintf(buf, L"%d%%", (Progress+5)/10);
		SetWindowText(GetSubWindow(hProgress, IDC_PLEASEWAITPCT), buf);
		MessageLoop();
	}
}

static void UpdateProgressText(const wchar_t* wcText) {
	wchar_t buf[256];
	wsprintf(buf, L"Please wait, %s...", wcText);
	SetWindowText(GetSubWindow(hProgress, IDC_PLEASEWAITTEXT), buf);
	UpdateProgressDialog();
}

void StartProgress(HWND hWnd, const wchar_t* wcMessage) {
	if( ++ProgressNest == 1 ) {
		ProgressStartTicks = GetTickCount();
		wcscpy(wcProgressMessage, wcMessage);
		wcscpy(wcOrigProgressMessage, wcMessage);
		ProgressTotal = 1;
		ProgressPos = 0;
		ProgressWeight = 1;
		ProgressSubTotal = 1;
		ProgressSubPos = 0;
		ProgressSubWeight = 1;
		ProgressLastPos = 0;
		ProgressLastFinish = 1;
		g_bProgressCancelled = false;
	} else {
		wsprintf(wcProgressMessage, L"%s (%s)", wcOrigProgressMessage, wcMessage);
		if( hProgress )
			UpdateProgressText(wcProgressMessage);
	}
}

bool FinishProgress(HWND hWnd) {
	if( --ProgressNest == 0 && hProgress ) {
		DestroyWindow(hProgress);
		hProgress = (HWND)NULL;
	}
	return !g_bProgressCancelled;
}

bool UpdateProgress(HWND hWnd, int pos, int finish) {
	if( !hProgress && (int)(GetTickCount() - ProgressStartTicks) >= 250 ) {
		OpenProgressDialog(hWnd);
		UpdateProgressText(wcProgressMessage);
	}
	ProgressLastPos = pos;
	ProgressLastFinish = finish;
	if( hProgress )
		UpdateProgressDialog();
	return !g_bProgressCancelled;
}

bool ProgressStep(HWND hWnd, int total, int pos, int weight) {
	ProgressTotal = total;
	ProgressPos = pos;
	ProgressWeight = weight;
	ProgressSubTotal = 1;
	ProgressSubPos = 0;
	ProgressSubWeight = 1;
	ProgressLastPos = 0;
	if( hProgress )
		UpdateProgressDialog();
	return !g_bProgressCancelled;
}

bool ProgressSubStep(HWND hWnd, int total, int pos, int weight) {
	ProgressSubTotal = total;
	ProgressSubPos = pos;
	ProgressSubWeight = weight;
	ProgressLastPos = 0;
	if( hProgress )
		UpdateProgressDialog();
	return !g_bProgressCancelled;
}

bool ProgressDialogIsOpen() {
	return hProgress != (HWND)NULL;
}
