
#include "targetver.h"
#include "CopyPaste.h"
#include "Sequence.h"
#include "WindowDrawing.h"
#include "WAVBrowse.h"
#include "EditSequence.h"
#include "Undo.h"
#include "ToolbarsMenus.h"
#ifdef _DEBUG
#include <assert.h>
#endif


struct CopyEntry {
	int i;
	sequence sq;
};

struct CopyBuffer {
	CopyEntry* pEntries;
	int NumEntries;
	int ms;
};

CopyBuffer copybuffer, copybufferstorage[9];

static void FreeCopyBuffer(CopyBuffer* pCopyBuffer) {
	for( int i = 0; i < pCopyBuffer->NumEntries; ++i )
		sequence_destroy(&pCopyBuffer->pEntries[i].sq);
	delete pCopyBuffer->pEntries;
	pCopyBuffer->pEntries = 0;
	pCopyBuffer->NumEntries = 0;
	pCopyBuffer->ms = 0;
}
static void AllocCopyBuffer(CopyBuffer* pCopyBuffer, unsigned long which) {
	int num = 0;
	FreeCopyBuffer(pCopyBuffer);
	for( int i = 0; i < 32; ++i )
		if( which&(1<<i) )
			++num;
	pCopyBuffer->NumEntries = num;
	pCopyBuffer->pEntries = new CopyEntry[num];
	int x = 0;
	for( int i = 0; i < 32; ++i ) {
		if( which&(1<<i) )
			pCopyBuffer->pEntries[x].i = x++;
	}
}
static void CopyCopyBuffer(CopyBuffer* pDest, CopyBuffer* pSource) {
	int num = 0;
	FreeCopyBuffer(pDest);
	pDest->NumEntries = pSource->NumEntries;
	pDest->pEntries = new CopyEntry[pDest->NumEntries];
	for( int i = 0; i < pDest->NumEntries; ++i ) {
		pDest->pEntries[i].i = pSource->pEntries[i].i;
		sequence_copy(&pDest->pEntries[i].sq, &pSource->pEntries[i].sq);
	}
	pDest->ms = pSource->ms;
}

void Copy(HWND hWnd) {
	int start_ms = (int)((selection_start + ((wav_sample_rate+999) / 1000 - 1)) * 1000LL / wav_sample_rate);
	int finish_ms = (int)((selection_finish + 1) * 1000LL / wav_sample_rate);
	bool bCouldPaste = (copybuffer.NumEntries != 0);

	if( selection_start == -1 ) {
		MessageBox(hWnd, L"Please select the time period within which you wish to copy data.", L"No time period selected", MB_OK|MB_ICONEXCLAMATION);
	} else if( start_ms == finish_ms ) {
		MessageBox(hWnd, L"Your selection is less than 1 millisecond long. 1 millisecond is the minimum time period that can be copied.", L"Selected time period too short", MB_OK|MB_ICONEXCLAMATION);
	} else {
		unsigned long which = selected_lights;
		int x;

		if( which == 0 )
			which = 0xFFFFFFFF;
		AllocCopyBuffer(&copybuffer, which);
		x = 0;
		for( int i = 0; i < 32; ++i ) {
			if( which&(1<<i) ) {
				int len;

				sequence_state start_ss, finish_ss;
				sequence_init(&sequences[i], &start_ss);
				sequence_advance(&sequences[i], &start_ss, start_ms, true, false);
				finish_ss = start_ss;
				sequence_advance(&sequences[i], &finish_ss, finish_ms, true, false);
				len = finish_ss.pos - start_ss.pos;

				sequence* pSeq = &copybuffer.pEntries[x].sq;
				pSeq->len = len+16;
				pSeq->used = 0;
				pSeq->commands = new unsigned short [pSeq->len];

				sequence_append_command(pSeq, (1<<13)|(x<<8)|start_ss.brightness);
				if( start_ss.ramp_ms )
					sequence_append_ramp(pSeq, x, start_ss.ramp < 0 ? -1 : 1, start_ss.ramp_ms);
				if( start_ss.ms_remain && start_ss.pos != finish_ss.pos )
					sequence_append_delay(pSeq, start_ss.ms_remain);
				sequence_append_translated_commands(pSeq, &sequences[i], start_ss.pos, finish_ss.ms_remain ? finish_ss.pos-1 : finish_ss.pos, x);
				if( finish_ss.ms_remain ) {
					if( finish_ss.pos != start_ss.pos )
						sequence_append_delay(pSeq, DELAY_MS(sequences[i].commands[finish_ss.pos-1]) - finish_ss.ms_remain);
					else
						sequence_append_delay(pSeq, finish_ms - start_ms);
				}
//				if( finish_ss.ramp_ms )
//					sequence_append_command(pSeq, (1<<13)|(x<<8));

				++x;
			}
		}
		copybuffer.ms = finish_ms - start_ms;
		DelayedUpdateDisabledState(hWnd);
		if( bCouldPaste != (copybuffer.NumEntries != 0) ) {
			UpdateCopyBufferStorageMenu(hWnd);
			UpdatePasteSpecialMenu(hWnd, NULL);
		}
	}
}

void Paste(HWND hWnd, bool bMerge, bool bMix, bool bStretch) {
	int start_ms = (int)((selection_start + ((wav_sample_rate+999) / 1000 - 1)) * 1000LL / wav_sample_rate);
	int finish_ms = (int)((selection_finish + 1) * 1000LL / wav_sample_rate);

	if( !copybuffer.ms ) {
		MessageBox(hWnd, L"You must copy data before you can paste it.", L"Copy buffer empty", MB_OK|MB_ICONEXCLAMATION);
	} else if( selection_start == -1 ) {
		MessageBox(hWnd, L"Please select the location/period where you wish to paste data.", L"No selection", MB_OK|MB_ICONEXCLAMATION);
	} else if( (bMerge || bStretch) && selection_start == selection_finish ) {
		MessageBox(hWnd, L"You can not do a merged/stretched paste if the selection does not have a width.", L"Selection not wide enough", MB_OK|MB_ICONEXCLAMATION);
	} else {
		unsigned long which = selected_lights;
		unsigned long altered_lights = 0;
		int finish;
		bool bRedrawRest = false;
		int x;

		if( bStretch ) {
			finish = finish_ms * (long long)wav_sample_rate / 1000;
		} else {
			finish = (start_ms + copybuffer.ms) * (long long)wav_sample_rate / 1000;
			if( selection_finish > selection_start && finish > selection_finish )
				finish = selection_finish;
		}

		int start_ms = (int)((selection_start + ((wav_sample_rate+999) / 1000 - 1)) * 1000LL / wav_sample_rate);
		int finish_ms = (int)((finish + 1) * 1000LL / wav_sample_rate);

		if( which == 0 )
			which = 0xFFFFFFFF;
		x = 0;
		UndoBegin();
		for( int i = 0; i < 32; ++i ) {
			if( x == copybuffer.NumEntries )
				break;
			if( which&(1<<i) ) {
				altered_lights |= (1<<i);
				if( bMerge || bMix ) {
					sequence temp;
					memset(&temp, 0, sizeof(temp));
					sequence_state ss, orig_ss;
					sequence_init(&sequences[i], &orig_ss);
					sequence_advance(&sequences[i], &orig_ss, start_ms, true);
					if( bStretch ) {
						sequence temp2;
						memset(&temp2, 0, sizeof(temp2));
						sequence_stretch(&temp2, &copybuffer.pEntries[x].sq, finish_ms - start_ms);
						sequence_init(&temp2, &ss);
						if( bMerge )
							sequence_merge(&temp, &sequences[i], &orig_ss, &temp2, &ss, i, finish_ms - start_ms);
						else
							sequence_mix(&temp, &sequences[i], &orig_ss, &temp2, &ss, i, finish_ms - start_ms);
						sequence_destroy(&temp2);
					} else {
						sequence_init(&copybuffer.pEntries[x].sq, &ss);
						if( bMerge )
							sequence_merge(&temp, &sequences[i], &orig_ss, &copybuffer.pEntries[x].sq, &ss, i, finish_ms - start_ms);
						else
							sequence_mix(&temp, &sequences[i], &orig_ss, &copybuffer.pEntries[x].sq, &ss, i, finish_ms - start_ms);
					}
					if( SetLightBrightness(hWnd, i, selection_start, finish, SETBRIGHTNESS_PASTE, &temp) )
						bRedrawRest = true;
					sequence_destroy(&temp);
				} else if( bStretch ) {
					sequence temp;
					memset(&temp, 0, sizeof(temp));
					sequence_stretch(&temp, &copybuffer.pEntries[x].sq, finish_ms - start_ms);
					if( SetLightBrightness(hWnd, i, selection_start, finish, SETBRIGHTNESS_PASTE, &temp) )
						bRedrawRest = true;
					sequence_destroy(&temp);
				} else if( copybuffer.ms > finish_ms - start_ms ) {
					sequence temp;
					memset(&temp, 0, sizeof(temp));
					sequence_state ss;
					sequence_init(&copybuffer.pEntries[x].sq, &ss);
					sequence_advance(&copybuffer.pEntries[x].sq, &ss, finish_ms - start_ms, true, false);
					sequence_append_translated_commands(&temp, &copybuffer.pEntries[x].sq, 0, ss.pos, i);
					if( ss.ms_remain ) {
						if( temp.used > 0 && IS_DELAY_CMD(copybuffer.pEntries[x].sq.commands[temp.used-1]) )
							--temp.used;
						int len = sequence_get_length_ms(&temp);
#ifdef _DEBUG
						assert( len <= finish_ms - start_ms );
#endif
						if( len < finish_ms - start_ms )
							sequence_append_delay(&temp, (finish_ms - start_ms) - len);
					}
					if( SetLightBrightness(hWnd, i, selection_start, finish, SETBRIGHTNESS_PASTE, &temp) )
						bRedrawRest = true;
					sequence_destroy(&temp);
				} else {
					if( SetLightBrightness(hWnd, i, selection_start, finish, SETBRIGHTNESS_PASTE, &copybuffer.pEntries[x].sq) )
						bRedrawRest = true;
				}
				++x;
			}
		}
		UndoEnd(hWnd);

		if( bRedrawRest ) {
			SCROLLINFO si;
			si.cbSize = sizeof (si);
			si.fMask  = SIF_ALL;
			GetScrollInfo (hWnd, SB_HORZ, &si);
			finish = (rcWAV.right - rcWAV.left + si.nPos) << zoom;
		}
		InvalidateLightRange(hWnd, start_ms * (long long)wav_sample_rate / 1000, finish, altered_lights);
	}
}

void PasteMerge(HWND hWnd) {
	return Paste(hWnd, true);
}

void PasteStretch(HWND hWnd) {
	return Paste(hWnd, false, false, true);
}

void PasteMergeStretch(HWND hWnd) {
	return Paste(hWnd, true, false, true);
}

void PasteMix(HWND hWnd) {
	return Paste(hWnd, false, true);
}

void PasteMixStretch(HWND hWnd) {
	return Paste(hWnd, false, true, true);
}

void SaveToCopyBufferStorage(HWND hWnd, int Index) {
	CopyCopyBuffer(&copybufferstorage[Index], &copybuffer);
}
void LoadFromCopyBufferStorage(HWND hWnd, int Index) {
	bool bCouldPaste = (copybuffer.NumEntries != 0);
	CopyCopyBuffer(&copybuffer, &copybufferstorage[Index]);
	if( bCouldPaste != (copybuffer.NumEntries != 0) )
		UpdatePasteSpecialMenu(hWnd, NULL);
}
void EmptyCopyBufferStorage(HWND hWnd, int Index) {
	FreeCopyBuffer(&copybufferstorage[Index]);
}

bool CopyBufferHasContents(const wchar_t** pReason) {
	if( pReason )
		*pReason = L"there is nothing in the copy buffer";
	return copybuffer.NumEntries != 0;
}

bool CanPaste(const wchar_t** pReason) {
	if( pReason )
		if( copybuffer.NumEntries == 0 )
			*pReason = L"there is nothing in the copy buffer";
		else
			*pReason = L"there is currently no selection";
	return copybuffer.NumEntries != 0 && selection_start != -1;
}

bool CanPasteStretch(const wchar_t** pReason) {
	if( pReason )
		if( copybuffer.NumEntries == 0 )
			*pReason = L"there is nothing in the copy buffer";
		else if( selection_start == -1 )
			*pReason = L"there is currently no selection";
		else
			*pReason = L"the selection is not wide enough";
	return copybuffer.NumEntries != 0 && selection_start != -1 && selection_finish != selection_start;
}

bool IsCopyBufferOccupied(int Index) {
	return copybufferstorage[Index].NumEntries != 0;
}
