
#define _CRT_SECURE_NO_WARNINGS
#include "targetver.h"
#include <stdio.h>
extern "C" {
	#include "../../Firmware/wav.h"
}
#include "WAVBrowse.h"

WAVHeader wav_header;

wav_data* wav_content;
wav_sample** wav_mipmap;
int wav_mipmap_levels;
int wav_bytes_per_sample;
int wav_len, wav_sample_rate, wav_num_channels;

#define min(a,b) ((a)<(b)?(a):(b))
#define max(a,b) ((a)>(b)?(a):(b))

void collapse1(wav_sample* dest, wav_data* src, int dest_len) {
	bool bFirst = true;
	while( dest_len ) {
		dest[0].left.min = min((src[0].left + 32768)>>8, (src[1].left + 32768)>>8);
		dest[0].left.max = max((src[0].left + 32768)>>8, (src[1].left + 32768)>>8);
		dest[0].right.min = min((src[0].right + 32768)>>8, (src[1].right + 32768)>>8);
		dest[0].right.max = max((src[0].right + 32768)>>8, (src[1].right + 32768)>>8);
		if( !bFirst ) {
			if( dest[0].left.min > dest[-1].left.max ) {
				int diff = dest[0].left.min - dest[-1].left.max;
				dest[0].left.min -= diff/2;
				dest[-1].left.max += diff-(diff/2);
			} else if( dest[0].left.max < dest[-1].left.min ) {
				int diff = dest[-1].left.min - dest[0].left.max;
				dest[-1].left.min -= diff/2;
				dest[0].left.max += diff-(diff/2);
			}
			if( dest[0].right.min > dest[-1].right.max ) {
				int diff = dest[0].right.min - dest[-1].right.max;
				dest[0].right.min -= diff/2;
				dest[-1].right.max += diff-(diff/2);
			} else if( dest[0].right.max < dest[-1].right.min ) {
				int diff = dest[-1].right.min - dest[0].right.max;
				dest[-1].right.min -= diff/2;
				dest[0].right.max += diff-(diff/2);
			}
		}
		dest += 1;
		src += 2;
		--dest_len;
		bFirst = false;
	}
}

void collapse2(wav_sample* dest, wav_sample* src, int dest_len) {
	bool bFirst = true;
	while( dest_len ) {
		dest[0].left.min = min(src[0].left.min, src[1].left.min);
		dest[0].left.max = max(src[0].left.max, src[1].left.max);
		dest[0].right.min = min(src[0].right.min, src[1].right.min);
		dest[0].right.max = max(src[0].right.max, src[1].right.max);
		if( !bFirst ) {
			if( dest[0].left.min > dest[-1].left.max ) {
				int diff = dest[0].left.min - dest[-1].left.max;
				dest[0].left.min -= diff/2;
				dest[-1].left.max += diff-(diff/2);
			} else if( dest[0].left.max < dest[-1].left.min ) {
				int diff = dest[-1].left.min - dest[0].left.max;
				dest[-1].left.min -= diff/2;
				dest[0].left.max += diff-(diff/2);
			}
			if( dest[0].right.min > dest[-1].right.max ) {
				int diff = dest[0].right.min - dest[-1].right.max;
				dest[0].right.min -= diff/2;
				dest[-1].right.max += diff-(diff/2);
			} else if( dest[0].right.max < dest[-1].right.min ) {
				int diff = dest[-1].right.min - dest[0].right.max;
				dest[-1].right.min -= diff/2;
				dest[0].right.max += diff-(diff/2);
			}
		}
		dest += 1;
		src += 2;
		--dest_len;
		bFirst = false;
	}
}

bool load_wav(const wchar_t* filename) {
	unsigned char buf[512];
	size_t buf_len;
	int temp;

	FILE* f = _wfopen(filename, L"rb");
	if( !f )
		return false;
	buf_len = fread(buf, 1, sizeof(buf), f);
	if( buf_len == -1 || !WAVreadWAVHeader(buf, &wav_header, buf_len) || wav_header.fmtHeader.audioFormat != 1 || wav_header.fmtHeader.numChannels < 1 || wav_header.fmtHeader.numChannels > 2 || wav_header.fmtHeader.bitsPerSample != 16 || fseek(f, (char*)wav_header.dataHeader.dataPtr - (char*)buf, SEEK_SET) == -1 ) {
		fclose(f);
		return false;
	}
	wav_bytes_per_sample = wav_header.fmtHeader.numChannels * 2;
	wav_len = wav_header.dataHeader.data.chunkSize / wav_bytes_per_sample;
	wav_sample_rate = wav_header.fmtHeader.sampleRate;
	wav_num_channels = wav_header.fmtHeader.numChannels;
	wav_mipmap_levels = 1;
	temp = wav_len;
	while( temp > 512 ) {
		temp >>= 1;
		++wav_mipmap_levels;
	}
	wav_content = new wav_data[wav_len];
	if( fread((short*)wav_content+(2-wav_num_channels), wav_bytes_per_sample, wav_len, f) != wav_len ) {
		delete wav_content;
		wav_content = 0;
		return false;
	}
	if( wav_num_channels == 1 ) {
		wav_data* pDest = wav_content + wav_len - 1;
		short* pSource = (short*)wav_content + wav_len;
		while( pDest >= wav_content ) {
			pDest->left = pDest->right = pSource[0];
			--pDest;
			--pSource;
		}
	}
	wav_mipmap = new wav_sample*[wav_mipmap_levels-1];
	temp = wav_len;
	for( int i = 1; i < wav_mipmap_levels; ++i ) {
		temp >>= 1;
		wav_mipmap[i-1] = new wav_sample[temp];
		if( i == 1 )
			collapse1(wav_mipmap[i-1], wav_content, temp);
		else
			collapse2(wav_mipmap[i-1], wav_mipmap[i-2], temp);
	}

	fclose(f);
	return true;
}

void close_wav() {
	for( int i = 1; i < wav_mipmap_levels; ++i ) {
		delete [] wav_mipmap[i-1];
	}
	wav_bytes_per_sample = 0;
	wav_len = 0;
	wav_sample_rate = 0;
	wav_num_channels = 0;
	wav_mipmap_levels = 0;
	delete [] wav_content;
	wav_content = 0;
	delete [] wav_mipmap;
	wav_mipmap = 0;
}
