
#include "targetver.h"
#include "ToolbarsMenus.h"
#include "Win32Utilities.h"
#include "WindowDrawing.h"
#include "Resource.h"
#include "LoadSave.h"
#include "WAVBrowse.h"
#include "Undo.h"
#include "Playback.h"
#include "CopyPaste.h"
#include "Dialogs.h"
#include <commctrl.h>
#ifdef _DEBUG
#include <assert.h>
#endif


HWND hToolbar, hTooltip;
int follow_playback_pos = 1, scroll_follows_playback = 0, loop_playback = 0;

bool AmPlaying();

ToolbarEntry toolbar_entries[] = { 
	{ L"New sequence (CTRL n)", IDM_NEWFILE, 'n', true, false },
	{ L"Open sequence (CTRL o)", IDM_OPENFILE, 'o', true, false },
	{ L"Save sequence (CTRL s)", IDM_SAVEFILE, 's', true, false, false, false, 0, &FileHasChanged },
	{ L"Save sequence as... (CTRL SHIFT s)", IDM_SAVEFILEAS, 'S', false, false, false, false, 0, &FileIsOpen },
	{ L"Save copy as...", IDM_SAVECOPYAS, 0, false, false, false, false, 0, &FileIsOpen },
	{ L"Revert sequence", IDM_REVERT, 0, false, false, false, false, 0, &FileHasChanged },
	{ L"Close sequence (CTRL w)", IDM_CLOSEFILE, 'w', true, false, false, false, 0, &FileIsOpen },
	{ L"Recent sequences" },
	{ L"Publish sequence", IDM_PUBLISH, 0, true, false, false, false, 0, &CanPublish },

	{ 0, 0 },

	{ L"Zoom in (CTRL +)", IDM_ZOOMIN, '+', true, false, false, false, VK_F3, &CanZoomIn },
	{ L"Zoom out (CTRL -)", IDM_ZOOMOUT, '-', true, false, false, false, VK_F4, &CanZoomOut },
	{ L"Zoom fit selection (CTRL SHIFT f)", IDM_ZOOMFITSELECTION, 'F', true, false, false, false, 0, &SelectionHasArea },
	{ L"Zoom fit all (CTRL 0)", IDM_ZOOMFITALL, '0', true, false, false, false, 0, &FileIsOpen },

	{ 0, 0 },

	{ L"Undo (CTRL z)", IDM_UNDO, 'z', true, false, false, false, 0, &CanUndo },
	{ L"Redo (CTRL y)", IDM_REDO, 'y', true, false, false, false, 0, &CanRedo },
	{ L"Cut (CTRL x)", IDM_CUT, 'x', true, false, false, false, 0, &SelectionHasAreaAndLights },
	{ L"Copy (CTRL c)", IDM_COPY, 'c', true, false, false, false, 0, &SelectionHasAreaAndLights },
	{ L"Paste (CTRL v)", IDM_PASTE, 'v', true, false, false, false, 0, &CanPaste },
	{ L"Paste Special" },
	{ L"Copy buffer storage" },
	{ L"Select all (CTRL a)", IDM_SELECTALL, 'a', true, false, false, false, 0, &FileIsOpen },
	{ L"Select none (CTRL SHIFT a)", IDM_SELECTNONE, 'A', true, false, false, false, 0, &FileIsOpen }, // also ESC
	{ L"Select view", IDM_SELECTVIEW, 0, false, false, false, false, 0, &FileIsOpen },
	{ L"Select playback region", IDM_SELECTPLAYBACKREGION, 0, false, false, false, false, 0, &HavePlaybackRegion },
	{ L"Select all lights", IDM_SELECTALLLIGHTS },
	{ L"Select no lights", IDM_SELECTNOLIGHTS },
	{ L"Selection storage" },
	{ L"Change Length", IDM_CHANGELENGTH, 0, false, false, false, false, 0, &IsStandaloneSequence },
	{ L"Settings", IDM_SETTINGS },

	{ 0, 0 },

	{ L"Play file (CTRL SHIFT e)", IDM_PLAYFILE, 'E', true, false, false, false, 0, &FileIsOpen },
	{ L"Play selection (CTRL e)", IDM_PLAYSELECTION, 'e', true, false, false, false, 0, &IsSelection },
	{ L"Play view", IDM_PLAYVIEW, 0, false, false, false, false, 0, &FileIsOpen },
	{ L"Set playback region", IDM_SETPLAYBACKREGION, 0, true, false, false, false, 0, &SelectionHasArea },
	{ L"Play region (CTRL p)", IDM_PLAYREGION, 'p', true, false, false, false, 0, &HavePlaybackRegion },
	{ L"Pause playback", IDM_PAUSE, 0, true, false, false, false, 0, &AmPlaying },
	{ L"Stop playback (CTRL SHIFT p)", IDM_STOP, 'P', true, false, false, false, 0, &AmPlaying },
	{ L"Loop playback? (CTRL l)", IDM_LOOPPLAYBACK, 'l', true, true, false },
	{ L"Follow playback position? (CTRL f)", IDM_FOLLOWPLAYBACKPOS, 'f', true, true, true },

	{ 0, 0 },

	{ L"Cancel light actions", IDM_CANCELLIGHTACTIONS, 0, false, false, false, false, 0, &IsSelectionAndLights },
	{ L"Light on (CTRL o)", IDM_LIGHTSON, 'o', true, false, false, false, 0, &IsSelectionAndLights },
	{ L"Light off (CTRL SHIFT o)", IDM_LIGHTSOFF, 'O', true, false, false, false, VK_DELETE, &IsSelectionAndLights },
	{ L"Set light brightness (CTRL b)", IDM_SETBRIGHT, 'b', true, false, false, true, 0, &IsSelectionAndLights },
	{ L"Interpolated ramp (CTRL i)", IDM_RAMPINTERPOLATE, 'i', true, false, false, false, 0, &SelectionHasAreaAndLights },
	{ L"Ramp up (CTRL r)", IDM_RAMPUP, 'r', true, false, false, false, 0, &SelectionHasAreaAndLights },
	{ L"Ramp down (CTRL SHIFT r)", IDM_RAMPDOWN, 'R', true, false, false, false, 0, &SelectionHasAreaAndLights },
	{ L"Custom ramp (CTRL SHIFT c)", IDM_CUSTOM_RAMP, 'C', true, false, false, true, 0, &SelectionHasAreaAndLights },
	{ L"Cascade (CTRL d)", IDM_CASCADE, 'd', true, false, false, true, 0, &SelectionHasAreaAndLights },

	{ 0, 0 },

	{ L"Beat detection", IDM_BEATDETECTION, 0, true, false, false, true, 0, &SelectionHasAreaAndLightsAndNotStandalone },
	{ L"Spectrum analysis", IDM_SPECTRUMANALYSIS, 0, true, false, false, true, 0, &IsSelectionAndLightsAndNotStandalone },
	{ L"Automatic sequencing", IDM_AUTOMATICSEQUENCING, 0, true, false, false, false, 0, &FileIsOpenAndNotStandalone }
};

ToolbarEntry extra_toolbar_entries[] = {
	{ L"Paste Merge", IDM_PASTE_MERGE, 'M', true, false, false, false, 0, &CanPaste },
	{ L"Paste Stretch", IDM_PASTE_STRETCH, 'V', true, false, false, false, 0, &CanPasteStretch },
	{ L"Paste Merge & Stretch", IDM_PASTE_MERGE_STRETCH, 0, true, false, false, false, 0, &CanPasteStretch },
	{ L"Paste Mix", IDM_PASTE_MIX, 'X', true, false, false, false, 0, &CanPaste },
	{ L"Paste Mix & Stretch", IDM_PASTE_MIX_STRETCH, 0, true, false, false, false, 0, &CanPasteStretch }
};

ToolbarEntry menu_entries[] = { 
	{ L"Exit (CTRL q)",  IDM_EXIT,  'q', false },
	{ L"About", IDM_ABOUT, 0, false }
};


HWND CreateToolbar(HWND hWnd, HINSTANCE hInst) {
	TBBUTTON tbrButtons[sizeof(toolbar_entries)/sizeof(*toolbar_entries)];

	int btnindex = 0;
	int index = 0;
	for( int i = 0; i < sizeof(tbrButtons)/sizeof(*tbrButtons); ++i ) {
		ToolbarEntry* pEntry = &toolbar_entries[i];
		if( pEntry->cmd || !pEntry->tooltip ) {
			if( !pEntry->tooltip || pEntry->bOnToolbar ) {
				bool bSep = !pEntry->tooltip;
				tbrButtons[index].iBitmap   = bSep ? 0 : pEntry->bCheck && !pEntry->bDefaultState ? btnindex+1 : btnindex;
				tbrButtons[index].idCommand = bSep ? 0 : pEntry->cmd;
				tbrButtons[index].fsState   = TBSTATE_ENABLED;
				tbrButtons[index].fsStyle   = bSep ? TBSTYLE_SEP : TBSTYLE_BUTTON;
				tbrButtons[index].dwData    = 0L;
				tbrButtons[index].iString   = 0;
				if( pEntry->bDropdown )
					tbrButtons[index].fsStyle |= TBSTYLE_DROPDOWN;
				++index;
			}
			if( pEntry->tooltip )
				btnindex += pEntry->bCheck ? 2 : 1;
		} else {
			++btnindex;
		}
	}

	HBITMAP bmp = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_TOOLBAR_BUTTONS));
	HWND tb = CreateToolbarEx(hWnd, WS_VISIBLE|WS_CHILD|WS_BORDER|TBSTYLE_TOOLTIPS, IDB_TOOLBAR_BUTTONS, btnindex, NULL, (UINT_PTR)bmp, tbrButtons, index, 16, 16, 16, 16, sizeof(TBBUTTON));
	SendMessage(tb, TB_SETEXTENDEDSTYLE, 0, (LPARAM)TBSTYLE_EX_DRAWDDARROWS);

	RECT rcTB;
	POINT ptBottom;
	GetWindowRect(tb, &rcTB);
	ptBottom.x = rcTB.right;
	ptBottom.y = rcTB.bottom;
	ScreenToClient(hWnd, &ptBottom);
	rcWAV.top = ptBottom.y;
	rcWAV.bottom = rcWAV.top + horiz_div_pos;
	rcWAV.right = ptBottom.x;
	rcSeq.top = rcWAV.bottom;
	rcSeq.right = ptBottom.x;

	hToolbar = tb;
	return tb;
}

void SetupMenus(HWND hWnd, HINSTANCE hInst) {
	MENUITEMINFO mii;
	HBITMAP bmp = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_TOOLBAR_BUTTONS));
	HMENU hMenu = GetMenu(hWnd);
	HMENU hSubMenu;

	int index = 0;
	mii.cbSize = sizeof(mii);
	while( (hSubMenu = GetSubMenu(hMenu, index++)) ) {
		for( int subindex = 0; ; ++subindex ) {
			mii.fMask = MIIM_ID|MIIM_STATE;
			if( !GetMenuItemInfo(hSubMenu, subindex, true, &mii) )
				break;
			int bitmap_index = 0;

			const ToolbarEntry* pEntry;
			int num_toolbar_entries = sizeof(toolbar_entries)/sizeof(*toolbar_entries);
			int num_menu_entries = sizeof(menu_entries)/sizeof(*menu_entries);
			for( int i = 0; i < num_toolbar_entries + num_menu_entries; ++i ) {
				pEntry = i < num_toolbar_entries ? &toolbar_entries[i] : &menu_entries[i - num_toolbar_entries];
				if( pEntry->cmd == mii.wID ) {
					if( pEntry->bCheck ) {
						mii.fMask = MIIM_CHECKMARKS|MIIM_STATE;
						if( pEntry->bDefaultState )
							mii.fState |= MFS_CHECKED;
						mii.hbmpChecked = CropBitmap(bmp, bitmap_index*16, 0, 16, 16);
						mii.hbmpUnchecked = CropBitmap(bmp, (bitmap_index+1)*16, 0, 16, 16);
					} else {
						mii.fMask = MIIM_BITMAP;
						mii.hbmpItem = CropBitmap(bmp, bitmap_index*16, 0, 16, 16);
					}
					SetMenuItemInfo(hSubMenu, subindex, true, &mii);
					break;
				}
				if( pEntry->tooltip )
					bitmap_index += pEntry->bCheck ? 2 : 1;
			}
		}
	}

	DeleteObject(bmp);
}

void SetCheckedMenuItem(HWND hWnd, int MenuItemID, bool bChecked) {
	MENUITEMINFO mii;
	HMENU hMenu = GetMenu(hWnd);
	HMENU hSubMenu;

	mii.cbSize = sizeof(mii);

	for( int i = 0; ; ++i ) {
		hSubMenu = GetSubMenu(hMenu, i);
		if( !hSubMenu )
			return;

		mii.fMask = MIIM_STATE;
		if( GetMenuItemInfo(hSubMenu, MenuItemID, false, &mii) )
			break;
	}
	if( bChecked )
		mii.fState |= MFS_CHECKED;
	else
		mii.fState &= ~MFS_CHECKED;
	mii.fMask = MIIM_STATE;
	SetMenuItemInfo(hSubMenu, MenuItemID, false, &mii);

	int num_toolbar_entries = sizeof(toolbar_entries)/sizeof(*toolbar_entries);
	int bitmap_index = 0;
	for( int i = 0; i < num_toolbar_entries; ++i ) {
		if( toolbar_entries[i].cmd == MenuItemID ) {
			break;
		}
		if( toolbar_entries[i].tooltip )
			bitmap_index += toolbar_entries[i].bCheck ? 2 : 1;
	}
	SendMessage(hToolbar, TB_CHANGEBITMAP, MenuItemID, bChecked ? bitmap_index : bitmap_index+1);
}

void SetMenuItemDisabled(HWND hWnd, int MenuItemID, bool bDisabled) {
	MENUITEMINFO mii;
	HMENU hMenu = GetMenu(hWnd);
	HMENU hSubMenu;

	mii.cbSize = sizeof(mii);

	for( int i = 0; ; ++i ) {
		hSubMenu = GetSubMenu(hMenu, i);
		if( !hSubMenu )
			return;

		mii.fMask = MIIM_STATE;
		if( GetMenuItemInfo(hSubMenu, MenuItemID, false, &mii) )
			break;
	}
	if( bDisabled )
		mii.fState |= MFS_DISABLED;
	else
		mii.fState &= ~MFS_DISABLED;
	mii.fMask = MIIM_STATE;
	SetMenuItemInfo(hSubMenu, MenuItemID, false, &mii);

	int num_toolbar_entries = sizeof(toolbar_entries)/sizeof(*toolbar_entries);
	int bitmap_index = 0;
	for( int i = 0; i < num_toolbar_entries; ++i ) {
		if( toolbar_entries[i].cmd == MenuItemID ) {
			break;
		}
		if( toolbar_entries[i].tooltip )
			bitmap_index += toolbar_entries[i].bCheck ? 2 : 1;
	}
	int old_state = SendMessage(hToolbar, TB_GETSTATE, MenuItemID, 0);
	int new_state;
	if( bDisabled )
		new_state = old_state & ~TBSTATE_ENABLED;
	else
		new_state = old_state |  TBSTATE_ENABLED;
	if( new_state != old_state )
		SendMessage(hToolbar, TB_SETSTATE, MenuItemID, new_state);
}

ToolbarEntry* FindToolbarEntry(DWORD cmd, bool bIncludeMenus) {
	for( int i = 0; i < sizeof(toolbar_entries)/sizeof(*toolbar_entries); ++i ) {
		if( toolbar_entries[i].cmd == cmd )
			return &toolbar_entries[i];
	}
	if( bIncludeMenus ) {
		for( int i = 0; i < sizeof(menu_entries)/sizeof(*menu_entries); ++i ) {
			if( menu_entries[i].cmd == cmd )
				return &menu_entries[i];
		}
	}
	return (ToolbarEntry*)NULL;
}
ToolbarEntry* FindToolbarEntry(char shortcut, bool bIncludeMenus) {
	for( int i = 0; i < sizeof(toolbar_entries)/sizeof(*toolbar_entries); ++i ) {
		if( toolbar_entries[i].shortcut == shortcut )
			return &toolbar_entries[i];
	}
	for( int i = 0; i < sizeof(extra_toolbar_entries)/sizeof(*extra_toolbar_entries); ++i ) {
		if( extra_toolbar_entries[i].shortcut == shortcut )
			return &extra_toolbar_entries[i];
	}
	if( bIncludeMenus ) {
		for( int i = 0; i < sizeof(menu_entries)/sizeof(*menu_entries); ++i ) {
			if( menu_entries[i].shortcut == shortcut )
				return &menu_entries[i];
		}
	}
	return (ToolbarEntry*)NULL;
}
ToolbarEntry* FindToolbarEntryByVKey(int VKey, bool bIncludeMenus) {
	for( int i = 0; i < sizeof(toolbar_entries)/sizeof(*toolbar_entries); ++i ) {
		if( toolbar_entries[i].alt_vkey_shortcut == VKey )
			return &toolbar_entries[i];
	}
	if( bIncludeMenus ) {
		for( int i = 0; i < sizeof(menu_entries)/sizeof(*menu_entries); ++i ) {
			if( menu_entries[i].alt_vkey_shortcut == VKey )
				return &menu_entries[i];
		}
	}
	return (ToolbarEntry*)NULL;
}

static HWND InitLightBarTooltips(HWND hWnd, HINSTANCE hInst) {
	HWND hwndTip = CreateWindowEx(NULL, TOOLTIPS_CLASS, NULL,
		                          WS_POPUP | TTS_NOPREFIX | TTS_ALWAYSTIP,
			                      CW_USEDEFAULT, CW_USEDEFAULT,
				                  CW_USEDEFAULT, CW_USEDEFAULT,
					              hWnd, NULL, hInst,
						          NULL);

	SetWindowPos(hwndTip, HWND_TOPMOST, 0, 0, 0, 0,
				 SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);

	return hwndTip;
}
void UpdateLightBarTooltips(HWND hWnd, HINSTANCE hInst, wchar_t light_names[32][256]) {
	TOOLINFO ti;
	memset(&ti, 0, sizeof(ti));
	ti.cbSize = sizeof(ti) - sizeof(void*); // work around problem with comctl32.dll
	ti.uFlags = TTF_CENTERTIP|TTF_SUBCLASS;
	ti.hwnd = hWnd;
	ti.hinst = hInst;

	bool bInitTooltips = !hTooltip;
	if( bInitTooltips )
		hTooltip = InitLightBarTooltips(hWnd, hInst);

	int dim = rcLightBar.bottom - rcLightBar.top - 6;
	int x = 8;
	for( int i = 0; i < 32; ++i ) {
		int y = rcLightBar.top + 2;

		ti.uId = i+1;
		ti.rect.left = x;
		ti.rect.top = y;
		ti.rect.right = x + dim;
		ti.rect.bottom = y + dim;
		ti.lpszText = light_names[i];
		if( bInitTooltips ) {
			SendMessage(hTooltip, TTM_NEWTOOLRECT, 0, (LPARAM)&ti);
			SendMessage(hTooltip, TTM_UPDATETIPTEXT, 0, (LPARAM)&ti);
		} else {
			SendMessage(hTooltip, TTM_DELTOOL, 0, (LPARAM)&ti);
			SendMessage(hTooltip, TTM_ADDTOOL, 0, (LPARAM)&ti);
		}

		x += dim + 8;
	}
	SendMessage(hTooltip, TTM_ACTIVATE, (WPARAM)TRUE, (LPARAM)0);
	bInitTooltips = true;
}

struct CheckEnabledCache {
	IsEnabled* pFunc;
	bool bResult;
};

void UpdateDisabledState(HWND hWnd) {
	CheckEnabledCache* pCache = 0;
	int cache_size = 0;

	for( int i = 0; i < sizeof(toolbar_entries)/sizeof(*toolbar_entries); ++i ) {
		ToolbarEntry* pEntry = &toolbar_entries[i];
		if( pEntry->CheckEnabled ) {
			bool bFound = false, bResult;
			for( int j = 0; j < cache_size; ++j ) {
				if( pCache[j].pFunc == pEntry->CheckEnabled ) {
					bFound = true;
					bResult = pCache[j].bResult;
					break;
				}
			}
			if( !bFound ) {
				bResult = pEntry->CheckEnabled((const wchar_t**)NULL);
				pCache = (CheckEnabledCache*)realloc(pCache, ++cache_size * sizeof(*pCache));
				pCache[cache_size-1].pFunc = pEntry->CheckEnabled;
				pCache[cache_size-1].bResult = bResult;
			}
			SetMenuItemDisabled(hWnd, pEntry->cmd, !bResult);
		}
	}

	free(pCache);
}

HBITMAP g_open_bmp;
void UpdateRecentFilesMenu(HWND hWnd, HINSTANCE hInst) {
	MENUITEMINFO mii;
	HMENU hMenu = GetMenu(hWnd);
	HMENU hSubMenu = GetSubMenu(hMenu, 0);
	HMENU hRecentFilesMenu;
	mii.cbSize = sizeof(mii);

	int i;
	for( i = 0; i < 100; ++i ) {
		hRecentFilesMenu = GetSubMenu(hSubMenu, i);
		if( hRecentFilesMenu )
			break;
	}

	if( !hRecentFilesMenu ) {
#ifdef _DEBUG
		assert(0);
#endif
		return;
	}

	if( hInst ) {
		HBITMAP bmp = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_TOOLBAR_BUTTONS));
		int bitmap_index = 0;
		while( !(toolbar_entries[bitmap_index].tooltip && !toolbar_entries[bitmap_index].cmd) ) {
			if( toolbar_entries[bitmap_index].cmd == IDM_OPENFILE )
				g_open_bmp = CropBitmap(bmp, bitmap_index*16, 0, 16, 16);
			++bitmap_index;
		}
		mii.fMask = MIIM_BITMAP;
		mii.hbmpItem = CropBitmap(bmp, bitmap_index*16, 0, 16, 16);
		SetMenuItemInfo(hSubMenu, i, true, &mii);
		DeleteObject(bmp);
	}

	HKEY RecentFiles;
	DWORD ret, Type;
	int index = 0;
	if( RegOpenKeyEx(HKEY_CURRENT_USER, L"Software\\Silicon Chip\\Digital Lighting Controller\\Recent Files", 0, KEY_QUERY_VALUE, &RecentFiles) == ERROR_SUCCESS ) {
		i = 0;
		for( int id = 10000; id < 10010; ++id ) {
			wchar_t buf[32];
			wchar_t filename[_MAX_PATH];
			DWORD size = sizeof(filename);
			wsprintf(buf, L"%d", i);
			Type = REG_SZ;
			ret = RegQueryValueEx(RecentFiles, buf, NULL, &Type, (LPBYTE)filename, &size);
			if( ret == ERROR_SUCCESS && Type == REG_SZ ) {
				wchar_t oldfilename[_MAX_PATH];
				mii.fMask = MIIM_ID|MIIM_STRING;
				mii.cch = sizeof(oldfilename);
				mii.dwTypeData = oldfilename;
				if( GetMenuItemInfo(hRecentFilesMenu, i, true, &mii) ) {
					if( _wcsicmp(filename, oldfilename) || mii.wID != id ) {
						mii.wID = id;
						mii.dwTypeData = filename;
						SetMenuItemInfo(hRecentFilesMenu, i, true, &mii);
						if( id == 10000 && hInst ) {
							mii.fMask = MIIM_BITMAP;
							mii.hbmpItem = g_open_bmp;
							SetMenuItemInfo(hRecentFilesMenu, i, true, &mii);
						}
					}
				} else {
					AppendMenu(hRecentFilesMenu, MF_STRING, id, filename);
					mii.fMask = MIIM_BITMAP;
					mii.hbmpItem = g_open_bmp;
					SetMenuItemInfo(hRecentFilesMenu, i, true, &mii);
				}
				++i;
			} else {
				DeleteMenu(hRecentFilesMenu, i, MF_BYPOSITION);
			}
		}
	}
//	DeleteObject(open_bmp);
}

selection selection_storage[9];

HBITMAP g_emptyselectionstorage_bmp;
HBITMAP g_fullselectionstorage_bmp;
static void SetMenuItemDisabled(HMENU hMenu, int index, bool bDisabled) {
	MENUITEMINFO mii;

	mii.cbSize = sizeof(mii);
	mii.fMask = MIIM_STATE;
	if( GetMenuItemInfo(hMenu, index, true, &mii) ) {
		if( bDisabled )
			mii.fState |= MFS_DISABLED;
		else
			mii.fState &= ~MFS_DISABLED;
		SetMenuItemInfo(hMenu, index, true, &mii);
	}
}

void UpdateSelectionStorageMenu(HWND hWnd, HINSTANCE hInst) {
	MENUITEMINFO mii;
	HMENU hMenu = GetMenu(hWnd);
	HMENU hSubMenu = GetSubMenu(hMenu, 2);
	HMENU hSelectionStorageMenu;
	mii.cbSize = sizeof(mii);

	int i;
	int skip = 2;
	for( i = 0; i < 100; ++i ) {
		hSelectionStorageMenu = GetSubMenu(hSubMenu, i);
		if( hSelectionStorageMenu && skip-- == 0 )
			break;
	}

	if( !hSelectionStorageMenu ) {
#ifdef _DEBUG
		assert(0);
#endif
		return;
	}

	if( hInst ) {
		HBITMAP bmp = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_TOOLBAR_BUTTONS));
		int bitmap_index = 0;
		int j = 0;
		int skip = 3;
		while( !(toolbar_entries[j].tooltip && !toolbar_entries[j].cmd) || skip-- ) {
			if( toolbar_entries[j++].tooltip )
				++bitmap_index;
		}
		g_fullselectionstorage_bmp = CropBitmap(bmp, bitmap_index*16, 0, 16, 16);
		mii.fMask = MIIM_BITMAP;
		mii.hbmpItem = g_fullselectionstorage_bmp;
		SetMenuItemInfo(hSubMenu, i, true, &mii);

		while( j < sizeof(toolbar_entries)/sizeof(*toolbar_entries) ) {
			if( toolbar_entries[j].tooltip )
				bitmap_index += toolbar_entries[j].bCheck ? 2 : 1;
			++j;
		}
		for( j = 0; j < sizeof(menu_entries)/sizeof(*menu_entries); ++j ) {
			if( menu_entries[j].tooltip )
				bitmap_index += menu_entries[j].bCheck ? 2 : 1;
		}
		g_emptyselectionstorage_bmp = CropBitmap(bmp, bitmap_index*16, 0, 16, 16);;
		DeleteObject(bmp);
	}

	for( i = 0; i < 9; ++i ) {
		if( hInst ) // initialise
			selection_storage[i].start = selection_storage[i].finish = -1;

		HMENU hSelectionStorage = GetSubMenu(hSelectionStorageMenu, i);
		mii.fMask = MIIM_BITMAP;
		mii.hbmpItem = selection_storage[i].start == -1 ? g_emptyselectionstorage_bmp : g_fullselectionstorage_bmp;
		SetMenuItemInfo(hSelectionStorageMenu, i, true, &mii);

		SetMenuItemDisabled(hSelectionStorage, 0, selection_start == -1);
		SetMenuItemDisabled(hSelectionStorage, 1, selection_storage[i].start == -1);
		SetMenuItemDisabled(hSelectionStorage, 2, selection_storage[i].start == -1);
	}
}

HBITMAP g_emptycopybufferstorage_bmp;
HBITMAP g_fullcopybufferstorage_bmp;
void UpdateCopyBufferStorageMenu(HWND hWnd, HINSTANCE hInst) {
	MENUITEMINFO mii;
	HMENU hMenu = GetMenu(hWnd);
	HMENU hSubMenu = GetSubMenu(hMenu, 2);
	HMENU hCopyBufferStorageMenu;
	mii.cbSize = sizeof(mii);

	int i;
	int skip = 1;
	for( i = 0; i < 100; ++i ) {
		hCopyBufferStorageMenu = GetSubMenu(hSubMenu, i);
		if( hCopyBufferStorageMenu && skip-- == 0 )
			break;
	}

	if( !hCopyBufferStorageMenu ) {
#ifdef _DEBUG
		assert(0);
#endif
		return;
	}

	if( hInst ) {
		HBITMAP bmp = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_TOOLBAR_BUTTONS));
		int bitmap_index = 0;
		int j = 0;
		int skip = 2;
		while( !(toolbar_entries[j].tooltip && !toolbar_entries[j].cmd) || skip-- ) {
			if( toolbar_entries[j++].tooltip )
				++bitmap_index;
		}
		g_fullcopybufferstorage_bmp = CropBitmap(bmp, bitmap_index*16, 0, 16, 16);
		mii.fMask = MIIM_BITMAP;
		mii.hbmpItem = g_fullcopybufferstorage_bmp;
		SetMenuItemInfo(hSubMenu, i, true, &mii);

		while( j < sizeof(toolbar_entries)/sizeof(*toolbar_entries) ) {
			if( toolbar_entries[j].tooltip )
				bitmap_index += toolbar_entries[j].bCheck ? 2 : 1;
			++j;
		}
		for( j = 0; j < sizeof(menu_entries)/sizeof(*menu_entries); ++j ) {
			if( menu_entries[j].tooltip )
				bitmap_index += menu_entries[j].bCheck ? 2 : 1;
		}
		g_emptycopybufferstorage_bmp = CropBitmap(bmp, bitmap_index*16, 0, 16, 16);;
		DeleteObject(bmp);
	}

	bool bCopyBufferEmpty = !CopyBufferHasContents(NULL);
	for( i = 0; i < 9; ++i ) {
		bool bOccupied = IsCopyBufferOccupied(i);
		HMENU hCopyBufferStorage = GetSubMenu(hCopyBufferStorageMenu, i);
		mii.fMask = MIIM_BITMAP;
		mii.hbmpItem = bOccupied ? g_fullcopybufferstorage_bmp : g_emptycopybufferstorage_bmp;
		SetMenuItemInfo(hCopyBufferStorageMenu, i, true, &mii);

		SetMenuItemDisabled(hCopyBufferStorage, 0, bCopyBufferEmpty);
		SetMenuItemDisabled(hCopyBufferStorage, 1, !bOccupied);
		SetMenuItemDisabled(hCopyBufferStorage, 2, !bOccupied);
	}
}

void UpdatePasteSpecialMenu(HWND hWnd, HINSTANCE hInst) {
	MENUITEMINFO mii;
	HMENU hMenu = GetMenu(hWnd);
	HMENU hSubMenu = GetSubMenu(hMenu, 2);
	HMENU hPasteSpecialMenu;
	mii.cbSize = sizeof(mii);

	bool bCanPaste = CanPaste(NULL);
	bool bCanPasteStretch = CanPasteStretch(NULL);

	int i;
	int skip = 0;
	for( i = 0; i < 100; ++i ) {
		hPasteSpecialMenu = GetSubMenu(hSubMenu, i);
		if( hPasteSpecialMenu && skip-- == 0 )
			break;
	}

	if( !hPasteSpecialMenu ) {
#ifdef _DEBUG
		assert(0);
#endif
		return;
	}

	if( hInst ) {
		HBITMAP bmp = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_TOOLBAR_BUTTONS));
		int bitmap_index = 0;
		int j = 0;
		int skip = 1;
		while( !(toolbar_entries[j].tooltip && !toolbar_entries[j].cmd) || skip-- ) {
			if( toolbar_entries[j++].tooltip )
				++bitmap_index;
		}
		mii.fMask = MIIM_BITMAP;
		mii.hbmpItem = CropBitmap(bmp, bitmap_index*16, 0, 16, 16);
		SetMenuItemInfo(hSubMenu, i, true, &mii);

		for( ; j < sizeof(toolbar_entries)/sizeof(*toolbar_entries); ++j ) {
			if( toolbar_entries[j].tooltip )
				bitmap_index += toolbar_entries[j].bCheck ? 2 : 1;
		}
		for( j = 0; j < sizeof(menu_entries)/sizeof(*menu_entries); ++j ) {
			if( menu_entries[j].tooltip )
				bitmap_index += menu_entries[j].bCheck ? 2 : 1;
		}
		bitmap_index += 1;
		for( int j = 0; j < 5; ++j ) {
			mii.fMask = MIIM_BITMAP;
			mii.hbmpItem = CropBitmap(bmp, bitmap_index*16, 0, 16, 16);
			SetMenuItemInfo(hPasteSpecialMenu, j, true, &mii);
			++bitmap_index;
		}
		DeleteObject(bmp);
	}

	EnableMenuItem(hSubMenu, i, MF_BYPOSITION|(bCanPaste ? MF_ENABLED : MF_DISABLED));
	for( int j = 0; j < 5; ++j )
		EnableMenuItem(hPasteSpecialMenu, j, MF_BYPOSITION|((j == 0 || j == 3 ? bCanPaste : bCanPasteStretch) ? MF_ENABLED : MF_DISABLED));
}

void ToggleFollowPlaybackPos(HWND hWnd) {
	follow_playback_pos = !follow_playback_pos;
	SetCheckedMenuItem(hWnd, IDM_FOLLOWPLAYBACKPOS, follow_playback_pos != 0);
	if( !follow_playback_pos )
		scroll_follows_playback = 0;
	SetRegistryDialogDword(L"Settings", IDC_SCROLL_TO_FOLLOW_PLAYBACK_CURSOR, follow_playback_pos ? 1 : 0);
}

void ToggleLoopPlayback(HWND hWnd) {
	loop_playback = !loop_playback;
	set_loop_playback(loop_playback != 0);
	SetCheckedMenuItem(hWnd, IDM_LOOPPLAYBACK, loop_playback != 0);
	SetRegistryDialogDword(L"Settings", IDC_LOOP_PLAYBACK, loop_playback ? 1 : 0);
}

void SetFollowPlaybackPos(HWND hWnd, bool bFollow) {
	if( (follow_playback_pos != 0) != bFollow )
		ToggleFollowPlaybackPos(hWnd);
}

void SetLoopPlayback(HWND hWnd, bool bLoop) {
	if( (loop_playback != 0) != bLoop )
		ToggleLoopPlayback(hWnd);
}

void UpdatePublishEnabledStatus(HWND hWnd) {
	SetMenuItemDisabled(hWnd, IDM_PUBLISH, !CanPublish(NULL));
}
