
#include <Windows.h>

extern int horiz_div_pos, zoom;
extern int playback_pos, select_pos, selection_start, selection_finish, playback_region_start, playback_region_finish;
extern unsigned long selected_lights, current_light;
extern double lfGamma, lfInvGamma;
extern RECT rcWAV, rcSeq, rcLightBar;
extern DWORD EnabledLights, NumEnabledLights;
//extern HFONT hFont, hSmallFont;

void InvalidateLightSpan(HWND hWnd, unsigned long lights, int left, int right);
void InvalidateSelectionRange(HWND hWnd, int start, int finish, unsigned long lights);
void InvalidateLightRange(HWND hWnd, int start, int finish, unsigned long lights);
void InvalidateSelectionDiff(HWND hWnd, int start, int finish, int old_start, int old_finish, unsigned long lights);
void InvalidateLightBar(HWND hWnd);
void InvalidateLightBarLights(HWND hWnd, int sample_pos);
void InvalidateStatus(HWND hWnd);

void MovePlaybackPos(HWND hWnd, int pos);
void SetSelection(HWND hWnd, int start, int finish);
void ClearSelections(HWND hWnd);
void MoveSelection(HWND hWnd, int amount);
void MoveLightSelection(HWND hWnd, int dir, bool bOr);
void SetLightSelection(HWND hWnd, unsigned long selection, unsigned long new_current_light);
void SetPlaybackRegion(HWND hWnd, int start, int finish);
void SetScrollExtent(HWND hWnd, int old_zoom, int mousex, bool bUpdateSelectPos = true);
void HorizScrollWindowBy(HWND hWnd, int scroll, bool bUpdateSelectPos = false);

void InitLightbar();
void DrawWAV(HWND hWnd, HDC hdc);
void DrawLightbar(HWND hWnd, HDC hdc, COLORREF* light_colours);
void DrawSequences(HWND hWnd, HDC hdc, wchar_t light_names[32][256], COLORREF* light_colours, bool bUseGradients);
void DrawStatus(HWND hWnd, HDC hdc);

void DelayedUpdateDisabledState(HWND hWnd);
bool CanZoomIn(const wchar_t** pReason);
bool CanZoomOut(const wchar_t** pReason);
bool IsSelection(const wchar_t** pReason);
bool IsSelectionAndLights(const wchar_t** pReason);
bool IsSelectionAndLightsAndNotStandalone(const wchar_t** pReason);
bool SelectionHasArea(const wchar_t** pReason);
bool SelectionHasAreaAndLights(const wchar_t** pReason);
bool SelectionHasAreaAndLightsAndNotStandalone(const wchar_t** pReason);
bool HavePlaybackRegion(const wchar_t** pReason);

void MainSequenceChanged(HWND hWnd, int which, int start, int finish);
void MainSequencesChanged(HWND hWnd, int start, int finish);
