
#define _CRT_SECURE_NO_WARNINGS
#include "targetver.h"
#include "LoadSave.h"
#include "Sequence.h"
#include "WAVBrowse.h"
#include "Playback.h"
#include "WindowDrawing.h"
#include "Undo.h"
#include "ToolbarsMenus.h"
#include "Dialogs.h"
#include "EjectDrive.h"
#include <stdio.h>
#include <Windows.h>
#ifdef _DEBUG
#include <assert.h>
#endif


wchar_t sequence_file_name[_MAX_PATH];
int sequence_loaded;
bool g_bBackupSequenceFiles, g_bEjectAfterPublish;

extern HWND hDialog;
bool PreCloseSequence(HWND hWnd) {
	if( UndoIsDirty() ) {
		int ret = MessageBox(hWnd, L"You have made changes to the current sequence. Do you want to save if before closing?", L"Close confirmation prompt", MB_YESNOCANCEL|MB_DEFBUTTON1|MB_ICONEXCLAMATION);
		if( ret == IDYES ) {
			if( !sequence_save(sequence_file_name, g_bBackupSequenceFiles) ) {
				MessageBox(hWnd, L"Saving the sequence file failed. Please check that you have permission to write files into that folder and that you are not out of disk space. It will remain open.", L"Sequence file save error", MB_OK|MB_ICONEXCLAMATION);
				return false;
			}
			UndoReset(hWnd);
		} else if( ret == IDCANCEL ) {
			return false;
		}
	}

	if( hDialog ) {
		wchar_t buf[256];
		GetWindowText(hDialog, buf, sizeof(buf)/sizeof(wchar_t));
		if( wcscmp(buf, L"Settings") ) {
			DestroyWindow(hDialog);
			hDialog = (HWND)NULL;
		}
	}

	return true;
}

void CloseSequence(HWND hWnd) {
	if( !PreCloseSequence(hWnd) )
		return;
	RECT rcClient;
	stop_playback();
	close_wav();
	sequence_close();
	sequence_loaded = 0;
	DelayedUpdateDisabledState(hWnd);
	UpdateWindowTitle(hWnd);
	SetScrollExtent(hWnd, zoom, -1);
	GetClientRect(hWnd, &rcClient);
	InvalidateRect(hWnd, &rcClient, true);
	UndoReset(hWnd);
	ClearSelections(hWnd);
}

static void UpdateRecentFiles(HWND hWnd) {
	HKEY RecentFiles;
	DWORD ret, Disposition, Type;
	if( RegCreateKeyEx(HKEY_CURRENT_USER, L"Software\\Silicon Chip\\Digital Lighting Controller\\Recent Files", 0, NULL, REG_OPTION_NON_VOLATILE, KEY_QUERY_VALUE|KEY_SET_VALUE, NULL, &RecentFiles, &Disposition) == ERROR_SUCCESS ) {
		for( int i = 0; i < 10; ++i ) {
			wchar_t buf[32];
			wchar_t filename[_MAX_PATH];
			DWORD size = sizeof(filename);
			wsprintf(buf, L"%d", i);
			Type = REG_SZ;
			ret = RegQueryValueEx(RecentFiles, buf, NULL, &Type, (LPBYTE)filename, &size);
			if( ret == ERROR_SUCCESS && Type == REG_SZ ) {
				if( !_wcsicmp(filename, sequence_file_name) ) {
					if( i != 0 ) {
						for( int j = i; j > 0; --j ) {
							wchar_t buf[32];
							wchar_t filename[_MAX_PATH];
							DWORD size = sizeof(filename);
							wsprintf(buf, L"%d", j-1);
							Type = REG_SZ;
							ret = RegQueryValueEx(RecentFiles, buf, NULL, &Type, (LPBYTE)filename, &size);
							if( ret == ERROR_SUCCESS && Type == REG_SZ ) {
								wsprintf(buf, L"%d", j);
								RegSetValueEx(RecentFiles, buf, NULL, Type, (LPBYTE)filename, size);
							}
						}
						RegSetValueEx(RecentFiles, L"0", NULL, REG_SZ, (LPBYTE)sequence_file_name, (wcslen(sequence_file_name)+1)*sizeof(wchar_t));
					}
					return;
				}
			}
		}
		for( int i = 8; i >= 0; --i ) {
			wchar_t buf[32];
			wchar_t filename[_MAX_PATH];
			DWORD size = sizeof(filename);
			wsprintf(buf, L"%d", i);
			Type = REG_SZ;
			ret = RegQueryValueEx(RecentFiles, buf, NULL, &Type, (LPBYTE)filename, &size);
			if( ret == ERROR_SUCCESS && Type == REG_SZ ) {
				wsprintf(buf, L"%d", i+1);
				RegSetValueEx(RecentFiles, buf, NULL, Type, (LPBYTE)filename, size);
			}
		}
		RegSetValueEx(RecentFiles, L"0", NULL, REG_SZ, (LPBYTE)sequence_file_name, (wcslen(sequence_file_name)+1)*sizeof(wchar_t));
	}
}

bool OpenRecentFile(HWND hWnd, int id) {
	MENUITEMINFO mii;
	HMENU hMenu = GetMenu(hWnd);
	HMENU hSubMenu = GetSubMenu(hMenu, 0);
	HMENU hRecentFilesMenu;
	mii.cbSize = sizeof(mii);

	for( int i = 0; i < 100; ++i ) {
		hRecentFilesMenu = GetSubMenu(hSubMenu, i);
		if( hRecentFilesMenu )
			break;
	}

	if( !hRecentFilesMenu ) {
#ifdef _DEBUG
		assert(0);
#endif
		return false;
	}

	wchar_t filename[_MAX_PATH];
	mii.fMask = MIIM_STRING;
	mii.cch = sizeof(filename);
	mii.dwTypeData = filename;
	if( GetMenuItemInfo(hRecentFilesMenu, id, false, &mii) ) {
		return DoOpenSequence(hWnd, filename, false, -1);
	} else {
		return false;
	}
}

extern bool g_bLoading;
void NewSequence(HWND hWnd) {
	int ms = (wav_len + ((wav_sample_rate+999) / 1000 - 1)) * 1000LL / wav_sample_rate;
	g_bLoading = true;
	for( int i = 0; i < 32; ++i )
		sequence_append_delay(&sequences[i], ms);
	sequence_loaded = 1;
	g_bLoading = false;
	DelayedUpdateDisabledState(hWnd);
}

void CreateStandaloneSequence(int length_ms) {
	wav_content = NULL;
	wav_sample_rate = 12000;
	wav_bytes_per_sample = 4;
	wav_num_channels = 2;
	wav_len = length_ms * 12;
	sequence_loaded = 1;
}

bool DoOpenSequence(HWND hWnd, const wchar_t* filename, bool bNew, int length_ms) {
	wchar_t alt_filename[_MAX_PATH];

	if( bNew ) {
		const wchar_t* dot = wcsrchr(filename, L'.');
		const wchar_t* slash = wcsrchr(filename, L'\\');
		if( !dot || dot < slash )
			dot = filename + wcslen(filename);
		wcsncpy(alt_filename, filename, dot - filename);
		wcscpy(alt_filename + (dot - filename), length_ms == -1 ? L".lsq" : L".lsn");

		FILE* f = _wfopen(alt_filename, L"rb");
		if( f ) {
			int ret = MessageBox(hWnd, L"Warning: the sequence file you are about to create already exists. Do you want to overwrite it?", L"New sequence file overwrite warning", MB_YESNO|MB_DEFBUTTON2|MB_ICONEXCLAMATION);
			fclose(f);
			if( ret == IDNO )
				return false;
		}
	}

	CloseSequence(hWnd);
	if( sequence_loaded )
		return 0;

	if( !bNew ) {
		const wchar_t* dot = wcsrchr(filename, L'.');
		const wchar_t* slash = wcsrchr(filename, L'\\');
		if( !dot || dot < slash )
			dot = filename + wcslen(filename);
		wcsncpy(alt_filename, filename, dot - filename);
		wcscpy(alt_filename + (dot - filename), L".wav");
	}
	bool bIsLsn = false;
	if( !bNew ) {
		const wchar_t* wcsExtension = wcsrchr(filename, L'.');
		if( wcsExtension && !_wcsicmp(wcsExtension, L".lsn") )
			bIsLsn = true;
	}
	if( !(bNew && length_ms != -1) && !bIsLsn && !load_wav(bNew ? filename : alt_filename) ) {
		RECT rcClient;
		close_wav();
		SetScrollExtent(hWnd, zoom, -1);
		GetClientRect(hWnd, &rcClient);
		InvalidateRect(hWnd, &rcClient, true);
		if( bNew )
			MessageBox(hWnd, L"Reading the select WAV file failed. Check that it is a 16 bit PCM format (mono or stereo) with a supported sample rate.", L"WAV file open error", MB_OK|MB_ICONEXCLAMATION);
		else
			MessageBox(hWnd, L"Reading the WAV file failed. Check that it has the same name as the sequence file (with a .WAV extension) and is a 16 bit PCM format (mono or stereo) with a supported sample rate.", L"WAV file open error", MB_OK|MB_ICONEXCLAMATION);
		return false;
	} else {
		if( !bNew ) {
			int wav_ms_len = wav_content ? (wav_len + ((wav_sample_rate+999) / 1000 - 1)) * 1000LL / wav_sample_rate : -1;
			if( !sequence_load(filename, wav_ms_len) ) {
				RECT rcClient;
				GetClientRect(hWnd, &rcClient);
				InvalidateRect(hWnd, &rcClient, true);
				MessageBox(hWnd, L"Reading the sequence file failed. Check that its permissions are correct and that it has not become corrupted.", L"Sequence file open error", MB_OK|MB_ICONEXCLAMATION);
				return false;
			}
			if( !wav_content ) {
				int min = 0x7FFFFFFF/12;
				for( int i = 0; i < 32; ++i ) {
					int len = sequence_get_length_ms(&sequences[i]);
					if( len < min )
						min = len;
				}
				wav_content = NULL;
				wav_sample_rate = 12000;
				wav_bytes_per_sample = 4;
				wav_num_channels = 2;
				wav_len = length_ms * 12;
				sequence_loaded = 1;
				wav_len = min * 12;
				g_bLoading = true;
				for( int i = 0; i < 32; ++i )
					sequence_truncate(&sequences[i], min, min);
				g_bLoading = false;
			}
			sequence_loaded = 1;
			DelayedUpdateDisabledState(hWnd);
			wcscpy(sequence_file_name, filename);
		} else {
			if( length_ms != -1 )
				CreateStandaloneSequence(length_ms);
			wcscpy(sequence_file_name, alt_filename);
			NewSequence(hWnd);
			UndoSetDirty();
		}
		if( wav_content && zoom >= wav_mipmap_levels ) {
			int old_zoom = zoom;
			zoom = wav_mipmap_levels-1;
			SetScrollExtent(hWnd, old_zoom, -1);
		} else {
			SetScrollExtent(hWnd, zoom, -1);
		}
		UpdateWindowTitle(hWnd);
		InvalidateRect(hWnd, &rcSeq, true);
		InvalidateRect(hWnd, &rcWAV, true);
	}
	InvalidateStatus(hWnd);
	if( !bNew ) {
		UpdateRecentFiles(hWnd);
		UpdateRecentFilesMenu(hWnd);
	}
	return true;
}

void OpenSequence(HWND hWnd, HINSTANCE hInst, bool bNew) {
	if( !PreCloseSequence(hWnd) )
		return;
	int length_ms = -1;
	if( bNew ) {
		if( !NewSequenceDialog(hWnd, hInst, &length_ms) )
			return;
	}
	if( bNew && length_ms != -1 ) {
		OPENFILENAME ofn;
		wchar_t filename[_MAX_PATH] = L"";
		memset(&ofn, 0, sizeof(ofn));
		ofn.lStructSize = sizeof(ofn);
		ofn.hwndOwner = hWnd;
		ofn.lpstrFilter = L"Sequence Files\0*.lsn\0\0";
		ofn.lpstrFile = filename;
		ofn.nMaxFile = sizeof(filename)-5;
		ofn.lpstrTitle = L"New Sequence";
		ofn.Flags = OFN_ENABLESIZING|OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST|OFN_LONGNAMES;
		if( GetOpenFileName(&ofn) ) {
			UndoSetClean();
			DoOpenSequence(hWnd, filename, bNew, length_ms);
		}
	} else {
		OPENFILENAME ofn;
		wchar_t filename[_MAX_PATH] = L"";
		memset(&ofn, 0, sizeof(ofn));
		ofn.lStructSize = sizeof(ofn);
		ofn.hwndOwner = hWnd;
		ofn.lpstrFilter = bNew ? L"WAV Audio Files\0*.wav\0\0" : L"Sequence Files\0*.lsq;*.lsn\0\0";
		ofn.lpstrFile = filename;
		ofn.nMaxFile = sizeof(filename);
		ofn.lpstrTitle = bNew ? L"Open WAV File for Sequencing" : L"Open Sequence";
		ofn.Flags = OFN_ENABLESIZING|OFN_FILEMUSTEXIST|OFN_PATHMUSTEXIST|OFN_LONGNAMES;
		if( GetOpenFileName(&ofn) ) {
			UndoSetClean();
			DoOpenSequence(hWnd, filename, bNew, length_ms);
		}
	}
}

bool SaveSequence(HWND hWnd) {
	bool bRet = sequence_save(sequence_file_name, g_bBackupSequenceFiles);
	if( bRet ) {
		UpdateRecentFiles(hWnd);
		UpdateRecentFilesMenu(hWnd);
	}
	return bRet;
}

static bool DoSaveSequenceAs(HWND hWnd, wchar_t* filename, bool bAsCopy, bool bCopyWAV = false, bool bDontOverwriteWAV = false) {
	const wchar_t* dot = wcsrchr(filename, L'.');
	const wchar_t* slash = wcsrchr(filename, L'\\');
	if( !dot || dot < slash ) {
		int len = wcslen(filename);
		if( len < sizeof(filename) - 5 ) {
			wcscpy(filename+len, wav_content ? L".lsq" : L".lsn");
		}
	}
	if( !sequence_save(filename, false) ) {
		MessageBox(hWnd, L"Saving the sequence file failed. Please check that you have permission to write files into that folder and that you are not out of disk space.", L"Sequence file save error", MB_OK|MB_ICONEXCLAMATION);
		return false;
	} else {
		if( bCopyWAV && wav_content ) {
			wchar_t old_wav_name[_MAX_PATH], new_wav_name[_MAX_PATH];

			dot = wcsrchr(sequence_file_name, L'.');
			slash = wcsrchr(sequence_file_name, L'\\');
			if( !dot || dot < slash )
				dot = sequence_file_name + wcslen(sequence_file_name);
			wcsncpy(old_wav_name, sequence_file_name, dot - sequence_file_name);
			wcscpy(old_wav_name + (dot - sequence_file_name), L".wav");

			dot = wcsrchr(filename, L'.');
			slash = wcsrchr(filename, L'\\');
			if( !dot || dot < slash )
				dot = filename + wcslen(filename);
			wcsncpy(new_wav_name, filename, dot - filename);
			wcscpy(new_wav_name + (dot - filename), L".wav");

			if( !CopyFile(old_wav_name, new_wav_name, bDontOverwriteWAV) && (!bDontOverwriteWAV || GetLastError() != ERROR_FILE_EXISTS) ) {
				if( bAsCopy ) {
					MessageBox(hWnd, L"Copying the WAV file failed. Please check that you have permission to write files into that folder and that you are not out of disk space. The new sequence file was saved.", L"WAV file copy error", MB_OK|MB_ICONEXCLAMATION);
					return false;
				} else {
					MessageBox(hWnd, L"Copying the WAV file failed. Please check that you have permission to write files into that folder and that you are not out of disk space. The new sequence file was saved but any changes made now will be to the original file.", L"WAV file copy error", MB_OK|MB_ICONEXCLAMATION);
					return false;
				}
			} else {
				if( !bAsCopy ) {
					wcscpy(sequence_file_name, filename);
					UndoSetClean();
					UpdateWindowTitle(hWnd);
				}
			}
		}
	}
	return true;
}

void SaveSequenceAs(HWND hWnd, bool bAsCopy) {
	int ret;
	if( wav_content ) {
		if( bAsCopy ) {
			ret = MessageBox(hWnd, L"Do you want to copy the WAV file to accompany the newly saved sequence file?", L"Save copy as...", MB_YESNOCANCEL|MB_DEFBUTTON1|MB_ICONEXCLAMATION);
		} else {
			ret = MessageBox(hWnd, L"Do you want to copy the WAV file to accompany the newly saved sequence file? If you answer no then the new sequence will be saved but you will continue to edit the original.", L"Save sequence as...", MB_YESNOCANCEL|MB_DEFBUTTON1|MB_ICONEXCLAMATION);
		}
	} else {
		ret = IDNO;
	}
	if( ret != IDCANCEL ) {
		OPENFILENAME ofn;
		wchar_t filename[_MAX_PATH+5];
		wcscpy(filename, sequence_file_name);
		memset(&ofn, 0, sizeof(ofn));
		ofn.lStructSize = sizeof(ofn);
		ofn.hwndOwner = hWnd;
		ofn.lpstrFilter = wav_content ? L"Sequence Files\0*.lsq\0\0" : L"Sequence Files\0*.lsn\0\0";
		ofn.lpstrFile = filename;
		ofn.nMaxFile = sizeof(filename)-5;
		ofn.lpstrTitle = L"Save sequence as...";
		ofn.Flags = OFN_ENABLESIZING|OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST|OFN_LONGNAMES;
		if( GetSaveFileName(&ofn) )
			DoSaveSequenceAs(hWnd, filename, bAsCopy, ret == IDYES, true);
	}
}

bool RevertSequence(HWND hWnd) {
	if( sequence_loaded ) {
		UndoSetClean();
		return DoOpenSequence(hWnd, sequence_file_name, false, -1);
	} else {
		return false;
	}
}

void PublishSequence(HWND hWnd, HINSTANCE hInst) {
	if( GetDriveType(PublishPath) == DRIVE_NO_ROOT_DIR ) {
		OpenPublishWaitDialog(hWnd, hInst);
		if( GetDriveType(PublishPath) == DRIVE_NO_ROOT_DIR )
			return;
	}

	wchar_t filename[_MAX_PATH + 16];
	wcscpy(filename, PublishPath);

	const wchar_t* name = wcsrchr(sequence_file_name, L'\\');
	if( name )
		++name;
	else
		name = sequence_file_name;
	wcscpy(filename + 3, name);

	if( DoSaveSequenceAs(hWnd, filename, true, true, true) && g_bEjectAfterPublish )
		EjectVolume(PublishPath[0]);
}

void UpdateWindowTitle(HWND hWnd) {
	if( !sequence_loaded ) {
		SetWindowText(hWnd, L"No file - Digital Lighting Controller");
	} else {
		wchar_t buf[_MAX_PATH + 256];
		const wchar_t* name = wcsrchr(sequence_file_name, L'\\');
		if( name )
			++name;
		else
			name = sequence_file_name;
		wsprintf(buf, L"%s - Digital Lighting Controller", name);
		SetWindowText(hWnd, buf);
	}
}

bool FileIsOpen(const wchar_t** pReason) {
	if( pReason )
		*pReason = L"no file is currently open";
	return sequence_loaded != 0;
}

bool FileIsOpenAndNotStandalone(const wchar_t** pReason) {
	if( pReason )
		*pReason = sequence_loaded ? L"this is a standalone sequence" : L"no file is currently open";
	return sequence_loaded != 0 && wav_content;
}

wchar_t PublishPath[] = L"Z:\\";
bool CanPublish(const wchar_t** pReason) {
	static wchar_t reason[] = L"there is currently no drive F:";

	if( pReason )
		*pReason = sequence_loaded ? reason : L"no file is currently open";
	return sequence_loaded != 0 && GetDriveType(PublishPath) != DRIVE_NO_ROOT_DIR;
}

bool FileHasChanged(const wchar_t** pReason) {
	if( pReason )
		*pReason = sequence_loaded ? L"no changes have been made since the last save" : L"no file is currently open";
	return sequence_loaded != 0 && UndoIsDirty();
}

bool IsStandaloneSequence(const wchar_t** pReason) {
	if( pReason )
		*pReason = sequence_loaded ? L"this is not a standalone sequence" : L"no file is currently open";
	return sequence_loaded != 0 && !wav_content;
}
