
#include "p33Fxxxx.h"
#include "chainsense.h"

unsigned short get_chain_length() {
	unsigned short result, ret;

	LATBbits.LATB2 = 1;
	AD1PCFGLbits.PCFG4 = 0;  // set up AN4 for analog

	AD1CON1bits.SSRC = 7;    // auto-convert
	AD1CON1bits.AD12B = 1;   // 12-bit mode
//	AD1CON3bits.ADRC = 1;    // use internal RC clock
	AD1CON3bits.ADCS = 0xFF; // slowest clock possible
	AD1CON3bits.SAMC = 31;   // 31 clocks for sampling period
	AD1CHS0bits.CH0SA = 4;   // input is AN4
	AD1CON1bits.ADON = 1;    // turn on ADC

	AD1CON1bits.SAMP = 1;
	while( !AD1CON1bits.DONE )
		Nop();
	result = ADC1BUF0;

	AD1CON1bits.ADON = 0;    // turn off ADC

	for( ret = 0; ret < 4; ++ret ) {
		unsigned short expected = 4096 * ret / (ret+1);
		unsigned short next_expected = 4096 * (ret+1) / (ret+2);
		if( result < (expected + next_expected) / 2 )
			break;
	}

	return ret;
}

