
typedef enum { reset, stopped, playing, paused, error } playback_state_t;
typedef enum { ok, sd_card_invalid_response, sd_card_wrong_voltage, sd_card_timeout, fat_mount_failed, open_root_dir_failed, config_file_invalid, no_wav_files, invalid_wav_file, invalid_wav_format, file_read_error } playback_error_t;
typedef enum { directory, sorted, shuffle } playback_order_t;

#define ERROR_NOT_SDMMC_CARD		1
#define ERROR_BAD_VOLTAGE_RANGE	  	2
#define ERROR_SDMMC_CARD_TIMEOUT	3

static inline unsigned char is_wav_ext(const char* ext) {
	return (ext[1] == 'w' || ext[1] == 'W') && (ext[2] == 'a' || ext[2] == 'A') && (ext[3] == 'v' || ext[3] == 'V') && ext[4] == '\0';
}

static inline unsigned char is_lsn_ext(const char* ext) {
	return (ext[1] == 'l' || ext[1] == 'L') && (ext[2] == 's' || ext[2] == 'S') && (ext[3] == 'n' || ext[3] == 'N') && ext[4] == '\0';
}

static inline unsigned char is_playable_ext(const char* ext) {
	return is_wav_ext(ext) || is_lsn_ext(ext);
}


unsigned char init_playback();
unsigned char playback_reset();
unsigned char playback_start();
unsigned char playback_stop();
unsigned char playback_pause();
unsigned char playback_next_track(unsigned char clear_buffer);
unsigned char playback_prev_track(unsigned char clear_buffer);
unsigned char playback_forward();
unsigned char playback_back();
unsigned char playback_volume_up();
unsigned char playback_volume_down();
unsigned char playback_volume_set(unsigned char percent);
unsigned char playback_toggle_mute();
unsigned char playback_play_single_file(unsigned char index);
unsigned char set_playback_order(playback_order_t order);
playback_state_t get_playback_status();
playback_error_t get_playback_error();
playback_order_t get_playback_order();
unsigned char get_playback_shuffle();
unsigned char do_playback();

unsigned char goto_specific_wav_file(char* name, unsigned short name_len);
