
#include "ir_codes.h"
#include "infrared.h"

remote_code_ram remote_codes[NUM_REMOTE_FNS];
static const remote_code_rom default_remote_codes[NUM_REMOTE_FNS] = {
  { "volup",   { RC5(RC5_A1012_VOLUP),   RC5(RC5_A1012_UP),       RC5(RC5_AR1729_VOLUP), RC5(RC5_AR1729_UP)   } },
  { "voldn",   { RC5(RC5_A1012_VOLDN),   RC5(RC5_A1012_DOWN),     RC5(RC5_AR1729_VOLDN), RC5(RC5_AR1729_DOWN) } },
  { "1",       { RC5(RC5_A1012_1),       RC5(RC5_AR1729_1),       IR_NOCODE,             IR_NOCODE            } },
  { "2",       { RC5(RC5_A1012_2),       RC5(RC5_AR1729_2),       IR_NOCODE,             IR_NOCODE            } },
  { "3",       { RC5(RC5_A1012_3),       RC5(RC5_AR1729_3),       IR_NOCODE,             IR_NOCODE            } },
  { "4",       { RC5(RC5_A1012_4),       RC5(RC5_AR1729_4),       IR_NOCODE,             IR_NOCODE            } },
  { "5",       { RC5(RC5_A1012_5),       RC5(RC5_AR1729_5),       IR_NOCODE,             IR_NOCODE            } },
  { "6",       { RC5(RC5_A1012_6),       RC5(RC5_AR1729_6),       IR_NOCODE,             IR_NOCODE            } },
  { "7",       { RC5(RC5_A1012_7),       RC5(RC5_AR1729_7),       IR_NOCODE,             IR_NOCODE            } },
  { "8",       { RC5(RC5_A1012_8),       RC5(RC5_AR1729_8),       IR_NOCODE,             IR_NOCODE            } },
  { "9",       { RC5(RC5_A1012_9),       RC5(RC5_AR1729_9),       IR_NOCODE,             IR_NOCODE            } },
  { "10",      { RC5(RC5_A1012_0),       RC5(RC5_AR1729_0),       IR_NOCODE,             IR_NOCODE            } },
  { "play",    { RC5(RC5_A1012_PLAY),    RC5(RC5_AR1729_PLAY),    IR_NOCODE,             IR_NOCODE            } },
  { "stop",    { RC5(RC5_A1012_STOP),    RC5(RC5_AR1729_STOP),    IR_NOCODE,             IR_NOCODE            } },
  { "pause",   { RC5(RC5_A1012_PAUSE),   RC5(RC5_AR1729_PAUSE),   IR_NOCODE,             IR_NOCODE            } },
  { "order",   { RC5(RC5_A1012_RECORD),  RC5(RC5_AR1729_RECORD),  IR_NOCODE,             IR_NOCODE            } },
  { "reset",   { RC5(RC5_A1012_STANDBY), RC5(RC5_AR1729_STANDBY), IR_NOCODE,             IR_NOCODE            } },
  { "next",    { RC5(RC5_A1012_CHUP),    RC5(RC5_A1012_RIGHT),    RC5(RC5_AR1729_CHUP),  RC5(RC5_AR1729_RIGHT)} },
  { "prev",    { RC5(RC5_A1012_CHDN),    RC5(RC5_A1012_LEFT),     RC5(RC5_AR1729_CHDN),  RC5(RC5_AR1729_LEFT) } },
  { "forward", { RC5(RC5_A1012_FF),      RC5(RC5_AR1729_FF),      IR_NOCODE,             IR_NOCODE            } },
  { "back",    { RC5(RC5_A1012_RW),      RC5(RC5_AR1729_RW),      IR_NOCODE,             IR_NOCODE            } },
  { "mute",    { RC5(RC5_A1012_MUTE),    RC5(RC5_AR1729_MUTE),    IR_NOCODE,             IR_NOCODE            } }
};

void restore_default_remote_codes() {
	unsigned char i, j;
	for( i = 0; i < NUM_REMOTE_FNS; ++i ) {
		remote_codes[i].fn = default_remote_codes[i].fn;
		for( j = 0; j < NUM_REMOTE_CODES; ++j ) {
			remote_codes[i].lower_codes[j] = default_remote_codes[i].codes[j];
			remote_codes[i].upper_codes[j] = default_remote_codes[i].codes[j]>>16;
		}
	}
}

const char* get_remote_control_function(unsigned long code) {
	unsigned char i, j, upper_code;
	unsigned short lower_code;
	lower_code = IR_CODE(code);
	upper_code = IR_CODE(code)>>16;
	for( i = 0; i < NUM_REMOTE_FNS; ++i ) {
		for( j = 0; j < NUM_REMOTE_CODES; ++j ) {
			if( remote_codes[i].lower_codes[j] == lower_code && remote_codes[i].upper_codes[j] == upper_code )
				return remote_codes[i].fn;
		}
	}
	return (const char*)0;
}
