
#include "p33Fxxxx.h"

unsigned long read_program_word(unsigned long address) {
	union {
		unsigned short s[2];
		unsigned long l;
	} ret;

    unsigned short eedata_addr;
    unsigned short savedTBLPAG = TBLPAG;
    TBLPAG = address>>16;

    eedata_addr = address;
	ret.s[0] = __builtin_tblrdl(eedata_addr);
	ret.s[1] = __builtin_tblrdh(eedata_addr);
    TBLPAG = savedTBLPAG;
	return ret.l;
}

unsigned int disableInterrupts() {
	unsigned int ipl_level;
	SET_AND_SAVE_CPU_IPL(ipl_level, 7);
	return ipl_level;
} 

void enableInterrupts(unsigned int ipl_level) {
	RESTORE_CPU_IPL(ipl_level);	
}

#ifdef BOOTLOADER
extern void pre_erase_flash_block(unsigned short addr);
extern void flash_block_erased(unsigned short addr);
#endif

void erase_flash_block(unsigned short addr) {
    unsigned short savedTBLPAG;

#ifdef BOOTLOADER
	pre_erase_flash_block(addr);
#endif

	savedTBLPAG = TBLPAG;

	NVMCON=0x4042;
	TBLPAG=0;
	__builtin_tblwtl(addr, 0);
	asm("disi #5");
	__builtin_write_NVM();
    TBLPAG = savedTBLPAG;

#ifdef BOOTLOADER
	flash_block_erased(addr);
#endif
}

void write_flash_word(unsigned short addr, unsigned long data) {
    unsigned short savedTBLPAG = TBLPAG;
	union {
		unsigned long l;
		unsigned short s[2];
	} un;

	un.l = data;

	NVMCON=0x4003;
	TBLPAG=0;
	__builtin_tblwtl(addr, un.s[0]);
	__builtin_tblwth(addr, un.s[1]);
	asm("disi #5");
	__builtin_write_NVM();
    TBLPAG = savedTBLPAG;
}

void write_flash_row(unsigned short addr, unsigned long* data) {
    unsigned short savedTBLPAG = TBLPAG;
	unsigned char i;

	NVMCON=0x4001;
	TBLPAG = 0;
	for( i = 0; i < 64; ++i ) {
		__builtin_tblwtl(addr, ((unsigned short*)data)[0]);
		__builtin_tblwth(addr, ((unsigned short*)data)[1]);
		data += 1;
		addr += 2;
	}
	asm("disi #5");
	__builtin_write_NVM();
    TBLPAG = savedTBLPAG;
}

unsigned char erased_flash_blocks[6];
void erase_flash_addr_once(unsigned short addr) {
	unsigned short block = addr / 512 / 2;
	if( !(erased_flash_blocks[block>>3]&(1<<(block&7))) ) {
		erase_flash_block(block * 512 * 2);
		erased_flash_blocks[block>>3] |= (1<<(block&7));
	}
}

#ifdef BOOTLOADER
// statically allocating it saves program code space
unsigned long flash_row_buffer[64];
#else
// this saves RAM, the main program can allocate it from the heap
unsigned long* flash_row_buffer;
#endif
unsigned short flash_row_address, flash_row_pos;

void smart_write_flash_flush_buffer() {
	if( flash_row_pos ) {
		unsigned char i;
		erase_flash_addr_once(flash_row_address - flash_row_pos * 2);
		for( i = 0; i < flash_row_pos; ++i ) {
			write_flash_word(flash_row_address - (flash_row_pos-i) * 2, flash_row_buffer[i]);
		}
		flash_row_pos = 0;
	}
}
void smart_write_flash_word(unsigned short addr, unsigned long data) {
	if( flash_row_pos == 0 && !(addr&127) ) {
		flash_row_address = addr;
	}
	if( addr == flash_row_address ) {
		flash_row_buffer[flash_row_pos++] = data;
		flash_row_address += 2;
		if( flash_row_pos == 64 ) {
			erase_flash_addr_once(flash_row_address - 64 * 2);
			write_flash_row(flash_row_address - 64 * 2, flash_row_buffer);
			flash_row_pos = 0;
		}
	} else {
		if( flash_row_pos )
			smart_write_flash_flush_buffer();
		erase_flash_addr_once(addr);
		write_flash_word(addr, data);
	}
}
