
//// change these to suit the application ////

#define SDCARD_SPI        2
#define SDCARD_DMA		  2
#define SDCARD_DIN_RP     11
#define SDCARD_DIN_PORT   B
#define SDCARD_DIN_PIN    11
#define SDCARD_CLK_RP     10
#define SDCARD_CLK_PORT   B
#define SDCARD_CLK_PIN    10
#define SDCARD_DOUT_RP    8
#define SDCARD_DOUT_PORT  B
#define SDCARD_DOUT_PIN   8

/////////////////////////////////////////////

#include "GenericTypeDefs.h"
#include "spi.h"
#include "p33Fxxxx.h"
#include <string.h>

/* 
	SPI Module Firmware
	by Mauro Grassi, 2009-2010.
*/

#define _SPISTATname(spi) SPI##spi##STAT
#define SPISTATname(spi)  _SPISTATname(spi)
#define _SPISTATbits(spi) SPI##spi##STATbits
#define SPISTATbits(spi)  _SPISTATbits(spi)
#define _SPICON1name(spi) SPI##spi##CON1
#define SPICON1name(spi)  _SPICON1name(spi)
#define _SPICON1bits(spi) SPI##spi##CON1bits
#define SPICON1bits(spi)  _SPICON1bits(spi)
#define _SPICON2name(spi) SPI##spi##CON2
#define SPICON2name(spi)  _SPICON2name(spi)
#define _SPIBUFname(spi)  SPI##spi##BUF
#define SPIBUFname(spi)   _SPIBUFname(spi)
#define _SPIIEname(spi)   _SPI##spi##IE
#define SPIIEname(spi)    _SPIIEname(spi)
#define _SPIIFname(spi)   _SPI##spi##IF
#define SPIIFname(spi)    _SPIIFname(spi)
#define _RPORbits(a,b)    RPOR##a##bits.RP##b##R
#define RPORbits(a,b)     _RPORbits(a,b)
#define _TRISbits(a,b)    TRIS##a##bits.TRIS##a##b
#define TRISbits(a,b)     _TRISbits(a,b)
#define _LATbits(a,b)     LAT##a##bits.LAT##a##b
#define LATbits(a,b)      _LATbits(a,b)
#define _DMACONname(dma)  DMA##dma##CON
#define DMACONname(dma)   _DMACONname(dma)
#define _DMACONbits(dma)  DMA##dma##CONbits
#define DMACONbits(dma)   _DMACONbits(dma)
#define _DMASTAname(dma)  DMA##dma##STA
#define DMASTAname(dma)   _DMASTAname(dma)
#define _DMAPADname(dma)  DMA##dma##PAD
#define DMAPADname(dma)   _DMAPADname(dma)
#define _DMACNTname(dma)  DMA##dma##CNT
#define DMACNTname(dma)   _DMACNTname(dma)
#define _DMAREQname(dma)  DMA##dma##REQ
#define DMAREQname(dma)   _DMAREQname(dma)

#ifndef NO_DMA
#define USE_DMA
#endif
#define SLOW_SPI_DELAY 64

#ifdef USE_DMA
unsigned char SPIRxBuffer[512] __attribute__((space(dma)));
#endif

void InitSPI(int speed)
{
	/* Initialise the SPI System */
	SDCS=1;
	SDCS_TRIS=0;
	SPISTATname(SDCARD_SPI)=0;
	SPICON1name(SDCARD_SPI)=0;
	SPICON2name(SDCARD_SPI)=0;

	// set up SPI pins
#if SDCARD_SPI == 1
	RPINR20bits.SDI1R = SDCARD_DIN_RP;
	#define SD_CARD_SPI_DOUT_PIN 7
	#define SD_CARD_SPI_CLK_PIN 8
#else
	RPINR22bits.SDI2R = SDCARD_DIN_RP;
	#define SD_CARD_SPI_DOUT_PIN 10
	#define SD_CARD_SPI_CLK_PIN 11
#endif
#if SDCARD_CLK_RP < 2
	RPORbits(0,SDCARD_CLK_RP) = SD_CARD_SPI_CLK_PIN;
#elif SDCARD_CLK_RP < 4
	RPORbits(1,SDCARD_CLK_RP) = SD_CARD_SPI_CLK_PIN;
#elif SDCARD_CLK_RP < 6
	RPORbits(2,SDCARD_CLK_RP) = SD_CARD_SPI_CLK_PIN;
#elif SDCARD_CLK_RP < 8
	RPORbits(3,SDCARD_CLK_RP) = SD_CARD_SPI_CLK_PIN;
#elif SDCARD_CLK_RP < 10
	RPORbits(4,SDCARD_CLK_RP) = SD_CARD_SPI_CLK_PIN;
#elif SDCARD_CLK_RP < 12
	RPORbits(5,SDCARD_CLK_RP) = SD_CARD_SPI_CLK_PIN;
#elif SDCARD_CLK_RP < 14
	RPORbits(6,SDCARD_CLK_RP) = SD_CARD_SPI_CLK_PIN;
#elif SDCARD_CLK_RP < 16
	RPORbits(7,SDCARD_CLK_RP) = SD_CARD_SPI_CLK_PIN;
#elif SDCARD_CLK_RP < 18
	RPORbits(8,SDCARD_CLK_RP) = SD_CARD_SPI_CLK_PIN;
#elif SDCARD_CLK_RP < 20
	RPORbits(9,SDCARD_CLK_RP) = SD_CARD_SPI_CLK_PIN;
#elif SDCARD_CLK_RP < 22
	RPORbits(10,SDCARD_CLK_RP) = SD_CARD_SPI_CLK_PIN;
#elif SDCARD_CLK_RP < 24
	RPORbits(11,SDCARD_CLK_RP) = SD_CARD_SPI_CLK_PIN;
#else
	RPORbits(12,SDCARD_CLK_RP) = SD_CARD_SPI_CLK_PIN;
#endif
#if SDCARD_DOUT_RP < 2
	#define SDCARD_DOUT_RPOR RPORbits(0,SDCARD_DOUT_RP)
#elif SDCARD_DOUT_RP < 4
	#define SDCARD_DOUT_RPOR RPORbits(1,SDCARD_DOUT_RP)
#elif SDCARD_DOUT_RP < 6
	#define SDCARD_DOUT_RPOR RPORbits(2,SDCARD_DOUT_RP)
#elif SDCARD_DOUT_RP < 8
	#define SDCARD_DOUT_RPOR RPORbits(3,SDCARD_DOUT_RP)
#elif SDCARD_DOUT_RP < 10
	#define SDCARD_DOUT_RPOR RPORbits(4,SDCARD_DOUT_RP)
#elif SDCARD_DOUT_RP < 12
	#define SDCARD_DOUT_RPOR RPORbits(5,SDCARD_DOUT_RP)
#elif SDCARD_DOUT_RP < 14
	#define SDCARD_DOUT_RPOR RPORbits(6,SDCARD_DOUT_RP)
#elif SDCARD_DOUT_RP < 16
	#define SDCARD_DOUT_RPOR RPORbits(7,SDCARD_DOUT_RP)
#elif SDCARD_DOUT_RP < 18
	#define SDCARD_DOUT_RPOR RPORbits(8,SDCARD_DOUT_RP)
#elif SDCARD_DOUT_RP < 20
	#define SDCARD_DOUT_RPOR RPORbits(9,SDCARD_DOUT_RP)
#elif SDCARD_DOUT_RP < 22
	#define SDCARD_DOUT_RPOR RPORbits(10,SDCARD_DOUT_RP)
#elif SDCARD_DOUT_RP < 24
	#define SDCARD_DOUT_RPOR RPORbits(11,SDCARD_DOUT_RP)
#else
	#define SDCARD_DOUT_RPOR RPORbits(12,SDCARD_DOUT_RP)
#endif
	SDCARD_DOUT_RPOR = SD_CARD_SPI_DOUT_PIN;
	TRISbits(SDCARD_DOUT_PORT, SDCARD_DOUT_PIN) = 0;
	LATbits(SDCARD_DOUT_PORT, SDCARD_DOUT_PIN) = 1;
	TRISbits(SDCARD_CLK_PORT, SDCARD_CLK_PIN) = 0;
	TRISbits(SDCARD_DIN_PORT, SDCARD_DIN_PIN) = 1;
	
	/* Speed Selection
		SPIxCON1<4:2>= 	Secondary Prescaler (Master Mode)
						111b	1:1
						110b	2:1
						...	
						000b	8:1
		SPIxCON1<1:0>=	Primary Prescaler (Master Mode)
						11b		1:1
						10b		4:1
						01b		16:1
						00b		64:1

		Note: do not set both to 1:1
	*/

	SPICON1name(SDCARD_SPI)=(0x1F & speed);
	SPICON1bits(SDCARD_SPI).MODE16=0;		/*  8 bit mode */
	SPICON1bits(SDCARD_SPI).SMP=0;			/* input data sampling */
	SPICON1bits(SDCARD_SPI).CKP=0;			/* clock Polarity 0: idle low, active high 1: idle high, active low */
	SPICON1bits(SDCARD_SPI).CKE=1;			/* clock edge selection */
	SPICON1bits(SDCARD_SPI).MSTEN=1;		/* enable Master Mode */
	SPISTATbits(SDCARD_SPI).SPIROV=0;
	SPIIFname(SDCARD_SPI)=0;
	SPIIEname(SDCARD_SPI)=0;
	SPISTATbits(SDCARD_SPI).SPIEN=1;

#ifdef USE_DMA
	DMACONname(SDCARD_DMA) = 0x4801;
	DMASTAname(SDCARD_DMA) = __builtin_dmaoffset(SPIRxBuffer);
	DMAPADname(SDCARD_DMA) = (volatile unsigned int) &SPIBUFname(SDCARD_SPI);
	DMACNTname(SDCARD_DMA) = 511;
	DMAREQname(SDCARD_DMA) = 0x0021;
#endif
}

unsigned int WriteSPI(unsigned int x)
{
	SDCS=0;
	if( (SPICON1name(SDCARD_SPI)&0x1F) == 0x00 ) {
		unsigned short i;
		for( i = 0; i < SLOW_SPI_DELAY; ++i )
			Nop();
	}
	SPIBUFname(SDCARD_SPI)=x;
	while(SPISTATbits(SDCARD_SPI).SPITBF)Nop();
	while(SPISTATbits(SDCARD_SPI).SPIRBF==0)Nop();
	x=SPIBUFname(SDCARD_SPI);
	if( (SPICON1name(SDCARD_SPI)&0x1F) == 0x00 ) {
		unsigned short i;
		for( i = 0; i < SLOW_SPI_DELAY; ++i )
			Nop();
	}
	SDCS=1;
	if( (SPICON1name(SDCARD_SPI)&0x1F) == 0x00 ) {
		unsigned short i;
		for( i = 0; i < SLOW_SPI_DELAY; ++i )
			Nop();
	}
	return x;
}

#ifdef USE_DMA
unsigned char* BulkReadSPI() {
	SDCS = 0;
	// setting DISSDO doesn't work but this does
	SDCARD_DOUT_RPOR = 0;
	DMACONbits(SDCARD_DMA).CHEN=1;
	SPIBUFname(SDCARD_SPI) = 0x00;
	while( DMACONbits(SDCARD_DMA).CHEN )
		Nop();
	// restore the data output pin to its normal function
	SDCARD_DOUT_RPOR = SD_CARD_SPI_DOUT_PIN;
	SDCS = 1;
	return (unsigned char*)SPIRxBuffer;
}
#endif

unsigned int WriteSPIWithoutSS(unsigned int x)
{
	if( (SPICON1name(SDCARD_SPI)&0x1F) == 0x00 ) {
		unsigned short i;
		for( i = 0; i < SLOW_SPI_DELAY; ++i )
			Nop();
	}
	SPIBUFname(SDCARD_SPI)=x;
	while(SPISTATbits(SDCARD_SPI).SPITBF)Nop();
	while(SPISTATbits(SDCARD_SPI).SPIRBF==0)Nop();
	x=SPIBUFname(SDCARD_SPI);
	if( (SPICON1name(SDCARD_SPI)&0x1F) == 0x00 ) {
		unsigned short i;
		for( i = 0; i < SLOW_SPI_DELAY; ++i )
			Nop();
	}
	return x;
}
