
//// change these to suit the application ////

#define DAC_TIMER    4
#undef  INIT_DAC_RUNNING

//////////////////////////////////////////////

#include "p33Fxxxx.h"
#include "dac.h"
#include <string.h>
#include <stdlib.h>

#define _TCONname(which) T##which##CONbits
#define TCONname(which) _TCONname(which)
#define _TIMERname(which) TMR##which
#define TIMERname(which) _TIMERname(which)
#define _TMRname(which) _T##which##Interrupt
#define TMRname(which) _TMRname(which)
#define _TEname(which) IEC0bits.T##which##IE
#define TEname(which) _TEname(which)
#define _TFname(which) IFS0bits.T##which##IF
#define TFname(which) _TFname(which)
#define _PRname(which) PR##which
#define PRname(which) _PRname(which)


signed short DMA_DACBufferLA[128] __attribute__((space(dma)));
signed short DMA_DACBufferLB[128] __attribute__((space(dma)));
signed short DMA_DACBufferRA[128] __attribute__((space(dma)));
signed short DMA_DACBufferRB[128] __attribute__((space(dma)));

signed short* DACBuffer;
unsigned short DACBuffer_writepos;
volatile unsigned short DACBuffer_readpos;
volatile unsigned char DACBuffer_full;
volatile unsigned char DAC_read;
unsigned long sample_timer;

void write_dac(signed short* data, unsigned char num_channels, unsigned short volume) {
	while( DACBuffer_full == 1 )
		Nop();
	if( num_channels == 1 ) {
		signed short* dest = DACBuffer+DACBuffer_writepos;
		unsigned short i = 128;
		if( volume == 32768 ) {
			while( i-- ) {
				dest[0] = dest[1] = data[0];
				dest += 2;
				data += 1;
			}
		} else {
			while( i-- ) {
				dest[0] = dest[1] = __builtin_mulss(data[0], volume)>>15;
				dest += 2;
				data += 1;
			}
		}
	} else {
		if( volume == 32768 ) {
			memcpy(DACBuffer+DACBuffer_writepos, data, 512);
		} else {
			unsigned short i = 256;
			signed short* dest = DACBuffer+DACBuffer_writepos;
			signed short* src = data;
			while( i-- ) {
				dest[0] = __builtin_mulss(src[0], volume)>>15;
				++dest;
				++src;
			}
		}
	}
	asm volatile("disi #12");
	DACBuffer_writepos += 256;
	if( DACBuffer_writepos == 256*DAC_BUFFER_PAGES )
		DACBuffer_writepos = 0;
	if( DACBuffer_writepos == DACBuffer_readpos )
		DACBuffer_full = 1;
	asm volatile("disi #0");
}

void pause_dac(unsigned char paused) {
	DAC1CONbits.DACEN = !paused;
	TCONname(DAC_TIMER).TON = !paused;
}

void dac_reset_buffer() {
	DACBuffer_writepos = DACBuffer_readpos = 0;
	DACBuffer_full = 0;
}
void dac_clear_buffer() {
	memset(DACBuffer, 0, 512*DAC_BUFFER_PAGES);
	DACBuffer_writepos = DACBuffer_readpos = 0;
	DACBuffer_full = 0;
}
unsigned char* get_dac_buffer() {
	return (unsigned char*)DACBuffer;
}

void reset_sample_timer() {
	sample_timer = 0;
	TIMERname(DAC_TIMER) = 0;
}
void offset_sample_timer(signed long samples) {
	if( samples < 0 && -samples > sample_timer )
		sample_timer = 0;
	else
		sample_timer += samples;
}
unsigned long read_sample_timer_samples() {
	return sample_timer + TIMERname(DAC_TIMER) / (DAC1CONbits.DACFDIV+1);
}
unsigned long read_sample_timer_ms() {
	unsigned long samples = read_sample_timer_samples();
	if( CLKDIVbits.PLLPRE == 14 ) {
		unsigned char mul;
		unsigned short sr;
		unsigned long ret, halfhour;

		switch(DAC1CONbits.DACFDIV) {
		case 55:
			mul = 40;
			sr = 11025;
			break;
		case 27:
			mul = 20;
			sr = 22050;
			break;
		default:
			mul = 10;
			sr = 44100;
			break;
		}

		ret = 0;
		halfhour = (unsigned long)sr * 30 * 60;
		while( samples > halfhour ) {
			ret += 30L*60L*1000L;
			samples -= halfhour;
		}
		return ret + samples * mul / 441;
	} else if( CLKDIVbits.PLLPRE == 6 ) {
		unsigned char div;
		switch(DAC1CONbits.DACFDIV) {
		case 51:
			div = 12;
			break;
		case 25:
			div = 24;
			break;
		default:
			div = 48;
			break;
		}
		return samples / div;
	} else {
		return samples / 32;
	}
}

unsigned char is_valid_sample_rate(unsigned short rate) {
	switch(rate) {
	case 11025:
	case 22050:
	case 44100:
	case 12000:
	case 24000:
	case 32000:
	case 48000:
		return 1;
	}
	return 0;
}

unsigned char set_sample_rate(unsigned short rate) {
	unsigned char paused = !DAC1CONbits.DACEN;
	unsigned char ret = 1;
	DAC1CONbits.DACEN = 0;    // disable DAC
	TCONname(DAC_TIMER).TON = 0;

	switch(rate) {
	case 11025:
	case 22050:
	case 44100:
		if( CLKDIVbits.PLLPRE != 14 ) {
		    __builtin_write_OSCCONH(0x02); // switch to crystal oscillator
		    __builtin_write_OSCCONL(0x01);

		    // set PLL to get Fcy which is close to an integer multiple of 44.1kHz * 64 (24.576MHz / 16 * 103 / 4 / 2 = 39.552MHz)
			CLKDIVbits.PLLPRE = 14;
			CLKDIVbits.PLLPOST = 0;
    		PLLFBD = 101;

		    __builtin_write_OSCCONH(0x03); // switch back to PLL
		    __builtin_write_OSCCONL(0x01);
		}
		switch(rate) {
		case 11025:
		    DAC1CONbits.DACFDIV = 55; // divide clock by 56
			break;
		case 22050:
		    DAC1CONbits.DACFDIV = 27; // divide clock by 28
			break;
		default:
		    DAC1CONbits.DACFDIV = 13; // divide clock by 14
			break;
		}
		break;
	case 12000:
	case 24000:
	case 48000:
		if( CLKDIVbits.PLLPRE != 6 ) {
		    __builtin_write_OSCCONH(0x02); // switch to crystal oscillator
		    __builtin_write_OSCCONL(0x01);

		    // set PLL to get Fcy which is an integer multiple of 48kHz * 64 (24.576MHz / 8 * 52 / 2 / 2 = 39.936MHz)
			CLKDIVbits.PLLPRE = 6;
			CLKDIVbits.PLLPOST = 0;
    		PLLFBD = 50;

		    __builtin_write_OSCCONH(0x03); // switch back to PLL
		    __builtin_write_OSCCONL(0x01);
		}
		switch(rate) {
		case 12000:
		    DAC1CONbits.DACFDIV = 51; // divide clock by 52
			break;
		case 24000:
		    DAC1CONbits.DACFDIV = 25; // divide clock by 26
			break;
		default:
		    DAC1CONbits.DACFDIV = 12; // divide clock by 13
			break;
		}
		break;
	case 32000:
		if( CLKDIVbits.PLLPRE != 10 ) {
		    __builtin_write_OSCCONH(0x02); // switch to crystal oscillator
		    __builtin_write_OSCCONL(0x01);

		    // set PLL to get Fcy which is an integer multiple of 32kHz * 64 (24.576MHz / 12 * 76 / 2 / 2 = 38.912MHz)
			CLKDIVbits.PLLPRE = 10;
			CLKDIVbits.PLLPOST = 0;
    		PLLFBD = 74;

		    __builtin_write_OSCCONH(0x03); // switch back to PLL
		    __builtin_write_OSCCONL(0x01);
		}
	    DAC1CONbits.DACFDIV = 18; // divide clock by 19
		break;
	default:
		ret = 0;
		break;
	}

	PRname(DAC_TIMER) = 128*(DAC1CONbits.DACFDIV+1);
	DAC1CONbits.DACEN = !paused; // re-enable DAC unless it is paused
	TCONname(DAC_TIMER).TON = !paused;
	return ret;
}

void init_dac(void) {
	DACBuffer = (signed short*)malloc(512*DAC_BUFFER_PAGES);

	/* DMA Channel 0 set to DAC1RDAT */
	DMA0CONbits.MODE = 2; /* Continuous Mode with Ping-Pong Enabled */
	DMA0CONbits.DIR = 1;  /* Ram-to-Peripheral Data Transfer */
	DMA0PAD = (volatile unsigned int)&DAC1RDAT; /* Point DMA to DAC1RDAT */
	DMA0CNT = 127; /* 128 DMA Request */
	DMA0REQ = 78; /* Select DAC1RDAT as DMA Request Source */
	DMA0STA = __builtin_dmaoffset(DMA_DACBufferRA);
	DMA0STB = __builtin_dmaoffset(DMA_DACBufferRB);
	IFS0bits.DMA0IF = 0; /* Clear DMA Interrupt Flag */
	IEC0bits.DMA0IE = 1; /* Set DMA Interrupt Enable Bit */
	DMA0CONbits.CHEN = 1; /* Enable DMA Channel 0 */
	/* DMA Channel 1 set to DAC1LDAT */
	DMA1CONbits.MODE = 2; /* Continuous Mode with Ping-Pong Enabled */
	DMA1CONbits.DIR = 1; /* Ram-to-Peripheral Data Transfer */
	DMA1PAD = (volatile unsigned int)&DAC1LDAT; /* Point DMA to DAC1LDAT */
	DMA1CNT = 127; /* 128 DMA Request */
	DMA1REQ = 79; /* Select DAC1LDAT as DMA Request Source */
	DMA1STA = __builtin_dmaoffset(DMA_DACBufferLA);
	DMA1STB = __builtin_dmaoffset(DMA_DACBufferLB);
	IFS0bits.DMA1IF = 0; /* Clear DMA Interrupt Flag */
	IEC0bits.DMA1IE = 0; /* Clear DMA Interrupt Enable Bit */
	DMA1CONbits.CHEN = 1; /* Enable DMA Channel 1 */

    ACLKCONbits.ASRCSEL = 1;  // set primary oscillator as source for the reference clock
    ACLKCONbits.APSTSCLR = 7; // no clock division
    ACLKCONbits.SELACLK = 0;  // enable auxilliary clock

    DAC1STATbits.LOEN = 1;    // enable left channel output
    DAC1STATbits.ROEN = 1;    // enable right channel output
	DAC1STATbits.RITYPE = 1;  // Right Channel Interrupt if FIFO is Empty
	DAC1STATbits.LITYPE = 1;  // Left Channel Interrupt if FIFO is Empty
    DAC1CONbits.DACFDIV = 11; // divide clock by twelve
    DAC1CONbits.FORM = 1;     // signed integer

#ifdef INIT_DAC_RUNNING
    DAC1CONbits.DACEN = 1;    // enable DAC
#endif

	TIMERname(DAC_TIMER) = 0;
	PRname(DAC_TIMER) = 128*(DAC1CONbits.DACFDIV+1);
#ifdef INIT_DAC_RUNNING
	TCONname(DAC_TIMER).TON = 1;
#endif
}

void __attribute__((__interrupt__, no_auto_psv)) _DMA0Interrupt(void) {
	unsigned char i;
	signed short* dest1 = DMACS1bits.PPST0 ? DMA_DACBufferLA : DMA_DACBufferLB;
	signed short* dest2 = DMACS1bits.PPST0 ? DMA_DACBufferRA : DMA_DACBufferRB;
	signed short* src = DACBuffer+DACBuffer_readpos;
	i = 128/8;
	while( i-- ) {
		dest1[0] = src[ 0];
		dest2[0] = src[ 1];
		dest1[1] = src[ 2];
		dest2[1] = src[ 3];
		dest1[2] = src[ 4];
		dest2[2] = src[ 5];
		dest1[3] = src[ 6];
		dest2[3] = src[ 7];
		dest1[4] = src[ 8];
		dest2[4] = src[ 9];
		dest1[5] = src[10];
		dest2[5] = src[11];
		dest1[6] = src[12];
		dest2[6] = src[13];
		dest1[7] = src[14];
		dest2[7] = src[15];
		dest1 += 8;
		dest2 += 8;
		src += 16;
	}
/*
	              dest = DMACS1bits.PPST1^(DAC1CONbits.DACFDIV == 55) ? DMA_DACBufferLA : DMA_DACBufferLB;
	              src = DACBuffer+DACBuffer_readpos;
	i = 128/8;
	while( i-- ) {
		dest[0] = src[ 0];
		dest[1] = src[ 2];
		dest[2] = src[ 4];
		dest[3] = src[ 6];
		dest[4] = src[ 8];
		dest[5] = src[10];
		dest[6] = src[12];
		dest[7] = src[14];
		dest += 8;
		src += 16;
	}
*/
	asm volatile("disi #12");
//	DAC_read |= 1;
//	if( DAC_read == 3 ) {
		DACBuffer_readpos += 256;
		if( DACBuffer_readpos == 256*DAC_BUFFER_PAGES )
			DACBuffer_readpos = 0;
		DACBuffer_full = 0;
		DAC_read = 0;
		sample_timer += 128;
//	}
	asm volatile("disi #0");
	IFS0bits.DMA0IF = 0;
}
void __attribute__((__interrupt__, no_auto_psv)) _DMA1Interrupt(void) {
	IFS0bits.DMA1IF = 0;
/*
	unsigned char i;
	// It is weird, but when the DAC clock divider passes 50, the right channel's DMA buffer bit (PPST0) is still correct but the right channel's is inverted.
    // This is presumably due to the fact that the DAC isn't reading data from the DMA as fast. Inverting the bit in this case keeps the channels in phase.
	signed short* dest = DMACS1bits.PPST1^(DAC1CONbits.DACFDIV == 55) ? DMA_DACBufferLA : DMA_DACBufferLB;
	signed short* src = DACBuffer+DACBuffer_readpos;
	IFS0bits.DMA1IF = 0;
	i = 128/8;
	while( i-- ) {
		dest[0] = src[ 0];
		dest[1] = src[ 2];
		dest[2] = src[ 4];
		dest[3] = src[ 6];
		dest[4] = src[ 8];
		dest[5] = src[10];
		dest[6] = src[12];
		dest[7] = src[14];
		dest += 8;
		src += 16;
	}
	asm volatile("disi #12");
	DAC_read |= 2;
	if( DAC_read == 3 ) {
		DACBuffer_readpos += 256;
		if( DACBuffer_readpos == 256*DAC_BUFFER_PAGES )
			DACBuffer_readpos = 0;
		DACBuffer_full = 0;
		DAC_read = 0;
		sample_timer += 128;
	}
	asm volatile("disi #0");
*/
}

unsigned char is_dac_running() {
	return DAC1CONbits.DACEN;
}
