; Projector lock


	list P=16F88
	#include p16f88.inc
	ERRORLEVEL -302
	ERRORLEVEL -306

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _HS_OSC

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

	
; Bank 0 RAM
DIGITAL0	equ	H'20'
DIGITAL1	equ	H'21'	
TEMP		equ H'22'
TEMP2		equ	H'23'

; start at memory 0
	org	0	; reset vector
	goto	SETUP
	org 4	; interrupt vector
; start interrupt save w and status register
INTERRUPT
	bcf		T1CON,0			; timer off
; if overflow then no motor drive
	btfsc	PIR1,TMR1IF		; overflow flag
	goto	OVER

	clrf	TMR1H
	movlw	D'9'			; compensate for timer loss of count 
	movwf	TMR1L
	bsf		T1CON,0			; restart timer
	bcf		PIR1,CCP1IF		; clear flag

; compare values
; 50Hz.
; 16fps (set to 16.666fps)and 3-blade shutter, interrupter output is 3 x 16.666Hz. = 50Hz
; 24fps (set to 25fps) and 2-blade shutter, interrupter output is 2 x 25Hz. = 50Hz
; 50Hz is  a 20ms period.
; 
; timer1 prescaler is /8 and 5MHz clock (625kHz)and capture each 4th edge so 4 x 20ms x (5MHz/8)= 50000 
; D50000 (HC350) counts of 65536 maximum

; For different lock frequency to 50Hz change where marked (*^)
; subtact HC350

	movf	CCPR1H,w		; high byte of captured
;(*^)
	sublw	H'C3'			; take from 
	movwf	DIGITAL0		; store
	movf	CCPR1L,w		; low byte
;(*^)
	sublw	H'50'			; 
	btfss	STATUS,C
	decf	DIGITAL0,f		; decrease if required 
	movwf	DIGITAL1
	btfss	DIGITAL0,7		; when set captured is larger
	goto	LOWER

; Larger so swap subtraction
;(*^)
	movlw	H'C3'			; high byte 
	subwf	CCPR1H,w		; take from high byte of captured
	movwf	DIGITAL0		; store
;(*^)
	movlw	H'50'			; low byte
	subwf	CCPR1L,w			; 
	btfss	STATUS,C
	decf	DIGITAL0,f		; decrease if required 
	movwf	DIGITAL1
; <1
	movlw	H'00'			; high byte 
	subwf	DIGITAL0,w		; take from high byte
	movwf	TEMP 
	movlw	H'2'			; low byte
	subwf	DIGITAL1,w			; 
	btfss	STATUS,C
	decf	TEMP,f			; decrease if required 
	btfss	TEMP,7			; if set value smaller than 10
	goto	TEST_10


	movlw	B'00001000'		; lock LED
	movwf	PORTA

; motor off

	movlw	B'10010000'		; RB5, RB6 low, RB4, RB7 high
	movwf	PORTB
	goto 	RECLAIM			;


TEST_10
	movlw	H'01'			; high byte 
	subwf	DIGITAL0,w		; take from high byte
	movwf	TEMP 
	movlw	H'3F'			; low byte
	subwf	DIGITAL1,w		; 
	btfss	STATUS,C
	decf	TEMP,f			; decrease if required 
	btfss	TEMP,7			; if set value smaller 
	goto	TEST_100

; motor
	movlw	B'00110000'		; RB7, RB6 low, RB4, RB5 high
	movwf	PORTB
; LEDs	
	movlw	B'00011000'		; Fast LED and lock
	movwf	PORTA

; delay
	movlw	D'10'
	movwf	TEMP
DEL_LOOP2
	movlw	D'255'
	movwf	TEMP2
DEL_LOOP1
	decfsz	TEMP2,f
	goto	DEL_LOOP1
	decfsz	TEMP,f
	goto	DEL_LOOP2	

; motor off

	movlw	B'10010000'		; RB5, RB6 low, RB4, RB7 high
	movwf	PORTB
	goto 	RECLAIM	

; 
TEST_100
; motor
	movlw	B'00110000'		; RB7, RB6 low, RB4, RB5 high
	movwf	PORTB
; LEDs	
	movlw	B'00010000'		; Fast LED
	movwf	PORTA	

	goto 	RECLAIM		

; *********************

LOWER
	movlw	H'00'			; high byte 
	subwf	DIGITAL0,w		; take from high byte
	movwf	TEMP 
	movlw	H'2'			; low byte
	subwf	DIGITAL1,w			; 
	btfss	STATUS,C
	decf	TEMP,f			; decrease if required 
	btfss	TEMP,7			; if set value smaller than 2
	goto	TEST_10S

; motor off

	movlw	B'10010000'		; RB5, RB6 low, RB4, RB7 high
	movwf	PORTB
; LEDs
	movlw	B'00001000'		; Lock LED
	movwf	PORTA
	goto 	RECLAIM		;

TEST_10S

	movlw	H'01'			; high byte 
	subwf	DIGITAL0,w		; take from high byte
	movwf	TEMP 
	movlw	H'3F'			; low byte
	subwf	DIGITAL1,w			; 
	btfss	STATUS,C
	decf	TEMP,f			; decrease if required 
	btfss	TEMP,7			; if set value smaller 
	goto	TEST_100S	


; motor run
	movlw	B'11000000'		; RB5, RB4 low, RB6, RB7 high
	movwf	PORTB
; LEDs
	movlw	B'00001100'		; Slow LED and lock
	movwf	PORTA

; delay

	movlw	D'10'
	movwf	TEMP
DEL_LOOP4
	movlw	D'255'
	movwf	TEMP2
DEL_LOOP3
	decfsz	TEMP2,f
	goto	DEL_LOOP3
	decfsz	TEMP,f
	goto	DEL_LOOP4

; motor off

	movlw	B'10010000'		; RB5, RB6 low, RB4, RB7 high
	movwf	PORTB
	goto	RECLAIM

TEST_100S
; motor run
	movlw	B'11000000'		; RB5, RB4 low, RB6, RB7 high
	movwf	PORTB
; LEDs
	movlw	B'00000100'		; Slow LED
	movwf	PORTA
	goto	RECLAIM


OVER
	bcf		PIR1,TMR1IF		; overflow
	clrf	TMR1L
	clrf	TMR1H
	bsf		T1CON,0			; restart timer
; motor off
	movlw	B'10010000'		; RB5, RB6 low, RB4, RB7 high
	movwf	PORTB
	movlw	B'00000000'		; no LEDs
	movwf	PORTA	 

RECLAIM
	retfie				; return from interrupt


; **********************************************************************************************

SETUP
	
	clrf	PORTB		; port B outputs low
	clrf	PORTA		; port A output low
	bsf		STATUS,RP0	; select memory bank 1

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'00000001'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'00000000'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	bcf		STATUS,RP0	; select memory bank 0
	
; initial conditions

	
; TIMER1 mode resets
	movlw	B'00000110'		; capture every 4th rising edge
	movwf	CCP1CON
	bcf		T1CON,0			; stop timer
	clrf	TMR1H			; ms byte of timer 1
	clrf	TMR1L			; timer ls byte
	movlw	B'00110000'		; timer 1 divide by 8
	movwf	T1CON
	bsf		T1CON,0			; restart timer

; enable interrupts
	
	bsf		STATUS,RP0	; select memory bank 1

	bsf		PIE1,CCP1IE	; capture compare interrupt
	bsf		PIE1,TMR1IE	; timer overflow
	bcf		STATUS,RP0	; select memory bank 0
	
	bsf		INTCON,PEIE	; enable peripheral interrupts
	bsf		INTCON,GIE	; global interrupt enable

CYCLE	
	goto	CYCLE
 
	end
