'                    LEDS AND LADDERS 2010.(SEVEN LED DISPLAY)          
'                               FOR THE PICAXE 14M               

' -----------------------------------------------------------------------------
' You can choose a normal game (no test link) or an easy game (fit test link).
' Turn power ON and the climb LED and the lower ladder LED will begin flashing.
' You will climb the ladder by pushing the climb button while the LEDs are ON.
' You will fall down the ladder by pushing the button while the LEDs are OFF.
' Climbing up the ladder will take many more button presses than falling down.
' It will become harder to climb and easier to fall near the top of the ladder.
' Keep climbing (even after the top LED is ON) untill the game over tune plays.
' To play again (after tune ends) press the button untill the lower LED lights.
' Or turn the power OFF to end this game or OFF then ON again for a new game.     
' ----------------------------------------------------------------------------- 
               

set_up: '-------- begin by initialising picaxe and checking the test link ------
low portc 3:low portc 4: low portc 5: b3 = 20
if input3 = 1 then: b3 = 40: endif
pause 400


display_on: '---- monitor capacitor voltage and display for 400 or 800 ms  ----
for b2 = 1 to b3
readadc 4,b1
if b1 > 198 then: pinsc = 0: pins =  4: endif '  (top Led)                   
if b1 > 180 and b1 < 199 then: pinsc =  0: pins =  8: endif 
if b1 > 162 and b1 < 181 then: pinsc =  0: pins = 16: endif
if b1 > 135 and b1 < 162 then: pinsc =  0: pins = 32: endif
if b1 >  99 and b1 < 136 then: pinsc =  8: pins =  0: endif
if b1 >  54 and b1 < 100 then: pinsc = 16: pins =  0: endif
if b1 <  55 then: pinsc = 32: pins = 0: endif '  (bot LED)
pause 20
next b2


'display_off: ---- play the tune (see next note) or blank display for 500ms -----
pinsc = 0 :pins = 2
if b1 > 205 then: goto muppets_tune: endif
pause 500
goto display_on


muppets_tune: '--- will play tune when ADC value exceeds 205 - top LED is on. ----
pinsc = 0: pins = 6 
tune 0,5,($2C,$24,$24,$27,$25,$64,$25,$40,$60,$62,$24,$64,$64,$6C,$64,$27)


soft_reset: ' --- after the tune plays - press button until bottom LED is on. ----
readadc 4,b1
if b1 < 10 then: goto set_up: endif
pause 10
goto soft_reset

'  NOTE: alternate "hard reset" method - turn the power switch OFF then ON again. 
'                           (can be used at any time).

'---------------------------------------------------------------------------------
' b1 = AD converter      0 to 255     measures main capacitor voltage.
' b2 = for next loop     1 to  b3     display ADC value on the LED display.
' b3 = step number       20 or 40     normal (20) or test (40) steps in b2.
'---------------------------------------------------------------------------------
