' Pyschological Type Test
'------------------------
' Author: Graeme Anderson
' Date:   Nov-2012
'------------------------
Option BASE 1

' The questions
Data "Do you believe that an element of risk adds spice to life"
Data "Can you honestly say that you honour your commitments more than most people"
Data "Do you spontaneously introduce yourself to strangers at social gatherings"
Data "Do you often discuss causes of and solutions to social and political problems with your friends"
Data "Do you often feel depressed when you wake up in the mornings"
Data "Would you say that you seldom ever lose sleep over your worries"
Data "Do you often suffer from poor appetite"
Data "Are you usually calm and not easily upset"
Data "If you read something containing spelling and punctuation errors, do you find it difficult to concentrate on the content of the text"
Data "Do you take steps to control your health by exercise or diet"
Data "Is your skin very sensitive and tender"
Data "Occasionally do you think you have let down your parents by the life you have led"
Data "Would being in debt worry you"
Data "Do you like to be in the middle of things socially speaking"
Data "Would you rather see a comedy than a documentary on TV"
Data "At work or at play do other people find it hard to keep up with you"
Data "Are you rather cautious in novel situations"
Data "Are you very sensitive to beauty in your surroundings"
Data "Do you believe that it is necessary to fight for your rights or you risk losing them altogether"
Data "Do you have any tendency towards laziness"
Data "Do you sometimes tell people what they want to hear so that they will be more receptive to you"
Data "Would you take drugs that may cause hallucinations and other side effects"
Data "Do you like to watch boxing or wrestling matches on TV"
Data "Do you tend to do things immediately rather than put them off until later"
Data "Do you think that it is probably a waste of time going to the doctor with most mild complaints such as coughs, colds and the flu"
Data "Do you routinely check that all the lights, taps and appliances are off before you go to bed"
Data "If something goes wrong do you usually attribute it to bad luck rather than bad management"
Data "Does it concern you a great deal that you are living better than the majority of people in the world"
Data "Do you think that people really don't care what happens to you"
Data "Do you keep a supply of tinned or dried food in your house in case of an emergency food shortage"
Data "Is there something you have done that you will regret all your life"
Data "Do you have a great deal of confidence in your decisions"
Data "Do you often feel down in the dumps"
Data "Do you like highly coloured modern paintings more than discreet classical works"
Data "Do you get bored doing the same old things more easily than most people"
Data "Do you get very upset if someone criticises you"
Data "Are you always careful to pay back even the most trivial debt"
Data "Do you often feel that you have little influence over the things that happen to you"
Data "Does stomach trouble run in your family"
Data "Do you like to have time to be alone with your thoughts"
Data "Are you inclined to be overconscientious"
Data "Do you become restless when working at something in which there is very little action"
Data "Do you usually make up your mind quickly"
Data "If you are watching a funny play or film do you laugh louder than most of the people around you"
Data "Are you normally punctual"
Data "Do you generally prefer reading to meeting people"
Data "Do you lock up your house carefully at night"
Data "Do you live by the maxim that a job worth doing is worth doing right"
Data "Would you prefer a job involving change, travel and variety even though it were risky and insecure"
Data "Do you like planning things well in advance"
Data "Are you appalled by the ignorance shown by most people on social and political matters"
Data "Do you prefer to let an escalator carry you along without walking yourself"
Data "Do you think you are able to do things as well as most other people"
Data "Do you usually feel well and strong"
Data "Is there some habit such as smoking that you would like to break but cannot"
Data "Do you enjoy solitary activities such as playing patience and solving crosswords"
Data "Would you find it impossible to make a speech off the cuff"
Data "Did you occasionally play truant in your school days"
Data "Would you always read the small print before signing a contract"
Data "Do you prefer to 'sleep on it' before making decisions"
Data "Sometimes, do you feel that you have so many difficulties that you cannot possible overcome them"
Data "Do you believe that your personality was so firmly shaped as a child that there isn't much you can do to change it"
Data "Are you occasionally bothered by an unimportant thought that runs through your  mind for days"
Data "Do you have more headaches than most people"
Data "Do you often feel a strong need to confess something that you have done"
Data "Are you likely to swear loudly if you trip over something or hit your finger with a hammer"
Data "Do you like work that involves action rather than profound thought and study"
Data "Do you enjoy entertaining people"
Data "Are you bored by museums that feature archaeology and classical history"
Data "Do you normally do things at a rapid rate"
Data "Would you rather watch sports than play them"
Data "Would you go out of your way to find a garbage can rather than throw a wrapper on the street"
Data "Are you hesitant to ask strangers for a street direction"
Data "Is life a strain for you"
Data "Do you have regular dental check-ups"
Data "Do you sometimes feel a twitching on the face, head, or shoulders"
Data "Do you often feel that people disapprove of you"
Data "Would you be troubled by feelings of inadequacy if you had to make a speech"
Data "Are you obsessional about locking up drawers, windows, suitcases, etc."
Data "Do you place your trust in supernatural powers such as God or fate to see you through safely"
Data "Do you see your future as looking quite bright"
Data "Are you sometimes disgusted by your own sexual desires and fantasies"
Data "Do you think your personality is attractive to the opposite sex"
Data "Do you spend a great deal of time arranging your papers so you will know where everything is if you need it"
Data "Do other people usually decide what play or film you are going to see"
Data "Do you expect God will punish you for your sins in the after-life"
Data "Does advertising sometimes influence you to buy something you don't really want"
Data "Do you usually blame yourself if something goes wrong with your personal relationships"
Data "Do you often feel lonely even when you are with other people"
Data "Have you ever felt you needed to take tranquillizers"
Data "Do you read horoscopes with the hope of obtaining some guidance in your life"
Data "Do you prefer activities that just happen to those planned in advance"
Data "Do you analyse new ideas that you come across to see how they fit in with your own point of view"
Data "Do you generally have a serious and responsible attitude toward the world"
Data "When you meet new people do you decide very quickly whether you like them or not"
Data "Would it be easy for you to be friendly with people of all religions"
Data "Do you enjoy helping other people"
Data "Do you like plenty of bustle and excitement going on around you"
Data "Are you curious about how engines and other mechanical devices work"
Data "If someone does you a bad turn do you feel obliged to do something about it"
Data "Do you find it difficult to stop once you get wound up in a heated discussion"
Data "Do you enjoy taking part in rough physical activity"
Data "Do you have very clear ideas about what is right and wrong"
Data "Do you feel like crying if you see a sad film"
Data "Do you make a point of complaining if you are sold shoddy goods"
Data "Do creepy-crawly things like worms and spiders frighten you"
Data "Do you believe that it is naive and dangerous to place your complete trust in another person"
Data "Do the laws of physics interest you more than personal relationships"
Data "Are you intimidated by people in authority"
Data "Do you sometimes use flattery consciously to help you gain your own ends"
Data "When you were a child did you usually do as you were told"
Data "When on holidays do you often wish you were back at work"
Data "Do you believe it is necessary to cut corners here and there in order to get on in the world"
Data "Do you worry a lot about other members of your family getting ill"
Data "If you have done something morally wrong can you quickly forget it and get on with other things"
Data "Do you usually feel able to accomplish the things you want to do"
Data "Are you content with your appearance"
Data "Would you probably remain calm and collected in the face of an emergency"
Data "Do you make a point of writing down all your appointments even things that you have to do later the same day"
Data "Do you enjoy watching competitive physical sports such as boxing and football"
Data "If someone annoys you do you usually tell him in no uncertain terms what you think of him"
Data "Do you try to enjoy your work from day to day rather than striving to improve your position"
Data "Would you rather mix with people of your own kind than with foreigners with strange customs"
Data "When you are working on an important job do you find it hard to concentrate on what people are saying to you"
Data "Do you rely on intuition as a guide as to whether or not a person is trustworthy"
Data "Are you drawn toward those who are sick or unfortunate"
Data "Would you be more upset by losing valuable property than on hearing that a friend was seriously ill"
Data "Do you think that if someone is rude to you it is better to let it pass"
Data "If someone went to the front of a lineup out of turn would you do something about it"
Data "Do you like to be in a climate that has very even temperatures"
Data "Would you ask someone smoking to stop if it was annoying you"
Data "Is your preference a quiet restful holiday rather than a lot of rushing about"
Data "Do you always wear a seat belt in a car"
Data "Do you usually move about at a leisurely pace"
Data "Are other people unsympathetic when you are feeling unwell"
Data "When other people complement you do you find it difficult to believe that they are being sincere"
Data "Would you say that you are contributing to the world and leading a useful life"
Data "Is there at least one person in the world who really loves you"
Data "Are you considered an easy-going person"
Data "Are you frequently lacking in energy and motivation to do things"
Data "Do you often do things on the spur of the moment"
Data "Do you find it easy to discuss intimate and personal matters with members of your family"
Data "Are you apprehensive when you are about to enter a room full of strangers"
Data "Have you ever performed in amateur drama or music productions"
Data "Would you find a transfer to a another part of the world difficult"
Data "If you met a conceited and domineering person would you be inclined to put him in his place"
Data "Do you prefer to mix with people who can help you make your way in the world"
Data "Would you befriend someone you really didn't like if you thought he might be a useful contact"
Data "Would you enjoy a life of peace and serenity"
Data "Do you think there is a kernal of truth in nearly everybody's point of view"
Data "Do you often leave things until the last minute"
Data "Would you find it difficult to get rid of a persistent salesman who is wasting your time"
Data "Are things changing so fast today that you find it difficult to know what rules to follow"
Data "Do you always go straight to bed if you catch a cold"
Data "Would you say you were self-conscious"
Data "Do you often get the feeling that you just are not part of things"
Data "Do you often arrive at the last minute to catch a train"
Data "Would a life with no dangers in it be too dull a life for you"
Data "Can you make decisions quickly"
Data "Do you consider that your temper is well controlled"
Data "Are you always 'on the go' when not actually sleeping"
Data "Do you often feel listless and tired for no good reason"
Data "When you make an awkward social error can you easily forget it"
Data "Do you keep very careful accounts of all the money you spend"
Data "Sometimes does your anger lead you to break, hit, or throw things around the house"
Data "If you were poorly served in a restaurant or hotel do you prefer to let it pass rather than make a fuss"
Data "Do you attempt to convert others to your own point of view on matters of religion, morality and politics"
Data "Sometimes do you say shocking things just to see others reactions"
Data "Do you feel that you often get blamed or punished when you don't deserve it"
Data "Would you say you often worry unreasonably over things that do not really matter"
Data "Would you say that you smile and laugh as much as most people"
Data "Do you enjoy solving 'brain teasers'"
Data "Do you enjoy spending long periods of time by yourself"
Data "Would you rather listen to early classical music than to swinging jazz"
Data "Do you find yourself frequently becoming so involved with a problem that you keep thinking about it until you solve it"
Data "Would you say that you are generally very enthusiastic about starting a new project"
Data "Do you find that you are relaxed and self-confident in the company of others"
Data "Would you make quite sure that you had another job before giving up your old one"
Data "Do you collect all kinds of scrap material in case they may be useful someday"
Data "Are you shy and self-conscious in social situations"
Data "If things don't go as planned are you easily 'rattled'"
Data "Do you have a tendency to feel below the people you meet even though you are not outranked"
Data "Do you get very frustrated by slow-moving traffic while driving"
Data "Are you fairly talkative when with a group of people"
Data "Do you carefully consider all the advantages and disadvantages before making up your mind"
Data "Do sentimental films move you easily to tears"
Data "Do you often try to find the underlying motives for people's actions"
Data "Can you usually let yourself go and have a good time at a party"
Data "Do you often find yourself buying things on impulse"
Data "Would you rather read the sports section than the editorials in the newspaper"
Data "Does your blood boil when people stubbornly refuse to admit that they are wrong"
Data "Would you rather take orders than give them"
Data "Do you sometimes feel like picking a fight with someone"
Data "Do you enjoy Mozart better than Wagner"
Data "Do you think that other cultures have a lot to teach us about how to live"
Data "Is the shooting gallery one of your favourite carnival attractions"
Data "Do you really enjoy science fiction"
Data "Do you hesitate to ask a stranger for street directions"
Data "Would you say a good teacher is the one who makes you wonder rather than the one who tells you all the answers"
Data "Do you find it difficult to resist cuddling small furry animals"
Data "Can you usually manage to be patient even with fools"
Data "Are you satisfied with your present salary"
Data "Do you think most politicians talk a load of rubbish"
Data "Do you often compare your performance and ability on the job with that of other people's"
Data "Are you generally cool and detached in dealing with other people"
Data "Would you consider going to a wife/husband swapping party"
Data "Do you lose your temper less often than most people"
Data "Does your work excite you so much that it sometimes keeps you awake at night"
Data "Does a sense of fair play restrict your business acumen"
Data "Do you prefer quiet and discreet paintings to vivid and shocking ones"

' Start of Program
'-----------------

Cls
Font #2
Print "Psycological Type Test"
Print "______________________"
Font #1

Print ""
Print "The following test will take about 15 minutes of your time to complete."
Print ""
Print "The test consists of several questions to be answered by entering:  Y for Yes,"
Print "N for No or ? if unsure."
 Print "You will find this test a sensitive instrument for the mapping of your own"
Print "individual personality.   Based on the latest research in this exact science,"
Print "the questions have been meticulously chosen to give you an infallibly accurate"
Print "reflection of your precise personality.   No doubt, in return, your answers"
Print "will be scrupulously honest."
Print ""
Print "Enter YES when you are ready to start: ";
Ans$ = GetAnswer$(0)
Print Chr$(10)

If Ans$ = "Y" Then
  Answers$ = ""

  For i = 1 To 210
    Read Question$

    Font #1,,1 ' reverse video
    Print "Question "; Format$(i); " of 210"
    Font #1

    If Len(Question$)>76 Then
      j=77
      Do
        j=j-1
      Loop Until Mid$(Question$,j,1)=" "
      Print Left$(Question$,j)
      Question$=Right$(Question$,Len(Question$)-j)
    EndIf

    Print Question$ + "? ";
    Ans$ = GetAnswer$(0)
    Print Ans$ + Chr$(10)

    ' save the answers for later processing
    Answers$ = Answers$ + Ans$
  Next

  InterpretTheAnswers
  DisplayResults
EndIf

End
'-----------------------------

Function GetAnswer$(dummyArg)
  Do
    Char$ = UCase$(Inkey$)
  Loop Until Char$ = "Y" Or Char$ = "N" Or Char$ = "?"

  GetAnswer$ = Char$
End Function

Sub InterpretTheAnswers(dummyArg)
  Dim ScoreAmt(3, 7) ' score amount table
  Dim lim(3, 7, 3, 3)
  Dim vae(3, 7, 3, 3)
  Dim sval(3, 7)
  Dim tval(3)
  Dim lab1$(3), lab2$(3), tlab1$(3), tlab2$(3)
  Dim stm$(3, 7), estmt$(3, 7), tstmt2$(3)

  InitializeTables

  ' Scores by answer
  ScoreYN$ = "YNYNYNYNYNYYNYYYNNYNYYYYNYYYYYYNYYYYYYYNNYYYNNNNNNYNNNYNNYNN"
  ScoreYN$ = ScoreYN$ + "YYYYYYYYYYNNNYNYYYYYNYNYYYYYYYYYNNYNNYYYYYYNYNYYN"
  ScoreYN$ = ScoreYN$ + "YNYYYNYNNYYYNNYNNYNYNYNNNYYNNYNYYNYNYYYNNYNYYYYYY"
  ScoreYN$ = ScoreYN$ + "YNYYNYYNYYNYNNNNNYYNYYYYYYNYNYYYYNYNNYYNNNNNYNYYNYNN"

  ScoreI1$ = "111122222222111113333333222222222112222111111111113322211111"
  ScoreI1$ = ScoreI1$ + "2222211111111212222222222222222111133333333333333"
  ScoreI1$ = ScoreI1$ + "3333222222333333333333111222211111133333313222211"
  ScoreI1$ = ScoreI1$ + "1112223333222111111122221111111133333333333333333333"

  ScoreI2$ = "361526765473315731762456754325312241547567426136343617412634"
  ScoreI2$ = ScoreI2$ + "6457325157762667315423154343264456432415313171217"
  ScoreI2$ = ScoreI2$ + "2762731165156461225747737712267421245624367476233"
  ScoreI2$ = ScoreI2$ + "4272655734362512571351617142514537543517315636245624"

  ' process answers
  For iIndex = 1 To 210
    QuestVal = 0
    Ans$ = Mid$(Answers$,iIndex,1)
    ScoreAns$ = Mid$(ScoreYN$,iIndex,1)

    If Ans$ = "Y" Then
      If ScoreAns$ = "Y" Then QuestVal = 1
    ElseIf Ans$ = "N" Then
      If ScoreAns$ = "N" Then QuestVal = 1
    ElseIf Ans$ = "?" Then
     ScoreVal = 0.5
    EndIf

    ' accumulate score
    I1 = Val(Mid$(ScoreI1$,iIndex,1))
    I2 = Val(Mid$(ScoreI2$,iIndex,1))
    ScoreAmt(I1, I2) = ScoreAmt(I1, I2) + QuestVal
  Next
End Sub

Sub InitializeTables(dummyArg)

  ' load summary table labels
  tstmt2$(1) = "introverted|Introversion / Extroversion|extraverted"
  tstmt2$(2) = "well adjusted|Emotional Stability|maladjusted to life"
  tstmt2$(3) = "sensitive|Sensitivity|inseneitive"

  ' load summary statement table
  tlab1$(1) = "INTROVERSION": tlab2$(1) = "EXTRAVERSION"
  lab1$(1) = "UNSOCIABLE|INHIBITED|CAUTIOUS|PRUDENT|PENSIVE|RESPONSIBLE|INACTIVE"
  lab2$(1) = "SOCIABLE|EMOTIONAL|DARING|IMPULSIVE|PRACTICAL|IRRESPONSIBLE|ACTIVE"

  tlab1$(2) = "ADJUSTED":         tlab2$(2) = "MALADJUSTED"
  lab1$(2) = "SELF-CONFIDENT|HAPPY|CONSCIENCE-FREE|INDEPENDENT|CASUAL|CALM|HEALHY"
  lab2$(2) = "INFERIORITY|DEPRESSED|GUILT-RIDDEN|DEPENDENT|COMPULSIVE|NERVOUS|HYPOCHONDRIAC"

  tlab1$(3) = "SENSITIVE":      tlab2$(3) = "INSENSITIVE"
  lab1$(3) = "TENDER-MINDED|EMPATHETIC|FLEXIBLE|UNADVENTUROUS|GENTLE|UNAMBITIOUS|SUBMISSIVE"
  lab2$(3) = "TOUGH-MINDED|MANIPULATIVE|DOGMATIC|ADVENTUROUS|AGGRESSIVE|AMBITIOUS|ASSERTIVE"

  ' load extreme table
  estmt$(1, 1) = "||"
  estmt$(1, 2) = "||It is possible that you are emotionally unstable, hysterical."
  estmt$(1, 3) = "||You are pretty tough-minded."
  estmt$(1, 4) = "||"
  estmt$(1, 5) = "||"
  estmt$(1, 6) = "||Taken to the extreme you may be compulsive and obsessional."
  estmt$(1, 7) = "||"

  estmt$(2, 1) = "||Your inferiority complex may cause you many problems."
  estmt$(2, 2) = "||You may have a depressive illness."
  estmt$(2, 3) = "You may tend toward psychopathy.||You may be neurotic, possibly due to a strict religious background."
  estmt$(2, 4) = "You tend to be authoritarian.||Your submissiveness probably causes you problems."
  estmt$(2, 5) = "||This compulsiveness may incapacitate you."
  estmt$(2, 6) = "||"
  estmt$(2, 7) = "||You may be a hypochondriac."

  estmt$(3, 1) = "||"
  estmt$(3, 2) = "You may be naive and gullible.||"
  estmt$(3, 3) = "||"
  estmt$(3, 4) = "||"
  estmt$(3, 5) = "||"
  estmt$(3, 6) = "You may be apathetic, retiring and aimless.||"
  estmt$(3, 7) = "||You might be considered pushy."

  ' load limit table
  lim(1, 1, 1, 1) = 2.4: vae(1, 1, 1, 1) = -3: lim(1, 1, 1, 2) = 3.6: vae(1, 1, 1, 2) = -2: lim(1, 1, 1, 3) = 5.4: vae(1, 1, 1, 3) = -1
  lim(1, 1, 2, 1) = 6.4: vae(1, 1, 2, 1) = 0: lim(1, 1, 2, 2) = 6.4: vae(1, 1, 2, 2) = 0: lim(1, 1, 2, 3) = 6.4: vae(1, 1, 2, 3) = 0
  lim(1, 1, 3, 1) = 7.6: vae(1, 1, 3, 1) = 1: lim(1, 1, 3, 2) = 9.4: vae(1, 1, 3, 2) = 2: lim(1, 1, 3, 3) = 10.1: vae(1, 1, 3, 3) = 3

  lim(1, 2, 1, 1) = 1.6: vae(1, 2, 1, 1) = -3: lim(1, 2, 1, 2) = 2.6: vae(1, 2, 1, 2) = -2: lim(1, 2, 1, 3) = 3.6: vae(1, 2, 1, 3) = -1
  lim(1, 2, 2, 1) = 4.6: vae(1, 2, 2, 1) = 0: lim(1, 2, 2, 2) = 4.6: vae(1, 2, 2, 2) = 0: lim(1, 2, 2, 3) = 4.6: vae(1, 2, 2, 3) = 0
  lim(1, 2, 3, 1) = 6.4: vae(1, 2, 3, 1) = 1: lim(1, 2, 3, 2) = 7.6: vae(1, 2, 3, 2) = 2: lim(1, 2, 3, 3) = 10.1: vae(1, 2, 3, 3) = 3

  lim(1, 3, 1, 1) = 1.6: vae(1, 3, 1, 1) = -3: lim(1, 3, 1, 2) = 3.4: vae(1, 3, 1, 2) = -2: lim(1, 3, 1, 3) = 4.6: vae(1, 3, 1, 3) = -1
  lim(1, 3, 2, 1) = 6.4: vae(1, 3, 2, 1) = 0: lim(1, 3, 2, 2) = 6.4: vae(1, 3, 2, 2) = 0: lim(1, 3, 2, 3) = 6.4: vae(1, 3, 2, 3) = 0
  lim(1, 3, 3, 1) = 7.4: vae(1, 3, 3, 1) = 1: lim(1, 3, 3, 2) = 9.4: vae(1, 3, 3, 2) = 2: lim(1, 3, 3, 3) = 10.1: vae(1, 3, 3, 3) = 3

  lim(1, 4, 1, 1) = 2.4: vae(1, 4, 1, 1) = -3: lim(1, 4, 1, 2) = 4.4: vae(1, 4, 1, 2) = -2: lim(1, 4, 1, 3) = 5.6: vae(1, 4, 1, 3) = -1
  lim(1, 4, 2, 1) = 6.6: vae(1, 4, 2, 1) = 0: lim(1, 4, 2, 2) = 6.6: vae(1, 4, 2, 2) = 0: lim(1, 4, 2, 3) = 6.6: vae(1, 4, 2, 3) = 0
  lim(1, 4, 3, 1) = 7.6: vae(1, 4, 3, 1) = 1: lim(1, 4, 3, 2) = 9.4: vae(1, 4, 3, 2) = 2: lim(1, 4, 3, 3) = 10.1: vae(1, 4, 3, 3) = 3

  lim(1, 5, 1, 1) = 1.6: vae(1, 5, 1, 1) = -3: lim(1, 5, 1, 2) = 2.6: vae(1, 5, 1, 2) = -2: lim(1, 5, 1, 3) = 4.4: vae(1, 5, 1, 3) = -1
  lim(1, 5, 2, 1) = 5.4: vae(1, 5, 2, 1) = 0: lim(1, 5, 2, 2) = 5.4: vae(1, 5, 2, 2) = 0: lim(1, 5, 2, 3) = 5.4: vae(1, 5, 2, 3) = 0
  lim(1, 5, 3, 1) = 6.4: vae(1, 5, 3, 1) = 1: lim(1, 5, 3, 2) = 8.4: vae(1, 5, 3, 2) = 2: lim(1, 5, 3, 3) = 10.1: vae(1, 5, 3, 3) = 3

  lim(1, 6, 1, 1) = 1.6: vae(1, 6, 1, 1) = -3: lim(1, 6, 1, 2) = 3.4: vae(1, 6, 1, 2) = -2: lim(1, 6, 1, 3) = 5.4: vae(1, 6, 1, 3) = -1
  lim(1, 6, 2, 1) = 6.4: vae(1, 6, 2, 1) = 0: lim(1, 6, 2, 2) = 6.4: vae(1, 6, 2, 2) = 0: lim(1, 6, 2, 3) = 6.4: vae(1, 6, 2, 3) = 0
  lim(1, 6, 3, 1) = 7.4: vae(1, 6, 3, 1) = 1: lim(1, 6, 3, 2) = 9.4: vae(1, 6, 3, 2) = 2: lim(1, 6, 3, 3) = 10.1: vae(1, 6, 3, 3) = 3

  lim(1, 7, 1, 1) = 2.4: vae(1, 7, 1, 1) = -3: lim(1, 7, 1, 2) = 3.6: vae(1, 7, 1, 2) = -2: lim(1, 7, 1, 3) = 5.4: vae(1, 7, 1, 3) = -1
  lim(1, 7, 2, 1) = 6.4: vae(1, 7, 2, 1) = 0: lim(1, 7, 2, 2) = 6.4: vae(1, 7, 2, 2) = 0: lim(1, 7, 2, 3) = 6.4: vae(1, 7, 2, 3) = 0
  lim(1, 7, 3, 1) = 7.6: vae(1, 7, 3, 1) = 1: lim(1, 7, 3, 2) = 9.4: vae(1, 7, 3, 2) = 2: lim(1, 7, 3, 3) = 10.1: vae(1, 7, 3, 3) = 3

  lim(2, 1, 1, 1) = 0.6: vae(2, 1, 1, 1) = -3: lim(2, 1, 1, 2) = 1.4: vae(2, 1, 1, 2) = -2: lim(2, 1, 1, 3) = 2.4: vae(2, 1, 1, 3) = -1
  lim(2, 1, 2, 1) = 4.4: vae(2, 1, 2, 1) = 0: lim(2, 1, 2, 2) = 4.4: vae(2, 1, 2, 2) = 0: lim(2, 1, 2, 3) = 4.4: vae(2, 1, 2, 3) = 0
  lim(2, 1, 3, 1) = 6.4: vae(2, 1, 3, 1) = 1: lim(2, 1, 3, 2) = 8.4: vae(2, 1, 3, 2) = 2: lim(2, 1, 3, 3) = 10.1: vae(2, 1, 3, 3) = 3

  lim(2, 2, 1, 1) = 0.6: vae(2, 2, 1, 1) = -3: lim(2, 2, 1, 2) = 1.4: vae(2, 2, 1, 2) = -2: lim(2, 2, 1, 3) = 2.4: vae(2, 2, 1, 3) = -1
  lim(2, 2, 2, 1) = 4.4: vae(2, 2, 2, 1) = 0: lim(2, 2, 2, 2) = 4.4: vae(2, 2, 2, 2) = 0: lim(2, 2, 2, 3) = 4.4: vae(2, 2, 2, 3) = 0
  lim(2, 2, 3, 1) = 6.4: vae(2, 2, 3, 1) = 1: lim(2, 2, 3, 2) = 8.4: vae(2, 2, 3, 2) = 2: lim(2, 2, 3, 3) = 10.1: vae(2, 2, 3, 3) = 3

  lim(2, 3, 1, 1) = 0.6: vae(2, 3, 1, 1) = -3: lim(2, 3, 1, 2) = 1.4: vae(2, 3, 1, 2) = -2: lim(2, 3, 1, 3) = 2.4: vae(2, 3, 1, 3) = -1
  lim(2, 3, 2, 1) = 4.4: vae(2, 3, 2, 1) = 0: lim(2, 3, 2, 2) = 4.4: vae(2, 3, 2, 2) = 0: lim(2, 3, 2, 3) = 4.4: vae(2, 3, 2, 3) = 0
  lim(2, 3, 3, 1) = 6.4: vae(2, 3, 3, 1) = 1: lim(2, 3, 3, 2) = 8.4: vae(2, 3, 3, 2) = 2: lim(2, 3, 3, 3) = 10.1: vae(2, 3, 3, 3) = 3

  lim(2, 4, 1, 1) = 0.6: vae(2, 4, 1, 1) = -3: lim(2, 4, 1, 2) = 1.4: vae(2, 4, 1, 2) = -2: lim(2, 4, 1, 3) = 2.4: vae(2, 4, 1, 3) = -1
  lim(2, 4, 2, 1) = 4.4: vae(2, 4, 2, 1) = 0: lim(2, 4, 2, 2) = 4.4: vae(2, 4, 2, 2) = 0: lim(2, 4, 2, 3) = 4.4: vae(2, 4, 2, 3) = 0
  lim(2, 4, 3, 1) = 6.4: vae(2, 4, 3, 1) = 1: lim(2, 4, 3, 2) = 8.4: vae(2, 4, 3, 2) = 2: lim(2, 4, 3, 3) = 10.1: vae(2, 4, 3, 3) = 3

  lim(2, 5, 1, 1) = 0.6: vae(2, 5, 1, 1) = -3: lim(2, 5, 1, 2) = 1.4: vae(2, 5, 1, 2) = -2: lim(2, 5, 1, 3) = 2.4: vae(2, 5, 1, 3) = -1
  lim(2, 5, 2, 1) = 4.4: vae(2, 5, 2, 1) = 0: lim(2, 5, 2, 2) = 4.4: vae(2, 5, 2, 2) = 0: lim(2, 5, 2, 3) = 4.4: vae(2, 5, 2, 3) = 0
  lim(2, 5, 3, 1) = 6.4: vae(2, 5, 3, 1) = 1: lim(2, 5, 3, 2) = 8.4: vae(2, 5, 3, 2) = 2: lim(2, 5, 3, 3) = 10.1: vae(2, 5, 3, 3) = 3

  lim(2, 6, 1, 1) = 0.6: vae(2, 6, 1, 1) = -3: lim(2, 6, 1, 2) = 2.4: vae(2, 6, 1, 2) = -2: lim(2, 6, 1, 3) = 4.4: vae(2, 6, 1, 3) = -1
  lim(2, 6, 2, 1) = 6.4: vae(2, 6, 2, 1) = 0: lim(2, 6, 2, 2) = 6.4: vae(2, 6, 2, 2) = 0: lim(2, 6, 2, 3) = 6.4: vae(2, 6, 2, 3) = 0
  lim(2, 6, 3, 1) = 8.4: vae(2, 6, 3, 1) = 1: lim(2, 6, 3, 2) = 9.9: vae(2, 6, 3, 2) = 2: lim(2, 6, 3, 3) = 10.1: vae(2, 6, 3, 3) = 3

  lim(2, 7, 1, 1) = 0.6: vae(2, 7, 1, 1) = -3: lim(2, 7, 1, 2) = 0.8: vae(2, 7, 1, 2) = -2: lim(2, 7, 1, 3) = 1.4: vae(2, 7, 1, 3) = -1
  lim(2, 7, 2, 1) = 3.4: vae(2, 7, 2, 1) = 0: lim(2, 7, 2, 2) = 3.4: vae(2, 7, 2, 2) = 0: lim(2, 7, 2, 3) = 3.4: vae(2, 7, 2, 3) = 0
  lim(2, 7, 3, 1) = 5.4: vae(2, 7, 3, 1) = 1: lim(2, 7, 3, 2) = 7.4: vae(2, 7, 3, 2) = 2: lim(2, 7, 3, 3) = 10.1: vae(2, 7, 3, 3) = 3

  lim(3, 1, 1, 1) = 1.4: vae(3, 1, 1, 1) = -3: lim(3, 1, 1, 2) = 2.6: vae(3, 1, 1, 2) = -2: lim(3, 1, 1, 3) = 3.4: vae(3, 1, 1, 3) = -1
  lim(3, 1, 2, 1) = 4.6: vae(3, 1, 2, 1) = 0: lim(3, 1, 2, 2) = 4.6: vae(3, 1, 2, 2) = 0: lim(3, 1, 2, 3) = 4.6: vae(3, 1, 2, 3) = 0
  lim(3, 1, 3, 1) = 6.4: vae(3, 1, 3, 1) = 1: lim(3, 1, 3, 2) = 7.6: vae(3, 1, 3, 2) = 2: lim(3, 1, 3, 3) = 10.1: vae(3, 1, 3, 3) = 3

  lim(3, 2, 1, 1) = 1.4: vae(3, 2, 1, 1) = -3: lim(3, 2, 1, 2) = 2.6: vae(3, 2, 1, 2) = -2: lim(3, 2, 1, 3) = 3.6: vae(3, 2, 1, 3) = -1
  lim(3, 2, 2, 1) = 5.4: vae(3, 2, 2, 1) = 0: lim(3, 2, 2, 2) = 5.4: vae(3, 2, 2, 2) = 0: lim(3, 2, 2, 3) = 5.4: vae(3, 2, 2, 3) = 0
  lim(3, 2, 3, 1) = 6.6: vae(3, 2, 3, 1) = 1: lim(3, 2, 3, 2) = 8.4: vae(3, 2, 3, 2) = 2: lim(3, 2, 3, 3) = 10.1: vae(3, 2, 3, 3) = 3

  lim(3, 3, 1, 1) = 1.6: vae(3, 3, 1, 1) = -3: lim(3, 3, 1, 2) = 3.4: vae(3, 3, 1, 2) = -2: lim(3, 3, 1, 3) = 4.4: vae(3, 3, 1, 3) = -1
  lim(3, 3, 2, 1) = 5.6: vae(3, 3, 2, 1) = 0: lim(3, 3, 2, 2) = 5.6: vae(3, 3, 2, 2) = 0: lim(3, 3, 2, 3) = 5.6: vae(3, 3, 2, 3) = 0
  lim(3, 3, 3, 1) = 7.4: vae(3, 3, 3, 1) = 1: lim(3, 3, 3, 2) = 8.6: vae(3, 3, 3, 2) = 2: lim(3, 3, 3, 3) = 10.1: vae(3, 3, 3, 3) = 3

  lim(3, 4, 1, 1) = 1.6: vae(3, 4, 1, 1) = -3: lim(3, 4, 1, 2) = 3.6: vae(3, 4, 1, 2) = -2: lim(3, 4, 1, 3) = 4.6: vae(3, 4, 1, 3) = -1
  lim(3, 4, 2, 1) = 6.4: vae(3, 4, 2, 1) = 0: lim(3, 4, 2, 2) = 6.4: vae(3, 4, 2, 2) = 0: lim(3, 4, 2, 3) = 6.4: vae(3, 4, 2, 3) = 0
  lim(3, 4, 3, 1) = 7.4: vae(3, 4, 3, 1) = 1: lim(3, 4, 3, 2) = 9.4: vae(3, 4, 3, 2) = 2: lim(3, 4, 3, 3) = 10.1: vae(3, 4, 3, 3) = 3

  lim(3, 5, 1, 1) = 1.4: vae(3, 5, 1, 1) = -3: lim(3, 5, 1, 2) = 2.6: vae(3, 5, 1, 2) = -2: lim(3, 5, 1, 3) = 4.4: vae(3, 5, 1, 3) = -1
  lim(3, 5, 2, 1) = 5.4: vae(3, 5, 2, 1) = 0: lim(3, 5, 2, 2) = 5.4: vae(3, 5, 2, 2) = 0: lim(3, 5, 2, 3) = 5.4: vae(3, 5, 2, 3) = 0
  lim(3, 5, 3, 1) = 6.6: vae(3, 5, 3, 1) = 1: lim(3, 5, 3, 2) = 8.4: vae(3, 5, 3, 2) = 2: lim(3, 5, 3, 3) = 10.1: vae(3, 5, 3, 3) = 3

  lim(3, 6, 1, 1) = 1.6: vae(3, 6, 1, 1) = -3: lim(3, 6, 1, 2) = 3.4: vae(3, 6, 1, 2) = -2: lim(3, 6, 1, 3) = 4.4: vae(3, 6, 1, 3) = -1
  lim(3, 6, 2, 1) = 5.6: vae(3, 6, 2, 1) = 0: lim(3, 6, 2, 2) = 5.6: vae(3, 6, 2, 2) = 0: lim(3, 6, 2, 3) = 5.6: vae(3, 6, 2, 3) = 0
  lim(3, 6, 3, 1) = 7.4: vae(3, 6, 3, 1) = 1: lim(3, 6, 3, 2) = 9.4: vae(3, 6, 3, 2) = 2: lim(3, 6, 3, 3) = 10.1: vae(3, 6, 3, 3) = 3

  lim(3, 7, 1, 1) = 1.6: vae(3, 7, 1, 1) = -3: lim(3, 7, 1, 2) = 3.6: vae(3, 7, 1, 2) = -2: lim(3, 7, 1, 3) = 4.6: vae(3, 7, 1, 3) = -1
  lim(3, 7, 2, 1) = 6.4: vae(3, 7, 2, 1) = 0: lim(3, 7, 2, 2) = 6.4: vae(3, 7, 2, 2) = 0: lim(3, 7, 2, 3) = 6.4: vae(3, 7, 2, 3) = 0
  lim(3, 7, 3, 1) = 7.6: vae(3, 7, 3, 1) = 1: lim(3, 7, 3, 2) = 9.4: vae(3, 7, 3, 2) = 2: lim(3, 7, 3, 3) = 10.1: vae(3, 7, 3, 3) = 3

  ' Load statement table
  stm$(1, 1) = "unsociable and prefer solitary activities, avoiding social situations.|sociability.|gregarious and enjoy company and social get-togethers, relating easily to other people."
  stm$(1, 2) = "even-tempered and reserved and keep your feelings and thoughts to yourself.|inhibition.|emotional and easily express your feelings and are responsive, sympathetic and sentimental."
  stm$(1, 3) = "cautious and careful and seek security in familiar and safe situations.|daring.|adventurous and like to gamble and live dangerously."
  stm$(1, 4) = "prudent and orderly and carefully weigh the alternatives before making decisions, planning activities well in advance.|impulsiveness.|impulsive and unpredictable, acting on the spur of the moment, making incautious decisions."
  stm$(1, 5) = "pensive, reflective and speculative, pursuing philosophical questions and discussions.|practicality.|practical and prefer action to theory."
  stm$(1, 6) = "unreliable and unpredictable, careless and late with commitments.|responsibility.|reliable and trustworthy, conscientious and responsible."
  stm$(1, 7) = "easily fatigued, with a very low activity level.|activity level.|energetic and constantly active, relishing hard work and exercise."

  stm$(2, 1) = "self-confident with high self-esteem.|self-esteem.|low in self-confidence and self-esteem."
  stm$(2, 2) = "happy, optimistic and satisfied with life.|happiness.|unhappy, pessimistic, depressed and disappointed in life."
  stm$(2, 3) = "free from guilt, feeling sinless and blameless.|guilty feelings.|conscience-ridden and feel guilty, blaming yourself and regretting past behaviour."
  stm$(2, 4) = "independent and have a will of your own, making your own decisions, solving your own problems.|autonomy.|submissive and obedient to other's demands and feel ruled by external events."
  stm$(2, 5) = "casual, indifferent and easy-going.|compulsiveness.|compulsive, needing cleanliness, order and repetitive routine."
  stm$(2, 6) = "calm, placid and not easily perturbed.|anxiety.|nervous and anxious, easily upset, worrying unnecessarily."
  stm$(2, 7) = "well and unconcerned about your state of health.|hypochondriasis.|overly concerned about your health, complaining and demanding sympathy for your psychosomatic symptoms."

  stm$(3, 1) = "tender-minded, sentimental, delicate and intuitive, easily upset by insensitive people, things and events.|tough-mindedness.|tough-minded, untouched by violent or gruesome things and events."
  stm$(3, 2) = "trusting, empathetic, warm-hearted and altruistic.|manipulative tendancies.|manipulative, shrewd, calculating, selfish and detached."
  stm$(3, 3) = "flexible in outlook, rational and capable of change.|dogmatism.|dogmatic, uncompromising in your fixed opinions."
  stm$(3, 4) = "unadventurous, preferring the familiar, safe and secure.|daring.|adventurous and daring, seeking thrills and risking danger."
  stm$(3, 5) = "even-tempered and gentle, avoiding conflict and violence.|aggressiveness.|aggressive and indulge in sarcasm, arguments, fights, revenge, etc."
  stm$(3, 6) = "low in ambition, avoiding competitive and productive situations.|ambition.|ambitious, competitive, creative and productive."
  stm$(3, 7) = "submissive, easily imposed upon, timid and humble.|assertiveness.|assertive and independent, standing up for your rights."
End Sub

Sub DisplayResults(dummyArg)
  Cls

  Print "Your personality assessment has been broken down into three categories:"
  Print "     1.  Introversion / Extroversion"
  Print "     2.  Emotional Stability"
  Print "     3.  Sensitivity"

  ' look up limit table
  For t = 1 To 3
    Print Chr$(10) + Chr$(10) + Space$(15) + Str$(t) + ". " + GetString$((tstmt2$(t)),2,"|") + Chr$(10) + Chr$(10)

    For i = 1 To 7
      r = 1
      e = 0
      Do
        For d = 1 To 3
          If lim(t, i, r, d) > ScoreAmt(t, i) Then
            e = 1
            Exit For
            ' attempt to Exit the Do loop from inside the For loop has a bug
          EndIf
        Next
       If e = 1 Then Exit ' Do

       r = r + 1
      Loop Until r > 3

      ' set up score tables for t and i
      sval(t, i) = vae(t, i, r, d)
      tval(t) = tval(t) + sval(t, i)

      z = Abs(vae(t, i, r, d))
      If z > 3 Then z = 3
      If z = 0 Then
        Print "Your scores are average in the trait of";
      ElseIf z = 1 Then
        Print "You tend to be";
      ElseIf z = 2 Then
        Print "You are";
      ElseIf z = 3 Then
        Print "You are extremely";
      EndIf

      Print " " + GetString$((stm$(t, i)), r, "|")
      sExtra$ = GetString$((estmt$(t, i)), r, "|")
      If sExtra$ <> "" Then Print sExtra$
    Next

    WaitAnyKey
  Next

  ' display summary statements and summary tables
  Print Chr$(10) + Chr$(10) + "There are of course no rights/wrongs or goods/bads about all this."
  Print "However, extremes in some categories could indicate problems."
  Print "In any case, this is only a test of honesty anyway!" + Chr$(10) + Chr$(10)

  Print Space$(15) + "Summary of your Personality" + Chr$(10) + Chr$(10)

  For t = 1 To 3
    Print Space$(23) + "Table " + Str$(t) + "." + Chr$(10) + Chr$(10)
    Print Right$(Space$(14) + tlab1$(t), 14) + Space$(9) + "AVERAGE" + Space$(10) + Left$(tlab2$(t), 15)
    Print Space$(17) + "3  2  1  0  1  2  3" + Chr$(10) + Chr$(10)

    For i = 1 To 7
      y = sval(t, i) + 3
      Print Right$(Space$(14) + GetString$((lab1$(t)), i, "|"), 14) + "  ";
      Print Space$(y * 3) + "###" + Space$(3 + (6 - y) * 3);
      Print GetString$((lab2$(t)), i,"|")
    Next
    Print ""

    y = tval(t)
    x = Abs(y)

    If x <= 3.5 Then
      Print "Your scores are average in the trait of ";
    ElseIf x < 10.6 Then
      Print "You tend to be ";
    ElseIf x < 17.6 Then
      Print "You are ";
    Else
      Print "You are extremely ";
    EndIf

    If y > 3.5 Then
      Print GetString$((tstmt2$(t)),3,"|");
    ElseIf y < -3.5 Then
      Print GetString$((tstmt2$(t)),1,"|");
    Else
      Print GetString$((tstmt2$(t)),2,"|");
    EndIf
    Print "." + String$(2,10)

    If t = 2 Then
      If y <= -17.5 Then
        Print "Excessive emotional stability may be undesirable and may inhibit you from enjoying the experience of life." + Chr$(10)
      ElseIf y >= 17.5 Then
        Print "Extreme emotional instability can lead to neurotic illnesses with accompanying suffering and unhappiness." + Chr$(10)
      EndIf
    EndIf

    If t < 3 Then WaitAnyKey
  Next
End Sub

Sub WaitAnyKey(dummyArg)
  Font #1,,1 ' standard font and reverse video
  Print Chr$(10) + "press any key to continue...";
  Font #1

  Do: Loop While Inkey$ = ""

  Print String$(28,Chr$(8)) + String$(28," ") + String$(28,Chr$(8));
End Sub

Function GetString$(sValue$, iPart, sSeparator$)
' Multiple strings are packed into a single variable to better
' use the 255 characters that are reserved for each string.
' In this program the "|" separated variables saves more than 30kb of memory.

  sValue$ = sSeparator$ + sValue$ + sSeparator$

  iStart = 0
  For iLoop = 1 To iPart
    iStart = Instr(iStart + 1, sValue$, sSeparator$)
  Next

  iStart = iStart + 1
  iEnd = Instr(iStart, sValue$, sSeparator$)

  GetString$ = Mid$(sValue$, iStart, iEnd - iStart)
End Function



