#ifndef __LOG_EXPRESSIONS_H
#define __LOG_EXPRESSIONS_H

#define NUM_LOGGING_EXPRESSIONS	8
#define SIZE_EXPRESSIONS_BUFFER 256

#pragma pack(1)

typedef struct
{
	unsigned short 	expressionsSize;							/* Total Size of the used portion of the expressionsBuffer */
	unsigned short	expressionIndex[NUM_LOGGING_EXPRESSIONS];	/* Random Access Indexes into the expressionsBuffer */
	unsigned char	expressionsBuffer[SIZE_EXPRESSIONS_BUFFER];	/* Actual storage for the evaluation arrays */
} LOGGING_EXPRESSIONS_BUFFER;

void 			initLogExpressions(LOGGING_EXPRESSIONS_BUFFER* logExps);
unsigned int 	getSizeExpression(LOGGING_EXPRESSIONS_BUFFER* logExps, unsigned int numIndex);
unsigned char* 	getExpression(LOGGING_EXPRESSIONS_BUFFER* logExps, unsigned int numIndex, unsigned int* size);
void 			deleteLogExpressionByteAt(LOGGING_EXPRESSIONS_BUFFER* logExps, unsigned int index);
void 			deleteExpression(LOGGING_EXPRESSIONS_BUFFER* logExps, int numIndex);
int 			appendExpression(LOGGING_EXPRESSIONS_BUFFER* logExps, unsigned int numIndex, unsigned char* array, unsigned int sizeArray);
int   			insertExpression(LOGGING_EXPRESSIONS_BUFFER* logExps, unsigned int numIndex, unsigned char* array, unsigned int sizeArray);

extern LOGGING_EXPRESSIONS_BUFFER logExpressions;

#endif
