#ifdef __cplusplus
extern "C" { 
#endif 

#include "hardwarestate.h"
 
#if(IS_PC_HOST)

#else

#include "uart.h"
#include "ff.h"
#include "i2c.h"
#include "onewire.h"

#pragma udata hardwarestatedata

#pragma code usercode

#endif 

#if 0
void showUARTDescriptor(UART_DESCRIPTOR* ud)
{
	putrsUART("UD: mode: ");
	disWUART(ud->mode);
	putrsUART(" tx: ");
	disWUART(ud->txrxpin);
	putrsUART(" bd: ");
	disWUART(ud->baudRate);
	putrsUART("\r\n");
}
#endif
  
unsigned char clearUARTDescriptor(UART_DESCRIPTOR* ud)
{
	ud->mode=NO_UART_MODE;
	ud->txrxpin=0x54;
	ud->baudRate=(unsigned short)(DEFAULT_BAUD_RATE/BAUD_RATE_FACTOR);
	return 0;
}
 
unsigned char clearI2CDescriptor(I2C_DESCRIPTOR* id)
{
	unsigned char i;
	id->busRate=0;
	for(i=0; i<I2C_BUFFER_SIZE; i++)id->I2CBuffer[i]=0xFF;
	return 0;
}

unsigned char clearOneWireDescriptor(ONE_WIRE_DESCRIPTOR* od)
{
	unsigned char i;
	od->mode=NO_ONE_WIRE_MODE;
	for(i=0;i<8;i++)od->romCode[i]=0xFF;
	for(i=0;i<16;i++)od->oneWireBuffer[i]=0xFF;
	return 0;
}

unsigned char clearHardwareDescriptor(HARDWARE_DESCRIPTOR* hd)
{
	clearUARTDescriptor(&hd->serialPort);
	clearUARTDescriptor(&hd->oneWireSerialPort);
	clearI2CDescriptor(&hd->i2cPort);
	clearOneWireDescriptor(&hd->oneWirePort);
	return 0;	
}

unsigned char compareUARTDescriptor(UART_DESCRIPTOR* system, UART_DESCRIPTOR* newDescriptor, unsigned char mode)
{
	unsigned char 	result;
	
	result=0;
	if(
	(system->mode!=newDescriptor->mode)
	||
	(system->txrxpin!=newDescriptor->txrxpin)
	||
	(system->baudRate!=newDescriptor->baudRate))	
	{
		result|=mode;
	}
	
	return result;
}

unsigned char compareI2CDescriptor(I2C_DESCRIPTOR* system, I2C_DESCRIPTOR* newDescriptor, unsigned char mode)
{
	unsigned char  result;
	
	result=0;
	if(system->busRate!=newDescriptor->busRate)
	{
		result|=mode;
	}
	return result;
}

unsigned char compareOneWireDescriptor(ONE_WIRE_DESCRIPTOR* systemOW, UART_DESCRIPTOR* systemSerialPort, ONE_WIRE_DESCRIPTOR* newOW, UART_DESCRIPTOR* newSerialPort, unsigned char mode)
{
	unsigned char 	result;

	result=0;
	if(!(newOW->mode & ONE_WIRE_USING_IO))
	{
		/* If not using IO, then using UART. */
		result|=compareUARTDescriptor(systemSerialPort, newSerialPort, mode);
	}	

	if(systemOW->mode!=newOW->mode)
	{
		result|=mode;
	}
	return result;
}

unsigned char compareDescriptor(VIRTUAL_MACHINE* vm, HARDWARE_DESCRIPTOR* system, HARDWARE_DESCRIPTOR* newDescriptor, unsigned char mode)
{
	/* 0 if equal, otherwise non zero */
	unsigned char result;	
	
	result=0;	
	if(mode & OPEN_SERIAL_PORT)
	{
		result|=compareUARTDescriptor(&system->serialPort, &newDescriptor->serialPort, OPEN_SERIAL_PORT);
	}
	
	if(mode & OPEN_I2C_PORT)
	{
		result|=compareI2CDescriptor(&system->i2cPort, &newDescriptor->i2cPort, OPEN_I2C_PORT);
	}
	
	if(mode & OPEN_ONE_WIRE_PORT)
	{
		result|=compareOneWireDescriptor(&system->oneWirePort, &system->serialPort, &newDescriptor->oneWirePort, &newDescriptor->oneWireSerialPort, OPEN_ONE_WIRE_PORT);	
	}
	return result;
}

unsigned char autoConfigureState(VIRTUAL_MACHINE* vm, HARDWARE_DESCRIPTOR* system, HARDWARE_DESCRIPTOR* newDescriptor, unsigned char mode)
{
	/* this function compares the two hardware descriptors, and if not equal, swaps them! */
	mode=compareDescriptor(vm, system, newDescriptor, mode);	
	if(mode & OPEN_SERIAL_PORT)
	{
		#if(IS_PC_HOST)
		
		#else
	
		closeUARTState(vm, &system->serialPort);
		initUARTState(vm, &newDescriptor->serialPort);
		mem_cpy((void*)&system->serialPort, (void*)&newDescriptor->serialPort, sizeof(UART_DESCRIPTOR));
		
		#endif
	}
	
	if(mode & OPEN_I2C_PORT)
	{
		#if(IS_PC_HOST)
		
		#else

		closeI2CState(&system->i2cPort);
		initI2CState(&newDescriptor->i2cPort);
		mem_cpy((void*)&system->i2cPort, (void*)&newDescriptor->i2cPort, sizeof(I2C_DESCRIPTOR));

		#endif
	}
	
	if(mode & OPEN_ONE_WIRE_PORT)
	{
		#if(IS_PC_HOST)
		
		#else
		 
		closeOneWireState(system);
		initOneWireState(newDescriptor);
		mem_cpy((void*)&system->oneWirePort, (void*)&newDescriptor->oneWirePort, sizeof(ONE_WIRE_DESCRIPTOR));		
		if(newDescriptor->oneWirePort.mode & ONE_WIRE_USING_IO)
		{
						
		}
		else
		{
			mem_cpy((void*)&system->serialPort, (void*)&newDescriptor->oneWireSerialPort, sizeof(UART_DESCRIPTOR));
		}	
		#endif
	}
	return mode;
}

#ifdef __cplusplus
} 
#endif 
