#ifndef __CLOCK_H
#define __CLOCK_H

#ifdef __cplusplus
extern "C" {
#endif 

#define SHOW_WDAY				1
#define SHOW_DAY				2
#define SHOW_MINUTES			4
#define SHOW_SECONDS			8
#define SHOW_HOURS				16
#define SHOW_MONTH				32
#define SHOW_YEAR				64

#define SHOW_TIME_DEFAULT			(SHOW_WDAY | SHOW_DAY | SHOW_MONTH | SHOW_HOURS | SHOW_MINUTES | SHOW_SECONDS | SHOW_YEAR)

#define TIME_UPDATED				1
#define DATE_UPDATED				2

#define DEFAULT_DURATION_SECS		1293840000L	/* number of seconds since 1970 epoch time to default time, Jan 1, 2011, midnight */

unsigned char* myultoabase(unsigned long Value, unsigned char* Buffer, unsigned char setprinted, unsigned char base, unsigned char maxDigits, unsigned char spaceChar);

#pragma pack(push, 1)


	typedef struct
	{
		unsigned char  secs;			// Seconds.	[0-59] 
		unsigned char  mins;			// Minutes.	[0-59] 
		unsigned char  hours;		    // Hours.	[0-23] 
		unsigned char  day;				// Day.		[1-31] 
		unsigned char  month;		    // Month.	[1-12] 
		unsigned short year;			// Year.
		unsigned char  wday;			// Weekday (0=Monday, 6=Sunday) (also used as pointer)
		unsigned char  show;
		unsigned char  updated;
	} TIME_T;

#define GPS_NO_ERROR				0x00
#define GPS_OVERRUN_ERROR			0x01
#define GPS_OVERFLOW_ERROR			0x02
#define GPS_UNDERFLOW_ERROR			0x04

#define MAX_GPS_PIPE_LENGTH			96
#define MAX_GPS_TEMPSTRING			64
#define MAX_GPS_OUTPUT				40

#define GPS_START_CHAR				'$'	   
#define GPS_END_PAYLOAD_CHAR		'*'
#define GPS_END_CHAR				0x0A	/* LF */
#define GPS_DELIMITER				','

#define GPS_IDLE_STATE				0
#define GPS_PAYLOAD_STATE			1
#define GPS_FIRST_CRC_CHAR_STATE	2
#define GPS_SECOND_CRC_CHAR_STATE	3
#define GPS_ALL_RECEIVED_STATE		4
#define GPS_ALL_DONE_STATE			5

#define GGA_MSG						0
#define GLL_MSG						1
#define GSA_MSG						2
#define GSV_MSG						3
#define RMC_MSG						4
#define VTG_MSG						5

typedef struct 
{

	volatile unsigned char  GPSLastRx;
	volatile unsigned char	GPSTxCRC;
	volatile unsigned char  GPSPipe[MAX_GPS_PIPE_LENGTH];
	volatile unsigned char 	GPSTempString[MAX_GPS_TEMPSTRING];
	volatile unsigned char  GPSTempPtr;
	volatile unsigned char  GPSPipePutPtr;
	volatile unsigned char  GPSPipeGetPtr;
	volatile unsigned char	GPSRxCRC;
	volatile unsigned char  GPSPipeState;
	volatile unsigned char  GPSError;
	volatile unsigned char 	GPSOutput[MAX_GPS_OUTPUT];
	volatile unsigned char  GPSOutPtr;
	float				 	GPSLongitude;
	float					GPSLatitude;
	float					GPSSpeed;
	float					GPSCourse;
	volatile unsigned char  GPSNewRx;
} GPS_DATA_OBJECT;

	void			igetTime(TIME_T* secondSystemTime);
	void			addMonths(TIME_T* argTimeOutput, long n);
	void			addDays(TIME_T* argTimeOutput, long n);
	void			addHours(TIME_T* argTimeOutput, long n);
	void			addMinutes(TIME_T* argTimeOutput, long n);
	void			addSeconds(TIME_T* argTimeOutput, long n);
	unsigned char	checkTime(TIME_T* argTimeOutput);
	void			getFutureArgumentTime(TIME_T* argTimeOutput, TIME_T* currentTimeInput);
	void			getTime(TIME_T* sTime);
	unsigned long	getDurationTotalSeconds(TIME_T* timeOne, TIME_T* timeTwo);
	long			getDurationTotalSecondsFutureArgument(TIME_T* inTime);
	unsigned long	getTotalSeconds(TIME_T* timet);
	void			addMonth(TIME_T* argTimeOutput);
	void			addDay(TIME_T* argTimeOutput);
	void			addHour(TIME_T* argTimeOutput);
	void			addMinute(TIME_T* argTimeOutput);
	void			addSecond(TIME_T* argTimeOutput);
	int				setTime(TIME_T* sysTime);
	unsigned long	getTotalDays(unsigned int day, unsigned int month, unsigned int year);
	unsigned int	getWeekDay(unsigned int day, unsigned int month, unsigned int year);
	unsigned long	getTotalSeconds(TIME_T* timet);
	unsigned long	getDuration(TIME_T* timeOne, TIME_T* timeTwo);
	unsigned int	isLeapYear(unsigned int iyear);
	unsigned int	daysInMonth(unsigned int month, unsigned int year);


	extern TIME_T			systemTime;
	extern unsigned char	timeUp;

#pragma pack(pop)


#ifdef __cplusplus
}
#endif 

#endif
