#include <streambuf>

class BufferedStringBuf : public std::streambuf
{
public:
    BufferedStringBuf(int bufferSize) 
    {
        if (bufferSize)
        {
            char *ptr = new char[bufferSize];
            setp(ptr, ptr + bufferSize);
        }
        else
            setp(0, 0);
    }
    virtual ~BufferedStringBuf() 
    {
        sync();
        delete[] pbase();
    }

    virtual void writeString(const std::string &str) = 0;

private:
    int	overflow(int c)
    {
        sync();

        if (c != EOF)
        {
            if (pbase() == epptr())
            {
                std::string temp;
                temp += char(c);
                writeString(temp);
            }
            else
                sputc(c);
        }

        return 0;
    }

    int	sync()
    {
        if (pbase() != pptr())
        {
            int len = int(pptr() - pbase());
            std::string temp(pbase(), len);
            writeString(temp);
            setp(pbase(), epptr());
        }
        return 0;
    }
};