
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison LALR(1) parsers in C++
   
      Copyright (C) 2002, 2003, 2004, 2005, 2006, 2007, 2008 Free Software
   Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

// Take the name prefix into account.
#define yylex   examplelex

/* First part of user declarations.  */

/* Line 311 of lalr1.cc  */
#line 10 "parser.yy"
 /*** C/C++ Declarations ***/

#include <stdio.h>
#include <string>
#include <vector>

#include "expression.h"



/* Line 311 of lalr1.cc  */
#line 54 "parser.cc"


#include "parser.h"

/* User implementation prologue.  */

/* Line 317 of lalr1.cc  */
#line 147 "parser.yy"


#include "driver.h"
#include "scanner.h"

/* this "connects" the bison parser in the driver to the flex scanner class
 * object. it defines the yylex() function call to pull the next token from the
 * current lexer object of the driver context. */
#undef yylex
#define yylex driver.lexer->lex



/* Line 317 of lalr1.cc  */
#line 77 "parser.cc"

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* FIXME: INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#define YYUSE(e) ((void) (e))

/* Enable debugging if requested.  */
#if YYDEBUG

/* A pseudo ostream that takes yydebug_ into account.  */
# define YYCDEBUG if (yydebug_) (*yycdebug_)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)	\
do {							\
  if (yydebug_)						\
    {							\
      *yycdebug_ << Title << ' ';			\
      yy_symbol_print_ ((Type), (Value), (Location));	\
      *yycdebug_ << std::endl;				\
    }							\
} while (false)

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug_)				\
    yy_reduce_print_ (Rule);		\
} while (false)

# define YY_STACK_PRINT()		\
do {					\
  if (yydebug_)				\
    yystack_print_ ();			\
} while (false)

#else /* !YYDEBUG */

# define YYCDEBUG if (false) std::cerr
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_REDUCE_PRINT(Rule)
# define YY_STACK_PRINT()

#endif /* !YYDEBUG */

#define yyerrok		(yyerrstatus_ = 0)
#define yyclearin	(yychar = yyempty_)

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab
#define YYRECOVERING()  (!!yyerrstatus_)


/* Line 380 of lalr1.cc  */
#line 1 "[Bison:b4_percent_define_default]"

namespace example {

/* Line 380 of lalr1.cc  */
#line 146 "parser.cc"
#if YYERROR_VERBOSE

  /* Return YYSTR after stripping away unnecessary quotes and
     backslashes, so that it's suitable for yyerror.  The heuristic is
     that double-quoting is unnecessary unless the string contains an
     apostrophe, a comma, or backslash (other than backslash-backslash).
     YYSTR is taken from yytname.  */
  std::string
  Parser::yytnamerr_ (const char *yystr)
  {
    if (*yystr == '"')
      {
        std::string yyr = "";
        char const *yyp = yystr;

        for (;;)
          switch (*++yyp)
            {
            case '\'':
            case ',':
              goto do_not_strip_quotes;

            case '\\':
              if (*++yyp != '\\')
                goto do_not_strip_quotes;
              /* Fall through.  */
            default:
              yyr += *yyp;
              break;

            case '"':
              return yyr;
            }
      do_not_strip_quotes: ;
      }

    return yystr;
  }

#endif

  /// Build a parser object.
  Parser::Parser (class Driver& driver_yyarg)
    :
#if YYDEBUG
      yydebug_ (false),
      yycdebug_ (&std::cerr),
#endif
      driver (driver_yyarg)
  {
  }

  Parser::~Parser ()
  {
  }

#if YYDEBUG
  /*--------------------------------.
  | Print this symbol on YYOUTPUT.  |
  `--------------------------------*/

  inline void
  Parser::yy_symbol_value_print_ (int yytype,
			   const semantic_type* yyvaluep, const location_type* yylocationp)
  {
    YYUSE (yylocationp);
    YYUSE (yyvaluep);
    switch (yytype)
      {
         default:
	  break;
      }
  }


  void
  Parser::yy_symbol_print_ (int yytype,
			   const semantic_type* yyvaluep, const location_type* yylocationp)
  {
    *yycdebug_ << (yytype < yyntokens_ ? "token" : "nterm")
	       << ' ' << yytname_[yytype] << " ("
	       << *yylocationp << ": ";
    yy_symbol_value_print_ (yytype, yyvaluep, yylocationp);
    *yycdebug_ << ')';
  }
#endif

  void
  Parser::yydestruct_ (const char* yymsg,
			   int yytype, semantic_type* yyvaluep, location_type* yylocationp)
  {
    YYUSE (yylocationp);
    YYUSE (yymsg);
    YYUSE (yyvaluep);

    YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

    switch (yytype)
      {
        case 75: /* "constant" */

/* Line 480 of lalr1.cc  */
#line 134 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 253 "parser.cc"
	break;
      case 76: /* "stringvariablevalue" */

/* Line 480 of lalr1.cc  */
#line 143 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 262 "parser.cc"
	break;
      case 77: /* "stringvariable" */

/* Line 480 of lalr1.cc  */
#line 134 "parser.yy"
	{ delete (yyvaluep->CNStringVariableReference); };

/* Line 480 of lalr1.cc  */
#line 271 "parser.cc"
	break;
      case 78: /* "variable" */

/* Line 480 of lalr1.cc  */
#line 134 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 280 "parser.cc"
	break;
      case 79: /* "keywordscript" */

/* Line 480 of lalr1.cc  */
#line 137 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 289 "parser.cc"
	break;
      case 80: /* "keywordprint" */

/* Line 480 of lalr1.cc  */
#line 135 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 298 "parser.cc"
	break;
      case 81: /* "keywordsleep" */

/* Line 480 of lalr1.cc  */
#line 138 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 307 "parser.cc"
	break;
      case 82: /* "keywordopenpipe" */

/* Line 480 of lalr1.cc  */
#line 142 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 316 "parser.cc"
	break;
      case 83: /* "keywordclosepipe" */

/* Line 480 of lalr1.cc  */
#line 142 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 325 "parser.cc"
	break;
      case 84: /* "keywordif" */

/* Line 480 of lalr1.cc  */
#line 135 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 334 "parser.cc"
	break;
      case 85: /* "keywordelse" */

/* Line 480 of lalr1.cc  */
#line 135 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 343 "parser.cc"
	break;
      case 86: /* "keywordwhile" */

/* Line 480 of lalr1.cc  */
#line 135 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 352 "parser.cc"
	break;
      case 87: /* "keywordfunction" */

/* Line 480 of lalr1.cc  */
#line 135 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 361 "parser.cc"
	break;
      case 88: /* "keywordeq" */

/* Line 480 of lalr1.cc  */
#line 135 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 370 "parser.cc"
	break;
      case 89: /* "keywordneq" */

/* Line 480 of lalr1.cc  */
#line 135 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 379 "parser.cc"
	break;
      case 90: /* "keywordlt" */

/* Line 480 of lalr1.cc  */
#line 135 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 388 "parser.cc"
	break;
      case 91: /* "keywordlte" */

/* Line 480 of lalr1.cc  */
#line 135 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 397 "parser.cc"
	break;
      case 92: /* "keywordgt" */

/* Line 480 of lalr1.cc  */
#line 135 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 406 "parser.cc"
	break;
      case 93: /* "keywordgte" */

/* Line 480 of lalr1.cc  */
#line 135 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 415 "parser.cc"
	break;
      case 94: /* "keywordand" */

/* Line 480 of lalr1.cc  */
#line 135 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 424 "parser.cc"
	break;
      case 95: /* "keywordor" */

/* Line 480 of lalr1.cc  */
#line 135 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 433 "parser.cc"
	break;
      case 96: /* "keywordxor" */

/* Line 480 of lalr1.cc  */
#line 135 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 442 "parser.cc"
	break;
      case 97: /* "atomexpr" */

/* Line 480 of lalr1.cc  */
#line 136 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 451 "parser.cc"
	break;
      case 98: /* "powexpr" */

/* Line 480 of lalr1.cc  */
#line 136 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 460 "parser.cc"
	break;
      case 99: /* "unaryexpr" */

/* Line 480 of lalr1.cc  */
#line 136 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 469 "parser.cc"
	break;
      case 100: /* "binaryexpr" */

/* Line 480 of lalr1.cc  */
#line 134 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 478 "parser.cc"
	break;
      case 101: /* "mulexpr" */

/* Line 480 of lalr1.cc  */
#line 136 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 487 "parser.cc"
	break;
      case 102: /* "addexpr" */

/* Line 480 of lalr1.cc  */
#line 136 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 496 "parser.cc"
	break;
      case 103: /* "expr" */

/* Line 480 of lalr1.cc  */
#line 136 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 505 "parser.cc"
	break;
      case 104: /* "assignment" */

/* Line 480 of lalr1.cc  */
#line 136 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 514 "parser.cc"
	break;
      case 105: /* "stringassignment" */

/* Line 480 of lalr1.cc  */
#line 136 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 523 "parser.cc"
	break;
      case 106: /* "keywordtimeuntil" */

/* Line 480 of lalr1.cc  */
#line 141 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 532 "parser.cc"
	break;
      case 107: /* "keywordtime" */

/* Line 480 of lalr1.cc  */
#line 141 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 541 "parser.cc"
	break;
      case 108: /* "argument" */

/* Line 480 of lalr1.cc  */
#line 134 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 550 "parser.cc"
	break;
      case 109: /* "argumentlist" */

/* Line 480 of lalr1.cc  */
#line 134 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 559 "parser.cc"
	break;
      case 110: /* "argumentexp" */

/* Line 480 of lalr1.cc  */
#line 134 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 568 "parser.cc"
	break;
      case 111: /* "functionref" */

/* Line 480 of lalr1.cc  */
#line 134 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 577 "parser.cc"
	break;
      case 112: /* "functioncall" */

/* Line 480 of lalr1.cc  */
#line 134 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 586 "parser.cc"
	break;
      case 113: /* "functiondef" */

/* Line 480 of lalr1.cc  */
#line 136 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 595 "parser.cc"
	break;
      case 114: /* "whileloop" */

/* Line 480 of lalr1.cc  */
#line 136 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 604 "parser.cc"
	break;
      case 115: /* "conditional" */

/* Line 480 of lalr1.cc  */
#line 137 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 613 "parser.cc"
	break;
      case 116: /* "comment" */

/* Line 480 of lalr1.cc  */
#line 135 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 622 "parser.cc"
	break;
      case 117: /* "string" */

/* Line 480 of lalr1.cc  */
#line 137 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 631 "parser.cc"
	break;
      case 118: /* "keywordnewline" */

/* Line 480 of lalr1.cc  */
#line 137 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 640 "parser.cc"
	break;
      case 119: /* "keywordpfunction" */

/* Line 480 of lalr1.cc  */
#line 137 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 649 "parser.cc"
	break;
      case 120: /* "keywordbase" */

/* Line 480 of lalr1.cc  */
#line 143 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 658 "parser.cc"
	break;
      case 121: /* "keyworddecimal" */

/* Line 480 of lalr1.cc  */
#line 143 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 667 "parser.cc"
	break;
      case 122: /* "keywordchar" */

/* Line 480 of lalr1.cc  */
#line 143 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 676 "parser.cc"
	break;
      case 123: /* "printargument" */

/* Line 480 of lalr1.cc  */
#line 137 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 685 "parser.cc"
	break;
      case 124: /* "printargumentlist" */

/* Line 480 of lalr1.cc  */
#line 137 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 694 "parser.cc"
	break;
      case 125: /* "keywordprecision" */

/* Line 480 of lalr1.cc  */
#line 138 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 703 "parser.cc"
	break;
      case 126: /* "precisioncommand" */

/* Line 480 of lalr1.cc  */
#line 138 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 712 "parser.cc"
	break;
      case 127: /* "keywordreset" */

/* Line 480 of lalr1.cc  */
#line 141 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 721 "parser.cc"
	break;
      case 128: /* "resetcommand" */

/* Line 480 of lalr1.cc  */
#line 141 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 730 "parser.cc"
	break;
      case 129: /* "timeargument" */

/* Line 480 of lalr1.cc  */
#line 138 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 739 "parser.cc"
	break;
      case 130: /* "keywordsleepuntil" */

/* Line 480 of lalr1.cc  */
#line 138 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 748 "parser.cc"
	break;
      case 131: /* "sleepuntilcommand" */

/* Line 480 of lalr1.cc  */
#line 138 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 757 "parser.cc"
	break;
      case 132: /* "closepipecommand" */

/* Line 480 of lalr1.cc  */
#line 142 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 766 "parser.cc"
	break;
      case 133: /* "openpipecommand" */

/* Line 480 of lalr1.cc  */
#line 142 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 775 "parser.cc"
	break;
      case 134: /* "sleepcommand" */

/* Line 480 of lalr1.cc  */
#line 138 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 784 "parser.cc"
	break;
      case 135: /* "printcommand" */

/* Line 480 of lalr1.cc  */
#line 137 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 793 "parser.cc"
	break;
      case 136: /* "keywordopenfile" */

/* Line 480 of lalr1.cc  */
#line 140 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 802 "parser.cc"
	break;
      case 137: /* "keywordclearfile" */

/* Line 480 of lalr1.cc  */
#line 140 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 811 "parser.cc"
	break;
      case 138: /* "keywordserial" */

/* Line 480 of lalr1.cc  */
#line 141 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 820 "parser.cc"
	break;
      case 139: /* "keywordnmea" */

/* Line 480 of lalr1.cc  */
#line 141 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 829 "parser.cc"
	break;
      case 140: /* "keywordmatchnmea" */

/* Line 480 of lalr1.cc  */
#line 141 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 838 "parser.cc"
	break;
      case 141: /* "clearfilecommand" */

/* Line 480 of lalr1.cc  */
#line 140 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 847 "parser.cc"
	break;
      case 142: /* "openfilecommand" */

/* Line 480 of lalr1.cc  */
#line 140 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 856 "parser.cc"
	break;
      case 143: /* "serialcommand" */

/* Line 480 of lalr1.cc  */
#line 141 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 865 "parser.cc"
	break;
      case 144: /* "nmeacommand" */

/* Line 480 of lalr1.cc  */
#line 141 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 874 "parser.cc"
	break;
      case 145: /* "matchnmeacommand" */

/* Line 480 of lalr1.cc  */
#line 141 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 883 "parser.cc"
	break;
      case 146: /* "statement" */

/* Line 480 of lalr1.cc  */
#line 136 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 892 "parser.cc"
	break;
      case 147: /* "statementlist" */

/* Line 480 of lalr1.cc  */
#line 136 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 901 "parser.cc"
	break;
      case 148: /* "statementblock" */

/* Line 480 of lalr1.cc  */
#line 136 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 910 "parser.cc"
	break;
      case 149: /* "script" */

/* Line 480 of lalr1.cc  */
#line 137 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 919 "parser.cc"
	break;
      case 150: /* "keywordheader" */

/* Line 480 of lalr1.cc  */
#line 139 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 928 "parser.cc"
	break;
      case 151: /* "headerstatement" */

/* Line 480 of lalr1.cc  */
#line 139 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 937 "parser.cc"
	break;
      case 152: /* "headerstatementlist" */

/* Line 480 of lalr1.cc  */
#line 139 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 946 "parser.cc"
	break;
      case 153: /* "headerstatementblock" */

/* Line 480 of lalr1.cc  */
#line 139 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 955 "parser.cc"
	break;
      case 154: /* "header" */

/* Line 480 of lalr1.cc  */
#line 139 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 964 "parser.cc"
	break;
      case 155: /* "body" */

/* Line 480 of lalr1.cc  */
#line 140 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 973 "parser.cc"
	break;
      case 156: /* "total" */

/* Line 480 of lalr1.cc  */
#line 140 "parser.yy"
	{ delete (yyvaluep->BaseNode); };

/* Line 480 of lalr1.cc  */
#line 982 "parser.cc"
	break;

	default:
	  break;
      }
  }

  void
  Parser::yypop_ (unsigned int n)
  {
    yystate_stack_.pop (n);
    yysemantic_stack_.pop (n);
    yylocation_stack_.pop (n);
  }

#if YYDEBUG
  std::ostream&
  Parser::debug_stream () const
  {
    return *yycdebug_;
  }

  void
  Parser::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


  Parser::debug_level_type
  Parser::debug_level () const
  {
    return yydebug_;
  }

  void
  Parser::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }
#endif

  int
  Parser::parse ()
  {
    /// Lookahead and lookahead in internal form.
    int yychar = yyempty_;
    int yytoken = 0;

    /* State.  */
    int yyn;
    int yylen = 0;
    int yystate = 0;

    /* Error handling.  */
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// Semantic value of the lookahead.
    semantic_type yylval;
    /// Location of the lookahead.
    location_type yylloc;
    /// The locations where the error started and ended.
    location_type yyerror_range[2];

    /// $$.
    semantic_type yyval;
    /// @$.
    location_type yyloc;

    int yyresult;

    YYCDEBUG << "Starting parse" << std::endl;


    /* User initialization code.  */
    
/* Line 553 of lalr1.cc  */
#line 47 "parser.yy"
{
    // initialize the initial location object
    yylloc.begin.filename = yylloc.end.filename = &driver.streamname;
}

/* Line 553 of lalr1.cc  */
#line 1068 "parser.cc"

    /* Initialize the stacks.  The initial state will be pushed in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystate_stack_ = state_stack_type (0);
    yysemantic_stack_ = semantic_stack_type (0);
    yylocation_stack_ = location_stack_type (0);
    yysemantic_stack_.push (yylval);
    yylocation_stack_.push (yylloc);

    /* New state.  */
  yynewstate:
    yystate_stack_.push (yystate);
    YYCDEBUG << "Entering state " << yystate << std::endl;

    /* Accept?  */
    if (yystate == yyfinal_)
      goto yyacceptlab;

    goto yybackup;

    /* Backup.  */
  yybackup:

    /* Try to take a decision without lookahead.  */
    yyn = yypact_[yystate];
    if (yyn == yypact_ninf_)
      goto yydefault;

    /* Read a lookahead token.  */
    if (yychar == yyempty_)
      {
	YYCDEBUG << "Reading a token: ";
	yychar = yylex (&yylval, &yylloc);
      }


    /* Convert token to internal form.  */
    if (yychar <= yyeof_)
      {
	yychar = yytoken = yyeof_;
	YYCDEBUG << "Now at end of input." << std::endl;
      }
    else
      {
	yytoken = yytranslate_ (yychar);
	YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
      }

    /* If the proper action on seeing token YYTOKEN is to reduce or to
       detect an error, take that action.  */
    yyn += yytoken;
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yytoken)
      goto yydefault;

    /* Reduce or error.  */
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
	if (yyn == 0 || yyn == yytable_ninf_)
	goto yyerrlab;
	yyn = -yyn;
	goto yyreduce;
      }

    /* Shift the lookahead token.  */
    YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

    /* Discard the token being shifted.  */
    yychar = yyempty_;

    yysemantic_stack_.push (yylval);
    yylocation_stack_.push (yylloc);

    /* Count tokens shifted since error; after three, turn off error
       status.  */
    if (yyerrstatus_)
      --yyerrstatus_;

    yystate = yyn;
    goto yynewstate;

  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[yystate];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;

  /*-----------------------------.
  | yyreduce -- Do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    /* If YYLEN is nonzero, implement the default value of the action:
       `$$ = $1'.  Otherwise, use the top of the stack.

       Otherwise, the following line sets YYVAL to garbage.
       This behavior is undocumented and Bison
       users should not rely upon it.  */
    if (yylen)
      yyval = yysemantic_stack_[yylen - 1];
    else
      yyval = yysemantic_stack_[0];

    {
      slice<location_type, location_stack_type> slice (yylocation_stack_, yylen);
      YYLLOC_DEFAULT (yyloc, slice, yylen);
    }
    YY_REDUCE_PRINT (yyn);
    switch (yyn)
      {
	  case 2:

/* Line 678 of lalr1.cc  */
#line 165 "parser.yy"
    {
             (yyval.BaseNode) = new CNConstant((yysemantic_stack_[(1) - (1)].integerVal));
           }
    break;

  case 3:

/* Line 678 of lalr1.cc  */
#line 170 "parser.yy"
    {
             (yyval.BaseNode) = new CNConstant((yysemantic_stack_[(1) - (1)].integerVal));
           }
    break;

  case 4:

/* Line 678 of lalr1.cc  */
#line 175 "parser.yy"
    {
             (yyval.BaseNode) = new CNConstant((yysemantic_stack_[(1) - (1)].integerVal));
           }
    break;

  case 5:

/* Line 678 of lalr1.cc  */
#line 180 "parser.yy"
    {
             (yyval.BaseNode) = new CNConstant((yysemantic_stack_[(1) - (1)].doubleVal));
           }
    break;

  case 6:

/* Line 678 of lalr1.cc  */
#line 188 "parser.yy"
    {
            if (!driver.calc.existsLocalStringVariable(*(yysemantic_stack_[(4) - (3)].stringVal)))
            {
             error(yyloc, std::string("Error  : Unknown string variable \"") + *(yysemantic_stack_[(4) - (3)].stringVal) + "\".");
             delete (yysemantic_stack_[(4) - (3)].stringVal);
             delete (yysemantic_stack_[(4) - (1)].BaseNode);
             YYERROR;
            }
            else
            {
              (yyval.BaseNode) = new CNLocalVariableByteReference(*(yysemantic_stack_[(4) - (3)].stringVal), driver.calc.localStringVariables[driver.calc.scriptNumber][*(yysemantic_stack_[(4) - (3)].stringVal)][POSITION_OF_ADDRESS], new CNConstant(0));
              delete (yysemantic_stack_[(4) - (3)].stringVal);
              delete (yysemantic_stack_[(4) - (1)].BaseNode);
             }
           }
    break;

  case 7:

/* Line 678 of lalr1.cc  */
#line 205 "parser.yy"
    {
            if (!driver.calc.existsLocalStringVariable(*(yysemantic_stack_[(7) - (3)].stringVal)))
            {
                error(yyloc, std::string("Error  : Unknown string variable \"") + *(yysemantic_stack_[(7) - (3)].stringVal) + "\".");
                delete (yysemantic_stack_[(7) - (3)].stringVal);
                delete (yysemantic_stack_[(7) - (1)].BaseNode);
                YYERROR;
            }
            else
            {
              (yyval.BaseNode) = new CNLocalVariableByteReference(*(yysemantic_stack_[(7) - (3)].stringVal), driver.calc.localStringVariables[driver.calc.scriptNumber][*(yysemantic_stack_[(7) - (3)].stringVal)][POSITION_OF_ADDRESS], (yysemantic_stack_[(7) - (5)].BaseNode));
              delete (yysemantic_stack_[(7) - (3)].stringVal);
              delete (yysemantic_stack_[(7) - (1)].BaseNode);
            }
           }
    break;

  case 8:

/* Line 678 of lalr1.cc  */
#line 222 "parser.yy"
    {
            if (!driver.calc.existsGlobalStringVariable(*(yysemantic_stack_[(4) - (3)].stringVal)))
            {
             error(yyloc, std::string("Error  : No global string variable \"") + *(yysemantic_stack_[(4) - (3)].stringVal) + "\".");
             delete (yysemantic_stack_[(4) - (3)].stringVal);
             delete (yysemantic_stack_[(4) - (1)].BaseNode);
             YYERROR;
            }
           else
           {
            (yyval.BaseNode) = new CNGlobalVariableByteReference(*(yysemantic_stack_[(4) - (3)].stringVal), driver.calc.globalVariables[*(yysemantic_stack_[(4) - (3)].stringVal)][POSITION_OF_ADDRESS], new CNConstant(0));
            delete (yysemantic_stack_[(4) - (3)].stringVal);
            delete (yysemantic_stack_[(4) - (1)].BaseNode);
           }
           }
    break;

  case 9:

/* Line 678 of lalr1.cc  */
#line 239 "parser.yy"
    {
            if (!driver.calc.existsGlobalStringVariable(*(yysemantic_stack_[(7) - (3)].stringVal)))
            {
             error(yyloc, std::string("Error  : No global string variable \"") + *(yysemantic_stack_[(7) - (3)].stringVal) + "\".");
             delete (yysemantic_stack_[(7) - (3)].stringVal);
             delete (yysemantic_stack_[(7) - (1)].BaseNode);
             YYERROR;
            }
           else
           {
            (yyval.BaseNode) = new CNGlobalVariableByteReference(*(yysemantic_stack_[(7) - (3)].stringVal), driver.calc.globalVariables[*(yysemantic_stack_[(7) - (3)].stringVal)][POSITION_OF_ADDRESS], (yysemantic_stack_[(7) - (5)].BaseNode));
            delete (yysemantic_stack_[(7) - (1)].BaseNode);
            delete (yysemantic_stack_[(7) - (3)].stringVal);
           }
           }
    break;

  case 10:

/* Line 678 of lalr1.cc  */
#line 257 "parser.yy"
    {
            if (!driver.calc.existsLocalStringVariable(*(yysemantic_stack_[(1) - (1)].stringVal)))
            {
             std::vector<ADDRESS_TYPE> myVector;
             myVector.clear();
             myVector.insert(myVector.end(), driver.calc.currentLocalVars);
             myVector.insert(myVector.end(), (ADDRESS_TYPE)driver.calc.sizeOfStringVariable);
             driver.calc.localStringVariables[driver.calc.scriptNumber].insert(std::pair<std::string, std::vector<ADDRESS_TYPE>>(*(yysemantic_stack_[(1) - (1)].stringVal), myVector));
             error(yyloc, std::string("Warning: Unknown string variable \"") + *(yysemantic_stack_[(1) - (1)].stringVal) + "\".");
             (yyval.CNStringVariableReference) = new CNLocalStringVariableReference(*(yysemantic_stack_[(1) - (1)].stringVal), driver.calc.currentLocalVars, 0, driver.calc.sizeOfStringVariable);
             driver.calc.currentLocalVars+=driver.calc.sizeOfStringVariable;
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
            else
            {
             (yyval.CNStringVariableReference) = new CNLocalStringVariableReference(*(yysemantic_stack_[(1) - (1)].stringVal), driver.calc.localStringVariables[driver.calc.scriptNumber][*(yysemantic_stack_[(1) - (1)].stringVal)][POSITION_OF_ADDRESS], 0, driver.calc.getSizeOfLocalStringVariable(*(yysemantic_stack_[(1) - (1)].stringVal)));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
           }
    break;

  case 11:

/* Line 678 of lalr1.cc  */
#line 278 "parser.yy"
    {
            if (!driver.calc.existsLocalStringVariable(*(yysemantic_stack_[(4) - (1)].stringVal)))
            {
             error(yyloc, std::string("Warning: Unknown local string variable \"") + *(yysemantic_stack_[(4) - (1)].stringVal) + "\".");
             if(((yysemantic_stack_[(4) - (3)].BaseNode)->isConstant())&&((yysemantic_stack_[(4) - (3)].BaseNode)->evaluate()>0))
             {
                double localRequestedAllocationSize;
                localRequestedAllocationSize=(((yysemantic_stack_[(4) - (3)].BaseNode)->evaluate())+1);
                /* if constant expression, allocate that many bytes to this variable */
                if(localRequestedAllocationSize<=(double)driver.calc.maxLocalAllocationSize)
                {
                        /* allocate the space */
                        std::vector<ADDRESS_TYPE> myVector;
                        myVector.clear();
                        myVector.insert(myVector.end(), driver.calc.currentLocalVars);
                        myVector.insert(myVector.end(), (ADDRESS_TYPE)localRequestedAllocationSize);
                        driver.calc.localStringVariables[driver.calc.scriptNumber].insert(std::pair<std::string, std::vector<ADDRESS_TYPE>>(*(yysemantic_stack_[(4) - (1)].stringVal), myVector));
                        (yyval.CNStringVariableReference) = new CNLocalStringVariableReference(*(yysemantic_stack_[(4) - (1)].stringVal), driver.calc.currentLocalVars, new CNConstant(0), (ADDRESS_TYPE)localRequestedAllocationSize);
                        driver.calc.currentLocalVars+=(ADDRESS_TYPE)localRequestedAllocationSize;
                        error(yyloc, std::string("Warning: Non standard allocation size requested, "+getStdStringFromString(formatStringFloat((double)localRequestedAllocationSize, 0))+" bytes."));
                }
                else
                {
                        /* allocation size requested is too large */
                        error(yyloc, std::string("Error  : Allocation size requested, "+getStdStringFromString(formatStringFloat((double)localRequestedAllocationSize, 0))+" bytes is too large. The maximum is "+getStdStringFromString(formatStringFloat((double)driver.calc.maxLocalAllocationSize, 0))+" bytes."));
                        delete (yysemantic_stack_[(4) - (1)].stringVal);
                        delete (yysemantic_stack_[(4) - (3)].BaseNode);
                        YYERROR;
                }
             }
             else
             {
                std::vector<ADDRESS_TYPE> myVector;
                myVector.clear();
                myVector.insert(myVector.end(), driver.calc.currentLocalVars);
                myVector.insert(myVector.end(), (ADDRESS_TYPE)driver.calc.sizeOfStringVariable);
                driver.calc.localStringVariables[driver.calc.scriptNumber].insert(std::pair<std::string, std::vector<ADDRESS_TYPE>>(*(yysemantic_stack_[(4) - (1)].stringVal), myVector));
                (yyval.CNStringVariableReference) = new CNLocalStringVariableReference(*(yysemantic_stack_[(4) - (1)].stringVal), driver.calc.currentLocalVars, new CNConstant(0), (ADDRESS_TYPE)driver.calc.sizeOfStringVariable);
                driver.calc.currentLocalVars+=driver.calc.sizeOfStringVariable;
             }
             delete (yysemantic_stack_[(4) - (1)].stringVal);
            }
           else
           {
            (yyval.CNStringVariableReference) = new CNLocalStringVariableReference(*(yysemantic_stack_[(4) - (1)].stringVal), driver.calc.localStringVariables[driver.calc.scriptNumber][*(yysemantic_stack_[(4) - (1)].stringVal)][POSITION_OF_ADDRESS], (yysemantic_stack_[(4) - (3)].BaseNode), (ADDRESS_TYPE)driver.calc.getSizeOfLocalStringVariable(*(yysemantic_stack_[(4) - (1)].stringVal)));
            delete (yysemantic_stack_[(4) - (1)].stringVal);
           }
           }
    break;

  case 12:

/* Line 678 of lalr1.cc  */
#line 328 "parser.yy"
    {
            if (!driver.calc.existsGlobalStringVariable(*(yysemantic_stack_[(1) - (1)].stringVal)))
            {
             error(yyloc, std::string("Error  : Unknown global string variable \"") + *(yysemantic_stack_[(1) - (1)].stringVal) + "\".");
             delete (yysemantic_stack_[(1) - (1)].stringVal);
             YYERROR;
            }
           else
           {
            (yyval.CNStringVariableReference) = new CNGlobalStringVariableReference(*(yysemantic_stack_[(1) - (1)].stringVal), driver.calc.globalStringVariables[*(yysemantic_stack_[(1) - (1)].stringVal)][POSITION_OF_ADDRESS], 0, (ADDRESS_TYPE)driver.calc.getSizeOfGlobalStringVariable(*(yysemantic_stack_[(1) - (1)].stringVal)));
            delete (yysemantic_stack_[(1) - (1)].stringVal);
           }
           }
    break;

  case 13:

/* Line 678 of lalr1.cc  */
#line 343 "parser.yy"
    {
            if (!driver.calc.existsGlobalStringVariable(*(yysemantic_stack_[(4) - (1)].stringVal)))
            {
             error(yyloc, std::string("Error  : Unknown global string variable \"") + *(yysemantic_stack_[(4) - (1)].stringVal) + "\".");
             delete (yysemantic_stack_[(4) - (1)].stringVal);
             YYERROR;
            }
           else
           {
            (yyval.CNStringVariableReference) = new CNGlobalStringVariableReference(*(yysemantic_stack_[(4) - (1)].stringVal), driver.calc.globalStringVariables[*(yysemantic_stack_[(4) - (1)].stringVal)][POSITION_OF_ADDRESS], (yysemantic_stack_[(4) - (3)].BaseNode), (ADDRESS_TYPE)driver.calc.getSizeOfGlobalStringVariable(*(yysemantic_stack_[(4) - (1)].stringVal)));
            delete (yysemantic_stack_[(4) - (1)].stringVal);
           }
           }
    break;

  case 14:

/* Line 678 of lalr1.cc  */
#line 358 "parser.yy"
    {
            if (!driver.calc.existsDefineConstant(*(yysemantic_stack_[(1) - (1)].stringVal)))
            {
             driver.calc.defineConstants.insert(std::pair<std::string, double>(*(yysemantic_stack_[(1) - (1)].stringVal), 0));
             error(yyloc, std::string("Error  : Unknown define constant \"") + *(yysemantic_stack_[(1) - (1)].stringVal) + "\".");
             delete (yysemantic_stack_[(1) - (1)].stringVal);
             YYERROR;
             //$$ = new CNDefineConstantReference(*$1, 0);
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
            else
           {
            error(yyloc, std::string("Warning: Define constant \""+ *(yysemantic_stack_[(1) - (1)].stringVal) +"\"=" + getStdStringFromString(formatStringFloat(driver.calc.defineConstants[*(yysemantic_stack_[(1) - (1)].stringVal)], 3))+"."));
            (yyval.BaseNode) = new CNDefineConstantReference(*(yysemantic_stack_[(1) - (1)].stringVal), driver.calc.defineConstants[*(yysemantic_stack_[(1) - (1)].stringVal)]);
            delete (yysemantic_stack_[(1) - (1)].stringVal);
           }
           }
    break;

  case 15:

/* Line 678 of lalr1.cc  */
#line 377 "parser.yy"
    {
            error(yyloc, std::string("Warning: Stack variable referenced."));
            (yyval.BaseNode) = new CNStackVariableReference(std::string("STACK"), (yysemantic_stack_[(1) - (1)].integerVal), &driver.calc);
           }
    break;

  case 16:

/* Line 678 of lalr1.cc  */
#line 383 "parser.yy"
    {
            if (!driver.calc.existsLocalVariable(*(yysemantic_stack_[(1) - (1)].stringVal)))
            {
            std::vector<ADDRESS_TYPE> myVector;
            myVector.clear();
            myVector.insert(myVector.end(), driver.calc.currentLocalVars);
            myVector.insert(myVector.end(), (ADDRESS_TYPE)driver.calc.sizeOfFloat);
            driver.calc.localVariables[driver.calc.scriptNumber].insert(std::pair<std::string, std::vector<ADDRESS_TYPE>>(*(yysemantic_stack_[(1) - (1)].stringVal), myVector));
            error(yyloc, std::string("Warning: Unknown variable \"") + *(yysemantic_stack_[(1) - (1)].stringVal) + "\" @ 0x"+getStdStringFromString(HexToString(driver.calc.currentLocalVars, 4))+".");
            (yyval.BaseNode) = new CNLocalVariableReference(*(yysemantic_stack_[(1) - (1)].stringVal), driver.calc.currentLocalVars, 0);
            driver.calc.currentLocalVars+=driver.calc.sizeOfFloat;
            delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
            else
            {
             (yyval.BaseNode) = new CNLocalVariableReference(*(yysemantic_stack_[(1) - (1)].stringVal), driver.calc.localVariables[driver.calc.scriptNumber][*(yysemantic_stack_[(1) - (1)].stringVal)][POSITION_OF_ADDRESS], 0);
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
           }
    break;

  case 17:

/* Line 678 of lalr1.cc  */
#line 404 "parser.yy"
    {
            if (!driver.calc.existsLocalVariable(*(yysemantic_stack_[(4) - (1)].stringVal)))
            {
             error(yyloc, std::string("Warning: Unknown variable \"") + *(yysemantic_stack_[(4) - (1)].stringVal) + "\".");
             (yyval.BaseNode) = new CNLocalVariableReference(*(yysemantic_stack_[(4) - (1)].stringVal), driver.calc.currentLocalVars, new CNMultiply(new CNConstant(driver.calc.sizeOfFloat), (yysemantic_stack_[(4) - (3)].BaseNode)));
             if(((yysemantic_stack_[(4) - (3)].BaseNode)->isConstant())&&((yysemantic_stack_[(4) - (3)].BaseNode)->evaluate()>0))
             {
                double localRequestedAllocationSize;
                localRequestedAllocationSize=(((yysemantic_stack_[(4) - (3)].BaseNode)->evaluate())+1)*((double)driver.calc.sizeOfFloat);
                /* if constant expression, allocate that many bytes to this variable */
                if(localRequestedAllocationSize<=(double)driver.calc.maxLocalAllocationSize)
                {
                        /* allocate the space */
                        std::vector<ADDRESS_TYPE> myVector;
                        myVector.clear();
                        myVector.insert(myVector.end(), driver.calc.currentLocalVars);
                        myVector.insert(myVector.end(), (ADDRESS_TYPE)localRequestedAllocationSize);
                        driver.calc.localVariables[driver.calc.scriptNumber].insert(std::pair<std::string, std::vector<ADDRESS_TYPE>>(*(yysemantic_stack_[(4) - (1)].stringVal), myVector));
                        driver.calc.currentLocalVars+=(ADDRESS_TYPE)localRequestedAllocationSize;
                        error(yyloc, std::string("Warning: Non standard allocation size requested, "+getStdStringFromString(formatStringFloat((double)localRequestedAllocationSize, 0))+" bytes."));
                }
                else
                {
                        /* allocation size requested is too large */
                        error(yyloc, std::string("Error  : Allocation size requested, "+getStdStringFromString(formatStringFloat((double)localRequestedAllocationSize, 0))+" bytes is too large. The maximum is "+getStdStringFromString(formatStringFloat((double)driver.calc.maxLocalAllocationSize, 0))+" bytes."));
                        delete (yysemantic_stack_[(4) - (1)].stringVal);
                        delete (yysemantic_stack_[(4) - (3)].BaseNode);
                        YYERROR;
                }
             }
             else
             {
                std::vector<ADDRESS_TYPE> myVector;
                myVector.clear();
                myVector.insert(myVector.end(), driver.calc.currentLocalVars);
                myVector.insert(myVector.end(), (ADDRESS_TYPE)driver.calc.sizeOfFloat);
                driver.calc.localVariables[driver.calc.scriptNumber].insert(std::pair<std::string, std::vector<ADDRESS_TYPE>>(*(yysemantic_stack_[(4) - (1)].stringVal), myVector));
                driver.calc.currentLocalVars+=driver.calc.sizeOfFloat;
             }
             delete (yysemantic_stack_[(4) - (1)].stringVal);
            }
           else
           {
            (yyval.BaseNode) = new CNLocalVariableReference(*(yysemantic_stack_[(4) - (1)].stringVal), driver.calc.localVariables[driver.calc.scriptNumber][*(yysemantic_stack_[(4) - (1)].stringVal)][POSITION_OF_ADDRESS], new CNMultiply((yysemantic_stack_[(4) - (3)].BaseNode), new CNConstant(driver.calc.sizeOfFloat)));
            delete (yysemantic_stack_[(4) - (1)].stringVal);
           }
           }
    break;

  case 18:

/* Line 678 of lalr1.cc  */
#line 453 "parser.yy"
    {
            if (!driver.calc.existsLocalVariable(*(yysemantic_stack_[(4) - (1)].stringVal)))
            {
             error(yyloc, std::string("Warning: Unknown variable \"") + *(yysemantic_stack_[(4) - (1)].stringVal) + "\".");
             (yyval.BaseNode) = new CNLocalVariableByteReference(*(yysemantic_stack_[(4) - (1)].stringVal), driver.calc.currentLocalVars, (yysemantic_stack_[(4) - (3)].BaseNode));
             if(((yysemantic_stack_[(4) - (3)].BaseNode)->isConstant())&&((yysemantic_stack_[(4) - (3)].BaseNode)->evaluate()>0))
             {
                double localRequestedAllocationSize;
                localRequestedAllocationSize=(((yysemantic_stack_[(4) - (3)].BaseNode)->evaluate())+1);
                /* if constant expression, allocate that many bytes to this variable */
                if(localRequestedAllocationSize<=(double)driver.calc.maxLocalAllocationSize)
                {
                        /* allocate the space */
                        std::vector<ADDRESS_TYPE> myVector;
                        myVector.clear();
                        myVector.insert(myVector.end(), driver.calc.currentLocalVars);
                        myVector.insert(myVector.end(), (ADDRESS_TYPE)localRequestedAllocationSize);
                        driver.calc.localVariables[driver.calc.scriptNumber].insert(std::pair<std::string, std::vector<ADDRESS_TYPE>>(*(yysemantic_stack_[(4) - (1)].stringVal), myVector));
                        driver.calc.currentLocalVars+=(ADDRESS_TYPE)localRequestedAllocationSize;
                        error(yyloc, std::string("Warning: Non standard allocation size requested, "+getStdStringFromString(formatStringFloat((double)localRequestedAllocationSize, 0))+" bytes."));
                }
                else
                {
                        /* allocation size requested is too large */
                        error(yyloc, std::string("Error  : Allocation size requested, "+getStdStringFromString(formatStringFloat((double)localRequestedAllocationSize, 0))+" bytes is too large. The Maximum is "+getStdStringFromString(formatStringFloat((double)driver.calc.maxLocalAllocationSize, 0))+" bytes."));
                        delete (yysemantic_stack_[(4) - (1)].stringVal);
                        delete (yysemantic_stack_[(4) - (3)].BaseNode);
                        YYERROR;
                }
             }
             else
             {
                std::vector<ADDRESS_TYPE> myVector;
                myVector.clear();
                myVector.insert(myVector.end(), driver.calc.currentLocalVars);
                myVector.insert(myVector.end(), (ADDRESS_TYPE)driver.calc.sizeOfFloat);
                driver.calc.localVariables[driver.calc.scriptNumber].insert(std::pair<std::string, std::vector<ADDRESS_TYPE>>(*(yysemantic_stack_[(4) - (1)].stringVal), myVector));
                driver.calc.currentLocalVars+=driver.calc.sizeOfFloat;
             }
             delete (yysemantic_stack_[(4) - (1)].stringVal);
            }
           else
           {
            (yyval.BaseNode) = new CNLocalVariableByteReference(*(yysemantic_stack_[(4) - (1)].stringVal), driver.calc.localVariables[driver.calc.scriptNumber][*(yysemantic_stack_[(4) - (1)].stringVal)][POSITION_OF_ADDRESS], (yysemantic_stack_[(4) - (3)].BaseNode));
            delete (yysemantic_stack_[(4) - (1)].stringVal);
           }
           }
    break;

  case 19:

/* Line 678 of lalr1.cc  */
#line 502 "parser.yy"
    {
            if (!driver.calc.existsGlobalVariable(*(yysemantic_stack_[(1) - (1)].stringVal)))
            {
             error(yyloc, std::string("Error  : Unknown global variable \"") + *(yysemantic_stack_[(1) - (1)].stringVal) + "\".");
             delete (yysemantic_stack_[(1) - (1)].stringVal);
             YYERROR;
            }
           else
           {

            if(driver.calc.isFloatGlobalVariable(*(yysemantic_stack_[(1) - (1)].stringVal)))
            {
               (yyval.BaseNode) = new CNGlobalVariableReference(*(yysemantic_stack_[(1) - (1)].stringVal), driver.calc.globalVariables[*(yysemantic_stack_[(1) - (1)].stringVal)][POSITION_OF_ADDRESS], 0);
               delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
            else
            {
                ADDRESS_TYPE size;
                size=driver.calc.globalVariables[*(yysemantic_stack_[(1) - (1)].stringVal)][POSITION_OF_SIZE];
                if((size==(ADDRESS_TYPE)sizeof(char))||(size==(ADDRESS_TYPE)sizeof(unsigned short))||(size==(ADDRESS_TYPE)sizeof(unsigned long)))
                {
                    (yyval.BaseNode) = new CNGlobalVariableReferenceAutomatic(*(yysemantic_stack_[(1) - (1)].stringVal), driver.calc.globalVariables[*(yysemantic_stack_[(1) - (1)].stringVal)][POSITION_OF_ADDRESS], size);
                    delete (yysemantic_stack_[(1) - (1)].stringVal);
                }
                else
                {
                    (yyval.BaseNode) = new CNGlobalVariableByteReference(*(yysemantic_stack_[(1) - (1)].stringVal), driver.calc.globalVariables[*(yysemantic_stack_[(1) - (1)].stringVal)][POSITION_OF_ADDRESS], 0);
                    delete (yysemantic_stack_[(1) - (1)].stringVal);
                }
            }
           }
           }
    break;

  case 20:

/* Line 678 of lalr1.cc  */
#line 536 "parser.yy"
    {
            if (!driver.calc.existsGlobalVariable(*(yysemantic_stack_[(4) - (1)].stringVal)))
            {
             error(yyloc, std::string("Error  : Unknown global variable \"") + *(yysemantic_stack_[(4) - (1)].stringVal) + "\".");
             delete (yysemantic_stack_[(4) - (1)].stringVal);
             YYERROR;
            }
           else
           {
            (yyval.BaseNode) = new CNGlobalVariableReference(*(yysemantic_stack_[(4) - (1)].stringVal), driver.calc.globalVariables[*(yysemantic_stack_[(4) - (1)].stringVal)][POSITION_OF_ADDRESS], (yysemantic_stack_[(4) - (3)].BaseNode));
            delete (yysemantic_stack_[(4) - (1)].stringVal);
           }
           }
    break;

  case 21:

/* Line 678 of lalr1.cc  */
#line 551 "parser.yy"
    {
            if (!driver.calc.existsGlobalVariable(*(yysemantic_stack_[(4) - (1)].stringVal)))
            {
             error(yyloc, std::string("Error  : Unknown global variable \"") + *(yysemantic_stack_[(4) - (1)].stringVal) + "\".");
             delete (yysemantic_stack_[(4) - (1)].stringVal);
             YYERROR;
            }
           else
           {
            (yyval.BaseNode) = new CNGlobalVariableByteReference(*(yysemantic_stack_[(4) - (1)].stringVal), driver.calc.globalVariables[*(yysemantic_stack_[(4) - (1)].stringVal)][POSITION_OF_ADDRESS], (yysemantic_stack_[(4) - (3)].BaseNode));
            delete (yysemantic_stack_[(4) - (1)].stringVal);
           }
           }
    break;

  case 22:

/* Line 678 of lalr1.cc  */
#line 566 "parser.yy"
    {
                 (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
                 delete (yysemantic_stack_[(1) - (1)].stringVal);
                }
    break;

  case 23:

/* Line 678 of lalr1.cc  */
#line 572 "parser.yy"
    {
                 (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
                 delete (yysemantic_stack_[(1) - (1)].stringVal);
                }
    break;

  case 24:

/* Line 678 of lalr1.cc  */
#line 578 "parser.yy"
    {
                 (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
                 delete (yysemantic_stack_[(1) - (1)].stringVal);
                }
    break;

  case 25:

/* Line 678 of lalr1.cc  */
#line 584 "parser.yy"
    {
                 (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
                 delete (yysemantic_stack_[(1) - (1)].stringVal);
                }
    break;

  case 26:

/* Line 678 of lalr1.cc  */
#line 590 "parser.yy"
    {
                (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
                delete (yysemantic_stack_[(1) - (1)].stringVal);
                }
    break;

  case 27:

/* Line 678 of lalr1.cc  */
#line 596 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 28:

/* Line 678 of lalr1.cc  */
#line 602 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 29:

/* Line 678 of lalr1.cc  */
#line 608 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 30:

/* Line 678 of lalr1.cc  */
#line 614 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 31:

/* Line 678 of lalr1.cc  */
#line 620 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 32:

/* Line 678 of lalr1.cc  */
#line 626 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 33:

/* Line 678 of lalr1.cc  */
#line 632 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 34:

/* Line 678 of lalr1.cc  */
#line 638 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 35:

/* Line 678 of lalr1.cc  */
#line 644 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 36:

/* Line 678 of lalr1.cc  */
#line 650 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 37:

/* Line 678 of lalr1.cc  */
#line 656 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 38:

/* Line 678 of lalr1.cc  */
#line 662 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 39:

/* Line 678 of lalr1.cc  */
#line 668 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 40:

/* Line 678 of lalr1.cc  */
#line 674 "parser.yy"
    {
            (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
           }
    break;

  case 41:

/* Line 678 of lalr1.cc  */
#line 679 "parser.yy"
    {
            (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
           }
    break;

  case 42:

/* Line 678 of lalr1.cc  */
#line 684 "parser.yy"
    {
            (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
           }
    break;

  case 43:

/* Line 678 of lalr1.cc  */
#line 689 "parser.yy"
    {
            (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
           }
    break;

  case 44:

/* Line 678 of lalr1.cc  */
#line 694 "parser.yy"
    {
            (yyval.BaseNode) = (yysemantic_stack_[(3) - (2)].BaseNode);
           }
    break;

  case 45:

/* Line 678 of lalr1.cc  */
#line 699 "parser.yy"
    {
                 if (driver.calc.existsDefineConstant(*(yysemantic_stack_[(2) - (2)].BaseNode)->getReferenceName()))
                 {
                     error(yyloc, std::string("Error  : Cannot access address of define constant."));
                     delete (yysemantic_stack_[(2) - (2)].BaseNode);
                     YYERROR;
                 }
                 else
                 if (driver.calc.existsLocalVariable(*(yysemantic_stack_[(2) - (2)].BaseNode)->getReferenceName()))
                 {
                     if(!((yysemantic_stack_[(2) - (2)].BaseNode)->offsetExpression))
                     {
                     (yyval.BaseNode) = new CNConstant(0+driver.calc.localVariables[driver.calc.scriptNumber][*(yysemantic_stack_[(2) - (2)].BaseNode)->getReferenceName()][POSITION_OF_ADDRESS]);
                     delete (yysemantic_stack_[(2) - (2)].BaseNode);
                     }
                     else
                     if((yysemantic_stack_[(2) - (2)].BaseNode)->offsetExpression->isConstant())
                     {
                     /* accessing the address of the variable, as a numeric constant */
                     (yyval.BaseNode) = new CNConstant((yysemantic_stack_[(2) - (2)].BaseNode)->offsetExpression->evaluate()+driver.calc.localVariables[driver.calc.scriptNumber][*(yysemantic_stack_[(2) - (2)].BaseNode)->getReferenceName()][POSITION_OF_ADDRESS]);
                     delete (yysemantic_stack_[(2) - (2)].BaseNode);
                     }
                     else
                     {
                     error(yyloc, std::string("Error  : Non constant address requested!"));
                     delete (yysemantic_stack_[(2) - (2)].BaseNode);
                     YYERROR;
                     }
                 }
                 else
                 if (driver.calc.existsGlobalVariable(*(yysemantic_stack_[(2) - (2)].BaseNode)->getReferenceName()))
                 {
                     error(yyloc, std::string("Error  : Cannot access address of global variable \""+ *(yysemantic_stack_[(2) - (2)].BaseNode)->getReferenceName() + "\"."));
                     delete (yysemantic_stack_[(2) - (2)].BaseNode);
                     YYERROR;
                 }
                 else
                 {
                     error(yyloc, std::string("Error  : Bad address of argument \"") + *(yysemantic_stack_[(2) - (2)].BaseNode)->getReferenceName() + "\".");
                     delete (yysemantic_stack_[(2) - (2)].BaseNode);
                     YYERROR;
                 }
             }
    break;

  case 46:

/* Line 678 of lalr1.cc  */
#line 744 "parser.yy"
    {
                 if (driver.calc.existsLocalStringVariable(*(yysemantic_stack_[(2) - (2)].CNStringVariableReference)->getReferenceName()))
                 {
                     if(!((yysemantic_stack_[(2) - (2)].CNStringVariableReference)->offsetExpression))
                     {
                     /* accessing the address of the string variable, as a numeric constant */
                     (yyval.BaseNode) = new CNConstant(0+driver.calc.localStringVariables[driver.calc.scriptNumber][*(yysemantic_stack_[(2) - (2)].CNStringVariableReference)->getReferenceName()][POSITION_OF_ADDRESS]);
                     delete (yysemantic_stack_[(2) - (2)].CNStringVariableReference);
                     }
                     else
                     if((yysemantic_stack_[(2) - (2)].CNStringVariableReference)->offsetExpression->isConstant())
                     {
                     /* accessing the address of the string variable, as a numeric constant */
                     (yyval.BaseNode) = new CNConstant((yysemantic_stack_[(2) - (2)].CNStringVariableReference)->offsetExpression->evaluate()+(double)driver.calc.localStringVariables[driver.calc.scriptNumber][*(yysemantic_stack_[(2) - (2)].CNStringVariableReference)->getReferenceName()][POSITION_OF_ADDRESS]);
                     delete (yysemantic_stack_[(2) - (2)].CNStringVariableReference);
                     }
                     else
                     {
                     error(yyloc, std::string("Error  : Non constant address requested!"));
                     delete (yysemantic_stack_[(2) - (2)].CNStringVariableReference);
                     YYERROR;
                     }
                 }
                 else
                 if (driver.calc.existsGlobalStringVariable(*(yysemantic_stack_[(2) - (2)].CNStringVariableReference)->getReferenceName()))
                 {
                     error(yyloc, std::string("Error  : Cannot access address of global string variable \""+ *(yysemantic_stack_[(2) - (2)].CNStringVariableReference)->getReferenceName() + "\"."));
                     delete (yysemantic_stack_[(2) - (2)].CNStringVariableReference);
                     YYERROR;
                 }
                 else
                 {
                     error(yyloc, std::string("Error  : Bad address of argument \"") + *(yysemantic_stack_[(2) - (2)].CNStringVariableReference)->getReferenceName() + "\".");
                     delete (yysemantic_stack_[(2) - (2)].CNStringVariableReference);
                     YYERROR;
                 }
             }
    break;

  case 47:

/* Line 678 of lalr1.cc  */
#line 783 "parser.yy"
    {
                 /* size of operator */
                 if (driver.calc.existsDefineConstant(*(yysemantic_stack_[(2) - (2)].BaseNode)->getReferenceName()))
                 {
                     error(yyloc, std::string("Error  : Cannot access size of define constant."));
                     delete (yysemantic_stack_[(2) - (2)].BaseNode);
                     YYERROR;
                 }
                 else
                 if (driver.calc.existsLocalVariable(*(yysemantic_stack_[(2) - (2)].BaseNode)->getReferenceName()))
                 {
                     ADDRESS_TYPE sizeofvar;

                     sizeofvar=driver.calc.getSizeOfLocalVariable(*(yysemantic_stack_[(2) - (2)].BaseNode)->getReferenceName());
                     (yyval.BaseNode) = new CNConstant((double)sizeofvar);
                     delete (yysemantic_stack_[(2) - (2)].BaseNode);
                 }
                 else
                 if (driver.calc.existsGlobalVariable(*(yysemantic_stack_[(2) - (2)].BaseNode)->getReferenceName()))
                 {
                     ADDRESS_TYPE sizeofvar;

                     sizeofvar=driver.calc.getSizeOfGlobalVariable(*(yysemantic_stack_[(2) - (2)].BaseNode)->getReferenceName());
                     (yyval.BaseNode) = new CNConstant((double)sizeofvar);
                     delete (yysemantic_stack_[(2) - (2)].BaseNode);
                 }
                 else
                 {
                     error(yyloc, std::string("Error  : Bad size of argument \"") + *(yysemantic_stack_[(2) - (2)].BaseNode)->getReferenceName() + "\".");
                     delete (yysemantic_stack_[(2) - (2)].BaseNode);
                     YYERROR;
                 }
             }
    break;

  case 48:

/* Line 678 of lalr1.cc  */
#line 818 "parser.yy"
    {
                 /* size of operator */
                 if (driver.calc.existsLocalStringVariable(*(yysemantic_stack_[(2) - (2)].CNStringVariableReference)->getReferenceName()))
                 {
                     ADDRESS_TYPE sizeofvar;

                     sizeofvar=driver.calc.getSizeOfLocalStringVariable(*(yysemantic_stack_[(2) - (2)].CNStringVariableReference)->getReferenceName());
                     (yyval.BaseNode) = new CNConstant((double)sizeofvar);
                     delete (yysemantic_stack_[(2) - (2)].CNStringVariableReference);
                 }
                 else
                 if (driver.calc.existsGlobalStringVariable(*(yysemantic_stack_[(2) - (2)].CNStringVariableReference)->getReferenceName()))
                 {
                     ADDRESS_TYPE sizeofvar;

                     sizeofvar=driver.calc.getSizeOfGlobalStringVariable(*(yysemantic_stack_[(2) - (2)].CNStringVariableReference)->getReferenceName());
                     (yyval.BaseNode) = new CNConstant((double)sizeofvar);
                     delete (yysemantic_stack_[(2) - (2)].CNStringVariableReference);
                 }
                 else
                 {
                     error(yyloc, std::string("Error  : Bad size of argument \"") + *(yysemantic_stack_[(2) - (2)].CNStringVariableReference)->getReferenceName() + "\".");
                     delete (yysemantic_stack_[(2) - (2)].CNStringVariableReference);
                     YYERROR;
                 }
             }
    break;

  case 49:

/* Line 678 of lalr1.cc  */
#line 847 "parser.yy"
    {
            (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
          }
    break;

  case 50:

/* Line 678 of lalr1.cc  */
#line 852 "parser.yy"
    {
           (yyval.BaseNode) = new CNPower((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
          }
    break;

  case 51:

/* Line 678 of lalr1.cc  */
#line 858 "parser.yy"
    {
         (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
        }
    break;

  case 52:

/* Line 678 of lalr1.cc  */
#line 863 "parser.yy"
    {
         (yyval.BaseNode) = (yysemantic_stack_[(2) - (2)].BaseNode);
        }
    break;

  case 53:

/* Line 678 of lalr1.cc  */
#line 868 "parser.yy"
    {
         (yyval.BaseNode) = new CNNegate((yysemantic_stack_[(2) - (2)].BaseNode));
        }
    break;

  case 54:

/* Line 678 of lalr1.cc  */
#line 873 "parser.yy"
    {
         (yyval.BaseNode) = new CNLogicalNot((yysemantic_stack_[(2) - (2)].BaseNode));
        }
    break;

  case 55:

/* Line 678 of lalr1.cc  */
#line 879 "parser.yy"
    {
           (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
          }
    break;

  case 56:

/* Line 678 of lalr1.cc  */
#line 884 "parser.yy"
    {
           (yyval.BaseNode) = new CNBooleanEqu((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
           delete (yysemantic_stack_[(3) - (2)].BaseNode);
          }
    break;

  case 57:

/* Line 678 of lalr1.cc  */
#line 890 "parser.yy"
    {
           (yyval.BaseNode) = new CNBooleanNeq((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
           delete (yysemantic_stack_[(3) - (2)].BaseNode);
          }
    break;

  case 58:

/* Line 678 of lalr1.cc  */
#line 896 "parser.yy"
    {
           (yyval.BaseNode) = new CNBooleanGte((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
           delete (yysemantic_stack_[(3) - (2)].BaseNode);
          }
    break;

  case 59:

/* Line 678 of lalr1.cc  */
#line 902 "parser.yy"
    {
           (yyval.BaseNode) = new CNBooleanLte((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
           delete (yysemantic_stack_[(3) - (2)].BaseNode);
          }
    break;

  case 60:

/* Line 678 of lalr1.cc  */
#line 908 "parser.yy"
    {
           (yyval.BaseNode) = new CNBooleanGt((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
           delete (yysemantic_stack_[(3) - (2)].BaseNode);
          }
    break;

  case 61:

/* Line 678 of lalr1.cc  */
#line 914 "parser.yy"
    {
           (yyval.BaseNode) = new CNBooleanLt((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
           delete (yysemantic_stack_[(3) - (2)].BaseNode);
          }
    break;

  case 62:

/* Line 678 of lalr1.cc  */
#line 920 "parser.yy"
    {
           (yyval.BaseNode) = new CNBooleanAnd((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
           delete (yysemantic_stack_[(3) - (2)].BaseNode);
          }
    break;

  case 63:

/* Line 678 of lalr1.cc  */
#line 926 "parser.yy"
    {
           (yyval.BaseNode) = new CNBooleanOr((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
           delete (yysemantic_stack_[(3) - (2)].BaseNode);
          }
    break;

  case 64:

/* Line 678 of lalr1.cc  */
#line 932 "parser.yy"
    {
           (yyval.BaseNode) = new CNBooleanXor((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
           delete (yysemantic_stack_[(3) - (2)].BaseNode);
          }
    break;

  case 65:

/* Line 678 of lalr1.cc  */
#line 938 "parser.yy"
    {
           (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
          }
    break;

  case 66:

/* Line 678 of lalr1.cc  */
#line 943 "parser.yy"
    {
           (yyval.BaseNode) = new CNMultiply((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
          }
    break;

  case 67:

/* Line 678 of lalr1.cc  */
#line 948 "parser.yy"
    {
           (yyval.BaseNode) = new CNDivide((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
          }
    break;

  case 68:

/* Line 678 of lalr1.cc  */
#line 953 "parser.yy"
    {
           (yyval.BaseNode) = new CNModulo((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
          }
    break;

  case 69:

/* Line 678 of lalr1.cc  */
#line 958 "parser.yy"
    {
           (yyval.BaseNode) = new CNLogicalAnd((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
          }
    break;

  case 70:

/* Line 678 of lalr1.cc  */
#line 963 "parser.yy"
    {
           (yyval.BaseNode) = new CNLogicalOr((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
          }
    break;

  case 71:

/* Line 678 of lalr1.cc  */
#line 968 "parser.yy"
    {
           (yyval.BaseNode) = new CNLogicalXor((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
          }
    break;

  case 72:

/* Line 678 of lalr1.cc  */
#line 973 "parser.yy"
    {
           (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
          }
    break;

  case 73:

/* Line 678 of lalr1.cc  */
#line 978 "parser.yy"
    {
           (yyval.BaseNode) = new CNAdd((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
          }
    break;

  case 74:

/* Line 678 of lalr1.cc  */
#line 983 "parser.yy"
    {
            (yyval.BaseNode) = new CNSubtract((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
          }
    break;

  case 75:

/* Line 678 of lalr1.cc  */
#line 988 "parser.yy"
    {
           if((yysemantic_stack_[(1) - (1)].BaseNode)->isConstant())
           {
            (yyval.BaseNode) = new CNConstant((yysemantic_stack_[(1) - (1)].BaseNode)->evaluate());
            delete (yysemantic_stack_[(1) - (1)].BaseNode);
           }
           else
           {
            (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
           }
          }
    break;

  case 76:

/* Line 678 of lalr1.cc  */
#line 1001 "parser.yy"
    {
                (yyval.BaseNode) = new CNTimeUntilCommand((yysemantic_stack_[(4) - (3)].BaseNode));
                delete (yysemantic_stack_[(4) - (1)].BaseNode);
            }
    break;

  case 77:

/* Line 678 of lalr1.cc  */
#line 1007 "parser.yy"
    {
                (yyval.BaseNode) = new CNTimeCommand((yysemantic_stack_[(4) - (3)].BaseNode));
                delete (yysemantic_stack_[(4) - (1)].BaseNode);
            }
    break;

  case 78:

/* Line 678 of lalr1.cc  */
#line 1013 "parser.yy"
    {
                 if (driver.calc.existsDefineConstant(*(yysemantic_stack_[(4) - (1)].BaseNode)->getReferenceName()))
                 {
                     if((yysemantic_stack_[(4) - (3)].BaseNode)->isConstant())
                     {
                     driver.calc.defineConstants[*(yysemantic_stack_[(4) - (1)].BaseNode)->getReferenceName()]=(double)(yysemantic_stack_[(4) - (3)].BaseNode)->evaluate();
                     error(yyloc, std::string("Warning: Define constant \""+ *(yysemantic_stack_[(4) - (1)].BaseNode)->getReferenceName() +"\" redefined."));
                     (yyval.BaseNode) = 0;
                     delete (yysemantic_stack_[(4) - (1)].BaseNode);
                     delete (yysemantic_stack_[(4) - (3)].BaseNode);
                     }
                     else
                     {
                     error(yyloc, std::string("Error  : Define constant assignment is not a constant."));
                     delete (yysemantic_stack_[(4) - (1)].BaseNode);
                     delete (yysemantic_stack_[(4) - (3)].BaseNode);
                     YYERROR;
                     }
                 }
                 else
                 if (driver.calc.existsLocalVariable(*(yysemantic_stack_[(4) - (1)].BaseNode)->getReferenceName()))
                 {
                     // error(yyloc, std::string("Warning: Access local variable \""+ *$1->getReferenceName() +"\"."));
                     (yyval.BaseNode) = new CNLocalVariableAssignment((yysemantic_stack_[(4) - (1)].BaseNode), (yysemantic_stack_[(4) - (3)].BaseNode));
                 }
                 else
                 if (driver.calc.existsGlobalVariable(*(yysemantic_stack_[(4) - (1)].BaseNode)->getReferenceName()))
                 {
                     // error(yyloc, std::string("Warning: Access global variable \""+ *$1->getReferenceName() + "\"."));
                     (yyval.BaseNode) = new CNGlobalVariableAssignment((yysemantic_stack_[(4) - (1)].BaseNode), (yysemantic_stack_[(4) - (3)].BaseNode));
                 }
                 else
                 {
                     error(yyloc, std::string("Error  : Bad assignment target \"") + *(yysemantic_stack_[(4) - (1)].BaseNode)->getReferenceName() + "\".");
                     delete (yysemantic_stack_[(4) - (1)].BaseNode);
                     delete (yysemantic_stack_[(4) - (3)].BaseNode);
                     YYERROR;
                 }
             }
    break;

  case 79:

/* Line 678 of lalr1.cc  */
#line 1054 "parser.yy"
    {
                 if (driver.calc.existsLocalStringVariable(*(yysemantic_stack_[(4) - (1)].CNStringVariableReference)->getReferenceName()))
                 {
                     error(yyloc, std::string("Warning: Access local string variable \""+ *(yysemantic_stack_[(4) - (1)].CNStringVariableReference)->getReferenceName() +"\"."));
                     (yyval.BaseNode) = new CNLocalStringVariableAssignment((yysemantic_stack_[(4) - (1)].CNStringVariableReference), (yysemantic_stack_[(4) - (3)].BaseNode));
                 }
                 else
                 if (driver.calc.existsGlobalStringVariable(*(yysemantic_stack_[(4) - (1)].CNStringVariableReference)->getReferenceName()))
                 {
                     error(yyloc, std::string("Warning: Access global string variable \""+ *(yysemantic_stack_[(4) - (1)].CNStringVariableReference)->getReferenceName() + "\"."));
                     (yyval.BaseNode) = new CNGlobalStringVariableAssignment((yysemantic_stack_[(4) - (1)].CNStringVariableReference), (yysemantic_stack_[(4) - (3)].BaseNode));
                 }
                 else
                 {
                     error(yyloc, std::string("Error  : Bad assignment target \"") + *(yysemantic_stack_[(4) - (1)].CNStringVariableReference)->getReferenceName() + "\".");
                     delete (yysemantic_stack_[(4) - (1)].CNStringVariableReference);
                     delete (yysemantic_stack_[(4) - (3)].BaseNode);
                     YYERROR;
                 }
             }
    break;

  case 80:

/* Line 678 of lalr1.cc  */
#line 1076 "parser.yy"
    {
                 (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
                 delete (yysemantic_stack_[(1) - (1)].stringVal);
                }
    break;

  case 81:

/* Line 678 of lalr1.cc  */
#line 1082 "parser.yy"
    {
                 (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
                 delete (yysemantic_stack_[(1) - (1)].stringVal);
                }
    break;

  case 82:

/* Line 678 of lalr1.cc  */
#line 1088 "parser.yy"
    {
             (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
            }
    break;

  case 83:

/* Line 678 of lalr1.cc  */
#line 1094 "parser.yy"
    {
             (yyval.BaseNode) = new CNArgument((yysemantic_stack_[(1) - (1)].BaseNode), 0);
            }
    break;

  case 84:

/* Line 678 of lalr1.cc  */
#line 1098 "parser.yy"
    {
             (yyval.BaseNode) = new CNArgument((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
            }
    break;

  case 85:

/* Line 678 of lalr1.cc  */
#line 1104 "parser.yy"
    {
             (yyval.BaseNode) = 0;
            }
    break;

  case 86:

/* Line 678 of lalr1.cc  */
#line 1109 "parser.yy"
    {
             (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
            }
    break;

  case 87:

/* Line 678 of lalr1.cc  */
#line 1114 "parser.yy"
    {
                 if(!driver.calc.existsGlobalFunction(*(yysemantic_stack_[(4) - (1)].stringVal)))
                 {
                    error(yyloc, std::string("Error  : Global function \""+ *(yysemantic_stack_[(4) - (1)].stringVal) + "\" does not exist."));
                    delete (yysemantic_stack_[(4) - (1)].stringVal);
                    delete (yysemantic_stack_[(4) - (3)].BaseNode);
                    YYERROR;
                 }
                 else
                 {
                    (yyval.BaseNode) = new CNGlobalFunctionCall(*(yysemantic_stack_[(4) - (1)].stringVal), (yysemantic_stack_[(4) - (3)].BaseNode), &driver.calc);
                    delete (yysemantic_stack_[(4) - (1)].stringVal);
                 }
               }
    break;

  case 88:

/* Line 678 of lalr1.cc  */
#line 1130 "parser.yy"
    {
                 if(!driver.calc.existsLocalFunction(*(yysemantic_stack_[(4) - (1)].stringVal)))
                 {
                    error(yyloc, std::string("Error  : Local function \""+ *(yysemantic_stack_[(4) - (1)].stringVal) + "\" does not exist."));
                    delete (yysemantic_stack_[(4) - (1)].stringVal);
                    delete (yysemantic_stack_[(4) - (3)].BaseNode);
                    YYERROR;
                 }
                 else
                 {
                    (yyval.BaseNode) = new CNLocalFunctionCall(*(yysemantic_stack_[(4) - (1)].stringVal), (yysemantic_stack_[(4) - (3)].BaseNode), &driver.calc);
                    delete (yysemantic_stack_[(4) - (1)].stringVal);
                 }
               }
    break;

  case 89:

/* Line 678 of lalr1.cc  */
#line 1147 "parser.yy"
    {
                (yyval.BaseNode) = (yysemantic_stack_[(2) - (1)].BaseNode);
               }
    break;

  case 90:

/* Line 678 of lalr1.cc  */
#line 1153 "parser.yy"
    {
                 if(driver.calc.existsLocalFunction(*(yysemantic_stack_[(5) - (2)].stringVal)))
                 {
                    error(yyloc, std::string("Error  : Local function \""+ *(yysemantic_stack_[(5) - (2)].stringVal) + "\" redefined."));
                    delete (yysemantic_stack_[(5) - (1)].BaseNode);
                    delete (yysemantic_stack_[(5) - (2)].stringVal);
                    delete (yysemantic_stack_[(5) - (5)].BaseNode);
                    YYERROR;
                 }
                 else
                 {
                    std::vector<ADDRESS_TYPE> myVector;
                    myVector.clear();
                    myVector.insert(myVector.end(), driver.calc.currentFunctions);
                    myVector.insert(myVector.end(), (ADDRESS_TYPE)0);
                    driver.calc.localFunctions[driver.calc.scriptNumber].insert(std::pair<std::string, std::vector<ADDRESS_TYPE>>(*(yysemantic_stack_[(5) - (2)].stringVal), myVector));
                    error(yyloc, std::string("Warning: Defined local function \"" + *(yysemantic_stack_[(5) - (2)].stringVal) + "\"."));
                    (yyval.BaseNode) = new CNFunctionDefinition(*(yysemantic_stack_[(5) - (2)].stringVal), (yysemantic_stack_[(5) - (5)].BaseNode), (ADDRESS_TYPE)0, &driver.calc);
                    driver.calc.currentFunctions++;
                    delete (yysemantic_stack_[(5) - (1)].BaseNode);
                    delete (yysemantic_stack_[(5) - (2)].stringVal);
                 }
               }
    break;

  case 91:

/* Line 678 of lalr1.cc  */
#line 1178 "parser.yy"
    {
                 if(driver.calc.existsLocalFunction(*(yysemantic_stack_[(6) - (2)].stringVal)))
                 {
                    error(yyloc, std::string("Error  : Local function \""+ *(yysemantic_stack_[(6) - (2)].stringVal) + "\" redefined."));
                    delete (yysemantic_stack_[(6) - (1)].BaseNode);
                    delete (yysemantic_stack_[(6) - (2)].stringVal);
                    delete (yysemantic_stack_[(6) - (6)].BaseNode);
                    YYERROR;
                 }
                 else
                 {
                  if((yysemantic_stack_[(6) - (4)].BaseNode)->isConstant())
                  {
                   unsigned int args;
                   args=(unsigned int)(yysemantic_stack_[(6) - (4)].BaseNode)->evaluate();
                   if((args>=0)&&(args<256))
                   {
                   error(yyloc, std::string("Warning: Defined local function \"" + *(yysemantic_stack_[(6) - (2)].stringVal) + "\"."));
                   std::vector<ADDRESS_TYPE> myVector;
                   myVector.clear();
                   myVector.insert(myVector.end(), driver.calc.currentFunctions);
                   myVector.insert(myVector.end(), (ADDRESS_TYPE)(yysemantic_stack_[(6) - (4)].BaseNode)->evaluate());
                   driver.calc.localFunctions[driver.calc.scriptNumber].insert(std::pair<std::string, std::vector<ADDRESS_TYPE>>(*(yysemantic_stack_[(6) - (2)].stringVal), myVector));
                   (yyval.BaseNode) = new CNFunctionDefinition(*(yysemantic_stack_[(6) - (2)].stringVal), (yysemantic_stack_[(6) - (6)].BaseNode), (unsigned short)(yysemantic_stack_[(6) - (4)].BaseNode)->evaluate(), &driver.calc);
                   driver.calc.currentFunctions++;
                   delete (yysemantic_stack_[(6) - (1)].BaseNode);
                   delete (yysemantic_stack_[(6) - (2)].stringVal);
                   delete (yysemantic_stack_[(6) - (4)].BaseNode);
                   }
                   else
                   {
                    error(yyloc, std::string("Error  : Function \""+ *(yysemantic_stack_[(6) - (2)].stringVal) +"\" has a bad number of arguments, valid range is between 0 and 255 (inclusive)."));
                    delete (yysemantic_stack_[(6) - (1)].BaseNode);
                    delete (yysemantic_stack_[(6) - (2)].stringVal);
                    delete (yysemantic_stack_[(6) - (4)].BaseNode);
                    delete (yysemantic_stack_[(6) - (6)].BaseNode);
                    YYERROR;
                   }
                  }
                  else
                  {
                   error(yyloc, std::string("Error  : Function \"" + *(yysemantic_stack_[(6) - (2)].stringVal) +"\" has no constant number of arguments."));
                   delete (yysemantic_stack_[(6) - (1)].BaseNode);
                   delete (yysemantic_stack_[(6) - (2)].stringVal);
                   delete (yysemantic_stack_[(6) - (4)].BaseNode);
                   delete (yysemantic_stack_[(6) - (6)].BaseNode);
                   YYERROR;
                  }
                 }
                }
    break;

  case 92:

/* Line 678 of lalr1.cc  */
#line 1230 "parser.yy"
    {
                if((yysemantic_stack_[(5) - (3)].BaseNode)->isConstant())
                {
                    if((unsigned int)(yysemantic_stack_[(5) - (3)].BaseNode)->evaluate())
                    {
                            error(yyloc, std::string("Warning: Loop conditional always true."));
                            (yyval.BaseNode) = new CNWhileLoop((yysemantic_stack_[(5) - (3)].BaseNode), (yysemantic_stack_[(5) - (5)].BaseNode));
                            delete (yysemantic_stack_[(5) - (1)].BaseNode);
                    }
                    else
                    {
                            error(yyloc, std::string("Warning: Loop conditional always false."));
                            (yyval.BaseNode) = new CNWhileLoop((yysemantic_stack_[(5) - (3)].BaseNode), (yysemantic_stack_[(5) - (5)].BaseNode));
                            delete (yysemantic_stack_[(5) - (1)].BaseNode);
                    }
                }
                else
                {
                    (yyval.BaseNode) = new CNWhileLoop((yysemantic_stack_[(5) - (3)].BaseNode), (yysemantic_stack_[(5) - (5)].BaseNode));
                    delete (yysemantic_stack_[(5) - (1)].BaseNode);
                }
            }
    break;

  case 93:

/* Line 678 of lalr1.cc  */
#line 1254 "parser.yy"
    {
                    if((yysemantic_stack_[(7) - (3)].BaseNode)->isConstant())
                    {
                        if((unsigned int)(yysemantic_stack_[(7) - (3)].BaseNode)->evaluate())
                        {
                            error(yyloc, std::string("Warning: Conditional always true."));
                            (yyval.BaseNode) = (yysemantic_stack_[(7) - (5)].BaseNode);
                            delete (yysemantic_stack_[(7) - (1)].BaseNode);
                            delete (yysemantic_stack_[(7) - (3)].BaseNode);
                            delete (yysemantic_stack_[(7) - (6)].BaseNode);
                            delete (yysemantic_stack_[(7) - (7)].BaseNode);
                        }
                        else
                        {
                            error(yyloc, std::string("Warning: Conditional always false."));
                            (yyval.BaseNode) = (yysemantic_stack_[(7) - (7)].BaseNode);
                            delete (yysemantic_stack_[(7) - (1)].BaseNode);
                            delete (yysemantic_stack_[(7) - (3)].BaseNode);
                            delete (yysemantic_stack_[(7) - (5)].BaseNode);
                            delete (yysemantic_stack_[(7) - (6)].BaseNode);
                        }
                    }
                    else
                    {
                        (yyval.BaseNode) = new CNConditional((yysemantic_stack_[(7) - (3)].BaseNode), (yysemantic_stack_[(7) - (5)].BaseNode), (yysemantic_stack_[(7) - (7)].BaseNode));
                        delete (yysemantic_stack_[(7) - (1)].BaseNode);
                        delete (yysemantic_stack_[(7) - (6)].BaseNode);
                    }
                }
    break;

  case 94:

/* Line 678 of lalr1.cc  */
#line 1285 "parser.yy"
    {
                    if((yysemantic_stack_[(5) - (3)].BaseNode)->isConstant())
                    {
                        if((unsigned int)(yysemantic_stack_[(5) - (3)].BaseNode)->evaluate())
                        {
                            error(yyloc, std::string("Warning: Conditional always true."));
                            (yyval.BaseNode) = (yysemantic_stack_[(5) - (5)].BaseNode);
                            delete (yysemantic_stack_[(5) - (1)].BaseNode);
                            delete (yysemantic_stack_[(5) - (3)].BaseNode);
                        }
                        else
                        {
                            error(yyloc, std::string("Warning: Conditional always false."));
                            (yyval.BaseNode) = 0;
                            delete (yysemantic_stack_[(5) - (1)].BaseNode);
                            delete (yysemantic_stack_[(5) - (3)].BaseNode);
                            delete (yysemantic_stack_[(5) - (5)].BaseNode);
                        }
                    }
                    else
                    {
                        (yyval.BaseNode) = new CNConditional((yysemantic_stack_[(5) - (3)].BaseNode), (yysemantic_stack_[(5) - (5)].BaseNode), 0);
                        delete (yysemantic_stack_[(5) - (1)].BaseNode);
                    }
                }
    break;

  case 95:

/* Line 678 of lalr1.cc  */
#line 1312 "parser.yy"
    {
             (yyval.BaseNode) = 0;
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 96:

/* Line 678 of lalr1.cc  */
#line 1319 "parser.yy"
    {
              (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
              delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 97:

/* Line 678 of lalr1.cc  */
#line 1325 "parser.yy"
    {
                  (yyval.BaseNode) = new CNNewline(std::string("\r\n"));
                  delete (yysemantic_stack_[(1) - (1)].stringVal);
                }
    break;

  case 98:

/* Line 678 of lalr1.cc  */
#line 1331 "parser.yy"
    {
                  (yyval.BaseNode) = (yysemantic_stack_[(4) - (3)].BaseNode);
                }
    break;

  case 99:

/* Line 678 of lalr1.cc  */
#line 1336 "parser.yy"
    {
                  (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
                }
    break;

  case 100:

/* Line 678 of lalr1.cc  */
#line 1341 "parser.yy"
    {
                  (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
                }
    break;

  case 101:

/* Line 678 of lalr1.cc  */
#line 1346 "parser.yy"
    {
                  (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
                }
    break;

  case 102:

/* Line 678 of lalr1.cc  */
#line 1351 "parser.yy"
    {
                    (yyval.BaseNode) = new CNPrintArgumentString((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 103:

/* Line 678 of lalr1.cc  */
#line 1356 "parser.yy"
    {
                    (yyval.BaseNode) = new CNPrintArgumentString((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 104:

/* Line 678 of lalr1.cc  */
#line 1361 "parser.yy"
    {
                    (yyval.BaseNode) = new CNPrintBuiltInFunction((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 105:

/* Line 678 of lalr1.cc  */
#line 1366 "parser.yy"
    {
                    (yyval.BaseNode) = new CNPrintBaseFunction((yysemantic_stack_[(8) - (3)].BaseNode), new CNAdd(new CNSubtract((yysemantic_stack_[(8) - (5)].BaseNode), new CNConstant(1)), new CNMultiply(new CNConstant(16), (yysemantic_stack_[(8) - (7)].BaseNode))));
                    delete (yysemantic_stack_[(8) - (1)].BaseNode);
                }
    break;

  case 106:

/* Line 678 of lalr1.cc  */
#line 1372 "parser.yy"
    {
                    (yyval.BaseNode) = new CNPrintBaseFunction((yysemantic_stack_[(6) - (3)].BaseNode), new CNSubtract((yysemantic_stack_[(6) - (5)].BaseNode), new CNConstant(1)));
                    delete (yysemantic_stack_[(6) - (1)].BaseNode);
                }
    break;

  case 107:

/* Line 678 of lalr1.cc  */
#line 1378 "parser.yy"
    {
                    (yyval.BaseNode) = new CNPrintDecimal((yysemantic_stack_[(6) - (3)].BaseNode), (yysemantic_stack_[(6) - (5)].BaseNode));
                    delete (yysemantic_stack_[(6) - (1)].BaseNode);
                }
    break;

  case 108:

/* Line 678 of lalr1.cc  */
#line 1384 "parser.yy"
    {
                    (yyval.BaseNode) = new CNPrintChar((yysemantic_stack_[(4) - (3)].BaseNode));
                    delete (yysemantic_stack_[(4) - (1)].BaseNode);
                }
    break;

  case 109:

/* Line 678 of lalr1.cc  */
#line 1390 "parser.yy"
    {
                    (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].CNStringVariableReference);
                }
    break;

  case 110:

/* Line 678 of lalr1.cc  */
#line 1395 "parser.yy"
    {
                    (yyval.BaseNode) = new CNPrintArgumentExpression((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 111:

/* Line 678 of lalr1.cc  */
#line 1401 "parser.yy"
    {
                    (yyval.BaseNode) = 0;
                    }
    break;

  case 112:

/* Line 678 of lalr1.cc  */
#line 1406 "parser.yy"
    {
                    (yyval.BaseNode) = new CNPrintList((yysemantic_stack_[(1) - (1)].BaseNode), 0);
                    }
    break;

  case 113:

/* Line 678 of lalr1.cc  */
#line 1411 "parser.yy"
    {
                    (yyval.BaseNode) = new CNPrintList((yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
                    }
    break;

  case 114:

/* Line 678 of lalr1.cc  */
#line 1416 "parser.yy"
    {
                 (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
                 delete (yysemantic_stack_[(1) - (1)].stringVal);
                }
    break;

  case 115:

/* Line 678 of lalr1.cc  */
#line 1422 "parser.yy"
    {
                 (yyval.BaseNode) = new CNPrecisionCommand((yysemantic_stack_[(5) - (3)].BaseNode));
                 delete (yysemantic_stack_[(5) - (1)].BaseNode);
                }
    break;

  case 116:

/* Line 678 of lalr1.cc  */
#line 1428 "parser.yy"
    {
                 (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
                 delete (yysemantic_stack_[(1) - (1)].stringVal);
                }
    break;

  case 117:

/* Line 678 of lalr1.cc  */
#line 1434 "parser.yy"
    {
                 (yyval.BaseNode) = new CNResetCommand();
                 delete (yysemantic_stack_[(2) - (1)].BaseNode);
                }
    break;

  case 118:

/* Line 678 of lalr1.cc  */
#line 1440 "parser.yy"
    {
                    (yyval.BaseNode) = new CNTimeArgument(0, 0, 0, 0, (yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 119:

/* Line 678 of lalr1.cc  */
#line 1445 "parser.yy"
    {
                    (yyval.BaseNode) = new CNTimeArgument(0, 0, 0, (yysemantic_stack_[(3) - (1)].BaseNode), (yysemantic_stack_[(3) - (3)].BaseNode));
                }
    break;

  case 120:

/* Line 678 of lalr1.cc  */
#line 1450 "parser.yy"
    {
                    (yyval.BaseNode) = new CNTimeArgument(0, 0, (yysemantic_stack_[(5) - (1)].BaseNode), (yysemantic_stack_[(5) - (3)].BaseNode), (yysemantic_stack_[(5) - (5)].BaseNode));
                }
    break;

  case 121:

/* Line 678 of lalr1.cc  */
#line 1455 "parser.yy"
    {
                    (yyval.BaseNode) = new CNTimeArgument(0, (yysemantic_stack_[(7) - (1)].BaseNode), (yysemantic_stack_[(7) - (3)].BaseNode), (yysemantic_stack_[(7) - (5)].BaseNode), (yysemantic_stack_[(7) - (7)].BaseNode));
                }
    break;

  case 122:

/* Line 678 of lalr1.cc  */
#line 1460 "parser.yy"
    {
                    (yyval.BaseNode) = new CNTimeArgument((yysemantic_stack_[(9) - (1)].BaseNode), (yysemantic_stack_[(9) - (3)].BaseNode), (yysemantic_stack_[(9) - (5)].BaseNode), (yysemantic_stack_[(9) - (7)].BaseNode), (yysemantic_stack_[(9) - (9)].BaseNode));
                }
    break;

  case 123:

/* Line 678 of lalr1.cc  */
#line 1465 "parser.yy"
    {
                 (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
                 delete (yysemantic_stack_[(1) - (1)].stringVal);
                }
    break;

  case 124:

/* Line 678 of lalr1.cc  */
#line 1471 "parser.yy"
    {
                    (yyval.BaseNode) = new CNSleepUntilCommand((yysemantic_stack_[(5) - (3)].BaseNode));
                    delete (yysemantic_stack_[(5) - (1)].BaseNode);
                }
    break;

  case 125:

/* Line 678 of lalr1.cc  */
#line 1477 "parser.yy"
    {
                    (yyval.BaseNode) = new CNClosePipeCommand((yysemantic_stack_[(5) - (3)].BaseNode));
                    delete (yysemantic_stack_[(5) - (1)].BaseNode);
                }
    break;

  case 126:

/* Line 678 of lalr1.cc  */
#line 1483 "parser.yy"
    {
                    (yyval.BaseNode) = new CNOpenPipeCommand((yysemantic_stack_[(5) - (3)].BaseNode));
                    delete (yysemantic_stack_[(5) - (1)].BaseNode);
                }
    break;

  case 127:

/* Line 678 of lalr1.cc  */
#line 1489 "parser.yy"
    {
                    (yyval.BaseNode) = new CNSleepCommand((yysemantic_stack_[(5) - (3)].BaseNode));
                    delete (yysemantic_stack_[(5) - (1)].BaseNode);
                }
    break;

  case 128:

/* Line 678 of lalr1.cc  */
#line 1495 "parser.yy"
    {
                    (yyval.BaseNode) = new CNPrintList(0, (yysemantic_stack_[(3) - (2)].BaseNode));
                    delete (yysemantic_stack_[(3) - (1)].BaseNode);
                }
    break;

  case 129:

/* Line 678 of lalr1.cc  */
#line 1501 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 130:

/* Line 678 of lalr1.cc  */
#line 1507 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
             delete (yysemantic_stack_[(1) - (1)].stringVal);
            }
    break;

  case 131:

/* Line 678 of lalr1.cc  */
#line 1513 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
            }
    break;

  case 132:

/* Line 678 of lalr1.cc  */
#line 1518 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
            }
    break;

  case 133:

/* Line 678 of lalr1.cc  */
#line 1523 "parser.yy"
    {
             (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
            }
    break;

  case 134:

/* Line 678 of lalr1.cc  */
#line 1529 "parser.yy"
    {
                (yyval.BaseNode) = new CNClearFileCommand((yysemantic_stack_[(3) - (2)].BaseNode));
                delete (yysemantic_stack_[(3) - (1)].BaseNode);
             }
    break;

  case 135:

/* Line 678 of lalr1.cc  */
#line 1536 "parser.yy"
    {
                (yyval.BaseNode) = new CNOpenFileCommand((yysemantic_stack_[(3) - (2)].BaseNode));
                delete (yysemantic_stack_[(3) - (1)].BaseNode);
            }
    break;

  case 136:

/* Line 678 of lalr1.cc  */
#line 1543 "parser.yy"
    {
                (yyval.BaseNode) = new CNSerialCommand((yysemantic_stack_[(3) - (2)].BaseNode));
                delete (yysemantic_stack_[(3) - (1)].BaseNode);
            }
    break;

  case 137:

/* Line 678 of lalr1.cc  */
#line 1550 "parser.yy"
    {
                (yyval.BaseNode) = new CNNMEACommand((yysemantic_stack_[(3) - (2)].BaseNode));
                delete (yysemantic_stack_[(3) - (1)].BaseNode);
            }
    break;

  case 138:

/* Line 678 of lalr1.cc  */
#line 1557 "parser.yy"
    {
                (yyval.BaseNode) = new CNMatchNMEACommand((yysemantic_stack_[(3) - (2)].BaseNode));
                delete (yysemantic_stack_[(3) - (1)].BaseNode);
            }
    break;

  case 139:

/* Line 678 of lalr1.cc  */
#line 1564 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 140:

/* Line 678 of lalr1.cc  */
#line 1568 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 141:

/* Line 678 of lalr1.cc  */
#line 1572 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 142:

/* Line 678 of lalr1.cc  */
#line 1576 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 143:

/* Line 678 of lalr1.cc  */
#line 1580 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 144:

/* Line 678 of lalr1.cc  */
#line 1584 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 145:

/* Line 678 of lalr1.cc  */
#line 1589 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 146:

/* Line 678 of lalr1.cc  */
#line 1594 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 147:

/* Line 678 of lalr1.cc  */
#line 1599 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 148:

/* Line 678 of lalr1.cc  */
#line 1604 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 149:

/* Line 678 of lalr1.cc  */
#line 1609 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 150:

/* Line 678 of lalr1.cc  */
#line 1614 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 151:

/* Line 678 of lalr1.cc  */
#line 1619 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 152:

/* Line 678 of lalr1.cc  */
#line 1624 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 153:

/* Line 678 of lalr1.cc  */
#line 1629 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 154:

/* Line 678 of lalr1.cc  */
#line 1634 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 155:

/* Line 678 of lalr1.cc  */
#line 1639 "parser.yy"
    {
                 (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 156:

/* Line 678 of lalr1.cc  */
#line 1644 "parser.yy"
    {
                (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 157:

/* Line 678 of lalr1.cc  */
#line 1649 "parser.yy"
    {
                (yyval.BaseNode) = new CNStatement((yysemantic_stack_[(1) - (1)].BaseNode));
                }
    break;

  case 158:

/* Line 678 of lalr1.cc  */
#line 1655 "parser.yy"
    {
                (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
               }
    break;

  case 159:

/* Line 678 of lalr1.cc  */
#line 1660 "parser.yy"
    {
                (yyval.BaseNode) = new CNStatementList((yysemantic_stack_[(2) - (1)].BaseNode), (yysemantic_stack_[(2) - (2)].BaseNode));
               }
    break;

  case 160:

/* Line 678 of lalr1.cc  */
#line 1667 "parser.yy"
    {
                 (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
                }
    break;

  case 161:

/* Line 678 of lalr1.cc  */
#line 1671 "parser.yy"
    {
                 (yyval.BaseNode) = (yysemantic_stack_[(3) - (2)].BaseNode);
                }
    break;

  case 162:

/* Line 678 of lalr1.cc  */
#line 1675 "parser.yy"
    {
                 (yyval.BaseNode) = 0;
                }
    break;

  case 163:

/* Line 678 of lalr1.cc  */
#line 1680 "parser.yy"
    {
                (yyval.BaseNode) = new CNScript(*(yysemantic_stack_[(3) - (2)].stringVal), (yysemantic_stack_[(3) - (3)].BaseNode));
                driver.calc.scriptNames.push_back(*(yysemantic_stack_[(3) - (2)].stringVal));
                delete (yysemantic_stack_[(3) - (1)].BaseNode);
                delete (yysemantic_stack_[(3) - (2)].stringVal);
            }
    break;

  case 164:

/* Line 678 of lalr1.cc  */
#line 1688 "parser.yy"
    {
                 (yyval.BaseNode) = new CNString(*(yysemantic_stack_[(1) - (1)].stringVal));
                 delete (yysemantic_stack_[(1) - (1)].stringVal);
                }
    break;

  case 165:

/* Line 678 of lalr1.cc  */
#line 1695 "parser.yy"
    {
                    if((yysemantic_stack_[(4) - (3)].BaseNode)->isConstant())
                    {
                        if(!driver.calc.existsHeaderObject(*(yysemantic_stack_[(4) - (1)].stringVal)))
                        {
                        error(yyloc, std::string("Error  : Header object name \""+*(yysemantic_stack_[(4) - (1)].stringVal)+"\" does not exist."));
                        delete (yysemantic_stack_[(4) - (1)].stringVal);
                        delete (yysemantic_stack_[(4) - (3)].BaseNode);
                        YYERROR;
                        }
                        else
                        {
                        (yyval.BaseNode) = new CNHeaderStatement(*(yysemantic_stack_[(4) - (1)].stringVal), (yysemantic_stack_[(4) - (3)].BaseNode), &driver.calc);
                        delete (yysemantic_stack_[(4) - (1)].stringVal);
                        }
                    }
                    else
                    {
                        error(yyloc, std::string("Error  : Non constant expression in header statement."));
                        delete (yysemantic_stack_[(4) - (1)].stringVal);
                        delete (yysemantic_stack_[(4) - (3)].BaseNode);
                        YYERROR;
                    }
                }
    break;

  case 166:

/* Line 678 of lalr1.cc  */
#line 1721 "parser.yy"
    {
                    if((yysemantic_stack_[(4) - (3)].BaseNode)->isConstant())
                    {
                    if (!driver.calc.existsDefineConstant(*(yysemantic_stack_[(4) - (1)].stringVal)))
                    {
                    driver.calc.defineConstants.insert(std::pair<std::string, double>(*(yysemantic_stack_[(4) - (1)].stringVal), (yysemantic_stack_[(4) - (3)].BaseNode)->evaluate()));
                    (yyval.BaseNode) = new CNDefineConstantReference(*(yysemantic_stack_[(4) - (1)].stringVal), 0);
                    delete (yysemantic_stack_[(4) - (1)].stringVal);
                    }
                    else
                    {
                    error(yyloc, std::string("Warning: Define constant \""+ *(yysemantic_stack_[(4) - (1)].stringVal) +"\" redefined."));
                    driver.calc.defineConstants[*(yysemantic_stack_[(4) - (1)].stringVal)]=((yysemantic_stack_[(4) - (3)].BaseNode)->evaluate());
                    (yyval.BaseNode) = new CNDefineConstantReference(*(yysemantic_stack_[(4) - (1)].stringVal), driver.calc.defineConstants[*(yysemantic_stack_[(4) - (1)].stringVal)]);
                    delete (yysemantic_stack_[(4) - (1)].stringVal);
                    }
                    }
                    else
                    {
                        error(yyloc, std::string("Error  : Non constant expression in header statement."));
                        delete (yysemantic_stack_[(4) - (1)].stringVal);
                        delete (yysemantic_stack_[(4) - (3)].BaseNode);
                        YYERROR;
                    }
                  }
    break;

  case 167:

/* Line 678 of lalr1.cc  */
#line 1748 "parser.yy"
    {
                  (yyval.BaseNode) = 0;
                  delete (yysemantic_stack_[(1) - (1)].BaseNode);
                 }
    break;

  case 168:

/* Line 678 of lalr1.cc  */
#line 1755 "parser.yy"
    {
                (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
               }
    break;

  case 169:

/* Line 678 of lalr1.cc  */
#line 1760 "parser.yy"
    {
                (yyval.BaseNode) = new CNHeaderStatementList((yysemantic_stack_[(2) - (1)].BaseNode), (yysemantic_stack_[(2) - (2)].BaseNode));
               }
    break;

  case 170:

/* Line 678 of lalr1.cc  */
#line 1767 "parser.yy"
    {
                 (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
                }
    break;

  case 171:

/* Line 678 of lalr1.cc  */
#line 1771 "parser.yy"
    {
                 (yyval.BaseNode) = (yysemantic_stack_[(3) - (2)].BaseNode);
                }
    break;

  case 172:

/* Line 678 of lalr1.cc  */
#line 1775 "parser.yy"
    {
                 (yyval.BaseNode) = 0;
                }
    break;

  case 173:

/* Line 678 of lalr1.cc  */
#line 1780 "parser.yy"
    {
                (yyval.BaseNode) = new CNHeader(*(yysemantic_stack_[(3) - (2)].stringVal), (yysemantic_stack_[(3) - (3)].BaseNode));
                /* Register The Starting Location Of The Script */
                driver.calc.scriptStarts.insert(driver.calc.scriptStarts.end(), std::pair<int, int>(yyloc.begin.line, yyloc.begin.column));
                delete (yysemantic_stack_[(3) - (1)].BaseNode);
                delete (yysemantic_stack_[(3) - (2)].stringVal);
            }
    break;

  case 174:

/* Line 678 of lalr1.cc  */
#line 1789 "parser.yy"
    {
             (yyval.BaseNode) = (yysemantic_stack_[(1) - (1)].BaseNode);
            }
    break;

  case 175:

/* Line 678 of lalr1.cc  */
#line 1794 "parser.yy"
    {
              (yyval.BaseNode) = new CNScriptList((yysemantic_stack_[(2) - (1)].BaseNode), (yysemantic_stack_[(2) - (2)].BaseNode));
            }
    break;

  case 176:

/* Line 678 of lalr1.cc  */
#line 1799 "parser.yy"
    {
                (yyval.BaseNode) = new CNTotal((yysemantic_stack_[(2) - (1)].BaseNode), (yysemantic_stack_[(2) - (2)].BaseNode));
                /* Register The End Location Of The Script */
                driver.calc.scriptEnds.insert(driver.calc.scriptEnds.end(), std::pair<int, int>(yyloc.end.line, yyloc.end.column));
            }
    break;

  case 177:

/* Line 678 of lalr1.cc  */
#line 1806 "parser.yy"
    {
                (yyval.BaseNode) = 0;
            }
    break;

  case 178:

/* Line 678 of lalr1.cc  */
#line 1811 "parser.yy"
    {
              driver.calc.expressions.push_back((yysemantic_stack_[(2) - (2)].BaseNode));
              /* produce any map outputs before clearing local contexts! */
              driver.calc.expressionsMapOutput.push_back(driver.calc.getLocalVariablesMap(0, 0)+"\r\n"+driver.calc.getLocalStringVariablesMap(0, 0)+"\r\n"+driver.calc.getGlobalVariablesMap(0, 0)+"\r\n"+driver.calc.getGlobalStringVariablesMap(0, 0)+"\r\n");
              driver.calc.scriptNumber++;
              driver.calc.restartContext();
            }
    break;



/* Line 678 of lalr1.cc  */
#line 3534 "parser.cc"
	default:
          break;
      }
    YY_SYMBOL_PRINT ("-> $$ =", yyr1_[yyn], &yyval, &yyloc);

    yypop_ (yylen);
    yylen = 0;
    YY_STACK_PRINT ();

    yysemantic_stack_.push (yyval);
    yylocation_stack_.push (yyloc);

    /* Shift the result of the reduction.  */
    yyn = yyr1_[yyn];
    yystate = yypgoto_[yyn - yyntokens_] + yystate_stack_[0];
    if (0 <= yystate && yystate <= yylast_
	&& yycheck_[yystate] == yystate_stack_[0])
      yystate = yytable_[yystate];
    else
      yystate = yydefgoto_[yyn - yyntokens_];
    goto yynewstate;

  /*------------------------------------.
  | yyerrlab -- here on detecting error |
  `------------------------------------*/
  yyerrlab:
    /* If not already recovering from an error, report this error.  */
    if (!yyerrstatus_)
      {
	++yynerrs_;
	error (yylloc, yysyntax_error_ (yystate, yytoken));
      }

    yyerror_range[0] = yylloc;
    if (yyerrstatus_ == 3)
      {
	/* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

	if (yychar <= yyeof_)
	  {
	  /* Return failure if at end of input.  */
	  if (yychar == yyeof_)
	    YYABORT;
	  }
	else
	  {
	    yydestruct_ ("Error: discarding", yytoken, &yylval, &yylloc);
	    yychar = yyempty_;
	  }
      }

    /* Else will try to reuse lookahead token after shifting the error
       token.  */
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:

    /* Pacify compilers like GCC when the user code never invokes
       YYERROR and the label yyerrorlab therefore never appears in user
       code.  */
    if (false)
      goto yyerrorlab;

    yyerror_range[0] = yylocation_stack_[yylen - 1];
    /* Do not reclaim the symbols of the rule which action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    yystate = yystate_stack_[0];
    goto yyerrlab1;

  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;	/* Each real token shifted decrements this.  */

    for (;;)
      {
	yyn = yypact_[yystate];
	if (yyn != yypact_ninf_)
	{
	  yyn += yyterror_;
	  if (0 <= yyn && yyn <= yylast_ && yycheck_[yyn] == yyterror_)
	    {
	      yyn = yytable_[yyn];
	      if (0 < yyn)
		break;
	    }
	}

	/* Pop the current state because it cannot handle the error token.  */
	if (yystate_stack_.height () == 1)
	YYABORT;

	yyerror_range[0] = yylocation_stack_[0];
	yydestruct_ ("Error: popping",
		     yystos_[yystate],
		     &yysemantic_stack_[0], &yylocation_stack_[0]);
	yypop_ ();
	yystate = yystate_stack_[0];
	YY_STACK_PRINT ();
      }

    yyerror_range[1] = yylloc;
    // Using YYLLOC is tempting, but would change the location of
    // the lookahead.  YYLOC is available though.
    YYLLOC_DEFAULT (yyloc, (yyerror_range - 1), 2);
    yysemantic_stack_.push (yylval);
    yylocation_stack_.push (yyloc);

    /* Shift the error token.  */
    YY_SYMBOL_PRINT ("Shifting", yystos_[yyn],
		     &yysemantic_stack_[0], &yylocation_stack_[0]);

    yystate = yyn;
    goto yynewstate;

    /* Accept.  */
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;

    /* Abort.  */
  yyabortlab:
    yyresult = 1;
    goto yyreturn;

  yyreturn:
    if (yychar != yyempty_)
      yydestruct_ ("Cleanup: discarding lookahead", yytoken, &yylval, &yylloc);

    /* Do not reclaim the symbols of the rule which action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    while (yystate_stack_.height () != 1)
      {
	yydestruct_ ("Cleanup: popping",
		   yystos_[yystate_stack_[0]],
		   &yysemantic_stack_[0],
		   &yylocation_stack_[0]);
	yypop_ ();
      }

    return yyresult;
  }

  // Generate an error message.
  std::string
  Parser::yysyntax_error_ (int yystate, int tok)
  {
    std::string res;
    YYUSE (yystate);
#if YYERROR_VERBOSE
    int yyn = yypact_[yystate];
    if (yypact_ninf_ < yyn && yyn <= yylast_)
      {
	/* Start YYX at -YYN if negative to avoid negative indexes in
	   YYCHECK.  */
	int yyxbegin = yyn < 0 ? -yyn : 0;

	/* Stay within bounds of both yycheck and yytname.  */
	int yychecklim = yylast_ - yyn + 1;
	int yyxend = yychecklim < yyntokens_ ? yychecklim : yyntokens_;
	int count = 0;
	for (int x = yyxbegin; x < yyxend; ++x)
	  if (yycheck_[x + yyn] == x && x != yyterror_)
	    ++count;

	// FIXME: This method of building the message is not compatible
	// with internationalization.  It should work like yacc.c does it.
	// That is, first build a string that looks like this:
	// "syntax error, unexpected %s or %s or %s"
	// Then, invoke YY_ on this string.
	// Finally, use the string as a format to output
	// yytname_[tok], etc.
	// Until this gets fixed, this message appears in English only.
	res = "syntax error, unexpected ";
	res += yytnamerr_ (yytname_[tok]);
	if (count < 5)
	  {
	    count = 0;
	    for (int x = yyxbegin; x < yyxend; ++x)
	      if (yycheck_[x + yyn] == x && x != yyterror_)
		{
		  res += (!count++) ? ", expecting " : " or ";
		  res += yytnamerr_ (yytname_[x]);
		}
	  }
      }
    else
#endif
      res = YY_("syntax error");
    return res;
  }


  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
  const short int Parser::yypact_ninf_ = -219;
  const short int
  Parser::yypact_[] =
  {
      -219,    11,  -219,  -219,   -23,    26,  -219,    18,  -219,    20,
    -219,    26,     4,     6,  -219,    -6,  -219,  -219,  -219,   290,
    -219,   515,   515,  -219,  -219,    -4,  -219,  -219,  -219,  -219,
    -219,  -219,   -31,    24,    38,    56,  -219,    58,    66,  -219,
    -219,  -219,  -219,  -219,  -219,  -219,  -219,  -219,  -219,   140,
      45,    57,   338,    92,    98,   110,   121,   124,   156,  -219,
    -219,   118,  -219,  -219,  -219,  -219,  -219,   139,  -219,   125,
    -219,   142,  -219,  -219,  -219,  -219,  -219,   338,   338,   338,
     338,   338,  -219,  -219,  -219,  -219,  -219,  -219,  -219,  -219,
    -219,  -219,  -219,  -219,  -219,  -219,   515,    89,    89,    13,
      13,    13,  -219,  -219,  -219,   134,  -219,   334,  -219,    75,
      22,   132,   149,   150,  -219,   151,   136,  -219,  -219,   515,
     515,   515,   515,   515,   515,   515,   515,  -219,  -219,   208,
     338,   515,  -219,  -219,   153,  -219,  -219,  -219,  -219,  -219,
    -219,  -219,   155,   157,   158,  -219,    23,   515,   515,   515,
     515,   515,   159,  -219,   515,  -219,    13,    27,    37,    52,
      54,    65,   161,  -219,  -219,  -219,  -219,  -219,  -219,  -219,
      13,  -219,  -219,  -219,  -219,  -219,  -219,  -219,  -219,  -219,
     527,   527,   527,   527,   527,   527,   527,   527,   527,   527,
     527,   527,   527,   527,   527,   527,   527,  -219,    13,    13,
      60,  -219,   162,   163,   177,   184,   188,   189,  -219,   176,
    -219,   200,   201,  -219,  -219,    67,   190,   515,   515,   515,
     397,  -219,   338,   204,   206,   207,   211,   212,   456,   214,
     138,   221,  -219,  -219,  -219,  -219,  -219,  -219,  -219,  -219,
    -219,  -219,  -219,  -219,  -219,  -219,  -219,  -219,  -219,  -219,
    -219,  -219,  -219,  -219,    75,    75,   222,   223,    90,    94,
    -219,  -219,  -219,  -219,  -219,  -219,   515,  -219,  -219,  -219,
    -219,   224,   209,   210,   228,  -219,   215,   216,   218,   290,
     290,   290,   229,   219,    13,   220,  -219,  -219,   515,  -219,
     515,  -219,  -219,  -219,   515,   515,  -219,  -219,  -219,  -219,
     279,  -219,  -219,   290,  -219,   227,  -219,   237,   238,    19,
     239,  -219,   290,  -219,    13,   247,   250,  -219,   515,  -219,
    -219,   234,  -219,  -219,   252,    13,  -219,   236,    13,  -219
  };

  /* YYDEFACT[S] -- default rule to reduce with in state S when YYTABLE
     doesn't specify something else to do.  Zero means the default is an
     error.  */
  const unsigned char
  Parser::yydefact_[] =
  {
       177,     0,     1,   164,     0,     0,   178,     0,    22,     0,
     174,   176,     0,     0,    95,     0,   167,   170,   173,     0,
     175,     0,     0,   172,   168,     0,    15,    23,    27,    29,
      30,    24,    16,    19,    10,    12,    14,     0,     0,   114,
     129,   130,   131,   133,   132,   116,   123,    25,    26,     0,
       0,     0,   111,     0,     0,     0,     0,     0,     0,   139,
     149,     0,   142,   143,   141,   140,   144,     0,   148,     0,
     155,     0,   147,   157,   156,   146,   145,   111,   111,   111,
     111,   111,   151,   150,   152,   153,   154,   160,   163,     2,
       3,     5,     4,    80,    81,   101,     0,     0,     0,     0,
       0,     0,    40,    43,    42,    49,    51,    55,    65,    72,
      75,     0,     0,     0,    41,     0,     0,   171,   169,     0,
       0,     0,     0,     0,     0,    85,    85,   162,   158,     0,
     111,     0,    96,    97,     0,    99,   100,   109,   110,   102,
     103,   104,     0,     0,     0,   112,     0,     0,     0,     0,
       0,     0,     0,    89,     0,   117,     0,     0,     0,     0,
       0,     0,     0,    46,    45,    48,    47,    52,    53,    54,
       0,    31,    32,    33,    34,    35,    36,    37,    38,    39,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   166,     0,     0,
       0,   165,     0,     0,     0,     0,     0,     0,    82,    83,
      86,     0,     0,   161,   159,     0,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,     0,     0,     0,
     118,     0,   135,   134,   136,   137,   138,    44,    50,    56,
      57,    61,    59,    60,    58,    62,    63,    64,    69,    66,
      67,    68,    70,    71,    73,    74,     0,     0,     0,     0,
      18,    17,    21,    20,    11,    13,     0,    88,    87,    79,
      78,     0,     0,     0,     0,   113,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    76,    77,     0,     6,
       0,     8,    84,    98,     0,     0,   108,   127,   126,   125,
      94,    92,    90,     0,   115,   119,   124,     0,     0,     0,
       0,    28,     0,    91,     0,     0,     0,   106,     0,   107,
      93,   120,     7,     9,     0,     0,   105,   121,     0,   122
  };

  /* YYPGOTO[NTERM-NUM].  */
  const short int
  Parser::yypgoto_[] =
  {
      -219,  -219,  -219,   -44,   -17,  -219,  -219,  -219,  -219,  -219,
    -219,  -219,  -219,  -219,  -219,  -219,  -219,  -219,  -219,  -219,
    -219,  -219,  -219,  -153,   -94,    41,   -36,    -5,  -219,   -21,
    -219,  -219,  -219,  -219,  -219,    42,   183,    -9,  -219,  -219,
    -219,  -219,    53,  -219,  -219,  -219,  -219,  -219,   -22,    88,
     -65,  -219,  -219,  -219,  -219,   -39,  -219,  -219,  -219,  -219,
    -219,  -219,  -219,  -219,  -219,  -219,  -219,  -219,  -219,  -219,
    -219,  -219,   -45,  -219,  -218,   300,  -219,    16,  -219,  -219,
    -219,  -219,  -219,  -219
  };

  /* YYDEFGOTO[NTERM-NUM].  */
  const short int
  Parser::yydefgoto_[] =
  {
        -1,   102,   103,    50,   104,     9,    52,    53,    54,    55,
      56,   312,    57,    58,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   105,   106,   107,   108,   109,   110,   138,
      59,    60,   112,   113,   209,   210,   211,   114,    62,    63,
      64,    65,    66,   139,   140,   141,   142,   143,   115,   145,
     146,    67,    68,    69,    70,   231,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,   129,    88,    10,     4,    17,    25,    18,
       5,    11,     6,     1
  };

  /* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule which
     number is the opposite.  If zero, do what YYDEFACT says.  */
  const signed char Parser::yytable_ninf_ = -1;
  const unsigned short int
  Parser::yytable_[] =
  {
       111,   116,    51,   230,   128,   167,   168,   169,   137,     7,
      61,     2,   157,   158,   159,   160,   161,    89,    90,    26,
      91,    92,   119,    12,   120,    12,    13,    14,    13,    14,
     144,    24,    51,   137,   137,   137,   137,   137,    32,    33,
      61,   118,    36,    37,    38,   230,   230,    12,     3,     8,
      13,    14,    19,   163,   165,   144,   144,   144,   144,   144,
      16,   300,   301,   302,    95,   215,    96,    23,    16,   117,
      97,    98,    21,   317,    22,   162,   238,   121,    16,   122,
     164,   166,   195,   196,   214,   313,   137,   258,   259,   318,
      15,   123,   221,   222,   320,    26,   232,   222,   202,   203,
     204,   205,   206,   207,   208,   208,   233,   222,   144,   124,
     216,   125,    51,   130,    32,    33,    34,    35,    36,   126,
      61,   234,   222,   235,   222,   131,   223,   224,   225,   226,
     227,   305,   189,   229,   236,   222,   269,   222,   190,   191,
     192,   193,   194,   288,   289,   147,    26,   290,   291,    27,
      28,   148,    29,   248,   249,   250,   251,   252,   253,   256,
     257,   321,    30,   149,    31,    32,    33,    34,    35,    36,
      37,    38,   327,    14,   150,   329,    39,   151,   137,    40,
      41,    42,    43,    44,    45,    46,   152,   153,    47,    48,
     254,   255,   154,   170,   155,   156,   271,   272,   273,   274,
     144,   197,   198,   199,   200,   201,   217,   282,   218,   284,
     219,   220,   228,   127,    26,   237,   260,    27,    28,   261,
      29,   239,   240,   241,   242,   243,   244,   245,   246,   247,
      30,   262,    31,    32,    33,    34,    35,    36,    37,    38,
     263,    14,   264,   265,    39,   208,   266,    40,    41,    42,
      43,    44,    45,    46,   267,   268,    47,    48,   276,   270,
     277,   278,    51,    51,    51,   279,   280,   307,   283,   308,
      61,    61,    61,   309,   310,   285,   286,   287,   293,   294,
     295,   213,   296,   303,   297,   298,    51,   299,   304,   306,
     311,   315,   316,   319,    61,    51,    26,   324,   314,    27,
      28,   322,    29,    61,   323,   325,   326,   328,   292,   212,
     275,    20,    30,     0,    31,    32,    33,    34,    35,    36,
      37,    38,     0,    14,     0,     0,    39,     0,     0,    40,
      41,    42,    43,    44,    45,    46,     0,     0,    47,    48,
       0,     0,    89,    90,    26,    91,    92,   171,   172,   173,
     174,   175,   176,   177,   178,   179,     0,     0,     0,     0,
       0,     0,    49,    32,    33,    34,    35,    36,    37,    38,
       0,     0,   132,   133,     0,     0,   134,     0,     0,     0,
       0,     0,     0,     0,    93,    94,     0,     0,   135,    95,
     136,    96,     0,     0,     0,    97,    98,     0,    99,   100,
     101,    89,    90,    26,    91,    92,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    32,    33,   258,   259,    36,    37,    38,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    93,    94,     0,     0,     0,    95,     0,
      96,     0,     0,     0,    97,    98,     0,    99,   100,   101,
      89,    90,    26,    91,    92,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    32,    33,     0,     0,    36,    37,    38,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    93,    94,     0,     0,     0,    95,     0,    96,
     281,     0,     0,    97,    98,     0,    99,   100,   101,    89,
      90,    26,    91,    92,     0,     0,     0,     0,     0,     0,
       0,    89,    90,    26,    91,    92,     0,     0,     0,     0,
      32,    33,     0,     0,    36,    37,    38,     0,     0,     0,
       0,     0,    32,    33,     0,     0,    36,    37,    38,     0,
       0,    93,    94,     0,     0,     0,    95,     0,    96,     0,
       0,     0,    97,    98,     0,    99,   100,   101,    95,     0,
      96,     0,     0,     0,    97,    98,     0,    99,   100,   101
  };

  /* YYCHECK.  */
  const short int
  Parser::yycheck_[] =
  {
        21,    22,    19,   156,    49,    99,   100,   101,    52,    32,
      19,     0,    77,    78,    79,    80,    81,     4,     5,     6,
       7,     8,    53,    29,    55,    29,    32,    33,    32,    33,
      52,    15,    49,    77,    78,    79,    80,    81,    25,    26,
      49,    25,    29,    30,    31,   198,   199,    29,    37,    23,
      32,    33,    32,    97,    98,    77,    78,    79,    80,    81,
       7,   279,   280,   281,    51,   130,    53,    73,    15,    73,
      57,    58,    68,    54,    68,    96,   170,    53,    25,    55,
      97,    98,    60,    61,   129,   303,   130,    27,    28,    70,
      72,    53,    69,    70,   312,     6,    69,    70,   119,   120,
     121,   122,   123,   124,   125,   126,    69,    70,   130,    53,
     131,    53,   129,    68,    25,    26,    27,    28,    29,    53,
     129,    69,    70,    69,    70,    68,   147,   148,   149,   150,
     151,   284,    57,   154,    69,    70,    69,    70,    63,    64,
      65,    66,    67,    53,    54,    53,     6,    53,    54,     9,
      10,    53,    12,   189,   190,   191,   192,   193,   194,   198,
     199,   314,    22,    53,    24,    25,    26,    27,    28,    29,
      30,    31,   325,    33,    53,   328,    36,    53,   222,    39,
      40,    41,    42,    43,    44,    45,    30,    69,    48,    49,
     195,   196,    53,    59,    69,    53,   217,   218,   219,   220,
     222,    69,    53,    53,    53,    69,    53,   228,    53,    71,
      53,    53,    53,    73,     6,    54,    54,     9,    10,    56,
      12,   180,   181,   182,   183,   184,   185,   186,   187,   188,
      22,    54,    24,    25,    26,    27,    28,    29,    30,    31,
      56,    33,    54,    54,    36,   266,    70,    39,    40,    41,
      42,    43,    44,    45,    54,    54,    48,    49,    54,    69,
      54,    54,   279,   280,   281,    54,    54,   288,    54,   290,
     279,   280,   281,   294,   295,    54,    54,    54,    54,    70,
      70,    73,    54,    54,    69,    69,   303,    69,    69,    69,
      11,    54,    54,    54,   303,   312,     6,   318,    71,     9,
      10,    54,    12,   312,    54,    71,    54,    71,   266,   126,
     222,    11,    22,    -1,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    36,    -1,    -1,    39,
      40,    41,    42,    43,    44,    45,    -1,    -1,    48,    49,
      -1,    -1,     4,     5,     6,     7,     8,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    25,    26,    27,    28,    29,    30,    31,
      -1,    -1,    34,    35,    -1,    -1,    38,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    46,    47,    -1,    -1,    50,    51,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    60,    61,
      62,     4,     5,     6,     7,     8,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    47,    -1,    -1,    -1,    51,    -1,
      53,    -1,    -1,    -1,    57,    58,    -1,    60,    61,    62,
       4,     5,     6,     7,     8,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    25,    26,    -1,    -1,    29,    30,    31,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    46,    47,    -1,    -1,    -1,    51,    -1,    53,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    62,     4,
       5,     6,     7,     8,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     4,     5,     6,     7,     8,    -1,    -1,    -1,    -1,
      25,    26,    -1,    -1,    29,    30,    31,    -1,    -1,    -1,
      -1,    -1,    25,    26,    -1,    -1,    29,    30,    31,    -1,
      -1,    46,    47,    -1,    -1,    -1,    51,    -1,    53,    -1,
      -1,    -1,    57,    58,    -1,    60,    61,    62,    51,    -1,
      53,    -1,    -1,    -1,    57,    58,    -1,    60,    61,    62
  };

  /* STOS_[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
  const unsigned char
  Parser::yystos_[] =
  {
         0,   157,     0,    37,   150,   154,   156,    32,    23,    79,
     149,   155,    29,    32,    33,    72,   116,   151,   153,    32,
     149,    68,    68,    73,   151,   152,     6,     9,    10,    12,
      22,    24,    25,    26,    27,    28,    29,    30,    31,    36,
      39,    40,    41,    42,    43,    44,    45,    48,    49,    72,
      77,    78,    80,    81,    82,    83,    84,    86,    87,   104,
     105,   111,   112,   113,   114,   115,   116,   125,   126,   127,
     128,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   148,     4,
       5,     7,     8,    46,    47,    51,    53,    57,    58,    60,
      61,    62,    75,    76,    78,    97,    98,    99,   100,   101,
     102,   103,   106,   107,   111,   122,   103,    73,   151,    53,
      55,    53,    55,    53,    53,    53,    53,    73,   146,   147,
      68,    68,    34,    35,    38,    50,    52,    77,   103,   117,
     118,   119,   120,   121,   122,   123,   124,    53,    53,    53,
      53,    53,    30,    69,    53,    69,    53,   124,   124,   124,
     124,   124,   103,    77,    78,    77,    78,    98,    98,    98,
      59,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    57,
      63,    64,    65,    66,    67,    60,    61,    69,    53,    53,
      53,    69,   103,   103,   103,   103,   103,   103,   103,   108,
     109,   110,   110,    73,   146,   124,   103,    53,    53,    53,
      53,    69,    70,   103,   103,   103,   103,   103,    53,   103,
      97,   129,    69,    69,    69,    69,    69,    54,    98,    99,
      99,    99,    99,    99,    99,    99,    99,    99,   100,   100,
     100,   100,   100,   100,   101,   101,   129,   129,    27,    28,
      54,    56,    54,    56,    54,    54,    70,    54,    54,    69,
      69,   103,   103,   103,   103,   123,    54,    54,    54,    54,
      54,    54,   103,    54,    71,    54,    54,    54,    53,    54,
      53,    54,   109,    54,    70,    70,    54,    69,    69,    69,
     148,   148,   148,    54,    69,    97,    69,   103,   103,   103,
     103,    11,    85,   148,    71,    54,    54,    54,    70,    54,
     148,    97,    54,    54,   103,    71,    54,    97,    71,    97
  };

#if YYDEBUG
  /* TOKEN_NUMBER_[YYLEX-NUM] -- Internal symbol number corresponding
     to YYLEX-NUM.  */
  const unsigned short int
  Parser::yytoken_number_[] =
  {
         0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,    40,    41,    91,    93,    38,    35,    94,
      43,    45,    33,    42,    47,    37,   124,    63,    61,    59,
      44,    58,   123,   125
  };
#endif

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
  const unsigned char
  Parser::yyr1_[] =
  {
         0,    74,    75,    75,    75,    75,    76,    76,    76,    76,
      77,    77,    77,    77,    78,    78,    78,    78,    78,    78,
      78,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    97,    97,    97,    97,    97,    97,    97,    97,    98,
      98,    99,    99,    99,    99,   100,   100,   100,   100,   100,
     100,   100,   100,   100,   100,   101,   101,   101,   101,   101,
     101,   101,   102,   102,   102,   103,   103,   103,   104,   105,
     106,   107,   108,   109,   109,   110,   110,   111,   111,   112,
     113,   113,   114,   115,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   123,   123,   123,   123,   123,   123,   123,
     123,   124,   124,   124,   125,   126,   127,   128,   129,   129,
     129,   129,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     146,   146,   146,   146,   146,   146,   146,   146,   146,   146,
     146,   146,   146,   146,   146,   146,   146,   146,   147,   147,
     148,   148,   148,   149,   150,   151,   151,   151,   152,   152,
     153,   153,   153,   154,   155,   155,   156,   157,   157
  };

  /* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
  const unsigned char
  Parser::yyr2_[] =
  {
         0,     2,     1,     1,     1,     1,     4,     7,     4,     7,
       1,     4,     1,     4,     1,     1,     1,     4,     4,     1,
       4,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     2,     2,     2,     2,     1,
       3,     1,     2,     2,     2,     1,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     1,     3,     3,     3,     3,
       3,     3,     1,     3,     3,     1,     4,     4,     4,     4,
       1,     1,     1,     1,     3,     0,     1,     4,     4,     2,
       5,     6,     5,     7,     5,     1,     1,     1,     4,     1,
       1,     1,     1,     1,     1,     8,     6,     6,     4,     1,
       1,     0,     1,     3,     1,     5,     1,     2,     1,     3,
       5,     7,     9,     1,     5,     5,     5,     5,     3,     1,
       1,     1,     1,     1,     3,     3,     3,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     3,     2,     3,     1,     4,     4,     1,     1,     2,
       1,     3,     2,     3,     1,     2,     2,     0,     2
  };

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
  /* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
     First, the terminals, then, starting at \a yyntokens_, nonterminals.  */
  const char*
  const Parser::yytname_[] =
  {
    "\"end of file\"", "error", "$undefined", "\"end of line\"",
  "\"integer\"", "\"hexadecimal integer\"", "\"stack variable\"",
  "\"float\"", "\"binary integer\"", "\"keyword print\"", "\"keyword if\"",
  "\"keyword else\"", "\"keyword while\"", "\"keyword eq\"",
  "\"keyword neq\"", "\"keyword lt\"", "\"keyword lte\"", "\"keyword gt\"",
  "\"keyword gte\"", "\"keyword and\"", "\"keyword or\"",
  "\"keyword xor\"", "\"keyword function\"", "\"keyword script\"",
  "\"keyword sleep\"", "\"local variable\"", "\"global variable\"",
  "\"local string variable\"", "\"global string variable\"",
  "\"define constant\"", "\"local function name\"",
  "\"global function name\"", "\"object name\"", "\"comment\"",
  "\"literal string\"", "\"keyword newline\"", "\"keyword precision\"",
  "\"keyword header\"", "\"keyword print function\"",
  "\"keyword open file\"", "\"keyword clear file\"", "\"keyword serial\"",
  "\"keyword match nmea\"", "\"keyword nmea\"", "\"keyword reset\"",
  "\"keyword sleep until\"", "\"keyword time until\"", "\"keyword time\"",
  "\"keyword open pipe\"", "\"keyword close pipe\"", "\"keyword base\"",
  "\"keyword char\"", "\"keyword decimal\"", "'('", "')'", "'['", "']'",
  "'&'", "'#'", "'^'", "'+'", "'-'", "'!'", "'*'", "'/'", "'%'", "'|'",
  "'?'", "'='", "';'", "','", "':'", "'{'", "'}'", "$accept", "constant",
  "stringvariablevalue", "stringvariable", "variable", "keywordscript",
  "keywordprint", "keywordsleep", "keywordopenpipe", "keywordclosepipe",
  "keywordif", "keywordelse", "keywordwhile", "keywordfunction",
  "keywordeq", "keywordneq", "keywordlt", "keywordlte", "keywordgt",
  "keywordgte", "keywordand", "keywordor", "keywordxor", "atomexpr",
  "powexpr", "unaryexpr", "binaryexpr", "mulexpr", "addexpr", "expr",
  "assignment", "stringassignment", "keywordtimeuntil", "keywordtime",
  "argument", "argumentlist", "argumentexp", "functionref", "functioncall",
  "functiondef", "whileloop", "conditional", "comment", "string",
  "keywordnewline", "keywordpfunction", "keywordbase", "keyworddecimal",
  "keywordchar", "printargument", "printargumentlist", "keywordprecision",
  "precisioncommand", "keywordreset", "resetcommand", "timeargument",
  "keywordsleepuntil", "sleepuntilcommand", "closepipecommand",
  "openpipecommand", "sleepcommand", "printcommand", "keywordopenfile",
  "keywordclearfile", "keywordserial", "keywordnmea", "keywordmatchnmea",
  "clearfilecommand", "openfilecommand", "serialcommand", "nmeacommand",
  "matchnmeacommand", "statement", "statementlist", "statementblock",
  "script", "keywordheader", "headerstatement", "headerstatementlist",
  "headerstatementblock", "header", "body", "total", "start", 0
  };
#endif

#if YYDEBUG
  /* YYRHS -- A `-1'-separated list of the rules' RHS.  */
  const Parser::rhs_number_type
  Parser::yyrhs_[] =
  {
       157,     0,    -1,     4,    -1,     5,    -1,     8,    -1,     7,
      -1,   122,    53,    27,    54,    -1,   122,    53,    27,    53,
     103,    54,    54,    -1,   122,    53,    28,    54,    -1,   122,
      53,    28,    53,   103,    54,    54,    -1,    27,    -1,    27,
      53,   103,    54,    -1,    28,    -1,    28,    53,   103,    54,
      -1,    29,    -1,     6,    -1,    25,    -1,    25,    55,   103,
      56,    -1,    25,    53,   103,    54,    -1,    26,    -1,    26,
      55,   103,    56,    -1,    26,    53,   103,    54,    -1,    23,
      -1,     9,    -1,    24,    -1,    48,    -1,    49,    -1,    10,
      -1,    11,    -1,    12,    -1,    22,    -1,    13,    -1,    14,
      -1,    15,    -1,    16,    -1,    17,    -1,    18,    -1,    19,
      -1,    20,    -1,    21,    -1,    75,    -1,   111,    -1,    78,
      -1,    76,    -1,    53,   103,    54,    -1,    57,    78,    -1,
      57,    77,    -1,    58,    78,    -1,    58,    77,    -1,    97,
      -1,    97,    59,    98,    -1,    98,    -1,    60,    98,    -1,
      61,    98,    -1,    62,    98,    -1,    99,    -1,    99,    88,
      99,    -1,    99,    89,    99,    -1,    99,    93,    99,    -1,
      99,    91,    99,    -1,    99,    92,    99,    -1,    99,    90,
      99,    -1,    99,    94,    99,    -1,    99,    95,    99,    -1,
      99,    96,    99,    -1,   100,    -1,   101,    63,   100,    -1,
     101,    64,   100,    -1,   101,    65,   100,    -1,   101,    57,
     100,    -1,   101,    66,   100,    -1,   101,    67,   100,    -1,
     101,    -1,   102,    60,   101,    -1,   102,    61,   101,    -1,
     102,    -1,   106,    53,   129,    54,    -1,   107,    53,   129,
      54,    -1,    78,    68,   103,    69,    -1,    77,    68,   124,
      69,    -1,    46,    -1,    47,    -1,   103,    -1,   108,    -1,
     108,    70,   109,    -1,    -1,   109,    -1,    31,    53,   110,
      54,    -1,    30,    53,   110,    54,    -1,   111,    69,    -1,
      87,    30,    53,    54,   148,    -1,    87,    30,    53,   103,
      54,   148,    -1,    86,    53,   103,    54,   148,    -1,    84,
      53,   103,    54,   148,    85,   148,    -1,    84,    53,   103,
      54,   148,    -1,    33,    -1,    34,    -1,    35,    -1,    38,
      53,   103,    54,    -1,    50,    -1,    52,    -1,    51,    -1,
     117,    -1,   118,    -1,   119,    -1,   120,    53,   103,    70,
     103,    70,   103,    54,    -1,   120,    53,   103,    70,   103,
      54,    -1,   121,    53,   103,    70,   103,    54,    -1,   122,
      53,   103,    54,    -1,    77,    -1,   103,    -1,    -1,   123,
      -1,   124,    70,   123,    -1,    36,    -1,   125,    53,   103,
      54,    69,    -1,    44,    -1,   127,    69,    -1,    97,    -1,
      97,    71,    97,    -1,    97,    71,    97,    71,    97,    -1,
      97,    71,    97,    71,    97,    71,    97,    -1,    97,    71,
      97,    71,    97,    71,    97,    71,    97,    -1,    45,    -1,
     130,    53,   129,    54,    69,    -1,    83,    53,   103,    54,
      69,    -1,    82,    53,   103,    54,    69,    -1,    81,    53,
     103,    54,    69,    -1,    80,   124,    69,    -1,    39,    -1,
      40,    -1,    41,    -1,    43,    -1,    42,    -1,   137,   124,
      69,    -1,   136,   124,    69,    -1,   138,   124,    69,    -1,
     139,   124,    69,    -1,   140,   124,    69,    -1,   104,    -1,
     115,    -1,   114,    -1,   112,    -1,   113,    -1,   116,    -1,
     135,    -1,   134,    -1,   131,    -1,   126,    -1,   105,    -1,
     142,    -1,   141,    -1,   143,    -1,   144,    -1,   145,    -1,
     128,    -1,   133,    -1,   132,    -1,   146,    -1,   147,   146,
      -1,   146,    -1,    72,   147,    73,    -1,    72,    73,    -1,
      79,    32,   148,    -1,    37,    -1,    32,    68,   103,    69,
      -1,    29,    68,   103,    69,    -1,   116,    -1,   151,    -1,
     152,   151,    -1,   151,    -1,    72,   152,    73,    -1,    72,
      73,    -1,   150,    32,   153,    -1,   149,    -1,   155,   149,
      -1,   154,   155,    -1,    -1,   157,   156,    -1
  };

  /* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
     YYRHS.  */
  const unsigned short int
  Parser::yyprhs_[] =
  {
         0,     0,     3,     5,     7,     9,    11,    16,    24,    29,
      37,    39,    44,    46,    51,    53,    55,    57,    62,    67,
      69,    74,    79,    81,    83,    85,    87,    89,    91,    93,
      95,    97,    99,   101,   103,   105,   107,   109,   111,   113,
     115,   117,   119,   121,   123,   127,   130,   133,   136,   139,
     141,   145,   147,   150,   153,   156,   158,   162,   166,   170,
     174,   178,   182,   186,   190,   194,   196,   200,   204,   208,
     212,   216,   220,   222,   226,   230,   232,   237,   242,   247,
     252,   254,   256,   258,   260,   264,   265,   267,   272,   277,
     280,   286,   293,   299,   307,   313,   315,   317,   319,   324,
     326,   328,   330,   332,   334,   336,   345,   352,   359,   364,
     366,   368,   369,   371,   375,   377,   383,   385,   388,   390,
     394,   400,   408,   418,   420,   426,   432,   438,   444,   448,
     450,   452,   454,   456,   458,   462,   466,   470,   474,   478,
     480,   482,   484,   486,   488,   490,   492,   494,   496,   498,
     500,   502,   504,   506,   508,   510,   512,   514,   516,   518,
     521,   523,   527,   530,   534,   536,   541,   546,   548,   550,
     553,   555,   559,   562,   566,   568,   571,   574,   575
  };

  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
  const unsigned short int
  Parser::yyrline_[] =
  {
         0,   164,   164,   169,   174,   179,   187,   204,   221,   238,
     256,   277,   327,   342,   357,   376,   382,   403,   452,   501,
     535,   550,   565,   571,   577,   583,   589,   595,   601,   607,
     613,   619,   625,   631,   637,   643,   649,   655,   661,   667,
     673,   678,   683,   688,   693,   698,   743,   782,   817,   846,
     851,   857,   862,   867,   872,   878,   883,   889,   895,   901,
     907,   913,   919,   925,   931,   937,   942,   947,   952,   957,
     962,   967,   972,   977,   982,   987,  1000,  1006,  1012,  1053,
    1075,  1081,  1087,  1093,  1097,  1104,  1108,  1113,  1129,  1146,
    1152,  1177,  1229,  1253,  1284,  1311,  1318,  1324,  1330,  1335,
    1340,  1345,  1350,  1355,  1360,  1365,  1371,  1377,  1383,  1389,
    1394,  1401,  1405,  1410,  1415,  1421,  1427,  1433,  1439,  1444,
    1449,  1454,  1459,  1464,  1470,  1476,  1482,  1488,  1494,  1500,
    1506,  1512,  1517,  1522,  1528,  1535,  1542,  1549,  1556,  1563,
    1567,  1571,  1575,  1579,  1583,  1588,  1593,  1598,  1603,  1608,
    1613,  1618,  1623,  1628,  1633,  1638,  1643,  1648,  1654,  1659,
    1666,  1670,  1674,  1679,  1687,  1694,  1720,  1747,  1754,  1759,
    1766,  1770,  1774,  1779,  1788,  1793,  1798,  1806,  1810
  };

  // Print the state stack on the debug stream.
  void
  Parser::yystack_print_ ()
  {
    *yycdebug_ << "Stack now";
    for (state_stack_type::const_iterator i = yystate_stack_.begin ();
	 i != yystate_stack_.end (); ++i)
      *yycdebug_ << ' ' << *i;
    *yycdebug_ << std::endl;
  }

  // Report on the debug stream that the rule \a yyrule is going to be reduced.
  void
  Parser::yy_reduce_print_ (int yyrule)
  {
    unsigned int yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    /* Print the symbols being reduced, and their result.  */
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
	       << " (line " << yylno << "):" << std::endl;
    /* The symbols being reduced.  */
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
		       yyrhs_[yyprhs_[yyrule] + yyi],
		       &(yysemantic_stack_[(yynrhs) - (yyi + 1)]),
		       &(yylocation_stack_[(yynrhs) - (yyi + 1)]));
  }
#endif // YYDEBUG

  /* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
  Parser::token_number_type
  Parser::yytranslate_ (int t)
  {
    static
    const token_number_type
    translate_table[] =
    {
           0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    62,     2,    58,     2,    65,    57,     2,
      53,    54,    63,    60,    70,    61,     2,    64,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    71,    69,
       2,    68,     2,    67,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    55,     2,    56,    59,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    72,    66,    73,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52
    };
    if ((unsigned int) t <= yyuser_token_number_max_)
      return translate_table[t];
    else
      return yyundef_token_;
  }

  const int Parser::yyeof_ = 0;
  const int Parser::yylast_ = 589;
  const int Parser::yynnts_ = 84;
  const int Parser::yyempty_ = -2;
  const int Parser::yyfinal_ = 2;
  const int Parser::yyterror_ = 1;
  const int Parser::yyerrcode_ = 256;
  const int Parser::yyntokens_ = 74;

  const unsigned int Parser::yyuser_token_number_max_ = 307;
  const Parser::token_number_type Parser::yyundef_token_ = 2;


/* Line 1054 of lalr1.cc  */
#line 1 "[Bison:b4_percent_define_default]"

} // example

/* Line 1054 of lalr1.cc  */
#line 4343 "parser.cc"


/* Line 1056 of lalr1.cc  */
#line 1821 "parser.yy"
 /*** Additional Code ***/

void example::Parser::error(const Parser::location_type& l,
                const std::string& m)
{
    driver.error(l, m);
}

