#include "logExpressions.h"

#pragma pack(1)

LOGGING_EXPRESSIONS_BUFFER logExpressions;

void initLogExpressions(LOGGING_EXPRESSIONS_BUFFER* logExps)
{
	unsigned int i;
	
	logExps->expressionsSize=0;
	for(i=0; i<NUM_LOGGING_EXPRESSIONS; i++)
	{
		logExps->expressionIndex[i]=SIZE_EXPRESSIONS_BUFFER;
	}
	
	for(i=0; i<SIZE_EXPRESSIONS_BUFFER; i++)
	{
		logExps->expressionsBuffer[i]=0x00;
	}
}

unsigned int getSizeExpression(LOGGING_EXPRESSIONS_BUFFER* logExps, unsigned int numIndex)
{
	/* return the size in bytes of expression number numIndex in the logging expressions buffer */
	unsigned int max;
	unsigned int i;
	
	if(logExps->expressionIndex[numIndex]<SIZE_EXPRESSIONS_BUFFER)
	{
		max=logExps->expressionsSize;
		for(i=0; i<NUM_LOGGING_EXPRESSIONS; i++)
		{
			if((logExps->expressionIndex[i]>logExps->expressionIndex[numIndex])&&(logExps->expressionIndex[i]<max))
			{
				max=logExps->expressionIndex[i];
			}
		}
	}
	else 
	{
		return 0;
	}
	return (max-logExps->expressionIndex[numIndex]);
}

unsigned char* getExpression(LOGGING_EXPRESSIONS_BUFFER* logExps, unsigned int numIndex, unsigned int* size)
{
	/* return a pointer to the numIndex th expression, and a size indication */
	(*size)=getSizeExpression(logExps, numIndex);
	if((*size)>0)
	{
		return (unsigned char*)(&logExps->expressionsBuffer[logExps->expressionIndex[numIndex]]);	
	}	
	return 0;
}

void deleteLogExpressionByteAt(LOGGING_EXPRESSIONS_BUFFER* logExps, unsigned int index)
{
	unsigned int i;
	
	i=(index+1);
	while(i<logExps->expressionsSize)
	{
		logExps->expressionsBuffer[i-1]=logExps->expressionsBuffer[i];
		i++;
	}
	logExps->expressionsSize--;
}

void deleteExpression(LOGGING_EXPRESSIONS_BUFFER* logExps, int numIndex)
{
	unsigned int size;
	unsigned int index;
	unsigned int i;
	
	size=getSizeExpression(logExps, numIndex);
	index=logExps->expressionIndex[numIndex];
	if(size>0)
	{
		i=size;
		while(i--)
		{
			deleteLogExpressionByteAt(logExps, index);
		}
		
		for(i=0; i<NUM_LOGGING_EXPRESSIONS; i++)
		{
			if((logExps->expressionIndex[i]>index)&&(logExps->expressionIndex[i]<SIZE_EXPRESSIONS_BUFFER))logExps->expressionIndex[i]-=size;
		}
	}
	logExps->expressionIndex[numIndex]=SIZE_EXPRESSIONS_BUFFER;
}

int appendExpression(LOGGING_EXPRESSIONS_BUFFER* logExps, unsigned int numIndex, unsigned char* array, unsigned int sizeArray)
{
	/* return 0 if ok, non zero if error */
	unsigned int 	i;
	unsigned char* 	ptr;

	if(((int)logExps->expressionsSize+sizeArray)<=(SIZE_EXPRESSIONS_BUFFER))
	{
		ptr=(unsigned char*)&logExps->expressionsBuffer[logExps->expressionsSize];
		logExps->expressionIndex[numIndex]=logExps->expressionsSize;
		i=sizeArray;
		while(i--)
		{
			*ptr++=*array++;
		}		
		logExps->expressionsSize+=sizeArray;		
		return 0;
	}
	return 1;
}

int insertExpression(LOGGING_EXPRESSIONS_BUFFER* logExps, unsigned int numIndex, unsigned char* array, unsigned int sizeArray)
{
	/* return 0 if ok, non zero if error */
	unsigned int currentSize;
	unsigned char* ptr;
	int totalRequired;
	
	ptr=getExpression(logExps, numIndex, &currentSize);
	totalRequired=(int)sizeArray-(int)currentSize;
	if(((int)logExps->expressionsSize+totalRequired)<=(SIZE_EXPRESSIONS_BUFFER))
	{
		if(currentSize>0)deleteExpression(logExps, numIndex);
		return appendExpression(logExps, numIndex, array, sizeArray);	
	}
	/* error, out of memory */
	return 1;
}

