/* 

Expression Classes by Mauro Grassi, October 2010.

*/

#ifndef EXPRESSION_H
#define EXPRESSION_H

#include <map>
#include <vector>
#include <ostream>
#include <stdexcept>
#include <cmath>
#include "opcodes.h"  
#include "vm.h"
#include <stddef.h>
#include "driver.h"

#define GLOBAL_VARIABLES_VM_OFFSET_TAG			0x00080000
#define GLOBAL_VARIABLES_TAG					0x00040000
#define GLOBAL_FUNCTIONS_TAG					0x00020000
#define DEFINE_CONSTANTS_TAG					0x00010000
#define HEADER_OBJECTS_TAG						0x00100000
#define MASK_TAG								0x0000FFFF

typedef void (*NativeToManaged)(void);
extern "C" NativeToManaged globalIdleCompileTaskFunctionPointer;

#define POSITION_OF_ADDRESS     0
#define POSITION_OF_SIZE        1
#define POSITION_OF_TAG			2
#define POSITION_OF_IS_FLOAT	3
#define SIZE_MASK_FOR_FLOAT		0x8000
/* 

The Following is an approximate limit on the output size, it can be more, because the size is only
checked when starting to compile the output for a CNStatement 

Simply allow a reasonable amount on top of this, to the ROM cache of the VM.

*/

#define	MAX_LIST_OUTPUT_SIZE				64000
#define MAX_LIST_OUTPUT_SIZE_BUFFER_SIZE	65536

class BaseNode;
class CalcContext;
class CNConstant;
class CNOp;
class CNMemoryReference;
class CNStackVariableReference;
class CNLocalVariableReference;
class CNLocalVariableByteReference;
class CNBinary;
class CNAdd;
class CNStringVariableReference;
class CNLocalStringVariableReference;
class CNGlobalStringVariableReference;
class CNMemoryAssignment;
class CNLocalVariableAssignment;
class CNGlobalVariableAssignment;
class CNStringMemoryAssignment;
class CNLocalStringVariableAssignment;
class CNGlobalStringVariableAssignment;
class CNStringBinary;
class CNStringAdd;
class CNConditional;
class CNWhileLoop;
class CNArgument;
class CNLocalFunctionCall;
class CNGlobalFunctionCall;
class CNFunctionDefinition;
class CNGlobalVariableReference;
class CNGlobalVariableByteReference;
class CNDefineConstantReference;
class CNString;
class CNNewline;
class CNUnary;
class CNNegate;
class CNLogicalNot;
class CNPrintBaseFunction;
class CNPrintDecimal;
class CNSubtract;
class CNBooleanEqu;
class CNBooleanNeq;
class CNBooleanGte;
class CNBooleanLte;
class CNBooleanGt;
class CNBooleanLt;
class CNBooleanAnd;
class CNBooleanOr;
class CNBooleanXor;
class CNLogicalAnd;
class CNLogicalOr;
class CNLogicalXor;
class CNMultiply;
class CNDivide;
class CNModulo;
class CNPower;
class CNStatementContainer;
class CNStatement;
class CNHeaderStatement;
class CNBuiltInExpressionCommand;
class CNSleepCommand;
class CNPrintChar;
class CNOpenPipeCommand;
class CNClosePipeCommand;
class CNBuiltInTimeExpressionCommand;
class CNSleepUntilCommand;
class CNTimeUntilCommand;
class CNTimeCommand;
class CNResetCommand;
class CNPrecisionCommand;
class CNPrintArgumentExpression;
class CNPrintBuiltInFunction;
class CNPrintArgumentString;
class CNGenericFileCommand;
class CNOpenFileCommand;
class CNClearFileCommand;
class CNPrintList;
class CNLinkedList;
class CNStatementList;
class CNScriptList;
class CNHeaderStatementList;
class CNHeader;
class CNScript;
class CNTotal;
class CNMemoryReferenceAutomatic;
class CNGlobalByteReferenceAutomatic;

const double headerObjectOffset[]
=
	{
	/* Offsets into VM */
	(double)(unsigned int)offsetof(VIRTUAL_MACHINE, execPriority),
	(double)(unsigned int)offsetof(VIRTUAL_MACHINE, execMode),	
	-1.0
	};

const double headerObjectSize[]
=
	{
	2.0,
	1.0,
	0.0
	};

const std::string headerObjectNameTable[]
=
	{
	"execPriority",
	"execMode",
	""
	};

const std::string headerObjectsHelpTable[]
=
	{
	"set this to override the default execution priority of the script (the higher the number, the more priority), the default is: #defaultPriority\r\n",
	"set this to override the default execution mode of the script, which restarts automatically if it halts, possible values include: #defaultExecMode, #execModeNoRestart\r\n",
	""
	};

const int globalFunctionIDTable[]
=
	{
	/* Maths Functions */

	GL_FUNCTION_INT,				GL_FUNCTION_SQRT,				GL_FUNCTION_SIN,
	GL_FUNCTION_COS,				GL_FUNCTION_TAN,				GL_FUNCTION_ACOS,
	GL_FUNCTION_ASIN,				GL_FUNCTION_ATAN,				GL_FUNCTION_EXP,
	GL_FUNCTION_LN,					GL_FUNCTION_LOG10,				GL_FUNCTION_FPART,
	GL_FUNCTION_ABS,				GL_FUNCTION_SIGMA,				GL_FUNCTION_SIGMA_SQUARES,
	GL_FUNCTION_GCD,				GL_FUNCTION_INIT_RANDOM,		GL_FUNCTION_RANDOM,
	GL_FUNCTION_NUM_DIVISORS,		GL_FUNCTION_IS_PRIME,			GL_FUNCTION_PRIME_PRODUCT,
	GL_FUNCTION_CONVERT_BCD_TO_DECIMAL,								GL_FUNCTION_CONVERT_DECIMAL_TO_BCD,	

	/* I2C Functions */

	GL_FUNCTION_INIT_I2C,			GL_FUNCTION_CLOSE_I2C,			GL_FUNCTION_PUT_I2C_ONE_BYTE,
	GL_FUNCTION_PUT_I2C_TWO_BYTE,	GL_FUNCTION_GET_I2C_TWO_BYTE,	GL_FUNCTION_GET_I2C_BYTE_ARRAY,
	GL_FUNCTION_PUT_I2C_BYTE_ARRAY, 

	/* UART Functions */

	GL_FUNCTION_INIT_UART,			GL_FUNCTION_CLOSE_UART,			GL_FUNCTION_GET_UART, GL_FUNCTION_PUT_UART,	GL_FUNCTION_NOT_EMPTY_UART,
	GL_FUNCTION_GET_SIZE_UART,	    GL_FUNCTION_LAST_RX_UART,		GL_FUNCTION_CLEAR_RX_UART,
	GL_FUNCTION_GET_UART_ERROR,		GL_FUNCTION_RECEIVED_NMEA_UART,	GL_FUNCTION_NEW_RX_UART,
	GL_FUNCTION_DO_NMEA_MATCH,

	/* SPI Functions */

	GL_FUNCTION_INIT_SPI,			GL_FUNCTION_CLOSE_SPI, GL_FUNCTION_WRITE_SPI, GL_FUNCTION_WRITE_SPI_WITHOUT_CS, GL_FUNCTION_SET_SPI_CS,

	/* One Wire Functions */

	GL_FUNCTION_RESET_ONE_WIRE,		GL_FUNCTION_SEND_ONE_WIRE_COMMAND,	GL_FUNCTION_INIT_ONE_WIRE,  GL_FUNCTION_CLOSE_ONE_WIRE, GL_FUNCTION_ONE_WIRE_CRC,

	GL_FUNCTION_SEND_ONE_WIRE_COMMAND_USING_ROM_CODE_BUFFER,
	GL_FUNCTION_COPY_ONE_WIRE_BUFFER_TO_ROM_CODE_BUFFER,
	GL_FUNCTION_COPY_ROM_CODE_BUFFER_TO_ONE_WIRE_BUFFER,

	/* ADC Functions */

	GL_FUNCTION_GET_ADC_REFERENCE,		GL_FUNCTION_OPEN_ADC,					GL_FUNCTION_CLOSE_ADC,	
	GL_FUNCTION_READ_ADC,				GL_FUNCTION_READ_ADCP,					GL_FUNCTION_SET_ADC_SUPPLY_VOLTAGE,
	GL_FUNCTION_GET_ADC_SUPPLY_VOLTAGE,	GL_FUNCTION_GET_ADC_REFERENCE_OPTIONS,	GL_FUNCTION_SELF_CALIBRATE_ADC,
	GL_FUNCTION_SET_VBG_IO,				GL_FUNCTION_READ_COMPARATOR,			GL_FUNCTION_READ_V,

	/* General IO Pins */

	GL_FUNCTION_OPEN_IO,				GL_FUNCTION_SET_IO,			GL_FUNCTION_GET_IO,
	GL_FUNCTION_CLOSE_IO,		    	GL_FUNCTION_TOGGLE_IO,		GL_FUNCTION_IF_IO_HIGH,
	GL_FUNCTION_IF_IO_LOW,				GL_FUNCTION_SET_LED,
	GL_FUNCTION_FLASH_LED_TIMES,
	GL_FUNCTION_INTERNAL_SET_LED,


	/* Process related globals */

	GL_FUNCTION_START_PROCESS,			GL_FUNCTION_STOP_PROCESS,	GL_FUNCTION_PAUSE_PROCESS,

	/* Pipe related globals */

	GL_FUNCTION_GET_PIPE,

	/* Capture Functions */

	GL_FUNCTION_OPEN_CAPTURE_LF,		GL_FUNCTION_OPEN_CAPTURE_MF,	GL_FUNCTION_OPEN_CAPTURE_HF,

	/* Note there is a repeat (ie, an alias) here */

	GL_FUNCTION_READ_CAPTURE,			GL_FUNCTION_READ_CAPTURE,
	GL_FUNCTION_CLOSE_CAPTURE,			GL_FUNCTION_OPEN_CAPTURE_AUTO_FREQUENCY,
	GL_FUNCTION_OPEN_CAPTURE_OPTIONS, 	GL_FUNCTION_OPEN_CAPTURE_COUNTER_RISING, GL_FUNCTION_OPEN_CAPTURE_COUNTER_FALLING,

	/* System global functions */

	GL_FUNCTION_GLOBAL_READ,			GL_FUNCTION_GLOBAL_WRITE,
	GL_FUNCTION_READ_EE,				GL_FUNCTION_WRITE_EE,
	GL_FUNCTION_SIZE_EE,
	GL_FUNCTION_GLOBAL_READ_F,			GL_FUNCTION_GLOBAL_WRITE_F,
	GL_FUNCTION_READ_EE_F,				GL_FUNCTION_WRITE_EE_F,

	/* Time Functions */

	GL_FUNCTION_GET_LOCAL_TIME,			GL_FUNCTION_SET_LOCAL_TIME,					GL_FUNCTION_GET_YEAR,
	GL_FUNCTION_GET_MONTH,				GL_FUNCTION_GET_DAY,						GL_FUNCTION_GET_HOUR,
	GL_FUNCTION_GET_MINUTES,			GL_FUNCTION_GET_SECONDS,					GL_FUNCTION_SET_YEAR,
	GL_FUNCTION_SET_MONTH,				GL_FUNCTION_SET_DAY,						GL_FUNCTION_SET_HOUR,
	GL_FUNCTION_SET_MINUTES,			GL_FUNCTION_SET_SECONDS,					GL_FUNCTION_ADD_MONTHS,
	GL_FUNCTION_ADD_DAYS,				GL_FUNCTION_ADD_HOURS,						GL_FUNCTION_ADD_MINUTES,
	GL_FUNCTION_ADD_SECONDS,			GL_FUNCTION_GET_TOTAL_SECONDS,				GL_FUNCTION_GET_WEEKDAY,
	GL_FUNCTION_IS_LEAP_YEAR,			GL_FUNCTION_GET_DAYS_IN_MONTH_YEAR,				
	GL_FUNCTION_SET_TIME_W,				GL_FUNCTION_SET_SHOW_TIME,					GL_FUNCTION_SET_TOTAL_SECONDS,
	GL_FUNCTION_GET_TOTAL_SECONDS_DIV,	GL_FUNCTION_GET_TOTAL_SECONDS_MOD,
	GL_FUNCTION_SET_TOTAL_SECONDS_DIV_MOD,

	-1

	};

const std::string globalFunctionNameTable[]
=
	{
	/* Maths Functions */

	"@@int",			"@@sqrt",			"@@sin",		"@@cos",			"@@tan",		"@@acos",			"@@asin",		"@@atan",		"@@exp",
	"@@ln",				"@@log10",			"@@frac",		"@@abs",			"@@sum",		"@@sumSquares", 
	"@@gcd",			"@@initRandom",		"@@rnd",		"@@numDivisors",	"@@isPrime",	"@@primeProduct",   
	"@@bcdToDecimal",	"@@decimalToBcd", 

	/* I2C Functions */

	"@@openI2C",		"@@closeI2C",	"@@putI2CByte", "@@putI2CTwoBytes", "@@getI2CTwoBytes",
	"@@getI2C",			"@@putI2C",

	/* UART Functions */

	"@@openUART",		"@@closeUART",	"@@getUART",			"@@putUART",			"@@notEmptyUART",	  "@@getSizeUART",
	"@@getLastRxUART",	"@@clearUART",	"@@getErrorUART",		"@@receivedNMEAUART",	"@@newRxUART",
	"@@matchNMEAString",

	/* SPI Functions */

	"@@openSPI", "@@closeSPI", "@@writeSPI", "@@writeSPINoCS", "@@setSPICS",

	/* One Wire Functions */

	"@@resetOneWire",	
	"@@sendOneWireCommand",		
	"@@openOneWire",  
	"@@closeOneWire",  
	"@@oneWireCRC",
	"@@sendOneWireCommandRomCode",
	"@@copyOneWireBufferToRomCodeBuffer",
	"@@copyRomCodeBufferToOneWireBuffer",


	/* ADC Functions */

	"@@getADCRef",			"@@openADC",				"@@closeADC", "@@readADC",  "@@readADCP", "@@setADCSupplyRef",
	"@@getADCSupplyRef",	"@@getADCRefIfVBGVEquals",	"@@calibrateADC", "@@setVBGPinIO", 
	"@@readComparator",		"@@readV", 

	/* General IO Functions */

	"@@openIO", 
	"@@setIO", 
	"@@getIO", 
	"@@closeIO", 
	"@@toggleIO", 
	"@@isIOHigh",
	"@@isIOLow",
	"@@setLED", 
	"@@flashLED",
	"@@flashLEDDuration",

	/* Process related Functions */

	"@@startVM", "@@stopVM", "@@pauseVM",

	/* Pipe related Functions */

	"@@getPipes",

	/* Capture Functions */

	"@@openLowFrequency",	"@@openMediumFrequency", "@@openCaptureHighFrequency", 

	/* the following two are aliases */

	"@@readCounter",		"@@readFrequency",		
	"@@closeCapture",		"@@openFrequency", 
	"@@openCapture",		"@@openRisingCounter",   "@@openFallingCounter",

	/* System Calls */

	"@@sysRead",			"@@sysWrite",
	"@@readEE",				"@@writeEE",		
	"@@sizeEE",
	"@@sysReadFloat",		"@@sysWriteFloat",
	"@@readEEFloat",		"@@writeEEFloat",

	/* Time Functions */
	"@@getLocalTime",		"@@setLocalTime",	
	"@@getYear",			"@@getMonth",		"@@getDay",			"@@getHour",	"@@getMinutes",		"@@getSeconds",
	"@@setYear",			"@@setMonth",		"@@setDay",			"@@setHour",	"@@setMinutes",		"@@setSeconds",
	"@@addMonths",			"@@addDays",		"@@addHours",		"@@addMinutes",	"@@addSeconds",
	"@@getTotalSeconds",	"@@getWeekDay",		"@@isLeapYear",		"@@getDaysInMonthYear",
	"@@setScriptTime",		
	"@@setShowScriptTime",
	"@@setTotalSeconds",	
	"@@getTotalSecondsDiv", 
	"@@getTotalSecondsMod",
	"@@setTotalSecondsDivMod",
	""
	};

const std::string globalFunctionHelpTable[]
=
	{
	/* Maths Functions */

	"Effect:\treturns the integer part of $1\r\n",

	"Effect:\treturns the square root of $1\r\n",

	"Effect:\treturns the sine of the angle (in radians)\r\n",

	"Effect:\treturns the cosine of the angle (in radians)\r\n",

	"Effect:\treturns the tangent of the angle (in radians)\r\n",

	"Effect:\treturns the arc cosine of $1 if $1 is between -1 and +1, otherwise 0\r\n",

	"Effect:\treturns the arc sine of $1 if $1 is between -1 and +1, otherwise 0\r\n",

	"Effect:\treturns the arc tangent of $1\r\n",

	"Effect:\treturns the value of e to the power of $1, where e is the natural constant\r\n",

	"Effect:\treturns the natural log of $1, if $1 > 0, otherwise 0\r\n",

	"Effect:\treturns the log base 10 of $1, if $1 > 0, otherwise 0\r\n",

	"Effect:\treturns the fractional part of $1\r\n",

	"Effect:\treturns the absolute value of $1\r\n",

	"Effect:\treturns the sum of $2 numbers starting at address $1, if $2 is between 0 and 65535, otherwise 0\r\n",

	"Effect:\treturns the sum of the squares of $2 numbers starting at address $1, if $2 is between 0 and 65535, otherwise 0\r\n",

	"Effect:\treturns the greatest common divisor of $1 and $2\r\n",

	"Effect:\tinitialises the pseudo random generator modulo $1 and with seed $2, returns $2 modulo $1\r\n",

	"Effect:\treturns a pseudo random number modulo $1\r\n",

	"Effect:\treturns the number of divisors of $1\r\n",

	"Effect:\treturns 1 if $1 is prime, 0 otherwise\r\n",

	"Effect:\treturns the product of the prime divisors of $1\r\n",

	"Effect:\treturns the decimal equivalent of the BCD value $1\r\n",

	"Effect:\treturns the BCD equivalent of decimal value $1\r\n",

	/* I2C Functions */

	"Effect:\topens the I2C bus running at $1 kHz\r\n",

	"Effect:\tcloses the I2C bus\r\n",

	"Effect:\twrites byte $2 to I2C address $1\r\n",

	"Effect:\twrites bytes $2 and $3 to I2C address $1\r\n",

	"Effect:\treads 2 bytes from I2C address $1 (into the $$I2C buffer)\r\n",

	"Effect:\treads up to $2 bytes from I2C address $1 (into the $$I2C buffer)\r\n",

	"Effect:\twrites up to $2 bytes to I2C address $1 (from the $$I2C buffer)\r\n",

	/* UART Functions */

	"Effect:\topens the serial port in mode $1, baud rate $2 with Tx pin $3 and Rx pin $4. The mode can be a combination of the following constants: #defaultUART, #noTxInvUART, #noRxInvUART, #openDrainUART, #interruptRxUART, #noTxUART, #noRxUART,	#GPSDecodingUART, #noUART \r\n",

	"Effect:\tcloses the serial port\r\n",

	"Effect:\treads a character from the serial port input pipe, if available, otherwise 0\r\n",

	"Effect:\twrites a character to the serial port\r\n",

	"Effect:\treturns 1 if the serial port input pipe is not empty, otherwise 0\r\n",

	"Effect:\treturns the current size of serial port input pipe\r\n",

	"Effect:\treturns the last received character from the serial port\r\n",

	"Effect:\tclears the serial port input pipe\r\n",

	"Effect:\treturn the serial port input error register and then clear any error. The error register can be a combination of the following constants: #errorOverRunUART, #errorOverFlowUART, #errorUnderFlowUART \r\n",

	"Effect:\treturns 1 if a valid NMEA sentence has been received on the serial port input pipe, otherwise 0\r\n",

	"Effect:\treturns 1 if a new character has been received on the serial port input pipe for the script, otherwise 0\r\n", 

	"Effect:\treturns 1 if a NMEA sentence has been received on the serial port input pipe and it matches the one last set using the built in matchNMEA command\r\n", 

	/* SPI Functions */

	"Effect:\topens the SPI bus in mode $1, with CLK pin $2, DI pin $3, DO pin $4, CS pin $5\r\n", 

	"Effect:\tcloses the SPI bus\r\n", 

	"Effect:\twrite $1 to the SPI bus, simultaneously return the value read from the SPI bus\r\n", 

	"Effect:\twrite $1 to the SPI bus without asserting CS, simultaneously return the value read from the SPI bus\r\n", 

	"Effect:\tset the SPI bus' CS line to $1\r\n", 

	/* One Wire Functions */

	"Effect:\tsend a reset pulse to the OneWire bus\r\n", 

	"Effect:\tsend the command $1, with data packet of $2 bits, in mode $3 and with optional $4 ms pullup to the OneWire bus\r\n", 

	"Effect:\topen the OneWire bus in mode $1 on pin $2. The mode can be a combination of: #oneWireUsingUART, #oneWireUsingIO, #oneWireOverDrive, #oneWireWrite, #oneWireRead, #oneWireStrongPullUp \r\n", 

	"Effect:\tclose the OneWire bus\r\n", 

	"Effect:\treturn the OneWire CRC of the $$oneWire buffer of up to $1 bytes\r\n", 

	"Effect:\tsend the command $1, with data packet of $2 bits, in mode $3 and with optional $4 ms pullup to the OneWire bus (Uses the Rom Code Buffer As Buffer)\r\n", 

	"Effect:\tfill the rom code buffer with the contents of the one wire buffer at offset $1\r\n", 

	"Effect:\tcopy the contents of the rom code buffer to the one wire buffer at offset $1\r\n", 

	/* ADC Functions */

	"Effect:\tcompute the ADC reference voltage by measuring (in real time) the internal band gap reference voltage\r\n", 

	"Effect:\tconfigure pin $1 as analog input\r\n", 

	"Effect:\tclose pin $1 as analog input\r\n", 

	"Effect:\treturn the voltage level in Volts at the input to the microcontroller corresponding to analog input pin $1\r\n",

	"Effect:\treturn the voltage level in Volts at the input to REG1 the boost regulator\r\n",

	"Effect:\tset the ADC reference voltage to $1, provided it is within reasonable bounds\r\n",

	"Effect:\tget the ADC reference voltage\r\n",

	"Effect:\treturn the ADC reference voltage if the voltage of the band gap reference (VBG) is $1\r\n",

	"Effect:\tperform an automatic, real time calibration of the ADC system\r\n",

	"Effect:\tif $1==1 enable the band gap reference voltage on the D5/A1 output pin, if $1==0 disable such output\r\n",

	"Effect:\tget the output state of the internal comparator (connected to S2)\r\n",

	"Effect:\treturn the voltage level in Volts at the analog input pin $1 (assuming the default voltage dividers have been used)\r\n",

	/* General IO Functions */

	"Effect:\topen a digital IO pin on pin $1 and set to input (if $2==#inputIO==1) of output (if $2==#outputIO==0)\r\n",

	"Effect:\tset the digital output pin on pin $1 to high (if $2==#highIO==1) or low (if $2==#lowIO==0)\r\n",

	"Effect:\tget the level of the digital input pin on $1\r\n",

	"Effect:\tclose the digital IO pin $1\r\n",

	"Effect:\ttoggle the level of the IO pin $1\r\n",

	"Effect:\treturns 1 if the digital IO pin $1 is high, otherwise 0\r\n",

	"Effect:\treturns 1 if the digital IO pin $1 is low, otherwise 0\r\n",

	"Effect:\tset the onboard LED (LED3) on for $1 ms (system limited)\r\n",

	"Effect:\tflash the onboard LED (LED3) on $1 times (system limited)\r\n",

	"Effect:\tflash the onboard LED (LED3) on $1 times for $2 ms each time (system limited)\r\n",

	/* Process related Functions */

	"Effect:\tadd the script with ID $1 to the VM environment (start the script)\r\n",

	"Effect:\tremove the script with ID $1 from the VM environment (stop the script)\r\n",

	"Effect:\tpause (if ($1 & #pause)!=0) or unpause (if ($1 & #noPause)!=0) the script with ID $1\r\n",

	/* Pipe related Functions */

	"Effect:\treturn the currently enabled pipes. The result can be a combination of the following: #serialPipe, #filePipe, #usbPipe, #fileNamePipe, #systemLogPipe, #serialInPipe \r\n",

	/* Capture Functions */

	"Effect:\topen pin $1 as a low frequency input\r\n",

	"Effect:\topen pin $1 as a medium frequency input\r\n",

	"Effect:\topen pin $1 as a high frequency input\r\n",

	/* the following two are aliases */

	"Effect:\treturn the value of the counter on the pin $1 counter input\r\n",

	"Effect:\treturn the frequency of the signal on the pin $1 frequency input\r\n",

	"Effect:\tclose the frequency or counter input on pin $1\r\n",

	"Effect:\topen pin $1 as a frequency input (with automatic scaling of frequency modes)\r\n",

	"Effect:\topen pin $1 as a frequency/counter input in mode $2\r\n",

	"Effect:\topen pin $1 as a counter input incrementing on a rising edge (also clears the counter)\r\n",

	"Effect:\topen pin $1 as a counter input incrementing on a falling edge (also clears the counter)\r\n",

	/* System Calls */

	"Effect:\treturn the value of the byte of system memory at address $1\r\n",

	"Effect:\twrite the byte $2 to system memory address $1\r\n",

	"Effect:\treturn the value of the byte of general non volatile memory at address $1 (EEPROM emulated on memory card)\r\n",

	"Effect:\twrite the byte $2 to general non volatile memory at address $1 (EEPROM emulated on memory card)\r\n",

	"Effect:\tget the size in bytes of the general non volatile memory (EEPROM emulated on memory card)\r\n",

	"Effect:\treturn the 32 bit floating point value of system memory at address $1\r\n",

	"Effect:\twrite the 32 bit floating point value $2 to system memory address $1\r\n",

	"Effect:\treturn the 32 bit floating point value of general non volatile memory at address $1 (EEPROM emulated on memory card)\r\n",

	"Effect:\twrite the 32 bit floating point value $2 to general non volatile memory at address $1 (EEPROM emulated on memory card)\r\n",

	/* Time Functions */

	"Effect:\tload the script's time register with the local time from the RTCC (Real Time Clock Calendar)\r\n",

	"Effect:\tset the RTCC (Real Time Clock Calendar) clock with the script's time register or the argument $1 in the form time(YYYY:MM:DD:hh:mm:ss)\r\n",

	"Effect:\tif $1 is not given, get the year of the local time from the RTCC (Real Time Clock Calendar), otherwise if $1==#vmTime, get the year of the script's time\r\n",

	"Effect:\tif $1 is not given, get the month of the local time from the RTCC (Real Time Clock Calendar), otherwise if $1==#vmTime, get the month of the script's time\r\n",

	"Effect:\tif $1 is not given, get the day of the local time from the RTCC (Real Time Clock Calendar), otherwise if $1==#vmTime, get the day of the script's time\r\n",

	"Effect:\tif $1 is not given, get the (24 hour time) hour of the local time from the RTCC (Real Time Clock Calendar), otherwise if $1==#vmTime, get the hours of the script's time\r\n",

	"Effect:\tif $1 is not given, get the minutes of the local time from the RTCC (Real Time Clock Calendar), otherwise if $1==#vmTime, get the minutes of the script's time\r\n",

	"Effect:\tif $1 is not given, get the seconds of the local time from the RTCC (Real Time Clock Calendar), otherwise if $1==#vmTime, get the seconds of the script's time\r\n",

	"Effect:\tif only one argument is given, set the year of the local time to $1, otherwise if $2==#vmTime, set the year of the script's time to $1\r\n",

	"Effect:\tif only one argument is given, set the month of the local time to $1, otherwise if $2==#vmTime, set the month of the script's time to $1\r\n",

	"Effect:\tif only one argument is given, set the day of the local time to $1, otherwise if $2==#vmTime, set the day of the script's time to $1\r\n",

	"Effect:\tif only one argument is given, set the (24 hour time) hour of the local time to $1, otherwise if $2==#vmTime, set the year of the script's time to $1\r\n",

	"Effect:\tif only one argument is given, set the minutes of the local time to $1, otherwise if $2==#vmTime, set the year of the script's time to $1\r\n",

	"Effect:\tif only one argument is given, set the seconds of the local time to $1, otherwise if $2==#vmTime, set the year of the script's time to $1\r\n",

	"Effect:\tif only one argument is given, add $1>0 months to the local time, otherwise if $2==#vmTime, add $1 months to the script's time\r\n",

	"Effect:\tif only one argument is given, add $1>0 days to the local time, otherwise if $2==#vmTime, add $1 days to the script's time\r\n",

	"Effect:\tif only one argument is given, add $1>0 hours to the local time, otherwise if $2==#vmTime, add $1 hours to the script's time\r\n",

	"Effect:\tif only one argument is given, add $1>0 minutes to the local time, otherwise if $2==#vmTime, add $1 minutes to the script's time\r\n",

	"Effect:\tif only one argument is given, add $1>0 seconds to the local time, otherwise if $2==#vmTime, add $1 seconds to the script's time\r\n",

	"Effect:\tif no argument is given, return the total number of seconds from the default time (1 Jan 2011 00:00:00) until the local time, otherwise if $1==#vmTime, from the default time to the script's time\r\n",

	"Effect:\tif no argument is given, return the week day of the local time, otherwise if $1==#vmTime, return the week day of the script's time (0=Monday, ..., 6=Sunday)\r\n",

	"Effect:\tif no argument is given, return 1 if the local time's year is a leap year, otherwise return 1 if $1 is a leap year, otherwise 0\r\n",

	"Effect:\tif no arguments are given, returns the number of days in the local time's month, otherwise returns the number of days in year $2 and month $1\r\n",

	"Effect:\tset the script's time register, the argument $1 can be a time in the form time(YYYY:MM:DD:hh:mm:ss)\r\n",

	"Effect:\tset the show mode for the script's time register, where $1 is a combination of the following constants: #showDay, #showWeekDay, #showMinutes, #showSeconds, #showHours, #showMonth, #showYear, #showDefault	\r\n",

	"Effect:\tif only one argument is given, set the local time to the number of seconds $1 from the default time (1 Jan 2011 00:00:00), otherwise if $2==#vmTime, set the script's time at $1 seconds from the default time\r\n",

	"Effect:\tif one argument is given, return the total number of seconds from the default time (1 Jan 2011 00:00:00) until the local time divided by $1>0, otherwise if $2==#vmTime, from the default time to the script's time divided by $1>0\r\n",

	"Effect:\tif no argument is given, return the total number of seconds from the default time (1 Jan 2011 00:00:00) until the local time modulo $1>0, otherwise if $2==#vmTime, from the default time to the script's time modulo $1>0\r\n",

	"Effect:\tif only three arguments are given, set the local time to the number of seconds equal to (($1*$2)+$3) from the default time (1 Jan 2011 00:00:00), otherwise if $4==#vmTime, set the script's time at (($1*$2)+$3) seconds from the default time\r\n",

	""
	};

const std::string globalVariableNameTable[]
=
	{
	"$$indirect",
	"$$temp",
	"$$return",
	"$$ven",
	"$$ven.vmPtr",
	"$$ven.vmNum",
	"$$ven.vmState",
	"$$ven.vmMode",
	"$$ven.vmID",
	"$$ven.vmSelected",
	"$$ven.vmLogFileCache",
	"$$ven.vmLogFileName",
	"$$ven.vmSleepPeriod",
	"$$ven.vmMinimumPeriod",
	"$$ven.vmExecLimit",
	"$$ven.vmRecoveryTime",
	"$$ven.vmMinimumSleepPeriod",
	"$$file",
	};

const std::string globalVariableHelpTable[]
=
	{
	"indirect memory access to [W]",
	"temporary buffer (system limited)",
	"32 bit floating point return value variable, can be used for returning values from local functions",
	"base address of VM environment",
	"VM environment script pointer",
	"VM environment number of scripts loaded",
	"VM environment state",
	"VM environment mode",
	"VM environment script ID buffer",
	"VM environment selected script",
	"VM environment log file cache base address",
	"VM environment log file name buffer",
	"VM environment script sleep period",
	"VM environment minimum sleep period",
	"VM environment execution limit",
	"VM environment sleep recovery time in seconds",
	"VM environment minimum sleep period in seconds",
	"the memory mapped log file output for the VM",
	};

/* These are relative offsets into VM */

const std::string vmOffsetGlobalVariableNameTable[]
=
	{
	/* Start */
	"$$vm",
	"$$vm.execID",
	"$$vm.execState",
	"$$vm.execMode",
	"$$vm.CRC",
	"$$vm.lastError",
	"$$vm.IR",
	"$$vm.W",
	"$$vm.time",
	"$$vm.time.secs",
	"$$vm.time.mins",
	"$$vm.time.hours",
	"$$vm.time.day",
	"$$vm.time.month",
	"$$vm.time.year",
	"$$vm.time.wday",
	"$$vm.time.show",
	"$$vm.time.updated",
	"$$vm.DSLIMIT",
	"$$vm.DS",
	"$$vm.SS",
	"$$vm.addressModes",
	"$$vm.PC",
	"$$vm.stackSizePtr",
	"$$vm.lastIndirect",
	"$$vm.execLimit",
	"$$vm.execDone",
	"$$vm.execPriority",
	"$$vm.resetVector",
	"$$cache.ram",
	"$$cache.rom",
	"$$cache.stack",
	"$$cache.file",
	"$$vm.pipeMode",
	"$$vm.sleepMode",
	"$$fileName",
	"$$vm.temp",
	"$$vm.typeMode",
	"$$hardware",
	"$$hardware.serial",
	"$$hardware.serial.mode",
	"$$hardware.serial.txrxpin",
	"$$hardware.serial.baudRate",
	"$$hardware.oneWireSerial",
	"$$hardware.oneWireSerial.mode",
	"$$hardware.oneWireSerial.txrxpin",
	"$$hardware.oneWireSerial.baudRate",
	"$$hardware.I2C",
	"$$hardware.I2C.busRate",
	"$$I2C",
	"$$hardware.oneWire",
	"$$hardware.oneWire.mode",
	"$$oneWireRomCode",
	"$$oneWire",
	"$$serial.lastRx",
	"$$serial.TxCRC",
	"$$serial",
	"$$nmea.match.string",
	"$$nmea.match.stringPtr",
	"$$serial.newRx",
	"$$serial.putPtr",
	"$$serial.getPtr",
	"$$serial.RxCRC",
	"$$serial.pipeState",
	"$$serial.error",
	"$$nmea.output",
	"$$nmea.outputPtr",
	"$$longitude",
	"$$latitude",
	"$$speed",
	"$$course",
	"$$hardware.SPI",
	"$$hardware.SPI.mode",
	"$$hardware.SPI.ckdidocspin",
	"$$SPI",
	"$$vm.timeSpeed",
	"$$vm.timeOffset",
	"$$vm.timeScaling",
	"$$por",
	"$$vm.tempPipe",
	""
	};

const std::string vmOffsetGlobalVariableHelpTable[]
=
	{
	/* Start */
	"base pointer to the script structure",
	"execution ID of the current script",
	"execution state of the current script",
	"execution mode of the current script",
	"CRC check of the current script",
	"last run time error of the current script",
	"the instruction register of the current script",
	"the accumulator of the current script",
	"base pointer to the script's time register",
	"seconds register of the script's time register",
	"minutes register of the script's time register",
	"hours register of the script's time register",
	"day register of the script's time register",
	"month register of the script's time register",
	"year register of the script's time register",
	"week day register of the script's time register",
	"show register of the script's time register (determines which fields of the time are shown)",
	"time updated register of the script's time register",
	"the DS limit register of the current script",
	"the DS register of the current script",
	"the SS register of the current script",
	"the adressModes of the DS and SS registers of the current script",
	"the program counter register of the current script",
	"the stack size/pointer register of the current script",
	"the last indirect status register of the current script",
	"the execution limit register of the current script",
	"the execution counter register of the current script",
	"the execution priority register of the current script",
	"the reset vector register of the current script",
	"base pointer to the RAM cache of the current script",
	"base pointer to the ROM cache of the current script",
	"base pointer to the STACK cache of the current script",
	"base pointer to the FILE cache of the current script",
	"the enabled pipes of the current script",
	"the current sleep mode of the current script",
	"the current script's log file name buffer",
	"N/A",
	"the implicit argument type register of the current script",
	"base pointer to the hardware descriptors of the current script",
	"base pointer to the hardware descriptor for the serial port of the current script",
	"the current mode of the serial port of the current script",
	"the Tx and Rx pin register of the serial port of the current script",
	"the baud rate (divided by 10) of the serial port of the current script",
	"base pointer to the hardware descriptor for the serial port of oneWire port of the current script",
	"the current mode of the serial port of the oneWire port of the current script",
	"the Tx and Rx pin register of the serial port of the oneWire port of current script",
	"the baud rate (divided by 10) of the serial port of the oneWire port of current script",
	"base pointer to the hardware descriptor for the I2C port of the current script",
	"the current bus rate (in kHz) of the I2C port of the current script",
	"the I2C internal buffer",
	"base pointer to the hardware descriptor for the oneWire port of the current script",
	"the current mode of the oneWire port of the current script",
	"the OneWire Rom Code buffer",
	"the OneWire internal buffer",
	"the last received character on the serial port",
	"byte value used to accumulate the CRC checksum for NMEA sentence output",
	"the serial input pipe buffer",
	"user defined NMEA match string command buffer",
	"NMEA match string command buffer pointer",
	"indicates that a new character has been received in the serial port input pipe, cleared automatically when accessed using the global function @@newRxUART",
	"the serial input pipe buffer write location pointer",
	"the serial input pipe buffer read location pointer",
	"byte value used to accumulate the CRC checksum for the serial port input pipe buffer (also used for NMEA sentence decoding)",
	"the status of the serial input pipe buffer",
	"the last error status of the serial input pipe buffer",
	"byte array contains the raw output of any NMEA sentence match",
	"position pointer to the byte array containing the raw output of any NMEA sentence match (can be used to size the output)",
	"32 bit floating point value indicating longitude in degrees (<0 indicates West, >=0 indicates East) set by the system if a GPS module is present and outputting valid GPS GPRMC NMEA sentences through the serial port",
	"32 bit floating point value indicating latitude in degrees (<0 indicates South, >=0 indicates North) set by the system if a GPS module is present and outputting valid GPS GPRMC NMEA sentences through the serial port",
	"32 bit floating point value indicating ground speed in knots set by the system if a GPS module is present and outputting valid GPS GPRMC NMEA sentences through the serial port",
	"32 bit floating point value indicating course over ground (heading) in degrees set by the system if a GPS module is present and outputting valid GPS GPRMC NMEA sentences through the serial port",
	"base pointer to the hardware descriptor for the SPI port of the current script",
	"the current mode of the SPI port of the current script",
	"the CLK, DI, DO and CS pin register of the SPI port of the current script",
	"the SPI buffer",
	"N/A",
	"N/A",
	"N/A",
	"is 1 if a POR (Power On Reset) has occurred, otherwise 0",
	"N/A",
	""
	};

const unsigned short vmOffsets[]
=
	{
	/* offsets into VM */
	0,
	(unsigned short)offsetof(VIRTUAL_MACHINE, execID),
	(unsigned short)offsetof(VIRTUAL_MACHINE, execState),
	(unsigned short)offsetof(VIRTUAL_MACHINE, execMode),
	(unsigned short)offsetof(VIRTUAL_MACHINE, CRC),
	(unsigned short)offsetof(VIRTUAL_MACHINE, lastError),
	(unsigned short)offsetof(VIRTUAL_MACHINE, IR),
	(unsigned short)offsetof(VIRTUAL_MACHINE, W),
	(unsigned short)offsetof(VIRTUAL_MACHINE, time),
	(unsigned short)offsetof(VIRTUAL_MACHINE, time.secs),
	(unsigned short)offsetof(VIRTUAL_MACHINE, time.mins),
	(unsigned short)offsetof(VIRTUAL_MACHINE, time.hours),
	(unsigned short)offsetof(VIRTUAL_MACHINE, time.day),
	(unsigned short)offsetof(VIRTUAL_MACHINE, time.month),
	(unsigned short)offsetof(VIRTUAL_MACHINE, time.year),
	(unsigned short)offsetof(VIRTUAL_MACHINE, time.wday),
	(unsigned short)offsetof(VIRTUAL_MACHINE, time.show),
	(unsigned short)offsetof(VIRTUAL_MACHINE, time.updated),
	(unsigned short)offsetof(VIRTUAL_MACHINE, DSLIMIT),
	(unsigned short)offsetof(VIRTUAL_MACHINE, DS),
	(unsigned short)offsetof(VIRTUAL_MACHINE, SS),
	(unsigned short)offsetof(VIRTUAL_MACHINE, addressModes),
	(unsigned short)offsetof(VIRTUAL_MACHINE, PC),
	(unsigned short)offsetof(VIRTUAL_MACHINE, StackSizePtr),
	(unsigned short)offsetof(VIRTUAL_MACHINE, lastIndirect),
	(unsigned short)offsetof(VIRTUAL_MACHINE, execLimit),
	(unsigned short)offsetof(VIRTUAL_MACHINE, execDone),
	(unsigned short)offsetof(VIRTUAL_MACHINE, execPriority),
	(unsigned short)offsetof(VIRTUAL_MACHINE, resetVector),
	(unsigned short)offsetof(VIRTUAL_MACHINE, RAMImage),
	(unsigned short)offsetof(VIRTUAL_MACHINE, ROMImage),
	(unsigned short)offsetof(VIRTUAL_MACHINE, STACKImage),
	(unsigned short)offsetof(VIRTUAL_MACHINE, FILEImage),
	(unsigned short)offsetof(VIRTUAL_MACHINE, pipeMode),
	(unsigned short)offsetof(VIRTUAL_MACHINE, sleepMode),
	(unsigned short)offsetof(VIRTUAL_MACHINE, fName),
	(unsigned short)offsetof(VIRTUAL_MACHINE, temp),
	(unsigned short)offsetof(VIRTUAL_MACHINE, typeMode),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState.serialPort),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState.serialPort.mode),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState.serialPort.txrxpin),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState.serialPort.baudRate),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState.oneWireSerialPort),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState.oneWireSerialPort.mode),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState.oneWireSerialPort.txrxpin),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState.oneWireSerialPort.baudRate),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState.i2cPort),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState.i2cPort.busRate),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState.i2cPort.I2CBuffer),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState.oneWirePort),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState.oneWirePort.mode),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState.oneWirePort.romCode),
	(unsigned short)offsetof(VIRTUAL_MACHINE, hardwareState.oneWirePort.oneWireBuffer),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSLastRx),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSTxCRC),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSPipe),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSTempString),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSTempPtr),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSNewRx),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSPipePutPtr),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSPipeGetPtr),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSRxCRC),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSPipeState),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSError),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSOutput),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSOutPtr),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSLongitude),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSLatitude),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSSpeed),
	(unsigned short)offsetof(VIRTUAL_MACHINE, GPS.GPSCourse),
	(unsigned short)offsetof(VIRTUAL_MACHINE, SPI),
	(unsigned short)offsetof(VIRTUAL_MACHINE, SPI.mode),
	(unsigned short)offsetof(VIRTUAL_MACHINE, SPI.ckdidocspin),
	(unsigned short)offsetof(VIRTUAL_MACHINE, SPI.SPIBuffer),
	(unsigned short)offsetof(VIRTUAL_MACHINE, timeSpeed),
	(unsigned short)offsetof(VIRTUAL_MACHINE, timeOffset),
	(unsigned short)offsetof(VIRTUAL_MACHINE, timeScaling),
	(unsigned short)offsetof(VIRTUAL_MACHINE, firstPor),
	(unsigned short)offsetof(VIRTUAL_MACHINE, tempPipe),
	0,
	};

extern const unsigned short vmSizes[];

const std::string definesNameTable[]
=
	{
	"#pi",
	/* Pipe Related Define Constants */
	"#serialPipe", "#filePipe", "#usbPipe", "#fileNamePipe",	"#systemLogPipe",
	/* Print Function Define Constants */
	"#time",			"#timeIfSet",		"#timeFileName",	"#timeFileNameDate",	"#timeFileNameNumeric",		"#timeFileNameNumericDate",		"#timeOrDuration",		"#timeDuration",
	"#vmTimeFuture",	"#nmea",			"#vmFileName",				
	"#vmTime",			"#vmTimeIfSet",		"#vmTimeFileName",	"#vmTimeFileNameDate",	"#vmTimeFileNameNumeric",	"#vmTimeFileNameNumericDate",	"#vmTimeOrDuration",	"#vmTimeDuration",	  
	"#serialInPipe",	"#matchUARTString",
	/* Process Related Define Constants */
	"#pause", "#noPause", 
	/* define constants for header objects */
	"#defaultPriority", "#defaultExecMode", "#execModeNoRestart",
	/* for One Wire Modes */
	"#oneWireUsingUART", "#oneWireUsingIO", "#oneWireOverDrive", "#oneWireWrite", "#oneWireRead", "#oneWireStrongPullUp",
	/* IO related  constants */
	"#inputIO",	"#outputIO", "#highIO",	"#lowIO",
	/* UART related */
	"#defaultUART",
	"#noTxInvUART",		 "#noRxInvUART",		"#openDrainUART",	  "#interruptRxUART", 
	"#noTxUART",		 "#noRxUART",			"#noUART",
	"#errorOverRunUART", "#GPSDecodingUART",	"#errorOverFlowUART", "#errorUnderFlowUART", 
	"#maxUARTRxSize",
	/* Time related */
	"#showDay", "#showWeekDay", "#showMinutes", "#showSeconds", "#showHours", "#showMonth", "#showYear",
	"#showDefault",
	/* Channel related */
	"#D0", "#D1", "#D2", "#D3", "#D4", "#D5", "#A0", "#A1", "#A2", "#A3",
	/* Number of raw output bytes matched by the internal GPS GPRMC sentence match */
	"#GPRMCNumBytesToMatch",
	""
	};

const std::string definesHelpTable[]
=
	{
	"the mathematical constant PI, useful for trigonometric functions, among other uses",
	/* Pipe Related Define Constants */
	"the serial pipe over the script's serial port",
	"the log file pipe for the script",
	"a serial pipe emulated over the USB connection to the PC Host", 
	"a pipe used to set the file name for the script's log file", 
	"a pipe used to log entries to the system log file",
	/* Print Function Define Constants */
	"print function constant, displays the local time",
	"print function constant, displays the local time if it is set",
	"print function constant, displays the local time as a string suitable for a file name",
	"print function constant, displays the local date as a string suitable for a file name",
	"print function constant, displays the local time as a numeric string suitable for a file name",
	"print function constant, displays the local date as a numeric string suitable for a file name",
	"print function constant, displays the local time if it is set or the duration since the last POR (Power On Reset)",
	"print function constant, displays the duration since the time was last synchronised with the PC Host",
	"print function constant, displays the next matching time argument in the future corresponding to the script's time register",
	"print function constant, displays the NMEA end sentence sequence, including CRC, useful for sending NMEA sentences",
	"print function constant, displays the script's log's file name",
	"print function constant, displays the script's time register",
	"print function constant, displays the script's time register if it is set",
	"print function constant, displays the script's time as a string suitable for a file name",
	"print function constant, displays the script's date as a string suitable for a file name",
	"print function constant, displays the script's time as a numeric string suitable for a file name",
	"print function constant, displays the script's date as a numeric string suitable for a file name",
	"print function constant, displays the script's time if it is set or the duration since the script was last restarted",
	"print function constant, displays the duration since the script was last restarted",
	"print function constant, displays the contents of the input serial pipe buffer",
	"print function constant, displays the contents of the NMEA string schema to use to match NMEA sentences received on the serial pipe buffer",
	/* Process Related Define Constants */
	"used to pause a script",
	"used to unpause a script",
	/* define constants for header objects */
	"use the system default execution priority", 
	"use the system default execution mode (restart on HALT)", 
	"use the no-restart execution mode (no restart on HALT)",
	/* for One Wire Modes */
	"use the serial port for the OneWire bus implementation", 
	"use a digital IO pin for the OneWire bus implementation", 
	"use over drive speeds on the OneWire bus", 
	"select write direction for the OneWire bus", 
	"select read direction for the OneWire bus", 
	"enable a strong pull up on the OneWire bus",
	/* IO related  constants */
	"indicates the IO pin is to be opened as an input",
	"indicates the IO pin is to be opened as an output",
	"a high level on the IO pin",
	"a low level on the IO pin",
	/* UART related */
	"default options for the serial port",		 
	"do not invert the transmit (Tx) pin output for the serial port",		 
	"do not invert the receive (Rx) pin input for the serial port",		
	"enables open drain output for the transmit (Tx) pin on the serial port",	  
	"enables interrupt receive on the serial port (system limited)", 
	"disables transmit (Tx) on the serial port (UART)",		 
	"disables receive (Rx) on the serial port (UART)",			
	"disables the serial port function (UART)",
	"there was a receive (Rx) overrun error on the serial port", 
	"enable automatic NMEA sentence decoding on the serial port input (GPS GPRMC sentence decoding)",	
	"there was a receive (Rx) serial port input pipe overflow error", 
	"there was a receive (Rx) serial port input pipe underflow error", 
	"the maximum capacity of the serial port input pipe buffer",
	/* Time related */
	"display the day of the month", 
	"display the day of the week", 
	"display the minutes", 
	"display the seconds", 
	"display the hours", 
	"display the month", 
	"display the year",
	"display the system default time settings",
	"digital channel D0",
	"digital channel D1",
	"digital channel D2",
	"digital channel D3",
	"digital channel D4 (multiplexed with analog channel A0)",
	"digital channel D5 (multiplexed with analog channel A1)",
	"analog channel A0 (multiplexed with digital channel D4)",
	"analog channel A1 (multiplexed with digital channel D5)",
	"analog channel A2",
	"analog channel A3",
	"number of bytes output by the automatic match for GPS GPRMC NMEA sentences, used to determine when a match occurs (the $$nmea.outputPtr will be >= this number to indicate a good match)",
	""
	};

const double definesValueTable[]=
	{
	3.141592654,
	/* Pipe Related Define Constants */
	(double)SERIAL_PIPE_MODE, (double)LOGFILE_PIPE_MODE, (double)SERIAL_USB_PIPE_MODE, (double)FILENAME_PIPE_MODE, (double)SYSTEM_LOGFILE_PIPE_MODE,
	/* Print Function Define Constants */
	(double) PF_LOCAL_TIME, (double) PF_LOCAL_TIME_IF_SET, (double) PF_LOCAL_TIME_FILE_STRING, (double) PF_LOCAL_DATE_FILE_STRING,
	(double) PF_LOCAL_TIME_FILE_STRING_NUMERIC, (double) PF_LOCAL_DATE_FILE_STRING_NUMERIC, (double) PF_LOCAL_TIME_OR_DURATION,
	(double) PF_LOCAL_DURATION_SINCE_LAST_SYNC, (double) PF_VM_TIME_FUTURE, (double) PF_NMEA, 
	(double) PF_VM_FILENAME, (double) PF_VM_TIME, (double) PF_VM_TIME_IF_SET, (double) PF_VM_TIME_FILE_STRING,
	(double) PF_VM_DATE_FILE_STRING, (double) PF_VM_TIME_FILE_STRING_NUMERIC, (double) PF_VM_DATE_FILE_STRING_NUMERIC,
	(double) PF_VM_TIME_OR_DURATION, (double) PF_VM_DURATION_SINCE_LAST_SYNC,
	(double) PF_GPS_PIPE,  (double)PF_GPS_TEMPSTRING,

	/* Process Related Define Constants */
	(double)VM_ID_HOLD, (double)0,
	/* define constants for header objects */
	(double)VM_EXEC_PRIORITY_DEFAULT, (double)VM_EXEC_MODE_DEFAULT, (double)VM_EXEC_MODE_NO_RESTART,
	(double)0, (double)ONE_WIRE_USING_IO, (double)ONE_WIRE_OVERDRIVE, (double)ONE_WIRE_WRITE_DIR, (double)ONE_WIRE_READ_DIR, (double)ONE_WIRE_STRONG_PULLUP,
	(double)1.0, (double)0.0, (double)1.0, (double)0.0,
	(double)0.0,
	(double)UART_NO_TX_INV, (double)UART_NO_RX_INV, (double)UART_OD, (double)UART_RX_INT, (double)UART_NO_TX, (double)UART_NO_RX, (double)NO_UART_MODE,
	(double)GPS_OVERRUN_ERROR, (double)UART_GPS_MODE,  (double)GPS_OVERFLOW_ERROR,   (double)GPS_UNDERFLOW_ERROR,
	(double)MAX_GPS_PIPE_LENGTH, 

	/* Time Related */
	(double)SHOW_WDAY,	(double)SHOW_DAY,	(double)SHOW_MINUTES,	(double)SHOW_SECONDS,	
	(double)SHOW_HOURS,	(double)SHOW_MONTH,	(double)SHOW_YEAR,		(double)SHOW_TIME_DEFAULT,
	(double)0, (double)1, (double)2, (double)3, (double)4, (double)5, 
	(double)0, (double)1, (double)2, (double)3,
	(double)AUTO_MATCH_NUM_BYTES_GPRMC,
	0.0
	};

System::String^		formatStringFloat(double f, int numdec);
System::String^		getStringFromUnsignedCharArray(unsigned char* inarray, unsigned int numchars);
System::String^		getStringFromUnsignedCharArrayAuto(unsigned char* inarray);
System::String^		getStringFromStdString(std::string* instring);
double				setGlobalVariableValue(int valID, int index, double value);
double				getGlobalVariableValue(int valID, int index);
class				CNArgument;
double				doGlobalFunction(int functionID, CNArgument* argList);
std::string			getStdStringFromString(System::String^ instring);
System::String^		HexToString(unsigned long input, unsigned char bytes);

class BaseNode
	{

	public:

		BaseNode*			 offsetExpression;
		unsigned char		 movOpcode;
		std::string			 name;
		unsigned char		 type;

		/// required for virtual functions. in the derived classes the operands are
		/// deleted...

		BaseNode(std::string &instring=std::string(""), unsigned char opc=OPCODE_MOVW, BaseNode* offs=nullptr, unsigned char tp=NORMAL_TYPE)
			{
			name=instring;
			movOpcode=opc;
			offsetExpression=offs;
			type=tp;
			}

		virtual ~BaseNode()
			{

			}

		/// evaluate the complete calculation tree and return the floating point
		/// result value
		virtual double	evaluate() const = 0;

		virtual std::string* getReferenceName()
			{
			return &this->name;
			}

		virtual bool isConstant()=0;

		virtual System::String^ printString()
			{
			return "BaseNode";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_NOP;
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			return instring;
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			return instring;
			}

		virtual unsigned char listOutputMode(unsigned char** argument, unsigned int* size, int* countStack)
			{
			*size=0;
			return MODE_NONE_OR_STACK_TOP;
			}

		virtual System::String^ listOutputAutomaticPrefix(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			return instring;
			}

		virtual void outputTargetAddress(ADDRESS_TYPE targetAddress, unsigned long* output, unsigned int* size)
			{
			if((targetAddress>=0)&&(targetAddress<64))
				{
				/* we allow 0 for the Stack Reference even though it's the indirect address for others */
				*size=1;
				(*output)=(unsigned long)(targetAddress);
				}
			else
				if((targetAddress>=64)&&(targetAddress<(4096+64)))
					{
					*size=2;
					(*output)=(unsigned long)(targetAddress-64);
					}
				else
					if((targetAddress>=(4096+64))&&(targetAddress<=(MAX_ADDRESS)))
						{
						*size=3;
						(*output)=(unsigned long)targetAddress-(4096+64);
						}
					else
						{
						*size=0;
						}
			}

		unsigned char refType(unsigned char opcode, unsigned char* iArg, unsigned int size)
			{
			unsigned char type;

			type=opcodeArgTypeTable[opcode & 0xFF];
			switch(type)
				{
				default:
					break;

				case REF_ARG_TYPE:

					if(size==1)
						{
						switch(iArg[0] & 0xC0)
							{
							default:
								break;

							case 0x00:
								type=REF_ARG_LOCAL;
								break; 

							case 0x40:
								type=REF_ARG_STACK;
								break;

							case 0x80:
								type=REF_ARG_GLOBAL;
								break;
							}

						}
					else
						if(size==2)
							{
							switch(iArg[0] & 0xF0)
								{
								default:
									break;

								case 0xC0:
									type=REF_ARG_LOCAL;
									break;

								case 0xD0:
									type=REF_ARG_STACK;
									break;

								case 0xE0:
									type=REF_ARG_GLOBAL;
									break;

								}
							}
						else
							if(size==3)
								{
								switch(iArg[0] & 0xFC)
									{
									default:
										break;

									case 0xF0:
										type=REF_ARG_LOCAL;
										break;

									case 0xF4:
										type=REF_ARG_STACK;
										break;

									case 0xF8:
										type=REF_ARG_GLOBAL;
										break;

									}
								}
							break;
				}
			return type;
			}

		unsigned char isOpcodeOptimizable(unsigned char opcode, unsigned char* data, unsigned int size)
			{
			unsigned char result;
			unsigned char type;

			/* Note that Global References are NOT optimized, because they are treated as volatile variables... M.G. */

			result=0;
			type=refType(opcode, data, size);
			switch(opcode & 0xFC)
				{
				case OPCODE_MOVW:
				case OPCODE_MOVWB:
					switch(type)
						{
						default:
							break;

						case LIT_ARG_TYPE:
						case LITI_ARG_TYPE:
						case REF_ARG_LOCAL:
							result=1;
							break;
						}
					break;

				case OPCODE_CLR:
					result=1;
					break;

				case OPCODE_MOVWR:
				case OPCODE_MOVWRB:
					switch(type)
						{
						default:
							break;

						case REF_ARG_LOCAL:		
						case LIT_ARG_TYPE:
						case LITI_ARG_TYPE:
							result=1;
							break;
						}
					break;

				default:
					break;
				}
			return result;
			}

		unsigned char isOpcodeWNeutral(unsigned char opcode)
			{
			unsigned char result;
			/* Opcodes that do NOT affect the value of W after executing! (at any time) return 1 */
			result=0;
			switch(opcode)
				{
				default:
					break;

				case OPCODE_PUSH:
				case OPCODE_PUSH_N:
					result=1;
					break;
				}		
			return result;
			}

		void outOpcode(unsigned char opcode, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			lastOpcode=opcode;
			lastIndex=0;
			/* The reverse movs don't affect the value of W */
			if(((lastOpcode & 0xFC)==OPCODE_MOVWR)||((lastOpcode & 0xFC)==OPCODE_MOVWRB))
				{
				lastMovROpcode[lastMovRNum % MAX_LAST_MOVRS]=opcode;
				lastMovRIndex[lastMovRNum % MAX_LAST_MOVRS]=0;
				}
			else
				if(isOpcodeWNeutral(opcode))
					{
					/* Put All The Opcodes Here that Do NOT affect the value of W, like PUSH_W etc */

					}
				else
					{
					lastNonMovROpcode=lastOpcode;
					lastNonMovRIndex=0;
					lastMovRNum=0;
					}
				(**outptr)=opcode;
				(*outptr)++;
				if(outsize)(*outsize)++;

				if(globalIdleCompileTaskFunctionPointer!=nullptr)
					{
					globalIdleCompileTaskFunctionPointer();
					}
			}

		void outByte(unsigned char c, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			lastData[lastIndex & 0x0F]=c;
			lastIndex++;
			if(((lastOpcode & 0xFC)==OPCODE_MOVWR)||((lastOpcode & 0xFC)==OPCODE_MOVWRB))
				{
				lastMovRData[lastMovRNum % MAX_LAST_MOVRS][lastMovRIndex[lastMovRNum % MAX_LAST_MOVRS] & 0x0F]=c;
				lastMovRIndex[lastMovRNum % MAX_LAST_MOVRS]++;	
				}
			else						  
				{
				lastNonMovRData[lastNonMovRIndex & 0x0F]=c;
				lastNonMovRIndex++;
				}
			(**outptr)=c;
			(*outptr)++;
			if(outsize)(*outsize)++;
			if(globalIdleCompileTaskFunctionPointer!=nullptr)
				{
				globalIdleCompileTaskFunctionPointer();
				}
			}

		unsigned char isLastMovRData(unsigned char opcode, unsigned char* data, unsigned int size)
			{
			int k;
			int i;
			int equal;
			int j;
			unsigned char result;

			result=0;
			k=0;
			while((result==0)&&(k<lastMovRNum)&&(k<MAX_LAST_MOVRS))
				{
				if(lastMovROpcode[k]==opcode)
					{
					/* if the last opcode was a reverse move with the same source as this one's destination, then kill it! */
					if(lastMovRIndex[k]==size)
						{
						i=size;
						equal=1;
					 j=0;
					 while((equal)&&(i>0))
						 {
						 if(lastMovRData[k][j]==*(data+j))
							 {

							 }
						 else
							 {
							 equal=0;
							 }
						 j++;
						 i--;
						 }

					 if(equal)
						 {
						 result=1;
						 }				
						}
					}
				k++;
				}
			return result;
			}

		void outEnd(void)
			{
			/* The reverse movs don't affect the value of W */
			if(((lastOpcode & 0xFC)==OPCODE_MOVWR)||((lastOpcode & 0xFC)==OPCODE_MOVWRB))
				{
				if(isLastMovRData(lastOpcode, &lastData[0], lastIndex))
					{

					}
				else
					{
					lastMovRNum++;			
					}
				}
			}

		void outBytes(unsigned char* ptr, unsigned char** outptr, unsigned int* outsize, int* countStack, unsigned int size)
			{
			while(size>0)
				{
				outByte(*ptr, outptr, outsize, countStack);
				ptr++;
				size--;
				}
			}

		unsigned char outOpcodeOptimized(unsigned char opcode, unsigned char** outptr, unsigned int* outsize, int* countStack, unsigned char* data, unsigned int size)
			{
			unsigned char result;
			unsigned char i;
			unsigned char j;
			unsigned char equal;
			unsigned char k;

			result=1;

			if(copyPropagation)
				{
				/* Check to see if W already contains the value that we are requiring to be moved to it: copy propagation! */
				if(isOpcodeOptimizable(opcode, data, size))
					{
					if(((opcode & 0xFC)==OPCODE_MOVW)||((opcode & 0xFC)==OPCODE_MOVWB))
						{
						k=0;
						while((result)&&(k<lastMovRNum)&&(k<MAX_LAST_MOVRS))
							{

							if((result)&&((lastMovROpcode[k] & 0xFC)==OPCODE_MOVWR)&&((opcode & 0xFC)==OPCODE_MOVW))
								{
								/* if the last opcode was a reverse move with the same source as this one's destination, then kill it! */
								if((lastMovROpcode[k] & 0x03)==(opcode & 0x03))
									{
									if(lastMovRIndex[k]==size)
										{
										i=size;
										equal=1;
										j=0;
										while((equal)&&(i>0))
											{
											if(lastMovRData[k][j]==*(data+j))
												{

												}
											else
												{
												equal=0;
												}
											j++;
											i--;
											}
										if(equal)
											{
											result=0;
											}
										}				
									}
								}

							if((result)&&((lastMovROpcode[k] & 0xFC)==OPCODE_MOVWRB)&&((opcode & 0xFC)==OPCODE_MOVWB))
								{
								/* if the last opcode was a reverse move with the same source as this one's destination, then kill it! */
								if((lastMovROpcode[k] & 0x03)==(opcode & 0x03))
									{
									if(lastMovRIndex[k]==size)
										{
										i=size;
										equal=1;
										j=0;
										while((equal)&&(i>0))
											{
											if(lastMovRData[k][j]==*(data+j))
												{

												}
											else
												{
												equal=0;
												}
											j++;
											i--;
											}
										if(equal)
											{
											result=0;
											}
										}				
									}
								}

							k++;
							}

						if((result)&&(lastNonMovROpcode==opcode))
							{
							/* this implies that the same mode was used too! */
							if(lastNonMovRIndex==size)
								{
								i=size;
								equal=1;
								j=0;
								while((equal)&&(i>0))
									{
									if(lastNonMovRData[j]==*(data+j))
										{

										}
									else
										{
										equal=0;
										}
									j++;
									i--;
									}
								if(equal)
									{
									/* The instructions are the same, so kill it! */
									result=0;
									}
								}
							}
						}		

					if((result)&&((opcode & 0xFC)==OPCODE_CLR))
						{
						if(lastNonMovROpcode==OPCODE_CLR)
							{
							/* kill it */
							result=0;
							}
						}

					if((result)&&(((opcode & 0xFC)==OPCODE_MOVWR)||((opcode & 0xFC)==OPCODE_MOVWRB)))
						{
						result=!isLastMovRData(opcode, data, size);	
						}

					}	

				}

			if(result)
				{
				outOpcode(opcode, outptr, outsize, countStack);
				outBytes(data, outptr, outsize, countStack, size);
				outEnd();
				}
			else
				{
				bytesKilled+=(1+size);		
				}
			return result;
			}

	};

class CalcContext
	{
	public:

		int				scriptNumber;
		int				stackFrame;
		ADDRESS_TYPE	currentLocalVars;
		ADDRESS_TYPE	currentFunctions;
		ADDRESS_TYPE	functionPointer;
		unsigned short	sizeOfFloat;
		unsigned short	sizeOfStringVariable;
		ADDRESS_TYPE	maxLocalAllocationSize;

		/// type of the variable storage

		typedef std::map<std::string, std::vector<ADDRESS_TYPE>>	variablemap_type;
		typedef std::map<std::string, double>						constantsmap_type;
		typedef std::map<std::string, std::vector<ADDRESS_TYPE> >	functionmap_type;
		typedef std::map<std::string, std::vector<double>>			headermap_type;
		typedef std::vector<std::pair<int, int>>					scriptsend_type;


		/// variable storage. maps variable string to doubles

		std::vector<variablemap_type>		localVariables;
		std::vector<variablemap_type>		localStringVariables;
		std::vector<functionmap_type>		localFunctions;

		/// The following are Global!

		constantsmap_type					defineConstants;
		variablemap_type					globalVariables;
		variablemap_type					globalStringVariables;
		functionmap_type					globalFunctions;
		headermap_type						headerObjects;

		scriptsend_type						scriptEnds;
		scriptsend_type						scriptStarts;

		/// array of unassigned expressions found by the parser. these are then
		/// outputted to the user.

		std::vector<BaseNode*>				expressions;
		std::vector<std::string>			expressionsListOutput;
		std::vector<std::string>			expressionsHexOutput;
		std::vector<std::string>			expressionsMapOutput;
		std::vector<std::string>			scriptNames;
		std::vector<unsigned long>			opcodesSaved;

		/// free the saved expression trees

		~CalcContext()
			{
			clearExpressions();
			}

		void restartContext(void)
			{	
			variablemap_type *nType;
			functionmap_type *fType;

			nType=new variablemap_type();
			nType->clear();
			localVariables.push_back(*nType);

			nType=new variablemap_type();
			nType->clear();
			localStringVariables.push_back(*nType);

			fType=new functionmap_type();
			fType->clear();
			localFunctions.push_back(*fType); 

			//defineConstants.clear();
			currentLocalVars=4;
			currentFunctions=0;
			functionPointer=0;
			stackFrame=0;
			sizeOfFloat=SIZE_OF_FLOAT;
			sizeOfStringVariable=SIZE_OF_STRING_VAR;
			maxLocalAllocationSize=MAX_LOCAL_ALLOCATION_SIZE;
			}

		/// free all saved expression trees
		void clearExpressions()
			{
			scriptNumber=0;	
			for(unsigned int i=0; i<expressions.size();++i)
				{
				delete expressions[i];
				}
			localVariables.clear();
			localFunctions.clear();
			localStringVariables.clear();
			opcodesSaved.clear();
			scriptEnds.clear();
			scriptStarts.clear();
			expressionsListOutput.clear();
			expressionsHexOutput.clear();
			expressionsMapOutput.clear();
			expressions.clear();
			scriptNames.clear();
			restartContext();

			}

		void insertContext(void)
			{
			std::vector<ADDRESS_TYPE> v;
			std::vector<double> vc;
			ADDRESS_TYPE offset;
			ADDRESS_TYPE delta;
			ADDRESS_TYPE remainder;
			int i;

			/* Insert Global Variables */

			/* Insert the Header Objects */
			i=0;
			while(1)
				{
				if(headerObjectSize[i]<=0)
					{
					break;
					}
				else
					{
					vc.clear();
					vc.insert(vc.end(), (double)headerObjectOffset[i]);		
					vc.insert(vc.end(), (double)headerObjectSize[i]);
					vc.insert(vc.end(), (double)(HEADER_OBJECTS_TAG)+i);
					this->headerObjects.insert(std::pair<std::string, std::vector<double>>(headerObjectNameTable[i], vc));
					i++;
					}
				}

			/* Insert the Functions */
			i=0;
			while(1)
				{
				if(globalFunctionIDTable[i]<0)
					{
					break;
					}
				else
					{
					v.clear();
					v.insert(v.end(), (ADDRESS_TYPE)globalFunctionIDTable[i]);		
					v.insert(v.end(), (ADDRESS_TYPE)globalFunctionArgTable[globalFunctionIDTable[i]]);
					v.insert(v.end(), (ADDRESS_TYPE)i | GLOBAL_FUNCTIONS_TAG);
					this->globalFunctions.insert(std::pair<std::string, std::vector<ADDRESS_TYPE>>(globalFunctionNameTable[i], v));
					i++;
					}
				}

			i=0;
			offset=0;
			while(i<(NUM_GLOBAL_VARS-1))
				{
				v.clear();
				v.insert(v.end(), (ADDRESS_TYPE)offset);	
				v.insert(v.end(), (ADDRESS_TYPE)0x7F & globalVariablesSizes[i]);
				v.insert(v.end(), (ADDRESS_TYPE)GLOBAL_VARIABLES_TAG + i);

				if(0x80 & globalVariablesSizes[i])
					{
					/* indicates a floating point type */
					v.insert(v.end(), (ADDRESS_TYPE)1);
					}
				else
					{
					v.insert(v.end(), (ADDRESS_TYPE)0);
					}

				delta=(0x7F & globalVariablesSizes[i])>>(GLOBAL_ADDRESS_SHIFT);
				remainder=(0x7F & globalVariablesSizes[i]) & (GLOBAL_ADDRESS_OFFSET);
				if(remainder>0)delta++;
				offset+=(delta<<(GLOBAL_ADDRESS_SHIFT));
				this->globalVariables.insert(this->globalVariables.end(), std::pair<std::string, std::vector<ADDRESS_TYPE>>(globalVariableNameTable[i], v));
				i++;
				}
			/* insert the file object */
			i=NUM_GLOBAL_VARS-1;
			v.clear();
			v.insert(v.end(), (ADDRESS_TYPE)GLOBAL_VARS_UPPER);	
			v.insert(v.end(), (ADDRESS_TYPE)0);
			v.insert(v.end(), (ADDRESS_TYPE)GLOBAL_VARIABLES_TAG + i);
			v.insert(v.end(), (ADDRESS_TYPE)0);
			this->globalVariables.insert(this->globalVariables.end(), std::pair<std::string, std::vector<ADDRESS_TYPE>>(globalVariableNameTable[i], v));

			i=0;
			offset=GLOBAL_VM_UPPER;
			while(1)
				{
				if(vmOffsetGlobalVariableNameTable[i]!="")
					{
					v.clear();
					v.insert(v.end(), (ADDRESS_TYPE)offset+(ADDRESS_TYPE)vmOffsets[i]);	
					v.insert(v.end(), (ADDRESS_TYPE)(SIZE_MASK_FOR_FLOAT-1) & vmSizes[i]);
					v.insert(v.end(), (ADDRESS_TYPE)GLOBAL_VARIABLES_VM_OFFSET_TAG + i);
					if(vmSizes[i] & SIZE_MASK_FOR_FLOAT)
						{
						v.insert(v.end(), (ADDRESS_TYPE)1);
						}
					else
						{
						v.insert(v.end(), (ADDRESS_TYPE)0);
						}
					this->globalVariables.insert(this->globalVariables.end(), std::pair<std::string, std::vector<ADDRESS_TYPE>>(vmOffsetGlobalVariableNameTable[i], v));
					}
				else
					{
					break;
					}
				i++;
				}

			i=0;
			while(1)
				{
				if(definesNameTable[i]=="")
					{
					break;
					}
				else
					{	
					this->defineConstants.insert(std::pair<std::string, double>(definesNameTable[i], definesValueTable[i]));
					this->defineConstants.insert(std::pair<std::string, double>(getStdStringFromString(getStringFromStdString((std::string*)&definesNameTable[i])->ToUpper()), definesValueTable[i]));
					i++;																																		

					}																										  
				}
			}

		/// check if the given variable name exists in the storage

		bool existsLocalStringVariable(const std::string &varname)
			{
			return localStringVariables[scriptNumber].find(varname) != localStringVariables[scriptNumber].end();
			}

		bool existsHeaderObject(const std::string &varname)
			{
			return headerObjects.find(varname) != headerObjects.end();
			}

		bool existsGlobalStringVariable(const std::string &varname)
			{
			return globalStringVariables.find(varname) != globalStringVariables.end();
			}

		bool existsLocalVariable(const std::string &varname)
			{
			return localVariables[scriptNumber].find(varname) != localVariables[scriptNumber].end();
			}

		bool existsGlobalVariable(const std::string &varname)
			{
			return globalVariables.find(varname) != globalVariables.end();
			}

		bool existsDefineConstant(const std::string &defname)
			{
			return defineConstants.find(defname) != defineConstants.end();
			}

		bool existsLocalFunction(const std::string &funcname)
			{
			return localFunctions[scriptNumber].find(funcname) != localFunctions[scriptNumber].end();
			}

		bool existsGlobalFunction(const std::string &funcname) const
			{
			return globalFunctions.find(funcname) != globalFunctions.end();
			}

		ADDRESS_TYPE getSizeOfLocalVariable(const std::string &varname)
			{
			ADDRESS_TYPE result;
			std::vector<ADDRESS_TYPE>* v;		
			result=0;
			if(existsLocalVariable(varname))
				{
				v=&localVariables[scriptNumber][varname];
				result=(ADDRESS_TYPE)(*v)[POSITION_OF_SIZE];
				}
			return result;
			}

		ADDRESS_TYPE getSizeOfLocalStringVariable(const std::string &varname)
			{
			ADDRESS_TYPE result;
			std::vector<ADDRESS_TYPE>* v;		
			result=0;
			if(existsLocalStringVariable(varname))
				{
				v=&localStringVariables[scriptNumber][varname];
				result=(ADDRESS_TYPE)(*v)[POSITION_OF_SIZE];
				}
			return result;
			}

		ADDRESS_TYPE getSizeOfGlobalVariable(const std::string &varname)
			{
			ADDRESS_TYPE result;
			std::vector<ADDRESS_TYPE>* v;		
			result=0;
			if(existsGlobalVariable(varname))
				{
				v=&globalVariables[varname];
				result=(ADDRESS_TYPE)(*v)[POSITION_OF_SIZE];
				}
			return result;
			}

		bool isFloatGlobalVariable(const std::string &varname)
			{
			bool result;
			ADDRESS_TYPE x;

			std::vector<ADDRESS_TYPE>* v;		
			result=false;
			if(existsGlobalVariable(varname))
				{
				v=&globalVariables[varname];
				x=(ADDRESS_TYPE)(*v)[POSITION_OF_IS_FLOAT];
				if(x)result=true;
				}
			return result;
			}

		ADDRESS_TYPE getSizeOfGlobalStringVariable(const std::string &varname)
			{
			ADDRESS_TYPE result;
			std::vector<ADDRESS_TYPE>* v;		
			result=0;
			if(existsGlobalStringVariable(varname))
				{
				v=&globalStringVariables[varname];
				result=(ADDRESS_TYPE)(*v)[POSITION_OF_SIZE];
				}
			return result;
			}

		std::string getIteratorMapString(std::map<std::string, std::vector<ADDRESS_TYPE>>::iterator &myIterator, std::string &result)
			{
			std::string ist;
			unsigned char tempString[64];

			myultoabase((unsigned long)myIterator->second[POSITION_OF_SIZE], (unsigned char*)tempString, 5, 10, 32, ' ');
			ist="0x"+getStdStringFromString(HexToString(myIterator->second[POSITION_OF_ADDRESS], 4))+" "+getStdStringFromString(getStringFromUnsignedCharArrayAuto(tempString))+" ";
			result+=ist+"  ";
			result+=(std::string)myIterator->first+"\r\n";
			return result;
			}

		std::string getLocalVariablesMap(ADDRESS_TYPE startAddress, ADDRESS_TYPE endAddress)
			{
			/* if startAddress==endAddress, get all */
			std::string result;
			std::map<std::string, std::vector<ADDRESS_TYPE>>::iterator myIterator;

			result="Local Variables Map ";
			if(endAddress>startAddress)
				{
				result+="From 0x"+getStdStringFromString(HexToString((unsigned long)startAddress, 4))+" to 0x"+getStdStringFromString(HexToString((unsigned long)endAddress, 4));
				} 
			result+="\r\n";
			myIterator=this->localVariables[scriptNumber].begin();
			while(myIterator!=this->localVariables[scriptNumber].end())
				{
				result=getIteratorMapString(myIterator++, result);
				}
			return result;
			}

		std::string getLocalStringVariablesMap(ADDRESS_TYPE startAddress, ADDRESS_TYPE endAddress)
			{
			/* if startAddress==endAddress, get all */
			std::string result;
			std::map<std::string, std::vector<ADDRESS_TYPE>>::iterator myIterator;

			result="Local String Variables Map ";
			if(endAddress>startAddress)
				{
				result+="From 0x"+getStdStringFromString(HexToString((unsigned long)startAddress, 4))+" to 0x"+getStdStringFromString(HexToString((unsigned long)endAddress, 4));
				} 
			result+="\r\n";
			myIterator=this->localStringVariables[scriptNumber].begin();
			while(myIterator!=this->localStringVariables[scriptNumber].end())
				{
				result=getIteratorMapString(myIterator++, result);
				}
			return result;
			}

		std::string getGlobalVariablesMap(ADDRESS_TYPE startAddress, ADDRESS_TYPE endAddress)
			{
			/* if startAddress==endAddress, get all */
			std::string result;
			std::map<std::string, std::vector<ADDRESS_TYPE>>::iterator myIterator;

			result="Global Variables Map ";
			if(endAddress>startAddress)
				{
				result+="From 0x"+getStdStringFromString(HexToString((unsigned long)startAddress, 4))+" to 0x"+getStdStringFromString(HexToString((unsigned long)endAddress, 4));
				} 
			result+="\r\n";
			myIterator=this->globalVariables.begin();
			while(myIterator!=this->globalVariables.end())
				{
				result=getIteratorMapString(myIterator++, result);
				}
			return result;
			}

		std::string getGlobalStringVariablesMap(ADDRESS_TYPE startAddress, ADDRESS_TYPE endAddress)
			{
			/* if startAddress==endAddress, get all */
			std::string result;
			std::map<std::string, std::vector<ADDRESS_TYPE>>::iterator myIterator;

			result="Global String Variables Map ";
			if(endAddress>startAddress)
				{
				result+="From 0x"+getStdStringFromString(HexToString((unsigned long)startAddress, 4))+" to 0x"+getStdStringFromString(HexToString((unsigned long)endAddress, 4));
				} 
			result+="\r\n";
			myIterator=this->globalStringVariables.begin();
			while(myIterator!=this->globalStringVariables.end())
				{
				result=getIteratorMapString(myIterator++, result);
				}
			return result;
			}

		std::string getHelpDefineConstants(unsigned int index)
			{
			if(definesNameTable[index]!="")
				{
				return definesNameTable[index];		
				}
			else
				return "";
			}

		std::string getHelpHeaderObjects(unsigned int index)
			{
			if(headerObjectNameTable[index]!="")
				{
				return headerObjectNameTable[index];		
				}
			else
				return "";
			}

		std::string getHelpGlobalFunctions(unsigned int index)
			{
			if(globalFunctionNameTable[index]!="")
				{
				return globalFunctionNameTable[index];		
				}
			else
				return "";
			}	

		int getIndexGlobalFunction(int functionID)
			{
			int j;
			j=0;
			while(globalFunctionIDTable[j]>=0)
				{
				if(globalFunctionIDTable[j]==functionID)break;
				j++;
				}
			return j;
			}



	};

/** Calculation node always returning a constant value. */
class CNConstant : public BaseNode
	{

	protected:
		/// the constant value returned
		double	value;

	public:
		/// construct a constant calculation node from a value
		explicit CNConstant(double _value)
			: BaseNode(), value(_value)
			{

			}

		virtual double evaluate() const
			{
			return value;
			}

		virtual bool isConstant()
			{
			return true;
			}

		virtual System::String^ printString()
			{
			return "CNConstant";
			}

		virtual bool isListOutputTerminal()
			{
			return true;
			}

		unsigned char getLiteralMode(float f, short* i)
			{
			unsigned char mode;

			mode=MODE_LITERAL;
			if((f<=32767)&&(f>=-32768))
				{
				*i=(short)f;
				if(f==(float)*i)
					{
					/* roughly an integer? */
					mode=MODE_RESERVED;
					}	
				}
			return mode;
			}

		virtual unsigned char listOutputMode(unsigned char** argument, unsigned int* size, int* countStack)
			{
			float f;
			unsigned char* ptr;
			short i;
			unsigned char mode;

			f=(float)value;
			mode=getLiteralMode(f, &i);
			if(mode==MODE_LITERAL)
				{
				f=(float)value;
				ptr=(unsigned char*)&f;
				(**argument)=*ptr++;
				(*argument)++;
				(**argument)=*ptr++;
				(*argument)++;
				(**argument)=*ptr++;
				(*argument)++;
				(**argument)=*ptr++;
				(*argument)++;
				(*size)+=4;
				}
			else
				{	
				(**argument)=(unsigned char)(i>>8);
				(*argument)++;
				(**argument)=(unsigned char)i;
				(*argument)++;
				(*size)+=2;
				}
			return mode;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{	
			short i;
			unsigned char mode;

			mode=getLiteralMode((float)value, &i);
			if(mode==MODE_LITERAL)
				{
				instring+="CONSTANT("+formatStringFloat((double)value, 2)+")";
				}
			else
				{
				instring+="INTEGER CONSTANT("+formatStringFloat((double)i, 0)+")";
				}
			return instring;
			}
	}; 

class CNTimeArgument : public BaseNode
	{

	protected:
		/// the constant value returned
		BaseNode* expr[5];

	public:
		/// construct a constant calculation node from a value
		explicit CNTimeArgument(BaseNode* mnth=0, BaseNode* d=0, BaseNode* h=0, BaseNode* m=0, BaseNode* s=0)
			: BaseNode()
			{
			expr[0]=mnth;
			expr[1]=d;
			expr[2]=h;
			expr[3]=m;
			expr[4]=s;
			}

		virtual double evaluate() const
			{
			return 0;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNTimeArgument";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			unsigned int	i;
			unsigned int	j;
			unsigned int	lsize;
			unsigned char	mode;
			unsigned char   bArray[16];
			unsigned char*  ptr;

			j=0;
			for(i=0; i<5; i++)
				{
				if((j==0)&&(expr[i]==0))
					{
					/* skip null arguments */
					}
				else
					{
					if((j==0)&&(i>=0))
						{
						outOpcode(OPCODE_CLEARFTIMEFLAGS, outptr, outsize, countStack);
						outByte((unsigned char)i, outptr, outsize, countStack);
						outEnd();
						instring+="CLR TIME ARGS, 0x"+HexToString((unsigned long)i, 1)+"\r\n";
						}
					j=1;				
					if(expr[i]->isListOutputTerminal())
						{
						lsize=0;
						ptr=&bArray[0];
						mode=expr[i]->listOutputMode(&ptr, &lsize, countStack);

						if(expr[i]->movOpcode==OPCODE_MOVW)
							{
							if(outOpcodeOptimized(OPCODE_MOVW+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
								{
								instring+="MOV W, "+expr[i]->listOutput("", outptr, outsize, countStack)+"\r\n";		
								}

							}
						else
							{
							if(outOpcodeOptimized(OPCODE_MOVWB+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
								{
								instring+="MOVB W, "+expr[i]->listOutput("", outptr, outsize, countStack)+"\r\n";
								}
							}
						}
					else
						{					
						instring=expr[i]->listOutput(instring, outptr, outsize, countStack);
						}
					outOpcode(OPCODE_MOVTIMEW, outptr, outsize, countStack);
					outEnd();
					instring+="MOV [TIME++], W\r\n";
					}
				}
			return instring;
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			return instring;
			}

	};

class CNOp : public BaseNode
	{
	public:
		BaseNode* container;

		explicit CNOp(BaseNode* cont=0)
			: BaseNode(), container(cont)
			{

			}

		virtual double evaluate() const
			{
			return 0.0;
			}

		virtual bool isConstant()
			{
			if(container)
				{
				return container->isConstant();
				} else
					return false;
			}

		virtual System::String^ printString()
			{
			return "CNOp";
			}

		virtual bool isListOutputTerminal()
			{
			bool result;

			if(container)
				{
				result=container->isListOutputTerminal();
				}
			else
				{
				result=false;
				}
			return result;
			}

		virtual unsigned char listOutputMode(unsigned char** argument, unsigned int* size, int* countStack)
			{
			if(container)
				{
				return container->listOutputMode(argument, size, countStack);
				}
			else
				{
				*size=0;
				return MODE_NONE_OR_STACK_TOP;
				}
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			if(container)
				{
				instring=container->listOutput(instring, outptr, outsize, countStack);
				}
			else
				{

				}
			return instring;
			}
	};

class CNMemoryReference : public BaseNode
	{

	public:
		unsigned char	 mask;
		ADDRESS_TYPE     variableID;
		std::string		 refName;

		explicit CNMemoryReference(std::string &instring, ADDRESS_TYPE varID=0, BaseNode* offs=0, unsigned char msk=0, std::string& iname=std::string(""), unsigned char mopc=OPCODE_MOVW)
			: BaseNode(instring, mopc, offs), variableID(varID), mask(msk), refName(iname)
			{

			}

		virtual double evaluate() const
			{
			return 0.0;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNMemoryReference";
			}

		virtual bool isListOutputTerminal()
			{
			bool result;
			if(offsetExpression)
				{
				result=offsetExpression->isConstant();
				}
			else
				{
				result=true;
				}
			return result;
			}

		virtual unsigned char listOutputMode(unsigned char** argument, unsigned int* size, int* countStack)
			{
			ADDRESS_TYPE   targetAddress;
			unsigned int   tSize;
			unsigned long  tAddr;

			if((!offsetExpression)||(offsetExpression->isConstant()))
				{
				targetAddress=(ADDRESS_TYPE)variableID;
				if(offsetExpression)
					{
					if(offsetExpression->isConstant())
						{
						targetAddress+=(ADDRESS_TYPE)offsetExpression->evaluate();
						}
					}
				outputTargetAddress(targetAddress, &tAddr, &tSize);
				if(tSize==1)
					{
					(**argument)=(unsigned char)((tAddr & 0x3F) | (0xC0 & (this->mask<<4)));
					(*argument)++;
					(*size)++;
					}
				else
					if(tSize==2)
						{
						(**argument)=(unsigned char)(((tAddr>>8) & 0x0F) | (0xF0 & this->mask));
						(*argument)++;
						(**argument)=(unsigned char)(tAddr);
						(*argument)++;
						(*size)+=2;
						}
					else
						if(tSize==3)
							{
							(**argument)=(unsigned char)(0xF0 | (0x0F & this->mask));
							(*argument)++;
							(**argument)=(unsigned char)(tAddr>>8);
							(*argument)++;
							(**argument)=(unsigned char)(tAddr);
							(*argument)++;
							(*size)+=3;
							}
				}
			else
				{
				*size=0;
				}
			return MODE_REFERENCE;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			float offset;
			unsigned int lsize;
			unsigned char mode;
			unsigned char bArray[16];
			unsigned char*  ptr;

			if((!offsetExpression)||(offsetExpression->isConstant()))
				{
				if(offsetExpression)
					{
					offset=(float)offsetExpression->evaluate();
					}
				else
					{
					offset=0.0;
					}
				instring+=getStringFromStdString(&this->refName)+"["+formatStringFloat(variableID, 0)+"+("+formatStringFloat(offset, 0)+")]";
				}
			else
				{
				if(offsetExpression)
					{
					if(offsetExpression->isListOutputTerminal())
						{
						lsize=0;
						ptr=&bArray[0];
						mode=offsetExpression->listOutputMode(&ptr, &lsize, countStack);					
						if(outOpcodeOptimized(OPCODE_MOVW+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
							{
							instring+="MOV W, "+offsetExpression->listOutput("", outptr, outsize, countStack)+"\r\n";
							}
						}
					else
						{
						instring=offsetExpression->listOutput(instring, outptr, outsize, countStack);
						}	
					offset=(float)variableID;

					outOpcode(OPCODE_ADD+MODE_LITERAL, outptr, outsize, countStack);
					outBytes((unsigned char*)&offset, outptr, outsize, countStack, 4);
					outEnd();
					instring+="ADD W, CONSTANT("+formatStringFloat(offset, 2)+")\r\n";

					bArray[0]=(0xC0 & (this->mask & 0x0F)<<4);
					if(this->movOpcode==OPCODE_MOVW)
						{
						outOpcode(OPCODE_MOVW+MODE_REFERENCE, outptr, outsize, countStack);
						outBytes((unsigned char*)&bArray[0], outptr, outsize, countStack, 1);
						outEnd();
						instring+="MOV W, "+getStringFromStdString(&this->refName)+"[W]\r\n";

						}
					else
						{
						outOpcode(OPCODE_MOVWB+MODE_REFERENCE, outptr, outsize, countStack);
						outBytes((unsigned char*)&bArray[0], outptr, outsize, countStack, 1);
						outEnd();
						instring+="MOVB W, "+getStringFromStdString(&this->refName)+"[W]\r\n";
						}
					}
				}
			return instring;
			}
	};

class CNStackVariableReference : public CNMemoryReference
	{

	public:
		CalcContext* cont;

		explicit CNStackVariableReference(std::string &instring, ADDRESS_TYPE varID=0, CalcContext* dr=0)
			: CNMemoryReference(instring, varID, 0, 0xD4, std::string("STACK VAR REF"), OPCODE_MOVW)
			{
			cont=dr;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual bool isListOutputTerminal()
			{
			return true;
			}

		virtual System::String^ printString()
			{
			return "CNStackVariableReference";
			}

		virtual unsigned char listOutputMode(unsigned char** argument, unsigned int* size, int* countStack)
			{
			ADDRESS_TYPE   targetAddress;
			unsigned int   tSize;
			unsigned long  tAddr;

			targetAddress=(ADDRESS_TYPE)(cont->stackFrame+1-variableID)+(*countStack);
			outputTargetAddress(targetAddress, &tAddr, &tSize);
			if(tSize==1)
				{
				(**argument)=(unsigned char)((tAddr & 0x3F) | (0xC0 & (this->mask<<4)));
				(*argument)++;
				(*size)++;
				}
			else
				if(tSize==2)
					{
					(**argument)=(unsigned char)(((tAddr>>8) & 0x0F) | (0xF0 & this->mask));
					(*argument)++;
					(**argument)=(unsigned char)(tAddr);
					(*argument)++;
					(*size)+=2;
					}
				else
					if(tSize==3)
						{
						(**argument)=(unsigned char)(0xF0 | (0x0F & this->mask));
						(*argument)++;
						(**argument)=(unsigned char)(tAddr>>8);
						(*argument)++;
						(**argument)=(unsigned char)(tAddr);
						(*argument)++;
						(*size)+=3;
						}
					return MODE_REFERENCE;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			instring+=getStringFromStdString(&this->refName)+"["+formatStringFloat((double)(cont->stackFrame+1-variableID), 0)+"+("+formatStringFloat((double)(*countStack), 0)+")]";
			return instring;
			}
	};

class CNLocalVariableReference : public CNMemoryReference
	{

	public:

		explicit CNLocalVariableReference(std::string &instring, ADDRESS_TYPE varID=0, BaseNode* offs=0)
			: CNMemoryReference(instring, varID, offs, 0xC0, std::string("LOCAL VAR REF"), OPCODE_MOVW)
			{

			}

		virtual System::String^ printString()
			{
			return "CNLocalVariableReference";
			}

	};

class CNLocalVariableByteReference : public CNMemoryReference
	{

	public:

		explicit CNLocalVariableByteReference(std::string &instring, ADDRESS_TYPE varID=0, BaseNode* offs=0)
			: CNMemoryReference(instring, varID, offs, 0xC0, std::string("LOCAL VAR REF"), OPCODE_MOVWB)
			{

			}

		virtual System::String^ printString()
			{
			return "CNLocalVariableByteReference";
			}

	};


class CNBinary : public BaseNode
	{

	protected:
		/// left calculation operand
		BaseNode* 	left;

		/// right calculation operand
		BaseNode* 	right;

	public:
		explicit CNBinary(BaseNode* _left, BaseNode* _right)
			: BaseNode(), left(_left), right(_right)
			{
			}

		virtual ~CNBinary()
			{
			delete left;
			delete right;
			}

		virtual double evaluate() const
			{
			return 0;
			}

		virtual bool isConstant()
			{
			return left->isConstant() && right->isConstant();
			}

		virtual System::String^ printString()
			{
			return "";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_NOP;
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			float f;
			unsigned char* ptr;
			unsigned char mode;
			unsigned int lsize;
			unsigned char bArray[16];

			if(this->isConstant())
				{
				if(this->evaluate()==0.0)
					{
					outOpcode(OPCODE_CLR, outptr, outsize, countStack);
					outEnd();
					instring+="CLR W\r\n";
					}
				else
					{
					f=(float)this->evaluate();
					ptr=(unsigned char*)&f;
					if(outOpcodeOptimized(OPCODE_MOVW+MODE_LITERAL, outptr, outsize, countStack, ptr, 4))
						{
						instring+="MOV W, CONSTANT("+formatStringFloat(f, 2)+")\r\n";
						}
					}
				}
			else
				{

				if(left)
					{	
					if(left->isListOutputTerminal())
						{
						if((left->isConstant())&&(left->evaluate()==0.0))
							{
							outOpcode(OPCODE_CLR, outptr, outsize, countStack);
							outEnd();
							instring+="CLR W\r\n";
							}
						else
							{
							lsize=0;
							ptr=&bArray[0];
							mode=left->listOutputMode(&ptr, &lsize, countStack);
							if(left->movOpcode==OPCODE_MOVW)
								{
								if(outOpcodeOptimized(OPCODE_MOVW+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
									{
									instring+="MOV W, "+left->listOutput("", outptr, outsize, countStack)+"\r\n";
									}
								}
							else
								{
								if(outOpcodeOptimized(OPCODE_MOVWB+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
									{
									instring+="MOVB W, "+left->listOutput("", outptr, outsize, countStack)+"\r\n";
									}
								}
							}
						}
					else
						{
						instring=left->listOutput(instring, outptr, outsize, countStack);
						}
					}

				if(right)
					{
					if(right->isListOutputTerminal())
						{
						lsize=0;
						ptr=&bArray[0];
						mode=right->listOutputMode(&ptr, &lsize, countStack);
						outOpcode(this->getOpcode()+mode, outptr, outsize, countStack);
						outBytes((unsigned char*)&bArray[0], outptr, outsize, countStack, lsize);
						outEnd();
						instring+=this->printString()+" W, "+right->listOutput("", outptr, outsize, countStack)+"\r\n";
						}
					else
						{
						outOpcode(OPCODE_PUSH, outptr, outsize, countStack);
						outEnd();
						instring+="PUSH W\r\n";
						(*countStack)++;
						instring=right->listOutput(instring, outptr, outsize, countStack);
						outOpcode(this->getOpcode()+MODE_NONE_OR_STACK_TOP, outptr, outsize, countStack);
						outEnd();
						instring+=this->printString()+" ST, W, POP\r\n";
						(*countStack)--;
						}
					}
				}
			return instring;
			}
	};

class CNAdd : public CNBinary
	{

	public:
		explicit CNAdd(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			return left->evaluate()+ right->evaluate();
			}

		virtual System::String^ printString()
			{
			return "ADD";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_ADD;
			}

	};

class CNStringVariableReference : public BaseNode
	{

	public:
		unsigned char     sOpcode;
		std::string		  sOpcodeName;
		unsigned char     nOpcode;
		std::string		  nOpcodeName;
		CNAdd			  *totalOffset;
		unsigned char     sizeLimited;
		ADDRESS_TYPE	  size;
		ADDRESS_TYPE	  DSLimit;

		explicit CNStringVariableReference(std::string &instring, ADDRESS_TYPE varID=0, BaseNode* offs=0, unsigned char sOp=OPCODE_NOP, std::string &opname=std::string("NOP"), unsigned char nOp=OPCODE_NOP, std::string &nopname=std::string("NOP"), ADDRESS_TYPE sz=0)
			:  BaseNode(instring, OPCODE_MOVW, offs), sOpcode(sOp), sOpcodeName(opname), nOpcode(nOp), nOpcodeName(nopname), sizeLimited(0), size(sz)
			{
			if(offs!=0)
				totalOffset=new CNAdd(new CNConstant((double)varID), offs);	
			else
				totalOffset=new CNAdd(new CNConstant((double)varID), new CNConstant((double)0));

			if(size>=1)DSLimit=varID+size-1;
			else
				DSLimit=varID;
			}

		virtual double evaluate() const
			{
			return 0.0;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNStringVariableReference";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			unsigned int   lsize;
			unsigned char* ptr;
			unsigned char  mode;
			unsigned char  bArray[16];
			short	       litiValue;

			if(this->sizeLimited)
				{
				CNConstant* N=new CNConstant((double)(ADDRESS_TYPE)DSLimit);
				mode=N->getLiteralMode((float)DSLimit, &litiValue);
				outOpcode(OPCODE_SET_DS_LIMIT+(0x03 & mode), outptr, outsize, countStack);
				instring+="MOV DS LIMIT, ";	
				instring=N->listOutput(instring, outptr, outsize, countStack)+"\r\n"; 
				lsize=0;
				ptr=&bArray[0];
				N->listOutputMode(&ptr, &lsize, countStack);
				outBytes((unsigned char*)&bArray[0], outptr, outsize, countStack, lsize);
				outEnd(); 
				}

			if(this->totalOffset->isListOutputTerminal())
				{
				lsize=0;
				ptr=&bArray[0];
				mode=this->totalOffset->listOutputMode(&ptr, &lsize, countStack);					
				if(outOpcodeOptimized(OPCODE_MOVW+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
					{
					instring+="MOV W, "+this->totalOffset->listOutput("", outptr, outsize, countStack)+"\r\n";
					}
				}
			else
				{
				instring=this->totalOffset->listOutput(instring, outptr, outsize, countStack);
				}

			if(sOpcode!=OPCODE_NOP)
				{
				outOpcode(sOpcode, outptr, outsize, countStack);
				outEnd();
				instring+=getStringFromStdString(&sOpcodeName)+"\r\n";		
				}

			if(nOpcode!=OPCODE_NOP)
				{
				outOpcode(nOpcode, outptr, outsize, countStack);
				outEnd();
				instring+=getStringFromStdString(&nOpcodeName)+"\r\n";
				}
			return instring;
			}
	};

class CNLocalStringVariableReference : public CNStringVariableReference
	{
	public :

		explicit CNLocalStringVariableReference(std::string &instring, ADDRESS_TYPE varID=0, BaseNode* offs=0, ADDRESS_TYPE size=0)
			: CNStringVariableReference(instring, varID, offs, OPCODE_MOVSLW, std::string("MOV SS, LOCAL W"), OPCODE_MOVS, std::string("MOVS [DS++], [SS++]"), size)
			{

			}

		virtual System::String^ printString()
			{
			return "CNLocalStringVariableReference";
			}
	};

class CNGlobalStringVariableReference : public CNStringVariableReference
	{
	public: 
		explicit CNGlobalStringVariableReference(std::string &instring, ADDRESS_TYPE varID=0, BaseNode* offs=0, ADDRESS_TYPE size=0)
			: CNStringVariableReference(instring, varID, offs, OPCODE_MOVSGW, std::string("MOV SS, GLOBAL W"), OPCODE_MOVS, std::string("MOVS [DS++], [SS++]"), size)
			{

			}

		virtual System::String^ printString()
			{
			return "CNLocalStringVariableReference";
			}
	};

class CNMemoryReferenceAutomatic : public BaseNode
	{

	public:
		unsigned char	 mask;
		ADDRESS_TYPE     variableID;
		ADDRESS_TYPE	 variableSize;
		std::string		 refName;

		explicit CNMemoryReferenceAutomatic(std::string &instring, ADDRESS_TYPE varID=0, ADDRESS_TYPE varSize=1, unsigned char msk=0, std::string& iname=std::string(""), unsigned char mopc=OPCODE_MOVWB)
			: BaseNode(instring, mopc, 0), variableID(varID), variableSize(varSize), mask(msk), refName(iname)
			{

			}

		virtual double evaluate() const
			{
			return 0.0;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNMemoryReferenceAutomatic";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual unsigned char listOutputMode(unsigned char** argument, unsigned int* size, int* countStack)
			{
			ADDRESS_TYPE   targetAddress;
			unsigned int   tSize;
			unsigned long  tAddr;

			if((!offsetExpression)||(offsetExpression->isConstant()))
				{
				targetAddress=(ADDRESS_TYPE)variableID;
				if(offsetExpression)
					{
					if(offsetExpression->isConstant())
						{
						targetAddress+=(ADDRESS_TYPE)offsetExpression->evaluate();
						}
					}
				outputTargetAddress(targetAddress, &tAddr, &tSize);
				if(tSize==1)
					{
					(**argument)=(unsigned char)((tAddr & 0x3F) | (0xC0 & (this->mask<<4)));
					(*argument)++;
					(*size)++;
					}
				else
					if(tSize==2)
						{
						(**argument)=(unsigned char)(((tAddr>>8) & 0x0F) | (0xF0 & this->mask));
						(*argument)++;
						(**argument)=(unsigned char)(tAddr);
						(*argument)++;
						(*size)+=2;
						}
					else
						if(tSize==3)
							{
							(**argument)=(unsigned char)(0xF0 | (0x0F & this->mask));
							(*argument)++;
							(**argument)=(unsigned char)(tAddr>>8);
							(*argument)++;
							(**argument)=(unsigned char)(tAddr);
							(*argument)++;
							(*size)+=3;
							}
				}
			else
				{
				*size=0;
				}
			return MODE_REFERENCE;
			}

		virtual System::String^ listOutputAutomaticPrefix(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			switch(variableSize)
				{
				default:	
					break;

				case sizeof(unsigned short):
					outOpcode(OPCODE_SIZE_SHORT, outptr, outsize, countStack);
					outEnd();
					instring+="SIZE SHORT\r\n";
					break;

				case sizeof(unsigned long):
					outOpcode(OPCODE_SIZE_LONG, outptr, outsize, countStack);
					outEnd();
					instring+="SIZE LONG\r\n";
					break;
				}
			return instring;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			float			offset;
			unsigned int    lsize;
			unsigned char   mode;
			unsigned char   bArray[16];
			unsigned char*  ptr;

			instring+=this->listOutputAutomaticPrefix("", outptr, outsize, countStack);
			if(offsetExpression)
				{
				offset=(float)offsetExpression->evaluate();
				}
			else
				{
				offset=0.0;
				}
			lsize=0;
			ptr=&bArray[0];
			mode=this->listOutputMode(&ptr, &lsize, countStack);					
			outOpcode(OPCODE_MOVWB+mode, outptr, outsize, countStack);
			outBytes((unsigned char*)&bArray[0], outptr, outsize, countStack, lsize);
			outEnd();
			instring+="MOVB W, "+getStringFromStdString(&this->refName)+"["+formatStringFloat(variableID, 0)+"+("+formatStringFloat(offset, 0)+")]\r\n";
			return instring;
			}
	};

class CNGlobalVariableReferenceAutomatic : public CNMemoryReferenceAutomatic
	{

	public:

		explicit CNGlobalVariableReferenceAutomatic(std::string &instring, ADDRESS_TYPE varID=0, ADDRESS_TYPE varSize=1)
			: CNMemoryReferenceAutomatic(instring, varID, varSize, 0xE8, std::string("GLOBAL VAR REF AUTOMATIC"), OPCODE_MOVWB)
			{

			}

		virtual System::String^ printString()
			{
			return "CNGlobalVariableReferenceAutomatic";
			}

	};

class CNMemoryAssignment : public BaseNode
	{	
	public:
		BaseNode*  target;
		BaseNode*  expression;

		/// construct a constant calculation node from a value
		explicit CNMemoryAssignment(BaseNode* varref=0, BaseNode* expr=0)
			: BaseNode(), target(varref), expression(expr)
			{

			}

		virtual double evaluate() const
			{
			return 0.0;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNMemoryAssignment";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			unsigned int lsize;
			unsigned char* ptr;
			unsigned char mode;
			unsigned char tempMovOpcode;
			unsigned char bArray[16];

			if(expression)
				{
				if(expression->isListOutputTerminal())
					{
					if((expression->isConstant())&&(expression->evaluate()==0.0))
						{
						if(outOpcodeOptimized(OPCODE_CLR, outptr, outsize, countStack, 0, 0))
							{
							instring+="CLR W\r\n";
							}
						}
					else
						{
						lsize=0;
						ptr=&bArray[0];
						mode=expression->listOutputMode(&ptr, &lsize, countStack);
						if(expression->movOpcode==OPCODE_MOVW)
							{
							if(outOpcodeOptimized(OPCODE_MOVW+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
								{
								instring+="MOV W, "+expression->listOutput("", outptr, outsize, countStack)+"\r\n";
								}
							}
						else
							{
							if(outOpcodeOptimized(OPCODE_MOVWB+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
								{
								instring+="MOVB W, "+expression->listOutput("", outptr, outsize, countStack)+"\r\n";
								}
							}
						}
					}
				else
					{
					instring=expression->listOutput(instring, outptr, outsize, countStack);
					}
				}

			if(target)
				{
				if(target->printString()=="CNGlobalVariableReferenceAutomatic")
					{
					CNGlobalVariableReferenceAutomatic* otarget;
					try
						{
						otarget=dynamic_cast<CNGlobalVariableReferenceAutomatic*>(target);
						}
					catch(...)
						{
						/* Dynamic Cast Error! */
						return instring;
						}

					instring+=otarget->listOutputAutomaticPrefix("", outptr, outsize, countStack);
					lsize=0;
					ptr=&bArray[0];
					mode=otarget->listOutputMode(&ptr, &lsize, countStack);

					outOpcode(OPCODE_MOVWRB+mode, outptr, outsize, countStack);
					outBytes((unsigned char*)&bArray[0], outptr, outsize, countStack, lsize);
					outEnd();

					instring+="MOVB "+getStringFromStdString(&otarget->refName)+"["+formatStringFloat(otarget->variableID, 0)+"+("+formatStringFloat(0, 0)+")], W\r\n";

					}
				else
					{	

					if(target->isListOutputTerminal())
						{
						lsize=0;
						ptr=&bArray[0];
						mode=target->listOutputMode(&ptr, &lsize, countStack);

						if(target->movOpcode==OPCODE_MOVW)
							{
							if(outOpcodeOptimized(OPCODE_MOVWR+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
								{
								instring+="MOV "+target->listOutput("", outptr, outsize, countStack)+", W\r\n";
								}
							}
						else
							{
							if(outOpcodeOptimized(OPCODE_MOVWRB+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
								{
								instring+="MOVB "+target->listOutput("", outptr, outsize, countStack)+", W\r\n";			
								}
							}
						}
					else
						{

						outOpcode(OPCODE_PUSH, outptr, outsize, countStack);
						outEnd();
						instring+="PUSH W\r\n";
						(*countStack)++;

						/* force target to be full size for the expression of the offset to be evaluated in full size */

						tempMovOpcode=target->movOpcode;
						target->movOpcode=OPCODE_MOVW;
						instring=target->listOutput(instring, outptr, outsize, countStack);
						target->movOpcode=tempMovOpcode;

						if(target->movOpcode==OPCODE_MOVW)
							{
							outOpcode(OPCODE_POP_IND, outptr, outsize, countStack);
							outEnd();
							instring+="POP INDIRECT\r\n";
							}
						else
							{
							outOpcode(OPCODE_POP_IND_B, outptr, outsize, countStack);
							outEnd();
							instring+="POPB INDIRECT\r\n";
							}
						(*countStack)--;
						}
					}
				}
			return instring;
			}
	};

class CNLocalVariableAssignment : public CNMemoryAssignment
	{  
	public:

		/// construct a constant calculation node from a value
		explicit CNLocalVariableAssignment(BaseNode* varref=0, BaseNode* expr=0)
			: CNMemoryAssignment(varref , expr)
			{

			}

		virtual System::String^ printString()
			{
			return "CNLocalVariableAssignment";
			}
	};

class CNGlobalVariableAssignment : public CNMemoryAssignment
	{    
	public:
		/// construct a constant calculation node from a value
		explicit CNGlobalVariableAssignment(BaseNode* varref=0, BaseNode* expr=0)
			: CNMemoryAssignment(varref , expr)
			{

			}

		virtual System::String^ printString()
			{
			return "CNGlobalVariableAssignment";
			}
	};

class CNStringMemoryAssignment : public BaseNode
	{	
	public:
		BaseNode*					expression;
		CNStringVariableReference*	target;

		/// construct a constant calculation node from a value
		explicit CNStringMemoryAssignment(CNStringVariableReference* varref=0, BaseNode* expr=0, unsigned char sizeLimited=0, unsigned char opcode=OPCODE_NOP, std::string& instring=std::string("NOP"))
			: BaseNode(), expression(expr)
			{
			target=varref;
			target->sOpcode=opcode;
			target->sOpcodeName=instring;
			target->nOpcode=OPCODE_NOP;
			target->sizeLimited=sizeLimited;

			}

		virtual double evaluate() const
			{
			return 0.0;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNStringVariableAssignment";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			/* Get the DS pointer to hold the correct destination address */
			instring=this->target->listOutput(instring, outptr, outsize, countStack);
			/* Now get the SS pointer to hold the correct source address */
			instring=this->expression->listOutput(instring, outptr, outsize, countStack);

			outOpcode(OPCODE_CLEAR_DS_SS, outptr, outsize, countStack);
			outEnd();
			instring+="CLR DS, SS\r\n";
			return instring;
			}
	};

class CNLocalStringVariableAssignment : public CNStringMemoryAssignment
	{	
	public:

		/// construct a constant calculation node from a value
		explicit CNLocalStringVariableAssignment(CNStringVariableReference* varref=0, BaseNode* expr=0)
			: CNStringMemoryAssignment(varref, expr, 1, OPCODE_MOVDLW, std::string("MOV DS, LOCAL W"))
			{

			}

		virtual System::String^ printString()
			{
			return "CNLocalStringVariableAssignment";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}
	};

class CNGlobalStringVariableAssignment : public CNStringMemoryAssignment
	{	
	public:
		BaseNode*  target;
		BaseNode*  expression;

		/// construct a constant calculation node from a value
		explicit CNGlobalStringVariableAssignment(CNStringVariableReference* varref=0, BaseNode* expr=0)
			: CNStringMemoryAssignment(varref, expr, 1, OPCODE_MOVDGW, std::string("MOV DS, GLOBAL W"))
			{

			}

		virtual System::String^ printString()
			{
			return "CNGlobalStringVariableAssignment";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			return instring;
			}
	};

class CNStringBinary : public BaseNode
	{

	protected:
		/// left calculation operand
		BaseNode* 	left;

		/// right calculation operand
		BaseNode* 	right;

	public:
		explicit CNStringBinary(BaseNode* _left, BaseNode* _right)
			: BaseNode(), left(_left), right(_right)
			{
			}

		virtual ~CNStringBinary()
			{
			delete left;
			delete right;
			}

		virtual double evaluate() const
			{
			return 0;
			}

		virtual bool isConstant()
			{
			return left->isConstant() && right->isConstant();
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			return instring;
			}
	};

class CNStringAdd : public CNStringBinary
	{
	public:
		explicit CNStringAdd(BaseNode* left, BaseNode* right)
			: CNStringBinary(left, right)
			{

			}
	};

class CNConditional : public BaseNode
	{   
	public:
		BaseNode*  conditional;
		BaseNode*  expressionTrue;
		BaseNode*  expressionFalse;

		explicit CNConditional(BaseNode* cond=0, BaseNode* iftrue=0, BaseNode* iffalse=0)
			: BaseNode(), conditional(cond), expressionTrue(iftrue), expressionFalse(iffalse)
			{

			}

		virtual double evaluate() const
			{
			return conditional->evaluate();
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNConditional";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			unsigned char*  ptr;
			System::String^ trueString;
			System::String^ falseString;
			unsigned int    tsize;
			unsigned int    fsize;
			unsigned int    csize;
			unsigned char   tempSize;
			unsigned int	lsize;
			unsigned char	mode;
			unsigned char   bArray[16];

			if(conditional)
				{
				if(conditional->isConstant())
					{
					if((unsigned int)conditional->evaluate())
						{
						if(expressionTrue)
							{


							}
						}
					else
						{
						if(expressionFalse)
							{


							}
						}
					}
				else
					{
					tempSize=(*outsize);
					csize=0;
					if(conditional->isListOutputTerminal())
						{
						lsize=0;
						ptr=&bArray[0];
						mode=conditional->listOutputMode(&ptr, &lsize, countStack);
						if(conditional->movOpcode==OPCODE_MOVW)
							{
							if(outOpcodeOptimized(OPCODE_MOVW+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
								{
								instring+="MOV W, "+conditional->listOutput("", outptr, outsize, countStack)+"\r\n";
								csize=1+lsize;
								}
							}
						else
							{
							if(outOpcodeOptimized(OPCODE_MOVWB+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
								{
								instring+="MOVB W, "+conditional->listOutput("", outptr, outsize, countStack)+"\r\n";
								csize=1+lsize;
								}
							}
						}
					else
						{
						instring=conditional->listOutput(instring, outptr, &csize, countStack);
						}

					outOpcode(OPCODE_BRZ, outptr, outsize, countStack);
					ptr=(*outptr);
					(*outptr)++;
					(*outptr)++;
					tsize=0;
					fsize=0;
					if(expressionTrue)
						{
						tsize=0;
						trueString=expressionTrue->listOutput("", outptr, &tsize, countStack);
						if(expressionFalse)tsize+=3;
						*ptr++=(unsigned char)(tsize>>8);
						*ptr++=(unsigned char)(tsize);
						instring+="BRZ +"+formatStringFloat((double)tsize, 0)+"\r\n";
						}

					if(expressionFalse)
						{	
						outOpcode(OPCODE_BRA, outptr, outsize, countStack);
						ptr=(*outptr);
						(*outptr)++;
						(*outptr)++;
						fsize=0;
						falseString=expressionFalse->listOutput("", outptr, &fsize, countStack);
						trueString+="BRA +"+formatStringFloat((double)fsize, 0)+"\r\n";
						*ptr++=(unsigned char)(fsize>>8);
						*ptr++=(unsigned char)(fsize);
						}
					instring+=trueString+falseString;
					(*outsize)=tempSize+(csize+3+tsize+fsize);
					}
				}
			return instring;
			}
	};

class CNWhileLoop : public BaseNode
	{   
	public:
		BaseNode*  conditional;
		BaseNode*  loopBody;

		explicit CNWhileLoop(BaseNode* cond=0, BaseNode* bdy=0)
			: BaseNode(), conditional(cond), loopBody(bdy)
			{

			}

		virtual double evaluate() const
			{
			return conditional->evaluate();
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNWhileLoop";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			unsigned int lsize;
			unsigned int csize;
			int			 nsize;
			unsigned char* ptr;
			System::String^ cString;
			System::String^ lString;
			unsigned char	mode;
			unsigned char   bArray[16];

			if(conditional)
				{
				if(conditional->isConstant())
					{
					if((unsigned int)conditional->evaluate())
						{
						/* infinite loop */
						if(loopBody)
							{
							lsize=0;
							instring=loopBody->listOutput(instring, outptr, &lsize, countStack);
							nsize=-((int)lsize+3);
							instring+="BRA -"+formatStringFloat((double)lsize+3, 0)+"\r\n";
							outOpcode(OPCODE_BRA, outptr, 0, countStack);
							outByte((unsigned char)(nsize>>8), outptr, 0, countStack);
							outByte((unsigned char)(nsize), outptr, 0, countStack);
							outEnd();
							(*outsize)+=(lsize+3);
							}
						}
					else
						{

						}
					}
				else
					{
					if(loopBody)
						{
						csize=0;
						cString="";
						if(conditional->isListOutputTerminal())
							{
							lsize=0;
							ptr=&bArray[0];
							mode=conditional->listOutputMode(&ptr, &lsize, countStack);
							if(conditional->movOpcode==OPCODE_MOVW)
								{
								if(outOpcodeOptimized(OPCODE_MOVW+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
									{
									cString="MOV W, "+conditional->listOutput("", outptr, outsize, countStack)+"\r\n";
									csize=1+lsize;			
									}
								}
							else
								{
								if(outOpcodeOptimized(OPCODE_MOVWB+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
									{
									cString="MOVB W, "+conditional->listOutput("", outptr, outsize, countStack)+"\r\n";
									csize=1+lsize;
									}
								}
							}
						else
							{
							cString=conditional->listOutput("", outptr, &csize, countStack);
							}

						outOpcode(OPCODE_BRZ, outptr, 0, countStack);
						ptr=(*outptr);
						(*outptr)++;
						(*outptr)++;
						csize+=3;

						lsize=0;
						lString=loopBody->listOutput("", outptr, &lsize, countStack);
						lsize+=3;

						nsize=-((int)lsize+(int)csize);

						outOpcode(OPCODE_BRA, outptr, 0, countStack);

						outByte((unsigned char)(nsize>>8), outptr, 0, countStack);
						outByte((unsigned char)(nsize), outptr, 0, countStack);
						outEnd();
						instring+=cString+"BRZ +"+formatStringFloat((double)lsize, 0)+"\r\n"+lString+"BRA -"+formatStringFloat((double)lsize+csize, 0)+"\r\n";

						*ptr++=(unsigned char)(lsize>>8);
						*ptr++=(unsigned char)(lsize);
						(*outsize)+=(lsize+csize);
						}
					}
				}
			return instring;
			}
	};

class CNArgument : public BaseNode
	{

	public:
		BaseNode*		argThis;
		BaseNode*		argNext;

		explicit CNArgument(BaseNode* athis=0, BaseNode* anext=0)
			: BaseNode(), argThis(athis), argNext(anext)
			{
			}

		virtual double evaluate() const
			{
			return this->argThis->evaluate();
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNArgument";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			unsigned int lsize;
			unsigned char* ptr;
			unsigned char mode;
			unsigned char bArray[16];

			if(argThis)
				{
				if(argThis->isListOutputTerminal())
					{
					lsize=0;
					ptr=&bArray[0];
					mode=argThis->listOutputMode(&ptr, &lsize, countStack);

					if(argThis->movOpcode==OPCODE_MOVW)
						{
						if(outOpcodeOptimized(OPCODE_MOVW+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
							{
							instring+="MOV W, "+argThis->listOutput("", outptr, outsize, countStack)+"\r\n";
							}
						}
					else
						{
						if(outOpcodeOptimized(OPCODE_MOVWB+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
							{
							instring+="MOVB W, "+argThis->listOutput("", outptr, outsize, countStack)+"\r\n";
							}
						}
					}
				else
					{
					instring=argThis->listOutput(instring, outptr, outsize, countStack);
					}
				outOpcode(OPCODE_PUSH, outptr, outsize, countStack);
				outEnd();
				instring+="PUSH W\r\n";
				(*countStack)++;
				}

			if(argNext)
				{
				if(argNext->isListOutputTerminal())
					{
					lsize=0;
					ptr=&bArray[0];
					mode=argNext->listOutputMode(&ptr, &lsize, countStack);
					if(argNext->movOpcode==OPCODE_MOVW)
						{
						if(outOpcodeOptimized(OPCODE_MOVW+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
							{
							instring+="MOV W, "+argNext->listOutput("", outptr, outsize, countStack)+"\r\n";
							}
						}
					else
						{
						if(outOpcodeOptimized(OPCODE_MOVWB+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
							{
							instring+="MOVB W, "+argNext->listOutput("", outptr, outsize, countStack)+"\r\n";
							}
						}
					outOpcode(OPCODE_PUSH, outptr, outsize, countStack);
					outEnd();
					instring+="PUSH W\r\n";
					(*countStack)++;
					}
				else
					{
					instring=argNext->listOutput(instring, outptr, outsize, countStack);
					}
				}
			return instring;
			}

	};

class CNLocalFunctionCall : public BaseNode
	{
	/// the constant value returned
	public:
		BaseNode*		argumentExpression;
		CalcContext*	context;

		/// construct a constant calculation node from a value
		explicit CNLocalFunctionCall(std::string &instring, BaseNode* args=0, CalcContext* cont=0)
			: BaseNode(instring), argumentExpression(args), context(cont)
			{

			}

		virtual double evaluate() const
			{
			return 0.0;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNLocalFunctionCall";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			unsigned int   numArgsGiven;
			unsigned int   numArgsRequired;
			CNArgument*    pptr;
			std::vector<ADDRESS_TYPE>* myVector;
			unsigned int   lsize;
			unsigned char* ptr;
			unsigned char  mode;
			ADDRESS_TYPE   address;
			unsigned char  bArray[16];

			numArgsGiven=0;
			myVector=&context->localFunctions[context->scriptNumber][this->name];
			numArgsRequired=(*myVector)[1];
			if(argumentExpression)
				{
				pptr=(CNArgument*)argumentExpression;		
				while((numArgsGiven<numArgsRequired)&&(pptr))
					{	
					if(pptr->argThis)
						{
						if(pptr->argThis->isListOutputTerminal())
							{
							if((pptr->argThis->isConstant())&&(pptr->argThis->evaluate()==0))
								{
								if(outOpcodeOptimized(OPCODE_CLR, outptr, outsize, countStack, &bArray[0], 0))
									{
									instring+="CLR W\r\n";
									}
								}
							else
								{
								lsize=0;
								ptr=&bArray[0];
								mode=pptr->argThis->listOutputMode(&ptr, &lsize, countStack);
								if(pptr->movOpcode==OPCODE_MOVW)
									{
									if(outOpcodeOptimized(OPCODE_MOVW+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
										{
										instring+="MOV W, "+pptr->argThis->listOutput("", outptr, outsize, countStack)+"\r\n";
										}
									}
								else
									{
									if(outOpcodeOptimized(OPCODE_MOVWB+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
										{
										instring+="MOVB W, "+pptr->argThis->listOutput("", outptr, outsize, countStack)+"\r\n";
										}
									}
								}
							}
						else
							{
							instring=pptr->argThis->listOutput(instring, outptr, outsize, countStack);
							}
						outOpcode(OPCODE_PUSH, outptr, outsize, countStack);
						outEnd();
						instring+="PUSH W\r\n";
						(*countStack)++;
						}
					numArgsGiven++;
					pptr=(CNArgument*)pptr->argNext;
					}
				}	

			if(numArgsGiven<numArgsRequired)
				{
				outOpcode(OPCODE_CLR, outptr, outsize, countStack);
				outEnd();
				instring+="CLR W\r\n";
				mode=(unsigned char)(numArgsRequired-numArgsGiven);
				if(mode>1)
					{
					outOpcode(OPCODE_PUSH_N, outptr, outsize, countStack);
					outByte((unsigned char)mode, outptr, outsize, countStack);
					outEnd();
					instring+="PUSH N, 0x"+HexToString((unsigned long)mode, 1)+"\r\n";
					(*countStack)+=mode;
					}
				else
					{
					outOpcode(OPCODE_PUSH, outptr, outsize, countStack);
					outEnd();
					instring+="PUSH W\r\n";
					(*countStack)++;
					}
				}
			outOpcode(OPCODE_CALL, outptr, outsize, countStack);
			address=(*myVector)[0];
			outByte((unsigned char)(address>>8), outptr, outsize, countStack);
			outByte((unsigned char)(address), outptr, outsize, countStack);
			outEnd();
			instring+="CALL 0x"+HexToString(address, 2)+"\r\n";
			(*countStack)=0;
			return instring;
			}
	};

class CNGlobalFunctionCall : public BaseNode
	{
	/// the constant value returned
	public:
		BaseNode*		argumentExpression;
		CalcContext*	context;

		/// construct a constant calculation node from a value
		explicit CNGlobalFunctionCall(std::string &instring, BaseNode* args=0, CalcContext* cont=0)
			: BaseNode(instring), argumentExpression(args), context(cont)
			{

			}

		virtual double evaluate() const
			{
			return 0.0;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNGlobalFunctionCall";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			unsigned int   numArgsGiven;
			unsigned int   numArgsRequired;
			CNArgument*    pptr;
			std::vector<ADDRESS_TYPE>* myVector;
			unsigned int   lsize;
			unsigned char* ptr;
			unsigned char  mode;
			ADDRESS_TYPE   address;
			unsigned char  bArray[16];

			numArgsGiven=0;
			myVector=&context->globalFunctions[this->name];
			numArgsRequired=(*myVector)[1];
			if(argumentExpression)
				{
				pptr=(CNArgument*)argumentExpression;		
				while((numArgsGiven<numArgsRequired)&&(pptr))
					{	
					if(pptr->argThis)
						{
						if(pptr->argThis->isListOutputTerminal())
							{
							if((pptr->argThis->isConstant())&&(pptr->argThis->evaluate()==0))
								{
								if(outOpcodeOptimized(OPCODE_CLR, outptr, outsize, countStack, &bArray[0], 0))
									{
									instring+="CLR W\r\n";
									}
								}
							else
								{
								lsize=0;
								ptr=&bArray[0];
								mode=pptr->argThis->listOutputMode(&ptr, &lsize, countStack);
								if(pptr->movOpcode==OPCODE_MOVW)
									{
									if(outOpcodeOptimized(OPCODE_MOVW+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
										{
										instring+="MOV W, "+pptr->argThis->listOutput("", outptr, outsize, countStack)+"\r\n";
										}
									}
								else
									{
									if(outOpcodeOptimized(OPCODE_MOVWB+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
										{
										instring+="MOVB W, "+pptr->argThis->listOutput("", outptr, outsize, countStack)+"\r\n";
										}
									}
								}
							}
						else
							{
							instring=pptr->argThis->listOutput(instring, outptr, outsize, countStack);
							}
						outOpcode(OPCODE_PUSH, outptr, outsize, countStack);
						outEnd();
						instring+="PUSH W\r\n";
						(*countStack)++;
						}
					numArgsGiven++;
					pptr=(CNArgument*)pptr->argNext;
					}
				}	

			if(numArgsGiven<numArgsRequired)
				{
				outOpcode(OPCODE_CLR, outptr, outsize, countStack);
				outEnd();
				instring+="CLR W\r\n";
				mode=(unsigned char)(numArgsRequired-numArgsGiven);
				if(mode>0)
					{
					outOpcode(OPCODE_PUSH_N, outptr, outsize, countStack);
					outByte((unsigned char)mode, outptr, outsize, countStack);
					outEnd();
					instring+="PUSH N, 0x"+HexToString((unsigned long)mode, 1)+"\r\n";
					(*countStack)+=mode;
					}
				/*	
				Note that although it would save one byte to use PUSH for when mode=1, we need the PUSH N function to know
				how many arguments are defaults! In any case, you could specify 0 as an argument to save the extra byte...

				*/
				}
			outOpcode(OPCODE_GLOBAL_CALL, outptr, outsize, countStack);
			address=(*myVector)[0];
			outByte((unsigned char)(address>>8), outptr, outsize, countStack);
			outByte((unsigned char)(address), outptr, outsize, countStack);
			outEnd();
			instring+="GLOBAL \""+getStringFromStdString((std::string*)&globalFunctionNameTable[context->getIndexGlobalFunction(address)])+"\" (0x"+HexToString(address, 2)+")\r\n";
			return instring;
			}
	};

class CNFunctionDefinition : public BaseNode
	{

	public:
		CalcContext*	context;
		unsigned short  numArgs;
		BaseNode*       body;

		explicit CNFunctionDefinition(std::string &instring, BaseNode* bdy=0, unsigned short nArgs=0, CalcContext* cont=0)
			: BaseNode(instring), body(bdy), numArgs(nArgs), context(cont)
			{
			context->stackFrame=nArgs;
			}

		virtual double evaluate() const
			{
			return 0.0;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNFunctionDefinition";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			return instring;
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			std::vector<ADDRESS_TYPE>* myVector;
			ADDRESS_TYPE address;
			int   stackPtr;

			address=(ADDRESS_TYPE)(*outsize);
			myVector=&context->localFunctions[context->scriptNumber][this->name];
			(*myVector)[0]=(ADDRESS_TYPE)address;
			instring+="FUNCTION DEFINITION "+getStringFromStdString(&name)+"\r\n";
			if(body)
				{
				stackPtr=0;	
				context->stackFrame=numArgs;
				instring=body->listOutput(instring, outptr, outsize, &stackPtr);
				(*countStack)=0;
				}
			outOpcode(OPCODE_RETURN, outptr, outsize, countStack);
			outByte((unsigned char)numArgs, outptr, outsize, countStack);
			outEnd();
			instring+="RETURN "+formatStringFloat((double)numArgs, 0)+"\r\n";
			return instring;
			}
	};

class CNGlobalVariableReference : public CNMemoryReference
	{

	public:

		explicit CNGlobalVariableReference(std::string &instring, ADDRESS_TYPE varID=0, BaseNode* offs=0)
			: CNMemoryReference(instring, varID, offs, 0xE8, std::string("GLOBAL VAR REF"), OPCODE_MOVW)
			{

			}

		virtual System::String^ printString()
			{
			return "CNGlobalVariableReference";
			}

	};

class CNGlobalVariableByteReference : public CNMemoryReference
	{

	public:

		explicit CNGlobalVariableByteReference(std::string &instring, ADDRESS_TYPE varID=0, BaseNode* offs=0)
			: CNMemoryReference(instring, varID, offs, 0xE8, std::string("GLOBAL VAR REF"), OPCODE_MOVWB)
			{

			}

		virtual System::String^ printString()
			{
			return "CNGlobalVariableByteReference";
			}

	};

class CNDefineConstantReference : public BaseNode
	{

	protected:
		/// the constant value returned
		double	value;

	public:
		/// construct a constant calculation node from a value
		explicit CNDefineConstantReference(std::string& iname, double _value)
			: BaseNode(iname), value(_value)
			{

			}

		virtual double evaluate() const
			{
			return value;
			}

		virtual bool isConstant()
			{
			return true;
			}

		virtual System::String^ printString()
			{
			return "CNDefineConstantReference";
			}

		virtual bool isListOutputTerminal()
			{
			return true;
			}

		virtual unsigned char listOutputMode(unsigned char** argument, unsigned int* size, int* countStack)
			{
			float f;
			unsigned char* ptr;
			f=(float)value;
			ptr=(unsigned char*)&f;
			(**argument)=*ptr++;
			(*argument)++;
			(*size)++;
			(**argument)=*ptr++;
			(*argument)++;
			(*size)++;
			(**argument)=*ptr++;
			(*argument)++;
			(*size)++;
			(**argument)=*ptr++;
			(*argument)++;
			(*size)++;
			return MODE_LITERAL;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			instring+="DEFINE CONSTANT ("+formatStringFloat(value, 2)+")";
			return instring;
			}
	};

class CNString : public BaseNode
	{
	/// the constant value returned
	public:
		/// construct a constant calculation node from a value
		explicit CNString(std::string &instring=std::string(""))
			: BaseNode(instring)
			{

			}

		virtual double evaluate() const
			{
			return 0.0;
			}

		virtual bool isConstant()
			{
			return true;
			}

		virtual System::String^ printString()
			{
			return "CNString";
			}

		virtual bool isListOutputTerminal()
			{
			return true;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			wchar_t internalArray[2];
			int i;

			i=0;
			internalArray[0]=(wchar_t)this->name[i++];
			internalArray[1]=(wchar_t)'\0';
			while(((*outsize)<MAX_LIST_OUTPUT_SIZE)&&(internalArray[0]!='\0'))
				{
				instring+=gcnew System::String((wchar_t*)&internalArray[0]);
				if(internalArray[0]!=0x22)
					{
					outByte((unsigned char)internalArray[0], outptr, outsize, countStack);
					}
				internalArray[0]=(wchar_t)this->name[i++];
				}
			outByte('\0', outptr, outsize, countStack);
			return instring;
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			return instring;
			}

	};

class CNNewline : public CNString
	{

	public:
		/// construct a constant calculation node from a value
		explicit CNNewline(std::string &instring=std::string(""))
			: CNString(instring)
			{

			}

		virtual System::String^ printString()
			{
			return "CNNewline";
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			instring+="NEWLINE";
			outByte('\r', outptr, outsize, countStack);
			outByte('\n', outptr, outsize, countStack);
			outByte('\0', outptr, outsize, countStack);
			return instring;
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			return instring;
			}

	};

class CNUnary : public BaseNode
	{

	protected:

		/// calculation subtree
		BaseNode* 	left;

	public:
		explicit CNUnary(BaseNode* _node)
			: BaseNode(), left(_node)
			{

			}

		virtual double evaluate() const
			{
			return left->evaluate();
			}

		virtual bool isConstant()
			{
			return left->isConstant();
			}

		virtual System::String^ printString()
			{
			return "UNARY";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			unsigned int lsize;
			unsigned char* ptr;
			unsigned char mode;
			unsigned char bArray[16];

			if(left->isListOutputTerminal())
				{
				if((left->isConstant())&&(left->evaluate()==0.0))
					{
					outOpcode(OPCODE_CLR, outptr, outsize, countStack);
					outEnd();
					instring+="CLR W\r\n";
					}
				else
					{
					lsize=0;
					ptr=&bArray[0];
					mode=left->listOutputMode(&ptr, &lsize, countStack);
					if(left->movOpcode==OPCODE_MOVW)
						{
						if(outOpcodeOptimized(OPCODE_MOVW+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
							{
							instring+="MOV W, "+left->listOutput("", outptr, outsize, countStack)+"\r\n";
							}
						}
					else
						{
						if(outOpcodeOptimized(OPCODE_MOVWB+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
							{
							instring+="MOVB W, "+left->listOutput("", outptr, outsize, countStack)+"\r\n";
							}
						}
					}
				}
			else
				{
				instring=left->listOutput(instring, outptr, outsize, countStack);
				}
			outOpcode(this->getOpcode(), outptr, outsize, countStack);
			outEnd();
			instring+=this->printString()+" W\r\n";
			return instring;
			}
	};

/** Calculation node negating the value of the operand subtree. */
class CNNegate : public CNUnary
	{

	public:
		explicit CNNegate(BaseNode* _node)
			: CNUnary(_node)
			{
			}

		virtual double evaluate() const
			{
			return -left->evaluate();
			}

		virtual System::String^ printString()
			{
			return "NEG";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_NEG;
			}
	};

/** Calculation node negating the value of the operand subtree. */
class CNLogicalNot : public CNUnary
	{
	public:
		explicit CNLogicalNot(BaseNode* _node)
			: CNUnary(_node)
			{
			}

		virtual double evaluate() const
			{
			unsigned int l;
			l=(unsigned int)left->evaluate();
			if(!l)return 1.0;
			return 0.0;
			}

		virtual System::String^ printString()
			{
			return "LOGICAL NOT";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_NOT;
			}

	};

class CNPrintBaseFunction : public CNBinary
	{

	public:
		explicit CNPrintBaseFunction(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			return 0;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "PRINT BASE";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_PRINT_BASE;
			}

	};

class CNPrintDecimal : public CNBinary
	{

	public:
		explicit CNPrintDecimal(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual double evaluate() const
			{
			return 0.0;
			}

		virtual System::String^ printString()
			{
			return "PRINT DECIMAL";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_PRINT_DECIMAL;
			}

	};

/** Calculation node adding two operand nodes. */

class CNSubtract : public CNBinary
	{

	public:
		explicit CNSubtract(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			return left->evaluate()-right->evaluate();
			}

		virtual System::String^ printString()
			{
			return "SUB";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_SUB;
			}

	};

class CNBooleanEqu : public CNBinary
	{

	public:
		explicit CNBooleanEqu(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			return (double)(left->evaluate()==right->evaluate());
			}

		virtual System::String^ printString()
			{
			return "ISEQU";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_ISEQU;
			}

	};

class CNBooleanNeq : public CNBinary
	{

	public:
		explicit CNBooleanNeq(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}


		virtual double evaluate() const
			{
			return (double)(left->evaluate()!=right->evaluate());
			}

		virtual System::String^ printString()
			{
			return "ISNEQ";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_ISNEQ;
			}


	};

class CNBooleanGte : public CNBinary
	{

	public:
		explicit CNBooleanGte(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			return (double)(left->evaluate()>=right->evaluate());
			}

		virtual System::String^ printString()
			{
			return "ISGTE";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_ISGTE;
			}

	};

class CNBooleanLte : public CNBinary
	{

	public:
		explicit CNBooleanLte(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			return (double)(left->evaluate()<=right->evaluate());
			}

		virtual System::String^ printString()
			{
			return "ISLTE";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_ISLTE;
			}

	};

class CNBooleanGt : public CNBinary
	{

	public:
		explicit CNBooleanGt(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			return (double)(left->evaluate()>right->evaluate());
			}

		virtual System::String^ printString()
			{
			return "ISGT";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_ISGT;
			}
	};

class CNBooleanLt : public CNBinary
	{

	public:
		explicit CNBooleanLt(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			return (double)(left->evaluate()<right->evaluate());
			}

		virtual System::String^ printString()
			{
			return "ISLT";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_ISLT;
			}

	};

class CNBooleanAnd : public CNBinary
	{

	public:
		explicit CNBooleanAnd(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			return (double)((unsigned int)left->evaluate() && (unsigned int)right->evaluate());
			}

		virtual System::String^ printString()
			{
			return "AND";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_AND;
			}

	};

class CNBooleanOr : public CNBinary
	{

	public:
		explicit CNBooleanOr(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			return (double)((unsigned int)left->evaluate() || (unsigned int)right->evaluate());
			}

		virtual System::String^ printString()
			{
			return "OR";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_OR;
			}

	};

class CNBooleanXor : public CNBinary
	{

	public:
		explicit CNBooleanXor(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			return (double)((unsigned int)left->evaluate() ^ (unsigned int)right->evaluate());
			}

		virtual System::String^ printString()
			{
			return "XOR";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_XOR;
			}

	};

class CNLogicalAnd : public CNBinary
	{

	public:
		explicit CNLogicalAnd(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			return (double)((unsigned int)left->evaluate() & (unsigned int)right->evaluate());
			}

		virtual System::String^ printString()
			{
			return "AND";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_AND;
			}


	};

class CNLogicalOr : public CNBinary
	{

	public:
		explicit CNLogicalOr(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			return (double)((unsigned int)left->evaluate() | (unsigned int)right->evaluate());
			}

		virtual System::String^ printString()
			{
			return "OR";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_OR;
			}

	};

class CNLogicalXor : public CNBinary
	{

	public:
		explicit CNLogicalXor(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			return (double)((unsigned int)left->evaluate() ^ (unsigned int)right->evaluate());
			}

		virtual System::String^ printString()
			{
			return "XOR";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_XOR;
			}


	};

class CNMultiply : public CNBinary
	{

	public:
		explicit CNMultiply(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			return left->evaluate() * right->evaluate();
			}

		virtual System::String^ printString()
			{
			return "MUL";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_MUL;
			}

	};

class CNDivide : public CNBinary
	{

	public:
		explicit CNDivide(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{

			}

		virtual double evaluate() const
			{
			if(right->evaluate()!=0.0)return left->evaluate() / right->evaluate();
			else
				return 0.0;
			}

		virtual System::String^ printString()
			{
			return "DIV";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_DIV;
			}

	};

/** Calculation node calculating the remainder of an integer division of two
* operand nodes. */
class CNModulo : public CNBinary
	{   
	public:
		explicit CNModulo(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{
			}

		virtual double evaluate() const
			{
			return std::fmod(left->evaluate(), right->evaluate());
			}

		virtual System::String^ printString()
			{
			return "MOD";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_MOD;
			}
	};

/** Calculation node raising one operand to the power of the second. */
class CNPower : public CNBinary
	{

	public:
		explicit CNPower(BaseNode* _left, BaseNode* _right)
			: CNBinary(_left, _right)
			{
			}

		virtual double evaluate() const
			{
			return std::pow(left->evaluate(), right->evaluate());
			}

		virtual System::String^ printString()
			{
			return "POW";
			}

		virtual unsigned char getOpcode()
			{
			return OPCODE_POW;
			}
	};

class CNStatementContainer : public BaseNode
	{

	public:
		BaseNode* statementThis;

		explicit CNStatementContainer(std::string &inname=std::string(""), BaseNode* athis=0)
			: BaseNode(inname), statementThis(athis)
			{
			}

		virtual double evaluate() const
			{
			return 0;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNStatementContainer";
			}

		virtual bool isListOutputTerminal()
			{
			return true;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			if((*outsize)< MAX_LIST_OUTPUT_SIZE)
				{
				if(statementThis)
					{
					instring=statementThis->listOutput(instring, outptr, outsize, countStack);
					}
				}
			return instring;
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			if((*outsize)< MAX_LIST_OUTPUT_SIZE)
				{	
				if(statementThis)
					{
					instring=statementThis->listOutputHeader(instring, outptr, outsize, countStack);
					}
				}
			return instring;
			}
	};

class CNStatement : public CNStatementContainer
	{

	public:
		explicit CNStatement(BaseNode* athis=0)
			: CNStatementContainer(std::string(""), athis)
			{
			}
		virtual System::String^ printString()
			{
			return "CNStatement";
			}
	};

class CNHeaderStatement : public CNStatementContainer
	{

	public:
		CalcContext* context;

		explicit CNHeaderStatement(std::string &inname=std::string(""), BaseNode* athis=0, CalcContext* cont=0)
			: CNStatementContainer(inname, athis), context(cont)
			{
			}

		virtual System::String^ printString()
			{
			return "CNHeaderStatement";
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			std::vector<double>* myVector;
			unsigned char offset;
			unsigned char size;
			unsigned long l;

			if(statementThis)
				{
				myVector=&context->headerObjects[this->name];
				offset=(unsigned char)(*myVector)[0];
				size=(unsigned char)(*myVector)[1];
				if((size==1)||(size==2)||(size==4))
					{
					l=(unsigned long)statementThis->evaluate();
					instring+="HEADER OBJECT \""+getStringFromStdString(this->getReferenceName())+"\" = "+formatStringFloat((double)l, 0)+"\r\n";
					outOpcode(OPCODE_HEADER_OFFSET_WRITE, outptr, outsize, countStack);
					outByte(offset, outptr, outsize, countStack);
					outByte(size, outptr, outsize, countStack);
					if(size==1)
						{
						outByte((unsigned char)l & 0xFF, outptr, outsize, countStack);
						}
					else
						if(size==2)
							{
							outByte((unsigned char)l & 0xFF, outptr, outsize, countStack);
							outByte((unsigned char)(l>>8) & 0xFF, outptr, outsize, countStack);
							}
						else
							if(size==4)
								{
								outByte((unsigned char)l & 0xFF, outptr, outsize, countStack);
								outByte((unsigned char)(l>>8)  & 0xFF, outptr, outsize, countStack);
								outByte((unsigned char)(l>>16) & 0xFF, outptr, outsize, countStack);
								outByte((unsigned char)(l>>24) & 0xFF, outptr, outsize, countStack);
								}
							outEnd();				
					}
				}
			return instring;
			}
	};

class CNBuiltInExpressionCommand : public BaseNode
	{

	public:
		BaseNode*		cmdExpression;
		unsigned char	opcode;

		explicit CNBuiltInExpressionCommand(std::string &inname=std::string(""), unsigned char opc=0, BaseNode* expr=0, unsigned char tp=NORMAL_TYPE)
			: BaseNode(inname), opcode(opc), cmdExpression(expr)
			{
			this->type=tp;
			}

		virtual double evaluate() const
			{
			return 0;
			}

		virtual bool isConstant()
			{
			return true;
			}

		virtual System::String^ printString()
			{
			return "CNBuiltInExpressionCommand";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			unsigned int   lsize;
			unsigned char* ptr;
			unsigned char  mode;
			unsigned char  bArray[16];

			if(cmdExpression)
				{
				if(cmdExpression->isListOutputTerminal())
					{
					if((cmdExpression->isConstant())&&(cmdExpression->evaluate()==0))
						{
						outOpcode(OPCODE_CLR, outptr, outsize, countStack);
						outEnd();
						instring+="CLR W\r\n";
						}
					else
						{
						lsize=0;
						ptr=&bArray[0];
						mode=cmdExpression->listOutputMode(&ptr, &lsize, countStack);
						if(cmdExpression->movOpcode==OPCODE_MOVW)
							{
							if(outOpcodeOptimized(OPCODE_MOVW+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
								{
								instring+="MOV W, "+cmdExpression->listOutput("", outptr, outsize, countStack)+"\r\n";
								}
							}
						else
							{
							if(outOpcodeOptimized(OPCODE_MOVWB+mode, outptr, outsize, countStack, (unsigned char*)&bArray[0], lsize))
								{
								instring+="MOVB W, "+cmdExpression->listOutput("", outptr, outsize, countStack)+"\r\n";
								}
							}
						}
					}
				else
					{
					instring=cmdExpression->listOutput(instring, outptr, outsize, countStack);
					}
				}

			if(this->opcode!=OPCODE_NOP)
				{
				outOpcode(this->opcode, outptr, outsize, countStack);
				outEnd();
				instring+=getStringFromStdString(&this->name)+" W\r\n";
				}
			return instring;
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			return instring;
			}
	};

class CNSleepCommand : public CNBuiltInExpressionCommand
	{

	public:

		explicit CNSleepCommand(BaseNode* expr=0)
			: CNBuiltInExpressionCommand(std::string("SLEEP"), OPCODE_SLEEP, expr)
			{

			}

		virtual System::String^ printString()
			{
			return "CNSleepCommand";
			}

	};

class CNPrintChar : public CNBuiltInExpressionCommand
	{

	public:

		explicit CNPrintChar(BaseNode* expr=0)
			: CNBuiltInExpressionCommand(std::string("PRINT CHAR"), OPCODE_PRINT_CHAR, expr)
			{

			}

		virtual System::String^ printString()
			{
			return "CNPrintChar";
			}

	};

class CNOpenPipeCommand : public CNBuiltInExpressionCommand
	{

	public:

		explicit CNOpenPipeCommand(BaseNode* expr=0)
			: CNBuiltInExpressionCommand(std::string("OPEN PIPE"), OPCODE_OPEN_PIPE, expr)
			{

			}

		virtual System::String^ printString()
			{
			return "CNOpenPipeCommand";
			}

	};

class CNClosePipeCommand : public CNBuiltInExpressionCommand
	{

	public:

		explicit CNClosePipeCommand(BaseNode* expr=0)
			: CNBuiltInExpressionCommand(std::string("CLOSE PIPE"), OPCODE_CLOSE_PIPE, expr)
			{

			}

		virtual System::String^ printString()
			{
			return "CNClosePipeCommand";
			}

	};

class CNBuiltInTimeExpressionCommand : public BaseNode
	{

	public:
		BaseNode*		timeArgument;
		unsigned char	opcode;

		explicit CNBuiltInTimeExpressionCommand(std::string &inname=std::string(""), unsigned char opc=0, BaseNode* expr=0)
			: BaseNode(inname), opcode(opc), timeArgument(expr)
			{
			this->type=TIME_TYPE;
			}

		virtual double evaluate() const
			{
			return 0;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNBuiltInTimeExpressionCommand";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			unsigned int i;

			if(timeArgument)
				{
				instring=timeArgument->listOutput(instring, outptr, outsize, countStack);
				}
			else
				{
				i=5;
				outOpcode(OPCODE_CLEARFTIMEFLAGS, outptr, outsize, countStack);
				outByte((unsigned char)i, outptr, outsize, countStack);
				outEnd();
				instring+="CLR TIME ARGS, 0x"+HexToString((unsigned long)i, 1)+"\r\n";
				}
			if(this->opcode!=OPCODE_NOP)
				{
				outOpcode(this->opcode, outptr, outsize, countStack);
				outEnd();
				instring+=getStringFromStdString(&this->name);
				instring+="\r\n";
				}
			return instring;
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			return instring;
			}
	};

class CNSleepUntilCommand : public CNBuiltInTimeExpressionCommand
	{

	public:

		explicit CNSleepUntilCommand(BaseNode* expr=0)
			: CNBuiltInTimeExpressionCommand(std::string("SLEEP UNTIL [TIME]"), OPCODE_SLEEPUNTIL, expr)
			{

			}

		virtual System::String^ printString()
			{
			return "CNSleepUntilCommand";
			}
	};

class CNTimeUntilCommand : public CNBuiltInTimeExpressionCommand
	{

	public:

		explicit CNTimeUntilCommand(BaseNode* expr=0)
			: CNBuiltInTimeExpressionCommand(std::string("TIME UNTIL W, [TIME]"), OPCODE_TIMEUNTIL, expr)
			{

			}

		virtual System::String^ printString()
			{
			return "CNTimeUntilCommand";
			}
	};

class CNTimeCommand : public CNBuiltInTimeExpressionCommand
	{

	public:

		explicit CNTimeCommand(BaseNode* expr=0)
			: CNBuiltInTimeExpressionCommand(std::string("NOP"), OPCODE_NOP, expr)
			{

			}

		virtual System::String^ printString()
			{
			return "CNTimeCommand";
			}
	};

class CNResetCommand : public CNBuiltInExpressionCommand
	{

	public:

		explicit CNResetCommand()
			: CNBuiltInExpressionCommand(std::string("RESET"), OPCODE_RESET, nullptr)
			{

			}

		virtual System::String^ printString()
			{
			return "CNResetCommand";
			}

	};

class CNPrecisionCommand : public CNBuiltInExpressionCommand
	{

	public:

		explicit CNPrecisionCommand(BaseNode* expr=0)
			: CNBuiltInExpressionCommand(std::string("PRECISION"), OPCODE_PREC, expr)
			{

			}

		virtual System::String^ printString()
			{
			return "CNPrecisionCommand";
			}

	};

class CNPrintArgumentExpression : public CNBuiltInExpressionCommand
	{

	public:

		explicit CNPrintArgumentExpression(BaseNode* expr=0)
			: CNBuiltInExpressionCommand(std::string("PRINT"), OPCODE_PRINT_W, expr)
			{
			}

		virtual System::String^ printString()
			{
			return "CNPrintArgumentExpression";
			}

	};

class CNPrintBuiltInFunction : public CNBuiltInExpressionCommand
	{

	public:

		explicit CNPrintBuiltInFunction(BaseNode* expr=0)
			: CNBuiltInExpressionCommand(std::string("PRINT FUNCTION "), OPCODE_PRINTF_W, expr)
			{
			}

		virtual System::String^ printString()
			{
			return "CNPrintArgumentExpression";
			}

	};

class CNPrintArgumentString : public BaseNode
	{

	public:
		BaseNode*		printStringObject;

		explicit CNPrintArgumentString(BaseNode* str=0)
			: BaseNode(), printStringObject(str)
			{
			}

		virtual double evaluate() const
			{
			return 0;
			}

		virtual bool isConstant()
			{
			return true;
			}

		virtual System::String^ printString()
			{
			return "CNPrintArgumentString";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			if(printStringObject)
				{
				outOpcode(OPCODE_PRINT_STRING, outptr, outsize, countStack);
				outEnd();
				instring+="PRINT "+printStringObject->listOutput("", outptr, outsize, countStack)+"\r\n";
				}
			return instring;
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			return instring;
			}
	};

class CNGenericFileCommand : public BaseNode
	{
	public:
		BaseNode*		printStringObject;

		explicit CNGenericFileCommand(BaseNode* str=0, std::string &inname=std::string(""), unsigned char opc=0)
			: BaseNode(inname, opc), printStringObject(str)
			{
			}

		virtual double evaluate() const
			{
			return 0;
			}

		virtual bool isConstant()
			{
			return true;
			}

		virtual System::String^ printString()
			{
			return "CNGenericFileCommand";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			if(printStringObject)
				{
				outOpcode(this->movOpcode, outptr, outsize, countStack);
				outEnd();
				instring+=getStringFromStdString(&this->name)+printStringObject->listOutput("", outptr, outsize, countStack);
				outOpcode(this->movOpcode, outptr, outsize, countStack);
				outEnd();
				}
			return instring;
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			return instring;
			}
	};

class CNSerialCommand : public CNGenericFileCommand
	{
	public:
		BaseNode*		printStringObject;

		explicit CNSerialCommand(BaseNode* str=0)
			: CNGenericFileCommand(str, std::string("SERIAL\r\n"), OPCODE_SERIAL)
			{
			}

		virtual System::String^ printString()
			{
			return "CNSerial";
			}
	};

class CNMatchNMEACommand : public CNGenericFileCommand
	{
	public:
		BaseNode*		printStringObject;

		explicit CNMatchNMEACommand(BaseNode* str=0)
			: CNGenericFileCommand(str, std::string("MATCH NMEA\r\n"), OPCODE_MATCH_NMEA)
			{
			}

		virtual System::String^ printString()
			{
			return "CNMatchNMEACommand";
			}
	};

class CNNMEACommand : public CNGenericFileCommand
	{
	public:
		BaseNode*		printStringObject;

		explicit CNNMEACommand(BaseNode* str=0)
			: CNGenericFileCommand(str, std::string("NMEA\r\n"), OPCODE_NMEA)
			{
			}

		virtual System::String^ printString()
			{
			return "CNNMEACommand";
			}
	};

class CNOpenFileCommand : public CNGenericFileCommand
	{
	public:
		BaseNode*		printStringObject;

		explicit CNOpenFileCommand(BaseNode* str=0)
			: CNGenericFileCommand(str, std::string("OPEN FILE\r\n"), OPCODE_OPENFILE)
			{
			}

		virtual System::String^ printString()
			{
			return "CNOpenFileCommand";
			}
	};

class CNClearFileCommand : public CNGenericFileCommand
	{
	public:
		BaseNode*		printStringObject;

		explicit CNClearFileCommand(BaseNode* str=0)
			: CNGenericFileCommand(str, std::string("CLEAR FILE\r\n"), OPCODE_CLEARFILE)
			{
			}

		virtual System::String^ printString()
			{
			return "CNClearFileCommand";
			}
	};

class CNPrintList : public BaseNode
	{

	public:
		BaseNode*		statementThis;
		BaseNode*		statementNext;

		explicit CNPrintList(BaseNode* athis=0, BaseNode* anext=0)
			: BaseNode(), statementThis(athis), statementNext(anext)
			{
			}

		virtual double evaluate() const
			{
			return 0;
			}

		virtual bool isConstant()
			{
			return true;
			}

		virtual System::String^ printString()
			{
			return "CNPrintList";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			if(statementThis)
				{
				instring=statementThis->listOutput(instring, outptr, outsize, countStack);
				}

			if(statementNext)
				{
				instring=statementNext->listOutput(instring, outptr, outsize, countStack);
				}
			return instring;
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			if(statementThis)
				{
				instring=statementThis->listOutputHeader(instring, outptr, outsize, countStack);
				}

			if(statementNext)
				{
				instring=statementNext->listOutputHeader(instring, outptr, outsize, countStack);
				}
			return instring;
			}
	};

class CNLinkedList : public BaseNode
	{

	public:
		BaseNode*		statementThis;
		BaseNode*		statementNext;

		explicit CNLinkedList(BaseNode* athis=0, BaseNode* anext=0)
			: BaseNode(), statementThis(athis), statementNext(anext)
			{
			}

		virtual double evaluate() const
			{
			return 0;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNLinkedList";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			if(statementThis)
				{
				instring=statementThis->listOutput(instring, outptr, outsize, countStack);
				}

			if(statementNext)
				{
				instring=statementNext->listOutput(instring, outptr, outsize, countStack);
				}

			return instring;
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			if(statementThis)
				{
				instring=statementThis->listOutputHeader(instring, outptr, outsize, countStack);
				}

			if(statementNext)
				{
				instring=statementNext->listOutputHeader(instring, outptr, outsize, countStack);
				}
			return instring;
			}
	};

class CNStatementList : public CNLinkedList
	{

	public:

		explicit CNStatementList(BaseNode* athis=0, BaseNode* anext=0)
			: CNLinkedList(athis, anext)
			{
			}

		virtual System::String^ printString()
			{
			return "CNStatementList";
			}
	};

class CNScriptList : public CNLinkedList
	{

	public:

		explicit CNScriptList(BaseNode* athis=0, BaseNode* anext=0)
			: CNLinkedList(athis, anext)
			{
			}

		virtual System::String^ printString()
			{
			return "CNStatementList";
			}
	};

class CNHeaderStatementList : public CNLinkedList
	{

	public:

		explicit CNHeaderStatementList(BaseNode* athis=0, BaseNode* anext=0)
			: CNLinkedList(athis, anext)
			{
			}

		virtual System::String^ printString()
			{
			return "CNHeaderStatementList";
			}
	};

class CNHeader : public BaseNode
	{

	public:
		BaseNode*		statementList;

		explicit CNHeader(std::string &inname=std::string(""), BaseNode* stmtList=0)
			: BaseNode(inname), statementList(stmtList)
			{
			}

		virtual double evaluate() const
			{
			return 0;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNHeader";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			return instring;
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			instring+="HEADER \""+getStringFromStdString(this->getReferenceName())+"\"\r\n";
			if(statementList)
				{
				instring+=statementList->listOutputHeader("", outptr, outsize, countStack);
				}
			return instring;
			}

	};

class CNScript : public BaseNode
	{

	public:
		BaseNode*		statementList;

		explicit CNScript(std::string &inname=std::string(""), BaseNode* stmtList=0)
			: BaseNode(inname), statementList(stmtList)
			{
			}

		virtual double evaluate() const
			{
			return 0;
			}

		virtual bool isConstant()
			{
			return false;
			}

		virtual System::String^ printString()
			{
			return "CNScript";
			}

		virtual bool isListOutputTerminal()
			{
			return false;
			}

		virtual System::String^ listOutput(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			if(statementList)
				{
				instring=statementList->listOutput(instring, outptr, outsize, countStack);
				}
			outOpcode(OPCODE_HALT, outptr, outsize, countStack);
			outEnd();
			instring+="HALT\r\n";
			return instring;
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			unsigned char* ptr;
			unsigned int   hsize;
			System::String^ tstring;

			outOpcode(OPCODE_BRA, outptr, outsize, countStack);
			ptr=(*outptr);
			(*outptr)+=2;
			(*outsize)+=2;
			hsize=(*outsize);
			if(statementList)
				{		
				tstring=statementList->listOutputHeader(instring, outptr, outsize, countStack);
				}
			else
				{
				tstring=instring;
				}
			instring="SCRIPT \""+getStringFromStdString(this->getReferenceName())+"\"\r\n";
			hsize=(*outsize)-hsize;
			instring+="BRA +"+formatStringFloat((double)hsize, 0)+"\r\n";
			instring+=tstring;
			*ptr++=(unsigned char)(hsize>>8);
			*ptr++=(unsigned char)(hsize);
			return instring;
			}
	};

class CNTotal : public CNLinkedList
	{

	public:

		explicit CNTotal(BaseNode* athis=0, BaseNode* anext=0)
			: CNLinkedList(athis, anext)
			{
			}

		virtual System::String^ printString()
			{
			return "CNTotal";
			}

		virtual System::String^ listOutputHeader(System::String^ instring, unsigned char** outptr, unsigned int* outsize, int* countStack)
			{
			instring+="TOTAL\r\n";
			if(statementThis)
				{
				instring+=statementThis->listOutputHeader("", outptr, outsize, countStack);
				}

			instring+="BODY\r\n";
			if(statementNext)
				{
				instring+=statementNext->listOutputHeader("", outptr, outsize, countStack);
				}
			return instring;
			}
	};

/** Calculator context used to save the parsed expressions. This context is
* passed along to the example::Driver class and fill during parsing via bison
* actions. */
#endif // EXPRESSION_H
