#pragma once

//-------------------------------------------------------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------BEGIN CUT AND PASTE BLOCK-----------------------------------------------------------------------------------

/*

USB Data Logger PC Host Program,

by Mauro Grassi, September, October, November 2010.

Version History:

1.00:  open/read/write/close file RPC handlers...
1.90:  incorporated arithmetic expression parser and lexical analyser using Bison/Flex...
1.98:  support for logging expressions (arithmetic)...
1.99:  changed grammar...
2.00:  with command grammar...

Changes to Hardware, to PCB versions here...

2.20:  PCB version with keys...
2.22:  ...
2.30:  automatic connect and disconnect...
2.42:  ...
2.50:  much work on script compiler...
2.52:  ...
2.60:  compile output, compile header output provisional...
2.64:  ...
2.70:  many improvements to the script compiler (with better error messages, and object code output)...
2.80:  with local stack references and stack frames for functions...
2.90:  virtual machine, with virtual memory is running...
3.00:  working POP indirect and mov W, [W] indirections... Also working with Global Function definitions!
added  single expression built in command infrastructure (eg, PRINT, SLEEP, PRECISION commands)...
added  header body and header statements, etc...
3.10:  modified listOutputHeader for function definition to take into account reset vector... added output list size restriction...
3.20:  added file output and input support...
3.90:  with mutexes for the USB functions, moved global functions to a separate file...
3.92:  ...
3.96:  address space for VM has been expanded!
4.00:  integrated PC host VM simulation Environment with file IO...
4.10:  performance improvements to device, read only caches...
4.20:  improvements...
4.30:  built in print functions...
4.40:  ...
4.50:  global inbuilt functions development infrastructure in place...
4.80:  ...
4.84:  added file transfer facility for ease of use...
4.90:  file transfer with most features...
4.92:  added address of operator for local variables...
5.00:  ...
5.10:  performance improvements...
5.12:  adds CRC checking on PC host for VM restore and save (already available on device)...
5.20:  Changed the device VID and PID to the one sublicenced to me (Mauro Grassi) by Microchip...
5.24:  ...
5.30:  Support for meta opcodes for VM Environment...
5.40:  Memory Card Information...
5.50:  Improvements to the stack referencing, countstack handles call of local functions...
5.60:  Automatic Frequency Scaling for capture system (device)...
5.70:  Counters on Capture ...
5.72:  More maths functions support, recycled from the DAB+ Tuner project...
5.80:  ...
5.90:  Better global function support, etc...
5.94:  The popindb function was using the indirect addressing alignment of the popind function, now fixed!
5.96:  Improvements to the LED system and to the USB system interface...
5.98:  Sleep Until Command Support... Time Until Support, LITI_ARG_TYPE for greater efficiency...
6.00:  Simple change to allow global functions to detect default arguments through the vm->temp field...
6.10:  DMA improvements to the firmware...
6.12:  ...
6.20:  pipes support...
6.30:  SLEEP support...
6.40:  SLEEP support for the device when no memory card is present...
6.60:  ...
6.90:  improvements...
6.98:  added internal global function calls through USB and USB serial pipe...
7.00a: captive device with serial USB pipe...
7.00b: added openPipes and closePipes opcodes and getPipes global function...
7.10:  system logging cache...
7.20a: hardwarestate on device...
7.24:  ...
7.30:  new hardware descriptor logic... added OPCODE_HEADER_OFFSET_WRITE and changes to the CNHeaderStatement class...
7.40:  ...
7.52:  with Global memory space infrastructure with offsets into VM...
7.60:  fully integrated one wire module...
7.64:  added NMEA support for print command and myultoabase commands for printing to other bases...
7.70:  added string variables support...
7.82:  added support for SPI sensors to the firmware...
7.84:  better grammar for address of operator...
7.90:  many improvements to the layout...
7.92:  ...
7.94:  ...
7.96:  new menus...
8.00a: many new menus and improvements...
8.10:  many improvements, added CACHE_APPEND_ALWAYS option and VMEnvironmentSuperTask, syncSettings, etc...
8.30:  ...
8.40:  banking optimizer turned off in the device...
8.46:  ...
8.50:  ...
8.60:  ...
8.90:  ...
9.00:  New Compiler outOpcode, outByte, outBytes functions to allow optimizations like copy propagation, etc...
9.02:  DS Limit for string variables...
9.10:
9.20:  using file buffering!
9.30:  no sleep if host is alive...
9.50:  incorporated bootloader...

9.80:  many improvements... compiler fixes for list terminals in the CNWhile and CNConditional conditionals...
added Global Variables help, and new global variables system... fixed iArg[2] not incrementing...

9.82:  you can now click on the help items to insert them into the source code editor...
9.84:  added nmea and matchnmea commands...
9.88:  improved GPS system and functions...

9.90:	Bootloader fixes intermittent switching lag... Many other improvements to the PC host program...

Much better serial bootloader, with synchronisation!
Secondary bootloader (over UART) can update the USB bootloader, if necessary...
Full check box functionality in PC host, also full help information in PC host...

Compiler & VM engine supports automatic variable sizing for the global variables...
New globals & globals emulated on the PC host (as far as possible)...

Some new interface features, like wide editor window, enable\disable confirm individual files delete...

First Release Version, as at 24 January 2011. By Mauro Grassi.

*/					  

// Includes

#include <windows.h>
#include <errno.h>
#include <stdio.h>
#include "usb.h"
#include "driver.h"
#include "expression.h"
#include "common.h"
#include <streambuf>
#include <iostream>
#include "global.h"
#include "opcodes.h"
#include "vm.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;
using namespace System::IO;
using namespace System::Text;
using namespace System::Runtime::InteropServices; //Need this to support "unmanaged" code.
using namespace System::Threading;
using namespace System::Diagnostics;
using namespace std;


// Global Variables

VM_RETURN_TYPE VMEnvironmentSuperTask(VIRTUAL_MACHINE_ENVIRONMENT* ven, std::string &instring);

int						globalCancel=0;
unsigned char			Connection_Status;
usb_dev_handle			*MyLibusbDeviceHandle=NULL;
int						totalUSBBytesWrite;
int						totalUSBBytesRead;
int						totalUSBWrites;
int						totalUSBReads;
CARD_INFO				cardInfo;
CARD_INFO				lastInfo;
float					deviceFirmwareVersion=0;
float					serialBootLoaderVersion=0;
unsigned long			USBBootLoaderVersion=0;
DATA_LOGGER_CONTAINER	lastUDL;
DATA_LOGGER_CONTAINER	thisUDL;
DATA_LOGGER_CONTAINER	localUDL;
VIRTUAL_MACHINE			vm[MAX_NUM_VM];
bool					guiStopped=false;
int						bootLoaderStatus;
unsigned int			timerCounter1=0;
unsigned int			timerCounter2=0;
unsigned int		    timerCounter3=0;
ADDRESS_TYPE			memoryOffset[MAX_NUM_VM+1];
unsigned char			oldValues[MAX_NUM_VM+1][MEMORY_NUM_COLS][MEMORY_NUM_ROWS];
unsigned int			runMode;
unsigned int			deviceSelected=0;
unsigned char			ProgramMemory[PROGRAM_ADDRESS_TOP];
unsigned char			ProgramMemoryVerify[PROGRAM_ADDRESS_TOP];
unsigned char			ConfigMemory[MAX_CONFIG_MEMORY];
unsigned char			BootLoaderMemory[BOOTLOADER_SIZE_BYTES];
LOCAL_SETTINGS			localSettings;
unsigned int			forceUpdate=0;
unsigned char		    firstPor;
static					HANDLE MyDevice=INVALID_HANDLE_VALUE;
static					COMMTIMEOUTS timeouts={ 0 };
static int				baudRt=PC_BOOT_BAUD_QUICK;
static unsigned int     SerialPortNumber;
static bool				SerialPortConnected;
static bool				SerialPortConnectedOld;
unsigned char           inHelpWindow=0;
static int				wideeditorwindow=-1;
unsigned char			serialUSBStatus=0;

std::map<std::string, unsigned int> currentTreeDir;
std::map<std::string, unsigned int> currentTreePCDir;

//-------------------------------------------------------END CUT AND PASTE BLOCK-------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------

[UnmanagedFunctionPointer(System::Runtime::InteropServices::CallingConvention::Cdecl)]
public delegate void CallBackDelegate(void);
NativeToManaged globalIdleCompileTaskFunctionPointer=nullptr;

namespace SimpleLibusbDemo
	{

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace System::Threading;
	using namespace example;
	/// <summary>
	/// Summary for Form1
	///
	/// WARNING: If you change the name of this class, you will need to change the
	/// 'Resource File Name' property for the managed resource compiler tool
	/// associated with all .resx files this class depends on. Otherwise,
	/// the designers will not be able to interact properly with localized
	/// resources associated with this form.
	/// </summary>

	public ref class Form1: public System::Windows::Forms::Form
		{

		private:
			System::String^ SerialPortName;

#if(USE_MUTEX_USB)
			static Semaphore^ semaphoreUSB = gcnew Semaphore(1, 1);
#endif

#if(USE_MUTEX_TRANSFERS)
			static Semaphore^ semaphoreTransfers = gcnew Semaphore(1, 1);
#endif

			static System::Windows::Forms::TreeNode^ currentTreeNode = gcnew System::Windows::Forms::TreeNode;
			static System::Windows::Forms::TreeNode^ currentTopNode  = gcnew System::Windows::Forms::TreeNode;

			static System::Windows::Forms::TreeNode^ currentScriptNode = gcnew System::Windows::Forms::TreeNode;
			static System::String^ currentTreeNodePath;
			static System::Windows::Forms::TreeNode^ currentTreePCNode;
			static System::String^ currentTreePCNodePath;

		private:

		private: System::Windows::Forms::CheckBox^ checkBoxBatteryProtection;
		private: System::Windows::Forms::TreeView^ treeViewScripts;


		private: System::Windows::Forms::NumericUpDown^ numericUpDownBatteryProtect;
		private: System::Windows::Forms::CheckBox^ checkBoxSystemLogging;
		private: System::Windows::Forms::TreeView^ treeViewPCScripts;

		private:
		private: DataTable^ LocalMemoryTable;
		private: System::Windows::Forms::TreeView^ treeViewPCFiles;
		private: System::Windows::Forms::CheckBox^ checkBoxShowMemory;
		private: System::Windows::Forms::TextBox^ textBoxInput1;
		private: System::Windows::Forms::StatusStrip^ statusStrip1;
		public: System::Windows::Forms::ToolStripProgressBar^  progressBar1;
		private: 

		private: System::Windows::Forms::ToolStripStatusLabel^  labelUSBTraffic;
		private: System::Windows::Forms::ToolStripStatusLabel^  labelUSB;
		private: System::Windows::Forms::ToolStripStatusLabel^  labelTimeDevice;
		private: System::Windows::Forms::ToolStripStatusLabel^  labelTimeFromDeviceX;
		private: System::Windows::Forms::ToolStripStatusLabel^  labelLastTimeSynced;
		private: System::Windows::Forms::ToolStripStatusLabel^  labelLastTime;
		private: System::Windows::Forms::ToolStripStatusLabel^  labelVoltage;
		private: System::Windows::Forms::ToolStripStatusLabel^  labelVDD;
		private: System::Windows::Forms::MenuStrip^  menuStrip1;
		private: System::Windows::Forms::ToolStripMenuItem^  toolStripMenuItem1;
		private: System::Windows::Forms::ToolStripMenuItem^  FileAdd;
		private: System::Windows::Forms::ToolStripMenuItem^  FileCompile;
		private: System::Windows::Forms::ToolStripMenuItem^  FileCompileAndSend;
		private: System::Windows::Forms::ToolStripMenuItem^  FileClose;
		private: System::Drawing::Point^ cursorPosition;



		private: System::Windows::Forms::ToolStripMenuItem^  runToolStripMenuItem;

		private: System::Windows::Forms::ToolStripMenuItem^  resetToolStripMenuItem;
		private: System::Windows::Forms::ToolStripMenuItem^  runToolStripMenuItem1;
		private: System::Windows::Forms::ToolStripMenuItem^  stopToolStripMenuItem;

		private: System::Windows::Forms::ToolStripMenuItem^  memoryToolStripMenuItem;
		private: System::Windows::Forms::ToolStripMenuItem^  localToolStripMenuItem;

		private: System::Windows::Forms::ToolStripMenuItem^  timeToolStripMenuItem;

		private: System::Windows::Forms::ToolStripMenuItem^  memoryCardToolStripMenuItem;
		private: System::Windows::Forms::ToolStripMenuItem^  getInfoToolStripMenuItem;
		private: System::Windows::Forms::ToolStripMenuItem^  FileOpen;
		private: System::Windows::Forms::ToolStripMenuItem^  FileSave;
		private: System::Windows::Forms::ToolStripMenuItem^  FileSaveAs;
		private: System::Windows::Forms::Button^  clearLog;

		private: System::String^ lastOpenedFile;
		private: System::String^ titleBase;
		private: System::Windows::Forms::ToolStripMenuItem^  DeviceMenu;
		private: System::Windows::Forms::ToolStripMenuItem^  restoreDefaultsToolStripMenuItem;
		private: System::Windows::Forms::ToolStripMenuItem^  DeviceSaveSettings;
		private: System::Windows::Forms::ToolStripMenuItem^  DeviceRestoreSettings;


		private: System::Windows::Forms::ToolStripMenuItem^  FileExit;
		private: System::Windows::Forms::ToolStripMenuItem^  FileReset;
		private: System::Windows::Forms::ToolStripMenuItem^  TimeSyncDeviceTime;
		public: System::Windows::Forms::DataGridView^  dataGridView1;
		private: System::Windows::Forms::NumericUpDown^  numericUpDownMemoryOffset;
		private: System::Windows::Forms::TextBox^  textBoxDebug;
		private: System::Windows::Forms::Label^  labelMemoryAt;
		private: System::Windows::Forms::Label^  labelMemory;
		private: System::Windows::Forms::ToolStripMenuItem^  clearSystemLogToolStripMenuItem;
		private: System::Windows::Forms::Timer^  timer2;
		private: System::Windows::Forms::Button^  buttonClearConsole;
		private: System::Windows::Forms::Button^  buttonRunVM;


		private: System::Windows::Forms::Button^  buttonStop;
		private: System::Windows::Forms::Button^  buttonStep;
		private: System::Windows::Forms::Button^  buttonReset;
		private: System::Windows::Forms::GroupBox^  groupBoxSettings;
		private: System::Windows::Forms::Label^  label1;
		private: System::Windows::Forms::Label^  label2;
		private: System::Windows::Forms::ToolStripMenuItem^  runStopToolStripMenuItem;
		private: System::Windows::Forms::ToolStripMenuItem^  aboutToolStripMenuItem;
		private: System::Windows::Forms::ToolStripMenuItem^  uSBDataLoggerToolStripMenuItem;
		private: System::Windows::Forms::ToolStripMenuItem^  newFileToolStripMenu;
		private: System::Windows::Forms::ToolStripMenuItem^  runDevicetoolStripMenuItem;

		private: System::Windows::Forms::ToolStripMenuItem^  toolStripMenuItem5;
		private: System::Windows::Forms::ToolStripMenuItem^  toolStripMenuItem6;
		private: System::Windows::Forms::ToolStripMenuItem^  toolStripMenuItem7;
		private: System::Windows::Forms::ToolStripMenuItem^  toolStripMenuItem8;
		private: System::Windows::Forms::ToolStripMenuItem^  stepToolStripMenuItem;
		private: System::Windows::Forms::Button^  buttonReadMemory;
		private: System::Windows::Forms::ToolStripMenuItem^  toolStripMenuItem2;
		private: System::Windows::Forms::ToolStripMenuItem^  restoreHostDefaultsToolStripMenuItem1;
		private: System::Windows::Forms::ToolStripMenuItem^  saveSettingsToolStripMenuItem;
		private: System::Windows::Forms::ToolStripMenuItem^  restoreSettingsToolStripMenuItem;
		private: System::Windows::Forms::ToolStripMenuItem^  reconnectToolStripMenuItem;
		private: System::Windows::Forms::TreeView^  treeViewHelp;
		private: System::Windows::Forms::Label^  labelHelp;
		private: System::Windows::Forms::ToolStripMenuItem^  showSystemLogToolStripMenuItem;
		private: System::Windows::Forms::ToolStripMenuItem^  newSystemLogToolStripMenuItem;
		private: System::Windows::Forms::ToolStripMenuItem^  toolStripMenuItem3;
		private: System::Windows::Forms::ToolStripMenuItem^  fontSizeUpToolStripMenuItem;
		private: System::Windows::Forms::ToolStripMenuItem^  fontSizeDownToolStripMenuItem;
		private: System::Windows::Forms::CheckBox^  checkBoxOptimize;
		private: System::Windows::Forms::NumericUpDown^  numericUpDownTimeSpeed;
		private: System::Windows::Forms::GroupBox^  groupBoxHost;

		private: System::Windows::Forms::ToolStripMenuItem^  simulateSpeedResetToolStripMenuItem;
		private: System::Windows::Forms::CheckBox^  checkBoxSpeed;
		private: System::Windows::Forms::CheckBox^  checkBoxSystemLogUSB;
		private: System::Windows::Forms::TextBox^  textBoxBoot;
		private: System::Windows::Forms::Button^  buttonEraseMemory;
		private: System::Windows::Forms::Button^  buttonWriteMemory;
		private: System::Windows::Forms::ToolStripMenuItem^  sendAllScriptsToDeviceToolStripMenuItem;
		private: System::Windows::Forms::Button^  buttonWriteBin;
		private: System::Windows::Forms::Button^  buttonClearBootLog;









		public: 
		private: 


		public:


		private:

		public: CallBackDelegate^ unmanagedDelegate;
		public: System::IntPtr    pointerF;
		public: int				  compileTaskCounter;
		public: int				  compileOutputCounter;
		private: System::Windows::Forms::Button^  buttonCancel;
		private: System::Windows::Forms::ToolStripMenuItem^  upgradeBootLoaderToolStripMenuItem;
		public: System::IO::Ports::SerialPort^  serialPort1;
		private: System::Windows::Forms::ToolStripMenuItem^  USBBootLoaderMenu;
		private: System::Windows::Forms::ToolTip^  toolTip1;
		private: System::Windows::Forms::CheckBox^  checkBoxVerbose;
		private: System::Windows::Forms::ToolStripMenuItem^  defaultSystemLog;
		private: System::Windows::Forms::ToolStripMenuItem^  currentSystemLogFileNameToolStripMenuItem;
		private: System::Windows::Forms::ToolStripTextBox^  toolStripTextBox1;
		private: System::Windows::Forms::ToolStripMenuItem^  clearLogToolStripMenuItem;
		private: System::Windows::Forms::CheckBox^  checkBoxPersistentLog;
		private: System::Windows::Forms::ToolStripMenuItem^  wideEditorWindowToggleMenu;
		private: System::Windows::Forms::CheckBox^  checkBoxConfirmAllDelete;
		private: System::Windows::Forms::ToolStripMenuItem^  helpToolStripMenuItem;

















		private: 

		private: 

		public: 
		private: 


		public: 

		public:

			unsigned int blockLongProcesses;

		public: void doIdleTask(void)
					{
					compileOutputCounter++;
					if(this->compileTaskCounter>0)
						{
						this->compileTaskCounter--;
						}
					else
						{
						if(this->progressBar1->Value<(this->progressBar1->Maximum-1))this->progressBar1->Value++;
						this->compileTaskCounter=COMPILE_TASK_PERIOD;
						this->labelUSB->Text=formatStringFileSize(compileOutputCounter);
						Application::DoEvents();
						}
					}

				Form1(void)
					{
					InitializeComponent();
					//
					// TODO: Add the constructor code here
					//
					this->unmanagedDelegate=gcnew CallBackDelegate(this, &SimpleLibusbDemo::Form1::doIdleTask);
					this->pointerF=Marshal::GetFunctionPointerForDelegate(this->unmanagedDelegate);
					/* Provide A Hook For Unmanaged Code to Call this Managed Code Class method */
					globalIdleCompileTaskFunctionPointer=(NativeToManaged)this->pointerF.ToPointer();
					}

		protected:
			/// <summary>
			/// Clean up any resources being used.
			/// </summary>
			~Form1()
				{
				if (components)
					{
					delete components;
					}
				}
		private: System::Windows::Forms::TextBox^ textBoxLog;
		private: System::Windows::Forms::TextBox^ textBoxSerialUSB;
		private: System::Windows::Forms::Timer^ timer1;
		private: System::Windows::Forms::Button^  buttonCompileFile;

		private: System::Windows::Forms::TreeView^ treeViewFiles;

		private: System::Windows::Forms::CheckBox^ checkBoxAutoSync;

		private: System::ComponentModel::IContainer^ components;

		protected:

		protected:




		private:
			/// <summary>
			/// Required designer variable.
			/// </summary>


#pragma region Windows Form Designer generated code
			/// <summary>
			/// Required method for Designer support - do not modify
			/// the contents of this method with the code editor.
			/// </summary>
			void InitializeComponent(void)
				{
				this->components = (gcnew System::ComponentModel::Container());
				System::Windows::Forms::DataGridViewCellStyle^  dataGridViewCellStyle1 = (gcnew System::Windows::Forms::DataGridViewCellStyle());
				System::Windows::Forms::TreeNode^  treeNode1 = (gcnew System::Windows::Forms::TreeNode(L""));
				System::Windows::Forms::TreeNode^  treeNode2 = (gcnew System::Windows::Forms::TreeNode(L""));
				System::ComponentModel::ComponentResourceManager^  resources = (gcnew System::ComponentModel::ComponentResourceManager(Form1::typeid));
				this->dataGridView1 = (gcnew System::Windows::Forms::DataGridView());
				this->textBoxLog = (gcnew System::Windows::Forms::TextBox());
				this->textBoxSerialUSB = (gcnew System::Windows::Forms::TextBox());
				this->timer1 = (gcnew System::Windows::Forms::Timer(this->components));
				this->buttonCompileFile = (gcnew System::Windows::Forms::Button());
				this->treeViewFiles = (gcnew System::Windows::Forms::TreeView());
				this->checkBoxAutoSync = (gcnew System::Windows::Forms::CheckBox());
				this->checkBoxBatteryProtection = (gcnew System::Windows::Forms::CheckBox());
				this->treeViewScripts = (gcnew System::Windows::Forms::TreeView());
				this->numericUpDownBatteryProtect = (gcnew System::Windows::Forms::NumericUpDown());
				this->checkBoxSystemLogging = (gcnew System::Windows::Forms::CheckBox());
				this->treeViewPCScripts = (gcnew System::Windows::Forms::TreeView());
				this->treeViewPCFiles = (gcnew System::Windows::Forms::TreeView());
				this->checkBoxShowMemory = (gcnew System::Windows::Forms::CheckBox());
				this->textBoxInput1 = (gcnew System::Windows::Forms::TextBox());
				this->statusStrip1 = (gcnew System::Windows::Forms::StatusStrip());
				this->progressBar1 = (gcnew System::Windows::Forms::ToolStripProgressBar());
				this->labelUSBTraffic = (gcnew System::Windows::Forms::ToolStripStatusLabel());
				this->labelUSB = (gcnew System::Windows::Forms::ToolStripStatusLabel());
				this->labelTimeDevice = (gcnew System::Windows::Forms::ToolStripStatusLabel());
				this->labelTimeFromDeviceX = (gcnew System::Windows::Forms::ToolStripStatusLabel());
				this->labelLastTimeSynced = (gcnew System::Windows::Forms::ToolStripStatusLabel());
				this->labelLastTime = (gcnew System::Windows::Forms::ToolStripStatusLabel());
				this->labelVoltage = (gcnew System::Windows::Forms::ToolStripStatusLabel());
				this->labelVDD = (gcnew System::Windows::Forms::ToolStripStatusLabel());
				this->menuStrip1 = (gcnew System::Windows::Forms::MenuStrip());
				this->toolStripMenuItem1 = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->newFileToolStripMenu = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->FileOpen = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->FileAdd = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->FileSave = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->FileSaveAs = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->FileCompile = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->FileCompileAndSend = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->FileClose = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->FileExit = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->toolStripMenuItem2 = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->restoreHostDefaultsToolStripMenuItem1 = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->saveSettingsToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->restoreSettingsToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->sendAllScriptsToDeviceToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->clearLogToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->DeviceMenu = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->restoreDefaultsToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->DeviceSaveSettings = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->DeviceRestoreSettings = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->FileReset = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->clearSystemLogToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->showSystemLogToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->newSystemLogToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->defaultSystemLog = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->currentSystemLogFileNameToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->toolStripTextBox1 = (gcnew System::Windows::Forms::ToolStripTextBox());
				this->runToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->resetToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->runToolStripMenuItem1 = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->stopToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->runStopToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->stepToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->simulateSpeedResetToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->runDevicetoolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->toolStripMenuItem5 = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->toolStripMenuItem6 = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->toolStripMenuItem7 = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->toolStripMenuItem8 = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->memoryToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->localToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->memoryCardToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->getInfoToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->reconnectToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->timeToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->TimeSyncDeviceTime = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->toolStripMenuItem3 = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->fontSizeUpToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->fontSizeDownToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->wideEditorWindowToggleMenu = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->aboutToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->uSBDataLoggerToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->USBBootLoaderMenu = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->upgradeBootLoaderToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->helpToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				this->clearLog = (gcnew System::Windows::Forms::Button());
				this->numericUpDownMemoryOffset = (gcnew System::Windows::Forms::NumericUpDown());
				this->textBoxDebug = (gcnew System::Windows::Forms::TextBox());
				this->labelMemoryAt = (gcnew System::Windows::Forms::Label());
				this->labelMemory = (gcnew System::Windows::Forms::Label());
				this->timer2 = (gcnew System::Windows::Forms::Timer(this->components));
				this->buttonClearConsole = (gcnew System::Windows::Forms::Button());
				this->buttonRunVM = (gcnew System::Windows::Forms::Button());
				this->buttonStop = (gcnew System::Windows::Forms::Button());
				this->buttonStep = (gcnew System::Windows::Forms::Button());
				this->buttonReset = (gcnew System::Windows::Forms::Button());
				this->groupBoxSettings = (gcnew System::Windows::Forms::GroupBox());
				this->checkBoxSystemLogUSB = (gcnew System::Windows::Forms::CheckBox());
				this->label1 = (gcnew System::Windows::Forms::Label());
				this->label2 = (gcnew System::Windows::Forms::Label());
				this->buttonReadMemory = (gcnew System::Windows::Forms::Button());
				this->treeViewHelp = (gcnew System::Windows::Forms::TreeView());
				this->labelHelp = (gcnew System::Windows::Forms::Label());
				this->checkBoxOptimize = (gcnew System::Windows::Forms::CheckBox());
				this->numericUpDownTimeSpeed = (gcnew System::Windows::Forms::NumericUpDown());
				this->groupBoxHost = (gcnew System::Windows::Forms::GroupBox());
				this->checkBoxConfirmAllDelete = (gcnew System::Windows::Forms::CheckBox());
				this->checkBoxPersistentLog = (gcnew System::Windows::Forms::CheckBox());
				this->checkBoxSpeed = (gcnew System::Windows::Forms::CheckBox());
				this->textBoxBoot = (gcnew System::Windows::Forms::TextBox());
				this->buttonEraseMemory = (gcnew System::Windows::Forms::Button());
				this->buttonWriteMemory = (gcnew System::Windows::Forms::Button());
				this->buttonWriteBin = (gcnew System::Windows::Forms::Button());
				this->buttonClearBootLog = (gcnew System::Windows::Forms::Button());
				this->buttonCancel = (gcnew System::Windows::Forms::Button());
				this->serialPort1 = (gcnew System::IO::Ports::SerialPort(this->components));
				this->toolTip1 = (gcnew System::Windows::Forms::ToolTip(this->components));
				this->checkBoxVerbose = (gcnew System::Windows::Forms::CheckBox());
				(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->dataGridView1))->BeginInit();
				(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numericUpDownBatteryProtect))->BeginInit();
				this->statusStrip1->SuspendLayout();
				this->menuStrip1->SuspendLayout();
				(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numericUpDownMemoryOffset))->BeginInit();
				this->groupBoxSettings->SuspendLayout();
				(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numericUpDownTimeSpeed))->BeginInit();
				this->groupBoxHost->SuspendLayout();
				this->SuspendLayout();
				// 
				// dataGridView1
				// 
				this->dataGridView1->AccessibleRole = System::Windows::Forms::AccessibleRole::Application;
				this->dataGridView1->AllowUserToAddRows = false;
				this->dataGridView1->AllowUserToDeleteRows = false;
				this->dataGridView1->AllowUserToResizeColumns = false;
				this->dataGridView1->AllowUserToResizeRows = false;
				this->dataGridView1->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom) 
					| System::Windows::Forms::AnchorStyles::Left) 
					| System::Windows::Forms::AnchorStyles::Right));
				this->dataGridView1->AutoSizeColumnsMode = System::Windows::Forms::DataGridViewAutoSizeColumnsMode::AllCells;
				this->dataGridView1->AutoSizeRowsMode = System::Windows::Forms::DataGridViewAutoSizeRowsMode::AllCells;
				this->dataGridView1->BackgroundColor = System::Drawing::Color::Black;
				this->dataGridView1->BorderStyle = System::Windows::Forms::BorderStyle::Fixed3D;
				this->dataGridView1->CausesValidation = false;
				this->dataGridView1->CellBorderStyle = System::Windows::Forms::DataGridViewCellBorderStyle::None;
				this->dataGridView1->ColumnHeadersBorderStyle = System::Windows::Forms::DataGridViewHeaderBorderStyle::None;
				this->dataGridView1->ColumnHeadersHeightSizeMode = System::Windows::Forms::DataGridViewColumnHeadersHeightSizeMode::AutoSize;
				this->dataGridView1->ColumnHeadersVisible = false;
				dataGridViewCellStyle1->Alignment = System::Windows::Forms::DataGridViewContentAlignment::MiddleCenter;
				dataGridViewCellStyle1->BackColor = System::Drawing::SystemColors::Window;
				dataGridViewCellStyle1->Font = (gcnew System::Drawing::Font(L"Segoe UI", 8.25F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				dataGridViewCellStyle1->ForeColor = System::Drawing::SystemColors::ControlText;
				dataGridViewCellStyle1->SelectionBackColor = System::Drawing::SystemColors::Highlight;
				dataGridViewCellStyle1->SelectionForeColor = System::Drawing::SystemColors::HighlightText;
				dataGridViewCellStyle1->WrapMode = System::Windows::Forms::DataGridViewTriState::False;
				this->dataGridView1->DefaultCellStyle = dataGridViewCellStyle1;
				this->dataGridView1->EditMode = System::Windows::Forms::DataGridViewEditMode::EditOnEnter;
				this->dataGridView1->Enabled = false;
				this->dataGridView1->EnableHeadersVisualStyles = false;
				this->dataGridView1->GridColor = System::Drawing::Color::Lime;
				this->dataGridView1->Location = System::Drawing::Point(12, 494);
				this->dataGridView1->MultiSelect = false;
				this->dataGridView1->Name = L"dataGridView1";
				this->dataGridView1->ReadOnly = true;
				this->dataGridView1->RowHeadersBorderStyle = System::Windows::Forms::DataGridViewHeaderBorderStyle::None;
				this->dataGridView1->RowHeadersVisible = false;
				this->dataGridView1->RowHeadersWidth = 24;
				this->dataGridView1->RowHeadersWidthSizeMode = System::Windows::Forms::DataGridViewRowHeadersWidthSizeMode::DisableResizing;
				this->dataGridView1->SelectionMode = System::Windows::Forms::DataGridViewSelectionMode::CellSelect;
				this->dataGridView1->ShowCellErrors = false;
				this->dataGridView1->ShowCellToolTips = false;
				this->dataGridView1->ShowEditingIcon = false;
				this->dataGridView1->ShowRowErrors = false;
				this->dataGridView1->Size = System::Drawing::Size(640, 138);
				this->dataGridView1->TabIndex = 116;
				this->dataGridView1->Visible = false;
				this->dataGridView1->CurrentCellChanged += gcnew System::EventHandler(this, &Form1::dataGridView1_CurrentCellChanged);
				this->dataGridView1->CellEnter += gcnew System::Windows::Forms::DataGridViewCellEventHandler(this, &Form1::dataGridView1_CellEnter);
				this->dataGridView1->KeyUp += gcnew System::Windows::Forms::KeyEventHandler(this, &Form1::dataGridView1_KeyUp);
				// 
				// textBoxLog
				// 
				this->textBoxLog->AcceptsReturn = true;
				this->textBoxLog->BackColor = System::Drawing::SystemColors::WindowText;
				this->textBoxLog->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
				this->textBoxLog->Cursor = System::Windows::Forms::Cursors::IBeam;
				this->textBoxLog->Font = (gcnew System::Drawing::Font(L"Lucida Console", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->textBoxLog->ForeColor = System::Drawing::Color::Lime;
				this->textBoxLog->Location = System::Drawing::Point(12, 494);
				this->textBoxLog->Multiline = true;
				this->textBoxLog->Name = L"textBoxLog";
				this->textBoxLog->ScrollBars = System::Windows::Forms::ScrollBars::Both;
				this->textBoxLog->Size = System::Drawing::Size(640, 219);
				this->textBoxLog->TabIndex = 4;
				this->textBoxLog->TextChanged += gcnew System::EventHandler(this, &Form1::textBoxLog_TextChanged);
				// 
				// textBoxSerialUSB
				// 
				this->textBoxSerialUSB->AcceptsReturn = true;
				this->textBoxSerialUSB->BackColor = System::Drawing::SystemColors::WindowFrame;
				this->textBoxSerialUSB->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
				this->textBoxSerialUSB->Cursor = System::Windows::Forms::Cursors::IBeam;
				this->textBoxSerialUSB->Font = (gcnew System::Drawing::Font(L"Lucida Console", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->textBoxSerialUSB->ForeColor = System::Drawing::Color::Lime;
				this->textBoxSerialUSB->Location = System::Drawing::Point(658, 494);
				this->textBoxSerialUSB->Multiline = true;
				this->textBoxSerialUSB->Name = L"textBoxSerialUSB";
				this->textBoxSerialUSB->ScrollBars = System::Windows::Forms::ScrollBars::Both;
				this->textBoxSerialUSB->Size = System::Drawing::Size(596, 233);
				this->textBoxSerialUSB->TabIndex = 94;
				// 
				// timer1
				// 
				this->timer1->Interval = 25;
				this->timer1->Tick += gcnew System::EventHandler(this, &Form1::timer1_Tick);
				// 
				// buttonCompileFile
				// 
				this->buttonCompileFile->BackColor = System::Drawing::SystemColors::Control;
				this->buttonCompileFile->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->buttonCompileFile->Location = System::Drawing::Point(468, 467);
				this->buttonCompileFile->Name = L"buttonCompileFile";
				this->buttonCompileFile->Size = System::Drawing::Size(64, 24);
				this->buttonCompileFile->TabIndex = 98;
				this->buttonCompileFile->Text = L"Compile";
				this->buttonCompileFile->UseVisualStyleBackColor = false;
				this->buttonCompileFile->Click += gcnew System::EventHandler(this, &Form1::textBoxInput_Compile);
				// 
				// treeViewFiles
				// 
				this->treeViewFiles->AccessibleRole = System::Windows::Forms::AccessibleRole::None;
				this->treeViewFiles->BackColor = System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(255)), static_cast<System::Int32>(static_cast<System::Byte>(192)), 
					static_cast<System::Int32>(static_cast<System::Byte>(192)));
				this->treeViewFiles->CausesValidation = false;
				this->treeViewFiles->CheckBoxes = true;
				this->treeViewFiles->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->treeViewFiles->Location = System::Drawing::Point(658, 26);
				this->treeViewFiles->Name = L"treeViewFiles";
				treeNode1->Name = L"Root";
				treeNode1->Text = L"";
				this->treeViewFiles->Nodes->AddRange(gcnew cli::array< System::Windows::Forms::TreeNode^  >(1) {treeNode1});
				this->treeViewFiles->ShowPlusMinus = false;
				this->treeViewFiles->Size = System::Drawing::Size(200, 210);
				this->treeViewFiles->TabIndex = 99;
				this->treeViewFiles->NodeMouseDoubleClick += gcnew System::Windows::Forms::TreeNodeMouseClickEventHandler(this, &Form1::treeViewFiles_NodeMouseDoubleClick);
				this->treeViewFiles->AfterLabelEdit += gcnew System::Windows::Forms::NodeLabelEditEventHandler(this, &Form1::treeViewFiles_AfterLabelEdit);
				this->treeViewFiles->AfterSelect += gcnew System::Windows::Forms::TreeViewEventHandler(this, &Form1::treeViewFiles_AfterSelect);
				this->treeViewFiles->NodeMouseClick += gcnew System::Windows::Forms::TreeNodeMouseClickEventHandler(this, &Form1::treeViewFiles_NodeMouseClick);
				// 
				// checkBoxAutoSync
				// 
				this->checkBoxAutoSync->AutoSize = true;
				this->checkBoxAutoSync->BackgroundImageLayout = System::Windows::Forms::ImageLayout::None;
				this->checkBoxAutoSync->Checked = true;
				this->checkBoxAutoSync->CheckState = System::Windows::Forms::CheckState::Indeterminate;
				this->checkBoxAutoSync->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->checkBoxAutoSync->Location = System::Drawing::Point(6, 22);
				this->checkBoxAutoSync->Name = L"checkBoxAutoSync";
				this->checkBoxAutoSync->Size = System::Drawing::Size(82, 19);
				this->checkBoxAutoSync->TabIndex = 102;
				this->checkBoxAutoSync->Text = L"Auto Time";
				this->checkBoxAutoSync->UseVisualStyleBackColor = true;
				this->checkBoxAutoSync->CheckedChanged += gcnew System::EventHandler(this, &Form1::checkBoxAutoSync_CheckedChanged);
				// 
				// checkBoxBatteryProtection
				// 
				this->checkBoxBatteryProtection->AutoSize = true;
				this->checkBoxBatteryProtection->BackgroundImageLayout = System::Windows::Forms::ImageLayout::None;
				this->checkBoxBatteryProtection->Checked = true;
				this->checkBoxBatteryProtection->CheckState = System::Windows::Forms::CheckState::Indeterminate;
				this->checkBoxBatteryProtection->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->checkBoxBatteryProtection->Location = System::Drawing::Point(6, 95);
				this->checkBoxBatteryProtection->Name = L"checkBoxBatteryProtection";
				this->checkBoxBatteryProtection->Size = System::Drawing::Size(97, 19);
				this->checkBoxBatteryProtection->TabIndex = 109;
				this->checkBoxBatteryProtection->Text = L"Undervoltage";
				this->checkBoxBatteryProtection->UseVisualStyleBackColor = true;
				this->checkBoxBatteryProtection->CheckedChanged += gcnew System::EventHandler(this, &Form1::checkBoxBatteryProtection_CheckedChanged);
				// 
				// treeViewScripts
				// 
				this->treeViewScripts->AccessibleRole = System::Windows::Forms::AccessibleRole::None;
				this->treeViewScripts->BackColor = System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(255)), static_cast<System::Int32>(static_cast<System::Byte>(192)), 
					static_cast<System::Int32>(static_cast<System::Byte>(192)));
				this->treeViewScripts->CausesValidation = false;
				this->treeViewScripts->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->treeViewScripts->Location = System::Drawing::Point(864, 26);
				this->treeViewScripts->Name = L"treeViewScripts";
				this->treeViewScripts->Size = System::Drawing::Size(200, 210);
				this->treeViewScripts->TabIndex = 110;
				this->treeViewScripts->NodeMouseClick += gcnew System::Windows::Forms::TreeNodeMouseClickEventHandler(this, &Form1::treeViewScripts_NodeMouseClick);
				// 
				// numericUpDownBatteryProtect
				// 
				this->numericUpDownBatteryProtect->DecimalPlaces = 2;
				this->numericUpDownBatteryProtect->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->numericUpDownBatteryProtect->Increment = System::Decimal(gcnew cli::array< System::Int32 >(4) {5, 0, 0, 131072});
				this->numericUpDownBatteryProtect->Location = System::Drawing::Point(109, 93);
				this->numericUpDownBatteryProtect->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) {330, 0, 0, 131072});
				this->numericUpDownBatteryProtect->Minimum = System::Decimal(gcnew cli::array< System::Int32 >(4) {9, 0, 0, 65536});
				this->numericUpDownBatteryProtect->Name = L"numericUpDownBatteryProtect";
				this->numericUpDownBatteryProtect->Size = System::Drawing::Size(49, 23);
				this->numericUpDownBatteryProtect->TabIndex = 113;
				this->numericUpDownBatteryProtect->TextAlign = System::Windows::Forms::HorizontalAlignment::Center;
				this->numericUpDownBatteryProtect->Value = System::Decimal(gcnew cli::array< System::Int32 >(4) {180, 0, 0, 131072});
				this->numericUpDownBatteryProtect->ValueChanged += gcnew System::EventHandler(this, &Form1::numericUpDownBatteryProtect_ValueChanged);
				this->numericUpDownBatteryProtect->MouseClick += gcnew System::Windows::Forms::MouseEventHandler(this, &Form1::numericUpDownBatteryProtect_MouseClick);
				// 
				// checkBoxSystemLogging
				// 
				this->checkBoxSystemLogging->AutoSize = true;
				this->checkBoxSystemLogging->BackgroundImageLayout = System::Windows::Forms::ImageLayout::None;
				this->checkBoxSystemLogging->Checked = true;
				this->checkBoxSystemLogging->CheckState = System::Windows::Forms::CheckState::Indeterminate;
				this->checkBoxSystemLogging->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->checkBoxSystemLogging->Location = System::Drawing::Point(6, 46);
				this->checkBoxSystemLogging->Name = L"checkBoxSystemLogging";
				this->checkBoxSystemLogging->Size = System::Drawing::Size(87, 19);
				this->checkBoxSystemLogging->TabIndex = 114;
				this->checkBoxSystemLogging->Text = L"System Log";
				this->checkBoxSystemLogging->UseVisualStyleBackColor = true;
				this->checkBoxSystemLogging->CheckedChanged += gcnew System::EventHandler(this, &Form1::checkBoxSystemLogging_CheckedChanged);
				// 
				// treeViewPCScripts
				// 
				this->treeViewPCScripts->AccessibleRole = System::Windows::Forms::AccessibleRole::None;
				this->treeViewPCScripts->BackColor = System::Drawing::Color::PaleGreen;
				this->treeViewPCScripts->CausesValidation = false;
				this->treeViewPCScripts->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->treeViewPCScripts->Location = System::Drawing::Point(864, 256);
				this->treeViewPCScripts->Name = L"treeViewPCScripts";
				this->treeViewPCScripts->Size = System::Drawing::Size(200, 210);
				this->treeViewPCScripts->TabIndex = 115;
				this->treeViewPCScripts->NodeMouseClick += gcnew System::Windows::Forms::TreeNodeMouseClickEventHandler(this, &Form1::treeViewPCScripts_NodeMouseClick);
				// 
				// treeViewPCFiles
				// 
				this->treeViewPCFiles->AccessibleRole = System::Windows::Forms::AccessibleRole::None;
				this->treeViewPCFiles->BackColor = System::Drawing::Color::PaleGreen;
				this->treeViewPCFiles->CausesValidation = false;
				this->treeViewPCFiles->CheckBoxes = true;
				this->treeViewPCFiles->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->treeViewPCFiles->Location = System::Drawing::Point(658, 256);
				this->treeViewPCFiles->Name = L"treeViewPCFiles";
				treeNode2->Name = L"Root";
				treeNode2->Text = L"";
				this->treeViewPCFiles->Nodes->AddRange(gcnew cli::array< System::Windows::Forms::TreeNode^  >(1) {treeNode2});
				this->treeViewPCFiles->ShowPlusMinus = false;
				this->treeViewPCFiles->Size = System::Drawing::Size(200, 210);
				this->treeViewPCFiles->TabIndex = 117;
				this->treeViewPCFiles->NodeMouseDoubleClick += gcnew System::Windows::Forms::TreeNodeMouseClickEventHandler(this, &Form1::treeViewPCFiles_NodeMouseDoubleClick);
				this->treeViewPCFiles->AfterLabelEdit += gcnew System::Windows::Forms::NodeLabelEditEventHandler(this, &Form1::treeViewPCFiles_AfterLabelEdit);
				this->treeViewPCFiles->NodeMouseClick += gcnew System::Windows::Forms::TreeNodeMouseClickEventHandler(this, &Form1::treeViewPCFiles_NodeMouseClick);
				// 
				// checkBoxShowMemory
				// 
				this->checkBoxShowMemory->AutoSize = true;
				this->checkBoxShowMemory->BackgroundImageLayout = System::Windows::Forms::ImageLayout::None;
				this->checkBoxShowMemory->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->checkBoxShowMemory->Location = System::Drawing::Point(12, 471);
				this->checkBoxShowMemory->Name = L"checkBoxShowMemory";
				this->checkBoxShowMemory->Size = System::Drawing::Size(61, 19);
				this->checkBoxShowMemory->TabIndex = 118;
				this->checkBoxShowMemory->Text = L"Debug";
				this->checkBoxShowMemory->UseVisualStyleBackColor = true;
				this->checkBoxShowMemory->CheckedChanged += gcnew System::EventHandler(this, &Form1::checkBoxShowMemory_CheckedChanged);
				// 
				// textBoxInput1
				// 
				this->textBoxInput1->AcceptsReturn = true;
				this->textBoxInput1->AcceptsTab = true;
				this->textBoxInput1->BackColor = System::Drawing::SystemColors::WindowText;
				this->textBoxInput1->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
				this->textBoxInput1->Cursor = System::Windows::Forms::Cursors::IBeam;
				this->textBoxInput1->Font = (gcnew System::Drawing::Font(L"Lucida Console", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->textBoxInput1->ForeColor = System::Drawing::Color::Lime;
				this->textBoxInput1->HideSelection = false;
				this->textBoxInput1->Location = System::Drawing::Point(12, 26);
				this->textBoxInput1->MaxLength = 512000;
				this->textBoxInput1->Multiline = true;
				this->textBoxInput1->Name = L"textBoxInput1";
				this->textBoxInput1->ScrollBars = System::Windows::Forms::ScrollBars::Both;
				this->textBoxInput1->Size = System::Drawing::Size(640, 440);
				this->textBoxInput1->TabIndex = 119;
				this->textBoxInput1->WordWrap = false;
				this->textBoxInput1->TextChanged += gcnew System::EventHandler(this, &Form1::textBoxInput1_TextChanged);
				// 
				// statusStrip1
				// 
				this->statusStrip1->AutoSize = false;
				this->statusStrip1->Items->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(9) {this->progressBar1, this->labelUSBTraffic, 
					this->labelUSB, this->labelTimeDevice, this->labelTimeFromDeviceX, this->labelLastTimeSynced, this->labelLastTime, this->labelVoltage, 
					this->labelVDD});
				this->statusStrip1->Location = System::Drawing::Point(0, 730);
				this->statusStrip1->Name = L"statusStrip1";
				this->statusStrip1->RenderMode = System::Windows::Forms::ToolStripRenderMode::Professional;
				this->statusStrip1->Size = System::Drawing::Size(1264, 32);
				this->statusStrip1->TabIndex = 120;
				this->statusStrip1->Text = L"statusStrip1";
				// 
				// progressBar1
				// 
				this->progressBar1->AutoSize = false;
				this->progressBar1->CausesValidation = false;
				this->progressBar1->MarqueeAnimationSpeed = 0;
				this->progressBar1->Name = L"progressBar1";
				this->progressBar1->Padding = System::Windows::Forms::Padding(20, 0, 0, 8);
				this->progressBar1->Size = System::Drawing::Size(580, 26);
				// 
				// labelUSBTraffic
				// 
				this->labelUSBTraffic->AutoSize = false;
				this->labelUSBTraffic->Name = L"labelUSBTraffic";
				this->labelUSBTraffic->Size = System::Drawing::Size(32, 27);
				this->labelUSBTraffic->Text = L"-";
				// 
				// labelUSB
				// 
				this->labelUSB->AutoSize = false;
				this->labelUSB->Name = L"labelUSB";
				this->labelUSB->Size = System::Drawing::Size(64, 27);
				this->labelUSB->Text = L"-";
				// 
				// labelTimeDevice
				// 
				this->labelTimeDevice->AutoSize = false;
				this->labelTimeDevice->Name = L"labelTimeDevice";
				this->labelTimeDevice->Size = System::Drawing::Size(80, 27);
				this->labelTimeDevice->Text = L"Device Time:";
				// 
				// labelTimeFromDeviceX
				// 
				this->labelTimeFromDeviceX->AutoSize = false;
				this->labelTimeFromDeviceX->Name = L"labelTimeFromDeviceX";
				this->labelTimeFromDeviceX->Size = System::Drawing::Size(140, 27);
				this->labelTimeFromDeviceX->Text = L"-";
				// 
				// labelLastTimeSynced
				// 
				this->labelLastTimeSynced->AutoSize = false;
				this->labelLastTimeSynced->Name = L"labelLastTimeSynced";
				this->labelLastTimeSynced->Size = System::Drawing::Size(80, 27);
				this->labelLastTimeSynced->Text = L"Last Sync:";
				this->labelLastTimeSynced->Click += gcnew System::EventHandler(this, &Form1::labelLastTimeSynced_Click);
				// 
				// labelLastTime
				// 
				this->labelLastTime->AutoSize = false;
				this->labelLastTime->Name = L"labelLastTime";
				this->labelLastTime->Size = System::Drawing::Size(140, 27);
				this->labelLastTime->Text = L"-";
				// 
				// labelVoltage
				// 
				this->labelVoltage->AutoSize = false;
				this->labelVoltage->Name = L"labelVoltage";
				this->labelVoltage->Size = System::Drawing::Size(40, 27);
				this->labelVoltage->Text = L"VDD:";
				this->labelVoltage->Click += gcnew System::EventHandler(this, &Form1::labelVoltage_Click);
				// 
				// labelVDD
				// 
				this->labelVDD->AutoSize = false;
				this->labelVDD->ForeColor = System::Drawing::Color::Black;
				this->labelVDD->ImageScaling = System::Windows::Forms::ToolStripItemImageScaling::None;
				this->labelVDD->Name = L"labelVDD";
				this->labelVDD->Overflow = System::Windows::Forms::ToolStripItemOverflow::Never;
				this->labelVDD->Size = System::Drawing::Size(74, 27);
				this->labelVDD->Text = L"-";
				// 
				// menuStrip1
				// 
				this->menuStrip1->Items->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(10) {this->toolStripMenuItem1, 
					this->toolStripMenuItem2, this->DeviceMenu, this->runToolStripMenuItem, this->runDevicetoolStripMenuItem, this->memoryToolStripMenuItem, 
					this->memoryCardToolStripMenuItem, this->timeToolStripMenuItem, this->toolStripMenuItem3, this->aboutToolStripMenuItem});
				this->menuStrip1->Location = System::Drawing::Point(0, 0);
				this->menuStrip1->Name = L"menuStrip1";
				this->menuStrip1->Size = System::Drawing::Size(1264, 24);
				this->menuStrip1->TabIndex = 121;
				this->menuStrip1->Text = L"menuStrip1";
				// 
				// toolStripMenuItem1
				// 
				this->toolStripMenuItem1->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(9) {this->newFileToolStripMenu, 
					this->FileOpen, this->FileAdd, this->FileSave, this->FileSaveAs, this->FileCompile, this->FileCompileAndSend, this->FileClose, 
					this->FileExit});
				this->toolStripMenuItem1->Name = L"toolStripMenuItem1";
				this->toolStripMenuItem1->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Alt | System::Windows::Forms::Keys::F));
				this->toolStripMenuItem1->Size = System::Drawing::Size(37, 20);
				this->toolStripMenuItem1->Text = L"File";
				this->toolStripMenuItem1->Click += gcnew System::EventHandler(this, &Form1::toolStripMenuItem1_Click);
				// 
				// newFileToolStripMenu
				// 
				this->newFileToolStripMenu->Name = L"newFileToolStripMenu";
				this->newFileToolStripMenu->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Control | System::Windows::Forms::Keys::N));
				this->newFileToolStripMenu->Size = System::Drawing::Size(198, 22);
				this->newFileToolStripMenu->Text = L"New";
				this->newFileToolStripMenu->Click += gcnew System::EventHandler(this, &Form1::newFileToolStripMenu_Click);
				// 
				// FileOpen
				// 
				this->FileOpen->Name = L"FileOpen";
				this->FileOpen->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Control | System::Windows::Forms::Keys::O));
				this->FileOpen->Size = System::Drawing::Size(198, 22);
				this->FileOpen->Text = L"Open...";
				this->FileOpen->Click += gcnew System::EventHandler(this, &Form1::FileOpen_Click);
				// 
				// FileAdd
				// 
				this->FileAdd->Name = L"FileAdd";
				this->FileAdd->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Control | System::Windows::Forms::Keys::End));
				this->FileAdd->Size = System::Drawing::Size(198, 22);
				this->FileAdd->Text = L"Add...";
				this->FileAdd->Click += gcnew System::EventHandler(this, &Form1::FileAdd_Click);
				// 
				// FileSave
				// 
				this->FileSave->Name = L"FileSave";
				this->FileSave->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Control | System::Windows::Forms::Keys::S));
				this->FileSave->Size = System::Drawing::Size(198, 22);
				this->FileSave->Text = L"Save";
				this->FileSave->Click += gcnew System::EventHandler(this, &Form1::FileSave_Click);
				// 
				// FileSaveAs
				// 
				this->FileSaveAs->Name = L"FileSaveAs";
				this->FileSaveAs->ShortcutKeys = static_cast<System::Windows::Forms::Keys>(((System::Windows::Forms::Keys::Control | System::Windows::Forms::Keys::Shift) 
					| System::Windows::Forms::Keys::S));
				this->FileSaveAs->Size = System::Drawing::Size(198, 22);
				this->FileSaveAs->Text = L"Save As...";
				this->FileSaveAs->Click += gcnew System::EventHandler(this, &Form1::FileSaveAs_Click);
				// 
				// FileCompile
				// 
				this->FileCompile->Name = L"FileCompile";
				this->FileCompile->ShortcutKeys = System::Windows::Forms::Keys::F10;
				this->FileCompile->Size = System::Drawing::Size(198, 22);
				this->FileCompile->Text = L"Compile";
				this->FileCompile->Click += gcnew System::EventHandler(this, &Form1::FileCompile_Click);
				// 
				// FileCompileAndSend
				// 
				this->FileCompileAndSend->Name = L"FileCompileAndSend";
				this->FileCompileAndSend->ShortcutKeys = System::Windows::Forms::Keys::F11;
				this->FileCompileAndSend->Size = System::Drawing::Size(198, 22);
				this->FileCompileAndSend->Text = L"Compile And Send";
				this->FileCompileAndSend->Click += gcnew System::EventHandler(this, &Form1::FileCompileAndSend_Click);
				// 
				// FileClose
				// 
				this->FileClose->Name = L"FileClose";
				this->FileClose->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Control | System::Windows::Forms::Keys::F4));
				this->FileClose->Size = System::Drawing::Size(198, 22);
				this->FileClose->Text = L"Close";
				this->FileClose->Click += gcnew System::EventHandler(this, &Form1::FileClose_Click);
				// 
				// FileExit
				// 
				this->FileExit->Name = L"FileExit";
				this->FileExit->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Alt | System::Windows::Forms::Keys::F4));
				this->FileExit->Size = System::Drawing::Size(198, 22);
				this->FileExit->Text = L"Exit";
				this->FileExit->Click += gcnew System::EventHandler(this, &Form1::FileExit_Click);
				// 
				// toolStripMenuItem2
				// 
				this->toolStripMenuItem2->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(5) {this->restoreHostDefaultsToolStripMenuItem1, 
					this->saveSettingsToolStripMenuItem, this->restoreSettingsToolStripMenuItem, this->sendAllScriptsToDeviceToolStripMenuItem, this->clearLogToolStripMenuItem});
				this->toolStripMenuItem2->Name = L"toolStripMenuItem2";
				this->toolStripMenuItem2->Size = System::Drawing::Size(44, 20);
				this->toolStripMenuItem2->Text = L"Host";
				// 
				// restoreHostDefaultsToolStripMenuItem1
				// 
				this->restoreHostDefaultsToolStripMenuItem1->Name = L"restoreHostDefaultsToolStripMenuItem1";
				this->restoreHostDefaultsToolStripMenuItem1->Size = System::Drawing::Size(267, 22);
				this->restoreHostDefaultsToolStripMenuItem1->Text = L"Restore Defaults";
				this->restoreHostDefaultsToolStripMenuItem1->Click += gcnew System::EventHandler(this, &Form1::restoreHostDefaultsToolStripMenuItem1_Click);
				// 
				// saveSettingsToolStripMenuItem
				// 
				this->saveSettingsToolStripMenuItem->Name = L"saveSettingsToolStripMenuItem";
				this->saveSettingsToolStripMenuItem->Size = System::Drawing::Size(267, 22);
				this->saveSettingsToolStripMenuItem->Text = L"Save Settings";
				this->saveSettingsToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::HostSaveSettings_Click);
				// 
				// restoreSettingsToolStripMenuItem
				// 
				this->restoreSettingsToolStripMenuItem->Name = L"restoreSettingsToolStripMenuItem";
				this->restoreSettingsToolStripMenuItem->Size = System::Drawing::Size(267, 22);
				this->restoreSettingsToolStripMenuItem->Text = L"Restore Settings";
				this->restoreSettingsToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::HostRestoreSettings_Click);
				// 
				// sendAllScriptsToDeviceToolStripMenuItem
				// 
				this->sendAllScriptsToDeviceToolStripMenuItem->Name = L"sendAllScriptsToDeviceToolStripMenuItem";
				this->sendAllScriptsToDeviceToolStripMenuItem->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Shift | System::Windows::Forms::Keys::F11));
				this->sendAllScriptsToDeviceToolStripMenuItem->Size = System::Drawing::Size(267, 22);
				this->sendAllScriptsToDeviceToolStripMenuItem->Text = L"Send All Scripts To Device";
				this->sendAllScriptsToDeviceToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::sendAllScriptsToDeviceToolStripMenuItem_Click);
				// 
				// clearLogToolStripMenuItem
				// 
				this->clearLogToolStripMenuItem->Name = L"clearLogToolStripMenuItem";
				this->clearLogToolStripMenuItem->Size = System::Drawing::Size(267, 22);
				this->clearLogToolStripMenuItem->Text = L"Save Log";
				this->clearLogToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::clearLogToolStripMenuItem_Click);
				// 
				// DeviceMenu
				// 
				this->DeviceMenu->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(9) {this->restoreDefaultsToolStripMenuItem, 
					this->DeviceSaveSettings, this->DeviceRestoreSettings, this->FileReset, this->clearSystemLogToolStripMenuItem, this->showSystemLogToolStripMenuItem, 
					this->newSystemLogToolStripMenuItem, this->defaultSystemLog, this->currentSystemLogFileNameToolStripMenuItem});
				this->DeviceMenu->Enabled = false;
				this->DeviceMenu->Name = L"DeviceMenu";
				this->DeviceMenu->Size = System::Drawing::Size(54, 20);
				this->DeviceMenu->Text = L"Device";
				// 
				// restoreDefaultsToolStripMenuItem
				// 
				this->restoreDefaultsToolStripMenuItem->Name = L"restoreDefaultsToolStripMenuItem";
				this->restoreDefaultsToolStripMenuItem->Size = System::Drawing::Size(176, 22);
				this->restoreDefaultsToolStripMenuItem->Text = L"Restore Defaults";
				this->restoreDefaultsToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::restoreDefaultsToolStripMenuItem_Click);
				// 
				// DeviceSaveSettings
				// 
				this->DeviceSaveSettings->Name = L"DeviceSaveSettings";
				this->DeviceSaveSettings->Size = System::Drawing::Size(176, 22);
				this->DeviceSaveSettings->Text = L"Save Settings";
				this->DeviceSaveSettings->Click += gcnew System::EventHandler(this, &Form1::DeviceSaveSettings_Click);
				// 
				// DeviceRestoreSettings
				// 
				this->DeviceRestoreSettings->Name = L"DeviceRestoreSettings";
				this->DeviceRestoreSettings->Size = System::Drawing::Size(176, 22);
				this->DeviceRestoreSettings->Text = L"Restore Settings";
				this->DeviceRestoreSettings->Click += gcnew System::EventHandler(this, &Form1::DeviceRestoreSettings_Click);
				// 
				// FileReset
				// 
				this->FileReset->Name = L"FileReset";
				this->FileReset->Size = System::Drawing::Size(176, 22);
				this->FileReset->Text = L"Reset";
				this->FileReset->Click += gcnew System::EventHandler(this, &Form1::FileReset_Click);
				// 
				// clearSystemLogToolStripMenuItem
				// 
				this->clearSystemLogToolStripMenuItem->Name = L"clearSystemLogToolStripMenuItem";
				this->clearSystemLogToolStripMenuItem->Size = System::Drawing::Size(176, 22);
				this->clearSystemLogToolStripMenuItem->Text = L"Clear System Log";
				this->clearSystemLogToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::clearSystemLogToolStripMenuItem_Click);
				// 
				// showSystemLogToolStripMenuItem
				// 
				this->showSystemLogToolStripMenuItem->Name = L"showSystemLogToolStripMenuItem";
				this->showSystemLogToolStripMenuItem->Size = System::Drawing::Size(176, 22);
				this->showSystemLogToolStripMenuItem->Text = L"Show System Log";
				this->showSystemLogToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::showSystemLogToolStripMenuItem_Click);
				// 
				// newSystemLogToolStripMenuItem
				// 
				this->newSystemLogToolStripMenuItem->Name = L"newSystemLogToolStripMenuItem";
				this->newSystemLogToolStripMenuItem->Size = System::Drawing::Size(176, 22);
				this->newSystemLogToolStripMenuItem->Text = L"New System Log";
				this->newSystemLogToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::newSystemLogToolStripMenuItem_Click);
				// 
				// defaultSystemLog
				// 
				this->defaultSystemLog->Name = L"defaultSystemLog";
				this->defaultSystemLog->Size = System::Drawing::Size(176, 22);
				this->defaultSystemLog->Text = L"Default System Log";
				this->defaultSystemLog->Click += gcnew System::EventHandler(this, &Form1::resetSystemLogToDefaultToolStripMenuItem_Click);
				// 
				// currentSystemLogFileNameToolStripMenuItem
				// 
				this->currentSystemLogFileNameToolStripMenuItem->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(1) {this->toolStripTextBox1});
				this->currentSystemLogFileNameToolStripMenuItem->Name = L"currentSystemLogFileNameToolStripMenuItem";
				this->currentSystemLogFileNameToolStripMenuItem->Size = System::Drawing::Size(176, 22);
				this->currentSystemLogFileNameToolStripMenuItem->Text = L"System Log Name";
				this->currentSystemLogFileNameToolStripMenuItem->DropDownOpened += gcnew System::EventHandler(this, &Form1::currentSystemLogFileNameToolStripMenuItem_DropDownOpened);
				this->currentSystemLogFileNameToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::currentSystemLogFileNameToolStripMenuItem_Click);
				// 
				// toolStripTextBox1
				// 
				this->toolStripTextBox1->AcceptsReturn = true;
				this->toolStripTextBox1->MaxLength = 24;
				this->toolStripTextBox1->Name = L"toolStripTextBox1";
				this->toolStripTextBox1->Size = System::Drawing::Size(160, 23);
				this->toolStripTextBox1->Text = L"Unavailable";
				this->toolStripTextBox1->KeyPress += gcnew System::Windows::Forms::KeyPressEventHandler(this, &Form1::toolStripTextBox1_KeyPress);
				// 
				// runToolStripMenuItem
				// 
				this->runToolStripMenuItem->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(6) {this->resetToolStripMenuItem, 
					this->runToolStripMenuItem1, this->stopToolStripMenuItem, this->runStopToolStripMenuItem, this->stepToolStripMenuItem, this->simulateSpeedResetToolStripMenuItem});
				this->runToolStripMenuItem->Name = L"runToolStripMenuItem";
				this->runToolStripMenuItem->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Alt | System::Windows::Forms::Keys::R));
				this->runToolStripMenuItem->Size = System::Drawing::Size(40, 20);
				this->runToolStripMenuItem->Text = L"Run";
				// 
				// resetToolStripMenuItem
				// 
				this->resetToolStripMenuItem->Name = L"resetToolStripMenuItem";
				this->resetToolStripMenuItem->ShortcutKeys = System::Windows::Forms::Keys::F6;
				this->resetToolStripMenuItem->Size = System::Drawing::Size(162, 22);
				this->resetToolStripMenuItem->Text = L"Reset";
				this->resetToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::resetToolStripMenuItem_Click);
				// 
				// runToolStripMenuItem1
				// 
				this->runToolStripMenuItem1->Name = L"runToolStripMenuItem1";
				this->runToolStripMenuItem1->ShortcutKeys = System::Windows::Forms::Keys::F9;
				this->runToolStripMenuItem1->Size = System::Drawing::Size(162, 22);
				this->runToolStripMenuItem1->Text = L"Run";
				this->runToolStripMenuItem1->Click += gcnew System::EventHandler(this, &Form1::runToolStripMenuItem1_Click);
				// 
				// stopToolStripMenuItem
				// 
				this->stopToolStripMenuItem->Name = L"stopToolStripMenuItem";
				this->stopToolStripMenuItem->ShortcutKeys = System::Windows::Forms::Keys::F5;
				this->stopToolStripMenuItem->Size = System::Drawing::Size(162, 22);
				this->stopToolStripMenuItem->Text = L"Stop";
				this->stopToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::stopToolStripMenuItem_Click);
				// 
				// runStopToolStripMenuItem
				// 
				this->runStopToolStripMenuItem->Name = L"runStopToolStripMenuItem";
				this->runStopToolStripMenuItem->ShortcutKeys = System::Windows::Forms::Keys::F12;
				this->runStopToolStripMenuItem->Size = System::Drawing::Size(162, 22);
				this->runStopToolStripMenuItem->Text = L"Run/Stop";
				this->runStopToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::runStopToolStripMenuItem_Click);
				// 
				// stepToolStripMenuItem
				// 
				this->stepToolStripMenuItem->Name = L"stepToolStripMenuItem";
				this->stepToolStripMenuItem->ShortcutKeys = System::Windows::Forms::Keys::F8;
				this->stepToolStripMenuItem->Size = System::Drawing::Size(162, 22);
				this->stepToolStripMenuItem->Text = L"Step";
				this->stepToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::stepToolStripMenuItem_Click);
				// 
				// simulateSpeedResetToolStripMenuItem
				// 
				this->simulateSpeedResetToolStripMenuItem->Name = L"simulateSpeedResetToolStripMenuItem";
				this->simulateSpeedResetToolStripMenuItem->Size = System::Drawing::Size(162, 22);
				this->simulateSpeedResetToolStripMenuItem->Text = L"Scale Time Reset";
				this->simulateSpeedResetToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::simulateSpeedResetToolStripMenuItem_Click);
				// 
				// runDevicetoolStripMenuItem
				// 
				this->runDevicetoolStripMenuItem->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(4) {this->toolStripMenuItem5, 
					this->toolStripMenuItem6, this->toolStripMenuItem7, this->toolStripMenuItem8});
				this->runDevicetoolStripMenuItem->Name = L"runDevicetoolStripMenuItem";
				this->runDevicetoolStripMenuItem->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Alt | System::Windows::Forms::Keys::R));
				this->runDevicetoolStripMenuItem->Size = System::Drawing::Size(78, 20);
				this->runDevicetoolStripMenuItem->Text = L"Run Device";
				// 
				// toolStripMenuItem5
				// 
				this->toolStripMenuItem5->Name = L"toolStripMenuItem5";
				this->toolStripMenuItem5->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Shift | System::Windows::Forms::Keys::F6));
				this->toolStripMenuItem5->Size = System::Drawing::Size(181, 22);
				this->toolStripMenuItem5->Text = L"Reset";
				this->toolStripMenuItem5->Click += gcnew System::EventHandler(this, &Form1::resetDeviceToolStripMenuItem_Click);
				// 
				// toolStripMenuItem6
				// 
				this->toolStripMenuItem6->Name = L"toolStripMenuItem6";
				this->toolStripMenuItem6->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Shift | System::Windows::Forms::Keys::F9));
				this->toolStripMenuItem6->Size = System::Drawing::Size(181, 22);
				this->toolStripMenuItem6->Text = L"Run";
				this->toolStripMenuItem6->Click += gcnew System::EventHandler(this, &Form1::runDeviceToolStripMenuItem1_Click);
				// 
				// toolStripMenuItem7
				// 
				this->toolStripMenuItem7->Name = L"toolStripMenuItem7";
				this->toolStripMenuItem7->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Shift | System::Windows::Forms::Keys::F5));
				this->toolStripMenuItem7->Size = System::Drawing::Size(181, 22);
				this->toolStripMenuItem7->Text = L"Stop";
				this->toolStripMenuItem7->Click += gcnew System::EventHandler(this, &Form1::stopDeviceToolStripMenuItem_Click);
				// 
				// toolStripMenuItem8
				// 
				this->toolStripMenuItem8->Name = L"toolStripMenuItem8";
				this->toolStripMenuItem8->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Shift | System::Windows::Forms::Keys::F12));
				this->toolStripMenuItem8->Size = System::Drawing::Size(181, 22);
				this->toolStripMenuItem8->Text = L"Run/Stop";
				this->toolStripMenuItem8->Click += gcnew System::EventHandler(this, &Form1::runStopDeviceToolStripMenuItem_Click);
				// 
				// memoryToolStripMenuItem
				// 
				this->memoryToolStripMenuItem->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(1) {this->localToolStripMenuItem});
				this->memoryToolStripMenuItem->Name = L"memoryToolStripMenuItem";
				this->memoryToolStripMenuItem->Size = System::Drawing::Size(64, 20);
				this->memoryToolStripMenuItem->Text = L"Memory";
				// 
				// localToolStripMenuItem
				// 
				this->localToolStripMenuItem->Name = L"localToolStripMenuItem";
				this->localToolStripMenuItem->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Control | System::Windows::Forms::Keys::M));
				this->localToolStripMenuItem->Size = System::Drawing::Size(235, 22);
				this->localToolStripMenuItem->Text = L"Toggle Local Memory";
				this->localToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::localToolStripMenuItem_Click);
				// 
				// memoryCardToolStripMenuItem
				// 
				this->memoryCardToolStripMenuItem->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(2) {this->getInfoToolStripMenuItem, 
					this->reconnectToolStripMenuItem});
				this->memoryCardToolStripMenuItem->Enabled = false;
				this->memoryCardToolStripMenuItem->Name = L"memoryCardToolStripMenuItem";
				this->memoryCardToolStripMenuItem->Size = System::Drawing::Size(92, 20);
				this->memoryCardToolStripMenuItem->Text = L"Memory Card";
				// 
				// getInfoToolStripMenuItem
				// 
				this->getInfoToolStripMenuItem->Name = L"getInfoToolStripMenuItem";
				this->getInfoToolStripMenuItem->Size = System::Drawing::Size(130, 22);
				this->getInfoToolStripMenuItem->Text = L"Get Info";
				this->getInfoToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::getInfoToolStripMenuItem_Click);
				// 
				// reconnectToolStripMenuItem
				// 
				this->reconnectToolStripMenuItem->Name = L"reconnectToolStripMenuItem";
				this->reconnectToolStripMenuItem->Size = System::Drawing::Size(130, 22);
				this->reconnectToolStripMenuItem->Text = L"Reconnect";
				this->reconnectToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::reconnectToolStripMenuItem_Click);
				// 
				// timeToolStripMenuItem
				// 
				this->timeToolStripMenuItem->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(1) {this->TimeSyncDeviceTime});
				this->timeToolStripMenuItem->Enabled = false;
				this->timeToolStripMenuItem->Name = L"timeToolStripMenuItem";
				this->timeToolStripMenuItem->Size = System::Drawing::Size(46, 20);
				this->timeToolStripMenuItem->Text = L"Time";
				// 
				// TimeSyncDeviceTime
				// 
				this->TimeSyncDeviceTime->Name = L"TimeSyncDeviceTime";
				this->TimeSyncDeviceTime->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Control | System::Windows::Forms::Keys::T));
				this->TimeSyncDeviceTime->Size = System::Drawing::Size(208, 22);
				this->TimeSyncDeviceTime->Text = L"Sync Device Time";
				this->TimeSyncDeviceTime->Click += gcnew System::EventHandler(this, &Form1::TimeSyncDeviceTime_Click);
				// 
				// toolStripMenuItem3
				// 
				this->toolStripMenuItem3->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(3) {this->fontSizeUpToolStripMenuItem, 
					this->fontSizeDownToolStripMenuItem, this->wideEditorWindowToggleMenu});
				this->toolStripMenuItem3->Name = L"toolStripMenuItem3";
				this->toolStripMenuItem3->Size = System::Drawing::Size(63, 20);
				this->toolStripMenuItem3->Text = L"Window";
				// 
				// fontSizeUpToolStripMenuItem
				// 
				this->fontSizeUpToolStripMenuItem->Name = L"fontSizeUpToolStripMenuItem";
				this->fontSizeUpToolStripMenuItem->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Control | System::Windows::Forms::Keys::Up));
				this->fontSizeUpToolStripMenuItem->Size = System::Drawing::Size(241, 22);
				this->fontSizeUpToolStripMenuItem->Text = L"Font Size Up";
				this->fontSizeUpToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::fontSizeUpToolStripMenuItem_Click);
				// 
				// fontSizeDownToolStripMenuItem
				// 
				this->fontSizeDownToolStripMenuItem->Name = L"fontSizeDownToolStripMenuItem";
				this->fontSizeDownToolStripMenuItem->ShortcutKeys = static_cast<System::Windows::Forms::Keys>((System::Windows::Forms::Keys::Control | System::Windows::Forms::Keys::Down));
				this->fontSizeDownToolStripMenuItem->Size = System::Drawing::Size(241, 22);
				this->fontSizeDownToolStripMenuItem->Text = L"Font Size Down";
				this->fontSizeDownToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::fontSizeDownToolStripMenuItem_Click);
				// 
				// wideEditorWindowToggleMenu
				// 
				this->wideEditorWindowToggleMenu->Name = L"wideEditorWindowToggleMenu";
				this->wideEditorWindowToggleMenu->ShortcutKeys = System::Windows::Forms::Keys::F3;
				this->wideEditorWindowToggleMenu->Size = System::Drawing::Size(241, 22);
				this->wideEditorWindowToggleMenu->Text = L"Toggle Wide Editor Window";
				this->wideEditorWindowToggleMenu->Click += gcnew System::EventHandler(this, &Form1::wideEditorWindowToggleMenu_Click);
				// 
				// aboutToolStripMenuItem
				// 
				this->aboutToolStripMenuItem->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(4) {this->uSBDataLoggerToolStripMenuItem, 
					this->USBBootLoaderMenu, this->upgradeBootLoaderToolStripMenuItem, this->helpToolStripMenuItem});
				this->aboutToolStripMenuItem->Name = L"aboutToolStripMenuItem";
				this->aboutToolStripMenuItem->Size = System::Drawing::Size(52, 20);
				this->aboutToolStripMenuItem->Text = L"About";
				// 
				// uSBDataLoggerToolStripMenuItem
				// 
				this->uSBDataLoggerToolStripMenuItem->Name = L"uSBDataLoggerToolStripMenuItem";
				this->uSBDataLoggerToolStripMenuItem->Size = System::Drawing::Size(205, 22);
				this->uSBDataLoggerToolStripMenuItem->Text = L"USB Data Logger";
				this->uSBDataLoggerToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::uSBDataLoggerToolStripMenuItem_Click);
				// 
				// USBBootLoaderMenu
				// 
				this->USBBootLoaderMenu->Name = L"USBBootLoaderMenu";
				this->USBBootLoaderMenu->Size = System::Drawing::Size(205, 22);
				this->USBBootLoaderMenu->Text = L"Enter USB BootLoader...";
				this->USBBootLoaderMenu->Click += gcnew System::EventHandler(this, &Form1::USBBootLoaderMenu_Click);
				// 
				// upgradeBootLoaderToolStripMenuItem
				// 
				this->upgradeBootLoaderToolStripMenuItem->Name = L"upgradeBootLoaderToolStripMenuItem";
				this->upgradeBootLoaderToolStripMenuItem->Size = System::Drawing::Size(205, 22);
				this->upgradeBootLoaderToolStripMenuItem->Text = L"Enter Serial BootLoader...";
				this->upgradeBootLoaderToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::upgradeBootLoaderToolStripMenuItem_Click);
				// 
				// helpToolStripMenuItem
				// 
				this->helpToolStripMenuItem->Name = L"helpToolStripMenuItem";
				this->helpToolStripMenuItem->Size = System::Drawing::Size(205, 22);
				this->helpToolStripMenuItem->Text = L"Help";
				this->helpToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::helpToolStripMenuItem_Click);
				// 
				// clearLog
				// 
				this->clearLog->BackColor = System::Drawing::SystemColors::Control;
				this->clearLog->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->clearLog->Location = System::Drawing::Point(538, 467);
				this->clearLog->Name = L"clearLog";
				this->clearLog->Size = System::Drawing::Size(113, 24);
				this->clearLog->TabIndex = 122;
				this->clearLog->Text = L"Clear Log Window";
				this->clearLog->UseVisualStyleBackColor = false;
				this->clearLog->Click += gcnew System::EventHandler(this, &Form1::clearLog_Click);
				// 
				// numericUpDownMemoryOffset
				// 
				this->numericUpDownMemoryOffset->Enabled = false;
				this->numericUpDownMemoryOffset->Hexadecimal = true;
				this->numericUpDownMemoryOffset->Increment = System::Decimal(gcnew cli::array< System::Int32 >(4) {16, 0, 0, 0});
				this->numericUpDownMemoryOffset->Location = System::Drawing::Point(79, 468);
				this->numericUpDownMemoryOffset->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) {65535, 0, 0, 0});
				this->numericUpDownMemoryOffset->Name = L"numericUpDownMemoryOffset";
				this->numericUpDownMemoryOffset->Size = System::Drawing::Size(57, 22);
				this->numericUpDownMemoryOffset->TabIndex = 123;
				this->numericUpDownMemoryOffset->TextAlign = System::Windows::Forms::HorizontalAlignment::Right;
				this->numericUpDownMemoryOffset->ValueChanged += gcnew System::EventHandler(this, &Form1::numericUpDownMemoryOffset_ValueChanged);
				// 
				// textBoxDebug
				// 
				this->textBoxDebug->AcceptsReturn = true;
				this->textBoxDebug->BackColor = System::Drawing::SystemColors::WindowText;
				this->textBoxDebug->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
				this->textBoxDebug->Cursor = System::Windows::Forms::Cursors::IBeam;
				this->textBoxDebug->Font = (gcnew System::Drawing::Font(L"Lucida Console", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->textBoxDebug->ForeColor = System::Drawing::Color::Lime;
				this->textBoxDebug->Location = System::Drawing::Point(12, 638);
				this->textBoxDebug->Multiline = true;
				this->textBoxDebug->Name = L"textBoxDebug";
				this->textBoxDebug->Size = System::Drawing::Size(640, 89);
				this->textBoxDebug->TabIndex = 124;
				this->textBoxDebug->Visible = false;
				this->textBoxDebug->WordWrap = false;
				// 
				// labelMemoryAt
				// 
				this->labelMemoryAt->AutoSize = true;
				this->labelMemoryAt->Location = System::Drawing::Point(142, 473);
				this->labelMemoryAt->Name = L"labelMemoryAt";
				this->labelMemoryAt->Size = System::Drawing::Size(21, 13);
				this->labelMemoryAt->TabIndex = 125;
				this->labelMemoryAt->Text = L"At:";
				this->labelMemoryAt->TextAlign = System::Drawing::ContentAlignment::MiddleCenter;
				// 
				// labelMemory
				// 
				this->labelMemory->AutoSize = true;
				this->labelMemory->Location = System::Drawing::Point(160, 473);
				this->labelMemory->Name = L"labelMemory";
				this->labelMemory->Size = System::Drawing::Size(42, 13);
				this->labelMemory->TabIndex = 126;
				this->labelMemory->Text = L"0x0000";
				this->labelMemory->TextAlign = System::Drawing::ContentAlignment::MiddleCenter;
				// 
				// timer2
				// 
				this->timer2->Interval = 10;
				this->timer2->Tick += gcnew System::EventHandler(this, &Form1::timer2_Tick);
				// 
				// buttonClearConsole
				// 
				this->buttonClearConsole->BackColor = System::Drawing::SystemColors::Control;
				this->buttonClearConsole->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->buttonClearConsole->Location = System::Drawing::Point(1124, 468);
				this->buttonClearConsole->Name = L"buttonClearConsole";
				this->buttonClearConsole->Size = System::Drawing::Size(113, 24);
				this->buttonClearConsole->TabIndex = 127;
				this->buttonClearConsole->Text = L"Clear Console";
				this->buttonClearConsole->UseVisualStyleBackColor = false;
				this->buttonClearConsole->Click += gcnew System::EventHandler(this, &Form1::buttonClearConsole_Click);
				// 
				// buttonRunVM
				// 
				this->buttonRunVM->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->buttonRunVM->Location = System::Drawing::Point(658, 467);
				this->buttonRunVM->Name = L"buttonRunVM";
				this->buttonRunVM->Size = System::Drawing::Size(64, 24);
				this->buttonRunVM->TabIndex = 128;
				this->buttonRunVM->Text = L"Run";
				this->buttonRunVM->UseVisualStyleBackColor = true;
				this->buttonRunVM->Click += gcnew System::EventHandler(this, &Form1::buttonRunVM_Click_1);
				// 
				// buttonStop
				// 
				this->buttonStop->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->buttonStop->Location = System::Drawing::Point(726, 467);
				this->buttonStop->Name = L"buttonStop";
				this->buttonStop->Size = System::Drawing::Size(64, 24);
				this->buttonStop->TabIndex = 129;
				this->buttonStop->Text = L"Stop";
				this->buttonStop->UseVisualStyleBackColor = true;
				this->buttonStop->Click += gcnew System::EventHandler(this, &Form1::buttonStop_Click);
				// 
				// buttonStep
				// 
				this->buttonStep->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->buttonStep->Location = System::Drawing::Point(862, 467);
				this->buttonStep->Name = L"buttonStep";
				this->buttonStep->Size = System::Drawing::Size(64, 24);
				this->buttonStep->TabIndex = 130;
				this->buttonStep->Text = L"Step";
				this->buttonStep->UseVisualStyleBackColor = true;
				this->buttonStep->Click += gcnew System::EventHandler(this, &Form1::buttonStep_Click);
				// 
				// buttonReset
				// 
				this->buttonReset->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->buttonReset->Location = System::Drawing::Point(794, 467);
				this->buttonReset->Name = L"buttonReset";
				this->buttonReset->Size = System::Drawing::Size(64, 24);
				this->buttonReset->TabIndex = 131;
				this->buttonReset->Text = L"Reset";
				this->buttonReset->UseVisualStyleBackColor = true;
				this->buttonReset->Click += gcnew System::EventHandler(this, &Form1::buttonReset_Click);
				// 
				// groupBoxSettings
				// 
				this->groupBoxSettings->Controls->Add(this->checkBoxSystemLogUSB);
				this->groupBoxSettings->Controls->Add(this->numericUpDownBatteryProtect);
				this->groupBoxSettings->Controls->Add(this->checkBoxAutoSync);
				this->groupBoxSettings->Controls->Add(this->checkBoxSystemLogging);
				this->groupBoxSettings->Controls->Add(this->checkBoxBatteryProtection);
				this->groupBoxSettings->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->groupBoxSettings->Location = System::Drawing::Point(1090, 26);
				this->groupBoxSettings->Name = L"groupBoxSettings";
				this->groupBoxSettings->Size = System::Drawing::Size(161, 122);
				this->groupBoxSettings->TabIndex = 132;
				this->groupBoxSettings->TabStop = false;
				this->groupBoxSettings->Text = L"Device Settings";
				// 
				// checkBoxSystemLogUSB
				// 
				this->checkBoxSystemLogUSB->AutoSize = true;
				this->checkBoxSystemLogUSB->BackgroundImageLayout = System::Windows::Forms::ImageLayout::None;
				this->checkBoxSystemLogUSB->Checked = true;
				this->checkBoxSystemLogUSB->CheckState = System::Windows::Forms::CheckState::Indeterminate;
				this->checkBoxSystemLogUSB->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->checkBoxSystemLogUSB->Location = System::Drawing::Point(6, 70);
				this->checkBoxSystemLogUSB->Name = L"checkBoxSystemLogUSB";
				this->checkBoxSystemLogUSB->Size = System::Drawing::Size(111, 19);
				this->checkBoxSystemLogUSB->TabIndex = 115;
				this->checkBoxSystemLogUSB->Text = L"System Log USB";
				this->checkBoxSystemLogUSB->UseVisualStyleBackColor = true;
				this->checkBoxSystemLogUSB->CheckedChanged += gcnew System::EventHandler(this, &Form1::checkBoxSystemLogUSB_CheckedChanged);
				// 
				// label1
				// 
				this->label1->AutoSize = true;
				this->label1->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->label1->Location = System::Drawing::Point(655, 9);
				this->label1->Name = L"label1";
				this->label1->Size = System::Drawing::Size(68, 15);
				this->label1->TabIndex = 133;
				this->label1->Text = L"Device Files";
				// 
				// label2
				// 
				this->label2->AutoSize = true;
				this->label2->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->label2->Location = System::Drawing::Point(658, 239);
				this->label2->Name = L"label2";
				this->label2->Size = System::Drawing::Size(58, 15);
				this->label2->TabIndex = 134;
				this->label2->Text = L"Host Files";
				// 
				// buttonReadMemory
				// 
				this->buttonReadMemory->BackColor = System::Drawing::SystemColors::Control;
				this->buttonReadMemory->Enabled = false;
				this->buttonReadMemory->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->buttonReadMemory->Location = System::Drawing::Point(13, 27);
				this->buttonReadMemory->Name = L"buttonReadMemory";
				this->buttonReadMemory->Size = System::Drawing::Size(140, 24);
				this->buttonReadMemory->TabIndex = 135;
				this->buttonReadMemory->Text = L"Read Memory";
				this->buttonReadMemory->UseVisualStyleBackColor = false;
				this->buttonReadMemory->Visible = false;
				this->buttonReadMemory->Click += gcnew System::EventHandler(this, &Form1::buttonReadMemory_Click);
				// 
				// treeViewHelp
				// 
				this->treeViewHelp->AccessibleRole = System::Windows::Forms::AccessibleRole::None;
				this->treeViewHelp->BackColor = System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(224)), static_cast<System::Int32>(static_cast<System::Byte>(224)), 
					static_cast<System::Int32>(static_cast<System::Byte>(224)));
				this->treeViewHelp->CausesValidation = false;
				this->treeViewHelp->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->treeViewHelp->Location = System::Drawing::Point(1072, 256);
				this->treeViewHelp->Name = L"treeViewHelp";
				this->treeViewHelp->Size = System::Drawing::Size(182, 210);
				this->treeViewHelp->TabIndex = 136;
				this->treeViewHelp->NodeMouseDoubleClick += gcnew System::Windows::Forms::TreeNodeMouseClickEventHandler(this, &Form1::treeViewHelp_NodeMouseDoubleClick);
				this->treeViewHelp->AfterSelect += gcnew System::Windows::Forms::TreeViewEventHandler(this, &Form1::treeViewHelp_AfterSelect);
				this->treeViewHelp->MouseEnter += gcnew System::EventHandler(this, &Form1::treeViewHelp_MouseEnter);
				this->treeViewHelp->NodeMouseClick += gcnew System::Windows::Forms::TreeNodeMouseClickEventHandler(this, &Form1::treeViewHelp_NodeMouseClick);
				this->treeViewHelp->MouseLeave += gcnew System::EventHandler(this, &Form1::treeViewHelp_MouseLeave);
				// 
				// labelHelp
				// 
				this->labelHelp->AutoSize = true;
				this->labelHelp->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->labelHelp->Location = System::Drawing::Point(1069, 239);
				this->labelHelp->Name = L"labelHelp";
				this->labelHelp->Size = System::Drawing::Size(32, 15);
				this->labelHelp->TabIndex = 137;
				this->labelHelp->Text = L"Help";
				// 
				// checkBoxOptimize
				// 
				this->checkBoxOptimize->AutoSize = true;
				this->checkBoxOptimize->Location = System::Drawing::Point(208, 471);
				this->checkBoxOptimize->Name = L"checkBoxOptimize";
				this->checkBoxOptimize->Size = System::Drawing::Size(102, 17);
				this->checkBoxOptimize->TabIndex = 138;
				this->checkBoxOptimize->Text = L"Optimise Code";
				this->checkBoxOptimize->UseVisualStyleBackColor = true;
				this->checkBoxOptimize->CheckedChanged += gcnew System::EventHandler(this, &Form1::checkBoxOptimize_CheckedChanged);
				// 
				// numericUpDownTimeSpeed
				// 
				this->numericUpDownTimeSpeed->DecimalPlaces = 2;
				this->numericUpDownTimeSpeed->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->numericUpDownTimeSpeed->Increment = System::Decimal(gcnew cli::array< System::Int32 >(4) {5, 0, 0, 131072});
				this->numericUpDownTimeSpeed->Location = System::Drawing::Point(105, 17);
				this->numericUpDownTimeSpeed->Minimum = System::Decimal(gcnew cli::array< System::Int32 >(4) {1, 0, 0, 65536});
				this->numericUpDownTimeSpeed->Name = L"numericUpDownTimeSpeed";
				this->numericUpDownTimeSpeed->Size = System::Drawing::Size(49, 23);
				this->numericUpDownTimeSpeed->TabIndex = 115;
				this->numericUpDownTimeSpeed->TextAlign = System::Windows::Forms::HorizontalAlignment::Center;
				this->numericUpDownTimeSpeed->Value = System::Decimal(gcnew cli::array< System::Int32 >(4) {100, 0, 0, 131072});
				this->numericUpDownTimeSpeed->ValueChanged += gcnew System::EventHandler(this, &Form1::numericUpDownTimeSpeed_ValueChanged);
				// 
				// groupBoxHost
				// 
				this->groupBoxHost->Controls->Add(this->checkBoxConfirmAllDelete);
				this->groupBoxHost->Controls->Add(this->checkBoxPersistentLog);
				this->groupBoxHost->Controls->Add(this->checkBoxSpeed);
				this->groupBoxHost->Controls->Add(this->numericUpDownTimeSpeed);
				this->groupBoxHost->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->groupBoxHost->Location = System::Drawing::Point(1091, 148);
				this->groupBoxHost->Name = L"groupBoxHost";
				this->groupBoxHost->Size = System::Drawing::Size(160, 88);
				this->groupBoxHost->TabIndex = 139;
				this->groupBoxHost->TabStop = false;
				this->groupBoxHost->Text = L"Host Settings";
				// 
				// checkBoxConfirmAllDelete
				// 
				this->checkBoxConfirmAllDelete->AutoSize = true;
				this->checkBoxConfirmAllDelete->BackgroundImageLayout = System::Windows::Forms::ImageLayout::None;
				this->checkBoxConfirmAllDelete->Checked = true;
				this->checkBoxConfirmAllDelete->CheckState = System::Windows::Forms::CheckState::Checked;
				this->checkBoxConfirmAllDelete->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->checkBoxConfirmAllDelete->Location = System::Drawing::Point(5, 63);
				this->checkBoxConfirmAllDelete->Name = L"checkBoxConfirmAllDelete";
				this->checkBoxConfirmAllDelete->Size = System::Drawing::Size(128, 19);
				this->checkBoxConfirmAllDelete->TabIndex = 117;
				this->checkBoxConfirmAllDelete->Text = L"Confirm All Deletes";
				this->checkBoxConfirmAllDelete->UseVisualStyleBackColor = true;
				this->checkBoxConfirmAllDelete->CheckedChanged += gcnew System::EventHandler(this, &Form1::checkBoxConfirmAllDelete_CheckedChanged);
				// 
				// checkBoxPersistentLog
				// 
				this->checkBoxPersistentLog->AutoSize = true;
				this->checkBoxPersistentLog->BackgroundImageLayout = System::Windows::Forms::ImageLayout::None;
				this->checkBoxPersistentLog->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->checkBoxPersistentLog->Location = System::Drawing::Point(5, 42);
				this->checkBoxPersistentLog->Name = L"checkBoxPersistentLog";
				this->checkBoxPersistentLog->Size = System::Drawing::Size(100, 19);
				this->checkBoxPersistentLog->TabIndex = 116;
				this->checkBoxPersistentLog->Text = L"Persistent Log";
				this->checkBoxPersistentLog->UseVisualStyleBackColor = true;
				this->checkBoxPersistentLog->CheckedChanged += gcnew System::EventHandler(this, &Form1::checkBox1_CheckedChanged);
				// 
				// checkBoxSpeed
				// 
				this->checkBoxSpeed->AutoSize = true;
				this->checkBoxSpeed->BackgroundImageLayout = System::Windows::Forms::ImageLayout::None;
				this->checkBoxSpeed->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->checkBoxSpeed->Location = System::Drawing::Point(5, 21);
				this->checkBoxSpeed->Name = L"checkBoxSpeed";
				this->checkBoxSpeed->Size = System::Drawing::Size(83, 19);
				this->checkBoxSpeed->TabIndex = 115;
				this->checkBoxSpeed->Text = L"Scale Time";
				this->checkBoxSpeed->UseVisualStyleBackColor = true;
				this->checkBoxSpeed->CheckedChanged += gcnew System::EventHandler(this, &Form1::checkBoxSpeed_CheckedChanged);
				// 
				// textBoxBoot
				// 
				this->textBoxBoot->AcceptsReturn = true;
				this->textBoxBoot->BackColor = System::Drawing::SystemColors::WindowText;
				this->textBoxBoot->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
				this->textBoxBoot->Cursor = System::Windows::Forms::Cursors::IBeam;
				this->textBoxBoot->Enabled = false;
				this->textBoxBoot->Font = (gcnew System::Drawing::Font(L"Lucida Console", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->textBoxBoot->ForeColor = System::Drawing::Color::Lime;
				this->textBoxBoot->Location = System::Drawing::Point(12, 90);
				this->textBoxBoot->Multiline = true;
				this->textBoxBoot->Name = L"textBoxBoot";
				this->textBoxBoot->ReadOnly = true;
				this->textBoxBoot->ScrollBars = System::Windows::Forms::ScrollBars::Both;
				this->textBoxBoot->Size = System::Drawing::Size(666, 623);
				this->textBoxBoot->TabIndex = 140;
				this->textBoxBoot->Visible = false;
				// 
				// buttonEraseMemory
				// 
				this->buttonEraseMemory->BackColor = System::Drawing::SystemColors::Control;
				this->buttonEraseMemory->Enabled = false;
				this->buttonEraseMemory->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->buttonEraseMemory->Location = System::Drawing::Point(173, 27);
				this->buttonEraseMemory->Name = L"buttonEraseMemory";
				this->buttonEraseMemory->Size = System::Drawing::Size(140, 24);
				this->buttonEraseMemory->TabIndex = 141;
				this->buttonEraseMemory->Text = L"Verify Memory";
				this->buttonEraseMemory->UseVisualStyleBackColor = false;
				this->buttonEraseMemory->Visible = false;
				this->buttonEraseMemory->Click += gcnew System::EventHandler(this, &Form1::buttonEraseMemory_Click);
				// 
				// buttonWriteMemory
				// 
				this->buttonWriteMemory->BackColor = System::Drawing::SystemColors::Control;
				this->buttonWriteMemory->Enabled = false;
				this->buttonWriteMemory->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->buttonWriteMemory->Location = System::Drawing::Point(333, 27);
				this->buttonWriteMemory->Name = L"buttonWriteMemory";
				this->buttonWriteMemory->Size = System::Drawing::Size(140, 24);
				this->buttonWriteMemory->TabIndex = 142;
				this->buttonWriteMemory->Text = L"Write HEX";
				this->buttonWriteMemory->UseVisualStyleBackColor = false;
				this->buttonWriteMemory->Visible = false;
				this->buttonWriteMemory->Click += gcnew System::EventHandler(this, &Form1::buttonWriteMemory_Click);
				// 
				// buttonWriteBin
				// 
				this->buttonWriteBin->BackColor = System::Drawing::SystemColors::Control;
				this->buttonWriteBin->Enabled = false;
				this->buttonWriteBin->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->buttonWriteBin->Location = System::Drawing::Point(493, 27);
				this->buttonWriteBin->Name = L"buttonWriteBin";
				this->buttonWriteBin->Size = System::Drawing::Size(140, 24);
				this->buttonWriteBin->TabIndex = 143;
				this->buttonWriteBin->Text = L"Write BINARY";
				this->buttonWriteBin->UseVisualStyleBackColor = false;
				this->buttonWriteBin->Visible = false;
				this->buttonWriteBin->Click += gcnew System::EventHandler(this, &Form1::buttonWriteBin_Click);
				// 
				// buttonClearBootLog
				// 
				this->buttonClearBootLog->BackColor = System::Drawing::SystemColors::Control;
				this->buttonClearBootLog->Enabled = false;
				this->buttonClearBootLog->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->buttonClearBootLog->Location = System::Drawing::Point(13, 57);
				this->buttonClearBootLog->Name = L"buttonClearBootLog";
				this->buttonClearBootLog->Size = System::Drawing::Size(620, 24);
				this->buttonClearBootLog->TabIndex = 144;
				this->buttonClearBootLog->Text = L"Clear Boot Log";
				this->buttonClearBootLog->UseVisualStyleBackColor = false;
				this->buttonClearBootLog->Visible = false;
				this->buttonClearBootLog->Click += gcnew System::EventHandler(this, &Form1::buttonClearBootLog_Click);
				// 
				// buttonCancel
				// 
				this->buttonCancel->BackColor = System::Drawing::SystemColors::Control;
				this->buttonCancel->Font = (gcnew System::Drawing::Font(L"Segoe UI", 9, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->buttonCancel->Location = System::Drawing::Point(398, 467);
				this->buttonCancel->Name = L"buttonCancel";
				this->buttonCancel->Size = System::Drawing::Size(64, 24);
				this->buttonCancel->TabIndex = 145;
				this->buttonCancel->Text = L"Cancel ";
				this->buttonCancel->UseVisualStyleBackColor = false;
				this->buttonCancel->Click += gcnew System::EventHandler(this, &Form1::buttonCancel_Click);
				// 
				// serialPort1
				// 
				this->serialPort1->BaudRate = 115200;
				// 
				// toolTip1
				// 
				this->toolTip1->Active = false;
				this->toolTip1->AutoPopDelay = 60000;
				this->toolTip1->InitialDelay = 0;
				this->toolTip1->ReshowDelay = 100;
				this->toolTip1->UseAnimation = false;
				this->toolTip1->UseFading = false;
				// 
				// checkBoxVerbose
				// 
				this->checkBoxVerbose->AutoSize = true;
				this->checkBoxVerbose->Checked = true;
				this->checkBoxVerbose->CheckState = System::Windows::Forms::CheckState::Checked;
				this->checkBoxVerbose->Location = System::Drawing::Point(316, 471);
				this->checkBoxVerbose->Name = L"checkBoxVerbose";
				this->checkBoxVerbose->Size = System::Drawing::Size(68, 17);
				this->checkBoxVerbose->TabIndex = 146;
				this->checkBoxVerbose->Text = L"Verbose";
				this->checkBoxVerbose->UseVisualStyleBackColor = true;
				this->checkBoxVerbose->Click += gcnew System::EventHandler(this, &Form1::checkBoxVerbose_Click);
				// 
				// Form1
				// 
				this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::None;
				this->AutoScroll = true;
				this->AutoSizeMode = System::Windows::Forms::AutoSizeMode::GrowAndShrink;
				this->ClientSize = System::Drawing::Size(1264, 762);
				this->Controls->Add(this->checkBoxVerbose);
				this->Controls->Add(this->buttonCancel);
				this->Controls->Add(this->buttonClearBootLog);
				this->Controls->Add(this->buttonWriteBin);
				this->Controls->Add(this->buttonWriteMemory);
				this->Controls->Add(this->buttonEraseMemory);
				this->Controls->Add(this->checkBoxOptimize);
				this->Controls->Add(this->labelHelp);
				this->Controls->Add(this->treeViewHelp);
				this->Controls->Add(this->buttonReadMemory);
				this->Controls->Add(this->label2);
				this->Controls->Add(this->label1);
				this->Controls->Add(this->buttonReset);
				this->Controls->Add(this->buttonStep);
				this->Controls->Add(this->buttonStop);
				this->Controls->Add(this->buttonRunVM);
				this->Controls->Add(this->buttonClearConsole);
				this->Controls->Add(this->labelMemory);
				this->Controls->Add(this->labelMemoryAt);
				this->Controls->Add(this->numericUpDownMemoryOffset);
				this->Controls->Add(this->clearLog);
				this->Controls->Add(this->checkBoxShowMemory);
				this->Controls->Add(this->treeViewPCFiles);
				this->Controls->Add(this->treeViewScripts);
				this->Controls->Add(this->buttonCompileFile);
				this->Controls->Add(this->textBoxSerialUSB);
				this->Controls->Add(this->statusStrip1);
				this->Controls->Add(this->menuStrip1);
				this->Controls->Add(this->treeViewPCScripts);
				this->Controls->Add(this->treeViewFiles);
				this->Controls->Add(this->groupBoxSettings);
				this->Controls->Add(this->textBoxDebug);
				this->Controls->Add(this->dataGridView1);
				this->Controls->Add(this->groupBoxHost);
				this->Controls->Add(this->textBoxLog);
				this->Controls->Add(this->textBoxBoot);
				this->Controls->Add(this->textBoxInput1);
				this->DoubleBuffered = true;
				this->Font = (gcnew System::Drawing::Font(L"Segoe UI", 8.25F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
					static_cast<System::Byte>(0)));
				this->Icon = (cli::safe_cast<System::Drawing::Icon^  >(resources->GetObject(L"$this.Icon")));
				this->MainMenuStrip = this->menuStrip1;
				this->MaximumSize = System::Drawing::Size(1280, 800);
				this->Name = L"Form1";
				this->Text = L"USB Data Logger";
				this->Load += gcnew System::EventHandler(this, &Form1::Form1_Load);
				this->FormClosed += gcnew System::Windows::Forms::FormClosedEventHandler(this, &Form1::Form1_FormClosed);
				(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->dataGridView1))->EndInit();
				(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numericUpDownBatteryProtect))->EndInit();
				this->statusStrip1->ResumeLayout(false);
				this->statusStrip1->PerformLayout();
				this->menuStrip1->ResumeLayout(false);
				this->menuStrip1->PerformLayout();
				(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numericUpDownMemoryOffset))->EndInit();
				this->groupBoxSettings->ResumeLayout(false);
				this->groupBoxSettings->PerformLayout();
				(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numericUpDownTimeSpeed))->EndInit();
				this->groupBoxHost->ResumeLayout(false);
				this->groupBoxHost->PerformLayout();
				this->ResumeLayout(false);
				this->PerformLayout();

				}

#pragma endregion

#if(USE_LEGACY_SERIAL_PORT)

		private: System::String^ DisconnectSerialPort(System::Void)
					 {
					 String^ responseString;

					 if(MyDevice!=INVALID_HANDLE_VALUE)
						 {
						 CloseHandle(MyDevice);
						 responseString="Disconnecting from "+this->SerialPortName+": Ok.\r\n";
						 }
					 else
						 {
						 responseString="";
						 }
					 MyDevice=INVALID_HANDLE_VALUE;
					 SerialPortConnected=false;
					 return responseString;
					 }

				 BOOL wstrcpy(LPWSTR wdest, LPCSTR src, int wlen)
					 {
					 return (MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,src, strlen(src)+1, wdest, wlen) != 0);
					 }

		private: System::String^ ConnectSerialPort(System::Void)
					 {
					 static DCB  dcbSerialParams;
					 String^	 responseString;
					 char        resName[32];

					 if(MyDevice==INVALID_HANDLE_VALUE)
						 {
						 responseString="Connecting to ";
						 this->SerialPortName="COM"+formatStringFloat((double)SerialPortNumber, 0);
						 responseString+=this->SerialPortName;
						 getUnsignedCharArrayFromString((unsigned char*)resName, this->SerialPortName);
						 MyDevice=CreateFile((char*)resName, GENERIC_WRITE | GENERIC_READ, NULL, NULL, OPEN_EXISTING, 0, 0);
						 if(MyDevice==INVALID_HANDLE_VALUE)
							 {
							 responseString+=": Bad!\r\n";
							 }
						 else
							 {

							 dcbSerialParams.DCBlength=sizeof(dcbSerialParams);
							 if (!GetCommState(MyDevice, &dcbSerialParams))
								 {
								 //error getting state

								 }

							 if(baudRt==PC_BOOT_BAUD_SLOW)
								 {
								 dcbSerialParams.BaudRate=PC_BOOT_BAUD_SLOW;
								 }
							 else
								 {
								 dcbSerialParams.BaudRate=PC_BOOT_BAUD_QUICK;
								 }
							 dcbSerialParams.ByteSize=8;
							 dcbSerialParams.StopBits=ONESTOPBIT;
							 dcbSerialParams.Parity=NOPARITY;
							 dcbSerialParams.fOutxCtsFlow=0;
							 dcbSerialParams.fDtrControl=DTR_CONTROL_DISABLE;
							 dcbSerialParams.fOutxDsrFlow=0;
							 dcbSerialParams.fDsrSensitivity=0;
							 dcbSerialParams.fOutX=0;
							 dcbSerialParams.fInX=0;
							 dcbSerialParams.fRtsControl=RTS_CONTROL_DISABLE;
							 if(!SetCommState(MyDevice, &dcbSerialParams))
								 {
								 //error setting serial port state
								 }
							 responseString+=": Ok.\r\n";
							 SerialPortConnected=true;
							 if(!GetCommTimeouts(MyDevice, &timeouts))
								 {

								 }
							 timeouts.ReadIntervalTimeout=100;			/* in ms, the maximum time allowed to elapse between the arrival of two bytes on the serial line */ 
							 timeouts.ReadTotalTimeoutMultiplier=5;		/* in ms, the timeout per character */
							 timeouts.ReadTotalTimeoutConstant=500;		/* total timeout in ms for the read operation */
							 timeouts.WriteTotalTimeoutMultiplier=5;	/* in ms, the timeout per character */
							 timeouts.WriteTotalTimeoutConstant=500;	/* total timeout in ms, for the write operation */
							 if (!SetCommTimeouts(MyDevice, &timeouts))
								 {
								 // Error setting time-outs.
								 //responseString+="Timeouts Error!\r\n";
								 }
							 else 
								 {
								 //responseString+="Timeouts Ok...\r\n";
								 }
							 }
						 } 
					 else
						 {
						 /* Already Connected... */
						 responseString="Already Connected!\r\n";
						 return responseString;
						 }
					 return responseString;
					 }

		private : System::Void scanForSerialPorts(void)
					  {
					  System::String^ responseString;
					  unsigned int	MaxSerialPort;
					  unsigned int    i;
					  int			    retries;
					  int				val;
					  int				cancel;

					  this->textBoxLog->ScrollToCaret();
					  this->textBoxLog->AppendText(getPCLocalTimeString()+"Scanning For Valid Serial Ports...\r\n");
					  this->textBoxBoot->ScrollToCaret();
					  this->textBoxBoot->AppendText(getPCLocalTimeString()+"Scanning For Valid Serial Ports...\r\n");

					  SerialPortNumber=localSettings.serialPortNum;
					  MaxSerialPort=MAXIMUM_SERIAL_PORT_NUMBER;
					  stopTimer1();
					  DisconnectSerialPort();
					  this->labelUSBTraffic->Text="COM:";
					  val=this->progressBar1->Minimum;
					  this->progressBar1->Value=val;
					  i=0;
					  cancel=0;
					  while((!cancel)&&(!SerialPortConnected)&&(i<MaxSerialPort))
						  {
						  DisconnectSerialPort();
						  this->labelUSB->ForeColor=NEUTRAL_COLOUR;
						  this->labelUSB->Text=formatStringFloat((double)SerialPortNumber, 0);
						  responseString=ConnectSerialPort();
						  if(SerialPortConnected)
							  {
							  String^ message = "Would You Like To Connect To "+this->SerialPortName+" ?\r\nPress No To Continue Scanning...\r\n";
							  String^ caption = "Warning: Confirm Serial Port Connection";
							  MessageBoxButtons buttons = MessageBoxButtons::YesNoCancel;
							  System::Windows::Forms::DialogResult result;
							  result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING, System::Windows::Forms::MessageBoxDefaultButton::Button2);
							  if (result==::DialogResult::Yes)
								  {
								  this->textBoxLog->ScrollToCaret();
								  this->textBoxLog->AppendText(getPCLocalTimeString()+responseString);
								  this->textBoxBoot->ScrollToCaret();
								  this->textBoxBoot->AppendText(getPCLocalTimeString()+responseString);
								  }
							  else
								  if(result==::DialogResult::No)
									  {
									  SerialPortConnected=false;	
									  if(SerialPortNumber<MaxSerialPort)SerialPortNumber++; else SerialPortNumber=1;
									  }
								  else
									  {
									  SerialPortConnected=false;
									  cancel=1;
									  }
							  }
						  else
							  {
							  if(SerialPortNumber<MaxSerialPort)SerialPortNumber++; else SerialPortNumber=1;
							  }
						  i++;
						  this->progressBar1->Value+=((this->progressBar1->Maximum-this->progressBar1->Minimum)/(MaxSerialPort));
						  Application::DoEvents();
						  }
					  val+=((this->progressBar1->Maximum-this->progressBar1->Minimum)/(MaxSerialPort));
					  if((val>=this->progressBar1->Minimum)&&(val<=this->progressBar1->Maximum))
						  this->progressBar1->Value=val;

					  startTimer1();
					  if(SerialPortConnected)
						  {
						  localSettings.serialPortNum=SerialPortNumber;
						  if((Connection_Status==false)||(enterSerialOrUSBBootLoader(CMD_ENTER_SERIAL_BOOTLOADER)>0))
							  {
							  this->textBoxLog->ScrollToCaret();
							  this->textBoxLog->AppendText(getPCLocalTimeString()+"Entering Serial BootLoader...\r\n");
							  this->textBoxBoot->ScrollToCaret();
							  this->textBoxBoot->AppendText(getPCLocalTimeString()+"Entering Serial BootLoader...\r\n");

							  retries=SerBootRecover(RESYNC_RETRIES);

							  if(retries)
								  {

								  }
							  else
								  {
								  DisconnectSerialPort();
								  }
							  }
						  else
							  {
							  DisconnectSerialPort();
							  } 
						  }
					  else
						  {
						  this->textBoxLog->ScrollToCaret();
						  this->textBoxLog->AppendText(getPCLocalTimeString()+"Failed To Connect!\r\n");
						  this->textBoxBoot->ScrollToCaret();
						  this->textBoxBoot->AppendText(getPCLocalTimeString()+"Failed To Connect!\r\n");

						  }

					  }

		private: System::Void SendPacket(unsigned char* ptr, unsigned int numBytes, unsigned long* numBytesDone, int mode)
					 {
					 DWORD n;

					 if(MyDevice==INVALID_HANDLE_VALUE)
						 {

						 }
					 else
						 {

						 if(mode==1)
							 {
							 while(numBytes--)
								 {
								 WriteFile(MyDevice, ptr, 1, &n, 0);
								 if(n==1)
									 {
									 ptr++;
									 (*numBytesDone)++;
									 //DelayMs(1);
									 }
								 }
							 }
						 else
							 {
							 WriteFile(MyDevice, ptr, numBytes, &n, 0);
							 (*numBytesDone)=n;
							 }
						 }	 
					 }

		private: System::Void FlushPackets(void)
					 {
					 /* Destroy any characters in the queue */
					 unsigned char c;
					 DWORD n;

					 n=1;
					 while(n!=0)ReadFile(MyDevice, &c, 1, &n, 0);
					 }

		private: System::Void GetPacket(unsigned char* ptr, unsigned int numBytes, unsigned long* numBytesDone)
					 {
					 DWORD n;

					 Application::DoEvents();
					 *numBytesDone=0;
					 if(MyDevice==INVALID_HANDLE_VALUE)
						 {

						 }
					 else
						 {

#if(INCREMENTAL_SERIAL)
						 while(numBytes--)
							 {
							 ReadFile(MyDevice, ptr, 1, &n, 0);
							 if(n==1)
								 {
								 ptr++;
								 (*numBytesDone)++;
								 }
							 }
#else 
						 ReadFile(MyDevice, ptr, numBytes, &n, 0);
						 (*numBytesDone)=n;
#endif
						 }
					 }

#else

		private: System::String^ DisconnectSerialPort(System::Void)
					 {
					 String^ responseString;

					 try
						 {
						 SerialPortConnected=this->serialPort1->IsOpen;
						 }
					 catch(...)
						 {

						 }
					 if(SerialPortConnected)
						 {
						 try
							 {
							 this->serialPort1->Close();
							 }
						 catch(...)
							 {

							 }
						 responseString="Disconnecting from "+this->SerialPortName+": Ok.\r\n";
						 }
					 else
						 {
						 responseString="";
						 }
					 SerialPortConnected=this->serialPort1->IsOpen;
					 return responseString;
					 }

		private: System::String^ ConnectSerialPort(System::Void)
					 {
					 String^	 responseString;

					 SerialPortConnected=this->serialPort1->IsOpen; 
					 if(!SerialPortConnected)
						 {
						 responseString="Connecting to ";
						 responseString+=this->SerialPortName;
						 this->serialPort1->PortName=this->SerialPortName;
						 try
							 {
							 this->serialPort1->ReadBufferSize=BW_BLOCK_SIZE;
							 this->serialPort1->WriteBufferSize=BW_BLOCK_SIZE;
							 this->serialPort1->Open();
							 }
						 catch(...)
							 {

							 }
						 SerialPortConnected=this->serialPort1->IsOpen; 
						 if(!SerialPortConnected)
							 {
							 responseString+=": Bad!\r\n";
							 }
						 else
							 {
							 this->serialPort1->BaudRate=baudRt;
							 this->serialPort1->Encoding=System::Text::Encoding::UTF8;
							 this->serialPort1->DataBits=8;
							 this->serialPort1->StopBits=System::IO::Ports::StopBits::One;
							 this->serialPort1->Parity=System::IO::Ports::Parity::None;
							 this->serialPort1->DtrEnable=false;
							 this->serialPort1->RtsEnable=false;
							 this->serialPort1->WriteTimeout=500;
							 this->serialPort1->ReadTimeout=500;
							 responseString+=": Ok.\r\n";
							 SerialPortConnected=true;
							 }
						 } 
					 else
						 {
						 /* Already Connected... */
						 responseString="Already Connected!\r\n";
						 return responseString;
						 }
					 return responseString;
					 }

		private : System::Void scanForSerialPorts(void)
					  {
					  System::String^					responseString;
					  int								MaxSerialPort;
					  int								i;
					  int								j;
					  int								val;
					  int								retries;
					  int								cancel;
					  cli::array<System::String^, 1>^	portNamesArray;

					  this->textBoxLog->ScrollToCaret();
					  this->textBoxLog->AppendText(getPCLocalTimeString()+ "Scanning For Valid Serial Ports...\r\n");

					  this->textBoxBoot->ScrollToCaret();
					  this->textBoxBoot->AppendText(getPCLocalTimeString()+"Scanning For Valid Serial Ports...\r\n");

					  try
						  {
						  SerialPortNumber=localSettings.serialPortNum;
						  MaxSerialPort=this->serialPort1->GetPortNames()->Length;
						  }
					  catch(...)
						  {
						  return;
						  }
					  if(MaxSerialPort>0)
						  {

						  try
							  {
							  portNamesArray=gcnew cli::array<System::String^, 1>(MaxSerialPort);
							  portNamesArray=this->serialPort1->GetPortNames();
							  }
						  catch(...)
							  {
							  return;
							  }
						  i=0;
						  j=0;
						  while(i<MaxSerialPort)
							  {
							  j=(unsigned int)StringToDecimal(portNamesArray[i]);
							  if(j==SerialPortNumber)break;
							  i++;
							  }
						  stopTimer1();

						  DisconnectSerialPort();
						  this->labelUSBTraffic->Text="COM:";
						  val=this->progressBar1->Minimum;
						  this->progressBar1->Value=val;
						  i=0;
						  cancel=0;
						  while((!cancel)&&(!SerialPortConnected)&&(i<MaxSerialPort))
							  {
							  try
								  {
								  DisconnectSerialPort();
								  this->labelUSB->ForeColor=NEUTRAL_COLOUR;
								  this->labelUSB->Text=formatStringFloat((double)SerialPortNumber, 0);
								  this->SerialPortName=portNamesArray[j];
								  SerialPortNumber=(unsigned int)StringToDecimal(this->SerialPortName);
								  if(j<(MaxSerialPort-1))j++; else j=0;	
								  }
							  catch(...)
								  {
								  break;

								  }
							  if((SerialPortNumber>=0)&&(SerialPortNumber<=MAXIMUM_SERIAL_PORT_NUMBER))
								  {

								  responseString=ConnectSerialPort();
								  if(SerialPortConnected)
									  {
									  String^ message = "Would You Like To Connect To "+this->SerialPortName+" ?\r\nPress No To Continue Scanning...\r\n";
									  String^ caption = "Warning: Confirm Serial Port Connection";
									  MessageBoxButtons buttons = MessageBoxButtons::YesNoCancel;

									  System::Windows::Forms::DialogResult result;
									  result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING, System::Windows::Forms::MessageBoxDefaultButton::Button2);
									  if (result==::DialogResult::Yes)
										  {
										  this->textBoxLog->ScrollToCaret();
										  this->textBoxLog->AppendText(getPCLocalTimeString()+responseString);
										  this->textBoxBoot->ScrollToCaret();
										  this->textBoxBoot->AppendText(getPCLocalTimeString()+responseString);
										  }
									  else
										  if(result==::DialogResult::No)
											  {
											  SerialPortConnected=false;	
											  }
										  else
											  {
											  /* Cancel the operation */
											  cancel=1;
											  SerialPortConnected=false;
											  }
									  }
								  else
									  {

									  }
								  }
							  i++;
							  val+=((this->progressBar1->Maximum-this->progressBar1->Minimum)/(MaxSerialPort));
							  if((val>=this->progressBar1->Minimum)&&(val<=this->progressBar1->Maximum))
								  this->progressBar1->Value=val;
							  Application::DoEvents();
							  }
						  this->progressBar1->Value=this->progressBar1->Maximum;
						  startTimer1();
						  if(SerialPortConnected)
							  {
							  localSettings.serialPortNum=SerialPortNumber;
							  if((Connection_Status==false)||(enterSerialOrUSBBootLoader(CMD_ENTER_SERIAL_BOOTLOADER)>0))
								  {
								  this->textBoxLog->ScrollToCaret();
								  this->textBoxLog->AppendText(getPCLocalTimeString()+"Entering Serial BootLoader...\r\n");
								  this->textBoxBoot->ScrollToCaret();
								  this->textBoxBoot->AppendText(getPCLocalTimeString()+"Entering Serial BootLoader...\r\n");

								  retries=SerBootRecover(RESYNC_RETRIES);
								  if(retries)
									  {

									  }
								  else
									  {
									  DisconnectSerialPort();
									  }
								  }
							  else
								  {
								  DisconnectSerialPort();
								  } 
							  }
						  else
							  {
							  this->textBoxLog->ScrollToCaret();
							  this->textBoxLog->AppendText(getPCLocalTimeString()+"Failed To Connect!\r\n");
							  this->textBoxBoot->ScrollToCaret();
							  this->textBoxBoot->AppendText(getPCLocalTimeString()+"Failed To Connect!\r\n");

							  }
						  }
					  }

		private: System::Void SendPacket(unsigned char* ptr, unsigned int numBytes, unsigned long* numBytesDone, int mode)
					 {
					 DWORD n;
					 cli::array<unsigned char, 1>^ buffer;
					 unsigned int i;

					 n=0;
					 if(!SerialPortConnected)
						 {

						 }
					 else
						 {
						 try
							 {
							 buffer=gcnew cli::array<unsigned char, 1>(numBytes);
							 i=0;
							 while(i<numBytes)
								 {
								 buffer[i++]=*ptr++;
								 }
							 this->serialPort1->Write(buffer, 0, numBytes);
							 n=numBytes;
							 }
						 catch(...)
							 {

							 }
						 }
					 (*numBytesDone)=n;

					 }

		private: System::Void FlushPackets(void)
					 {
					 /* Destroy any characters in the queue */

					 cli::array<unsigned char, 1>^ buffer;

					 if(SerialPortConnected)
						 {
						 while(this->serialPort1->BytesToRead)
							 {
							 try
								 {
								 buffer=gcnew cli::array<unsigned char, 1>(this->serialPort1->BytesToRead);
								 this->serialPort1->Read(buffer, 0, this->serialPort1->BytesToRead);
								 }
							 catch(...)
								 {
								 break;
								 }
							 }
						 }
					 }

		private: System::Void GetPacket(unsigned char* ptr, unsigned int numBytes, unsigned long* numBytesDone)
					 {
					 DWORD n;
					 cli::array<unsigned char, 1>^ buffer;
					 unsigned int i;

					 Application::DoEvents();
					 n=0;
					 if(!SerialPortConnected)
						 {

						 }
					 else
						 {
						 buffer=gcnew cli::array<unsigned char, 1>(1);
						 i=0;
						 while(i<numBytes)
							 {
							 try
								 {
								 this->serialPort1->Read(buffer, 0, 1);
							  }
							 catch(...)
							  {
							  break;
							  } 
							 *ptr++=buffer[0];
							 n++;
							 i++;
							 }
						 }
					 *numBytesDone=n;
					 }

#endif

		private: int SerBootDead(void)
					 {
					 unsigned char outPacket[16];
					 unsigned char inPacket[16];
					 unsigned long total;

					 /* returns 1 if there is no serial bootloader response! */
					 if(SerialPortConnected)
						 {
						 outPacket[0]=CMD_BW_RESYNC;
						 inPacket[0]=0;
						 SendPacket(&outPacket[0], 1, &total, BW_SERIAL_MODE);
						 GetPacket(&inPacket[0], 1, &total);
						 if(total==1)
							 {

							 }
						 else
							 {
							 return 1;
							 }
						 }
					 return 0;
					 }

		private: int SerBootReset(void)
					 {
					 /* returns 1 if ok... */

					 unsigned char outPacket[16];
					 unsigned char inPacket[16];
					 unsigned long total;

					 if(SerialPortConnected)
						 {
						 outPacket[0]=CMD_BW_BOOT_RESET;
						 inPacket[0]=0;
						 SendPacket(&outPacket[0], 1, &total, BW_SERIAL_MODE);
						 GetPacket(&inPacket[0], 1, &total);
						 if(total==1)
							 {
							 return 1;
							 }
						 else
							 {

							 }
						 }
					 return 0;
					 }

		private: int SerBootRecover(int retries)
					 {

					 /* 
					 Resync the serial bootloader client so that it ends up waiting for a command 

					 The serial bootloader echoes back the MAGIC_BYTE_COMMAND_ECHO...

					 Returns non zero if successful, zero otherwise...
					 */

					 unsigned char   outPacket[16];
					 unsigned char   inPacket[16];
					 int			    result;
					 unsigned long   total;
					 int				i;
					 int				totalRetries;
					 bool			flag;

					 totalRetries=retries;
					 result=0;
					 if(SerialPortConnected)
						 {
						 flag=this->timer1->Enabled;
						 stopTimer1();
						 FlushPackets();
						 this->labelUSBTraffic->Text="SYNC:";
						 i=0;
						 this->progressBar1->Value=this->progressBar1->Minimum;
						 this->labelUSB->ForeColor=NEUTRAL_COLOUR;
						 while((result==0)&&(retries>0))
							 {
							 this->labelUSB->Text=formatStringFloat((double)i, 0);
							 i++;
							 Application::DoEvents();
							 outPacket[0]=CMD_BW_RESYNC;
							 inPacket[0]=0;
							 SendPacket(&outPacket[0], 1, &total, BW_SERIAL_MODE);
							 GetPacket(&inPacket[0], 1, &total);
							 if((total==1)&&(inPacket[0]==MAGIC_BYTE_COMMAND_ECHO))
								 {
								 result=1;
								 }
							 this->progressBar1->Value+=(this->progressBar1->Maximum-this->progressBar1->Minimum)/(totalRetries);
							 retries--;
							 }
						 this->progressBar1->Value=this->progressBar1->Maximum;
						 if(retries)
							 {
							 // this->textBoxBoot->ScrollToCaret();
							 // this->textBoxLog->ScrollToCaret();
							 // this->textBoxBoot->AppendText(getPCLocalTimeString()+"Resync Ok ("+formatStringFloat((double)RESYNC_RETRIES-retries, 0)+")...\r\n");
							 // this->textBoxLog->AppendText(getPCLocalTimeString()+"Resync Ok ("+formatStringFloat((double)RESYNC_RETRIES-retries, 0)+")...\r\n");
							 this->labelUSB->Text="OK";
							 this->labelUSB->ForeColor=OK_DARK_COLOUR;

							 }
						 else
							 {
							 this->textBoxBoot->ScrollToCaret();
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Resynchronisation Failed! Check Your Serial Connection...\r\n");
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Resynchronisation Failed! Check Your Serial Connection...\r\n");
							 this->labelUSB->Text="BAD";
							 this->labelUSB->ForeColor=BAD_DARK_COLOUR;
							 //DisconnectSerialPort();					 
							 }	
						 if(flag)startTimer1();
						 result=retries;
						 }
					 return result;
					 }

		private: int SerBootSendFlashAddresses(unsigned long startAddress, unsigned long endAddress, int recovery)
					 {
					 unsigned char  outPacket[16];
					 unsigned char  inPacket[16];
					 int			   result;
					 unsigned char* ptr;
					 unsigned long  total;
					 int			   retries;
					 bool		   flag;

					 result=0;
					 if(SerialPortConnected)
						 {
						 flag=this->timer1->Enabled;
						 stopTimer1();
						 if(recovery)retries=SerBootRecover(RESYNC_RETRIES); else retries=1;
						 if(retries)
							 {		
							 outPacket[0]=CMD_BW_SET_FLASH_ADDRESS;
							 ptr=(unsigned char*)&startAddress;
							 outPacket[1]=*ptr++;
							 outPacket[2]=*ptr++;
							 outPacket[3]=*ptr++;
							 outPacket[4]=*ptr++;
							 SendPacket(&outPacket[0], 5, &total, BW_SERIAL_MODE);
							 GetPacket(&inPacket[0], 5, &total);
							 if(total==5)
								 {
								 if(compareMemory(&outPacket[1], &inPacket[1], (total-1)))
									 {
									 outPacket[0]=CMD_BW_SET_END_ADDRESS;
									 ptr=(unsigned char*)&endAddress;
									 outPacket[1]=*ptr++;
									 outPacket[2]=*ptr++;
									 outPacket[3]=*ptr++;
									 outPacket[4]=*ptr++;
									 SendPacket(&outPacket[0], 5, &total, BW_SERIAL_MODE);
									 GetPacket(&inPacket[0], 5, &total);
									 if(total==5)
										 {
										 if(compareMemory(&outPacket[1], &inPacket[1], (total-1)))
											 {
											 result=1;
											 }
										 }
									 }

								 }
							 }
						 if(flag)startTimer1();
						 }
					 return result;
					 }

		private : unsigned long SerBootReadProgramMemory(unsigned long startAddress, unsigned long endAddress, unsigned char* output, System::Windows::Forms::ToolStripProgressBar^ progress)
					  {
					  unsigned char  outPacket[16];
					  unsigned char  inPacket[16];
					  unsigned long  total;
					  unsigned long  done;
					  unsigned long  packetDone;
					  unsigned long  packetBlockSize;
					  double		   increment;
					  double         prog;
					  unsigned long  t;
					  bool		   flag;

					  done=0;
					  if(SerialPortConnected)
						  {
						  flag=this->timer1->Enabled;
						  stopTimer1();
						  total=(endAddress-startAddress);
						  packetBlockSize=BW_BLOCK_SIZE;
						  progress->Value=progress->Minimum;
						  this->labelUSBTraffic->Text="SER:";
						  prog=(double)progress->Minimum;
						  if(total>0)
							  increment=(double)((double)progress->Maximum-(double)progress->Minimum)/(double)total;
						  else 
							  increment=1;

						  while(startAddress<endAddress)
							  {
							  if(total>packetBlockSize)
								  {

								  }
							  else
								  {
								  packetBlockSize=total;						
								  }

							  packetDone=0;
							  if(SerBootSendFlashAddresses(startAddress, startAddress+packetBlockSize, 0))
								  {
								  outPacket[0]=CMD_BW_READ_MEMORY;
								  SendPacket(&outPacket[0], 1, &t, BW_SERIAL_MODE);
								  GetPacket(&inPacket[0], 1, &t);
								  if((t==1)&&(inPacket[0]==MAGIC_BYTE_COMMAND_ECHO))
									  {
									  GetPacket(output, packetBlockSize, &packetDone);
									  }
								  }
							  output+=packetDone;
							  if(packetDone==0)break;
							  prog+=(increment*(double)packetDone);
							  if((((int)prog)>=progress->Minimum)&&(((int)prog)<=progress->Maximum))progress->Value=(int)prog;								
							  startAddress+=packetDone;
							  done+=packetDone;
							  total-=packetDone;
							  this->labelUSB->Text=formatStringFileSize((double)done);
							  this->labelUSB->ForeColor=NEUTRAL_COLOUR;
							  Application::DoEvents();
							  }
						  if(startAddress<endAddress)this->labelUSB->ForeColor=BAD_DARK_COLOUR;
						  progress->Value=progress->Maximum;
						  if(flag)startTimer1();
						  }
					  this->labelUSB->Text=formatStringFileSize((double)done);
					  return done;
					  }

		private : unsigned long SerBootWriteProgramMemory(unsigned long startAddress, unsigned long endAddress, unsigned char* input, System::Windows::Forms::ToolStripProgressBar^ progress)
					  {
					  unsigned char  outPacket[16];
					  unsigned char  inPacket[BW_BLOCK_SIZE];
					  unsigned long  total;
					  unsigned long  done;
					  unsigned long  packetDone;
					  unsigned long  packetBlockSize;
					  double		   increment;
					  double         prog;
					  unsigned long  t;
					  bool		   flag;

					  done=0;
					  if(SerialPortConnected)
						  {
						  flag=this->timer1->Enabled;
						  stopTimer1();
						  total=(endAddress-startAddress);
						  packetBlockSize=BW_BLOCK_SIZE_WRITE;
						  progress->Value=progress->Minimum;
						  this->labelUSBTraffic->Text="SER:";
						  prog=(double)progress->Minimum;

						  if(total>0)
							  increment=(double)((double)progress->Maximum-(double)progress->Minimum)/(double)total;
						  else 
							  increment=1;

						  if(SerBootSendFlashAddresses(startAddress, startAddress+packetBlockSize, 0))
							  {

							  while(startAddress<endAddress)
								  {
								  if(total>packetBlockSize)
									  {


									  }
								  else
									  {
									  packetBlockSize=total;						
									  }

								  packetDone=0;
								  outPacket[0]=CMD_BW_WRITE_MEMORY;
								  SendPacket(&outPacket[0], 1, &t, BW_SERIAL_MODE);
								  GetPacket(&inPacket[0], 1, &t);
								  if((t==1)&&(inPacket[0]==MAGIC_BYTE_COMMAND_ECHO))
									  {
									  SendPacket(input, packetBlockSize, &packetDone, BW_SERIAL_MODE);
									  GetPacket(&inPacket[0], 1, &t);
									  if(t==1)
										  {

										  }
									  else
										  {
										  break;
										  }
									  }
								  else
									  {
									  break;
									  }

								  input+=packetDone;
								  if(packetDone==0)break;
								  prog+=(increment*(double)packetDone);
								  if((((int)prog)>=progress->Minimum)&&(((int)prog)<=progress->Maximum))progress->Value=(int)prog;								
								  startAddress+=packetDone;
								  done+=packetDone;
								  total-=packetDone;
								  this->labelUSB->Text=formatStringFileSize((double)done);
								  this->labelUSB->ForeColor=NEUTRAL_COLOUR;
								  Application::DoEvents();
								  }

							  }
						  if(startAddress<endAddress)this->labelUSB->ForeColor=BAD_DARK_COLOUR;
						  progress->Value=progress->Maximum;
						  if(flag)startTimer1();
						  }
					  return done;
					  }

		private : unsigned long SerBootEraseProgramMemory(unsigned long startAddress, unsigned long endAddress)
					  {
					  unsigned char  outPacket[16];
					  unsigned char  inPacket[16];
					  unsigned long  total;
					  unsigned long  done;
					  bool		   flag;

					  done=0;
					  if(SerialPortConnected)
						  {
						  flag=this->timer1->Enabled;
						  stopTimer1();
						  if(endAddress>startAddress)
							  {
							  if(SerBootSendFlashAddresses(startAddress, endAddress, 1))
								  {
								  outPacket[0]=CMD_BW_ERASE_MEMORY;
								  SendPacket(&outPacket[0], 1, &total, BW_SERIAL_MODE);
								  GetPacket(&inPacket[0], 1, &total);
								  if((total==1)&&(inPacket[0]==MAGIC_BYTE_COMMAND_ECHO))
									  {
									  done=endAddress-startAddress;
									  total=0;
									  while(total!=1)
										  {
										  GetPacket(&inPacket[0], 1, &total);
										  }
									  }
								  }
							  }
						  if(SerBootRecover(RESYNC_RETRIES))
							  {

							  }
						  else
							  {
							  done=0;
							  }
						  if(flag)startTimer1();
						  }
					  return done;
					  }		 

		private : unsigned long SerBootWriteWordProgramMemory(unsigned long startAddress, unsigned short data, int setAddressFirst)
					  {

					  unsigned char  outPacket[16];
					  unsigned char  inPacket[16];
					  unsigned long  done;
					  unsigned long  t;
					  bool		   flag;

					  done=0;
					  if(SerialPortConnected)
						  {
						  flag=this->timer1->Enabled;
						  stopTimer1();

						  if((!setAddressFirst)||(SerBootSendFlashAddresses(startAddress, startAddress, 0)))
							  {
							  outPacket[0]=CMD_BW_WRITE_WORD;
							  SendPacket(&outPacket[0], 1, &t, BW_SERIAL_MODE);
							  GetPacket(&inPacket[0], 1, &t);
							  if((t==1)&&(inPacket[0]==MAGIC_BYTE_COMMAND_ECHO))
								  {
								  outPacket[1]=(unsigned char)(data & 0xFF);
								  outPacket[2]=(unsigned char)(data>>8);
								  SendPacket(&outPacket[1], 2, &t, BW_SERIAL_MODE);
								  GetPacket(&inPacket[0], 1, &t);
								  if(t==1)
									  {
									  done=2;
									  }
								  }
							  }
						  if(flag)startTimer1();
						  }
					  return done;
					  }

				  void startStopGUI(bool value)
					  {
					  System::Windows::Forms::ToolStripItemCollection^ col;
					  array<System::Windows::Forms::ToolStripMenuItem^, 1>^ mItems=
						  {
						  this->toolStripMenuItem1,
						  this->toolStripMenuItem2,
						  this->DeviceMenu,
						  this->runToolStripMenuItem,
						  this->runDevicetoolStripMenuItem,
						  this->memoryToolStripMenuItem,
						  this->memoryCardToolStripMenuItem,
						  this->timeToolStripMenuItem,
						  this->toolStripMenuItem3,
						  this->aboutToolStripMenuItem
						  };
					  int i;
					  int j;

					  this->treeViewFiles->Enabled=value;
					  this->treeViewPCFiles->Enabled=value;
					  this->treeViewScripts->Enabled=value;
					  this->treeViewPCScripts->Enabled=value;

					  j=0;
					  while(j<mItems->Length)
						  {

						  mItems[j]->Enabled=value;
						  col=mItems[j]->DropDownItems;
						  i=0;
						  while(i<col->Count)
							  {
							  col[i]->Enabled=value;				
							  i++;
							  }
						  j++;
						  }
					  this->groupBoxSettings->Enabled=value;
					  this->groupBoxHost->Enabled=value;
					  this->checkBoxShowMemory->Enabled=value;
					  setButtons(value);
					  guiStopped=!value;
					  }

				  void stopGUI(void)
					  {
					  startStopGUI(false);
					  }

				  void startGUI(void)
					  {

					  }

				  void startTimer1(void)
					  {
					  startGUI();
					  timer1->Start();
					  }

				  void stopTimer1(void)
					  {
					  timer1->Stop();
					  timerCounter1=(SLOW_UPDATE_PERIOD_RECOVERY_MS/timer1->Interval);
					  stopGUI();
					  }

				  int ConnectedUser(void)
					  {
					  if((Connection_Status)&&(bootLoaderStatus==0))
						  {
						  return 1;
						  }
					  return 0;			
					  }

				  int usb_bulk_write_app(usb_dev_handle *dev, int ep, unsigned char *bytes, int size, int timeout)
					  {
					  int n;
					  n=0;

					  if(Connection_Status)
						  {
#if(USE_MUTEX_USB)
						  semaphoreUSB->WaitOne();
#endif
						  n=usb_bulk_write(dev, ep, (char*)bytes, size, timeout);
						  totalUSBBytesWrite+=n;
						  totalUSBWrites++;
#if(USE_MUTEX_USB)
						  semaphoreUSB->Release();
#endif
						  }
					  return n;
					  }

				  int usb_bulk_read_app(usb_dev_handle *dev, int ep, unsigned char *bytes, int size, int timeout)
					  {
					  int n;
					  n=0;
					  if(Connection_Status)
						  {
#if(USE_MUTEX_USB)
						  semaphoreUSB->WaitOne();
#endif
						  n=usb_bulk_read(dev, ep, (char*)bytes, size, timeout);
						  totalUSBBytesRead+=n;
						  totalUSBReads++;
#if(USE_MUTEX_USB)
						  semaphoreUSB->Release();
#endif
						  }
					  return n;
					  }

				  int saveLocalSettings(LOCAL_SETTINGS* lS, System::String^ fileName)
					  {
					  unsigned char	CRC;
					  unsigned int	done;
					  int			i;
					  unsigned char* ptr;

					  CRC=0;
					  ptr=(unsigned char*)lS;
					  i=0;
					  while(i<(sizeof(LOCAL_SETTINGS)-1))
						  {
						  CRC^=(*ptr);
						  ptr++;
						  i++;
						  }
					  lS->CRC=CRC;
					  WriteFile(fileName, 0, (unsigned char*)lS, sizeof(LOCAL_SETTINGS), &done);			
					  if(lS->persistentLog)
						  {
						  (void)WriteFileFromString(LOCAL_SYS_LOG_TXT, this->textBoxLog->Text);
						  }
					  else
						  {

						  }

					  return done;
					  }

				  int restoreLocalSettings(LOCAL_SETTINGS* lS, System::String^ fileName, int* loadDefaults)
					  {
					  unsigned int	done;
					  unsigned char	CRC;
					  int			i;
					  unsigned char* ptr;

					  ReadFile(fileName, 0, (unsigned char*)lS, sizeof(LOCAL_SETTINGS), &done);
					  *loadDefaults=0;
					  if(done==sizeof(LOCAL_SETTINGS))
						  {
						  /* Now Check CRC! */
						  CRC=0;
						  ptr=(unsigned char*)lS;
						  i=0;
						  while(i<(sizeof(LOCAL_SETTINGS)))
							  {
							  CRC^=(*ptr);
							  ptr++;
							  i++;
							  }

						  if(CRC==0)
							  {
							  /* Ok. */
							  }
						  else
							  {
							  *loadDefaults=1;
							  }	 
						  }
					  else
						  {
						  *loadDefaults=1;
						  }

					  if(*loadDefaults)
						  {
						  done=setDefaultsLocalSettings(lS);	 
						  }	 


					  if(lS->persistentLog)
						  {
						  this->textBoxLog->Clear();
						  this->textBoxLog->Text=ReadStringFromFile(LOCAL_SYS_LOG_TXT);
						  this->textBoxLog->ScrollToCaret();	 
						  }
					  else
						  {

						  }



					  return done;
					  }

				  int setDefaultsLocalSettings(LOCAL_SETTINGS* lS)
					  {
					  lS->checkDeletes=1;
					  lS->wideEditorWindow=0;
					  lS->verboseMode=1;
					  lS->persistentLog=0;
					  lS->timeShowMode=1;
					  lS->lastSyncDuration=0;
					  lS->voltageShowMode=0;
					  lS->fontSize=9.75;
					  lS->optimizeCode=1;
					  lS->lastSyncDifference=0;
					  lS->timeSpeed=1.0;
					  lS->timeOffset=0;
					  lS->timeScaling=0;
					  lS->effectiveSpeed=lS->timeSpeed;
					  lS->timeHostStarted.updated=0;
					  lS->timeHostStarted.show=(SHOW_YEAR | SHOW_MONTH | SHOW_DAY | SHOW_HOURS | SHOW_MINUTES | SHOW_SECONDS);
					  lS->timeHostStarted.year=2010;
					  lS->timeHostStarted.month=1;;
					  lS->timeHostStarted.day=1;
					  lS->timeHostStarted.hours=0;
					  lS->timeHostStarted.mins=0;
					  lS->timeHostStarted.secs=0;
					  lS->serialPortNum=0;
					  return sizeof(LOCAL_SETTINGS);
					  }

				  int deleteFileDialogBox(System::String^ message, System::String^ caption, int* cancel)
					  {

					  return 0;
					  }

				  int setWideEditorWindow(unsigned char onoff)
					  {
					  if(this->textBoxInput1->Visible)
						  {
						  if(onoff)
							  {
							  this->label1->Visible=false;
							  this->label2->Visible=false;
							  this->treeViewFiles->Visible=false;
							  this->treeViewPCFiles->Visible=false;
							  this->textBoxInput1->Size=System::Drawing::Size(840, 440);
							  this->textBoxLog->ScrollToCaret();
							  if(wideeditorwindow!=1)
								  {
								  this->textBoxLog->AppendText(getPCLocalTimeString()+"Wide Editor Window Enabled.\r\n");
								  wideeditorwindow=1;
								  }
							  }
						  else
							  {
							  this->textBoxInput1->Size=System::Drawing::Size(640, 440);
							  this->label1->Visible=true;
							  this->label2->Visible=true;
							  this->treeViewFiles->Visible=true;
							  this->treeViewPCFiles->Visible=true;
							  this->textBoxLog->ScrollToCaret();
							  if(wideeditorwindow!=0)
								  {
								  this->textBoxLog->AppendText(getPCLocalTimeString()+"Wide Editor Window Disabled.\r\n");
								  wideeditorwindow=0;
								  }
							  }
						  }
					  else
						  {
						  this->label1->Visible=false;
						  this->label2->Visible=false;
						  this->treeViewFiles->Visible=false;
						  this->treeViewPCFiles->Visible=false;
						  }
					  return onoff;
					  }

				  int initLocalSettings(LOCAL_SETTINGS* lS, System::String^ fileName)
					  {
					  int			  defaults;
					  TIME_T		  now;

					  restoreLocalSettings(lS, fileName, &defaults);
					  updateLocalSettings(lS);
					  avgInit(&lS->relError, AVGS);
					  getTime(&now);
					  lS->timeOffset=getTotalSeconds(&now);
					  return 1;
					  }

				  int restoreDefaultsLocalSettings(LOCAL_SETTINGS* lS, System::String^ fileName)
					  {
					  (void)setDefaultsLocalSettings(lS);
					  updateLocalSettings(lS);
					  return saveLocalSettings(lS, fileName);
					  }

				  void updateLocalSettings(LOCAL_SETTINGS* lS)
					  {
					  System::Decimal x;
					  this->textBoxInput1->Font = (gcnew System::Drawing::Font(L"Lucida Console", localSettings.fontSize, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
						  static_cast<System::Byte>(0)));
					  if(lS->optimizeCode)this->checkBoxOptimize->Checked=true; else this->checkBoxOptimize->Checked=false;
					  x=(System::Decimal)lS->timeSpeed;
					  if((x>=this->numericUpDownTimeSpeed->Minimum)&&(x<=this->numericUpDownTimeSpeed->Maximum))this->numericUpDownTimeSpeed->Value=x;
					  if(lS->timeScaling)this->checkBoxSpeed->Checked=true;
					  else this->checkBoxSpeed->Checked=false;
					  if(lS->verboseMode)this->checkBoxVerbose->Checked=true; else this->checkBoxVerbose->Checked=false;
					  if(lS->persistentLog)this->checkBoxPersistentLog->Checked=true; else this->checkBoxPersistentLog->Checked=false;
					  if(lS->checkDeletes)this->checkBoxConfirmAllDelete->Checked=true; else this->checkBoxConfirmAllDelete->Checked=false;
					  getTime(&lS->timeHostStarted);
					  setWideEditorWindow(lS->wideEditorWindow);
					  }

				  std::string getSerialUSBBuffer(unsigned char* getStatus)
					  {
					  std::string     response;
					  USB_PACKET		OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET		InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					  unsigned short	u;
					  unsigned char*  ptr;
					  unsigned char	status;

					  response="";
					  if(ConnectedUser())
						  {
						  OutputPacketBuffer.data[0]=(unsigned char)CMD_GET_SERIAL_USB_BUFFER;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
							  {
							  return response;
							  }
						  //Now get the response packet from the firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
							  {
							  return response;
							  }

						  u=(unsigned short)InputPacketBuffer.data[2];
						  u+=(unsigned short)((unsigned short)InputPacketBuffer.data[3]<<8);
						  status=InputPacketBuffer.data[1];
						  *getStatus=status;
						  if(u>MAX_SERIAL_PIPE_UNIT_LENGTH)u=MAX_SERIAL_PIPE_UNIT_LENGTH;
						  ptr=(unsigned char*)&InputPacketBuffer.data[4];
						  while(u>0)
							  {
							  response+=(*ptr);
							  ptr++;
							  u--;
							  }

						  if(status & SERIAL_PIPE_OVERFLOW)
							  {
							  response+=" ... ";

							  }

						  if(status & SERIAL_PIPE_UNDERFLOW)
							  {

							  }

						  }
					  return response;
					  }

				  int initSerialUSB(int x)
					  {
					  /* returns 1 if ok, 0 otherwise */

					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer;
					  if(ConnectedUser())
						  {

						  OutputPacketBuffer.data[0]= CMD_INIT_SERIAL_USB_BUFFER;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }

						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  return 1;
						  } else
							  return 0;
					  }

				  int setFirstPor(int x)
					  {
					  /* returns -1 if no device connected, else returns the value of captiveDevice */

					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer;
					  if(ConnectedUser())
						  {
						  OutputPacketBuffer.data[0]= CMD_SET_FIRST_POR;
						  OutputPacketBuffer.data[1]=(unsigned char)x;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return -1;
							  }

						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return -1;
							  }
						  x=(int)InputPacketBuffer.data[1];
						  return x;
						  } else
							  return -1;
					  }

				  int setCaptiveDevice(int x)
					  {
					  /* returns -1 if no device connected, else returns the value of captiveDevice */

					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer;
					  if(ConnectedUser())
						  {
						  OutputPacketBuffer.data[0]= CMD_SET_CAPTIVE_DEVICE;
						  OutputPacketBuffer.data[1]=(unsigned char)x;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return -1;
							  }

						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return -1;
							  }
						  x=(int)InputPacketBuffer.data[1];
						  return x;
						  } else
							  return -1;
					  }

				  int setCaptiveDeviceQuick(int x)
					  {
					  /* returns -1 if no device connected, else returns the value of captiveDevice */

					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer;
					  if(ConnectedUser())
						  {
						  OutputPacketBuffer.data[0]= CMD_SET_CAPTIVE_DEVICE;
						  OutputPacketBuffer.data[1]=(unsigned char)x;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
							  {
							  return -1;
							  }

						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
							  {
							  return -1;
							  }
						  x=(int)InputPacketBuffer.data[1];
						  return x;
						  } else
							  return -1;
					  }

				  int connectGUIBootLoaderStatus(int bootStatus)
					  {
					  bool value;

					  if(bootStatus)
						  {
						  value=true;

						  /* User Mode */
						  this->clearLog->Visible=!value;
						  this->clearLog->Enabled=!value;

						  this->textBoxInput1->Visible=!value;
						  this->textBoxInput1->Enabled=!value;					
						  setWideEditorWindow(localSettings.wideEditorWindow);

						  this->checkBoxOptimize->Visible=!value;
						  this->checkBoxOptimize->Enabled=!value;
						  this->toolStripMenuItem1->Visible=!value;
						  this->toolStripMenuItem1->Enabled=!value;
						  this->toolStripMenuItem2->Visible=!value;
						  this->toolStripMenuItem2->Enabled=!value;
						  this->DeviceMenu->Visible=!value;
						  this->DeviceMenu->Enabled=!value;
						  this->runToolStripMenuItem->Visible=!value;
						  this->runToolStripMenuItem->Enabled=!value;
						  this->runDevicetoolStripMenuItem->Visible=!value;
						  this->runDevicetoolStripMenuItem->Enabled=!value;
						  this->aboutToolStripMenuItem->Visible=!value;
						  this->aboutToolStripMenuItem->Enabled=!value;
						  this->memoryCardToolStripMenuItem->Visible=!value;
						  this->memoryCardToolStripMenuItem->Enabled=!value;
						  this->memoryToolStripMenuItem->Visible=!value;
						  this->memoryToolStripMenuItem->Enabled=!value;
						  this->timeToolStripMenuItem->Visible=!value;
						  this->timeToolStripMenuItem->Enabled=!value;
						  this->toolStripMenuItem3->Visible=!value;
						  this->toolStripMenuItem3->Enabled=!value;
						  this->groupBoxHost->Visible=!value;
						  this->groupBoxHost->Enabled=!value;
						  this->groupBoxSettings->Visible=!value;
						  this->groupBoxSettings->Enabled=!value;
						  this->treeViewHelp->Visible=!value;
						  this->treeViewHelp->Enabled=!value;
						  this->treeViewScripts->Visible=!value;
						  this->treeViewScripts->Enabled=!value;
						  this->treeViewPCScripts->Visible=!value;
						  this->treeViewPCScripts->Enabled=!value;
						  this->buttonCompileFile->Visible=!value;
						  this->buttonCompileFile->Enabled=!value;
						  this->buttonCancel->Visible=!value;
						  this->buttonCancel->Enabled=!value;

						  this->buttonRunVM->Visible=!value;
						  this->buttonRunVM->Enabled=!value;
						  this->buttonStop->Visible=!value;
						  this->buttonStop->Enabled=!value;
						  this->buttonReset->Visible=!value;
						  this->buttonReset->Enabled=!value;
						  this->buttonStep->Visible=!value;
						  this->buttonStep->Enabled=!value;

						  this->labelHelp->Visible=!value;
						  this->labelHelp->Enabled=!value;
						  this->labelLastTime->Visible=!value;
						  this->labelLastTime->Enabled=!value;
						  this->labelLastTimeSynced->Visible=!value;
						  this->labelLastTimeSynced->Enabled=!value;
						  this->labelTimeDevice->Visible=!value;
						  this->labelTimeDevice->Enabled=!value;
						  this->labelVDD->Visible=!value;
						  this->labelVDD->Enabled=!value;
						  this->labelVoltage->Visible=!value;
						  this->labelVoltage->Enabled=!value;
						  this->labelMemory->Visible=!value;
						  this->labelMemory->Enabled=!value;
						  this->labelMemoryAt->Visible=!value;
						  this->labelMemoryAt->Enabled=!value;
						  this->labelTimeFromDeviceX->Visible=!value;
						  this->labelTimeFromDeviceX->Enabled=!value;
						  this->checkBoxShowMemory->Visible=!value;
						  this->checkBoxShowMemory->Enabled=!value;
						  this->numericUpDownMemoryOffset->Visible=!value;
						  this->numericUpDownMemoryOffset->Enabled=!value;

						  this->textBoxSerialUSB->Visible=!value;
						  this->textBoxSerialUSB->Enabled=!value;
						  this->buttonClearConsole->Visible=!value;
						  this->buttonClearConsole->Enabled=!value;

						  this->dataGridView1->Visible=!value;
						  this->dataGridView1->Enabled=!value;

						  this->textBoxDebug->Enabled=!value;
						  this->textBoxDebug->Visible=!value;

						  this->textBoxLog->Visible=!value;
						  this->textBoxLog->Enabled=!value;

						  this->checkBoxVerbose->Visible=!value;
						  this->checkBoxVerbose->Enabled=!value;

						  /* Boot Mode */	

						  this->buttonReadMemory->Visible=value;
						  this->buttonReadMemory->Enabled=value;
						  this->buttonEraseMemory->Visible=value;
						  this->buttonEraseMemory->Enabled=value;
						  this->buttonWriteMemory->Visible=value;
						  this->buttonWriteMemory->Enabled=value;
						  this->buttonWriteBin->Visible=value;
						  this->buttonWriteBin->Enabled=value;
						  this->textBoxBoot->Visible=value;
						  this->textBoxBoot->Enabled=value;
						  this->buttonClearBootLog->Visible=value;
						  this->buttonClearBootLog->Enabled=value;

						  this->Size=System::Drawing::Size(720, 800);
						  this->Refresh();

						  }
					  else
						  {

						  this->Size=System::Drawing::Size(1280, 800);
						  this->Refresh();

						  value=false;

						  /* Boot Mode */	

						  this->buttonReadMemory->Visible=value;				
						  this->buttonReadMemory->Enabled=value;
						  this->buttonEraseMemory->Visible=value;
						  this->buttonEraseMemory->Enabled=value;
						  this->buttonWriteMemory->Visible=value;
						  this->buttonWriteMemory->Enabled=value;
						  this->buttonWriteBin->Visible=value;
						  this->buttonWriteBin->Enabled=value;
						  this->textBoxBoot->Visible=value;
						  this->textBoxBoot->Enabled=value;
						  this->buttonClearBootLog->Visible=value;
						  this->buttonClearBootLog->Enabled=value;

						  /* User Mode */

						  this->clearLog->Visible=!value;
						  this->clearLog->Enabled=!value;
						  this->textBoxInput1->Visible=!value;
						  this->textBoxInput1->Enabled=!value;
						  setWideEditorWindow(localSettings.wideEditorWindow);


						  this->checkBoxOptimize->Visible=!value;
						  this->checkBoxOptimize->Enabled=!value;
						  this->toolStripMenuItem1->Visible=!value;
						  this->toolStripMenuItem1->Enabled=!value;
						  this->toolStripMenuItem2->Visible=!value;
						  this->toolStripMenuItem2->Enabled=!value;
						  this->DeviceMenu->Visible=!value;
						  this->DeviceMenu->Enabled=!value;
						  this->runToolStripMenuItem->Visible=!value;
						  this->runToolStripMenuItem->Enabled=!value;
						  this->runDevicetoolStripMenuItem->Visible=!value;
						  this->runDevicetoolStripMenuItem->Enabled=!value;
						  this->aboutToolStripMenuItem->Visible=!value;
						  this->aboutToolStripMenuItem->Enabled=!value;
						  this->memoryCardToolStripMenuItem->Visible=!value;
						  this->memoryCardToolStripMenuItem->Enabled=!value;
						  this->memoryToolStripMenuItem->Visible=!value;
						  this->memoryToolStripMenuItem->Enabled=!value;
						  this->timeToolStripMenuItem->Visible=!value;
						  this->timeToolStripMenuItem->Enabled=!value;
						  this->toolStripMenuItem3->Visible=!value;
						  this->toolStripMenuItem3->Enabled=!value;
						  this->groupBoxHost->Visible=!value;
						  this->groupBoxHost->Enabled=!value;
						  this->groupBoxSettings->Visible=!value;
						  this->groupBoxSettings->Enabled=!value;
						  this->treeViewHelp->Visible=!value;
						  this->treeViewHelp->Enabled=!value;
						  this->treeViewScripts->Visible=!value;
						  this->treeViewScripts->Enabled=!value;
						  this->treeViewPCScripts->Visible=!value;
						  this->treeViewPCScripts->Enabled=!value;
						  this->buttonCompileFile->Visible=!value;
						  this->buttonCompileFile->Enabled=!value;
						  this->buttonRunVM->Visible=!value;
						  this->buttonRunVM->Enabled=!value;
						  this->buttonStop->Visible=!value;
						  this->buttonStop->Enabled=!value;
						  this->buttonReset->Visible=!value;
						  this->buttonReset->Enabled=!value;
						  this->buttonStep->Visible=!value;
						  this->buttonStep->Enabled=!value;
						  this->labelHelp->Visible=!value;
						  this->labelHelp->Enabled=!value;
						  this->labelLastTime->Visible=!value;
						  this->labelLastTime->Enabled=!value;
						  this->labelLastTimeSynced->Visible=!value;
						  this->labelLastTimeSynced->Enabled=!value;
						  this->labelTimeDevice->Visible=!value;
						  this->labelTimeDevice->Enabled=!value;
						  this->labelVDD->Visible=!value;
						  this->labelVDD->Enabled=!value;
						  this->labelVoltage->Visible=!value;
						  this->labelVoltage->Enabled=!value;
						  this->labelMemory->Visible=!value;
						  this->labelMemory->Enabled=!value;
						  this->labelMemoryAt->Visible=!value;
						  this->labelMemoryAt->Enabled=!value;
						  this->labelTimeFromDeviceX->Visible=!value;
						  this->labelTimeFromDeviceX->Enabled=!value;
						  this->checkBoxShowMemory->Visible=!value;
						  this->checkBoxShowMemory->Enabled=!value;
						  this->textBoxSerialUSB->Visible=!value;
						  this->textBoxSerialUSB->Enabled=!value;
						  this->buttonClearConsole->Visible=!value;
						  this->buttonClearConsole->Enabled=!value;
						  this->buttonCancel->Visible=!value;
						  this->buttonCancel->Enabled=!value;
						  this->checkBoxVerbose->Visible=!value;
						  this->checkBoxVerbose->Enabled=!value;

						  if(this->checkBoxShowMemory->Checked)
							  {
							  this->textBoxLog->Visible=false;
							  this->textBoxLog->Enabled=false;
							  this->dataGridView1->Visible=true;
							  this->textBoxDebug->Visible=true;
							  this->dataGridView1->Enabled=true;
							  this->numericUpDownMemoryOffset->Visible=true;
							  this->numericUpDownMemoryOffset->Enabled=true;
							  }
						  else
							  {
							  this->dataGridView1->Visible=false;
							  this->dataGridView1->Enabled=false;
							  this->textBoxDebug->Visible=false;
							  this->textBoxLog->Visible=true;
							  this->textBoxLog->Enabled=true;
							  this->numericUpDownMemoryOffset->Visible=true;
							  this->numericUpDownMemoryOffset->Enabled=false;

							  }
						  }
					  return 1;
					  }

				  int enterSerialOrUSBBootLoader(unsigned char cmd)
					  {

					  /* returns -1 if no device connected, else returns the value of captiveDevice */

					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device

					  if(Connection_Status)
						  {
						  OutputPacketBuffer.data[0]=cmd;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return -1;
							  }
						  // Now get the response packet from the firmware.
						  // The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return -1;
							  }
						  return 1;
						  }
					  return -1;
					  }

				  int getBootLoaderStatus(unsigned long *ver)
					  {

					  /* returns -1 if no device connected, else returns the value of captiveDevice */
					  if(SerialPortConnected)return 1;
					  else
						  {
						  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
						  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
						  unsigned char* ptr;

						  if(ver)*ver=0;

						  if(Connection_Status)
							  {

							  OutputPacketBuffer.data[0]=CMD_GET_BOOTLOADER_STATUS;
							  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
							  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_BOOT) != SIZE_USB_PACKET)
								  {
								  return -1;
								  }
							  // Now get the response packet from the firmware.
							  // The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
							  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_BOOT) != SIZE_USB_PACKET)
								  {
								  return -1;
								  }

							  if(ver)
								  {
								  ptr=(unsigned char*)ver;
								  *ptr++=InputPacketBuffer.data[4];
								  *ptr++=InputPacketBuffer.data[5];
								  *ptr++=InputPacketBuffer.data[6];
								  *ptr++=InputPacketBuffer.data[7];
								  }

							  bootLoaderStatus=(int)InputPacketBuffer.data[1];
							  return (int)InputPacketBuffer.data[1];
							  }
						  return -1;
						  }
					  }

				  int getBootLoaderStatusQuick(unsigned long *ver)
					  {
					  /* returns -1 if no device connected, else returns the value of captiveDevice */
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					  unsigned char* ptr;

					  if(SerialPortConnected)return 1;
					  else
						  {
						  if(ver)*ver=0;
						  if(Connection_Status)
							  {

							  OutputPacketBuffer.data[0]=CMD_GET_BOOTLOADER_STATUS;
							  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
							  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_BOOT_QUICK) != SIZE_USB_PACKET)
								  {
								  return -1;
								  }
							  // Now get the response packet from the firmware.
							  // The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
							  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_BOOT_QUICK) != SIZE_USB_PACKET)
								  {
								  return -1;
								  }

							  if(ver)
								  {
								  ptr=(unsigned char*)ver;
								  *ptr++=InputPacketBuffer.data[4];
								  *ptr++=InputPacketBuffer.data[5];
								  *ptr++=InputPacketBuffer.data[6];
								  *ptr++=InputPacketBuffer.data[7];
								  }
							  bootLoaderStatus=(int)InputPacketBuffer.data[1];
							  return (int)bootLoaderStatus;
							  }
						  }
					  return -1;
					  }

				  int getCaptiveDevice(void)
					  {
					  /* returns -1 if no device connected, else returns the value of captiveDevice */

					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device

					  if(ConnectedUser())
						  {
						  OutputPacketBuffer.data[0]= CMD_GET_CAPTIVE_DEVICE;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return -1;
							  }
						  // Now get the response packet from the firmware.
						  // The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return -1;
							  }

						  return (int)InputPacketBuffer.data[1];
						  } else
							  return -1;
					  }

				  float internalGlFunction(unsigned short function, VM_ARGUMENT* varg)
					  {
					  /* Execute the global function immediately through the USB */
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					  unsigned char* ptr;
					  float f;
					  int i;
					  int j;
					  int numArgs;

					  f=0.0;
					  if(ConnectedUser())
						  {
						  if((function>=0)&&(function<256))
							  {
							  numArgs=globalFunctionArgTable[function];
							  OutputPacketBuffer.data[0]=CMD_CALL_GLOBAL_FUNCTION_IMMEDIATE;
							  OutputPacketBuffer.data[1]=(unsigned char)function & 0x00FF;
							  OutputPacketBuffer.data[2]=(unsigned char)(function>>8);
							  ptr=(unsigned char*)&varg->w;
							  i=4;
							  OutputPacketBuffer.data[i++]=*ptr++;
							  OutputPacketBuffer.data[i++]=*ptr++;
							  OutputPacketBuffer.data[i++]=*ptr++;
							  OutputPacketBuffer.data[i++]=*ptr++;
							  i=8;
							  j=0;
							  while(numArgs--)
								  {
								  ptr=(unsigned char*)&varg->f[j++];
								  OutputPacketBuffer.data[i++]=*ptr++;
								  OutputPacketBuffer.data[i++]=*ptr++;
								  OutputPacketBuffer.data[i++]=*ptr++;
								  OutputPacketBuffer.data[i++]=*ptr++;
								  }
							  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
							  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
								  {
								  return 0;
								  }
							  //Now get the response packet from the firmware.
							  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
							  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
								  {
								  return 0;
								  }
							  ptr=(unsigned char*)&f;
							  *ptr++=InputPacketBuffer.data[4];
							  *ptr++=InputPacketBuffer.data[5];
							  *ptr++=InputPacketBuffer.data[6];
							  *ptr++=InputPacketBuffer.data[7];
							  }
						  }
					  varg->w=f;
					  return f;
					  }

				  int flushLog(void)
					  {
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device

					  if(ConnectedUser())
						  {
						  OutputPacketBuffer.data[0]= CMD_FLUSH_LOG;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  //Now get the response packet from tfluhe firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  return 1;
						  }
					  return 0;
					  }

				  int restartVMEnvironment(void)
					  {
					  int getResult;
					  DATA_LOGGER tempUDL;

					  getResult=getDataLogger(&tempUDL);
					  if(getResult)
						  {
						  /* Restart the environment on a connect! */
						  tempUDL.ven.vmMode|=(VME_HOLD | VME_RESTART);
						  getResult=putDataLogger(&tempUDL);
						  }
					  return getResult;					 
					  }

				  int restartLog(void)
					  {
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device

					  if(ConnectedUser())
						  {
						  OutputPacketBuffer.data[0]= CMD_RESTART_LOG;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  //Now get the response packet from tfluhe firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  return 1;
						  }
					  return 0;
					  }

				  int changeSystemLogName(unsigned char doChange, unsigned char* fName, unsigned char* ofName) 
					  {
					  DATA_LOGGER tempUDL;
					  int         getResult;
					  int			i;
					  int			result;

					  result=0;
					  flushLog();
					  getResult=getDataLogger(&tempUDL);
					  if(getResult)
						  {
						  if(doChange)
							  {
							  i=0;
							  while((tempUDL.ven.vmLogFileName[i]!='\0')&&(i<(LOG_FILE_NAME_SIZE-1)))
								  {
								  *ofName++=tempUDL.ven.vmLogFileName[i];
								  i++;
								  }

							  i=0;
							  while(((*fName)!='\0')&&(i<(LOG_FILE_NAME_SIZE-1)))
								  {
								  tempUDL.ven.vmLogFileName[i]=*fName++;
								  i++;
								  }
							  tempUDL.ven.vmLogFileName[i]='\0';
							  getResult=putDataLogger(&tempUDL);
							  if(getResult)
								  {
								  result=restartLog();				 
								  }
							  }
						  else
							  {
							  i=0;
							  while((tempUDL.ven.vmLogFileName[i]!='\0')&&(i<(LOG_FILE_NAME_SIZE-1)))
								  {
								  *ofName++=tempUDL.ven.vmLogFileName[i];
								  i++;
								  }
							  result=1;
							  }
						  }
					  *ofName='\0';
					  return result;
					  }

				  int deleteLog(void)
					  {
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device

					  if(ConnectedUser())
						  {
						  OutputPacketBuffer.data[0]= CMD_DELETE_LOG;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  //Now get the response packet from tfluhe firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  return 1;
						  }
					  return 0;
					  }

				  int flushSettings(void)
					  {
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device

					  if(ConnectedUser())
						  {
						  OutputPacketBuffer.data[0]= CMD_FLUSH_SETTINGS;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  //Now get the response packet from tfluhe firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  return 1;
						  }
					  return 0;
					  }

				  int logString(System::String^ instring, unsigned short function, System::Windows::Forms::ToolStripProgressBar^ progress)
					  {
					  USB_PACKET		OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET		InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					  int				i;
					  int				totalSize;
					  unsigned char	tempString[SIZE_USB_PACKET];
					  int				offset;
					  int				oprogress;
					  int				total;
					  int				percent;
					  int				done;

					  if(ConnectedUser())
						  {
						  totalUSBBytesRead=0;
						  totalUSBBytesWrite=0;
						  this->labelUSBTraffic->Text="USB:";
						  blockLongProcesses++;
						  if(progress!=nullptr)
							  {
							  progress->ForeColor=NEUTRAL_COLOUR;
							  progress->Value=0;
							  oprogress=1;
							  }
						  this->labelUSB->Text=formatStringFileSize(totalUSBBytesRead);
						  this->labelUSB->ForeColor=NEUTRAL_COLOUR;
						  totalSize=instring->Length;
						  total=totalSize;
						  offset=0;
						  while(totalSize>0)
							  {
							  OutputPacketBuffer.data[0]= CMD_LOGSTRING;
							  OutputPacketBuffer.data[1]=(unsigned char)(function & 0x00FF);
							  OutputPacketBuffer.data[2]=(unsigned char)(function>>8);
							  function=PF_NOP;
							  done=getUnsignedCharArrayFromStringMax(tempString, instring, SIZE_USB_PACKET-5);
							  offset+=done;
							  instring=instring->Substring(offset);
							  tempString[done]='\0';
							  i=0;
							  while((4+i)<SIZE_USB_PACKET)
								  {
								  OutputPacketBuffer.data[4+i]=tempString[i];
								  i++;
								  if(totalSize>0)
									  {
									  totalSize--;
									  }
								  }
							  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
							  if((totalSize>=0)&&(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET))
								  {
								  totalSize=-1;
								  }
							  //Now get the response packet from the firmware.
							  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
							  if((totalSize>=0)&&(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET))
								  {
								  totalSize=-1;
								  }

							  if(progress!=nullptr)
								  {
								  if(total>0)percent=(int)(((double)(offset)*100.0/((double)total))+0.5);
								  else percent=100;
								  if((percent>=progress->Minimum)&&(percent<=progress->Maximum))
									  {
									  progress->Value=percent;
									  }
								  if(progress->Value!=oprogress)
									  {
									  oprogress=(unsigned int)progress->Value;
									  }
								  this->labelUSB->Text=formatStringFileSize(totalUSBBytesRead);
								  }
							  Application::DoEvents();
							  }
						  blockLongProcesses--;

						  if(totalSize==0)return 1; else return 0;
						  }
					  return 0;
					  }

				  int getSizes(unsigned char num, unsigned short* sizesOut)
					  {
					  USB_PACKET		OutputPacketBuffer; // Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET		InputPacketBuffer;  // Allocate a memory buffer for the data which we will read from the USB device
					  unsigned char	*ptr;
					  unsigned short  size;

					  if(ConnectedUser())
						  {

						  stopDeviceRunning();
						  OutputPacketBuffer.data[0]= CMD_GET_SIZES;

						  // The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  //Now get the response packet from the firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  ptr=(unsigned char*)&InputPacketBuffer.data[4];
						  while(num>0)
							  {
							  size=(unsigned short)(*ptr);
							  ptr++;
							  size+=((unsigned short)(*ptr)<<8);
							  ptr++;
							  *sizesOut++=size;
							  num--;
							  }
						  return 1;
						  } 
					  return 0;
					  }		

				  unsigned long setReadFlashAddress(unsigned char set, unsigned long flashAddress)
					  {

					  USB_PACKET		OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET		InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					  unsigned char*  ptr;
					  unsigned long   flashAddressRead;
					  unsigned char   error;

					  error=0;
					  flashAddressRead=0;
					  if(Connection_Status)
						  {
						  if(getBootLoaderStatus(0)>=1)
							  {		
							  OutputPacketBuffer.data[0]=CMD_SET_FLASH_ADDRESS;
							  ptr=(unsigned char*)&flashAddress;
							  OutputPacketBuffer.data[4]=*ptr++;
							  OutputPacketBuffer.data[5]=*ptr++;
							  OutputPacketBuffer.data[6]=*ptr++;
							  OutputPacketBuffer.data[7]=*ptr++;
							  if(set)OutputPacketBuffer.data[1]=1; else OutputPacketBuffer.data[1]=0;
							  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
								  {
								  error=1;
								  }
							  //Now get the response packet from the firmware.
							  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
							  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
								  {
								  error=1;
								  }
							  ptr=(unsigned char*)&flashAddressRead;
							  *ptr++=InputPacketBuffer.data[4];
							  *ptr++=InputPacketBuffer.data[4];
							  *ptr++=InputPacketBuffer.data[4];
							  *ptr++=InputPacketBuffer.data[4];
							  }
						  }
					  return flashAddressRead;
					  }

				  unsigned long writeProgramMemory(unsigned long address, long bytes, unsigned char* output, System::Windows::Forms::ToolStripProgressBar^ progress)
					  {
					  USB_PACKET		OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET		InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					  unsigned long	numberWritten;
					  int				error;
					  unsigned int	size;
					  int				offset;
					  int				oprogress;
					  int				total;
					  int				percent;

					  numberWritten=0;
					  if(Connection_Status)
						  {
						  if(getBootLoaderStatus(0)>=1)
							  {						
							  error=0;
							  offset=0;
							  total=bytes;
							  totalUSBBytesRead=0;
							  totalUSBBytesWrite=0;
							  this->labelUSBTraffic->Text="Mem:";
							  blockLongProcesses++;
							  if(progress!=nullptr)
								  {
								  progress->ForeColor=NEUTRAL_COLOUR;
								  progress->Value=0;
								  oprogress=1;
								  }
							  this->labelUSB->Text=formatStringFileSize(totalUSBBytesRead);
							  this->labelUSB->ForeColor=NEUTRAL_COLOUR;

							  setReadFlashAddress(1, address);
							  while((error==0)&&(bytes>0))
								  {
								  OutputPacketBuffer.data[0]=CMD_PUT_PROGRAM_MEMORY_AT;
								  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.

								  size=32;
								  while(size>0)
									  {
									  size--;
									  OutputPacketBuffer.data[4+size]=*(output+size);
									  }

								  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
									  {
									  error=1;	
									  }
								  //Now get the response packet from the firmware.
								  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
								  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
									  {
									  error=1;
									  }

								  output+=32;
								  size=32;
								  while(size>0)
									  {
									  size--;
									  OutputPacketBuffer.data[4+size]=*(output+size);
									  }
								  output+=32;
								  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
									  {
									  error=1;
									  }
								  //Now get the response packet from the firmware.
								  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
								  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
									  {
									  error=1;
									  }

								  if(error)
									  {

									  }
								  else
									  {
									  size=(unsigned int)64;
									  address+=(unsigned long)size;
									  offset+=size;
									  numberWritten+=size;
									  bytes-=64;
									  }

								  if(progress!=nullptr)
									  {
									  if(total>0)percent=(int)(((double)(offset)*100.0/((double)total))+0.5);
									  else percent=100;
									  if((percent>=progress->Minimum)&&(percent<=progress->Maximum))
										  {
										  progress->Value=percent;
										  }
									  if(progress->Value!=oprogress)
										  {
										  oprogress=(unsigned int)progress->Value;
										  }
									  this->labelUSB->Text=formatStringFileSize(totalUSBBytesRead);
									  }
								  Application::DoEvents();
								  }
							  blockLongProcesses--;

							  if((bytes>0)||(error))
								  {
								  this->labelUSB->ForeColor=BAD_DARK_COLOUR;
								  if(progress!=nullptr)progress->ForeColor=BAD_COLOUR;
								  }
							  else
								  {
								  this->labelUSB->ForeColor=OK_DARK_COLOUR;
								  if(progress!=nullptr)progress->ForeColor=OK_COLOUR;
								  }
							  }
						  }
					  return numberWritten;
					  }

				  unsigned long eraseProgramMemory(unsigned long startAddress, unsigned long endAddress)
					  {
					  USB_PACKET		OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET		InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					  unsigned char*  ptr;
					  unsigned long   done;

					  done=0;
					  if(Connection_Status)
						  {
						  if(getBootLoaderStatus(0)>=1)
							  {						

							  if(startAddress<endAddress)
								  {
								  OutputPacketBuffer.data[0]=CMD_ERASE_PROGRAM_MEMORY_AT;
								  ptr=(unsigned char*)&startAddress;
								  OutputPacketBuffer.data[4]=*ptr++;
								  OutputPacketBuffer.data[5]=*ptr++;
								  OutputPacketBuffer.data[6]=*ptr++;
								  OutputPacketBuffer.data[7]=*ptr++;
								  ptr=(unsigned char*)&endAddress;
								  OutputPacketBuffer.data[8]=*ptr++;
								  OutputPacketBuffer.data[9]=*ptr++;
								  OutputPacketBuffer.data[10]=*ptr++;
								  OutputPacketBuffer.data[11]=*ptr++;
								  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
								  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
									  {
									  return 0;
									  }
								  //Now get the response packet from the firmware.
								  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
								  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
									  {
									  return 0;
									  }
								  ptr=(unsigned char*)&done;
								  *ptr++=InputPacketBuffer.data[4];
								  *ptr++=InputPacketBuffer.data[5];
								  *ptr++=InputPacketBuffer.data[6];
								  *ptr++=InputPacketBuffer.data[7];
								  return done;
								  }
							  }
						  }
					  return 0;
					  }

				  unsigned long readProgramMemory(unsigned long address, long bytes, unsigned char* output, System::Windows::Forms::ToolStripProgressBar^ progress)
					  {
					  USB_PACKET		OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET		InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					  unsigned long	numberRead;
					  int				error;
					  unsigned int	size;
					  unsigned int    i;
					  int				offset;
					  int				oprogress;
					  int				total;
					  int				percent;

					  numberRead=0;
					  if(Connection_Status)
						  {
						  if(getBootLoaderStatus(0)>=1)
							  {						
							  error=0;
							  offset=0;
							  total=bytes;
							  totalUSBBytesRead=0;
							  totalUSBBytesWrite=0;
							  this->labelUSBTraffic->Text="Mem:";
							  blockLongProcesses++;
							  if(progress!=nullptr)
								  {
								  progress->ForeColor=NEUTRAL_COLOUR;
								  progress->Value=0;
								  oprogress=1;
								  }
							  this->labelUSB->Text=formatStringFileSize(totalUSBBytesRead);
							  this->labelUSB->ForeColor=NEUTRAL_COLOUR;

							  setReadFlashAddress(1, address);
							  while((error==0)&&(bytes>0))
								  {
								  OutputPacketBuffer.data[0]=CMD_GET_PROGRAM_MEMORY_AT;
								  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
								  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
									  {
									  error=1;
									  }
								  //Now get the response packet from the firmware.
								  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
								  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
									  {
									  error=1;
									  }

								  if(error)
									  {

									  }
								  else
									  {
									  size=(unsigned int)64;
									  address+=(unsigned long)size;
									  i=0;						
									  while(i<size)
										  {
										  *output++=InputPacketBuffer.data[i];
										  bytes--;
										  numberRead++;
										  offset++;
										  i++;
										  }
									  }

								  if(progress!=nullptr)
									  {
									  if(total>0)percent=(int)(((double)(offset)*100.0/((double)total))+0.5);
									  else percent=100;
									  if((percent>=progress->Minimum)&&(percent<=progress->Maximum))
										  {
										  progress->Value=percent;
										  }
									  if(progress->Value!=oprogress)
										  {
										  oprogress=(unsigned int)progress->Value;
										  }
									  this->labelUSB->Text=formatStringFileSize(totalUSBBytesRead);
									  }
								  Application::DoEvents();
								  }
							  blockLongProcesses--;

							  if((bytes>0)||(error))
								  {
								  this->labelUSB->ForeColor=BAD_DARK_COLOUR;
								  if(progress!=nullptr)progress->ForeColor=BAD_COLOUR;
								  }
							  else
								  {
								  this->labelUSB->ForeColor=OK_DARK_COLOUR;
								  if(progress!=nullptr)progress->ForeColor=OK_COLOUR;
								  }
							  }

						  }
					  return numberRead;
					  }

				  int reconnectMemoryCard(void)
					  {
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device

					  if(ConnectedUser())
						  {
						  OutputPacketBuffer.data[0]= CMD_RECONNECT_MEMORYCARD;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  //Now get the response packet from the firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  } else return 0;
					  return 1;
					  }

				  int getTransferStats(unsigned short* count, unsigned short* tptr)
					  {
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device

					  *count=1;
					  *tptr=0;
					  if(ConnectedUser())
						  {
						  OutputPacketBuffer.data[0]= CMD_GET_TRANSFER_STATS;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  //Now get the response packet from the firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  } else return 0;

					  (*count)=(unsigned short)InputPacketBuffer.data[0]+(unsigned short)InputPacketBuffer.data[1]*256;
					  (*tptr)=(unsigned short)InputPacketBuffer.data[2]+(unsigned short)InputPacketBuffer.data[3]*256;
					  return 1;
					  }


				  float getFirmwareVersion(unsigned long* devicepors)
					  {
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					  unsigned char* ptr;
					  float f;

					  *devicepors=0;
					  if(ConnectedUser())
						  {
						  OutputPacketBuffer.data[0]= CMD_GET_VERSION;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  //Now get the response packet from the firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return 0;
							  }
						  ptr=(unsigned char*)&f;
						  *ptr++=InputPacketBuffer.data[4];
						  *ptr++=InputPacketBuffer.data[5];
						  *ptr++=InputPacketBuffer.data[6];
						  *ptr++=InputPacketBuffer.data[7];

						  ptr=(unsigned char*)devicepors;
						  *ptr++=InputPacketBuffer.data[8];
						  *ptr++=InputPacketBuffer.data[9];
						  *ptr++=InputPacketBuffer.data[10];
						  *ptr++=InputPacketBuffer.data[11];

						  ptr=(unsigned char*)&serialBootLoaderVersion;
						  *ptr++=InputPacketBuffer.data[12];
						  *ptr++=InputPacketBuffer.data[13];
						  *ptr++=InputPacketBuffer.data[14];
						  *ptr++=InputPacketBuffer.data[15];

						  ptr=(unsigned char*)&USBBootLoaderVersion;
						  *ptr++=InputPacketBuffer.data[16];
						  *ptr++=InputPacketBuffer.data[17];
						  *ptr++=InputPacketBuffer.data[18];
						  *ptr++=InputPacketBuffer.data[19];


						  } else f=0.0;
					  return f;
					  }

				  void clearTransfers(void)
					  {
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device

					  if(ConnectedUser())
						  {
						  stopDeviceRunning();
						  OutputPacketBuffer.data[0]= CMD_INIT_TRANSFERS;
						  OutputPacketBuffer.data[1]=0;
						  OutputPacketBuffer.data[2]=0;
						  OutputPacketBuffer.data[3]=0;
						  OutputPacketBuffer.data[4]=0;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return;
							  }
						  //Now get the response packet from the firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							  {
							  return;
							  }
						  }
					  return;
					  }

				  void sendLocalTime(void)
					  {
					  SYSTEMTIME mySystemTime;
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					  int i;
					  char* ptr;
					  DATA_LOGGER tempUDL;
					  int getResult;			  

					  if(ConnectedUser())
						  {
						  stopDeviceRunning();
						  GetLocalTime(&mySystemTime);
						  getResult=getDataLogger(&tempUDL);
						  tempUDL.lastSyncTime.secs=(unsigned char)mySystemTime.wSecond;
						  tempUDL.lastSyncTime.mins=(unsigned char)mySystemTime.wMinute;
						  tempUDL.lastSyncTime.hours=(unsigned char)mySystemTime.wHour;
						  tempUDL.lastSyncTime.day=(unsigned char)mySystemTime.wDay;
						  tempUDL.lastSyncTime.month=(unsigned char)mySystemTime.wMonth;
						  tempUDL.lastSyncTime.year=(unsigned short)mySystemTime.wYear;
						  tempUDL.lastSyncTime.wday=(unsigned char)mySystemTime.wDayOfWeek;
						  tempUDL.lastSyncTime.show=(SHOW_TIME_DEFAULT);
						  tempUDL.lastSyncTime.updated=(TIME_UPDATED);
						  if(getResult)putDataLogger(&tempUDL);
						  OutputPacketBuffer.data[0]= CMD_SET_TIME;
						  ptr=(char*)&tempUDL.lastSyncTime;
						  for(i=0; i<sizeof(TIME_T); i++)
							  {
							  OutputPacketBuffer.data[4+i]=*ptr++;
							  }

						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
							  {
							  return;
							  }

						  //Now get the response packet from the firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
							  {
							  return;
							  }

						  }
					  return;
					  }

				  void getTimeFromDevice(TIME_T* secondSystemTime)
					  {
					  /* get Time from the USB Data Logger */
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					  int i;
					  char* ptr;

					  if(ConnectedUser())
						  {

						  OutputPacketBuffer.data[0]= CMD_GET_TIME;

						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
							  {
							  return;
							  }
						  //Now get the response packet from the firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
							  {

							  return;
							  }
						  ptr=(char*)secondSystemTime;
						  for(i=0; i<sizeof(TIME_T); i++)
							  {
							  *ptr++=InputPacketBuffer.data[4+i];
							  }
						  }
					  return;
					  }

				  FRESULT getFileFromDeviceToPC(System::String^ PCFileName, System::String^ DeviceFilePath, unsigned long *offset, System::Windows::Forms::ToolStripProgressBar^ progress)
					  {
					  FRESULT			fresult;
					  char			path[MAX_PATH_LENGTH];
					  unsigned int	done;
					  unsigned int	adone;
					  unsigned char	tempBuffer[FILE_BLOCK_SIZE];
					  char			fileName[MAX_PATH_LENGTH];
					  unsigned int	total;
					  unsigned int	oprogress;
					  int				percent;
					  unsigned char	valueRead;

					  static unsigned char inUse=0;

					  if(inUse)
						  {
						  *offset=0;
						  return FR_DENIED;
						  }
					  else
						  {
						  inUse=1;
						  setCaptiveDevice(1);
						  total=(unsigned int)*offset;
						  *offset=0;
						  getUnsignedCharPathFromString((unsigned char*)&path[0], (unsigned char*)&fileName[0], DeviceFilePath, 0, MAX_PATH_LENGTH);
						  if(PCFileName=="")
							  {
							  PCFileName="."+getStringFromUnsignedCharArrayAuto((unsigned char*)path);
							  }

						  if(System::IO::File::Exists(PCFileName))
							  {
							  try
								  {
								  System::IO::File::Delete(PCFileName);
								  }
							  catch(...)
								  {

								  }
							  }

						  stopTimer1();
						  valueRead=0;

						  fresult=f_open((char*)path, FA_READ | FA_OPEN_EXISTING);
						  if(fresult==FR_OK)
							  {
							  totalUSBBytesRead=0;
							  totalUSBBytesWrite=0;
							  blockLongProcesses++;
							  this->labelUSBTraffic->Text="USB:";

							  done=FILE_BLOCK_SIZE;
							  if(progress!=nullptr)
								  {
								  progress->ForeColor=NEUTRAL_COLOUR;
								  progress->Value=0;
								  oprogress=1;
								  }
							  this->labelUSB->Text=formatStringFileSize(totalUSBBytesRead);
							  this->labelUSB->ForeColor=NEUTRAL_COLOUR;
							  globalCancel=0;
							  this->buttonCancel->BackColor=OK_COLOUR;
							  while((globalCancel==0)&&(fresult==FR_OK)&&(done==FILE_BLOCK_SIZE))
								  {
								  fresult=f_read(tempBuffer, FILE_BLOCK_SIZE, &done);
								  WriteFile(PCFileName, *offset, tempBuffer, done, &adone);
								  (*offset)+=done;
								  if(progress!=nullptr)
									  {
									  if(total>0)percent=(int)(((double)(*offset)*100.0/((double)total))+0.5);
									  else percent=100;

									  if((percent>=progress->Minimum)&&(percent<=progress->Maximum))
										  {
										  progress->Value=percent;
										  }

									  if(progress->Value!=oprogress)
										  {
										  oprogress=(unsigned int)progress->Value;
										  }
									  this->labelUSB->Text=formatStringFileSize(totalUSBBytesRead);
									  }
								  Application::DoEvents();

								  }
							  blockLongProcesses--;
							  if(globalCancel)fresult=FR_DENIED;
							  else
								  {
								  this->buttonCancel->BackColor=NORMAL_COLOUR;
								  }

							  if(fresult!=FR_OK)
								  {
								  this->labelUSB->ForeColor=BAD_DARK_COLOUR;
								  if(progress!=nullptr)progress->ForeColor=BAD_COLOUR;
								  }
							  else
								  {
								  this->labelUSB->ForeColor=OK_DARK_COLOUR;
								  if(progress!=nullptr)progress->ForeColor=OK_COLOUR;
								  }
							  f_close();
							  }

						  inUse=0;
						  startTimer1();
						  return fresult;
						  }
					  }

				  FRESULT deleteFileFromDevice(System::String^ DeviceFilePath)
					  {
					  FRESULT fresult;
					  char path[MAX_PATH_LENGTH];
					  char fileName[MAX_PATH_LENGTH];

					  setCaptiveDevice(1);
					  getUnsignedCharPathFromString((unsigned char*)&path[0], (unsigned char*)&fileName[0], DeviceFilePath, 0, MAX_PATH_LENGTH);
					  fresult=f_unlink((char*)path);
					  return fresult;
					  }

				  System::String^ nullGetTextFunction(unsigned char id)
					  {
					  System::String^ response;
					  System::String^ fileName;
					  unsigned int done;
					  unsigned char textBuffer[32];

					  fileName="nm"+HexToString((unsigned long)id & VM_ID_MASK, 1)+".txt";
					  if(File::Exists(fileName))
						  {
						  ReadFile(fileName, 0, textBuffer, 32, &done);
						  response="\""+getStringFromUnsignedCharArray(textBuffer, done)+"\" ";
						  }
					  else
						  {
						  response="";
						  }
					  response+="[0x"+HexToString((unsigned long)id & VM_ID_MASK, 1)+"]";
					  return response;
					  }

				  System::String^ deviceGetTextFunction(unsigned char id)
					  {

					  System::String^ response;
					  System::String^ fileName;
					  unsigned int done;
					  unsigned char textBuffer[32];
					  unsigned long offset;
					  FRESULT fresult;

					  fileName="nm"+HexToString((unsigned long)id & VM_ID_MASK, 1)+".txt";
					  offset=0;
					  response="";
					  fresult=getFileFromDeviceToPC("l"+fileName, fileName, &offset, nullptr);
					  if(fresult==FR_OK)
						  {
						  ReadFile("l"+fileName, 0, textBuffer, 32, &done);
						  response="\""+getStringFromUnsignedCharArray(textBuffer, done)+"\" ";
						  }
					  response+="[0x"+HexToString((unsigned long)id & VM_ID_MASK, 1)+"]";
					  return response;
					  }

				  System::Void updateScripts(System::Windows::Forms::TreeView^ intree, DATA_LOGGER* tempUDL, System::String^ title, unsigned char mode)
					  {
					  int									i;
					  System::Windows::Forms::TreeNode^	mTreeNode;

					  mTreeNode=gcnew System::Windows::Forms::TreeNode();
					  intree->Nodes->Clear();
					  mTreeNode->Text="["+title+formatStringFloat((double)tempUDL->ven.vmNum, 0)+"]";
					  mTreeNode->Name=mTreeNode->Text;
					  intree->Nodes->Add(mTreeNode);
					  i=0;
					  while((i<tempUDL->ven.vmNum)&&(i<MAX_NUM_VM))
						  {
						  mTreeNode=gcnew System::Windows::Forms::TreeNode();
						  if(mode!=0)mTreeNode->Text=deviceGetTextFunction(tempUDL->ven.vmID[i]);
						  else mTreeNode->Text=nullGetTextFunction(tempUDL->ven.vmID[i]);
						  if(tempUDL->ven.vmID[i] & VM_ID_HOLD)mTreeNode->Text+=" (Paused)";
						  if(((unsigned char)i)==tempUDL->ven.vmSelected)
							  {
							  mTreeNode->Text+=" (*)";
							  }
						  mTreeNode->Name=mTreeNode->Text;
						  mTreeNode->Tag=System::Decimal(tempUDL->ven.vmID[i]);
						  intree->Nodes->Add(mTreeNode);
						  i++;
						  }
					  intree->Show();
					  }

				  FRESULT createDirectoryOnDevice(System::String^ DeviceFilePath)
					  {
					  FRESULT fresult;
					  char path[MAX_PATH_LENGTH];
					  char fileName[MAX_PATH_LENGTH];

					  setCaptiveDevice(1);
					  getUnsignedCharPathFromString((unsigned char*)&path[0], (unsigned char*)&fileName[0], DeviceFilePath, 0, MAX_PATH_LENGTH);
					  fresult=f_mkdir((char*)path);
					  return fresult;
					  }

				  FRESULT putFileFromPCToDevice(System::String^ PCFileName, System::String^ DeviceFilePath, unsigned long *offset, System::Windows::Forms::ToolStripProgressBar^ progress)
					  {
					  FRESULT fresult;
					  char path[MAX_PATH_LENGTH];
					  unsigned int done;
					  unsigned int adone;
					  unsigned char	tempBuffer[FILE_BLOCK_SIZE];
					  char			fileName[MAX_PATH_LENGTH];
					  FileStream^		fileSupportStreamReader;
					  unsigned int	total;
					  unsigned int	oprogress;
					  int				percent;
					  int				todo;
					  unsigned char*  ptr;
					  unsigned long   aoffset;
					  unsigned char   valueRead;
					  unsigned char   c;

					  static unsigned char inUse=0;

					  if(inUse)
						  {
						  *offset=0;
						  return FR_DENIED;
						  }
					  else
						  {
						  *offset=0;
						  inUse=1;
						  if(File::Exists(PCFileName))
							  {

							  try
								  {
								  fileSupportStreamReader = gcnew FileStream(PCFileName, FileMode::Open);
								  }
							  catch(...)
								  {
								  if(fileSupportStreamReader)
									  {
									  delete fileSupportStreamReader;
									  }
								  inUse=0;
								  return FR_NO_FILE;
								  }
							  }
						  else
							  {
							  inUse=0;
							  return FR_NO_FILE;
							  }

						  total=(unsigned int)fileSupportStreamReader->Length;
						  aoffset=0;
						  setCaptiveDevice(1);
						  getUnsignedCharPathFromString((unsigned char*)&path[0], (unsigned char*)&fileName[0], DeviceFilePath, 0, MAX_PATH_LENGTH);

						  stopTimer1();
						  valueRead=0;

						  fresult=f_open((char*)path, FA_WRITE | FA_CREATE_ALWAYS);
						  if(fresult==FR_OK)
							  {

							  *offset=0;
							  done=FILE_BLOCK_SIZE;
							  adone=FILE_BLOCK_SIZE;
							  totalUSBBytesRead=0;
							  totalUSBBytesWrite=0;
							  blockLongProcesses++;
							  if(progress!=nullptr)
								  {
								  progress->Value=0;
								  progress->ForeColor=NEUTRAL_COLOUR;
								  oprogress=1;
								  }
							  this->labelUSB->Text=formatStringFileSize(totalUSBBytesRead);
							  this->labelUSB->ForeColor=NEUTRAL_COLOUR;
							  globalCancel=0;
							  this->buttonCancel->BackColor=OK_COLOUR;
							  while((globalCancel==0)&&(fresult==FR_OK)&&(done==FILE_BLOCK_SIZE)&&(adone>0))
								  {
								  //ReadFile(PCFileName, *offset, tempBuffer, done, &adone);
								  todo=done;
								  ptr=(unsigned char*)&tempBuffer[0];
								  adone=0;
								  while((todo>0)&&(aoffset<total))
									  {

									  c=(unsigned char)fileSupportStreamReader->ReadByte();
									  *ptr++=c;
									  aoffset++;
									  adone++;
									  todo--; 
									  }	

								  fresult=f_write(&tempBuffer[0], adone, &done);
								  (*offset)+=adone;
								  if(progress!=nullptr)
									  {
									  if(total>0)percent=(int)(((double)(*offset)*100.0/((double)total))+0.5);
									  else percent=100;

									  if((percent>=progress->Minimum)&&(percent<=progress->Maximum))
										  {
										  progress->Value=percent;
										  }

									  if(progress->Value!=oprogress)
										  {
										  oprogress=(unsigned int)progress->Value;
										  }
									  this->labelUSB->Text=formatStringFileSize(totalUSBBytesRead);
									  }
								  Application::DoEvents();
								  }

							  blockLongProcesses--;

							  if(globalCancel)fresult=FR_DENIED;
							  else
								  {
								  this->buttonCancel->BackColor=NORMAL_COLOUR;
								  }

							  if(fresult!=FR_OK)
								  {
								  if(progress!=nullptr)progress->ForeColor=BAD_DARK_COLOUR;
								  this->labelUSB->ForeColor=BAD_DARK_COLOUR;
								  }
							  else
								  {	
								  if(progress!=nullptr)progress->ForeColor=OK_DARK_COLOUR;
								  this->labelUSB->ForeColor=OK_DARK_COLOUR;
								  }
							  f_close();
							  fileSupportStreamReader->Close();
							  }
						  startTimer1();
						  inUse=0;
						  return fresult;
						  }
					  }


				  FRESULT f_open(char* fName, int mode)
					  {
					  /* open a file on device for reading... */
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					  unsigned int i;
					  FRESULT result;

					  result=FR_DISK_ERR;
					  if(ConnectedUser())
						  {

						  stopDeviceRunning();

						  if(mode & FA_WRITE)OutputPacketBuffer.data[0]=CMD_OPEN_WRITE_FILE;
						  else OutputPacketBuffer.data[0]=CMD_OPEN_READ_FILE;

						  for(i=4; i<(SIZE_USB_PACKET-1); i++)
							  {
							  if((*fName)!='\0')
								  {
								  OutputPacketBuffer.data[i]=(*fName);
								  }
							  else break;
							  fName++;
							  }
						  OutputPacketBuffer.data[i]='\0';
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							  {
							  return result;
							  }

						  //Now get the response packet from the firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							  {

							  return result;
							  }
						  result=(FRESULT)InputPacketBuffer.data[0];
						  }
					  return result;
					  }

				  FRESULT f_unlink(char* fName)
					  {
					  /* Delete a File on the device... */
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					  unsigned int i;
					  FRESULT result;

					  result=FR_DISK_ERR;
					  if(ConnectedUser())
						  {

						  stopDeviceRunning();

						  OutputPacketBuffer.data[0]=CMD_UNLINK_FILE;
						  for(i=4; i<(SIZE_USB_PACKET-1); i++)
							  {
							  if((*fName)!='\0')
								  {
								  OutputPacketBuffer.data[i]=(*fName);
								  }
							  else break;
							  fName++;
							  }
						  OutputPacketBuffer.data[i]='\0';
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							  {
							  return result;
							  }

						  //Now get the response packet from the firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							  {

							  return result;
							  }
						  result=(FRESULT)InputPacketBuffer.data[0];
						  }
					  return result;
					  }

				  FRESULT f_mkdir(char* fName)
					  {
					  /* Create a Directory on the device... */
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					  unsigned int i;
					  FRESULT result;

					  result=FR_DISK_ERR;
					  if(ConnectedUser())
						  {

						  stopDeviceRunning();

						  OutputPacketBuffer.data[0]=CMD_MKDIR;
						  for(i=4; i<(SIZE_USB_PACKET-1); i++)
							  {
							  if((*fName)!='\0')
								  {
								  OutputPacketBuffer.data[i]=(*fName);
								  }
							  else break;
							  fName++;
							  }
						  OutputPacketBuffer.data[i]='\0';
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							  {
							  return result;
							  }

						  //Now get the response packet from the firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							  {

							  return result;
							  }
						  result=(FRESULT)InputPacketBuffer.data[0];
						  }
					  return result;
					  }
				  FRESULT f_opendir(char* fName)
					  {
					  /* open a directory on device for listing... */
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					  unsigned int i;
					  FRESULT result;

					  result=FR_DISK_ERR;
					  if(ConnectedUser())
						  {

						  stopDeviceRunning();

						  OutputPacketBuffer.data[0]=CMD_OPEN_DIR;
						  for(i=4; i<(SIZE_USB_PACKET-1); i++)
							  {
							  if((*fName)!='\0')
								  {
								  OutputPacketBuffer.data[i]=(*fName);
								  }
							  else break;
							  fName++;
							  }
						  OutputPacketBuffer.data[i]='\0';
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							  {
							  return result;
							  }

						  //Now get the response packet from the firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							  {

							  return result;
							  }
						  result=(FRESULT)InputPacketBuffer.data[0];
						  }
					  return result;
					  }

				  FRESULT f_readdir(USB_PACKET* output)
					  {
					  /* read a previously opened directory entry on device... */
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  FRESULT result;

					  result=FR_DISK_ERR;
					  if(ConnectedUser())
						  {

						  stopDeviceRunning();

						  OutputPacketBuffer.data[0]=CMD_READ_DIR;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							  {
							  return result;
							  }

						  //Now get the response packet from the firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &output->data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							  {
							  return result;
							  }
						  result=(FRESULT)output->data[0];
						  }
					  return result;
					  }

				  FRESULT f_readdirrewind(USB_PACKET* output)
					  {
					  /* rewind directory list... */
					  USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					  FRESULT result;

					  result=FR_DISK_ERR;
					  if(ConnectedUser())
						  {

						  stopDeviceRunning();

						  OutputPacketBuffer.data[0]=CMD_READ_DIR_REWIND;
						  //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						  if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							  {
							  return result;
							  }

						  //Now get the response packet from the firmware.
						  //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						  if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &output->data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							  {
							  return result;
							  }
						  result=(FRESULT)output->data[0];
						  }
					  return result;
					  }

		private: String^ ExportMap_Click(System::String^ fileName, unsigned long address, unsigned long endAddress, unsigned char* inptr) 
					 {
					 String^			responseString;
					 SaveFileDialog^	dialog_ExportHex;

					 responseString=getPCLocalTimeString()+"Export Memory Map File \"";
					 if(fileName=="")
						 {

						 dialog_ExportHex= gcnew(SaveFileDialog);
						 dialog_ExportHex->Filter= "Text files (*.txt)|*.txt|All files (*.*)|*.*";

						 //Open a show dialog box for the "Save As" for the hex file
						 if (dialog_ExportHex->ShowDialog() == ::System::Windows::Forms::DialogResult::OK)
							 {
							 fileName=dialog_ExportHex->FileName; 
							 }
						 else
							 {

							 }

						 }

					 responseString+=fileName+"\": ";
					 if(fileName!="")
						 {
						 responseString+=writeMapFile(fileName, address, endAddress, inptr);
						 OpenAndShowFile(fileName);
						 }
					 else
						 {
						 responseString+="Cancelled.";
						 }
					 return responseString;
					 }

		private: String^ OpenBinaryFile(System::String^ fileName, int* result) 
					 {
					 String^			responseString;
					 unsigned int	done;
					 OpenFileDialog^ dialog;
					 unsigned long   n;
					 *result=0;
					 responseString="Import Binary File ";
					 if(fileName=="")
						 {
						 dialog=gcnew(OpenFileDialog);
						 dialog->Filter="Binary Files |*.bin |All files (*.*)|*.*";
						 dialog->FileName="*.bin";
						 /* Open a show dialog box for the "Put As" for the hex file */
						 if (dialog->ShowDialog() == ::System::Windows::Forms::DialogResult::OK)
							 {
							 fileName=dialog->FileName;		
							 }
						 else
							 {

							 }

						 }

					 if(fileName!="")
						 {
						 for(n=0; n<MAX_PROGRAM_MEMORY; n++)ProgramMemory[n]=0xFF;
						 for(n=0; n<MAX_CONFIG_MEMORY; n++)ConfigMemory[n]=0xFF;
						 ReadFile(fileName, 0, &ProgramMemory[0], PROGRAM_ADDRESS_TOP, &done);
						 responseString+="\""+fileName+"\": "+formatStringFloat((double)done, 0)+" B.";
						 *result=1;
						 }
					 else
						 {
						 responseString+=": Cancelled.";
						 }				
					 return responseString;
					 }

		private: String^ OpenHexFile(System::Object^  sender, System::EventArgs^  e, int* result) 
					 {
					 String^		responseString;
					 String^		fileSupportBuffer;
					 FileStream^	fileSupportFileStream;
					 StreamReader^	fileSupportStreamReader;
					 Stream^		myStream;

					 unsigned long	totalN, totalConfig;
					 unsigned long	extendedAddress;
					 unsigned long	n=0;
					 bool			hexFileEOF;
					 bool			hexFileError;
					 unsigned int	j;
					 unsigned char	checksumCalculated;

					 *result=0;
					 responseString="Import Hex File ";

					 OpenFileDialog^ openFileDialog1=gcnew OpenFileDialog;

					 // Set the parameters for the open file dialog box

					 openFileDialog1->Filter = "Hex files (*.hex)|*.hex|All files (*.*)|*.*";
					 openFileDialog1->FilterIndex = 1;
					 openFileDialog1->RestoreDirectory = true;

					 // Try to delete any previous file objects if they exist

					 try
						 {
						 if(fileSupportFileStream)
							 {
							 delete fileSupportFileStream;
							 }
						 }
					 catch(...)
						 {
						 responseString="Error.";
						 return responseString;
						 }

					 try
						 {
						 if (fileSupportStreamReader)
							 {
							 fileSupportStreamReader->Close();
							 delete (IDisposable^)fileSupportStreamReader;
							 }
						 }
					 catch(...)
						 {
						 responseString="Error.";
						 return responseString; 
						 }

					 // Set the hex file error detection to false initially
					 hexFileError = false;
					 // Open the dialog
					 if (openFileDialog1->ShowDialog() == ::System::Windows::Forms::DialogResult::OK)
						 {
						 //if they pressed OK and a file was selected
						 if ( (myStream = openFileDialog1->OpenFile()) != nullptr )
							 {
							 //If there was a file selected
							 try
								 {
								 //Try to open the file to read
								 fileSupportFileStream = gcnew FileStream(openFileDialog1->FileName, FileMode::Open, FileAccess::Read);
								 fileSupportStreamReader = gcnew StreamReader(fileSupportFileStream);
								 }
							 catch(...)
								 {
								 //If we couldn't open the file then destroy any of the file
								 //  support variables that may exist
								 if(fileSupportFileStream)
									 {
									 fileSupportFileStream->Close();
									 delete fileSupportFileStream;
									 }

								 if(myStream)
									 {
									 myStream->Close();
									 delete myStream;
									 }
								 responseString+="Error.";
								 // There was an error so bail
								 return responseString;
								 }

							 // Initially indicate that we haven't reached the end of file
							 hexFileEOF=false;
							 totalN=0;
							 totalConfig=0;

							 for(n=0; n<MAX_PROGRAM_MEMORY; n++)ProgramMemory[n]=0xFF;
							 for(n=0; n<MAX_CONFIG_MEMORY; n++)ConfigMemory[n]=0xFF;

							 // Start to read the file by reading a new line
							 try
								 {
								 while ((fileSupportBuffer = fileSupportStreamReader->ReadLine()) && (hexFileEOF == false))
									 {
									 unsigned long recordLength;
									 unsigned long addressField;
									 unsigned long recordType;
									 unsigned long checksum;
									 String^ dataPayload;

									 /* Trim off the white space from the line */

									 try
										 {
										 fileSupportBuffer=fileSupportBuffer->Trim();
										 }
									 catch(...)
										 {
										 fileSupportBuffer="";
										 responseString="Error.";
										 return responseString;
										 }

									 // If the line wasn't blank
									 if(fileSupportBuffer->Length > 0)
										 {

										 if(fileSupportBuffer[0] != ':')
											 {
											 // If the first character of the line wasn't ":" then
											 // something is wrong with the hex file
											 // DEBUG_OUT("ERROR: no leading ':' in row");
											 hexFileError = true;
											 }
										 else
											 {
											 // remove the ":" from the record
											 fileSupportBuffer = fileSupportBuffer->Substring(1,(fileSupportBuffer->Length-1));
											 }

										 // get the record length, address, record type, data, and checksum of the line
										 recordLength = StringToHex(fileSupportBuffer->Substring(0,2));
										 String^ temp = fileSupportBuffer->Substring(2,4);
										 addressField = StringToHex(fileSupportBuffer->Substring(2,4));
										 recordType = StringToHex(fileSupportBuffer->Substring(6,2));
										 dataPayload = fileSupportBuffer->Substring(8,recordLength*2);
										 checksum = StringToHex(fileSupportBuffer->Substring((recordLength*2)+8,2));

										 // Initialize the checksum value to 0
										 checksumCalculated = 0;

										 // For each byte in the data payload length
										 for(j=0;j<(recordLength+4);j++)
											 {
											 // Calculate the checksum
											 checksumCalculated += (unsigned char)StringToHex(fileSupportBuffer->Substring(j*2,2));
											 }

										 // complete the checksum calculation
										 checksumCalculated = (~checksumCalculated) + 1;

										 //  If the calculated checksum doesn't match the checksum read
										 //  from the file
										 if((checksumCalculated & 0x000000FF) != checksum)
											 {
											 // then error out of the function
											 // DEBUG_OUT("ERROR: Checksum error");
											 hexFileError = true;
											 }

										 if(hexFileError == false)
											 {
											 switch(recordType)
												 {
												 case HEX_FILE_EXTENDED_LINEAR_ADDRESS:
													 // If this record is an extended address record then 
													 // save off the extended address value so we can later
													 // add it to each of the address fields that we read
													 extendedAddress = StringToHex(dataPayload);
													 break;
												 case HEX_FILE_EOF:
													 hexFileEOF = true;
													 break;
												 case HEX_FILE_DATA:
													 {
													 unsigned long totalAddress;
													 // The total address is the extended address plus the current
													 // address field.
													 totalAddress=((extendedAddress << 16) + addressField);
													 for(j=0;j<recordLength;j++)
														 {
														 unsigned char data1;
														 //	Record the data from the hex file into the memory allocated
														 //  for that specific memory region.
														 if(totalAddress<MAX_PROGRAM_MEMORY)
															 {
															 totalN++;
															 data1=(unsigned char)StringToHex(dataPayload->Substring(j*2,2));
															 ProgramMemory[totalAddress++]=data1;
															 }
														 else
															 {
															 if((totalAddress-CONFIG_MEMORY_START)<MAX_CONFIG_MEMORY)
																 {
																 totalConfig++;
																 data1=(unsigned char)StringToHex(dataPayload->Substring(j*2,2));
																 ConfigMemory[(totalAddress-CONFIG_MEMORY_START)]=data1;
																 ProgramMemory[(totalAddress)]=data1;
																 totalAddress++;
																 }
															 }
														 }

													 }
													 break;

												 default:
													 break;
												 }
											 }
										 else
											 {
											 //  If there was an error in the hex file then 
											 //  return from the function
											 //  DEBUG_OUT("ERROR: Error in hex file somewhere");

											 try
												 {
												 if(fileSupportFileStream)
													 {
													 fileSupportFileStream->Close();
													 delete fileSupportFileStream;
													 }
												 }catch(...){}

												 try
													 {
													 if (fileSupportStreamReader)
														 {
														 fileSupportStreamReader->Close();
														 delete (IDisposable^)fileSupportStreamReader;
														 }
													 }catch(...){}

													 try
														 {
														 if(myStream)
															 {
															 myStream->Close();
															 delete myStream;
															 }
														 }catch(...){}
														 responseString+="Error.";
														 return responseString;
											 }
										 }
									 }


								 }
							 catch(...)
								 {
								 responseString="Error.";
								 return responseString;

								 }
							 responseString+=openFileDialog1->FileName;
							 responseString+=": ";
							 if(hexFileError)
								 {
								 responseString+="Error. "; 
								 return responseString;
								 }
							 else responseString+="Ok.\r\n";
							 responseString+=getPCLocalTimeString()+"Data: ";
							 responseString+=formatStringFloat((float)totalN, 0);
							 responseString+=" B. Config: ";
							 responseString+=formatStringFloat((float)totalConfig, 0);
							 responseString+=" B. Memory: ";
							 responseString+=formatStringFloat(100.0*((float)totalN)/((float)MAX_PROGRAM_MEMORY), 1);
							 responseString+="%";
							 *result=1;
#if 0						
							 for(n=0; n<MAX_CONFIG_MEMORY; n+=2)
								 {
								 responseString+=HexToString((n+CONFIG_MEMORY_START), 4);
								 responseString+=": ";
								 responseString+=HexToString(ConfigMemory[n], 2);
								 responseString+="\r\n";
								 }
#endif	
							 // If the hex file completed successfully, then enable any buttons
							 }
						 else
							 {
							 //DEBUG_OUT("---- Couldn't read the specified hex file ----");
							 }
						 }
					 else
						 {
						 //DEBUG_OUT("---- Open hex file terminated ----");
						 responseString+="Cancelled.";
						 return responseString;
						 }

					 try
						 {
						 if(fileSupportFileStream)
							 {
							 fileSupportFileStream->Close();
							 delete fileSupportFileStream;
							 }
						 }catch(...){}

						 try
							 {
							 if (fileSupportStreamReader)
								 {
								 fileSupportStreamReader->Close();
								 delete (IDisposable^)fileSupportStreamReader;
								 }
							 }catch(...){}

							 try
								 {
								 if(myStream)
									 {
									 myStream->Close();
									 delete myStream;
									 }
								 }catch(...){}
								 return responseString;
					 }


				 System::String^ readAllPCDirectoryEntries(System::String^ path, FRESULT* fresult, System::Windows::Forms::TreeNode^ intree, std::map<std::string, unsigned int> *currentTreeDirectory)
					 {
					 System::String^ resultString;
					 cli::array<System::String^, 1>^ directoryListing;
					 int i;
					 double fileSize=0.0;
					 System::String^ fargString;
					 System::String^ argString;
					 System::IO::FileInfo^ fileInfo;

					 resultString="Error";
					 currentTreeDirectory->clear();
					 intree->Nodes->Clear();
					 if(Directory::Exists(path))
						 {
						 directoryListing=Directory::GetDirectories(path);
						 i=0;
						 while(i<directoryListing->Length)
							 {
							 fargString=getFileNameFromPath(directoryListing[i]);
							 argString="["+fargString+"]";
							 System::Windows::Forms::TreeNode^ mTreeNode;
							 mTreeNode=gcnew System::Windows::Forms::TreeNode();
							 mTreeNode->Text=argString;
							 mTreeNode->Name=path+"\\"+fargString;
							 intree->Nodes->Add(mTreeNode);
							 currentTreeDirectory->insert(std::pair<std::string, unsigned int>(getStdStringFromString(fargString), (unsigned int)fileSize));
							 i++;
							 }

						 directoryListing=Directory::GetFiles(path);
						 i=0;
						 while(i<directoryListing->Length)
							 {
							 fargString=getFileNameFromPath(directoryListing[i]);
							 fileInfo=gcnew FileInfo(directoryListing[i]);
							 fileSize=(double)fileInfo->Length;
							 delete fileInfo;
							 argString=fargString+" ("+formatStringFileSize((double)fileSize)+")";
							 System::Windows::Forms::TreeNode^ mTreeNode;
							 mTreeNode=gcnew System::Windows::Forms::TreeNode();
							 mTreeNode->Text=argString;
							 mTreeNode->Name=path+"\\"+fargString;
							 intree->Nodes->Add(mTreeNode);
							 currentTreeDirectory->insert(std::pair<std::string, unsigned int>(getStdStringFromString(fargString), (unsigned int)fileSize));
							 i++;
							 }
						 resultString="Ok";
						 intree->TreeView->Refresh();

						 }
					 return resultString;
					 }

				 System::String^ readAllDirectoryEntries(char* path, FRESULT* fresult, System::Windows::Forms::TreeNode^ intree, std::map<std::string, unsigned int> *currentTreeDirectory)
					 {
					 System::String^ resultString;
					 System::String^ argString;
					 System::String^ fargString;
					 unsigned short itemSize;
					 USB_PACKET InputPacketBuffer;
					 double fileSize;

					 (*fresult)=f_opendir(path);
					 resultString="";
					 InputPacketBuffer.fdir.fname[0]=0x20;
					 intree->Nodes->Clear();
					 currentTreeDirectory->clear();
					 while((InputPacketBuffer.fdir.fname[0]!='\0')&&((*fresult)==FR_OK))
						 {
						 (*fresult)=f_readdir(&InputPacketBuffer);
						 if((*fresult)==FR_OK)
							 {
							 itemSize=(unsigned short)InputPacketBuffer.fdir.lfsize;
							 fargString=getStringFromUnsignedCharArrayUpTo((unsigned char*)&InputPacketBuffer.fdir.fname[0], itemSize);

							 if(InputPacketBuffer.fdir.fattrib & AM_DIR)
								 {
								 argString="["+fargString+"]";
								 }
							 else
								 {
								 fileSize=(double)InputPacketBuffer.fdir.fsize;
								 argString=fargString+" ("+formatStringFileSize((double)InputPacketBuffer.fdir.fsize)+")";
								 }
							 resultString+=argString+"\r\n";
							 }
						 else break;

						 if(InputPacketBuffer.fdir.fname[0]!='\0')
							 {
							 System::Windows::Forms::TreeNode^ mTreeNode;
							 mTreeNode=gcnew System::Windows::Forms::TreeNode();
							 mTreeNode->Text=argString;
							 mTreeNode->Name=getStringFromUnsignedCharArrayUpTo((unsigned char*)path, MAX_PATH_LENGTH-1-(fargString->Length))+"\\"+fargString;
							 if(InputPacketBuffer.fdir.fattrib & AM_DIR)mTreeNode->Name+="\\";
							 intree->Nodes->Add(mTreeNode);
							 currentTreeDirectory->insert(std::pair<std::string, unsigned int>(getStdStringFromString(fargString), (unsigned int)fileSize));
							 }
						 }
					 if(intree->GetNodeCount(true)>0)intree->Nodes[0]->TreeView->Sort();
					 return resultString;
					 }

				 FRESULT f_read(unsigned char* outBuffer, unsigned int numBytes, unsigned int* numBytesRead)
					 {
					 /* Read from a file on device... */
					 USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					 USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					 unsigned int i;
					 unsigned int j;
					 unsigned int k;
					 unsigned int respn;
					 unsigned char* ptr;
					 FRESULT result;

					 result=FR_DISK_ERR;
					 respn=0;
					 if(ConnectedUser())
						 {
						 result=FR_OK;
						 while((result==FR_OK)&&(numBytes>0))
							 {
							 OutputPacketBuffer.data[0]=CMD_READ_FILE;
							 if(numBytes>=(SIZE_USB_PACKET-4))
								 {
								 i=(SIZE_USB_PACKET-4);
								 }
							 else
								 {
								 i=numBytes;
								 }
							 j=i;
							 OutputPacketBuffer.data[2]=(unsigned char)(i);
							 OutputPacketBuffer.data[3]=(unsigned char)(i>>8);
							 //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
							 if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
								 {
								 result=FR_DISK_ERR;
								 break;
								 }
							 //Now get the response packet from the firmware.
							 //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
							 if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
								 {
								 result=FR_DISK_ERR;
								 break;
								 }
							 result=(FRESULT)InputPacketBuffer.data[0];
							 if(result==FR_OK)
								 {
								 i=((unsigned int)InputPacketBuffer.data[3]<<8) & 0xFF00;
								 i+=(unsigned int)InputPacketBuffer.data[2];
								 }
							 else
								 {
								 i=0;
								 }
							 ptr=(unsigned char*)&InputPacketBuffer.data[4];
							 k=i;
							 while(k--)
								 {
								 *outBuffer++=*ptr++;
								 }
							 numBytes-=i;
							 respn+=i;
							 if(i!=j)break;
							 }
						 }
					 (*numBytesRead)=respn;
					 return result;
					 }

				 FRESULT f_write(unsigned char* inBuffer, unsigned int numBytes, unsigned int* numBytesWritten)
					 {
					 /* write to a file on device... */
					 USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					 USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					 int i;
					 int j;
					 unsigned char* ptr;
					 FRESULT result;

					 result=FR_DISK_ERR;
					 *numBytesWritten=0;

					 if(ConnectedUser())
						 {
						 result=FR_OK;
						 while((result==FR_OK)&&(numBytes>0))
							 {

							 OutputPacketBuffer.data[0]=CMD_WRITE_FILE;
							 if(numBytes>=(SIZE_USB_PACKET-4))
								 {
								 i=(SIZE_USB_PACKET-4);
								 }
							 else
								 {
								 i=numBytes;
								 }
							 j=i;
							 OutputPacketBuffer.data[2]=(unsigned char)(i);
							 OutputPacketBuffer.data[3]=(unsigned char)(i>>8);
							 ptr=(unsigned char*)&OutputPacketBuffer.data[4];
							 while(i--)
								 {
								 *ptr++=*inBuffer++;
								 }
							 //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
							 if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
								 {
								 result=FR_DISK_ERR;
								 break;
								 }
							 //Now get the response packet from the firmware.
							 //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
							 if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
								 {
								 result=FR_DISK_ERR;
								 break;
								 }
							 result=(FRESULT)InputPacketBuffer.data[0];
							 if(result==FR_OK)
								 {
								 i=((unsigned int)InputPacketBuffer.data[3]<<8);
								 i+=(unsigned int)InputPacketBuffer.data[2];
								 }
							 else
								 {
								 i=0;
								 }
							 numBytes-=i;
							 (*numBytesWritten)+=i;
							 if(i!=j)break;
							 }
						 }
					 return result;
					 }

				 FRESULT f_close(void)
					 {
					 /*

					 close a previously opened file on device...

					 */
					 USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					 USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					 FRESULT result;

					 result=FR_DISK_ERR;
					 if(ConnectedUser())
						 {
						 stopDeviceRunning();
						 OutputPacketBuffer.data[0]=CMD_CLOSE_FILE;
						 //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						 if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							 {
							 return result;
							 }
						 //Now get the response packet from the firmware.
						 //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						 if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							 {
							 return result;
							 }
						 result=(FRESULT)InputPacketBuffer.data[0];
						 }
					 return result;
					 }


				 int restoreDefaultDeviceSettings(System::Void)
					 {

					 USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					 USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					 int result;

					 result=0;
					 if(ConnectedUser())
						 {
						 stopDeviceRunning();

						 OutputPacketBuffer.data[0]=CMD_RESTORE_DEFAULTS;
						 //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						 if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							 {
							 return result;
							 }
						 //Now get the response packet from the firmware.
						 //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						 if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							 {
							 return result;
							 }
						 result=1;
						 }
					 return result;
					 }

				 int resetDevice(System::Void)
					 {

					 USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					 USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					 int result;

					 result=0;
					 if(ConnectedUser())
						 {
						 stopDeviceRunning();

						 OutputPacketBuffer.data[0]=CMD_RESET;
						 //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						 if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							 {
							 return result;
							 }
						 //Now get the response packet from the firmware.
						 //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						 if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							 {
							 return result;
							 }
						 result=1;
						 }
					 return result;
					 }

				 int resetBootDevice(System::Void)
					 {

					 USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					 USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					 int result;

					 result=0;
					 if(Connection_Status)
						 {
						 OutputPacketBuffer.data[0]=CMD_BOOT_RESET;
						 //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						 if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							 {
							 return result;
							 }
						 //Now get the response packet from the firmware.
						 //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						 if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_FILE) != SIZE_USB_PACKET)
							 {
							 return result;
							 }
						 result=1;
						 }
					 return result;
					 }

				 System::String^ getTimeFromDeviceString(System::Void)
					 {
					 getTimeFromDevice(&systemTime);
					 systemTime.show=(SHOW_DAY | SHOW_MONTH | SHOW_YEAR | SHOW_HOURS | SHOW_MINUTES | SHOW_SECONDS | SHOW_WDAY);
					 return getTimeString(&systemTime);
					 }

				 System::Void syncTime()
					 {

					 TIME_T timeDev;
					 TIME_T timePC;
					 unsigned long durationSeconds;
					 DATA_LOGGER tempUDL;
					 int getResult;

					 getResult=getDataLogger(&tempUDL);
					 getLocalTimePC(&timePC);

					 if((getResult)&&(tempUDL.lastSyncTime.updated & TIME_UPDATED))
						 {
						 durationSeconds=getDurationTotalSeconds(&timePC, &tempUDL.lastSyncTime);
						 }
					 else
						 {
						 durationSeconds=MAX_SYNC_PERIOD_SECS;
						 }

					 if(durationSeconds>=MAX_SYNC_PERIOD_SECS)
						 {
						 String^ message = "The USB Data Logger's Time Has Not Recently been Synchronised.\r\n Update the USB Data Logger's Time?";
						 String^ caption = "Warning: Old Time";
						 MessageBoxButtons buttons = MessageBoxButtons::YesNo;
						 System::Windows::Forms::DialogResult result;
						 result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING );

						 stopTimer1();
						 if (result==::DialogResult::Yes)
							 {
							 getLocalTimePC(&timePC);
							 getTimeFromDevice(&timeDev);
							 durationSeconds=getDurationTotalSeconds(&timePC, &timeDev);
							 localSettings.lastSyncDifference=durationSeconds;
							 sendLocalTime();
							 }
						 startTimer1();
						 }
					 else
						 {
						 getLocalTimePC(&timePC);
						 getTimeFromDevice(&timeDev);
						 durationSeconds=getDurationTotalSeconds(&timePC, &timeDev);
						 localSettings.lastSyncDifference=durationSeconds;
						 if(durationSeconds<MAX_SYNC_PERIOD_SECS_DIFFERENT_TIME)
							 {
							 sendLocalTime();
							 }
						 else
							 {
							 String^ message = "The USB Data Logger's Time is Different to the Local PC's Time.\r\n Update the USB Data Logger's Time Anyway?";
							 String^ caption = "Warning: Time Conflict";
							 MessageBoxButtons buttons = MessageBoxButtons::YesNo;
							 System::Windows::Forms::DialogResult result;
							 result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING);
							 stopTimer1();
							 if (result==::DialogResult::Yes)
								 {
								 sendLocalTime();
								 }
							 startTimer1();
							 }
						 }
					 }

		private: int disConnectGUI(System::Object^ sender, System::EventArgs^ e)
					 {
					 if(!((Connection_Status)||(SerialPortConnected)))
						 {
						 bootLoaderStatus=0;
						 connectGUIBootLoaderStatus(0);
						 this->labelTimeDevice->Text="Local Time:";
						 this->labelTimeFromDeviceX->Text="-";
						 this->labelLastTime->Text="-";
						 this->labelVDD->Text="-";
						 this->labelLastTime->BackColor=NORMAL_COLOUR;
						 this->labelVDD->BackColor=NORMAL_COLOUR;
						 this->numericUpDownBatteryProtect->Enabled=false;
						 this->checkBoxAutoSync->Enabled=false;
						 this->checkBoxBatteryProtection->Enabled=false;
						 this->checkBoxSystemLogging->Enabled=false;
						 this->checkBoxSystemLogUSB->Enabled=false;
						 this->checkBoxSystemLogUSB->CheckState=System::Windows::Forms::CheckState::Indeterminate;
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Disconnected.\r\n");
						 this->titleBase="USB Data Logger PC Host Version: "+formatStringFloat((double)HOST_VERSION, 2)+" Disconnected...";
						 initVMEnvironment(&lastUDL.dataLogger.ven);
						 updateScripts(this->treeViewScripts, &lastUDL.dataLogger, "Device Scripts: ", 1);
						 this->Text=this->titleBase+TITLE_MIDDLE_STRING+this->lastOpenedFile;
						 setButtons(true);
						 this->DeviceMenu->Enabled=false;
						 this->timeToolStripMenuItem->Enabled=false;
						 this->memoryCardToolStripMenuItem->Enabled=false;
						 this->stopDeviceToolStripMenuItem_Click(sender, e);
						 cardInfo.cERROR=ERROR_CLOSED_CARD;
						 updateMemoryCardRoot(this->treeViewFiles);
						 }
					 return 0;
					 }

		private: int disConnect(void)
					 {

					 if(Connection_Status)
						 {
						 if(MyLibusbDeviceHandle!=NULL)usb_close(MyLibusbDeviceHandle);
						 MyLibusbDeviceHandle=NULL;
						 Connection_Status=0;
						 blockLongProcesses=0;
						 }
					 return 0;
					 }

		private: int checkConnectionStatus(void)
					 {
					 int j;
					 int c;

					 /* returns 1 if there was a change... */
					 j=0;
					 if(Connection_Status)
						 {
						 c=getBootLoaderStatus(0);
						 if(c>=0)
							 {
							 j=0;
							 }
						 else
							 {
							 j=1;
							 disConnect();
						  }
						 }
					 else
						 {
						 connect();
						 if(Connection_Status)
							 {
							 j=1;
							 }
						 else
							 {
							 j=0;
							 }
						 }

					 if(SerialPortConnected!=SerialPortConnectedOld)
						 {
						 c=getBootLoaderStatus(0);
							j=1;
							SerialPortConnectedOld=SerialPortConnected;
						 }
					 return j;
					 }

		private: System::Void updatePCFileRoot(Windows::Forms::TreeView^ ttree)
					 {

					 System::Windows::Forms::TreeNode^ mTreeNode;

					 if(ttree->GetNodeCount(true)>0)
						 {


						 }
					 else
						 {
						 ttree->Nodes->Clear();
						 ttree->ShowPlusMinus=true;
						 ttree->Nodes->Add(gcnew System::Windows::Forms::TreeNode());
						 }
					 mTreeNode=ttree->Nodes[0];
					 mTreeNode->Name=".";
					 mTreeNode->Text="[.]";
					 }

		private: System::Void updateMemoryCardRoot(Windows::Forms::TreeView^ ttree)
					 {

					 System::Windows::Forms::TreeNode^ mTreeNode;
					 if((cardInfo.cERROR==ERROR_ALL_OK)&&(ttree->GetNodeCount(true)>0))
						 {

						 }
					 else
						 {
						 this->treeViewFiles->Nodes->Clear();
						 this->treeViewFiles->ShowPlusMinus=true;
						 this->treeViewFiles->Nodes->Add(gcnew System::Windows::Forms::TreeNode());
						 }
					 mTreeNode=ttree->Nodes[0];
					 mTreeNode->Name="\\";
					 mTreeNode->Text="[";
					 mTreeNode->Text+=getMemoryCardInfoString(&cardInfo)+"]";
					 if(cardInfo.cERROR==ERROR_ALL_OK)
						 {


						 }
					 else
						 {
						 ttree->Nodes[0]->Nodes->Clear();
						 this->treeViewFiles->ShowPlusMinus=false;				 
						 }

					 }

		private: System::Void updateHelp(Windows::Forms::TreeView^ ttree)
					 {

					 int i;
					 std::string name;
					 CalcContext calc;
					 System::Windows::Forms::TreeNode^ mTreeNode;
					 System::Windows::Forms::TreeNode^ mTreeNode2;
					 System::Windows::Forms::TreeNode^ mTreeNode3;

					 ttree->Nodes->Clear();
					 ttree->ShowPlusMinus=true;
					 ttree->Nodes->Add(gcnew System::Windows::Forms::TreeNode());
					 mTreeNode=ttree->Nodes[0];
					 mTreeNode->Name="";
					 mTreeNode->Text="[Global Functions]";

					 calc.clearExpressions();
					 calc.insertContext();
					 i=0;
					 do
						 {
						 mTreeNode=gcnew System::Windows::Forms::TreeNode();
						 mTreeNode->Name="";
						 name=calc.getHelpGlobalFunctions(i);
						 if(name!="")
							 {
							 mTreeNode->Name=getStringFromStdString(&name)+"(";
							 mTreeNode->Text=getStringFromStdString(&name)+"("+formatStringFloat((double)globalFunctionArgTable[globalFunctionIDTable[i] & 0xFF], 0)+")";
							 mTreeNode->Tag=gcnew System::Int32((unsigned long)i | GLOBAL_FUNCTIONS_TAG);
							 ttree->Nodes[0]->Nodes->Add(mTreeNode);
							 }
						 i++;
						 }
						 while(name!="");
						 ttree->Nodes[0]->Text="[Global Functions: "+formatStringFloat((double)i-1, 0)+"]";

						 mTreeNode=gcnew System::Windows::Forms::TreeNode();
						 mTreeNode->Name="";
						 mTreeNode->Text="[Global Variables]";
						 ttree->Nodes->Add(mTreeNode);

						 std::map<std::string, std::vector<ADDRESS_TYPE>>::iterator myIterator;
						 std::vector<ADDRESS_TYPE> v;

						 myIterator=calc.globalVariables.begin();
						 i=0;
						 while(myIterator!=calc.globalVariables.end())
							 {
							 mTreeNode3=gcnew System::Windows::Forms::TreeNode();
							 mTreeNode3->Name="";
							 name=myIterator->first;
							 v=myIterator->second;
							 if(name!="")
								 {
								 mTreeNode3->Name=getStringFromStdString(&name);
								 mTreeNode3->Text=getStringFromStdString(&name);
								 mTreeNode3->Tag=gcnew System::Int32(v[POSITION_OF_TAG]);
								 if(v[POSITION_OF_SIZE]>0)mTreeNode3->Text+=" ("+formatStringFileSize((double)v[POSITION_OF_SIZE])+")";
								 mTreeNode->Nodes->Add(mTreeNode3);
								 }
							 myIterator++;
							 i++;
							 }		 
						 mTreeNode->Text="[Global Variables: "+formatStringFloat((double)i-1, 0)+"]";

						 mTreeNode=gcnew System::Windows::Forms::TreeNode();
						 mTreeNode->Name="";
						 mTreeNode->Text="[Define Constants]";
						 ttree->Nodes->Add(mTreeNode);

						 i=0;
						 do
							 {
							 mTreeNode2=gcnew System::Windows::Forms::TreeNode();
							 mTreeNode2->Name="";
							 name=calc.getHelpDefineConstants(i);
							 if(name!="")
								 {
								 mTreeNode2->Name=getStringFromStdString(&name);
								 mTreeNode2->Text=getStringFromStdString(&name)+": "+formatStringConstant((double)definesValueTable[i], 6);
								 mTreeNode2->Tag=gcnew System::Int32((unsigned long)i | DEFINE_CONSTANTS_TAG);
								 mTreeNode->Nodes->Add(mTreeNode2);
								 }
							 i++;
							 }
							 while(name!="");

							 mTreeNode->Text="[Define Constants: "+formatStringFloat((double)i-1, 0)+"]";

							 mTreeNode=gcnew System::Windows::Forms::TreeNode();
							 mTreeNode->Name="";
							 mTreeNode->Text="[Header Objects]";
							 ttree->Nodes->Add(mTreeNode);

							 i=0;
							 do
								 {
								 mTreeNode2=gcnew System::Windows::Forms::TreeNode();
								 mTreeNode2->Name="";
								 name=calc.getHelpHeaderObjects(i);
								 if(name!="")
									 {
									 mTreeNode2->Name=getStringFromStdString(&name);
									 mTreeNode2->Text=getStringFromStdString(&name);
									 mTreeNode2->Tag=gcnew System::Int32((unsigned long)i | HEADER_OBJECTS_TAG);
									 mTreeNode->Nodes->Add(mTreeNode2);
									 }
								 i++;
								 }
								 while(name!="");

								 mTreeNode->Text="[Header Objects: "+formatStringFloat((double)i-1, 0)+"]";
								 ttree->Sort();
					 }


		private: System::String^ generateHelpFile(System::String^ fileName)
					 {
					 int i;
					 std::string name;
					 CalcContext calc;
					 System::String^ result;
					 std::map<std::string, std::vector<ADDRESS_TYPE>>::iterator myIterator;
					 std::map<std::string, std::vector<double>>::iterator myIterator2;
					 std::map<std::string, double>::iterator myIterator3;
					 unsigned int maxWidth;
					 System::Windows::Forms::TreeView^ treeV;
					 std::vector<ADDRESS_TYPE> v;
					 std::vector<double> vc;
					 unsigned long tag;

					 result="";
					 calc.clearExpressions();
					 calc.insertContext();

					 result+="\r\nDefine Constants\r\n\r\n";

					 treeV=gcnew System::Windows::Forms::TreeView();
					 treeV->Nodes->Clear();
					 i=0;
					 maxWidth=80;
					 do
						 {
						 name=calc.getHelpDefineConstants(i);
						 if(name!="")
							 {
							 System::Windows::Forms::TreeNode^ mT;
							 mT=gcnew System::Windows::Forms::TreeNode();
							 mT->Name=getStringFromStdString(&name);
							 mT->Text=getHelpText(DEFINE_CONSTANTS_TAG + i, 0, maxWidth);
							 treeV->Nodes->Add(mT);
							 }
						 i++;
						 }
						 while(name!="");
						 treeV->Sort();

						 i=0;
						 while(i<treeV->Nodes->Count)
							 {
							 result+=treeV->Nodes[i]->Text+"\r\n";						 
							 i++;
							 }

						 result+="\r\nHeader Objects\r\n\r\n";
						 myIterator2=calc.headerObjects.begin();
						 i=0;
						 while(myIterator2!=calc.headerObjects.end())
							 {
							 name=myIterator2->first;
							 vc=myIterator2->second;
							 if(name!="")
								 {
								 tag=(unsigned long)vc[POSITION_OF_TAG];
								 result+=getHelpText(tag, 0, maxWidth);
								 }
							 myIterator2++;
							 i++;
							 }

						 myIterator=calc.globalFunctions.begin();
						 i=0;
						 result+="\r\nGlobal Functions\r\n\r\n";
						 while(myIterator!=calc.globalFunctions.end())
							 {
							 name=myIterator->first;
							 v=myIterator->second;
							 if(name!="")
								 {
								 tag=(unsigned long)v[POSITION_OF_TAG];
								 result+=getHelpText(tag, 0, maxWidth);
								 }
							 myIterator++;
							 i++;
							 }

						 myIterator=calc.globalVariables.begin();
						 i=0;
						 result+="\r\nGlobal Variables\r\n\r\n";
						 while(myIterator!=calc.globalVariables.end())
							 {
							 name=myIterator->first;
							 v=myIterator->second;
							 if(name!="")
								 {
								 tag=(unsigned long)v[POSITION_OF_TAG];
								 result+=getHelpText(tag, 0, maxWidth)+"\r\n";
								 }
							 myIterator++;
							 i++;
							 }

						 WriteFileFromString(fileName, result);
						 return result;		 
					 }

		private: System::Void connectGUI(System::Object^ sender, System::EventArgs^ e)
					 {

					 int			i;
					 int            bl;
					 int			getResult;
					 unsigned short sizes[6];
					 unsigned long  devicePORs;
					 unsigned long  bootVersion;

					 if((Connection_Status)||(SerialPortConnected))
						 {
						 totalUSBBytesWrite=0;
						 totalUSBBytesRead=0;
						 totalUSBWrites=0;
						 totalUSBReads=0;

						 /* force an update! */
						 /* Number of Retries! */

						 i=getBootLoaderStatus(&bootVersion);
						 if(i>=0)bootLoaderStatus=i; else return;


						 if(bootLoaderStatus==1)
							 {
							 connectGUIBootLoaderStatus(bootLoaderStatus);
							 if(SerialPortConnected)
								 this->titleBase="USB Data Logger PC Host Version: "+formatStringFloat((double)HOST_VERSION, 2)+". Serial BootLoader Version: "+formatStringFloat((double)SERIAL_BOOTLOADER_VERSION, 2)+". "+this->SerialPortName+" @ "+formatStringFloat((double)baudRt, 0)+" bps Connected...";
							 else
								 this->titleBase="USB Data Logger PC Host Version: "+formatStringFloat((double)HOST_VERSION, 2)+". USB BootLoader Version: "+formatStringFloat((double)bootVersion/100, 2)+". Connected...";
							 this->Text=this->titleBase+TITLE_MIDDLE_STRING+this->lastOpenedFile;
							 }
						 else
							 {
							 connectGUIBootLoaderStatus(bootLoaderStatus);
							 setWideEditorWindow(localSettings.wideEditorWindow);
							 i=0;
							 getResult=0;
							 bl=0;
							 while((i<3)&&(getResult!=1)&&(bl==0))
									{
									this->textBoxLog->ScrollToCaret();
									this->textBoxLog->AppendText(getPCLocalTimeString()+"Connect to Device: ");
									stopTimer1();
									bl=getBootLoaderStatusQuick(0);
									if(bl==0)
										{									
										getResult=setCaptiveDeviceQuick(1);
										}
									else
										{

										}
									startTimer1();
									if(getResult==1)this->textBoxLog->AppendText("Ok.\r\n");
									else this->textBoxLog->AppendText("Error.\r\n");
									i++;
									Application::DoEvents();
									}

							 if(getBootLoaderStatus(0)==1)
									{
									connectGUIBootLoaderStatus(bootLoaderStatus);
									resetBootDevice();
									disConnect();
									}
							 else
									{
									connectGUIBootLoaderStatus(bootLoaderStatus);
									if(getResult!=1)
										{
										/* Failed to reach device */
										stopTimer1();
										timerCounter1=0;
										String^ message = 
											"Failed To Reach Device! Check your Connection...\r\n";
										String^ caption = "Error: Device is not Responding...";
										MessageBoxButtons buttons = MessageBoxButtons::OK;
										System::Windows::Forms::DialogResult result;
										result = MessageBox::Show(this, message, caption, buttons, MSGBOX_ICON_ERROR);
										if (result==::DialogResult::OK)
											{
											disConnect();
											startTimer1();
											}	
										}
									else
										{	

										this->stopDeviceToolStripMenuItem_Click(sender, e);

										clearTransfers();
										getResult=getSizes(6, (unsigned short*)sizes);
										if((getResult)&&
											(sizes[0]==sizeof(DATA_LOGGER))
											&&
											(sizes[1]==sizeof(VIRTUAL_MACHINE_ENVIRONMENT))
											&&
											(sizes[2]==sizeof(VIRTUAL_MACHINE))
											&&
											(sizes[3]==sizeof(CACHE_OBJECT))
											&&
											(sizes[4]==sizeof(CARD_INFO)))
											{	

											getResult=getDataLogger(&thisUDL.dataLogger);
											lastUDL.dataLogger.pors=thisUDL.dataLogger.pors+1;
											if(getResult)
												{
												if(thisUDL.dataLogger.modes & TIME_AUTO_SYNC_MODE)
													{
													this->checkBoxAutoSync->CheckState=System::Windows::Forms::CheckState::Checked;
													this->checkBoxAutoSync->Checked=true;
													syncTime();
													}
												else
													{
													this->checkBoxAutoSync->CheckState=System::Windows::Forms::CheckState::Unchecked;
													this->checkBoxAutoSync->Checked=false;
													}
												}

											deviceFirmwareVersion=getFirmwareVersion(&devicePORs);
											if(deviceFirmwareVersion>0.0)
												{
												this->titleBase="USB Data Logger PC Host Version: "+formatStringFloat((double)HOST_VERSION, 2)+" Connected to Firmware Version: "+formatStringFloat((double)deviceFirmwareVersion, 2);
												if(getResult)this->titleBase+=" (Global PORs: "+formatStringFloat((double)devicePORs, 0)+" Local PORs: "+formatStringFloat((double)thisUDL.dataLogger.pors, 0)+")";
												this->titleBase+="...";
												}
											else 
												{
												this->titleBase="USB Data Logger PC Host Version: "+formatStringFloat((double)HOST_VERSION, 2);
												}


											this->textBoxLog->ScrollToCaret();
											this->textBoxLog->AppendText(getPCLocalTimeString()+"Established USB Connection.\r\n");

											this->textBoxLog->ScrollToCaret();
											this->textBoxLog->AppendText(getPCLocalTimeString()+"Data Structures Size Check: Ok.\r\n");

											avgInit(&localSettings.relError, AVGS);
											initSerialUSB(0);
											setCaptiveDevice(1);

											this->textBoxLog->ScrollToCaret();
											this->textBoxLog->AppendText(getPCLocalTimeString()+"Reset VM Environment: ");
											if(rewindDeviceVME())
												{
												this->textBoxLog->ScrollToCaret();
												this->textBoxLog->AppendText("Ok.\r\n");
												}
											else
												{
												this->textBoxLog->ScrollToCaret();
												this->textBoxLog->AppendText("Error.\r\n");
												}

											this->numericUpDownBatteryProtect->Enabled=true;

											logString(": PC Host Version: "+formatStringFloat((double)HOST_VERSION, 2)+" Connected...\r\n", PF_LOCAL_TIME_IF_SET, nullptr);
											this->Text=this->titleBase+TITLE_MIDDLE_STRING+this->lastOpenedFile;

											this->labelTimeDevice->Text="Device Time:";
											this->checkBoxAutoSync->Enabled=true;
											this->checkBoxBatteryProtection->Enabled=true;
											this->checkBoxSystemLogging->Enabled=true;

											this->DeviceMenu->Enabled=true;
											this->timeToolStripMenuItem->Enabled=true;
											this->memoryCardToolStripMenuItem->Enabled=true;

											}
										else
											{
											stopTimer1();
											timerCounter1=0;
											String^ message = 
												"Data Structure Sizes do not match the Firmware Sizes.\r\n\r\nFirmware Sizes:\r\n\r\n"
												+"DL:\t\t"+formatStringFloat((double)sizes[0], 0)+"\r\n"									 
												+"VME:\t\t"+formatStringFloat((double)sizes[1], 0)+"\r\n"+
												"VM:\t\t"+formatStringFloat((double)sizes[2], 0)+"\r\n"+
												"COBJ:\t\t"+formatStringFloat((double)sizes[3], 0)+"\r\n"+
												"CINF:\t\t"+formatStringFloat((double)sizes[4], 0)+"\r\n\r\nLocal Sizes:\r\n\r\nDL:\t\t"
												+formatStringFloat((double)sizeof(DATA_LOGGER), 0)+"\r\n"
												+"VME:\t\t"+formatStringFloat((double)sizeof(VIRTUAL_MACHINE_ENVIRONMENT), 0)+"\r\n"+
												"VM:\t\t"+formatStringFloat((double)sizeof(VIRTUAL_MACHINE), 0)+"\r\n"+
												"COBJ:\t\t"+formatStringFloat((double)sizeof(CACHE_OBJECT), 0)+"\r\n"+
												"CINF:\t\t"+formatStringFloat((double)sizeof(CARD_INFO), 0)+"\r\n"+
												"\r\n\r\nYou Should Install a Compatible PC Host Version,\r\nor Update the Firmware...";
											String^ caption = "Error: Possible Incompatible Firmware Version";
											MessageBoxButtons buttons = MessageBoxButtons::OK;
											System::Windows::Forms::DialogResult result;
											result = MessageBox::Show(this, message, caption, buttons, MSGBOX_ICON_ERROR);
											if (result==::DialogResult::OK)
												{
												disConnect();
												}
											startTimer1();
											}
										}
									}
							 }
						 }
					 }

		private: System::Void connect(void)
					 {

					 if (!Connection_Status) // if not connected already
						 {
						 usb_init(); /* initialize the library */
						 usb_find_busses(); /* find all busses */
						 usb_find_devices(); /* find all connected devices */

						 // Now look through the list that we just populated. We are trying to see if any of them match our device.

						 struct usb_bus *bus;
						 struct usb_device *dev;

						 for(bus = usb_get_busses(); bus; bus = bus->next)
							 {
							 for(dev = bus->devices; dev; dev = dev->next)
								 {
								 if(dev->descriptor.idVendor == MY_VID
									 && dev->descriptor.idProduct == MY_PID)
									 {
									 MyLibusbDeviceHandle = usb_open(dev); //Opens a USB device
									 break;
									 }
								 }
							 }

						 if(!MyLibusbDeviceHandle)
							 {
							 return;
							 }
						 if(usb_set_configuration(MyLibusbDeviceHandle, 1) < 0) // Sets the Active configuration of the device
							 {
							 usb_close(MyLibusbDeviceHandle);
							 return;
							 }

						 if(usb_claim_interface(MyLibusbDeviceHandle, 0) < 0) //claims the interface with the Operating System
							 {
							 //Closes a device opened since the claim interface is failed.
							 usb_close(MyLibusbDeviceHandle);
							 return ;
							 }
						 blockLongProcesses=0;
						 Connection_Status=CONNECTED; //Now status is connected
						 }
					 }

				 unsigned int goToLineColumn(unsigned int *currentLine, unsigned int *currentColumn, unsigned int toLine, unsigned int toColumn, unsigned char lineCharacter, unsigned int textPosition, unsigned char* text, unsigned int textSize)
					 {
					 unsigned int offset;
					 unsigned char c;

					 offset=textPosition;
					 while((offset>=0)&&(offset<textSize)&&(((*currentLine)!=toLine)||((*currentColumn)!=toColumn)))
						 {
						 if((*currentLine)>toLine)
							 {
							 offset--;
							 c=text[offset];
							 while((offset>=0)&&(offset<textSize)&&(c!=lineCharacter))
								 {
								 offset--;
								 c=text[offset];
								 }
							 offset++;
							 (*currentLine)--;
							 (*currentColumn)=1;
							 }
						 else
							 if((*currentLine)<toLine)
								 {
								 offset++;
								 c=text[offset];
								 while((offset>=0)&&(offset<textSize)&&(c!=lineCharacter))
									 {
									 offset++;
									 c=text[offset];
									 }
								 offset++;
								 (*currentLine)++;
								 (*currentColumn)=1;
								 }
							 else
								 if((*currentColumn)>toColumn)
									 {
									 offset-=((*currentColumn)-toColumn);
									 (*currentColumn)=toColumn;
									 }
								 else
									 if((*currentColumn)<toColumn)
										 {
										 offset+=(toColumn-(*currentColumn));
										 (*currentColumn)=toColumn;
										 }
						 }

					 if((offset>=0)&&(offset<textSize))
						 {

						 }
					 else
						 {
						 offset=0;
						 (*currentLine)=1;
						 (*currentColumn)=1;
						 }
					 return offset;
					 }

				 bool compileScripts(char* instring, unsigned int maxSize, VIRTUAL_MACHINE* vmPtr, unsigned int maxVMs, CalcContext* calc, example::Driver* driver, unsigned int* numDone, VIRTUAL_MACHINE_ENVIRONMENT* ven)
					 {
					 /*

					 Compiles A Number of Scripts to a series of VMs...

					 */

					 VM_RETURN_TYPE vmResult;
					 bool result;
					 unsigned int i;
					 unsigned long j;
					 unsigned long k;
					 unsigned int bytesWritten;
					 unsigned char id;
					 unsigned int compileSize;
					 unsigned char* ptr;
					 int stackPointer;
					 std::string listOutput;
					 std::string hexOutput;
					 unsigned int numToDo;
					 System::String^ fileName;
					 unsigned char codeImage[MAX_LIST_OUTPUT_SIZE_BUFFER_SIZE];

					 unsigned int currentLine[2];
					 unsigned int currentColumn[2];
					 unsigned char lineCharacter;
					 unsigned int currentOffset[2];

					 /* Clear the Context */
					 *numDone=0;
					 calc->clearExpressions();
					 /* Insert the Variables */
					 calc->insertContext();
					 bytesKilled=0;
					 copyPropagation=localSettings.optimizeCode;

					 /* Compile the Program */
					 this->labelUSBTraffic->Text="Out:";
					 this->statusStrip1->Refresh();
					 this->progressBar1->Value=0;
					 this->compileTaskCounter=0;
					 this->compileOutputCounter=0;
					 result=driver->parse_string(instring, "string stream");
					 this->progressBar1->Value=this->progressBar1->Maximum;
					 /* Check the result */
					 if(result)
						 {
						 /* Get the Output of the Compile */
						 currentLine[0]=1;
						 currentLine[1]=1;
						 currentColumn[0]=1;
						 currentColumn[1]=1;
						 lineCharacter='\n';
						 currentOffset[0]=0;
						 currentOffset[1]=0;

						 if(calc->expressions.size()<maxVMs)numToDo=calc->expressions.size(); else numToDo=maxVMs;
						 i=0;
						 vmResult=VM_OK;
						 calc->scriptNumber=0;
						 while((i< numToDo)&&(vmResult==VM_OK))
							 {
							 /* Clear the Machine */
							 initVM(vmPtr, 0, 0);
							 id=getFreeVMIDConsideringNames(ven, getStringFromStdString(&calc->scriptNames[i]));
							 vmPtr->execID=id;
							 /* Clear the Text Outputs */
							 listOutput="";
							 hexOutput="No Hex Output.\r\n";
							 compileSize=0;
							 stackPointer=0;
							 ptr=(unsigned char*)codeImage;
							 /* Compute Offsets to Store the Source File for the Script */
							 listOutput+="New Script: ";
							 listOutput+="Begins ("+getStdStringFromString(formatStringFloat((double)calc->scriptStarts[i].first, 0))+", "+getStdStringFromString(formatStringFloat((double)calc->scriptStarts[i].second, 0))+") ";
							 currentOffset[0]=goToLineColumn(&currentLine[0], &currentColumn[0], (unsigned int)calc->scriptStarts[i].first, (unsigned int)calc->scriptStarts[i].second, lineCharacter, currentOffset[0], (unsigned char*)instring, maxSize);
							 listOutput+="Ends ("+getStdStringFromString(formatStringFloat((double)calc->scriptEnds[i].first, 0))+", "+getStdStringFromString(formatStringFloat((double)calc->scriptEnds[i].second, 0))+")\r\n";
							 currentOffset[1]=goToLineColumn(&currentLine[1], &currentColumn[1], (unsigned int)calc->scriptEnds[i].first, (unsigned int)calc->scriptEnds[i].second, lineCharacter, currentOffset[1], (unsigned char*)instring, maxSize);
							 /* Write The Source File */
							 fileName="src"+HexToString((unsigned long)id & VM_ID_MASK, 1)+".txt";
							 WriteFileCreate(fileName, 0, (unsigned char*)&instring[currentOffset[0]], currentOffset[1]-currentOffset[0], &bytesWritten);
							 listOutput+="\r\n";
							 bytesKilled=0;
							 listOutput+=getStdStringFromString(calc->expressions[i]->listOutputHeader("", &ptr, &compileSize, &stackPointer));
							 listOutput+=getStdStringFromString(calc->expressions[i]->listOutput("", &ptr, &compileSize, &stackPointer));
							 calc->opcodesSaved.push_back((unsigned long)bytesKilled);
							 if(compileSize<MAX_LIST_OUTPUT_SIZE)
								 {
								 listOutput+="\r\n";
								 listOutput+="Compile Size: "+getStdStringFromString(myultoabaseString(compileSize, 8, 10, ' '))+" B.\r\n";
								 listOutput+="Optimization: "+getStdStringFromString(myultoabaseString(calc->opcodesSaved[i], 8, 10, ' '))+" B.";
								 if((compileSize+calc->opcodesSaved[i])>0)listOutput+=" ("+getStdStringFromString(formatStringFloat(((double)calc->opcodesSaved[i]*100.0)/(compileSize+calc->opcodesSaved[i]), 1))+" %)";
								 listOutput+="\r\n";
								 vmPtr->execLimit=compileSize;
								 }
							 else
								 {
								 compileSize=0;
								 listOutput+="\r\n";
								 listOutput+="Compile Size Error: Code Image Too Large.\r\n";
								 driver->errorOutput="Compile Size Error: Code Image Too Large.\r\n";
								 vmPtr->execLimit=compileSize;
								 result=false;
								 calc->expressionsListOutput.insert(calc->expressionsListOutput.end(), listOutput);
								 calc->expressionsHexOutput.insert(calc->expressionsHexOutput.end(), hexOutput);
								 break;
								 }
							 /* Produce the Hex Output */
							 hexOutput="";
							 j=0;
							 k=0;
							 while(j<(unsigned long)compileSize)
								 {
								 if(k==0)
									 {
									 hexOutput+="0x"+getStdStringFromString(HexToString((unsigned long)j, 4));
									 hexOutput+=": ";
									 }

								 hexOutput+=getStdStringFromString(HexToString((unsigned long)codeImage[j], 1));
								 if(k<15)
									 {
									 hexOutput+=".";
									 k++;
									 }
								 else
									 {
									 hexOutput+="\r\n";
									 k=0;
									 }
								 j++;
								 }
							 hexOutput+="\r\n\r\n";
							 hexOutput+="Compile Size: "+getStdStringFromString(myultoabaseString(compileSize, 8, 10, ' '))+" B.\r\n";
							 hexOutput+="Optimization: "+getStdStringFromString(myultoabaseString(calc->opcodesSaved[i], 8, 10, ' '))+" B.";
							 if((compileSize+calc->opcodesSaved[i])>0)hexOutput+=" ("+getStdStringFromString(formatStringFloat(((double)calc->opcodesSaved[i]*100.0)/(compileSize+calc->opcodesSaved[i]), 1))+" %)";
							 hexOutput+="\r\n";

							 calc->expressionsListOutput.insert(calc->expressionsListOutput.end(), listOutput);
							 calc->expressionsHexOutput.insert(calc->expressionsHexOutput.end(), hexOutput);
							 /* Now Create The Code File... */
							 fileName="co"+HexToString((unsigned long)id & VM_ID_MASK, 1)+".bin";
							 WriteFileCreate(fileName, 0, (unsigned char*)codeImage, compileSize, &bytesWritten);
							 /* Now Create the List Output File... */
							 compileSize=getUnsignedCharArrayFromStringMax(codeImage, getStringFromStdString(&listOutput), MAX_LIST_OUTPUT_SIZE_BUFFER_SIZE);
							 fileName="lst"+HexToString((unsigned long)id & VM_ID_MASK, 1)+".txt";
							 WriteFileCreate(fileName, 0, (unsigned char*)codeImage, compileSize, &bytesWritten);
							 /* Now Create the Hex Output File... */
							 compileSize=getUnsignedCharArrayFromStringMax(codeImage, getStringFromStdString(&hexOutput), MAX_LIST_OUTPUT_SIZE_BUFFER_SIZE);
							 fileName="hex"+HexToString((unsigned long)id & VM_ID_MASK, 1)+".txt";
							 WriteFileCreate(fileName, 0, (unsigned char*)codeImage, compileSize, &bytesWritten);
							 /* Now Create The Name File... */
							 compileSize=getUnsignedCharArrayFromStringMax(codeImage, getStringFromStdString(&calc->scriptNames[i]), MAX_LIST_OUTPUT_SIZE_BUFFER_SIZE);
							 fileName="nm"+HexToString((unsigned long)id & VM_ID_MASK, 1)+".txt";
							 WriteFileCreate(fileName, 0, (unsigned char*)codeImage, compileSize, &bytesWritten);
							 vmResult=addVMToEnvironment(ven, id);
							 vmPtr++;
							 i++;
							 calc->scriptNumber++;
							 (*numDone)++;
							 }

						 if((result)&&(vmResult==VM_OK))
							 {

							 }
						 else
							 {
							 result=false;
							 driver->errorOutput="Error. Too Many Scripts, Delete Some first.\r\n";
							 }
						 }
					 else
						 {
						 /* An error occurred */
						 }
					 return result;
					 }

		private: System::Void Form1_FormClosed(System::Object^ sender, System::Windows::Forms::FormClosedEventArgs^ e)
					 {
					 //-------------------------------------------------------BEGIN CUT AND PASTE BLOCK-------------------------------------------------------------------------------------
					 //-------------------------------------------------------------------------------------------------------------------------------------------------------------------
					 int getResult;
					 std::string myString;
					 unsigned char textBuffer[MAXIMUM_TEXT_BUFFER_SIZE+1];
					 unsigned long textSize;
					 unsigned int done;

					 saveLocalSettings(&localSettings, LOCAL_SETTINGS_FILENAME);
					 localUDL.dataLogger.dirty|=DL_DIRTY;
					 saveSettings(&localUDL.dataLogger, myString, LOCAL_SAVE_SETTINGS_FILE);
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+getStringFromStdString(&myString));
					 textSize=(unsigned long)getUnsignedCharArrayFromStringMax((unsigned char*)textBuffer, this->textBoxInput1->Text, MAXIMUM_TEXT_BUFFER_SIZE);
					 WriteFileCreate(BASE_TEXT_FILENAME, 0, textBuffer, textSize, &done);
					 if(ConnectedUser())
						 {
						 logString(": PC Host Version: "+formatStringFloat((double)HOST_VERSION, 2)+" Disconnected...\r\n", PF_LOCAL_TIME_IF_SET, nullptr);
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Log Off...");
						 this->textBoxLog->Refresh();
						 (void)setFirstPor(1);
						 getResult=getDataLogger(&lastUDL.dataLogger);
						 if(getResult)
							 {
							 /* Commit the changes! */
							 lastUDL.dataLogger.ven.vmMode|=(VME_HOLD | VME_RESTART);
							 putDataLogger(&lastUDL.dataLogger);
							 flushLog();
							 flushSettings();
							 setCaptiveDevice(0);
							 }
						 }

					 if(Connection_Status)
						 {
						 //The following functiom releases a previously claimed interface
						 usb_release_interface(MyLibusbDeviceHandle, 0);
						 //closes a device opened
						 usb_close(MyLibusbDeviceHandle);
						 }
					 return;
					 //-------------------------------------------------------END CUT AND PASTE BLOCK-------------------------------------------------------------------------------------
					 //-------------------------------------------------------------------------------------------------------------------------------------------------------------------
					 }

		private: System::Void initDataTable(System::Data::DataTable^ intable, int numCols, int numRows)
					 {
					 int i;
					 System::Data::DataColumn^ col;
					 System::Data::DataRow^ row;
					 System::String^ cstring;

					 intable->Clear();
					 i=0;
					 while(i<=numCols)
						 {
						 cstring=HexToString((unsigned long)i, 1);
						 col=gcnew System::Data::DataColumn();
						 if(i!=0)col->DefaultValue=HexToString(DEFAULT_MEMORY_VALUE, 1);
						 else col->DefaultValue="";
						 intable->Columns->Add(col);
						 i++;
						 }
					 i=0;
					 while(i<=numRows)
						 {
						 row=intable->NewRow();
						 intable->Rows->Add(row);
						 i++;
						 }
					 }

		private: System::Void refreshDataTable(Windows::Forms::DataGridView^ grid, System::Data::DataTable^ intable, VIRTUAL_MACHINE* vm, unsigned int index, ADDRESS_TYPE offset, int numCols, int numRows)
					 {
					 int i;
					 int j;
					 unsigned char	 c;
					 VM_RETURN_TYPE	 res;
					 ADDRESS_TYPE	 offs;

					 /* Refresh Data Table */	
					 if(grid)
						 {

						 intable->Rows[0][0]="ID: 0x"+HexToString(vm->execID, 1);				 
						 i=0;
						 while(i<numRows)
							 {
							 offs=offset+(i*MEMORY_NUM_COLS);
							 intable->Rows[i+1][0]=HexToString(offs, 4);
							 i++;
							 }

						 i=0;
						 while(i<numCols)
							 {
							 intable->Rows[0][i+1]=HexToString(i, 1);				 
							 i++;
							 }

						 i=0;
						 while(i<numRows)
							 {
							 j=0;
							 grid->Rows[i+1]->HeaderCell->Value=HexToString((unsigned long)offset+i*MEMORY_NUM_COLS, 4);
							 while(j<numCols)
								 {
								 offs=offset+(i*MEMORY_NUM_COLS+j);
								 if(vm)res=readCacheByte(&vm->RAMImage, offs, &c);
								 else 
									 {
									 res=VM_OK;
									 c=0xFF;
									 }
								 if(res==VM_OK)
									 {

									 }
								 else
									 {
									 c=0xFF;
									 }

								 if(c==oldValues[index][i][j])
									 {
									 grid->Rows[i+1]->Cells[j+1]->Style->ForeColor=TABLE_NO_CHANGE_COLOUR;
									 }
								 else
									 {
									 grid->Rows[i+1]->Cells[j+1]->Style->ForeColor=TABLE_CHANGE_COLOUR;
									 oldValues[index][i][j]=c;
									 }		
								 intable->Rows[i+1][j+1]=HexToString(c, 1);
								 j++;	
								 }					
							 i++;
							 }
						 }
					 }

		private: System::Void Form1_Load(System::Object^ sender, System::EventArgs^ e)
					 {

					 int i, j, k;

					 std::string myString;
					 unsigned char textBuffer[MAXIMUM_TEXT_BUFFER_SIZE+1];
					 unsigned int done;
					 FRESULT fresult;
					 DataGridViewCellStyle^ cellStyle;

					 SerialPortConnected=false;
					 SerialPortConnectedOld=false;
					 DisconnectSerialPort();
					 initSerialUSBLocal();
					 initLocalSettings(&localSettings, LOCAL_SETTINGS_FILENAME);

					 this->labelLastTimeSynced->Text="-";
					 deviceSelected=0;			  
					 this->timer2->Stop();
					 runMode=IDLE_MODE;
					 bootLoaderStatus=0;
					 alarmEvent=CLEAR_ALARM_EVENT;
					 lastOpenedFile="";


					 /* Initialize the VM environment, also destroy all VMs (ie reset them) */

					 initVMEnvironment(&localUDL.dataLogger.ven);
					 restoreSettings(&localUDL.dataLogger, myString, LOCAL_SAVE_SETTINGS_FILE);
					 firstPor=1;
					 destroyAllVM(&localUDL.dataLogger.ven, &firstPor);

					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+getStringFromStdString(&myString));

					 this->textBoxInput1->Font = (gcnew System::Drawing::Font(L"Lucida Console", localSettings.fontSize, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, 
						 static_cast<System::Byte>(0)));

					 ReadFile(BASE_TEXT_FILENAME, 0, textBuffer, MAXIMUM_TEXT_BUFFER_SIZE, &done);

					 textBuffer[done]='\0';
					 this->textBoxInput1->Clear();
					 this->textBoxInput1->ScrollToCaret();
					 this->textBoxInput1->AppendText(getStringFromUnsignedCharArray(textBuffer, done+1));
					 this->textBoxInput1->Refresh();
					 updateScripts(this->treeViewPCScripts, &localUDL.dataLogger, "Host Scripts: ", 0);

					 this->treeViewPCFiles->Nodes->Clear();
					 updatePCFileRoot(this->treeViewPCFiles);
					 (void)readAllPCDirectoryEntries(".", &fresult, this->treeViewPCFiles->Nodes[0], &currentTreePCDir);

					 this->LocalMemoryTable=gcnew System::Data::DataTable();
					 cellStyle=gcnew DataGridViewCellStyle();
					 cellStyle->Font=(gcnew System::Drawing::Font(L"Lucida Console", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point,
						 static_cast<System::Byte>(0)));
					 cellStyle->BackColor=System::Drawing::Color::Black;
					 cellStyle->ForeColor=System::Drawing::Color::Lime;
					 this->dataGridView1->DefaultCellStyle=cellStyle;
					 this->dataGridView1->ColumnHeadersDefaultCellStyle=cellStyle;
					 this->dataGridView1->RowsDefaultCellStyle=cellStyle;
					 this->dataGridView1->RowHeadersDefaultCellStyle=cellStyle;
					 initDataTable(this->LocalMemoryTable, MEMORY_NUM_COLS, MEMORY_NUM_ROWS);
					 this->dataGridView1->DisplayedRowCount(true); 
					 this->labelMemory->Text="0x"+HexToString(0, 2);
					 for(i=0; i< (MAX_NUM_VM+1); i++)
						 {
						 memoryOffset[i]=0;
						 for(j=0; j<MEMORY_NUM_COLS; j++)
							 {
							 for(k=0; k<MEMORY_NUM_ROWS; k++)
								 {
								 oldValues[i][j][k]=DEFAULT_MEMORY_VALUE;	
								 }
							 } 
						 }
					 System::Type^ dType=this->dataGridView1->GetType();
					 System::Reflection::PropertyInfo^ nPro=dType->GetProperty("DoubleBuffered", System::Reflection::BindingFlags::NonPublic | System::Reflection::BindingFlags::Instance);
					 if(nPro!=nullptr)
						 {
						 nPro->SetValue(this->dataGridView1, true, nullptr);
						 }
					 this->dataGridView1->DataSource=this->LocalMemoryTable;
					 //refreshDataTable(this->dataGridView1, this->LocalMemoryTable, 0, 0, 0, MEMORY_NUM_COLS, MEMORY_NUM_ROWS); 
					 this->disConnectGUI(sender, e);
					 /* Fill in Help */
					 updateHelp(this->treeViewHelp);

					 this->toolStripTextBox1->MaxLength=(LOG_FILE_NAME_SIZE-1);
					 /* Get The Time The Application Was Launched! */ 
					 startTimer1();
					 }

		private: System::Void textBoxLog_TextChanged(System::Object^ sender, System::EventArgs^ e)
					 {

					 }


		private: bool compileInputTextScripts(System::String^ textInput, VIRTUAL_MACHINE* vmPtr, unsigned int numVM, CalcContext* calc, example::Driver* driver, unsigned int* numDone, VIRTUAL_MACHINE_ENVIRONMENT* ven)
					 {
					 unsigned char textBuffer[MAXIMUM_TEXT_BUFFER_SIZE+1];
					 unsigned long textSize;

					 textSize=(unsigned long)getUnsignedCharArrayFromStringMax((unsigned char*)textBuffer, textInput, MAXIMUM_TEXT_BUFFER_SIZE);
					 return compileScripts((char*)textBuffer, MAXIMUM_TEXT_BUFFER_SIZE, vmPtr, numVM, calc, driver, numDone, ven);
					 }

		private: System::Void textBoxInput_CompileOption(System::Object^ sender, System::EventArgs^ e, int sendToo)
					 {

					 CalcContext calc;
					 example::Driver driver(calc);
					 std::string mapOutput;
					 int  getResult;
					 bool result;
					 unsigned int numDone;
					 unsigned int i;
					 unsigned int offset[2];
					 unsigned int cL[2];
					 unsigned int cC[2];
					 unsigned char textBuffer[MAXIMUM_TEXT_BUFFER_SIZE+1];
					 unsigned long textSize;
					 VM_RETURN_TYPE totalResult;
					 System::String^ responseString;

					 this->timer2->Stop();
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Compiling, Please Wait...\r\n");
					 runMode=IDLE_MODE;
					 alarmEvent=CLEAR_ALARM_EVENT;
					 this->checkBoxShowMemory->Checked=false;
					 clearVMEnvironment(&localUDL.dataLogger.ven);
					 textSize=(unsigned long)getUnsignedCharArrayFromStringMax((unsigned char*)textBuffer, this->textBoxInput1->Text, MAXIMUM_TEXT_BUFFER_SIZE);
					 result=compileScripts((char*)textBuffer, MAXIMUM_TEXT_BUFFER_SIZE, &vm[0], MAX_NUM_VM, &calc, &driver, &numDone, &localUDL.dataLogger.ven);
					 if(result)
						 {
						 firstPor=1;
						 destroyAllVM(&localUDL.dataLogger.ven, &firstPor);
						 this->buttonCompileFile->BackColor=OK_COLOUR;
						 if(driver.warningCount>0)
							 {
							 if(this->checkBoxVerbose->Checked)
								 {
								 this->textBoxLog->ScrollToCaret();
								 this->textBoxLog->AppendText(getPCLocalTimeString()+"Number of Warnings: "+formatStringFloat((double)driver.warningCount, 0)+".\r\n");
								 this->textBoxLog->ScrollToCaret();
								 this->textBoxLog->AppendText(getPCLocalTimeString()+"Compile Output: \r\n\r\n"+getStringFromStdString(&driver.errorOutput)+"\r\n");
								 } 
								else
									{
									this->textBoxLog->ScrollToCaret();
									this->textBoxLog->AppendText(getPCLocalTimeString()+"Number of Warnings: "+formatStringFloat((double)driver.warningCount, 0)+". (Verbose Mode Off)\r\n\r\n");
								 }
							 }
						 else
							 {
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Compile Output: All Ok.\r\n");
							 }
						 i=0;
						 while(i<numDone)
							 {

							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getStringFromStdString(&calc.expressionsListOutput[i]));

							 // optional variables map output... 
							 if(this->checkBoxVerbose->Checked)
								 {
								 mapOutput=driver.calc.expressionsMapOutput[i];
								 this->textBoxLog->ScrollToCaret();
								 this->textBoxLog->AppendText("\r\n"+getStringFromStdString(&mapOutput)+"\r\n");
								 }
							 else
								 {
								 this->textBoxLog->ScrollToCaret();
								 this->textBoxLog->AppendText("\r\n");
								 }
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText("Machine Code Output:\r\n");

							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getStringFromStdString(&calc.expressionsHexOutput[i]));
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText("\r\n");


							 i++;
							 }
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText("\r\n");

						 updateScripts(this->treeViewPCScripts, &localUDL.dataLogger, "Host Scripts: ", 0);
						 if(sendToo)
							 {
							 getResult=getDataLogger(&localUDL.dataLogger);
							 if(getResult)
								 {
								 i=0;
								 totalResult=VM_OK;
								 while((totalResult==VM_OK)&&(i<numDone))
									 {
									 this->textBoxLog->ScrollToCaret();
									 this->textBoxLog->AppendText(getPCLocalTimeString()+"Send PC Script With ID: 0x"+HexToString((unsigned long)vm[i].execID & VM_ID_MASK, 1)+" To Device: ");
									 responseString=sendPCScript(&localUDL.dataLogger, vm[i].execID, &totalResult, 0, 0);
									 this->textBoxLog->ScrollToCaret();
									 this->textBoxLog->AppendText(responseString+".\r\n");
									 i++;
									 }
								 getResult=putDataLogger(&localUDL.dataLogger);
								 }
							 }
						 }
					 else
						 {
						 this->buttonCompileFile->BackColor=BAD_COLOUR;
						 if(driver.errorCount>0)
							 {
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Number of Errors: "+formatStringFloat((double)driver.errorCount, 0)+".\r\n");
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Compile Output: \r\n");
							 cL[0]=1;
							 cL[1]=1;
							 cC[0]=1;
							 cC[1]=1;
							 offset[0]=goToLineColumn(&cL[0], &cC[0], driver.compileOutput[0]->lineNumberStart, driver.compileOutput[0]->columnNumberStart, '\n', 0, textBuffer, textSize);
							 offset[1]=goToLineColumn(&cL[1], &cC[1], driver.compileOutput[0]->lineNumberEnd, driver.compileOutput[0]->columnNumberEnd, '\n', 0, textBuffer, textSize);
							 this->textBoxInput1->Select(offset[0], offset[1]-offset[0]);
							 this->textBoxInput1->Show();
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getStringFromStdString(&driver.errorOutput));
							 }
						 else
							 {
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Compile Output: "+getStringFromStdString(&driver.errorOutput));
							 }
						 }
					 }

		private: System::Void textBoxInput_Compile(System::Object^ sender, System::EventArgs^ e)
					 {
#if 0
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText("FLUSH: [");
					 this->textBoxLog->AppendText(getStringFromStdString(&flushSerialUSBLocal()));
					 this->textBoxLog->AppendText("]\r\n");
					 return;
#endif

					 textBoxInput_CompileOption(sender, e, 0);
					 }

				 unsigned char* fillPacket(unsigned char* outptr, unsigned int size, unsigned int* todoSize, unsigned char* inptr, unsigned int* done)
					 {
					 while((size>0)&&((*todoSize)>0))
						 {
						 *outptr++=*inptr++;
						 size--;
						 (*todoSize)--;
						 (*done)++;
						 }
					 return outptr;
					 }

				 int getFullCardInfo(CARD_INFO* cInfo)
					 {
					 /* Update Card Info, including root folder free size! */

					 USB_PACKET  OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					 USB_PACKET  InputPacketBuffer;  //Allocate a memory buffer for the data which we will read from the USB device

					 if(ConnectedUser())
						 {

						 OutputPacketBuffer.data[0]= CMD_UPDATE_CARD_INFO;
						 //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
						 if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							 {
							 return 0;
							 }
						 //Now get the response packet from the firmware.
						 //The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
						 if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT_LONG) != SIZE_USB_PACKET)
							 {
							 return 0;
							 }
						 return getCardInfo(cInfo);
						 }
					 return 0;	
					 }

				 int getCardInfo(CARD_INFO* cInfo)
					 {
					 /* returns 1 if ok 0 otherwise */
					 USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					 USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					 unsigned char* transferPtr;
					 unsigned int transferCounter;
					 short n;
					 unsigned int done;
					 int captiveDevice;
					 unsigned short count;
					 unsigned short tptr;

#if(USE_MUTEX_TRANSFERS)
					 semaphoreTransfers->WaitOne();
#endif
					 cInfo->cERROR=ERROR_NOT_SDMMC_CARD;
					 if(ConnectedUser())
						 {
						 captiveDevice=getCaptiveDevice();
						 if(captiveDevice>=1)
							 {

							 OutputPacketBuffer.data[0]=CMD_INIT_CARDINFO_TRANSFER;
							 //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
							 if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
								 {
#if(USE_MUTEX_TRANSFERS)
								 semaphoreTransfers->Release();
#endif
								 return 0;
								 }

							 if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
								 {
#if(USE_MUTEX_TRANSFERS)
								 semaphoreTransfers->Release();
#endif
								 return 0;
								 }

							 // Now we start reading the data...
							 transferPtr=(unsigned char*)cInfo;
							 transferCounter=(unsigned int)sizeof(CARD_INFO);
							 while(transferCounter>0)
								 {
								 OutputPacketBuffer.data[0]=CMD_CONTINUE_BULK_TRANSFER_READ;
								 OutputPacketBuffer.data[1]=(unsigned char)(SIZE_USB_PACKET-2);
								 // The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
								 if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
									 {
#if(USE_MUTEX_TRANSFERS)
									 semaphoreTransfers->Release();
#endif
									 return 0;
									 }
								 if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
									 {
#if(USE_MUTEX_TRANSFERS)
									 semaphoreTransfers->Release();
#endif
									 return 0;
									 }
								 n=(short)(unsigned char)InputPacketBuffer.data[0];
								 n+=(short)((unsigned char)InputPacketBuffer.data[1]<<8);
								 if(n>0)
									 {
									 done=0;
									 fillPacket((unsigned char*)transferPtr, n, (unsigned int*)&transferCounter, (unsigned char*)&InputPacketBuffer.data[2], (unsigned int*)&done);
									 transferPtr+=done;
									 }
								 // Now get the response packet from the firmware.
								 // The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
								 }
							 if(transferCounter<=0)
								 {
#if(USE_MUTEX_TRANSFERS)
								 semaphoreTransfers->Release();
#endif

								 if(getTransferStats(&count, &tptr))
									 {
									 if((count==0)&&(tptr==0))
										 {
										 return 1;
										 }
									 }
								 }
							 }
						 }
#if(USE_MUTEX_TRANSFERS)
					 semaphoreTransfers->Release();
#endif
					 return 0;
					 }

				 unsigned char consistencyCheck(DATA_LOGGER* dl)
					 {
					 return 1;
					 }

				 int rewindDeviceVME(void)
					 {
					 int result;
					 DATA_LOGGER tempUDL;

					 result=getDataLogger(&tempUDL);
					 if(result)
						 {
						 (void)rewindVMEnvironment(&tempUDL.ven);
						 result=putDataLogger(&tempUDL);
						 if(result)
							 {

							 }
						 }
					 return result;
					 }

				 int getDataLogger(DATA_LOGGER* dl)
					 {
					 /* returns 1 if ok 0 otherwise */
					 DATA_LOGGER		temporary;
					 USB_PACKET OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					 USB_PACKET InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					 unsigned char* transferPtr;
					 unsigned int transferCounter;
					 short n;
					 unsigned int done;
					 int captiveDevice;
					 unsigned short count;
					 unsigned short tptr;

#if(USE_MUTEX_TRANSFERS)
					 semaphoreTransfers->WaitOne();
#endif

					 if(ConnectedUser())
						 {
						 captiveDevice=getCaptiveDevice();
						 if(captiveDevice>=1)
							 {
							 this->timer1->Stop();

							 OutputPacketBuffer.data[0]=CMD_INIT_DATA_LOGGER_TRANSFER;
							 //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
							 if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
								 {
#if(USE_MUTEX_TRANSFERS)
								 semaphoreTransfers->Release();
#endif
								 this->timer1->Start();
								 return 0;
								 }

							 if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
								 {
#if(USE_MUTEX_TRANSFERS)
								 semaphoreTransfers->Release();
#endif
								 this->timer1->Start();
								 return 0;
								 }

							 // Now we start reading the data...
							 transferPtr=(unsigned char*)&temporary;
							 transferCounter=(unsigned int)sizeof(DATA_LOGGER);
							 while(transferCounter>0)
								 {
								 OutputPacketBuffer.data[0]=CMD_CONTINUE_BULK_TRANSFER_READ;
								 OutputPacketBuffer.data[1]=(unsigned char)(SIZE_USB_PACKET-2);
								 // The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
								 if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
									 {
#if(USE_MUTEX_TRANSFERS)
									 semaphoreTransfers->Release();
#endif
									 this->timer1->Start();
									 return 0;
									 }
								 if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
									 {
#if(USE_MUTEX_TRANSFERS)
									 semaphoreTransfers->Release();
#endif
									 this->timer1->Start();
									 return 0;
									 }
								 n=(short)(unsigned char)InputPacketBuffer.data[0];
								 n+=(short)((unsigned char)InputPacketBuffer.data[1]<<8);
								 if(n>0)
									 {
									 done=0;
									 fillPacket((unsigned char*)transferPtr, n, (unsigned int*)&transferCounter, (unsigned char*)&InputPacketBuffer.data[2], (unsigned int*)&done);
									 transferPtr+=done;
									 }
								 // Now get the response packet from the firmware.
								 // The following call to usb_bulk_read_app() retrieves SIZE_USB_PACKET bytes of data from the USB device.
								 }

							 if(transferCounter<=0)
								 {
#if(USE_MUTEX_TRANSFERS)
								 semaphoreTransfers->Release();
#endif
								 if(getTransferStats(&count, &tptr))
									 {
									 if((count==0)&&(tptr==0))
										 {
										 if(consistencyCheck(&temporary))
											 {
											 memcpy((void*)dl, (void*)&temporary, sizeof(DATA_LOGGER));
											 this->timer1->Start();
											 return 1;
											 }
									  else
										  {
										  this->timer1->Start();
										  return 0;
											 }
										 }
									 }
								 }
							 }
						 }
#if(USE_MUTEX_TRANSFERS)
					 semaphoreTransfers->Release();
#endif
					 this->timer1->Start();
					 return 0;
					 }

				 int putDataLogger(DATA_LOGGER* dl)
					 {

					 /* returns 1 if ok 0 otherwise */
					 USB_PACKET		OutputPacketBuffer; //Allocate a memory buffer which will contain data to send to the USB device
					 USB_PACKET		InputPacketBuffer; //Allocate a memory buffer for the data which we will read from the USB device
					 unsigned char*	transferPtr;
					 unsigned int	transferCounter;
					 unsigned int	done;
					 int				captiveDevice;
					 unsigned short count;
					 unsigned short tptr;

#if(USE_MUTEX_TRANSFERS)
					 semaphoreTransfers->WaitOne();
#endif

					 if(ConnectedUser())
						 {
						 captiveDevice=getCaptiveDevice();
						 if(captiveDevice>=1)
							 {
							 this->timer1->Stop();
							 OutputPacketBuffer.data[0]=CMD_INIT_DATA_LOGGER_TRANSFER;
							 //The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
							 if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
								 {
#if(USE_MUTEX_TRANSFERS)
								 semaphoreTransfers->Release();
#endif
								 this->timer1->Start();
								 return 0;
								 }

							 if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
								 {
#if(USE_MUTEX_TRANSFERS)
								 semaphoreTransfers->Release();
#endif
								 this->timer1->Start();
								 return 0;
								 }

							 // Now we start reading the data...
							 transferPtr=(unsigned char*)dl;
							 transferCounter=(unsigned int)sizeof(DATA_LOGGER);
							 dl->dirty|=DL_DIRTY;
							 while(transferCounter>0)
								 {
								 OutputPacketBuffer.data[0]=CMD_CONTINUE_BULK_TRANSFER_WRITE;
								 done=0;
								 fillPacket((unsigned char*)&OutputPacketBuffer.data[2], (unsigned int)(SIZE_USB_PACKET-2), (unsigned int*)&transferCounter, transferPtr, &done);
								 transferPtr+=done;
								 OutputPacketBuffer.data[1]=(unsigned char)(done & 0x00FF);
								 // The following call to usb_bulk_write_app() sends SIZE_USB_PACKET bytes of data to the USB device.
								 if(usb_bulk_write_app(MyLibusbDeviceHandle, 0x01, &OutputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
									 {
#if(USE_MUTEX_TRANSFERS)
									 semaphoreTransfers->Release();
#endif
									 this->timer1->Start();
									 return 0;
									 }
								 if(usb_bulk_read_app(MyLibusbDeviceHandle, 0x81, &InputPacketBuffer.data[0], SIZE_USB_PACKET, USB_TIMEOUT) != SIZE_USB_PACKET)
									 {
#if(USE_MUTEX_TRANSFERS)
									 semaphoreTransfers->Release();
#endif
									 this->timer1->Start();
									 return 0;
									 }
								 }
							 if(transferCounter<=0)
								 {
#if(USE_MUTEX_TRANSFERS)
								 semaphoreTransfers->Release();
#endif
								 if(getTransferStats(&count, &tptr))
									 {
									 if((count==0)&&(tptr==0))
										 {
										 this->timer1->Start();
										 return 1;
										 }
									 }
								 }
							 }
						 }
#if(USE_MUTEX_TRANSFERS)
					 semaphoreTransfers->Release();
#endif
					 this->timer1->Start();
					 return 0;
					 }

				 int isDeviceRunning(void)
					 {
					 if((Connection_Status)&&(getCaptiveDevice()==0))
						 {
						 return 1;
						 }
					 return 0;
					 }

				 int isLocalRunning(void)
					 {
					 if(isDeviceRunning())return 0;
					 else
						 if(timer2->Enabled)return 1;
					 return 0;
					 }

				 int stopDeviceRunning(void)
					 {
					 if(isDeviceRunning())
						 {
						 setRunMenu(2);
						 setCaptiveDevice(1);
						 }
					 return 1;
					 }

		private: System::Void setButtons(bool onoff)
					 {
					 this->buttonRunVM->Enabled=onoff;
					 this->buttonRunVM->Enabled=onoff;
					 this->buttonStep->Enabled=onoff;
					 this->buttonReset->Enabled=onoff;
					 this->buttonStop->Enabled=onoff;
					 this->DeviceMenu->Enabled=onoff;
					 this->FileCompileAndSend->Enabled=onoff;	 
					 }


		private: System::Void setBootButtons(bool onoff)
					 {
					 this->buttonReadMemory->Enabled=onoff;
					 this->buttonEraseMemory->Enabled=onoff;
					 this->buttonWriteMemory->Enabled=onoff;
					 this->buttonWriteBin->Enabled=onoff;
					 }					

		private: System::Void setRunMenu(int mode)
					 {
					 switch(mode)
						 {
						 case 0:
							 this->runToolStripMenuItem->Enabled=false;
							 this->runDevicetoolStripMenuItem->Enabled=true;
							 deviceSelected=1;
							 this->buttonRunVM->Text="Device Run";
							 break;

						 case 1:
							 this->runToolStripMenuItem->Enabled=true;
							 this->runDevicetoolStripMenuItem->Enabled=false;
							 deviceSelected=0;
							 this->buttonRunVM->Text="Run";
							 break;

						 case 2:
						 default:
							 this->runToolStripMenuItem->Enabled=true;
							 if(ConnectedUser())
								 {
								 this->runDevicetoolStripMenuItem->Enabled=true;
								 }
							 else 
								 {
								 this->runDevicetoolStripMenuItem->Enabled=false;
								 this->buttonRunVM->Text="Run";
								 deviceSelected=0;
								 }
							 break;
						 }
					 }

		private: unsigned long updateLastSync(int getnow)
					 {
					 int getResult;
					 TIME_T timePC;
					 unsigned long durationSeconds;

					 durationSeconds=0;
					 if(getnow)getResult=getDataLogger(&lastUDL.dataLogger);
					 if((!getnow)||(getResult))
						 {
						 getLocalTimePC(&timePC);
						 if(lastUDL.dataLogger.lastSyncTime.updated & TIME_UPDATED)
							 {
							 lastUDL.dataLogger.lastSyncTime.show=(SHOW_DAY | SHOW_MONTH | SHOW_YEAR | SHOW_HOURS | SHOW_MINUTES | SHOW_SECONDS | SHOW_WDAY);
							 this->labelLastTime->Text=getTimeString(&lastUDL.dataLogger.lastSyncTime);
							 durationSeconds=getDurationTotalSeconds(&timePC, &lastUDL.dataLogger.lastSyncTime);
							 if(durationSeconds<MAX_SYNC_PERIOD_SECS)
								 {
								 this->labelLastTime->ForeColor=OK_DARK_COLOUR;
								 }
							 else
								 {
								 this->labelLastTime->ForeColor=BAD_DARK_COLOUR;
								 }


							 }
						 else
							 {
							 this->labelLastTime->Text="-";
							 this->labelLastTime->ForeColor=OK_DARK_COLOUR;
							 durationSeconds=0;
							 }
						 }
					 else 
						 {
						 this->labelLastTime->Text="-";
						 this->labelLastTime->ForeColor=OK_DARK_COLOUR;
						 }
					 return durationSeconds;

					 }

		private: System::Void timer1_Tick(System::Object^ sender, System::EventArgs^ e)
					 {

					 int i;
					 static double	 f=0;
					 System::Decimal gd;
					 double			 g;
					 int			 scriptsDiffer;
					 int			 getResult;
					 VM_ARGUMENT	 varg;
					 unsigned long	 durationSeconds;
					 TIME_T			 timeDev;
					 TIME_T			 timePC;
					 std::string	 serialUSBString;
					 unsigned char   stat;

					 if(timerCounter1>0)
						 {
						 timerCounter1--;
						 i=checkConnectionStatus();
						 if(i)
							 {
							 if(Connection_Status)
								 {
								 connectGUI(sender, e);
								 if(Connection_Status)
									 {

									 }
								 else
									 {
									 disConnectGUI(sender, e);
									 }
								 }
							 else
								 {
								 if(SerialPortConnected)			  
									 {	
									 connectGUI(sender, e);
									 }
								 else
									 {
									 disConnectGUI(sender, e);
							 	 }
								 }
							 }
						 else
							 {


							 }

						 if(bootLoaderStatus==1)
							 {


							 }
						 else
							 {
							 if(!blockLongProcesses)
								 {
								 if(this->buttonRunVM->Enabled)
									 {

									 }
								 else
									 {
									 setButtons(true);
									 }
								 }
							 else
								 {
								 setButtons(false);	 
								 }

							 if(ConnectedUser())
								 {
								 if(!blockLongProcesses)
									 {

									 serialUSBString=getSerialUSBBuffer(&stat);
#if 0
									 if(serialUSBString!="")
									  {
									  this->textBoxSerialUSB->ScrollToCaret();
									  this->textBoxSerialUSB->AppendText("["+getStringFromStdString(&serialUSBString)+"]"+formatStringFloat((double)stat, 0)+".\r\n");
									  }	
#endif	
									 switch(serialUSBStatus)
									  {
										 default:
											 serialUSBStatus=0;
										 case 0:
											 if(stat!=SERIAL_PIPE_OVERFLOW)
												 {
												 if(serialUSBString!="")
													 {
													 this->textBoxSerialUSB->ScrollToCaret();
													 this->textBoxSerialUSB->AppendText(getStringFromStdString(&serialUSBString));
													 }
											  }
											 else
											  {

											  serialUSBStatus=1;
											  }
											 break;

										 case 1:
											 if(stat!=SERIAL_PIPE_OVERFLOW)
										  	{
											size_t sx=serialUSBString.find("\r\n", 0);
											this->textBoxSerialUSB->ScrollToCaret();
											this->textBoxSerialUSB->AppendText(getStringFromStdString(&serialUSBString));

											if(sx!=std::string::npos)
												{
												serialUSBString=serialUSBString.substr(sx, std::string::npos);
												if(serialUSBString!="")
													{
													this->textBoxSerialUSB->ScrollToCaret();
													this->textBoxSerialUSB->AppendText(getStringFromStdString(&serialUSBString));
													}
												serialUSBStatus=0;
												}
										  	}
											 break;
										 }
									 }
								 else
									 {

									 }
								 }

							 }
						 }
					 else
						 {
						 if(inHelpWindow)
							 {
							 TIME_T tempTime;
							 getTime(&tempTime);
							 switch((unsigned int)(tempTime.secs /3) % 3)
								 {
								 default:
									case 0:
										this->labelHelp->Text="Help (Right Click For Details)";
										break;

									case 1:
										this->labelHelp->Text="Help (Left Click To Select)";
										break;

									case 2:
										this->labelHelp->Text="Help (2 x Left Click To Insert Text)";
										break;
								 }
							 }

						 if(bootLoaderStatus==1)
							 {
							 if(SerBootDead())
								 {
								 /* Check if Alive, if not, disconnect... */
								 DisconnectSerialPort();								
								 }
							 }
						 else
							 {

							 if(guiStopped)
								 {
								 startStopGUI(true);
								 setRunMenu(2);
								 }

							 if(!blockLongProcesses)
								 {
								 Application::DoEvents();
								 switch(localSettings.timeShowMode)
									 {
									 case 0:
										 getLocalTimePC(&timePC);
										 this->labelLastTimeSynced->Text="Local Time:";
										 timePC.show=(SHOW_DAY | SHOW_MONTH | SHOW_YEAR | SHOW_HOURS | SHOW_MINUTES | SHOW_SECONDS | SHOW_WDAY);
										 this->labelLastTime->Text=getTimeString(&timePC);
										 this->labelLastTime->ForeColor=OK_DARK_COLOUR;			
										 break;

									 default:		
									 case 1:
										 this->labelLastTimeSynced->Text="Last Sync:";								
										 updateLastSync(0);
										 break;

									 case 2:
										 this->labelLastTimeSynced->Text="Time Diff:";								
										 break;

									 case 3:
										 this->labelLastTimeSynced->Text="Time Diff (%):";								
										 break;

									 case 4:
										 this->labelLastTimeSynced->Text="Last Diff:";
										 break;

									 case 5:
										 if(localSettings.timeScaling)getLocalTimePCScaled(localSettings.effectiveSpeed, localSettings.timeOffset, &timePC);
										 else getLocalTimePC(&timePC);
										 this->labelLastTimeSynced->Text="Scaled Time:";
										 timePC.show=(SHOW_DAY | SHOW_MONTH | SHOW_YEAR | SHOW_HOURS | SHOW_MINUTES | SHOW_SECONDS | SHOW_WDAY);
										 this->labelLastTime->Text=getTimeString(&timePC);
										 this->labelLastTime->ForeColor=OK_DARK_COLOUR;			
										 break;

									 case 6:
										 this->labelLastTimeSynced->Text="Alarm Time:";
										 if(alarmEvent & ALARM_SET_EVENT)
											 {
											 this->labelLastTime->ForeColor=BAD_DARK_COLOUR;
											 alarmTime.show=(SHOW_DAY | SHOW_MONTH | SHOW_YEAR | SHOW_HOURS | SHOW_MINUTES | SHOW_SECONDS | SHOW_WDAY);
											 this->labelLastTime->Text=getTimeString(&alarmTime);
											 }
										 else
											 {
											 this->labelLastTime->ForeColor=OK_DARK_COLOUR;
											 }
										 break;
									 }

								 }

							 /* slow events */
							 if(ConnectedUser())
								 {

								 if(!blockLongProcesses)
									 {
									 getResult=getDataLogger(&thisUDL.dataLogger);
									 if(getResult)
										 {
										 scriptsDiffer=compareCopyScripts((VIRTUAL_MACHINE_ENVIRONMENT*)&lastUDL.dataLogger.ven, (VIRTUAL_MACHINE_ENVIRONMENT*)&thisUDL.dataLogger.ven);
										 getResult=compareCopy((unsigned char*)&lastUDL.dataLogger, (unsigned char*)&thisUDL.dataLogger, sizeof(DATA_LOGGER));
										 if(getResult)
											 {
											 if(lastUDL.dataLogger.modes & TIME_AUTO_SYNC_MODE)
												 {
												 this->checkBoxAutoSync->Checked=true;
												 this->checkBoxAutoSync->CheckState=System::Windows::Forms::CheckState::Checked;
												 }
											 else
												 {
												 this->checkBoxAutoSync->Checked=false;
												 this->checkBoxAutoSync->CheckState=System::Windows::Forms::CheckState::Unchecked;
												 }
											 if(lastUDL.dataLogger.modes & BATTERY_PROTECTION_MODE)
												 {
												 this->checkBoxBatteryProtection->Checked=true;
												 this->checkBoxBatteryProtection->CheckState=System::Windows::Forms::CheckState::Checked;
												 }
											 else
												 {
												 this->checkBoxBatteryProtection->Checked=false;
												 this->checkBoxBatteryProtection->CheckState=System::Windows::Forms::CheckState::Unchecked;
												 }
											 if(lastUDL.dataLogger.modes & SYSTEM_LOGGING_MODE)
												 {
												 this->checkBoxSystemLogging->Checked=true;
												 this->checkBoxSystemLogUSB->Enabled=true;
												 this->checkBoxSystemLogging->CheckState=System::Windows::Forms::CheckState::Checked;
												 }
											 else
												 {
												 this->checkBoxSystemLogging->Checked=false;
												 this->checkBoxSystemLogUSB->Enabled=false;
												 this->checkBoxSystemLogging->CheckState=System::Windows::Forms::CheckState::Unchecked;
												 }

											 if(lastUDL.dataLogger.modes & SYSTEM_LOGGING_TO_SERIAL_USB)
												 {
												 this->checkBoxSystemLogUSB->Checked=true;
												 this->checkBoxSystemLogUSB->CheckState=System::Windows::Forms::CheckState::Checked;
												 }
											 else
												 {
												 this->checkBoxSystemLogUSB->Checked=false;
												 this->checkBoxSystemLogUSB->CheckState=System::Windows::Forms::CheckState::Unchecked;
												 }

											 try
												 {
												 gd=(System::Decimal)lastUDL.dataLogger.batteryProtectionVoltage;
												 if((gd>=this->numericUpDownBatteryProtect->Minimum)&&(gd<=this->numericUpDownBatteryProtect->Maximum))this->numericUpDownBatteryProtect->Value=gd;
												 }
											 catch(...)
												 {

												 }

											 switch(localSettings.timeShowMode)
												 {
												 case 0:
												 case 2:
												 case 3:
												 case 4:
												 case 5:
												 case 6:
													 break;

												 default:
												 case 1:
													 localSettings.lastSyncDuration=updateLastSync(0);
													 break;

												 }

											 if((forceUpdate)||(scriptsDiffer))
												 {
												 updateScripts(this->treeViewScripts, &lastUDL.dataLogger, "Device Scripts: ", 1);
												 forceUpdate=0;
												 }
											 }

										 }

									 getLocalTimePC(&timePC);
									 getTimeFromDevice(&timeDev);
									 timeDev.show=(SHOW_DAY | SHOW_MONTH | SHOW_YEAR | SHOW_HOURS | SHOW_MINUTES | SHOW_SECONDS | SHOW_WDAY);
									 this->labelTimeFromDeviceX->Text=getTimeString(&timeDev);
									 durationSeconds=getDurationTotalSeconds(&timePC, &timeDev);
									 if(durationSeconds<MAX_SYNC_PERIOD_SECS_DIFFERENT_TIME)
										 {
										 this->labelTimeFromDeviceX->ForeColor=OK_DARK_COLOUR;
										 }
									 else
										 {
										 this->labelTimeFromDeviceX->ForeColor=BAD_DARK_COLOUR;
										 }

									 switch(localSettings.timeShowMode)
										 {
										 default:
										 case 0:
										 case 1:
										 case 5:
										 case 6:
											 break;

										 case 2:
											 this->labelLastTime->Text=getDurationString((double)durationSeconds, 0);
											 this->labelLastTime->ForeColor=this->labelTimeFromDeviceX->ForeColor;
											 break;

										 case 3:
											 /* Calculate % */
											 localSettings.lastSyncDuration=updateLastSync(1);

											 if(localSettings.lastSyncDuration>0)
												 {
												 g=((double)durationSeconds*100.0/(double)localSettings.lastSyncDuration);
												 g=avgPut(&localSettings.relError, g, 1);
												 if(g<0)g=0; else if(g>100.0)g=100.0;
												 this->labelLastTime->Text=formatStringFloat((double)g, 2)+" %";
												 this->labelLastTime->ForeColor=this->labelTimeFromDeviceX->ForeColor;
												 }
											 else
												 {
												 avgInit(&localSettings.relError, AVGS);
												 this->labelLastTime->Text="-";
												 this->labelLastTime->BackColor=NORMAL_COLOUR;											
												 }
											 break;

										 case 4:
											 this->labelLastTime->Text=getDurationString((double)localSettings.lastSyncDifference, 0);
											 this->labelLastTime->ForeColor=this->labelTimeFromDeviceX->ForeColor;
											 break;


										 }
									 getResult=getCardInfo(&lastInfo);
									 if(getResult)
										 {
										 getResult=compareCopyCardInfo(&cardInfo, &lastInfo);
										 if(getResult)
											 {
											 updateMemoryCardRoot(this->treeViewFiles);											
											 }
										 }
									 }

								 if(timerCounter2>0)
									 {
									 timerCounter2--;
									 }
								 else
									 {
									 switch((unsigned int)localSettings.voltageShowMode)
										 {
										 default:
											 localSettings.voltageShowMode=0;
										 case 0:
											 /* Even Slower Events! */
											 f=(double)internalGlFunction(GL_FUNCTION_GET_ADC_REFERENCE, &varg);
											 this->labelVDD->Text=formatStringFloat((double)f, 2)+" V";
											 this->labelVDD->ForeColor=NEUTRAL_COLOUR;
											 this->labelVoltage->Text="VDD:";
											 this->labelVoltage->ForeColor=NEUTRAL_COLOUR;
											 break;

										 case 1:
											 f=(double)internalGlFunction(GL_FUNCTION_READ_ADCP, &varg);
											 this->labelVDD->Text=formatStringFloat((double)f, 2)+" V";
											 this->labelVDD->ForeColor=NEUTRAL_COLOUR;
											 this->labelVoltage->Text="Vin:";
											 this->labelVoltage->ForeColor=NEUTRAL_COLOUR;
											 break;

										 case 2:
											 f=(double)internalGlFunction(GL_FUNCTION_READ_ADCP, &varg);
											 if(f>=ADCP_THRESHOLD_USB_POWER)
												 {
												 this->labelVDD->Text="USB/External";
												 this->labelVDD->ForeColor=OK_DARK_COLOUR;
												 }
											 else
												 {
												 this->labelVDD->Text="Battery";
												 this->labelVDD->ForeColor=BAD_DARK_COLOUR;
												 }
											 this->labelVoltage->Text="Vsc:";
											 this->labelVoltage->ForeColor=NEUTRAL_COLOUR;
											 break;
										 }
									 timerCounter2=VERY_SLOW_UPDATE_PERIOD_MS/SLOW_UPDATE_PERIOD_MS;
									 }


								 }
							 else
								 {
								 getLocalTimePC(&timePC);
								 timePC.show=(SHOW_DAY | SHOW_MONTH | SHOW_YEAR | SHOW_HOURS | SHOW_MINUTES | SHOW_SECONDS | SHOW_WDAY);
								 this->labelTimeFromDeviceX->Text=getTimeString(&timePC);
								 this->labelTimeFromDeviceX->ForeColor=OK_DARK_COLOUR;
								 }

							 /* Update the Running GUI parts */

							 if(isDeviceRunning())
								 {
								 this->buttonRunVM->Text="Device Run";
								 this->textBoxSerialUSB->BackColor=System::Drawing::Color::Black;						
								 this->buttonRunVM->BackColor=OK_COLOUR;
								 this->textBoxSerialUSB->ForeColor=System::Drawing::Color::Lime;					 
								 }
							 else
								 {
								 if(this->timer2->Enabled)
									 {
									 this->buttonRunVM->Text="Run";
									 this->buttonRunVM->BackColor=OK_COLOUR;
									 this->textBoxSerialUSB->BackColor=System::Drawing::Color::Black;
									 this->textBoxSerialUSB->ForeColor=System::Drawing::Color::Lime;
									 }
								 else
									 {
									 this->buttonRunVM->BackColor=BAD_COLOUR;
									 this->textBoxSerialUSB->BackColor=GREYED_COLOUR;
									 this->textBoxSerialUSB->ForeColor=System::Drawing::Color::Yellow;
									 }   
								 }
							 this->buttonStep->BackColor=NORMAL_COLOUR;
							 }
						 timerCounter1=(SLOW_UPDATE_PERIOD_MS/timer1->Interval);
						 }
					 }



		private: System::Void buttonRunVM_Click(System::Object^ sender, System::EventArgs^ e)
					 {

					 if(getCaptiveDevice()>=1)
						 {
						 setCaptiveDevice(0);
						 }
					 else
						 {
						 setCaptiveDevice(1);
						 }
					 }


		private: System::Void buttonOpenFile_Click(System::Object^ sender, System::EventArgs^ e)
					 {

					 System::String^ fileString;
					 System::String^ fileName;
					 int result;

					 fileString=OpenFileToString(&result, &fileName);
					 if(result)
						 {
						 this->lastOpenedFile=fileName;
						 this->Text=this->titleBase+TITLE_MIDDLE_STRING+this->lastOpenedFile;
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Opening File \""+fileName+"\": Ok.\r\n");
						 this->textBoxInput1->Clear();
						 this->textBoxInput1->AppendText(fileString);
						 }
					 else
						 {
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Opening File \""+fileName+"\": Error.\r\n");
						 }
					 }

		private: System::Void buttonSaveAsFile_Click(System::Object^ sender, System::EventArgs^ e)
					 {		 
					 System::String^ fileName;
					 int result;

					 fileName=WriteFileFromStringWithDialog(&result, this->textBoxInput1->Text); 
					 if(result)
						 {
						 this->lastOpenedFile=fileName;
						 this->Text=this->titleBase+TITLE_MIDDLE_STRING+this->lastOpenedFile;
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Saving File \""+fileName+"\": Ok.\r\n");
						 }
					 else
						 {
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Saving File \""+fileName+"\": Error.\r\n");
						 }
					 }

		private: System::Void buttonSaveFile_Click(System::Object^ sender, System::EventArgs^ e)
					 {		 
					 System::String^ fileName;
					 int result;

					 if(lastOpenedFile!="")
						 {
						 fileName=lastOpenedFile;
						 }
					 else
						 {
						 fileName=BASE_TEXT_FILENAME;
						 }
					 result=WriteFileFromString(fileName, this->textBoxInput1->Text); 
					 if(result)
						 {
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Saving File \""+fileName+"\": Ok.\r\n");
						 }

					 }


		private: System::Void buttonAddToFile_Click(System::Object^ sender, System::EventArgs^ e)
					 {

					 System::String^ fileString;
					 System::String^ fileName;
					 int result;

					 fileString=OpenFileToString(&result, &fileName);
					 if(result)
						 {
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Opening File \""+fileName+"\": Ok.\r\n");
						 this->textBoxInput1->AppendText(fileString);
						 }
					 else
						 {
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Opening File \""+fileName+"\": Error.\r\n");
						 }
					 }

		private: System::Void OpenAndShowFile(System::String^ filePath)
					 {
					 /* Use the Default Program to Open it! */
						try
							{
							System::Diagnostics::Process::Start(filePath);
							}
						catch(...)
							{

							}
					 }

		private: System::Void GetAsMenuTree_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 /* Save a File From the Device onto the local PC */
					 FRESULT fresult;
					 unsigned long done;
					 System::String^ fileNameString;
					 System::String^ destFileNameString;
					 SaveFileDialog^ dialog;
					 System::String^ fileExtension;
					 std::string findString;

					 destFileNameString="";
					 fileNameString=currentTreeNode->Name;
					 findString=getStdStringFromString(getFileNameFromPath(fileNameString));
					 if(currentTreeDir.find(findString) != currentTreeDir.end())
						 {
						 done=currentTreeDir[findString];
						 }
					 else
						 {
						 done=0;
						 }
					 fileExtension=getFileNameExtension(fileNameString);
					 dialog=gcnew(SaveFileDialog);
					 dialog->Filter="Similar Files |*."+fileExtension+"|All files (*.*)|*.*";
					 dialog->FileName=getFileNameFromPath(fileNameString);
					 /* Open a show dialog box for the "Save As" for the hex file */
					 if (dialog->ShowDialog() == ::System::Windows::Forms::DialogResult::OK)
						 {
						 destFileNameString=dialog->FileName;
						 fresult=getFileFromDeviceToPC(destFileNameString, fileNameString, &done, this->progressBar1);
						 if(fresult==FR_OK)
							 {
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Get File: \""+fileNameString+"\" from Device To PC File \""+destFileNameString+"\": "+formatStringFileSize((double)done)+" Done!\r\n");
							 }
						 else
							 {
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Get File: \""+fileNameString+"\": from Device To PC File \""+destFileNameString+"\": Error!\r\n");
							 }
						 }
					 else
						 {
						 /* Action was cancelled by the user */
						 }
					 }

		private: System::Void internalGetMenuClickFunction(System::Object^ sender, System::EventArgs^ e, unsigned char show)
					 {

					 FRESULT fresult;
					 unsigned long done;
					 System::String^ fileNameString;
					 std::string findString;

					 fileNameString=currentTreeNode->Name;
					 findString=getStdStringFromString(getFileNameFromPath(fileNameString));
					 if(currentTreeDir.find(findString) != currentTreeDir.end())
						 {
						 done=currentTreeDir[findString];
						 }
					 else
						 {
						 done=0;
						 }
					 fresult=getFileFromDeviceToPC("", fileNameString, &done, this->progressBar1);
					 if(fresult==FR_OK)
						 {
						 if(show)OpenAndShowFile("."+fileNameString);
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Get File: \""+fileNameString+"\" from Device To PC File \""+"."+fileNameString+"\": "+formatStringFileSize((double)done)+" Done!\r\n");
						 }
					 else
						 {
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Get File: \""+fileNameString+"\": from Device To PC File \""+"."+fileNameString+"\": Error!\r\n");
						 }
					 }

		private: System::Void internalPCGetMenuClickFunction(System::Object^ sender, System::EventArgs^ e)
					 {
					 unsigned long done;
					 System::String^ fileNameString;
					 std::string findString;

					 fileNameString=this->currentTreePCNode->Name;
					 findString=getStdStringFromString(getFileNameFromPath(fileNameString));
					 if(currentTreePCDir.find(findString) != currentTreePCDir.end())
						 {
						 done=currentTreePCDir[findString];
						 }
					 else
						 {
						 done=0;
						 }
					 OpenAndShowFile(fileNameString);
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Show PC File: \""+fileNameString+"\": "+formatStringFileSize((double)done)+" Done!\r\n");		
					 }

		private: System::Void GetMenuTree_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 System::Windows::Forms::TreeNodeCollection^ collection;
					 System::Windows::Forms::TreeNode^ mTreeNode;
					 int j;

					 this->currentTreeNode->Checked=true;
					 mTreeNode=currentTopNode;
					 collection=currentTopNode->Nodes;
					 j=0;	   
					 while(j<collection->Count)
						 {
						 mTreeNode=collection[j++];
						 if(mTreeNode->Checked)
							 {			
							 this->currentTreeNode=mTreeNode;
							 internalGetMenuClickFunction(sender, e, 0);
							 }
						 }
					 }


		private: System::Void GetPCTextFileMenuTree_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 System::Windows::Forms::TreeNodeCollection^ collection;
					 System::Windows::Forms::TreeNode^ mTreeNode;
					 int j;

					 this->currentTreePCNode->Checked=true;
					 mTreeNode=currentTopNode;
					 collection=currentTopNode->Nodes;
					 j=0;	   
					 while(j<collection->Count)
						 {
						 mTreeNode=collection[j++];
						 if(mTreeNode->Checked)
							 {			
							 this->currentTreePCNode=mTreeNode;
							 internalPCGetMenuClickFunction(sender, e);
							 }
						 }
					 }

		private: System::Void LoadPCSource_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 unsigned int done;
					 System::String^ fileNameString;
					 std::string findString;
					 System::String^ extension;
					 unsigned char textBuffer[MAXIMUM_TEXT_BUFFER_SIZE+1];

					 fileNameString=currentTreePCNode->Name;
					 findString=getStdStringFromString(getFileNameFromPath(fileNameString));
					 if(currentTreePCDir.find(findString) != currentTreePCDir.end())
						 {
						 done=currentTreePCDir[findString];
						 } 
					 else
						 {
						 done=0;
						 }
					 extension=getFileNameExtension(fileNameString);
					 if(extension=="txt")
						 {
						 ReadFile(fileNameString, (unsigned int)0, (unsigned char*)&textBuffer[0], (unsigned int)MAXIMUM_TEXT_BUFFER_SIZE, (unsigned int*)&done);
						 this->textBoxInput1->Text+=getStringFromUnsignedCharArray(textBuffer, done);
						 }
					 }

		private: System::Void GetAndShowMenuTree_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 System::Windows::Forms::TreeNodeCollection^ collection;
					 System::Windows::Forms::TreeNode^ mTreeNode;
					 int j;

					 this->currentTreeNode->Checked=true;
					 mTreeNode=currentTopNode;
					 collection=currentTopNode->Nodes;
					 j=0;	   
					 while(j<collection->Count)
						 {
						 mTreeNode=collection[j++];
						 if(mTreeNode->Checked)
							 {			
							 this->currentTreeNode=mTreeNode;
							 internalGetMenuClickFunction(sender, e, 1);
							 }
						 }
					 }

		private: System::Void PutMenuTree_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 /* Put a file from the PC onto the device */
					 FRESULT fresult;
					 unsigned long done;
					 System::String^ fileNameString;
					 System::String^ PCFileNamePath;
					 System::Windows::Forms::TreeNodeCollection^ collection;
					 System::Windows::Forms::TreeNode^ mTreeNode;
					 int j;

					 this->currentTreeNode->Checked=true;
					 mTreeNode=currentTopNode;
					 collection=currentTopNode->Nodes;
					 j=0;	   
					 while(j<collection->Count)
						 {
						 mTreeNode=collection[j++];
						 if(mTreeNode->Checked)
							 {			
							 this->currentTreeNode=mTreeNode;
							 fileNameString=currentTreeNode->Name;
							 PCFileNamePath="."+fileNameString;
							 fresult=putFileFromPCToDevice(PCFileNamePath, fileNameString, &done, this->progressBar1);
							 if(fresult==FR_OK)
								 {
								 this->textBoxLog->ScrollToCaret();
								 this->textBoxLog->AppendText(getPCLocalTimeString()+"Put File: \""+PCFileNamePath+"\" from PC To Device \""+fileNameString+"\": "+formatStringFileSize((double)done)+" Done!\r\n");
								 }
							 else
								 {
								 this->textBoxLog->ScrollToCaret();
								 this->textBoxLog->AppendText(getPCLocalTimeString()+"Put File: \""+PCFileNamePath+"\" from PC To Device \""+fileNameString+"\": Error!\r\n");
								 }
							 }
						 }
					 }

		private: System::Void AddScript_Click(System::Object^ sender, System::EventArgs^ e)
					 {


					 }


		private: System::Void AddPCScript_Click(System::Object^ sender, System::EventArgs^ e)
					 {


					 }

		private: System::Void RemoveScript_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 System::Decimal id;
					 DATA_LOGGER tempUDL;
					 System::String^ responseString;
					 unsigned char cid;
					 VM_RETURN_TYPE result;
					 int getResult;

					 id=(System::Decimal)currentScriptNode->Tag;
					 cid=System::Decimal::ToByte(id);
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Remove Script With ID: 0x"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+": ");

					 responseString="Error";
					 getResult=getDataLogger(&tempUDL);
					 if(getResult)
						 {
						 result=deleteVMFromEnvironment(&tempUDL.ven, cid);
						 if(result==VM_OK)
							 {
							 getResult=putDataLogger(&tempUDL);
							 if(getResult)
								 {
								 responseString="Ok";
								 currentScriptNode->Remove();
								 }
							 }
						 }
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(responseString+".\r\n");
					 }

		private: System::Void RemoveAllScripts_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 DATA_LOGGER tempUDL;
					 System::String^ responseString;
					 VM_RETURN_TYPE result;
					 int getResult;

					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Remove All Scripts: ");
					 responseString="Error";
					 getResult=getDataLogger(&tempUDL);
					 if(getResult)
						 {
						 result=initVMEnvironment(&tempUDL.ven);
						 if(result==VM_OK)
							 {
							 getResult=putDataLogger(&tempUDL);
							 if(getResult)
								 {
								 responseString="Ok";
								 }
							 }
						 }
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(responseString+".\r\n");
					 }

		private: System::Void LoadSourceScript_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 System::Decimal id;
					 System::String^ responseString;
					 unsigned char cid;
					 FRESULT fresult;
					 unsigned int done;
					 System::String^ PCFileName;
					 System::String^ DeviceFileName;
					 unsigned char textBuffer[MAXIMUM_TEXT_BUFFER_SIZE+1];
					 int result;

					 id=(System::Decimal)currentScriptNode->Tag;
					 cid=System::Decimal::ToByte(id);
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Load Source Code of Script With ID: 0x"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+": ");
					 responseString="Error";
					 done=0;
					 DeviceFileName="src"+HexToString(cid & VM_ID_MASK, 1)+".txt";
					 PCFileName="l"+DeviceFileName;
					 fresult=getFileFromDeviceToPC(PCFileName, DeviceFileName, (unsigned long*)&done, this->progressBar1);
					 if(fresult==FR_OK)
						 {
						 done=0;
						 result=ReadFile(PCFileName, 0, (unsigned char*)textBuffer, MAXIMUM_TEXT_BUFFER_SIZE, &done);
						 if(result)
							 {
							 textBuffer[done]='\0';
							 this->textBoxInput1->Clear();
							 this->textBoxInput1->ScrollToCaret();
							 this->textBoxInput1->AppendText(getStringFromUnsignedCharArray(textBuffer, done+1));
							 this->textBoxInput1->Refresh();
							 responseString="Ok";
							 }
						 }
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(responseString+".\r\n");
					 }

		private: unsigned int getVM(VIRTUAL_MACHINE* vm, unsigned char cid)
					 {
					 FRESULT		 fresult;
					 unsigned int	 done;
					 System::String^ PCFileName;
					 System::String^ DeviceFileName;
					 int			 result;
					 DATA_LOGGER     tempUDL;
					 int			 getFile;
					 int			 getResult;

					 done=0;
					 getFile=1;
					 getResult=getDataLogger(&tempUDL);
					 if(getResult)
						 {
						 if((tempUDL.ven.cVM.execID & VM_ID_MASK)==(cid & VM_ID_MASK))
							 {
							 getFile=0;
							 memcpy(vm, &tempUDL.ven.cVM, sizeof(VIRTUAL_MACHINE));				
							 done=sizeof(VIRTUAL_MACHINE);
							 }
						 else
							 {

							 }
						 }

					 if((getFile)&&(Connection_Status))
						 {
						 DeviceFileName="vm"+HexToString(cid & VM_ID_MASK, 1)+".bin";
						 PCFileName="l"+DeviceFileName;
						 done=0;
						 fresult=getFileFromDeviceToPC(PCFileName, DeviceFileName, (unsigned long*)&done, this->progressBar1);
						 if(fresult==FR_OK)
							 {
							 result=ReadFile(PCFileName, 0, (unsigned char*)vm, sizeof(VIRTUAL_MACHINE), &done);
							 }
						 }

					 return done;
					 }

		private: System::String^ getLogFileNameFromDeviceVM(unsigned char cid)
					 {
					 unsigned int	 result;
					 VIRTUAL_MACHINE tempVM;
					 System::String^ resultString;
					 unsigned int    getFile;

					 resultString=""; 
					 getFile=0;
					 if(ConnectedUser())
						 {
						 result=getVM(&tempVM, cid);
						 if(result)
						  {
						  if(tempVM.fName[0]=='\0')
							  {

							  }
						  else
							  {
							  resultString=getStringFromUnsignedCharArrayAuto((unsigned char*)&tempVM.fName[0]); 							
							  }
							 }
					  }

					 if(resultString!="")
					  {

					  }
					 else
					  {
					  resultString="log"+HexToString(cid & VM_ID_MASK, 1)+".txt";
					  }
					 return resultString;
					 }

		private: System::Void ClearLogFileForScript_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 unsigned char   cid;
					 System::Decimal id;
					 System::String^ PCFileName;
					 System::String^ DeviceFileName;
					 System::String^ responseString;
					 ADDRESS_TYPE	 done;
					 FRESULT		 fresult;
					 id=(System::Decimal)currentScriptNode->Tag;
					 cid=System::Decimal::ToByte(id);
					 done=0;
					 DeviceFileName=getLogFileNameFromDeviceVM(cid);
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Clear the Log For Script with ID: 0x"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+". Filename: \""+DeviceFileName+"\": ");
					 PCFileName=DeviceFileName;
					 String^ message = "Are you sure you would like to Delete the Script's Log?";
					 String^ caption = "Warning: Deleting Log";
					 MessageBoxButtons buttons = MessageBoxButtons::YesNo;
					 System::Windows::Forms::DialogResult result;
					 responseString="Error";
					 result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING);
					 stopTimer1();
					 if (result==::DialogResult::Yes)
						 {
						 fresult=deleteFileFromDevice(DeviceFileName);
						 if(fresult==FR_OK)
					 	 {
						 restartVMEnvironment();
						 responseString="Ok";
					 	 }
						 }
					 else
						 {
						 responseString="Cancelled";
						 }
					 startTimer1();
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(responseString+".\r\n");
					 }

		private: System::Void LoadLogFileForScript_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 unsigned char   cid;
					 System::Decimal id;
					 System::String^ PCFileName;
					 System::String^ DeviceFileName;
					 System::String^ responseString;
					 ADDRESS_TYPE	 done;
					 FRESULT		 fresult;

					 id=(System::Decimal)currentScriptNode->Tag;
					 cid=System::Decimal::ToByte(id);
					 responseString="Error";
					 done=0;
					 DeviceFileName=getLogFileNameFromDeviceVM(cid);
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Get And Show Log For Script with ID: 0x"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+". Filename: \""+DeviceFileName+"\": ");
					 PCFileName=DeviceFileName;

					 fresult=getFileFromDeviceToPC(PCFileName, DeviceFileName, (unsigned long*)&done, this->progressBar1);

					 if(fresult==FR_OK)
						 {
						 OpenAndShowFile(PCFileName);
						 responseString="Ok";
						 }
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(responseString+".\r\n");
					 }

		private: System::String^ getLogFileNameVMPCScript(VM_RETURN_TYPE* res, unsigned char cid)
					 {

					 VIRTUAL_MACHINE lvm;
					 System::String^ resultString;

					 resultString="";
					 (*res)=saveVM(&localUDL.dataLogger.ven.cVM);
					 if((*res)==VM_OK)
						 {
						 lvm.execID=(cid & 0x3F);
						 (*res)=restoreVM(&lvm);
						 if((*res)==VM_OK)
							 {
							 if(lvm.fName[0]=='\0')
								 {

								 }
							 else
								 {
								 resultString=getStringFromUnsignedCharArrayAuto((unsigned char*)&lvm.fName[0]); 							
								 }

							 if(resultString!="")
								 {

								 }
							 else
								 {
								 resultString="log"+HexToString(cid & VM_ID_MASK, 1)+".txt";
								 }
							 }
						 }
					 return resultString;
					 }

		private: System::Void ClearLogFileForPCScript_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 unsigned char   cid;
					 System::Decimal id;
					 System::String^ responseString;
					 VM_RETURN_TYPE  result;
					 System::String^ resultString;
					 VIRTUAL_MACHINE lvm;
					 std::string     resString;

					 stopToolStripMenuItem_Click(sender, e);

					 id=(System::Decimal)currentScriptNode->Tag;
					 cid=System::Decimal::ToByte(id);
					 responseString="Error";
					 resultString="";

					 resultString=getLogFileNameVMPCScript(&result, cid);
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Clear the Log For PC Script with ID: 0x"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+". Filename: \""+resultString+"\": ");
					 if(result==VM_OK)
						 {

						 String^ message = "Are you sure you would like to Delete the Script's Log? (File: \""+resultString+"\")";
						 String^ caption = "Warning: Deleting Log";
						 MessageBoxButtons buttons = MessageBoxButtons::YesNo;
						 System::Windows::Forms::DialogResult bresult;
						 responseString="Error";
						 bresult = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING);
						 stopTimer1();
						 if (bresult==::DialogResult::Yes)
							 {
							 responseString="Ok";
							 try
								 {
								 File::Delete(resultString);
								 }
							 catch(...)
								 {
								 responseString="Error";
								 }

							 if(responseString=="Ok")
								 {
								 responseString="Error";
								 lvm.execID=(cid & 0x3F);
								 result=restoreVM(&lvm);
								 if(result==VM_OK)
									 {
									 result=resetVM(&lvm, lvm.execID);
									 if(result==VM_OK)
										 {
										 showCache((CACHE_OBJECT*)&lvm.FILEImage, (std::string&)resString);
										 this->textBoxLog->AppendText(getStringFromStdString(&resString));

										 result=saveVM(&lvm);
										 if(result==VM_OK)
											 {
											 responseString="Ok";
											 }
										 }

									 }

								 }
							 }
						 else
							 {

							 responseString="Cancelled";
							 }
						 startTimer1();
						 }
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(responseString+".\r\n");

					 }

		private: System::Void LoadLogFileForPCScript_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 unsigned char   cid;
					 System::Decimal id;
					 System::String^ responseString;
					 VM_RETURN_TYPE  result;
					 System::String^ resultString;

					 stopToolStripMenuItem_Click(sender, e);
					 id=(System::Decimal)currentScriptNode->Tag;
					 cid=System::Decimal::ToByte(id);
					 responseString="Error";
					 resultString="";
					 this->textBoxLog->ScrollToCaret();
					 resultString=getLogFileNameVMPCScript(&result, cid);
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Get And Show Log For PC Script with ID: 0x"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+". Filename: \""+resultString+"\": ");
					 if(result==VM_OK)
						 {
						 responseString="Ok";
						 try
							 {
							 OpenAndShowFile(resultString);
							 }
						 catch(...)
							 {
							 responseString="Error";
							 }
						 }
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(responseString+".\r\n");
					 }

		private: System::Void SelectPCScript_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 unsigned char   cid;
					 unsigned short  cs;
					 System::Decimal id;

					 id=(System::Decimal)currentScriptNode->Tag;
					 cid=System::Decimal::ToByte(id);
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Selected Script With ID: 0x"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+": ");
					 cs=findVMInEnvironment(&localUDL.dataLogger.ven, cid);
					 if(cs<MAX_NUM_VM)
						 {
						 localUDL.dataLogger.ven.vmSelected=(unsigned char)cs;
						 if(this->dataGridView1->Visible)
							 {
							 refreshDataTable(this->dataGridView1, this->LocalMemoryTable, &localUDL.dataLogger.ven.cVM, localUDL.dataLogger.ven.vmSelected, memoryOffset[localUDL.dataLogger.ven.vmSelected], MEMORY_NUM_COLS, MEMORY_NUM_ROWS); 
							 this->numericUpDownMemoryOffset->Value=(System::Decimal)(unsigned int)memoryOffset[localUDL.dataLogger.ven.vmSelected];
							 }
						 else
							 {

							 }
						 updateScripts(this->treeViewPCScripts, &localUDL.dataLogger, "Host Scripts: ", 0);
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText("Ok.\r\n");				 
						 }
					 else
						 {
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText("Error.\r\n");				 
						 }
					 }

		private: System::Void RemovePCScript_Click(System::Object^ sender, System::EventArgs^ e)
					 {

					 System::Decimal id;
					 System::String^ responseString;
					 unsigned char cid;
					 VM_RETURN_TYPE result;

					 id=(System::Decimal)currentScriptNode->Tag;
					 cid=System::Decimal::ToByte(id);
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Remove Script With ID: 0x"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+": ");
					 result=deleteVMFromEnvironment(&localUDL.dataLogger.ven, cid);
					 if(result==VM_OK)
						 {
						 responseString="Ok";
						 currentScriptNode->Remove();
						 updateScripts(this->treeViewPCScripts, &localUDL.dataLogger, "Host Scripts: ", 0);
						 }
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(responseString+".\r\n");
					 }

		private: System::Void RemoveAllPCScripts_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 System::String^ responseString;
					 VM_RETURN_TYPE result;

					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Removing All PC Scripts: ");
					 result=initVMEnvironment(&localUDL.dataLogger.ven);
					 if(result==VM_OK)
						 {
						 responseString="Ok";
						 updateScripts(this->treeViewPCScripts, &localUDL.dataLogger, "Host Scripts: ", 0);
						 }
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(responseString+".\r\n");
					 }

		private: System::String^ sendPCScript(DATA_LOGGER* dl, unsigned char cid, VM_RETURN_TYPE *totalresult, unsigned char read, unsigned char write)
					 {
					 System::String^ fileName;
					 VIRTUAL_MACHINE vm;
					 FRESULT fresult;
					 int getResult;
					 int result;
					 unsigned long done;
					 System::String^ responseString;

					 *totalresult=VM_ERROR;
					 responseString="Error";
					 if(read)getResult=getDataLogger(dl);
					 else getResult=1;

					 if(getResult)
						 {
						 responseString="Error. Too Many Scripts";
						 result=addVMToEnvironment(&dl->ven, cid & VM_ID_MASK);
						 if(result<MAX_NUM_VM)
							 {
							 /* Now Create The Code File... */
							 responseString="Error. File Write To Device Error";
							 fileName="co"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+".bin";
							 fresult=putFileFromPCToDevice(fileName, fileName, &done, this->progressBar1);
							 if(fresult==FR_OK)
								 {
								 fileName="src"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+".txt";
								 fresult=putFileFromPCToDevice(fileName, fileName, &done, this->progressBar1);
								 if(fresult==FR_OK)
									 {
									 fileName="nm"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+".txt";
									 fresult=putFileFromPCToDevice(fileName, fileName, &done, this->progressBar1);
									 if(fresult==FR_OK)
										 {
										 destroyVM(&vm, cid & VM_ID_MASK, 1);
										 fileName="vm"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+".bin";
										 fresult=putFileFromPCToDevice(fileName, fileName, &done, this->progressBar1);
										 if(fresult==FR_OK)
											 {
											 if(write)
												 {
												 responseString="Device Write Error";
												 getResult=putDataLogger(dl);
												 if(getResult)
													 {
													 responseString="Ok";
													 *totalresult=VM_OK;
													 }
												 }
											 else
												 {
												 responseString="Ok";
												 *totalresult=VM_OK;
												 }
											 }
										 }
									 }
								 }
							 }
						 }
					 return responseString;
					 }

		private: System::Void SendPCScriptToDevice_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 System::Decimal id;
					 System::String^ responseString;
					 unsigned char cid;
					 VM_RETURN_TYPE result;

					 id=(System::Decimal)currentScriptNode->Tag;
					 cid=System::Decimal::ToByte(id);
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Send PC Script With ID: 0x"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+" To Device: ");
					 responseString="Error";
					 if(ConnectedUser())
						 {
						 responseString=sendPCScript(&thisUDL.dataLogger, cid, &result, 1, 1);
						 }
					 else
						 {

						 }
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(responseString+".\r\n");
					 }

		private: System::Void SendAllPCScriptsToDevice_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 System::String^ responseString;
					 unsigned char cid;
					 VM_RETURN_TYPE result;
					 int getResult;
					 int i;
					 DATA_LOGGER tempUDL;

					 responseString="Ok";
					 if(localUDL.dataLogger.ven.vmNum>0)
						 {
						 responseString="Error";
						 getResult=getDataLogger(&tempUDL);
						 if(getResult)
							 {
							 result=VM_OK;
							 i=0;
							 while((result==VM_OK) && (i<localUDL.dataLogger.ven.vmNum))
								 {
								 cid=localUDL.dataLogger.ven.vmID[i];
								 responseString=sendPCScript(&tempUDL, cid, &result, 0, 0);
								 this->textBoxLog->ScrollToCaret();
								 this->textBoxLog->AppendText(getPCLocalTimeString()+"Send PC Script With ID: 0x"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+" To Device: ");
								 this->textBoxLog->ScrollToCaret();
								 this->textBoxLog->AppendText(responseString+".\r\n");
								 i++;
								 }
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Sending All PC Scripts To Device: ");
							 if(result==VM_OK)
								 {
								 getResult=putDataLogger(&tempUDL);
								 if(getResult)
									 {
									 responseString="All Ok";
									 }
								 }
							 else
								 {
								 responseString="Errors";
								 }
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(responseString);
							 }
						 else
							 {
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Sending All PC Scripts To Device: Error.\r\n");
							 }
						 }
					 }

		private: System::Void LoadSourcePCScript_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 System::Decimal id;
					 System::String^ responseString;
					 unsigned char cid;
					 unsigned int done;
					 System::String^ PCFileName;
					 unsigned char textBuffer[MAXIMUM_TEXT_BUFFER_SIZE+1];
					 int result;

					 id=(System::Decimal)currentScriptNode->Tag;
					 cid=System::Decimal::ToByte(id);
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Load Source Code of Script With ID: 0x"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+": ");
					 responseString="Error";
					 done=0;
					 PCFileName="src"+HexToString(cid & VM_ID_MASK, 1)+".txt";
					 done=0;
					 result=ReadFile(PCFileName, 0, (unsigned char*)textBuffer, MAXIMUM_TEXT_BUFFER_SIZE, &done);
					 if(result)
						 {
						 textBuffer[done]='\0';
						 this->textBoxInput1->Clear();
						 this->textBoxInput1->ScrollToCaret();
						 this->textBoxInput1->AppendText(getStringFromUnsignedCharArray(textBuffer, done+1));
						 this->textBoxInput1->Refresh();
						 responseString="Ok";
						 }
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(responseString+".\r\n");
					 }

		private: System::Void TogglePauseScript_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 System::Decimal id;
					 DATA_LOGGER tempUDL;
					 System::String^ responseString;
					 unsigned char cid;
					 int getResult;
					 unsigned short findresult;

					 id=(System::Decimal)currentScriptNode->Tag;
					 cid=System::Decimal::ToByte(id);
					 this->textBoxLog->ScrollToCaret();
					 if(cid & VM_ID_HOLD)
						 {
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Restart Script With ID: 0x"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+": ");
						 }
					 else
						 {
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Pause Script With ID: 0x"+HexToString((unsigned long)cid & VM_ID_MASK, 1)+": ");
						 }
					 responseString="Error";
					 getResult=getDataLogger(&tempUDL);
					 if(getResult)
						 {
						 findresult=findVMInEnvironment(&tempUDL.ven, cid);
						 if(findresult<MAX_NUM_VM)
							 {
							 tempUDL.ven.vmID[findresult]^=VM_ID_HOLD;
							 getResult=putDataLogger(&tempUDL);
							 if(getResult)
								 {
								 responseString="Ok";
								 }
							 }
						 }
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(responseString+".\r\n");
					 }

		private: System::Void PutAsMenuTree_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 /* Put a file from the PC onto the Device */
					 FRESULT fresult;
					 unsigned long done;
					 System::String^ fileNameString;
					 System::String^ PCFileNamePath;
					 OpenFileDialog^ dialog;
					 System::String^ fileExtension;

					 PCFileNamePath="";
					 fileNameString=currentTreeNodePath;
					 fileExtension=getFileNameExtension(fileNameString);
					 dialog=gcnew(OpenFileDialog);
					 dialog->Filter="Similar Files |*."+fileExtension+"|All files (*.*)|*.*";
					 dialog->FileName=getFileNameFromPath(fileNameString);
					 /* Open a show dialog box for the "Put As" for the hex file */
					 if (dialog->ShowDialog() == ::System::Windows::Forms::DialogResult::OK)
						 {
						 PCFileNamePath=dialog->FileName;
						 fileNameString=currentTreeNodePath+getFileNameFromPath(PCFileNamePath);
						 fresult=putFileFromPCToDevice(PCFileNamePath, fileNameString, &done, this->progressBar1);
						 if(fresult==FR_OK)
							 {
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Put File: \""+PCFileNamePath+"\" from PC To Device \""+fileNameString+"\": "+formatStringFileSize((double)done)+" Done!\r\n");
							 }
						 else
							 {
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Put File: \""+PCFileNamePath+"\" from PC To Device \""+fileNameString+"\": Error!\r\n");
							 }
						 }
					 else
						 {
						 /* Action was cancelled by the user */
						 }
					 }

		private: System::Void DeleteMenuTree_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 /* Delete a file from the PC from the device */
					 FRESULT fresult;
					 System::String^ fileNameString;
					 System::Windows::Forms::TreeNodeCollection^ collection;
					 System::Windows::Forms::TreeNode^ mTreeNode;
					 int j;
					 int total;
					 System::Windows::Forms::DialogResult result;

					 this->currentTreeNode->Checked=true;
					 mTreeNode=currentTopNode;
					 collection=currentTopNode->Nodes;

					 result=::DialogResult::Yes;
					 if(!localSettings.checkDeletes)
						 {
						 j=0;	  
						 total=0; 
						 while(j<collection->Count)
							 {
							 mTreeNode=collection[j++];
							 if(mTreeNode->Checked)
								 {	
								 total++;
								 } 		
							 }

						 if(total>1)
							 {
							 String^ message = "Are you Sure you would like to Delete all the "+formatStringFloat((double)total, 0)+" Selected files ?\r\n";
							 String^ caption = "Warning: Deleting Multiple Files From Device";
							 MessageBoxButtons buttons = MessageBoxButtons::YesNo;
							 stopTimer1();
							 result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING );
							 startTimer1();
							 }
						 }

					 if(result==::DialogResult::Yes)
						 {

						 j=0;	   
						 while(j<collection->Count)
							 {
							 mTreeNode=collection[j++];
							 if(mTreeNode->Checked)
								 {			
								 mTreeNode->Checked=false;
								 currentTreeNodePath=mTreeNode->Name;	 
								 fileNameString=currentTreeNodePath;

								 if(localSettings.checkDeletes)
									 {
									 String^ message = "Are you Sure you would like to Delete \""+fileNameString+"\" From Device ?\r\n";
									 String^ caption = "Warning: Deleting File From Device";
									 MessageBoxButtons buttons = MessageBoxButtons::YesNoCancel;
									 result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING );
									 }
								 else
									 {
									 result=::DialogResult::Yes;	 

									 }

								 if (result==::DialogResult::Yes)
									 {	 
									 fresult=deleteFileFromDevice(fileNameString);
									 if(fresult==FR_OK)
										 {
										 this->textBoxLog->ScrollToCaret();
										 this->textBoxLog->AppendText(getPCLocalTimeString()+"Deleting : \""+fileNameString+"\" from Device: Done!\r\n");
										 mTreeNode->Remove();
										 collection=currentTopNode->Nodes;
										 j=0;
										 }
									 else
										 {
										 this->textBoxLog->ScrollToCaret();
										 this->textBoxLog->AppendText(getPCLocalTimeString()+"Deleting : \""+fileNameString+"\" from Device: Error. Note: A Directory Must be Empty First...\r\n");
										 }
									 }
								 else
									 if(result==::DialogResult::No)
										 {
										 this->textBoxLog->ScrollToCaret();
										 this->textBoxLog->AppendText(getPCLocalTimeString()+"Deleting : \""+fileNameString+"\" from Device: Skipped.\r\n");
										 }
									 else
										 {
										 this->textBoxLog->ScrollToCaret();
										 this->textBoxLog->AppendText(getPCLocalTimeString()+"Cancelled.\r\n");
										 break;
										 }
								 }
							 }
						 }
					 }

		private: System::Void UnselectAll_Click(System::Object^ sender, System::EventArgs^ e)
					 {

					 System::Windows::Forms::TreeNode^ mTreeNode;
					 System::Windows::Forms::TreeNodeCollection^ collection;
					 int j;

					 mTreeNode=currentTopNode;
					 collection=currentTopNode->Nodes;
					 j=0;	   
					 while(j<collection->Count)
						 {
						 mTreeNode=collection[j++];
						 if(mTreeNode->Checked)
							 {
							 mTreeNode->Checked=false;
							 }
						 }

					 }

		private: System::Void DeletePCFileMenuTree_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 /* Delete a file from the PC */
					 System::String^ fileNameString;
					 System::Windows::Forms::TreeNode^ mTreeNode;
					 System::Windows::Forms::TreeNodeCollection^ collection;
					 System::Windows::Forms::DialogResult result;
					 int total;
					 int j;

					 this->currentTreePCNode->Checked=true;

					 mTreeNode=currentTopNode;
					 collection=currentTopNode->Nodes;

					 result=::DialogResult::Yes;
					 if(!localSettings.checkDeletes)
						 {
						 j=0;	  
						 total=0; 
						 while(j<collection->Count)
							 {
							 mTreeNode=collection[j++];
							 if(mTreeNode->Checked)
								 {	
								 total++;
								 } 		
							 }

						 if(total>1)
							 {
							 String^ message = "Are you Sure you would like to Delete all the "+formatStringFloat((double)total, 0)+" Selected files ?\r\n";
							 String^ caption = "Warning: Deleting Multiple Files From Host";
							 MessageBoxButtons buttons = MessageBoxButtons::YesNo;
							 stopTimer1();
							 result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING );
							 startTimer1();
							 }
						 }

					 if(result==::DialogResult::Yes)
						 {

						 j=0;	   
						 while(j<collection->Count)
							 {
							 mTreeNode=collection[j++];
							 if(mTreeNode->Checked)
								 {
								 mTreeNode->Checked=false;
								 this->currentTreePCNodePath=mTreeNode->Name;
								 fileNameString=this->currentTreePCNodePath;

								 if(File::Exists(fileNameString))
									 {

									 if(localSettings.checkDeletes)
										 {
										 String^ message = "Are you Sure you would like to Delete \""+fileNameString+"\" ?\r\n";
										 String^ caption = "Warning: Deleting File";
										 MessageBoxButtons buttons = MessageBoxButtons::YesNoCancel;
										 result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING );
										 }
									 else
										 {
										 result=::DialogResult::Yes;
										 }
									 this->textBoxLog->ScrollToCaret();
									 this->textBoxLog->AppendText(getPCLocalTimeString()+"Deleting \""+fileNameString+"\" from PC: ");
									 if (result==::DialogResult::Yes)
										 {
										 try
											 {
											 File::Delete(fileNameString);
											 }
										 catch(...)
											 {

											 }
										 this->textBoxLog->ScrollToCaret();
										 this->textBoxLog->AppendText("Ok.\r\n");
										 mTreeNode->Remove();
										 collection=currentTopNode->Nodes;
										 j=0;
										 }
									 else
										 if(result==::DialogResult::No)
											 {
											 this->textBoxLog->ScrollToCaret();
											 this->textBoxLog->AppendText("Skipped.\r\n");
											 }
										 else
											 {
											 this->textBoxLog->ScrollToCaret();
											 this->textBoxLog->AppendText("Cancelled.\r\n");
											 break;
											 }

									 }
								 else
									 if(Directory::Exists(fileNameString))
										 {
										 if(localSettings.checkDeletes)
											 {
											 String^ message = "Are you Sure you would like to Delete \""+fileNameString+"\" and all its contents?\r\n";
											 String^ caption = "Warning: Deleting Directory";
											 MessageBoxButtons buttons = MessageBoxButtons::YesNoCancel;
											 result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING );
											 }
										 else
											 {
											 result=::DialogResult::Yes;
											 }
										 if (result==::DialogResult::Yes)
											 {
											 try
												 { 
												 Directory::Delete(fileNameString, true);
												 }
											 catch(...)
												 {

												 }
											 this->textBoxLog->ScrollToCaret();
											 this->textBoxLog->AppendText(getPCLocalTimeString()+"Deleting Directory \""+fileNameString+"\" from PC: Done!\r\n");
											 mTreeNode->Remove();
											 collection=currentTopNode->Nodes;
											 j=0;
											 }
										 else
											 if(result==::DialogResult::No)
												 {
												 this->textBoxLog->ScrollToCaret();
												 this->textBoxLog->AppendText(getPCLocalTimeString()+"Deleting Directory \""+fileNameString+"\" from PC: Skipped.\r\n");
												 }
											 else
												 {
												 this->textBoxLog->ScrollToCaret();
												 this->textBoxLog->AppendText(getPCLocalTimeString()+"Cancelled.\r\n");
												 break;
												 }

										 }
								 }
							 else
								 {

								 }
							 }
						 }

					 }

		private: int AfterLabelEdit(System::Object^ sender, System::Windows::Forms::NodeLabelEditEventArgs^ e)
					 {
					 int result;

					 result=0;
					 if ((e->Label!= nullptr )&&(e->Node!=nullptr))
						 {
						 if ((e->Label->Length > 0 )&&(e->Label->Length<13))
							 {
							 array<Char>^ temp0 = {'@','.',',','!', '\\'};
							 if ( e->Label->IndexOfAny( temp0 ) == -1 )
								 {

								 // Stop editing without canceling the label change.
								 e->Node->EndEdit(false);
								 e->Node->Collapse();
								 e->Node->TreeView->LabelEdit=false;
								 result=1;
								 }
							 else
								 {
								 /* Cancel the label edit action, inform the user, and
								 place the node in edit mode again. */
								 e->CancelEdit = true;
								 MessageBox::Show( String::Concat( "Invalid Directory Name.\n",
									 "The invalid characters are: '@','.', ',', '!' '\\'" ),
									 "Node Label Edit" );
								 e->Label->Copy("NewDir");
								 e->Node->BeginEdit();
								 }
							 }
						 else
							 {
							 /* Cancel the label edit action, inform the user, and
							 place the node in edit mode again. */
							 e->CancelEdit = true;
							 MessageBox::Show( "Invalid Directory Name.\nThe Name cannot be Blank or Too long (12 characters Maximum)",
								 "Node Label Edit" );
							 e->Label->Copy("NewDir");
							 e->Node->BeginEdit();
							 }
						 }
					 return result;
					 }


		private: System::Void treeViewFiles_AfterLabelEdit(System::Object^ sender, System::Windows::Forms::NodeLabelEditEventArgs^ e)
					 {
					 FRESULT fresult;
					 System::String^ fileNameString;

					 if(AfterLabelEdit(sender, e))
						 {
						 fileNameString=getPathOnly(currentTreeNodePath)+e->Label;
						 fresult=createDirectoryOnDevice(fileNameString);
						 if(fresult==FR_OK)
							 {
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Creating Directory: \""+fileNameString+"\" on Device: Done!\r\n");
							 if(e->Node->Parent!=nullptr)e->Node->Parent->Nodes->Clear();
							 else e->Node->TreeView->Nodes->Clear();
							 }
						 else
							 {
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Creating Directory: \""+fileNameString+"\" on Device: Error!\r\n");
							 }
						 }
					 }

		private: System::Void treeViewPCFiles_AfterLabelEdit(System::Object^ sender, System::Windows::Forms::NodeLabelEditEventArgs^ e)
					 {
					 System::String^ fileNameString;

					 if(AfterLabelEdit(sender, e))
						 {
						 fileNameString=currentTreePCNodePath+"\\"+e->Label;
						 Directory::CreateDirectory(fileNameString);
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Creating Directory: \""+fileNameString+"\" on PC: Done!\r\n");
						 if(e->Node->Parent!=nullptr)e->Node->Parent->Nodes->Clear();
						 else e->Node->TreeView->Nodes->Clear();
						 }
					 }

		private: System::Void CreateDirectoryTree_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 /* Create a Directory on the device */
					 System::Windows::Forms::TreeNode^ newNode;

					 if(this->treeViewFiles->LabelEdit)
						 {


						 }
					 else
						 {
						 newNode=gcnew System::Windows::Forms::TreeNode();
						 newNode->Name="NewDir";
						 newNode->Text="NewDir";
						 currentTreeNode->Nodes->Add(newNode);
						 currentTreeNode->Expand();
						 newNode->TreeView->LabelEdit=true;
						 newNode->BeginEdit();
						 }
					 }

		private: System::Void CreatePCDirectoryTree_Click(System::Object^ sender, System::EventArgs^ e)
					 {
					 /* Create a Directory on the device */
					 System::Windows::Forms::TreeNode^ newNode;

					 if(this->treeViewPCFiles->LabelEdit)
						 {


						 }
					 else
						 {
						 newNode=gcnew System::Windows::Forms::TreeNode();
						 newNode->Name="NewDir";
						 newNode->Text="NewDir";
						 currentTreePCNode->Nodes->Add(newNode);
						 currentTreePCNode->Expand();
						 newNode->TreeView->LabelEdit=true;
						 newNode->BeginEdit();
						 }
					 }

		private: System::Void treeViewPCFiles_NodeMouseClick(System::Object^ sender, System::Windows::Forms::TreeNodeMouseClickEventArgs^ e)
					 {

					 System::Windows::Forms::TreeNode^ intree;
					 System::String^ path;
					 FRESULT fresult;
					 int i;
					 int j;


					 if(this->treeViewPCFiles->LabelEdit)
						 {

						 }
					 else
						 {
						 intree=e->Node;
						 this->treeViewPCFiles->SelectedNode=intree;
						 this->currentTreePCNodePath=intree->Name;
						 this->currentTreePCNode=intree;
						 if(intree->Parent)this->currentTopNode=intree->Parent;
						 else this->currentTopNode=intree->TreeView->Nodes[0];

						 if(intree->Text[0]==(wchar_t)'[')
							 {
							 path=intree->Name;
							 readAllPCDirectoryEntries(path, &fresult, intree, &currentTreePCDir);
							 }

						 if(e->Button==System::Windows::Forms::MouseButtons::Left)
							 {

							 }
						 else
							 if(e->Button==System::Windows::Forms::MouseButtons::Right)
								 {

								 System::Windows::Forms::ContextMenu^	mContextMenu;
								 System::Windows::Forms::MenuItem^		mItem0;
								 System::Windows::Forms::MenuItem^		mItem1;
								 System::Windows::Forms::MenuItem^		mItem2;
								 System::Windows::Forms::MenuItem^		mItem4;
								 System::Windows::Forms::TreeNode^ mTreeNode;
								 System::Windows::Forms::TreeNodeCollection^ collection;

								 collection=currentTopNode->Nodes;
								 i=0;								
								 j=0;	   
								 while(j<collection->Count)
									 {
									 mTreeNode=collection[j++];
									 if(mTreeNode->Checked)
										 {
										 i++;
										 }
									 }

								 if(intree->Text[0]==(wchar_t)'[')
									 {

									 mContextMenu=gcnew System::Windows::Forms::ContextMenu();
									 mContextMenu->Name="Menu";

									 mItem0=gcnew System::Windows::Forms::MenuItem();
									 mItem0->Text="Create Directory";
									 mItem0->Click+=gcnew System::EventHandler(this, &Form1::CreatePCDirectoryTree_Click);
									 mContextMenu->MenuItems->Add(mItem0);
									 if((intree->Text[0]!=(wchar_t)'[')||(intree->Text[1]!=(wchar_t)'.')||(intree->Text[2]!=(wchar_t)']'))
										 {
										 mItem1=gcnew System::Windows::Forms::MenuItem();
										 mItem1->Text="Delete";
										 mItem1->Click+=gcnew System::EventHandler(this, &Form1::DeletePCFileMenuTree_Click);
										 mContextMenu->MenuItems->Add(mItem1);
										 }
									 mContextMenu->Show(this->treeViewPCFiles, System::Drawing::Point(e->X, e->Y));

									 }
								 else
									 {
									 mContextMenu=gcnew System::Windows::Forms::ContextMenu();
									 mContextMenu->Name="Menu";

									 mItem0=gcnew System::Windows::Forms::MenuItem();
									 mItem0->Text="Show File";
									 mItem0->Click+=gcnew System::EventHandler(this, &Form1::GetPCTextFileMenuTree_Click);
									 mContextMenu->MenuItems->Add(mItem0);

									 mItem2=gcnew System::Windows::Forms::MenuItem();
									 mItem2->Text="Load Source From Text File";
									 mItem2->Click+=gcnew System::EventHandler(this, &Form1::LoadPCSource_Click);
									 mContextMenu->MenuItems->Add(mItem2);

									 mItem1=gcnew System::Windows::Forms::MenuItem();
									 mItem1->Text="Delete";
									 mItem1->Click+=gcnew System::EventHandler(this, &Form1::DeletePCFileMenuTree_Click);
									 mContextMenu->MenuItems->Add(mItem1);

									 if(i>0)
										 {

										 mItem4=gcnew System::Windows::Forms::MenuItem();
										 mItem4->Text="Unselect All";
										 mItem4->Click+=gcnew System::EventHandler(this, &Form1::UnselectAll_Click);
										 mContextMenu->MenuItems->Add(mItem4);

										 }

									 mContextMenu->Show(this->treeViewPCFiles, System::Drawing::Point(e->X, e->Y));
									 }
								 }
						 }
					 }


		private: System::Void treeViewFiles_NodeMouseClick(System::Object^ sender, System::Windows::Forms::TreeNodeMouseClickEventArgs^ e)
					 {

					 System::Windows::Forms::TreeNode^ intree;
					 char			path[MAX_PATH_LENGTH];
					 char			fileName[MAX_PATH_LENGTH];
					 FRESULT		fresult;
					 unsigned int	i;
					 int			j;

					 if(this->treeViewFiles->LabelEdit)
						 {

						 }
					 else
						 {
						 intree=e->Node;
						 this->treeViewFiles->SelectedNode=intree;
						 this->currentTreeNodePath=intree->Name;
						 this->currentTreeNode=intree;
						 if(intree->Parent)this->currentTopNode=intree->Parent;
						 else this->currentTopNode=intree->TreeView->Nodes[0];

						 if(intree->Text[0]==(wchar_t)'[')
							 {
							 if(intree->Name->Length<MAX_PATH_LENGTH)
								 {
								 getUnsignedCharPathFromString((unsigned char*)&path[0], (unsigned char*)&fileName[0], intree->Name, 1, MAX_PATH_LENGTH);
								 if(path[0]=='\0')
									 {
									 this->treeViewFiles->ShowPlusMinus=true;
									 readAllDirectoryEntries((char*)&path[0], &fresult, this->treeViewFiles->Nodes[0], &currentTreeDir);
									 }
								 else
									 {
									 this->treeViewFiles->ShowPlusMinus=true;
									 readAllDirectoryEntries((char*)&path[0], &fresult, intree, &currentTreeDir);
									 }
								 }
							 }

						 if(e->Button==System::Windows::Forms::MouseButtons::Left)
							 {

							 }
						 else
							 if(e->Button==System::Windows::Forms::MouseButtons::Right)
								 {
								 System::Windows::Forms::ContextMenu^ mContextMenu;
								 System::Windows::Forms::MenuItem^ mItem0;
								 System::Windows::Forms::MenuItem^ mItem1;
								 System::Windows::Forms::MenuItem^ mItem2;
								 System::Windows::Forms::MenuItem^ mItem3;
								 System::Windows::Forms::MenuItem^ mItem4;
								 System::Windows::Forms::MenuItem^ mItem5;

								 System::Windows::Forms::TreeNode^ mTreeNode;
								 System::Windows::Forms::TreeNodeCollection^ collection;

								 collection=currentTopNode->Nodes;
								 i=0;								
								 j=0;	   
								 while(j<collection->Count)
									 {
									 mTreeNode=collection[j++];
									 if(mTreeNode->Checked)
										 {
										 i++;
										 }
									 }

								 if(intree->Text[0]==(wchar_t)'[')
									 {

									 mContextMenu=gcnew System::Windows::Forms::ContextMenu();
									 mContextMenu->Name="Menu";

									 mItem1=gcnew System::Windows::Forms::MenuItem();
									 mItem1->Text="Get";
									 mItem1->Click+=gcnew System::EventHandler(this, &Form1::GetMenuTree_Click);
									 mContextMenu->MenuItems->Add(mItem1);

									 mItem0=gcnew System::Windows::Forms::MenuItem();
									 mItem0->Text="Get As...";
									 mItem0->Click+=gcnew System::EventHandler(this, &Form1::GetAsMenuTree_Click);
									 mContextMenu->MenuItems->Add(mItem0);

									 mItem2=gcnew System::Windows::Forms::MenuItem();
									 mItem2->Text="Create Directory";
									 mItem2->Click+=gcnew System::EventHandler(this, &Form1::CreateDirectoryTree_Click);
									 mContextMenu->MenuItems->Add(mItem2);

									 mItem3=gcnew System::Windows::Forms::MenuItem();
									 mItem3->Text="Put As...";
									 mItem3->Click+=gcnew System::EventHandler(this, &Form1::PutAsMenuTree_Click);
									 mContextMenu->MenuItems->Add(mItem3);

									 mItem4=gcnew System::Windows::Forms::MenuItem();
									 mItem4->Text="Delete";
									 mItem4->Click+=gcnew System::EventHandler(this, &Form1::DeleteMenuTree_Click);
									 mContextMenu->MenuItems->Add(mItem4);


									 mContextMenu->Show(this->treeViewFiles, System::Drawing::Point(e->X, e->Y));

									 }
								 else
									 {

									 mContextMenu=gcnew System::Windows::Forms::ContextMenu();
									 mContextMenu->Name="Menu";

									 mItem1=gcnew System::Windows::Forms::MenuItem();
									 mItem1->Text="Get";
									 mItem1->Click+=gcnew System::EventHandler(this, &Form1::GetMenuTree_Click);
									 mContextMenu->MenuItems->Add(mItem1);

									 mItem5=gcnew System::Windows::Forms::MenuItem();
									 mItem5->Text="Get and Show File";
									 mItem5->Click+=gcnew System::EventHandler(this, &Form1::GetAndShowMenuTree_Click);
									 mContextMenu->MenuItems->Add(mItem5);

									 mItem0=gcnew System::Windows::Forms::MenuItem();
									 mItem0->Text="Get As...";
									 mItem0->Click+=gcnew System::EventHandler(this, &Form1::GetAsMenuTree_Click);
									 mContextMenu->MenuItems->Add(mItem0);

									 mItem2=gcnew System::Windows::Forms::MenuItem();
									 mItem2->Text="Put";
									 mItem2->Click+=gcnew System::EventHandler(this, &Form1::PutMenuTree_Click);
									 mContextMenu->MenuItems->Add(mItem2);

									 mItem3=gcnew System::Windows::Forms::MenuItem();
									 mItem3->Text="Put As...";
									 mItem3->Click+=gcnew System::EventHandler(this, &Form1::PutAsMenuTree_Click);
									 mContextMenu->MenuItems->Add(mItem3);

									 mItem4=gcnew System::Windows::Forms::MenuItem();
									 mItem4->Text="Delete";
									 mItem4->Click+=gcnew System::EventHandler(this, &Form1::DeleteMenuTree_Click);
									 mContextMenu->MenuItems->Add(mItem4);

									 if(i>0)
										 {
										 mItem5=gcnew System::Windows::Forms::MenuItem();
										 mItem5->Text="Unselect All";
										 mItem5->Click+=gcnew System::EventHandler(this, &Form1::UnselectAll_Click);
										 mContextMenu->MenuItems->Add(mItem5);

										 }

									 mContextMenu->Show(this->treeViewFiles, System::Drawing::Point(e->X, e->Y));
									 /* Now Refresh The Directory */
									 }
								 }
						 }
					 }

		private: System::Void checkBoxAutoSync_CheckedChanged(System::Object^ sender, System::EventArgs^ e)
					 {
					 DATA_LOGGER	tempUDL;
					 int			getResult;

					 getResult=getDataLogger(&tempUDL);
					 if(this->checkBoxAutoSync->Checked)
						 {
						 this->checkBoxAutoSync->CheckState=System::Windows::Forms::CheckState::Checked;
						 tempUDL.modes|=TIME_AUTO_SYNC_MODE;
						 }
					 else
						 {
						 this->checkBoxAutoSync->CheckState=System::Windows::Forms::CheckState::Unchecked;
						 tempUDL.modes&=~TIME_AUTO_SYNC_MODE;
						 }
					 if(getResult)putDataLogger(&tempUDL);
					 if(tempUDL.modes & TIME_AUTO_SYNC_MODE)syncTime();
					 }

		private: System::Void treeViewFiles_AfterSelect(System::Object^ sender, System::Windows::Forms::TreeViewEventArgs^ e)
					 {

					 }

		private: System::Void groupBoxConfiguration_Enter(System::Object^ sender, System::EventArgs^ e)
					 {

					 }

		private: System::Void checkBoxBatteryProtection_CheckedChanged(System::Object^ sender, System::EventArgs^ e)
					 {
					 DATA_LOGGER tempUDL;
					 int getResult;
					 getResult=getDataLogger(&tempUDL);
					 if(this->checkBoxBatteryProtection->Checked)
						 {
						 tempUDL.modes|=BATTERY_PROTECTION_MODE;
						 this->checkBoxBatteryProtection->CheckState=System::Windows::Forms::CheckState::Checked;
						 }
					 else
						 {
						 tempUDL.modes&=~BATTERY_PROTECTION_MODE;
						 this->checkBoxBatteryProtection->CheckState=System::Windows::Forms::CheckState::Unchecked;
						 }
					 if(getResult)putDataLogger(&tempUDL);
					 }

		private: System::Void numericUpDownBatteryProtect_MouseClick(System::Object^ sender, System::Windows::Forms::MouseEventArgs^ e)
					 {

					 }

		private: System::Void numericUpDownBatteryProtect_ValueChanged(System::Object^ sender, System::EventArgs^ e)
					 {
					 DATA_LOGGER tempUDL;
					 int getResult;

					 getResult=getDataLogger(&tempUDL);
					 if(getResult)
						 {
						 tempUDL.batteryProtectionVoltage=(float)this->numericUpDownBatteryProtect->Value;
						 putDataLogger(&tempUDL);
						 }
					 }
		private: System::Void checkBoxSystemLogging_CheckedChanged(System::Object^ sender, System::EventArgs^ e)
					 {
					 DATA_LOGGER tempUDL;
					 int getResult;

					 getResult=getDataLogger(&tempUDL);
					 if(this->checkBoxSystemLogging->Checked)
						 {
						 tempUDL.modes|=SYSTEM_LOGGING_MODE;
						 this->checkBoxSystemLogging->CheckState=System::Windows::Forms::CheckState::Checked;
						 this->checkBoxSystemLogUSB->Enabled=true;
						 }
					 else
						 {
						 tempUDL.modes&=~SYSTEM_LOGGING_MODE;
						 this->checkBoxSystemLogging->CheckState=System::Windows::Forms::CheckState::Unchecked;
						 this->checkBoxSystemLogUSB->Enabled=false;
						 }
					 if(getResult)putDataLogger(&tempUDL);
					 }


		private: System::Void treeViewScripts_NodeMouseClick(System::Object^ sender, System::Windows::Forms::TreeNodeMouseClickEventArgs^ e)
					 {
					 System::Windows::Forms::TreeNode^ intree;
					 unsigned char cid;


					 if(this->treeViewScripts->LabelEdit)
						 {

						 }
					 else
						 {
						 intree=e->Node;
						 currentScriptNode=intree;
						 if(e->Button==System::Windows::Forms::MouseButtons::Left)
							 {

							 }
						 else
							 if(e->Button==System::Windows::Forms::MouseButtons::Right)
								 {
								 if(intree->Text[0]=='[')
									 {
									 System::Windows::Forms::ContextMenu^ mContextMenu;
									 System::Windows::Forms::MenuItem^ mItem1;
									 mContextMenu=gcnew System::Windows::Forms::ContextMenu();
									 mContextMenu->Name="Menu";
									 mItem1=gcnew System::Windows::Forms::MenuItem();
									 mItem1->Text="Remove All Scripts";
									 mItem1->Click+=gcnew System::EventHandler(this, &Form1::RemoveAllScripts_Click);
									 mContextMenu->MenuItems->Add(mItem1);

									 mContextMenu->Show(this->treeViewScripts, System::Drawing::Point(e->X, e->Y));
									 }
								 else
									 {
									 System::Windows::Forms::ContextMenu^ mContextMenu;
									 System::Windows::Forms::MenuItem^ mItem1;
									 System::Windows::Forms::MenuItem^ mItem2;
									 System::Windows::Forms::MenuItem^ mItem3;
									 System::Windows::Forms::MenuItem^ mItem4;
									 System::Windows::Forms::MenuItem^ mItem5;

									 cid=System::Decimal::ToByte((System::Decimal)intree->Tag);

									 mContextMenu=gcnew System::Windows::Forms::ContextMenu();
									 mContextMenu->Name="Menu";
									 mItem1=gcnew System::Windows::Forms::MenuItem();
									 mItem1->Text="Remove Script";
									 mItem1->Click+=gcnew System::EventHandler(this, &Form1::RemoveScript_Click);
									 mContextMenu->MenuItems->Add(mItem1);

									 mItem2=gcnew System::Windows::Forms::MenuItem();
									 if(cid & VM_ID_HOLD)mItem2->Text="Restart Script"; else mItem2->Text="Pause Script";
									 mItem2->Click+=gcnew System::EventHandler(this, &Form1::TogglePauseScript_Click);
									 mContextMenu->MenuItems->Add(mItem2);

									 mItem3=gcnew System::Windows::Forms::MenuItem();
									 mItem3->Text="Load Source Code";
									 mItem3->Click+=gcnew System::EventHandler(this, &Form1::LoadSourceScript_Click);
									 mContextMenu->MenuItems->Add(mItem3);

									 mItem4=gcnew System::Windows::Forms::MenuItem();
									 mItem4->Text="Get And Show Log File";
									 mItem4->Click+=gcnew System::EventHandler(this, &Form1::LoadLogFileForScript_Click);
									 mContextMenu->MenuItems->Add(mItem4);

									 mItem5=gcnew System::Windows::Forms::MenuItem();
									 mItem5->Text="Clear Log File";
									 mItem5->Click+=gcnew System::EventHandler(this, &Form1::ClearLogFileForScript_Click);
									 mContextMenu->MenuItems->Add(mItem5);

									 mContextMenu->Show(this->treeViewScripts, System::Drawing::Point(e->X, e->Y));


									 }
								 }
						 }
					 }

		private: System::Void treeViewPCScripts_NodeMouseClick(System::Object^ sender, System::Windows::Forms::TreeNodeMouseClickEventArgs^ e)
					 {
					 System::Windows::Forms::TreeNode^ intree;
					 unsigned char cid;

					 if(this->treeViewPCScripts->LabelEdit)
						 {

						 }
					 else
						 {
						 intree=e->Node;
						 currentScriptNode=intree;
						 if(e->Button==System::Windows::Forms::MouseButtons::Left)
							 {

							 }
						 else
							 if(e->Button==System::Windows::Forms::MouseButtons::Right)
								 {
								 if(intree->Text[0]=='[')
									 {
									 System::Windows::Forms::ContextMenu^ mContextMenu;
									 System::Windows::Forms::MenuItem^ mItem1;
									 System::Windows::Forms::MenuItem^ mItem2;
									 System::Windows::Forms::MenuItem^ mItem3;

									 mContextMenu=gcnew System::Windows::Forms::ContextMenu();
									 mContextMenu->Name="Menu";
									 mItem1=gcnew System::Windows::Forms::MenuItem();
									 mItem1->Text="Add PC Script";
									 mItem1->Click+=gcnew System::EventHandler(this, &Form1::AddPCScript_Click);
									 mContextMenu->MenuItems->Add(mItem1);

									 mItem3=gcnew System::Windows::Forms::MenuItem();
									 mItem3->Text="Send All PC Scripts";
									 mItem3->Click+=gcnew System::EventHandler(this, &Form1::SendAllPCScriptsToDevice_Click);
									 mContextMenu->MenuItems->Add(mItem3);

									 mItem2=gcnew System::Windows::Forms::MenuItem();
									 mItem2->Text="Remove All PC Scripts";
									 mItem2->Click+=gcnew System::EventHandler(this, &Form1::RemoveAllPCScripts_Click);
									 mContextMenu->MenuItems->Add(mItem2);

									 mContextMenu->Show(this->treeViewPCScripts, System::Drawing::Point(e->X, e->Y));
									 }
								 else
									 {
									 System::Windows::Forms::ContextMenu^ mContextMenu;
									 System::Windows::Forms::MenuItem^ mItem0;
									 System::Windows::Forms::MenuItem^ mItem1;
									 System::Windows::Forms::MenuItem^ mItem2;
									 System::Windows::Forms::MenuItem^ mItem3;
									 System::Windows::Forms::MenuItem^ mItem4;
									 System::Windows::Forms::MenuItem^ mItem5;

									 cid=System::Decimal::ToByte((System::Decimal)intree->Tag);

									 mContextMenu=gcnew System::Windows::Forms::ContextMenu();
									 mContextMenu->Name="Menu";
									 mItem1=gcnew System::Windows::Forms::MenuItem();
									 mItem1->Text="Remove PC Script";
									 mItem1->Click+=gcnew System::EventHandler(this, &Form1::RemovePCScript_Click);
									 mContextMenu->MenuItems->Add(mItem1);

									 mItem2=gcnew System::Windows::Forms::MenuItem();
									 mItem2->Text="Send PC Script";
									 mItem2->Click+=gcnew System::EventHandler(this, &Form1::SendPCScriptToDevice_Click);
									 mContextMenu->MenuItems->Add(mItem2);

									 mItem3=gcnew System::Windows::Forms::MenuItem();
									 mItem3->Text="Load Source Code";
									 mItem3->Click+=gcnew System::EventHandler(this, &Form1::LoadSourcePCScript_Click);
									 mContextMenu->MenuItems->Add(mItem3);

									 mItem0=gcnew System::Windows::Forms::MenuItem();
									 mItem0->Text="Select PC Script";
									 mItem0->Click+=gcnew System::EventHandler(this, &Form1::SelectPCScript_Click);
									 mContextMenu->MenuItems->Add(mItem0);

									 mItem4=gcnew System::Windows::Forms::MenuItem();
									 mItem4->Text="Get And Show Log File";
									 mItem4->Click+=gcnew System::EventHandler(this, &Form1::LoadLogFileForPCScript_Click);
									 mContextMenu->MenuItems->Add(mItem4);

									 mItem5=gcnew System::Windows::Forms::MenuItem();
									 mItem5->Text="Clear Log File";
									 mItem5->Click+=gcnew System::EventHandler(this, &Form1::ClearLogFileForPCScript_Click);
									 mContextMenu->MenuItems->Add(mItem5);

									 mContextMenu->Show(this->treeViewPCScripts, System::Drawing::Point(e->X, e->Y));
									 }
								 }
						 }
					 }
		private: System::Void menuStrip1_ItemClicked(System::Object^ sender, System::Windows::Forms::ToolStripItemClickedEventArgs^ e){


					 }


		private: System::Void checkBoxShowMemory_CheckedChanged(System::Object^ sender, System::EventArgs^ e)
					 {
					 if(this->checkBoxShowMemory->Checked)
						 {
						 this->textBoxLog->Visible=false;
						 this->textBoxLog->Enabled=false;
						 this->dataGridView1->Visible=true;
						 this->textBoxDebug->Visible=true;
						 this->dataGridView1->Enabled=true;
						 this->numericUpDownMemoryOffset->Enabled=true;
						 }
					 else
						 {
						 this->dataGridView1->Visible=false;
						 this->dataGridView1->Enabled=false;
						 this->textBoxDebug->Visible=false;
						 this->numericUpDownMemoryOffset->Enabled=false;
						 this->textBoxLog->Visible=true;
						 this->textBoxLog->Enabled=true;
						 }
					 }

		private: System::Void statusStrip1_ItemClicked(System::Object^ sender, System::Windows::Forms::ToolStripItemClickedEventArgs^ e)
					 {

					 }

		private: System::Void labelVoltage_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 localSettings.voltageShowMode++;
					 timerCounter2=0;
					 timerCounter1=0;
					 }


		private: System::Void FileOpen_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 buttonOpenFile_Click(sender, e);
					 }

		private: System::Void FileAdd_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 buttonAddToFile_Click(sender, e);
					 }

		private: System::Void FileCompile_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 textBoxInput_CompileOption(sender, e, 0);
					 }

		private: System::Void FileCompileAndSend_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 textBoxInput_CompileOption(sender, e, 1);
					 }

		private: System::Void FileClose_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 buttonSaveFile_Click(sender, e);
					 this->textBoxInput1->Clear();
					 this->lastOpenedFile="";
					 this->Text=this->titleBase+TITLE_MIDDLE_STRING+this->lastOpenedFile;
					 }

		private: System::Void clearLog_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 this->textBoxLog->Clear();
					 }

		private: System::Void FileSaveAs_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 buttonSaveAsFile_Click(sender, e);
					 }

		private: System::Void FileSave_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 buttonSaveFile_Click(sender, e);
					 }

		private: System::Void restoreDefaultsToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 String^ message = "Are you sure you would like To Restore The USB Data Logger's Settings To Defaults?\r\nAll Settings Will Be Lost!";
					 String^ caption = "Warning: Restoring Default Settings";
					 MessageBoxButtons buttons = MessageBoxButtons::YesNo;
					 System::Windows::Forms::DialogResult result;
					 result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING );
					 if (result==::DialogResult::Yes)
						 {
						 if(restoreDefaultDeviceSettings())
							 {
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Device Defaults Restored!\r\n");
							 disConnectGUI(sender, e);
							 }
						 }
					 }

		private: System::Void FileExit_Click(System::Object^  sender, System::EventArgs^  e)
					 {
					 this->Close();
					 }

		private: System::Void FileReset_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 if(resetDevice())
						 {
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Device Reset!\r\n");
						 disConnectGUI(sender, e);
						 }
					 }

		private: System::Void DeviceSaveSettings_Click(System::Object^  sender, System::EventArgs^  e)
					 {	
					 int			getResult;
					 DATA_LOGGER	tempUDL;
					 std::string	myString;

					 getResult=getDataLogger(&tempUDL);
					 if(getResult)
						 {
						 tempUDL.dirty|=DL_DIRTY;
						 saveSettings(&tempUDL, myString, "");
						 }		 
					 }

		private: System::Void DeviceRestoreSettings_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 int getResult;
					 DATA_LOGGER tempUDL;
					 std::string	myString;

					 if(restoreSettings(&tempUDL, myString, ""))
						 {
						 getResult=putDataLogger(&tempUDL);
						 if(getResult)
							 {
							 saveSettings(&tempUDL, myString, "");
							 }
						 }
					 }

		private: System::Void TimeSyncDeviceTime_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 int result;
					 DATA_LOGGER tempUDL;
					 int getResult;

					 result=0;
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(    getPCLocalTimeString()+"Time From Device: "+getTimeFromDeviceString()+".\r\n");
					 syncTime();
					 getResult=getDataLogger(&tempUDL);
					 if(getResult)
						 {
						 this->textBoxLog->ScrollToCaret();
						 tempUDL.lastSyncTime.show=(SHOW_TIME_DEFAULT);
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Last Sync. Time : "+getTimeString(&tempUDL.lastSyncTime)+".\r\n");
						 }
					 else
						 {
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Last Sync. Time : Time Unavailable.\r\n");
						 }
					 }

		private: System::Void getInfoToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
				  {

				  int				getResult;
				  System::String^ responseString;

				  /* Get Information About the Memory Card */
				  responseString="Memory Card Information Unavailable!\r\n";
				  stopDeviceRunning();
				  getResult=getFullCardInfo(&lastInfo);
				  if(getResult)
					  {
					  getResult=compareCopy((unsigned char*)&cardInfo, (unsigned char*)&lastInfo, sizeof(CARD_INFO));
					  updateMemoryCardRoot(this->treeViewFiles);
					  responseString=getFullMemoryCardInfoString(&cardInfo);
					  }			
				  String^ message = responseString;
				  String^ caption = "Memory Card Information";
				  MessageBoxButtons buttons = MessageBoxButtons::OK;
				  System::Windows::Forms::DialogResult result;
				  result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_INFORMATION);
					 }

		private: System::Void numericUpDownMemoryOffset_ValueChanged(System::Object^  sender, System::EventArgs^  e) 
					 {
					 memoryOffset[localUDL.dataLogger.ven.vmSelected]=(ADDRESS_TYPE)(int)this->numericUpDownMemoryOffset->Value;
					 refreshDataTable(this->dataGridView1, this->LocalMemoryTable, &localUDL.dataLogger.ven.cVM, localUDL.dataLogger.ven.vmSelected, memoryOffset[localUDL.dataLogger.ven.vmSelected], MEMORY_NUM_COLS, MEMORY_NUM_ROWS);
					 updateCurrentCell(this->dataGridView1);
					 }

		private: System::Void dataGridView1_CellClick(System::Object^  sender, System::Windows::Forms::DataGridViewCellEventArgs^  e) 
					 {

					 }

		private: System::Void clearSystemLogToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 { 

					 unsigned int delresult;
					 String^ message = "Are you sure you would like to Delete the Device's System Log?";
					 String^ caption = "Warning: Deleting Log";
					 MessageBoxButtons buttons = MessageBoxButtons::YesNo;
					 System::Windows::Forms::DialogResult result;
					 result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING);
					 stopTimer1();
					 if (result==::DialogResult::Yes)
						 {
						 delresult=deleteLog();	
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"Deleting Log from Device: ");
						 if(delresult)
							 {
							 this->textBoxLog->AppendText("Ok.\r\n");
							 }
						 else
							 {
							 this->textBoxLog->AppendText("Error.\r\n");
							 }	
						 }
					 startTimer1();
					 }

		private: System::Void localToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {

					 this->checkBoxShowMemory->Checked=!this->checkBoxShowMemory->Checked;

					 }

		private: System::Void updateCurrentCell(System::Windows::Forms::DataGridView^ grid)
					 {
					 unsigned int col;
					 unsigned int row;

					 if(grid->CurrentCell)
						 {
						 col=(unsigned int)grid->CurrentCell->ColumnIndex;
						 row=(unsigned int)grid->CurrentCell->RowIndex;
						 if((col>=1)&&(row>=1))
							 {
							 this->labelMemory->Text="0x"+HexToString((ADDRESS_TYPE)((int)this->numericUpDownMemoryOffset->Value)+(col-1)+(row-1)*MEMORY_NUM_COLS, 2);
							 }
						 }		
					 }

		private: System::Void dataGridView1_CellEnter(System::Object^  sender, System::Windows::Forms::DataGridViewCellEventArgs^  e) 
					 {
					 updateCurrentCell(this->dataGridView1);		 
					 }

		private: System::Void textBoxDebug_KeyPress(System::Object^  sender, System::Windows::Forms::KeyPressEventArgs^  e) 
					 {

					 }

		private: System::Void addRowColumnCurrentCell(System::Windows::Forms::DataGridView^ grid, int drow, int dcol)
					 {

					 /* Will only work properly if abs value of drow and dcol are between 0 and 1 */
					 int nc, nr;
					 System::Decimal x;
					 int min;
					 int wrap;

					 wrap=0;
					 if((grid->CurrentCell)&&(grid->CurrentCell->Selected))
						 {
						 nc=grid->CurrentCell->ColumnIndex;
						 nr=grid->CurrentCell->RowIndex;
						 min=1;
						 x=this->numericUpDownMemoryOffset->Value;

						 nc+=dcol;

						 if(nc>MEMORY_NUM_COLS)
							 {
							 drow++;
							 nc=min;
							 wrap=1;
							 }
						 else
							 if(nc<min)
								 {
								 nc=MEMORY_NUM_COLS;
								 drow--;
								 wrap=1;
								 }

							 nr+=drow;
							 while(nr>MEMORY_NUM_ROWS)
								 {
								 x+=(System::Decimal)(MEMORY_NUM_COLS);
								 wrap=1;
								 nr--;
								 }
							 while(nr<min)
								 {
								 x-=(System::Decimal)(MEMORY_NUM_COLS);
								 wrap=1;
								 nr++;
								 }

							 if(nr<min)nr=min;
							 else
								 if(nr>MEMORY_NUM_ROWS)nr=MEMORY_NUM_ROWS;

							 if(nc<min)nc=min;
							 else
								 if(nc>MEMORY_NUM_COLS)nc=MEMORY_NUM_COLS;

							 if(x<this->numericUpDownMemoryOffset->Minimum)x=this->numericUpDownMemoryOffset->Minimum;
							 else
								 if(x>this->numericUpDownMemoryOffset->Maximum)x=this->numericUpDownMemoryOffset->Maximum;
							 this->numericUpDownMemoryOffset->Value=x;

							 if(wrap)
								 {
								 grid->CurrentCell=this->dataGridView1->Rows[nr]->Cells[nc];
								 grid->CurrentCell->Selected=true;
								 }
						 }
					 }

		private: System::Void dataGridView1_CurrentCellChanged(System::Object^  sender, System::EventArgs^  e) 
					 {
					 updateCurrentCell(this->dataGridView1);		 	
					 }

		private: System::Void dataGridView1_KeyUp(System::Object^ sender, System::Windows::Forms::KeyEventArgs^  e) 
					 {
					 switch(e->KeyCode)
						 {
						 case Keys::Up:
							 addRowColumnCurrentCell(this->dataGridView1, -1, 0);
							 break;

						 case Keys::Down:
							 addRowColumnCurrentCell(this->dataGridView1, 1, 0);
							 break;

						 case Keys::Left:
							 addRowColumnCurrentCell(this->dataGridView1, 0, -1);
							 break;

						 case Keys::Right:
							 addRowColumnCurrentCell(this->dataGridView1, 0, 1);
							 break;

						 default:
							 break;
						 }
					 }


		private: System::Void resetToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {

					 bool en;

					 setRunMenu(1);
					 en=timer2->Enabled;
					 timer2->Stop();

					 destroyAllVM(&localUDL.dataLogger.ven, &firstPor);
					 clearVMEnvironment(&localUDL.dataLogger.ven);
					 if(en)
							{
							timer2->Start();
							}
					 else
							{
							setRunMenu(2);
							}
					 }

		private: System::Void resetDeviceToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 DATA_LOGGER tempUDL;
					 int			getResult;
					 int			gcaptive;

					 if(ConnectedUser())
							{
							setRunMenu(0);
							gcaptive=getCaptiveDevice();
							setCaptiveDevice(1);
							getResult=getDataLogger(&tempUDL);
							if(getResult)
								{
								/* Commit the changes! */
								tempUDL.ven.vmMode|=(VME_HOLD | VME_RESTART);
								getResult=putDataLogger(&tempUDL);
								if(getResult)setCaptiveDevice(gcaptive);
								}
							else
								{
								if(gcaptive>=0)setCaptiveDevice(gcaptive);
								}
							if(gcaptive==1)setRunMenu(2);
						 }
					 else
							{

						 }					 
					 }

		private: System::Void runToolStripMenuItem1_Click(System::Object^  sender, System::EventArgs^  e) 
					 {

					 setRunMenu(1);
					 if(timer2->Enabled)
						 {

						 runMode=SIMULATE_RUN_MODE;								
						 }
					 else
						 {

						 runMode=SIMULATE_RUN_MODE;								
						 clearVMEnvironment(&localUDL.dataLogger.ven);
						 timer2->Start();
						 }
					 }


		private: System::Void runDeviceToolStripMenuItem1_Click(System::Object^  sender, System::EventArgs^  e) 
					 {

					 if(ConnectedUser())
							{
							timer2->Stop();
							setRunMenu(0);
							if(isDeviceRunning())
								{
								resetDeviceToolStripMenuItem_Click(sender, e);
								setCaptiveDevice(0);
								}
							else
								{
								setCaptiveDevice(0);
								}
							}
					 else
							{

							}
					 }

		private: System::Void timer2_Tick(System::Object^  sender, System::EventArgs^  e) 
					 {

					 TIME_T timePC;
					 int i;
					 std::string outputString;
					 VIRTUAL_MACHINE  tempVM;

					 if(timerCounter3>0)
						 {
						 /* Fast Processes */

						 if(alarmEvent & ALARM_SET_EVENT)
								{

								/* Check the Alarm! */

								if(localUDL.dataLogger.ven.timeScaling)
									{
									tempVM.timeScaling=localUDL.dataLogger.ven.timeScaling;
									tempVM.timeSpeed=localUDL.dataLogger.ven.timeSpeed;
									tempVM.timeOffset=localUDL.dataLogger.ven.timeOffset;
									getTimeVM(&tempVM, &timePC);
									}
								else 
									{
									getLocalTimePC(&timePC);
									}

								i=compareTimes(&alarmTime, &timePC);
								if(i<=0)
									{
									/* Alarm Triggered! */
									alarmEvent|=ALARM_TRIGGER_EVENT;
									alarmEvent&=~ALARM_SET_EVENT;	
									}

								}
						 else
								{

								}

						 outputString="";

						 switch(runMode)
								{

							 case SIMULATE_RUN_MODE:
								 VMEnvironmentSuperTask(&localUDL.dataLogger.ven, outputString);
								 break;

							 case STEP_RUN_MODE:
								 if(localUDL.dataLogger.ven.vmState==VME_STEP_VM)
									 {
									 if(this->dataGridView1->Visible)
										 {
										 refreshDataTable(this->dataGridView1, this->LocalMemoryTable, &localUDL.dataLogger.ven.cVM, localUDL.dataLogger.ven.vmPtr, memoryOffset[localUDL.dataLogger.ven.vmPtr], MEMORY_NUM_COLS, MEMORY_NUM_ROWS); 
										 }
									 else
										 {

										 }
									 showVM(&localUDL.dataLogger.ven.cVM, outputString);
									 this->textBoxDebug->Clear();
									 this->textBoxDebug->ScrollToCaret();
									 this->textBoxDebug->AppendText(getStringFromStdString(&outputString));
									 }
								 VMEnvironmentTask(&localUDL.dataLogger.ven, outputString);
								 runMode=IDLE_MODE;
								 break;

							 case IDLE_MODE:
							 default:
								 break;

								}
						 this->textBoxSerialUSB->ScrollToCaret();
						 this->textBoxSerialUSB->AppendText(getStringFromStdString(&myVMOutput));
						 myVMOutput="";
						 timerCounter3--;

						 }
					 else
						 {
						 switch(runMode)
							 { 
							 case SIMULATE_RUN_MODE:
								 break;

							 case STEP_RUN_MODE:
								 break;

							 case IDLE_MODE:
							 default:
								 break;
						  }
						 updateScripts(this->treeViewPCScripts, &localUDL.dataLogger, "Host Scripts: ", 0);
						 timerCounter3=(SLOW_SIMULATION_UPDATE_PERIOD_MS/timer2->Interval);
						 Application::DoEvents();
						 }
					 }

		private: System::Void stopToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
						{

						setRunMenu(2);
						if(timer2->Enabled)
							{
							timer2->Stop();
							runMode=IDLE_MODE;
							}
						else
							{

							}
						}

		private: System::Void stopDeviceToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
						{

						setRunMenu(2);
						if(ConnectedUser())
							{
							setCaptiveDevice(1);
							}
						else
							{

							}

						}

		private: System::Void runStopToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {

					 if(timer2->Enabled)
						 {

						 stopToolStripMenuItem_Click(sender, e);

						 }
					 else
						 {

						 runToolStripMenuItem1_Click(sender, e);   							

						 }
					 }

		private: System::Void runStopDeviceToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 int gcaptive;

					 if(ConnectedUser())
						 {
						 gcaptive=getCaptiveDevice();
						 if(gcaptive>=1)
							 {
							 runDeviceToolStripMenuItem1_Click(sender, e);   							
							 }
							else
								{
								stopDeviceToolStripMenuItem_Click(sender, e);
							 }

						 }
						else
							{

						 }
					 }

		private: System::Void buttonClearConsole_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 this->textBoxSerialUSB->Clear();
					 }

		private: System::Void textBoxInput1_TextChanged(System::Object^  sender, System::EventArgs^  e) 
					 {

					 this->stopToolStripMenuItem_Click(sender, e);
					 this->stopDeviceToolStripMenuItem_Click(sender, e);
					 }


		private: System::Void uSBDataLoggerToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 float deviceFirmwareVersion;
					 String^ message;
					 String^ caption = "Information...";
					 MessageBoxButtons buttons = MessageBoxButtons::OK;
					 System::Windows::Forms::DialogResult result;
					 int getResult;
					 DATA_LOGGER tempUDL;
					 unsigned long devicePORs;

					 stopDeviceRunning();
					 deviceFirmwareVersion=getFirmwareVersion(&devicePORs);
					 message="PC Host Version:\t\t"+formatStringFloat((double)HOST_VERSION, 2)+"\r\n";
					 if((Connection_Status)&&(deviceFirmwareVersion>0.0))
							{
							message+="Firmware Version:\t\t"+formatStringFloat((double)deviceFirmwareVersion, 2)+"\r\n";
							message+="Serial BootLoader:\t\t"+formatStringFloat((double)serialBootLoaderVersion, 2)+"\r\n";
							message+="USB BootLoader:\t\t"+formatStringFloat((double)USBBootLoaderVersion/100.0, 2)+"\r\n";
							getResult=getDataLogger(&tempUDL);
							if(getResult)
								{
								message+="Global PORs:\t\t"+formatStringFloat((double)devicePORs, 0)+"\r\n";
								message+="Local  PORs:\t\t"+formatStringFloat((double)tempUDL.pors, 0)+"\r\n";	
								}
							}
					 else
							{
							System::String^ msg1="-\r\n";
							message+="Firmware Version:\t\t"+msg1;
							message+="Serial BootLoader:\t\t"+msg1;
							message+="USB BootLoader:\t\t"+msg1;
							message+="Global PORs:\t\t"+msg1;
							message+="Local  PORs:\t\t"+msg1;	
							}
					 result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_INFORMATION);
					 stopTimer1();
					 if (result==::DialogResult::OK)
						 {

						 }
					 startTimer1();
					 }

		private: System::Void newFileToolStripMenu_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 buttonSaveFile_Click(sender, e);
					 this->textBoxInput1->Clear();
					 }

		private: System::Void buttonRunVM_Click_1(System::Object^  sender, System::EventArgs^  e) 
					 {
					 if(deviceSelected)
						 {
						 this->runDeviceToolStripMenuItem1_Click(sender, e);					
						 }
					 else
						 {
						 this->runToolStripMenuItem1_Click(sender, e);					
						 }
					 }

		private: System::Void buttonStop_Click(System::Object^  sender, System::EventArgs^  e) {

					 if(deviceSelected)
						 {
						 this->stopDeviceToolStripMenuItem_Click(sender, e);					
						 }
					 else
						 {
						 this->stopToolStripMenuItem_Click(sender, e);					
						 }
					 }

		private: System::Void buttonReset_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 if(deviceSelected)
						 {
						 this->resetDeviceToolStripMenuItem_Click(sender, e);					
						 }
					 else
						 {
						 this->resetToolStripMenuItem_Click(sender, e);					
						 }
					 }

		private: System::Void buttonStep_Click(System::Object^  sender, System::EventArgs^  e)
					 {

					 }

		private: System::Void stepToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 keyFull=1;
					 setRunMenu(1);
					 this->buttonStep->BackColor=OK_COLOUR;
					 if(timer2->Enabled)
						 {
						 runMode=STEP_RUN_MODE;
						 this->checkBoxShowMemory->Checked=true;
						 }
					 else
						 {
						 runMode=STEP_RUN_MODE;
						 this->checkBoxShowMemory->Checked=true;
						 timer2->Start();
						 }	
					 }

		private: System::Void labelLastTimeSynced_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 localSettings.timeShowMode++;
					 switch(localSettings.timeShowMode)
						 {
						 default:
						 case 0:
							 localSettings.timeShowMode=0;
							 this->labelLastTimeSynced->Text="Local Time:";
							 break;

						 case 1:
							 localSettings.lastSyncDuration=updateLastSync(1);
							 this->labelLastTimeSynced->Text="Last Sync:";
							 break;

						 case 2:
							 this->labelLastTimeSynced->Text="Time Diff:";
							 break;

						 case 3:
							 this->labelLastTimeSynced->Text="Time Diff (%):";								
							 break;

						 case 4:
							 this->labelLastTimeSynced->Text="Last Diff:";
							 break;

						 case 5:
							 this->labelLastTimeSynced->Text="Scaled Time:";
							 break;

						 case 6:
							 this->labelLastTimeSynced->Text="Alarm Time:";
							 break;


						 }
					 this->labelLastTime->Text="-";
					 }

		private: System::Void buttonReadMemory_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 unsigned int done;
					 System::String^ response;
					 System::String^ outString;
					 bool            flag;

					 flag=this->buttonReadMemory->Enabled;
					 setBootButtons(false);

					 this->textBoxBoot->ScrollToCaret();
					 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Reading Memory: ");

					 if(SerialPortConnected)
						 {
						 done=SerBootReadProgramMemory(0, PROGRAM_ADDRESS_TOP, (unsigned char*)&ProgramMemory[0], this->progressBar1);
						 }
					 else
						 {
						 done=readProgramMemory(0, PROGRAM_ADDRESS_TOP, (unsigned char*)&ProgramMemory[0], this->progressBar1);
						 }

					 if(done>0)
						 {
						 this->textBoxBoot->AppendText(formatStringFloat((double)done, 0)+" B. Ok.\r\n");
						 this->textBoxBoot->ScrollToCaret();
						 outString="";
						 response=ExportMap_Click("", 0, done, (unsigned char*)&ProgramMemory[0]);
						 this->textBoxBoot->AppendText(response+"\r\n");						 
						 WriteFile("code.bin", 0, &ProgramMemory[0], done, &done);
						 }
					 else
						 {
						 this->textBoxBoot->ScrollToCaret();
						 this->textBoxBoot->AppendText("Error.\r\n");
						 }
					 setBootButtons(flag);
					 }

		private: System::Void restoreHostDefaultsToolStripMenuItem1_Click(System::Object^  sender, System::EventArgs^  e)
					 {
					 String^ message = "Are you Sure you would like To Restore The PC Host's Settings To Defaults?\r\nAll Settings Will Be Lost!";
					 String^ caption = "Warning: Restoring Default Settings";
					 MessageBoxButtons buttons = MessageBoxButtons::YesNo;
					 System::Windows::Forms::DialogResult result;
					 result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING );
					 if (result==::DialogResult::Yes)
						 {
						 if(restoreDefaultsLocalSettings(&localSettings, LOCAL_SETTINGS_FILENAME))
							 {
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Host Defaults Restored!\r\n");
							 timerCounter2=0;
							 timerCounter1=0;
							 forceUpdate=1;
							 this->labelLastTime->Text="-";
							 this->labelVDD->Text="-";
							 this->labelLastTime->BackColor=NORMAL_COLOUR;
							 this->labelVDD->BackColor=NORMAL_COLOUR;
							 }
						 }
					 }


		private: System::Void HostSaveSettings_Click(System::Object^  sender, System::EventArgs^  e)
					 {	

					 int ok;
					 System::String^ responseString;
					 System::String^ fileName;

					 responseString=getPCLocalTimeString()+"Save Host Settings";
					 fileName=getSaveFileName("", "Binary Files", "*.bin", &ok);
					 if(ok)
						 {
						 responseString+=" to File \""+fileName+"\": "+formatStringFloat((double)saveLocalSettings(&localSettings, fileName), 0)+" B.\r\n";
						 }
					 else
						 {
						 responseString+=": Cancelled.\r\n";  
						 }
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(responseString);


					 }

		private: System::Void HostRestoreSettings_Click(System::Object^  sender, System::EventArgs^  e) 
					 {

					 int ok;
					 System::String^ responseString;
					 System::String^ fileName;
					 int defaultsLoaded;
					 int done;

					 responseString=getPCLocalTimeString()+"Restore Host Settings";
					 fileName=getOpenFileName("", "Binary Files", "*.bin", &ok);
					 if(ok)
						 {
						 done=restoreLocalSettings(&localSettings, fileName, &defaultsLoaded);
						 responseString+=" from File \""+fileName+"\": ";
						 if(defaultsLoaded)
							 {
							 responseString+="CRC Error. Loading Defaults Instead.\r\n";	
							 }
						 else
							 {
							 responseString+=formatStringFloat((double)done, 0)+" B.\r\n";
							 }
						 timerCounter2=0;
						 timerCounter1=0;
						 forceUpdate=1;
						 this->labelLastTime->Text="-";
						 this->labelVDD->Text="-";
						 this->labelLastTime->BackColor=NORMAL_COLOUR;
						 this->labelVDD->BackColor=NORMAL_COLOUR;
						 updateLocalSettings(&localSettings);
						 }
					 else
						 {
						 responseString+=": Cancelled.\r\n";  
						 }
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(responseString);	
					 }

		private: System::Void treeViewPCFiles_NodeMouseDoubleClick(System::Object^  sender, System::Windows::Forms::TreeNodeMouseClickEventArgs^  e) 
					 {

					 System::Windows::Forms::TreeNode^ intree;
					 System::String^ path;
					 FRESULT fresult;

					 if(this->treeViewPCFiles->LabelEdit)
						 {

						 }
					 else
						 {
						 intree=e->Node;
						 this->treeViewPCFiles->SelectedNode=intree;
						 this->currentTreePCNodePath=intree->Name;
						 this->currentTreePCNode=intree;
						 if(intree->Text[0]==(wchar_t)'[')
						  {
						  path=intree->Name;
						  readAllPCDirectoryEntries(path, &fresult, intree, &currentTreePCDir);
							 }

						 if(e->Button==System::Windows::Forms::MouseButtons::Left)
							 {
							 internalPCGetMenuClickFunction(sender, e);
							 }
						 }
					 }

		private: System::Void reconnectToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 initVMEnvironment(&lastUDL.dataLogger.ven);
					 updateScripts(this->treeViewScripts, &lastUDL.dataLogger, "Device Scripts: ", 1);						 
					 cardInfo.cERROR=ERROR_CLOSED_CARD;
					 updateMemoryCardRoot(this->treeViewFiles);	
					 this->Refresh();
					 reconnectMemoryCard();
					 forceUpdate=1;
					 }

		private: System::Void treeViewFiles_NodeMouseDoubleClick(System::Object^  sender, System::Windows::Forms::TreeNodeMouseClickEventArgs^  e) {

					 System::Windows::Forms::TreeNode^ intree;
					 char path[MAX_PATH_LENGTH];
					 char fileName[MAX_PATH_LENGTH];
					 FRESULT fresult;

					 if(this->treeViewFiles->LabelEdit)
						 {

						 }
					 else
						 {

						 intree=e->Node;
						 this->treeViewFiles->SelectedNode=intree;
						 this->currentTreeNodePath=intree->Name;
						 this->currentTreeNode=intree;

						 if(intree->Text[0]==(wchar_t)'[')
							 {
							 if(intree->Name->Length<MAX_PATH_LENGTH)
								 {
								 getUnsignedCharPathFromString((unsigned char*)&path[0], (unsigned char*)&fileName[0], intree->Name, 1, MAX_PATH_LENGTH);
								 if(path[0]=='\0')
									 {
									 this->treeViewFiles->ShowPlusMinus=true;
									 readAllDirectoryEntries((char*)&path[0], &fresult, this->treeViewFiles->Nodes[0], &currentTreeDir);
									 }
								 else
									 {
									 this->treeViewFiles->ShowPlusMinus=true;
									 readAllDirectoryEntries((char*)&path[0], &fresult, intree, &currentTreeDir);
									 }
								 }
							 }


						 if(e->Button==System::Windows::Forms::MouseButtons::Left)
							 {
							 internalGetMenuClickFunction(sender, e, 1);

							 }
						 else
							 if(e->Button==System::Windows::Forms::MouseButtons::Right)
								 {

								 }
						 }
					 }

		private: System::Void showSystemLogToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 FRESULT			fresult;
					 int				getResult;
					 DATA_LOGGER		tempUDL;
					 System::String^ fileName;
					 System::String^ PCfileName;
					 ADDRESS_TYPE	done;

					 if(ConnectedUser())
						 {
						 getResult=flushLog();
						 getResult=getDataLogger(&tempUDL);
						 if(getResult)
							 {
							 fileName=getStringFromUnsignedCharArrayAuto(&tempUDL.ven.vmLogFileName[0]);
							 done=0;
							 PCfileName=fileName;
							 fresult=getFileFromDeviceToPC(PCfileName, fileName, &done, this->progressBar1);
							 if(fresult==FR_OK)
								 {
								 OpenAndShowFile(PCfileName);
								 this->textBoxLog->ScrollToCaret();
								 this->textBoxLog->AppendText(getPCLocalTimeString()+"Get File: \""+fileName+"\" from Device To PC File \""+PCfileName+"\": "+formatStringFileSize((double)done)+" Done!\r\n");
								 }
							 else
								 {
								 this->textBoxLog->ScrollToCaret();
								 this->textBoxLog->AppendText(getPCLocalTimeString()+"Get File: \""+fileName+"\": from Device To PC File \""+PCfileName+"\": Error!\r\n");
								 }

							 }
						 }
					 }

		private: System::Void newSystemLogToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 unsigned char*  tempString[LOG_FILE_NAME_SIZE];
					 System::String^ fileName;
					 System::String^ ofileName;
					 int			 result;
					 unsigned char*  oldTempString[LOG_FILE_NAME_SIZE];


					 fileName="sys"+getTimeFileString()+".txt";
					 getUnsignedCharArrayFromString((unsigned char*)tempString, fileName);

					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"New System Log File: \""+fileName+"\": ");

					 result=changeSystemLogName(1, (unsigned char*)tempString, (unsigned char*)oldTempString); 
					 if(result)
						 {
						 ofileName=getStringFromUnsignedCharArrayAuto((unsigned char*)oldTempString);
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText("Ok.\r\n");
						 if(ofileName!=fileName)
							 {
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Old System Log File: \""+ofileName+"\". (Still Available)\r\n");
							 }								
						 }
					 else
						 {
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText("Error.\r\n");
						 }

					 }

		private: System::Void fontSizeUpToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 if(localSettings.fontSize<24)localSettings.fontSize+=(float)1;
					 updateLocalSettings(&localSettings);
					 }

		private: System::Void fontSizeDownToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 if(localSettings.fontSize>9)localSettings.fontSize-=(float)1;
					 updateLocalSettings(&localSettings);		
					 }

		private: System::Void checkBoxOptimize_CheckedChanged(System::Object^  sender, System::EventArgs^  e) 
					 {
					 if(this->checkBoxOptimize->Checked)localSettings.optimizeCode=1; else localSettings.optimizeCode=0;
					 }

		private: System::Void numericUpDownTimeSpeed_ValueChanged(System::Object^  sender, System::EventArgs^  e) 
					 {
					 TIME_T	now;
					 localSettings.timeSpeed=(float)this->numericUpDownTimeSpeed->Value;
					 localSettings.effectiveSpeed=(float)this->numericUpDownTimeSpeed->Value;
					 getTime(&now);
					 localSettings.timeOffset=getTotalSeconds(&now);
					 alarmEvent&=~ALARM_SET_EVENT;
					 alarmEvent|=ALARM_TRIGGER_EVENT;
					 }

		private: System::Void simulateSpeedResetToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 TIME_T		now;
					 localSettings.timeSpeed=1.0;
					 localSettings.effectiveSpeed=localSettings.timeSpeed;
					 getTime(&now);
					 localSettings.timeOffset=getTotalSeconds(&now);
					 this->numericUpDownTimeSpeed->Value=(System::Decimal)localSettings.timeSpeed;
					 alarmEvent&=~ALARM_SET_EVENT;
					 alarmEvent|=ALARM_TRIGGER_EVENT;
					 }

		private: System::Void checkBoxSpeed_CheckedChanged(System::Object^  sender, System::EventArgs^  e) 
					 {
					 TIME_T		now;
					 if(this->checkBoxSpeed->Checked)localSettings.timeScaling=1;
					 else localSettings.timeScaling=0;
					 getTime(&now);
					 localSettings.timeOffset=getTotalSeconds(&now);
					 alarmEvent&=~ALARM_SET_EVENT;
					 alarmEvent|=ALARM_TRIGGER_EVENT;
					 }

		private: System::Void checkBoxSystemLogUSB_CheckedChanged(System::Object^  sender, System::EventArgs^  e)
					 {
					 DATA_LOGGER tempUDL;
					 int getResult;

					 getResult=getDataLogger(&tempUDL);
					 if(this->checkBoxSystemLogUSB->Checked)
						 {
						 tempUDL.modes|=SYSTEM_LOGGING_TO_SERIAL_USB;
						 this->checkBoxSystemLogUSB->CheckState=System::Windows::Forms::CheckState::Checked;
						 }
					 else
						 {
						 tempUDL.modes&=~SYSTEM_LOGGING_TO_SERIAL_USB;
						 this->checkBoxSystemLogUSB->CheckState=System::Windows::Forms::CheckState::Unchecked;
						 }
					 if(getResult)putDataLogger(&tempUDL);
					 }

		private: System::String^ printBadRange(int start, int end)
					 {
					 System::String^ str;
					 if(start==end)
						 str="0x"+HexToString(start, 4)+".\r\n";
					 else 
						 str="0x"+HexToString(start, 4)+" To 0x"+HexToString(end, 4)+".\r\n";
					 return str;
					 }

		private: int compareMemory(unsigned char* firstPtr, unsigned char* secondPtr, int size)
					 {
					 int i;
					 int ok;

					 i=0;
					 ok=1;
					 while((i<size))
						 {

						 if((*firstPtr)!=(*secondPtr))
							 {
							 ok=0;
							 }
						 i++;
						 firstPtr++;
						 secondPtr++;
						 }
					 return ok;
					 }

		private: System::String^ showMemoryDifferences(System::String^ instring, unsigned char* firstPtr, unsigned char* secondPtr, int offset, int size, int* total, System::Windows::Forms::TextBox^ intextbox, bool returnString)
					 {
					 int inBad;
					 int oldBad;
					 int startBad;
					 int endBad;
					 System::String^ diffString;
					 int i;

					 diffString="";											
					 inBad=0;
					 oldBad=0;
					 startBad=0;
					 endBad=0;
					 i=0;
					 *total=0;
					 while(i<size)
						 {
						 if(!(i & 0x0FFF))Application::DoEvents();

						 if((*firstPtr)!=(*secondPtr))
							 {
							 inBad=1;
							 (*total)++;
							 }
						 else
							 {
							 inBad=0;
							 }

						 if(inBad!=oldBad)
							 {
							 if(inBad)
								 {
								 startBad=i+offset;									
								 }
							 else
								 {
								 endBad=i+offset-1;
								 if(returnString)diffString+=(getPCLocalTimeString()+instring+printBadRange(startBad, endBad));									
								 if(intextbox!=nullptr)
							   {
							   intextbox->ScrollToCaret();
							   intextbox->AppendText(diffString);
							   diffString="";
							   }
								 }
							 oldBad=inBad;
							 }
						 i++;
						 firstPtr++;
						 secondPtr++;
						 }
					 inBad=0;
					 if(inBad!=oldBad)
						 {
						 if(inBad)
							 {
							 startBad=i+offset;									
							 }
						 else
							 {
							 endBad=i+offset-1;
							 diffString+=(getPCLocalTimeString()+instring+printBadRange(startBad, endBad));									
							 }
						 oldBad=inBad;
						 }
					 return diffString;
					 }

		private: System::Void buttonEraseMemory_Click(System::Object^  sender, System::EventArgs^  e)
					 {
					 unsigned long	 done;
					 int			 ok;
					 System::String^ responseString;
					 int			 total;
					 bool            flag;

					 flag=this->buttonReadMemory->Enabled;
					 setBootButtons(false);

#if 0
					 // use this to test the "envelope" of the bootloader is Ok. 
					 done=eraseProgramMemory(0x400, BOOTLOADER_ADDRESS);
					 if(done>0)
						 {
						 this->textBoxBoot->ScrollToCaret();
						 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Erased Program Memory: 0x"+HexToString(done, 4)+" B.\r\n");						 
						 }

					 if(done=SerBootEraseProgramMemory(0x1000, 0x1400))
						 {
						 this->textBoxBoot->ScrollToCaret();
						 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Erased Memory: "+formatStringFloat((double)done, 0));
						 }
					 return;

#endif

					 this->textBoxBoot->ScrollToCaret();
					 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Verifying Memory Against Hex File... ");
					 responseString=OpenHexFile(sender, e, &ok); 
					 this->textBoxBoot->ScrollToCaret();
					 this->textBoxBoot->AppendText(responseString+"\r\n");
					 if(ok)
						 {
						 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Verifying...\r\n");

						 if(SerialPortConnected)
							 {
							 done=SerBootReadProgramMemory(0, PROGRAM_ADDRESS_TOP, &ProgramMemoryVerify[0], this->progressBar1);
							 }
							else
								{
								done=readProgramMemory(0, PROGRAM_ADDRESS_TOP, &ProgramMemoryVerify[0], this->progressBar1);
							 }

						 if(done==PROGRAM_ADDRESS_TOP)
							 {
							 writeMapFile("inputhex.txt", 0, MAX_PROGRAM_MEMORY, &ProgramMemory[0]);
							 writeMapFile("readhex.txt", 0,  MAX_PROGRAM_MEMORY, &ProgramMemoryVerify[0]);

							 ok=compareMemory(&ProgramMemory[0], &ProgramMemoryVerify[0], MAX_PROGRAM_MEMORY);
								if(ok)
									{
									this->textBoxBoot->ScrollToCaret();
									this->textBoxBoot->AppendText(getPCLocalTimeString()+"Verify All Ok.\r\n");
									}
								else
									{
									(void)showMemoryDifferences("Verify Error(s): ", &ProgramMemory[0], &ProgramMemoryVerify[0], 0, MAX_PROGRAM_MEMORY, &total, nullptr, false);
									this->textBoxBoot->ScrollToCaret();
									this->textBoxBoot->AppendText(getPCLocalTimeString()+"Verify Error(s): "+formatStringFloat(((double)100.0*(double)total)/(double)MAX_PROGRAM_MEMORY, 1)+" %\r\n");
									(void)writeMapDifferencesFile("diff.txt", " Verify Error(s): Rows With Differences Are Shown Interleaved\r\n\r\n First  Row: Imported Hex File\r\n Second Row: Memory Read From Device\r\n\r\n", 0, MAX_PROGRAM_MEMORY, &ProgramMemory[0], &ProgramMemoryVerify[0]);
									OpenAndShowFile("diff.txt");
									}
							 }
							else
								{
								this->textBoxBoot->ScrollToCaret();
								this->textBoxBoot->AppendText(getPCLocalTimeString()+"Read Error.\r\n");
							 }
						 }

					 setBootButtons(flag);
					 }


		private: System::Void internalWriteProgramMemory(int askForConfirmation)
					 {
					 int				ok;
					 unsigned long	done;
					 int				total;
					 TIME_T			tempTime;
					 int				timeout;
					 int				t;
					 int				oldsecs;
					 int				i;
					 int				val;

					 if(SerialPortConnected)
						 {
						 /* Read the Extant USB Bootloader code */
						 writeMapFile("serialhex.txt", 0, PROGRAM_ADDRESS_TOP, &ProgramMemory[0]);

						 this->textBoxBoot->ScrollToCaret();
						 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Upgrading the USB BootLoader & Firmware...\r\n");

						 this->textBoxBoot->ScrollToCaret();
						 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Reading Extant USB BootLoader Code: ");

						 done=SerBootReadProgramMemory(BOOTLOADER_ADDRESS, PROGRAM_ADDRESS_TOP, &ProgramMemoryVerify[BOOTLOADER_ADDRESS], this->progressBar1);
						 this->textBoxBoot->AppendText(formatStringFloat((double)done, 0)+" B.\r\n");

						 if(done==(PROGRAM_ADDRESS_TOP-BOOTLOADER_ADDRESS))
							 {

							 if(compareMemory((unsigned char*)&ProgramMemoryVerify[BOOTLOADER_ADDRESS], (unsigned char*)&ProgramMemory[BOOTLOADER_ADDRESS], BOOTLOADER_SIZE_BYTES_CHECK))
								 {
								 this->textBoxBoot->ScrollToCaret();
								 this->textBoxBoot->AppendText(getPCLocalTimeString()+"USB BootLoader Image is Up to Date...\r\n");
								 this->textBoxBoot->ScrollToCaret();
								 this->textBoxBoot->AppendText(getPCLocalTimeString()+"No Update is Required (If you Wish to Update the Firmware, Use the USB BootLoader Instead).\r\n");
								 }
							 else
								 {

								 System::Windows::Forms::DialogResult result;
								 if(askForConfirmation)
									 {
									 String^ message = "Ensure That The USB Data Logger is Properly Powered During The USB BootLoader & Firmware Update. Switch S1 to its UP position to use USB power.\r\nWould you like to Proceed the With Update?\r\n(All Settings May Be Lost, Depending On Version Compatibilities)\r\n";
									 String^ caption = "Warning: Confirm USB BootLoader & Firmware Update";
									 MessageBoxButtons buttons = MessageBoxButtons::YesNo;
									 result=MessageBox::Show(this, message, caption, buttons, MSGBOX_ICON_WARNING );
									 }

								 if((!askForConfirmation)||(result==::DialogResult::Yes))
									 {
									 /* 
									 Begin the USB Bootloader & Firmware Update... 

									 First redirect the startup vector to the serial bootloader code ...

									 0xEF and 0xF0 are the goto codes... The address is divided by 2...

									 */

									 memcpy((void*)&ProgramMemoryVerify[0], (void*)&ProgramMemory[0], PROGRAM_ADDRESS_TOP);
									 ProgramMemoryVerify[0]=0xEF;
									 ProgramMemoryVerify[1]=(unsigned char)(0xFF & (SERIAL_BOOTLOADER_ADDRESS>>1));
									 ProgramMemoryVerify[2]=0xF0;
									 ProgramMemoryVerify[3]=(unsigned char)(0xFF & (SERIAL_BOOTLOADER_ADDRESS>>9));

									 /* Erase the first page */

									 this->textBoxBoot->ScrollToCaret();
									 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Redirecting Startup Vector: ");
									 done=SerBootEraseProgramMemory(0, 0x400);
									 done=SerBootWriteProgramMemory(0, 0x400, (unsigned char*)&ProgramMemoryVerify[0], this->progressBar1);
									 if(done==0x400)
										 {
										 this->textBoxBoot->ScrollToCaret();
										 this->textBoxBoot->AppendText("Ok.\r\n");

										 this->textBoxBoot->ScrollToCaret();
										 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Updating USB BootLoader Image...\r\n");

										 done=SerBootEraseProgramMemory(BOOTLOADER_ADDRESS, PROGRAM_ADDRESS_TOP);
										 this->textBoxBoot->ScrollToCaret();
										 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Erasing USB BootLoader: "+formatStringFloat((double)done, 0)+" B.\r\n");
										 if(done)
											 {
											 done=SerBootWriteProgramMemory(BOOTLOADER_ADDRESS, PROGRAM_ADDRESS_TOP, &ProgramMemory[BOOTLOADER_ADDRESS], this->progressBar1);
											 }
										 this->textBoxBoot->ScrollToCaret();
										 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Write USB BootLoader: "+formatStringFloat((double)done, 0)+" B.\r\n");

										 if(done)
											 {
											 /* 
											 The New USB BootLoader image has been written, now we must update the startup vector and jump to the new
											 USB Bootloader to update the rest of the image... */

											 this->textBoxBoot->ScrollToCaret();
											 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Redirecting Startup Vector: ");
											 done=SerBootEraseProgramMemory(0, 0x400);
											 done=SerBootWriteProgramMemory(0, 0x400, (unsigned char*)&ProgramMemory[0], this->progressBar1);
												if(done)
													{
													this->textBoxBoot->ScrollToCaret();
													this->textBoxBoot->AppendText("Ok.\r\n");

													this->textBoxBoot->ScrollToCaret();
													this->textBoxBoot->AppendText(getPCLocalTimeString()+"Entering the USB BootLoader: ");
													done=SerBootReset();

													if(done)
														{
														stopTimer1();
														this->textBoxBoot->ScrollToCaret();
														this->textBoxBoot->AppendText("Ok.\r\n");
														DisconnectSerialPort();

														/* timeout is in seconds */

														getTime(&tempTime);
														timeout=((tempTime.secs+10)%60);
														oldsecs=tempTime.secs;
														startTimer1();
														i=0;
														this->labelUSBTraffic->Text="SYNC:";
														this->labelUSB->Text=formatStringFloat((double)i, 0);
														this->labelUSB->ForeColor=NEUTRAL_COLOUR;
														while((!Connection_Status)&&(tempTime.secs!=timeout))
															{
															Application::DoEvents();
															getTime(&tempTime);							
															if(oldsecs!=tempTime.secs)
																{
																i++;
																this->labelUSB->Text=formatStringFloat((double)i, 0);
																oldsecs=tempTime.secs;
																}
															}

														if(Connection_Status)
															{
															this->labelUSB->Text="OK";
															this->labelUSB->ForeColor=OK_DARK_COLOUR;
															this->textBoxBoot->ScrollToCaret();
															this->textBoxBoot->AppendText(getPCLocalTimeString()+"Connected!\r\n");

															this->textBoxBoot->ScrollToCaret();
															this->textBoxBoot->AppendText(getPCLocalTimeString()+"Please Wait...\r\n");

															getTime(&tempTime);
															/* number of seconds to wait = t */
															t=5;
															timeout=((tempTime.secs+t)%60);
															oldsecs=tempTime.secs;
															i=0;
															val=this->progressBar1->Minimum;
															this->progressBar1->Value=val;
															this->labelUSBTraffic->Text="SYNC:";
															this->labelUSB->Text=formatStringFloat((double)i, 0);
															this->labelUSB->ForeColor=NEUTRAL_COLOUR;
															while(tempTime.secs!=timeout)
																{
																getTime(&tempTime);							
																if(oldsecs!=tempTime.secs)
																	{
																	i++;
																	this->labelUSB->Text=formatStringFloat((double)i, 0);
																	val+=((this->progressBar1->Maximum-this->progressBar1->Minimum)/(t-1));
																	if((val>=this->progressBar1->Minimum)&&(val<=this->progressBar1->Maximum))this->progressBar1->Value=val;
																	Application::DoEvents();
																	oldsecs=tempTime.secs;
																	}
																}
															this->progressBar1->Value=this->progressBar1->Maximum;	
															Application::DoEvents();						
															/* Recursively Update the user code space! */
															if(Connection_Status)
																{
																this->labelUSB->Text="OK";
																this->labelUSB->ForeColor=OK_DARK_COLOUR;	
																internalWriteProgramMemory(0);
																}
															else
																{
																this->textBoxBoot->ScrollToCaret();
																this->textBoxBoot->AppendText(getPCLocalTimeString()+"Fatal Error.\r\n");
																this->labelUSB->Text="BAD";
																this->labelUSB->ForeColor=BAD_DARK_COLOUR;	
																}
															/* We've now updated the USB bootloader AND the firmware! */
															}
														else
															{
															this->labelUSB->Text="BAD";
															this->labelUSB->ForeColor=BAD_DARK_COLOUR;
															this->textBoxBoot->ScrollToCaret();
															this->textBoxBoot->AppendText(getPCLocalTimeString()+"Failed To Connect...\r\n");
															}
														}
													else
														{
														this->textBoxBoot->ScrollToCaret();
														this->textBoxBoot->AppendText("Error.\r\n");
														}
													}
												else
													{
													this->textBoxBoot->ScrollToCaret();
													this->textBoxBoot->AppendText("Error.\r\n");
													}
											 }
										 else
											 {
											 this->textBoxBoot->ScrollToCaret();
											 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Fatal Error!\r\n");
											 }
										 }
									 else
										 {
										 this->textBoxBoot->ScrollToCaret();
										 this->textBoxBoot->AppendText("Error.\r\n");
										 }
									 }
								 else
									 {
									 this->textBoxBoot->ScrollToCaret();
									 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Cancelled.\r\n");
									 }
								 }	
							 }
							else
								{
								this->textBoxBoot->ScrollToCaret();
								this->textBoxBoot->AppendText(getPCLocalTimeString()+"Read Error. Aborting!\r\n");

							 }
						 WriteFileFromString("log_serial_bootloader.txt", this->textBoxBoot->Text);

						 }
						else
							{
							writeMapFile("usbhex.txt", 0, PROGRAM_ADDRESS_TOP, &ProgramMemory[0]);

							this->textBoxBoot->ScrollToCaret();
							this->textBoxBoot->AppendText(getPCLocalTimeString()+"Checking Image...");

							done=readProgramMemory(BOOTLOADER_ADDRESS, BOOTLOADER_SIZE_BYTES, &BootLoaderMemory[0], nullptr);
							this->textBoxBoot->ScrollToCaret	();
							this->textBoxBoot->AppendText(" Read Image: "+formatStringFloat((double)done, 0)+" B.\r\n");
							if(done)
								{
								ok=compareMemory(&BootLoaderMemory[0], &ProgramMemory[BOOTLOADER_ADDRESS], BOOTLOADER_SIZE_BYTES_CHECK);
								if(ok)
									{
									this->textBoxBoot->ScrollToCaret();
									this->textBoxBoot->AppendText(getPCLocalTimeString()+"Image Good!\r\n");

									this->textBoxBoot->ScrollToCaret();
									this->textBoxBoot->AppendText(getPCLocalTimeString()+"Begin Programming...\r\n");

									System::Windows::Forms::DialogResult result;
									if(askForConfirmation)
										{
										String^ message = "Ensure That The USB Data Logger is Properly Powered During The Firmware Update. Switch S1 to its UP position to use USB power.\r\nWould you like to Proceed With the Update?\r\n(All Settings May Be Lost, Depending On Version Compatibilities)\r\n";
										String^ caption = "Warning: Confirm Firmware Update";
										MessageBoxButtons buttons = MessageBoxButtons::YesNo;
										result = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING );
										}

									if((!askForConfirmation)||(result==::DialogResult::Yes))
										{

										done=eraseProgramMemory(FIRST_PAGE_PROGRAM_ADDRESS, REST_PAGE_PROGRAM_ADDRESS);
										if(done>0)
											{
											this->textBoxBoot->ScrollToCaret();
											this->textBoxBoot->AppendText(getPCLocalTimeString()+"Erased: "+formatStringFloat((double)done, 0)+" B.\r\n");
											this->textBoxBoot->ScrollToCaret();
											this->textBoxBoot->AppendText(getPCLocalTimeString()+"Writing Vectors: ");
											done=writeProgramMemory(FIRST_PAGE_PROGRAM_ADDRESS, REST_PAGE_PROGRAM_ADDRESS-FIRST_PAGE_PROGRAM_ADDRESS, &ProgramMemory[0], nullptr);
											if(done>0)
												{
												this->textBoxBoot->ScrollToCaret();
												this->textBoxBoot->AppendText(formatStringFloat((double)done, 0)+" B Ok.\r\n");
												this->textBoxBoot->ScrollToCaret();
												this->textBoxBoot->AppendText(getPCLocalTimeString()+"Erasing Memory, Please Wait...\r\n");
												this->progressBar1->Value=0;
												done=eraseProgramMemory(REST_PAGE_PROGRAM_ADDRESS, BOOTLOADER_ADDRESS);
												if((done>0)&&(done==(BOOTLOADER_ADDRESS-REST_PAGE_PROGRAM_ADDRESS)))
													{
													this->textBoxBoot->ScrollToCaret();
													this->textBoxBoot->AppendText(getPCLocalTimeString()+"Erased: "+formatStringFloat((double)done, 0)+" B.\r\n");
													this->textBoxBoot->ScrollToCaret();
													this->textBoxBoot->AppendText(getPCLocalTimeString()+"Writing Program Code: ");
													done=writeProgramMemory(REST_PAGE_PROGRAM_ADDRESS, BOOTLOADER_ADDRESS-REST_PAGE_PROGRAM_ADDRESS, &ProgramMemory[REST_PAGE_PROGRAM_ADDRESS], this->progressBar1);
													if(done==(BOOTLOADER_ADDRESS-REST_PAGE_PROGRAM_ADDRESS))
														{
														this->textBoxBoot->ScrollToCaret();
														this->textBoxBoot->AppendText(formatStringFloat((double)done, 0)+" B Ok.\r\n");
														this->textBoxBoot->ScrollToCaret();
														this->textBoxBoot->AppendText(getPCLocalTimeString()+"Verifying...\r\n");
														done=readProgramMemory(0, PROGRAM_ADDRESS_TOP, &ProgramMemoryVerify[0], this->progressBar1);
														if(done==PROGRAM_ADDRESS_TOP)
															{
															ok=compareMemory(&ProgramMemory[0], &ProgramMemoryVerify[0], MAX_PROGRAM_MEMORY);
															if(ok)
																{
																this->textBoxBoot->ScrollToCaret();
																this->textBoxBoot->AppendText(getPCLocalTimeString()+"Verify All Ok.\r\n");
																this->textBoxBoot->ScrollToCaret();
																this->textBoxBoot->AppendText(getPCLocalTimeString()+"Resetting: ");
																if(resetBootDevice()==1)
																	{
																	this->textBoxBoot->ScrollToCaret();
																	this->textBoxBoot->AppendText("Ok.\r\n");
																	disConnect();
																	}
																else
																	{
																	this->textBoxBoot->ScrollToCaret();
																	this->textBoxBoot->AppendText("Error.\r\n");
																	}

																}
															else
																{
																showMemoryDifferences("Verify Error(s): ", &ProgramMemory[0], &ProgramMemoryVerify[0], 0, MAX_PROGRAM_MEMORY, &total, nullptr, false);
																this->textBoxBoot->ScrollToCaret();
																this->textBoxBoot->AppendText(getPCLocalTimeString()+"Verify Error(s): "+formatStringFloat(((double)100.0*(double)total)/(double)MAX_PROGRAM_MEMORY, 1)+" %\r\n");

																}
															}
														else
															{
															this->textBoxBoot->ScrollToCaret();
															this->textBoxBoot->AppendText("Read Error.\r\n");

															}

														}
													else
														{
														this->textBoxBoot->ScrollToCaret();
														this->textBoxBoot->AppendText("Write Error.\r\n");	 
														}
													}
												else
													{
													this->textBoxBoot->ScrollToCaret();
													this->textBoxBoot->AppendText("Erase Error.\r\n");
													}
												}
											else
												{
												this->textBoxBoot->ScrollToCaret();
												this->textBoxBoot->AppendText("Write Error.\r\n");
												}							 
											}
										else
											{	 
											this->textBoxBoot->ScrollToCaret();
											this->textBoxBoot->AppendText("Erase Error.\r\n");
											}
										}
									else
										{
										this->textBoxBoot->ScrollToCaret();
										this->textBoxBoot->AppendText(getPCLocalTimeString()+"Cancelled.\r\n");							
										}
									}
								else
									{
									showMemoryDifferences("Image Bad: ", &BootLoaderMemory[0], &ProgramMemory[BOOTLOADER_ADDRESS], BOOTLOADER_ADDRESS, BOOTLOADER_SIZE_BYTES_CHECK, &total, nullptr, false);
									this->textBoxBoot->ScrollToCaret();
									this->textBoxBoot->AppendText(getPCLocalTimeString()+"Image Bad: "+formatStringFloat(((double)100.0*(double)total)/(double)BOOTLOADER_SIZE_BYTES_CHECK, 1)+" %\r\n");
									this->textBoxBoot->ScrollToCaret();
									this->textBoxBoot->AppendText(getPCLocalTimeString()+"Try Using the Serial BootLoader Instead...\r\n");							
									}
								}
							else
								{
								this->textBoxBoot->ScrollToCaret();
								this->textBoxBoot->AppendText(getPCLocalTimeString()+"Read Error.\r\n");							
								}
							WriteFileFromString("log_usb_bootloader.txt", this->textBoxBoot->Text);
							}
					 }

		private: System::Void toolStripMenuItem1_Click(System::Object^  sender, System::EventArgs^  e) 
					 {

					 }

		private: System::Void sendAllScriptsToDeviceToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 SendAllPCScriptsToDevice_Click(sender, e);
					 }

		private: System::Void buttonWriteMemory_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 System::String^ responseString;
					 int				ok;
					 bool            flag;

					 flag=this->buttonReadMemory->Enabled;
					 setBootButtons(false);

					 this->textBoxBoot->ScrollToCaret();
					 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Writing Memory From Hex File: ");
					 responseString=OpenHexFile(sender, e, &ok); 
					 this->textBoxBoot->ScrollToCaret();
					 this->textBoxBoot->AppendText(responseString+"\r\n");
					 if(ok)
						 {
						 internalWriteProgramMemory(1);
						 }
					 setBootButtons(flag);
					 }

		private: System::Void buttonWriteBin_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 System::String^ responseString;
					 int				ok;
					 bool            flag;

					 flag=this->buttonReadMemory->Enabled;
					 setBootButtons(false);

					 this->textBoxBoot->ScrollToCaret();
					 this->textBoxBoot->AppendText(getPCLocalTimeString()+"Writing Memory From Binary File: ");
					 responseString=OpenBinaryFile("", &ok); 
					 this->textBoxBoot->ScrollToCaret();
					 this->textBoxBoot->AppendText(responseString+"\r\n");
					 if(ok)
						 {
						 internalWriteProgramMemory(1);
						 }
					 setBootButtons(flag);
					 }

		private: System::Void buttonClearBootLog_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 this->textBoxBoot->Clear();
					 }

		private: System::Void buttonCancel_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 globalCancel=1;
					 if(this->buttonCancel->BackColor==OK_COLOUR)this->buttonCancel->BackColor=BAD_COLOUR;
					 else this->buttonCancel->BackColor=NORMAL_COLOUR;
					 }

		private: System::Void treeViewHelp_NodeMouseDoubleClick(System::Object^  sender, System::Windows::Forms::TreeNodeMouseClickEventArgs^  e) 
					 {
					 System::Windows::Forms::TreeNode^ intree;					
					 intree=e->Node;
					 this->treeViewHelp->SelectedNode=intree;
					 if(intree->Text[0]==(wchar_t)'[')
						 {

						 }
					 else
						 {
						 if(e->Button==System::Windows::Forms::MouseButtons::Left)
							 {
							 this->textBoxInput1->Paste(intree->Name);				 
							 }			
						 }
					 }

		private: System::Void upgradeBootLoaderToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 if(SerialPortConnected)
						 {

						 }
					 else
						 {
						 scanForSerialPorts();		
						 }		 	
					 }

		private: System::Void USBBootLoaderMenu_Click(System::Object^  sender, System::EventArgs^  e)
					 {
					 if(Connection_Status)
						 {
						 enterSerialOrUSBBootLoader(CMD_ENTER_USB_BOOTLOADER);
						 }  
					 }

		private: System::Void treeViewHelp_NodeMouseClick(System::Object^  sender, System::Windows::Forms::TreeNodeMouseClickEventArgs^  e) 
					 {
					 System::Windows::Forms::TreeNode^ intree;					

					 intree=e->Node;
					 this->treeViewHelp->SelectedNode=intree;
					 this->toolTip1->Active=false;

					 if(intree->Text[0]==(wchar_t)'[')
						 {
						 this->toolTip1->Active=false;
						 }
					 else
						 {
						 if(e->Button==System::Windows::Forms::MouseButtons::Left)
							 {

							 }
						 else
							 {
							 if(this->toolTip1->Active)
								 {
								 this->toolTip1->Active=false;
								 }
							 else
								 {
								 System::Int32 x;
								 x=(System::Int32)intree->Tag;
								 this->toolTip1->SetToolTip(this->treeViewHelp, getHelpText(x, 1, 32));	

								 this->toolTip1->Active=true;
								 }
							 }			
						 }
					 }

		private: System::Void treeViewHelp_MouseEnter(System::Object^  sender, System::EventArgs^  e)
					 {
					 inHelpWindow=1;
					 }

		private: System::Void treeViewHelp_MouseLeave(System::Object^  sender, System::EventArgs^  e) 
					 {
					 this->labelHelp->Text="Help";
					 inHelpWindow=0;
					 }

		private: System::Void treeViewHelp_AfterSelect(System::Object^  sender, System::Windows::Forms::TreeViewEventArgs^  e) 
					 {
					 this->toolTip1->Active=false;
					 }

		private: System::Void checkBoxVerbose_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 if(this->checkBoxVerbose->Checked)
						 {
						 localSettings.verboseMode=1;
						 }
					 else
						 {
						 localSettings.verboseMode=0;
						 }	
					 }

		private: System::Void resetSystemLogToDefaultToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
					 {
					 unsigned char*  tempString[LOG_FILE_NAME_SIZE];
					 System::String^ fileName;
					 System::String^ ofileName;
					 int			 result;
					 unsigned char*  oldTempString[LOG_FILE_NAME_SIZE];

					 fileName="syslog.txt";
					 getUnsignedCharArrayFromString((unsigned char*)tempString, fileName);

					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Default System Log File: \""+fileName+"\": ");

					 result=changeSystemLogName(1, (unsigned char*)tempString, (unsigned char*)oldTempString); 
					 if(result)
						 {
						 ofileName=getStringFromUnsignedCharArrayAuto((unsigned char*)oldTempString);
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText("Ok.\r\n");
						 if(ofileName!=fileName)
							 {
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText(getPCLocalTimeString()+"Old System Log File: \""+ofileName+"\". (Still Available)\r\n");
							 }
						 }
					 else
						 {
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText("Error.\r\n");
						 }

					 }

		private: System::Void currentSystemLogFileNameToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
					 {

					 }

		private: System::Void changeSystemLogNameToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
					 {

					 }

		private: System::Void currentSystemLogFileNameToolStripMenuItem_DropDownOpened(System::Object^  sender, System::EventArgs^  e) 
					 {
					 System::String^ ofileName;
					 int			 result;
					 unsigned char*  oldTempString[LOG_FILE_NAME_SIZE];

					 ofileName="Unavailable";
					 result=changeSystemLogName(0, (unsigned char*)oldTempString, (unsigned char*)oldTempString); 
					 if(result)
						 {
						 ofileName=getStringFromUnsignedCharArrayAuto((unsigned char*)oldTempString);
						 }
					 this->toolStripTextBox1->Text=ofileName;
					 }

		private: System::Void toolStripTextBox1_KeyPress(System::Object^  sender, System::Windows::Forms::KeyPressEventArgs^  e) 
					 {
					 unsigned char*  tempString[LOG_FILE_NAME_SIZE];
					 System::String^ fileName;
					 System::String^ ofileName;
					 int			 result;
					 unsigned char*  oldTempString[LOG_FILE_NAME_SIZE];

					 if(e->KeyChar==13)
						 {
						 fileName=getFileNameRoot(this->toolStripTextBox1->Text);
						 if(fileName->Length>(LOG_FILE_NAME_SIZE-5))fileName=fileName->Substring(0, LOG_FILE_NAME_SIZE-5);
						 fileName+=".txt";					 
						 String^ message = "Are you sure you would like to change the name of the System Log to \""+fileName+"\" ?";
						 String^ caption = "Warning: Changing the System Log File Name";
						 MessageBoxButtons buttons = MessageBoxButtons::YesNo;
						 System::Windows::Forms::DialogResult bresult;
						 bresult = MessageBox::Show( this, message, caption, buttons, MSGBOX_ICON_WARNING);
						 this->textBoxLog->ScrollToCaret();
						 this->textBoxLog->AppendText(getPCLocalTimeString()+"New System Log File: \""+fileName+"\": ");
						 stopTimer1();
						 if (bresult==::DialogResult::Yes)
							 {
							 getUnsignedCharArrayFromString((unsigned char*)tempString, fileName);
							 result=changeSystemLogName(1, (unsigned char*)tempString, (unsigned char*)oldTempString); 
							 if(result)
								 {
								 ofileName=getStringFromUnsignedCharArrayAuto((unsigned char*)oldTempString);
								 this->textBoxLog->ScrollToCaret();
								 this->textBoxLog->AppendText("Ok.\r\n");
								 if(ofileName!=fileName)
									 {
									 this->textBoxLog->ScrollToCaret();
									 this->textBoxLog->AppendText(getPCLocalTimeString()+"Old System Log File: \""+ofileName+"\". (Still Available)\r\n");
									 }								
								 }
							 else
								 {
								 this->textBoxLog->ScrollToCaret();
								 this->textBoxLog->AppendText("Error.\r\n");
								 }
							 }
						 else
							 {
							 this->textBoxLog->ScrollToCaret();
							 this->textBoxLog->AppendText("Cancelled.\r\n");
							 }
						 startTimer1();	
						 }

					 }

		private: System::Void clearLogToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
					 {
					 System::String^ fileName;
					 fileName="lsys"+getTimeFileString()+".txt";
					 this->textBoxLog->ScrollToCaret();
					 this->textBoxLog->AppendText(getPCLocalTimeString()+"Saving this Log to Local File: \""+fileName+"\".\r\n");
					 WriteFileFromString(fileName, this->textBoxLog->Text);			
					 }

		private: System::Void checkBox1_CheckedChanged(System::Object^  sender, System::EventArgs^  e)
					 {
					 if(this->checkBoxPersistentLog->Checked)
						 {
						 localSettings.persistentLog=1;
						 }
					 else
						 {
						 localSettings.persistentLog=0;
						 }
					 }

		private: System::Void wideEditorWindowToggleMenu_Click(System::Object^  sender, System::EventArgs^  e) 
					 {			
					 localSettings.wideEditorWindow=!localSettings.wideEditorWindow;
					 setWideEditorWindow(localSettings.wideEditorWindow);
					 }

		private: System::Void checkBoxConfirmAllDelete_CheckedChanged(System::Object^  sender, System::EventArgs^  e)
					 {
					 if(this->checkBoxConfirmAllDelete->Checked)
						 {
						 localSettings.checkDeletes=1;
						 }
					 else
						 {
						 localSettings.checkDeletes=0;
						 }
					 }

		private: System::Void helpToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) 
					 {
					 System::String^ res;

					 if(System::IO::File::Exists(HELP_FILE_NAME))
						 {
						 OpenAndShowFile(HELP_FILE_NAME);
						 }
					 else
						 {
						 res=generateHelpFile(HELP_TXT_FILE_NAME);
						 OpenAndShowFile(HELP_TXT_FILE_NAME);
						 }
					 }

		};

	}

//-------------------------------------------------------BEGIN CUT AND PASTE BLOCK-------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------
/* The below portion of the code is used link dynamically to the libusb0.dll. The run time linking
is done only to the functions which are used by the demo. If the user wants to use all the
functinalties of the liusb, then delete the below portion of the code and add "libusb_dyn.c"
file (distributed along with libusb-win32 project) to this application. Also change the file name
to "libusb_dyn.cpp" before building.*/

typedef usb_dev_handle * (*usb_open_t)(struct usb_device *dev);
typedef int (*usb_close_t)(usb_dev_handle *dev);
typedef int (*usb_bulk_write_t)(usb_dev_handle *dev, int ep, char *bytes,
								int size, int timeout);
typedef int (*usb_bulk_read_t)(usb_dev_handle *dev, int ep, char *bytes,
							   int size, int timeout);
typedef int (*usb_set_configuration_t)(usb_dev_handle *dev, int configuration);
typedef int (*usb_claim_interface_t)(usb_dev_handle *dev, int interface);
typedef int (*usb_release_interface_t)(usb_dev_handle *dev, int interface);
typedef void (*usb_init_t)(void);
typedef int (*usb_find_busses_t)(void);
typedef int (*usb_find_devices_t)(void);
typedef struct usb_device * (*usb_device_t)(usb_dev_handle *dev);
typedef struct usb_bus * (*usb_get_busses_t)(void);



static usb_open_t _usb_open = NULL;
static usb_close_t _usb_close = NULL;
static usb_bulk_write_t _usb_bulk_write = NULL;
static usb_bulk_read_t _usb_bulk_read = NULL;
static usb_set_configuration_t _usb_set_configuration = NULL;
static usb_claim_interface_t _usb_claim_interface = NULL;
static usb_release_interface_t _usb_release_interface = NULL;
static usb_init_t _usb_init = NULL;
static usb_find_busses_t _usb_find_busses = NULL;
static usb_find_devices_t _usb_find_devices = NULL;
static usb_device_t _usb_device = NULL;
static usb_get_busses_t _usb_get_busses = NULL;



void usb_init(void)
	{

	HINSTANCE libusb_dll = LoadLibrary("libusb0.dll");

	if(!libusb_dll)
		return;

	_usb_open = (usb_open_t)
		GetProcAddress(libusb_dll, "usb_open");
	_usb_close = (usb_close_t)
		GetProcAddress(libusb_dll, "usb_close");
	_usb_bulk_write = (usb_bulk_write_t)
		GetProcAddress(libusb_dll, "usb_bulk_write");
	_usb_bulk_read = (usb_bulk_read_t)
		GetProcAddress(libusb_dll, "usb_bulk_read");
	_usb_set_configuration = (usb_set_configuration_t)
		GetProcAddress(libusb_dll, "usb_set_configuration");
	_usb_claim_interface = (usb_claim_interface_t)
		GetProcAddress(libusb_dll, "usb_claim_interface");
	_usb_release_interface = (usb_release_interface_t)
		GetProcAddress(libusb_dll, "usb_release_interface");
	_usb_init = (usb_init_t)
		GetProcAddress(libusb_dll, "usb_init");
	_usb_find_busses = (usb_find_busses_t)
		GetProcAddress(libusb_dll, "usb_find_busses");
	_usb_find_devices = (usb_find_devices_t)
		GetProcAddress(libusb_dll, "usb_find_devices");
	_usb_device = (usb_device_t)
		GetProcAddress(libusb_dll, "usb_device");
	_usb_get_busses = (usb_get_busses_t)
		GetProcAddress(libusb_dll, "usb_get_busses");


	if(_usb_init)
		_usb_init();
	}

usb_dev_handle *usb_open(struct usb_device *dev)
	{
	if(_usb_open)
		return _usb_open(dev);
	else
		return NULL;
	}

int usb_close(usb_dev_handle *dev)
	{
	if(_usb_close)
		return _usb_close(dev);
	else
		return -ENFILE;
	}

int usb_bulk_write(usb_dev_handle *dev, int ep, char *bytes, int size,
				   int timeout)
	{
	if(_usb_bulk_write)
		return _usb_bulk_write(dev, ep, bytes, size, timeout);
	else
		return -ENFILE;
	}

int usb_bulk_read(usb_dev_handle *dev, int ep, char *bytes, int size,
				  int timeout)
	{
	if(_usb_bulk_read)
		return _usb_bulk_read(dev, ep, bytes, size, timeout);
	else
		return -ENFILE;
	}
int usb_set_configuration(usb_dev_handle *dev, int configuration)
	{
	if(_usb_set_configuration)
		return _usb_set_configuration(dev, configuration);
	else
		return -ENFILE;
	}

int usb_claim_interface(usb_dev_handle *dev, int interface)
	{
	if(_usb_claim_interface)
		return _usb_claim_interface(dev, interface);
	else
		return -ENFILE;
	}

int usb_release_interface(usb_dev_handle *dev, int interface)
	{
	if(_usb_release_interface)
		return _usb_release_interface(dev, interface);
	else
		return -ENFILE;
	}

int usb_find_busses(void)
	{
	if(_usb_find_busses)
		return _usb_find_busses();
	else
		return -ENFILE;
	}

int usb_find_devices(void)
	{
	if(_usb_find_devices)
		return _usb_find_devices();
	else
		return -ENFILE;
	}

struct usb_device *usb_device(usb_dev_handle *dev)
	{
	if(_usb_device)
		return _usb_device(dev);
	else
		return NULL;
	}

struct usb_bus *usb_get_busses(void)
	{
	if(_usb_get_busses)
		return _usb_get_busses();
	else
		return NULL;
	}

//-------------------------------------------------------END CUT AND PASTE BLOCK-------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------------------------------------------------------