#ifndef __GLOBAL_H
#define __GLOBAL_H

/* 

	Globals, by Mauro Grassi, 2009-2010.


*/

#include <windows.h>
#include <errno.h>
#include <stdio.h>
#include "usb.h"
#include "driver.h"
#include "expression.h"
#include "common.h"
#include <streambuf>
#include <iostream>
#include "opcodes.h"
#include "vm.h"

#define CLEAR_ALARM_EVENT		0
#define ALARM_SET_EVENT			1
#define ALARM_TRIGGER_EVENT		2

extern std::string			myVMOutput;
extern const unsigned int	monthDayLimits[12];
extern TIME_T				systemTime;
extern unsigned short		alarmEvent;
extern unsigned short		keyFull;
extern TIME_T				alarmTime;

#if(IS_PC_HOST)

using namespace std;

void showCache(CACHE_OBJECT* cObj, std::string &instring);
void showArgument(VM_ARGUMENT* varg, std::string &instring);
void showVM(VIRTUAL_MACHINE* vm, std::string &instring);
void showVMEnvironment(VIRTUAL_MACHINE_ENVIRONMENT* ven, std::string &instring);
VM_RETURN_TYPE VMEnvironmentTask(VIRTUAL_MACHINE_ENVIRONMENT* ven, std::string &instring);


#else


#endif

unsigned int convertBCDToDecimal(unsigned int bcdValue);
unsigned int convertDecimalToBCD(unsigned int decValue);
unsigned char* getMemoryCardPNM(CARD_INFO* cInfo, unsigned char* outstr);
unsigned char* getMemoryCardPSN(CARD_INFO* cInfo, unsigned char* outstr);
unsigned char* getMemoryCardPRV(CARD_INFO* cInfo, unsigned char* outstr);
unsigned char* getMemoryCardType(CARD_INFO* cInfo, unsigned char* outstr);
unsigned char* getMemoryCardFreeSizeMB(CARD_INFO* cInfo, unsigned char* outstr);
unsigned char* getMemoryCardTotalSizeMB(CARD_INFO* cInfo, unsigned char* outstr);
unsigned char* ascTimeFileName(unsigned char* instr, TIME_T* timet);
unsigned char* getTimeStringSystemTime(unsigned char* outptr);
unsigned char* ascTime(unsigned char* outptr, TIME_T* ttime);
System::String^ getMemoryCardInfoString(CARD_INFO* cInfo);
unsigned char* uftoa(unsigned char* outstr, float f, int numdec);
BYTE* myultoa(DWORD Value, BYTE* Buffer, unsigned int setprinted);
unsigned char* ftoa(unsigned char* outstr, float f, int numdec);
System::Void createPath(System::String^ pathName);
System::String^ getPathOnly(System::String^ path);
System::String^ getFileNameFromPath(System::String^ path);
System::String^ getFileNameExtension(System::String^ infilename);
System::String^ formatStringFileSize(double f);
unsigned char*  getUnsignedCharPathFromString(unsigned char* outpath, unsigned char* outfilename, System::String^ instring, int index, int maxChars);
System::String^ showCache(CACHE_OBJECT* cObj);
System::String^ showArgument(VM_ARGUMENT* varg);
System::String^ showVM(VIRTUAL_MACHINE* vm);
System::String^ HexToString(unsigned long input, unsigned char bytes);
System::String^ formatStringFloat(double f, int numdec);
System::String^ getStringFromUnsignedCharArray(unsigned char* inarray, unsigned int numchars);
System::String^ getStringFromUnsignedCharArrayUpTo(unsigned char* inarray, unsigned int numchars);
unsigned char* getUnsignedCharArrayFromString(unsigned char* outarray, System::String^ instring);
int getUnsignedCharArrayFromStringMax(unsigned char* outarray, System::String^ instring, int maximum);
System::String^ getStringFromUnsignedCharArrayAuto(unsigned char* inarray);
System::String^ getStringFromStdString(std::string* instring);
std::string getStdStringFromString(System::String^ instring);
System::String^ digitString(int digit);
System::String^ myultoa(DWORD Value, unsigned int setprinted);
int stringLength(unsigned char* instr);
unsigned char* pointEndString(unsigned char* instr);
int compareString(unsigned char* first, unsigned char* second, int maxsize);
int findInString(unsigned char* first, unsigned char* second, int lengthOfSecondString, int maxsize);
unsigned char convertToUpper(unsigned char in);
int compareStringCaseInsensitive(unsigned char* first, unsigned char* second, int maxsize);
unsigned char* appendString(unsigned char* first, unsigned char* second, int maxsize);
unsigned char* copyString(unsigned char* first, unsigned char* second);
unsigned char* copyStringRom(unsigned char* first, const unsigned char* second);
unsigned char* copyStringLimited(unsigned char* first, unsigned char* second, int maxsize);
unsigned long myatol(unsigned char* instr);
unsigned int convertBCDToDecimal(unsigned int bcdValue);
unsigned int convertDecimalToBCD(unsigned int decValue);
unsigned int isLeapYear(unsigned int iyear);
unsigned int daysInMonth(unsigned int month, unsigned int year);
void convertToHoursMins(TIME_T* inTime, float f, int base);
float convertFromHoursMins(TIME_T* inTime, int base);
unsigned long getTotalDays(unsigned int day, unsigned int month, unsigned int year);
unsigned int getWeekDay(unsigned int day, unsigned int month, unsigned int year);
unsigned long getTotalSeconds(TIME_T* timet);
System::String^ getMonthString(int month);
System::String^ getWeekDayString(int wday);
System::String^ ascTimeString(TIME_T* timet);
System::String^ getTimeString(TIME_T* sysTime);
unsigned long getDuration(TIME_T* timeOne, TIME_T* timeTwo);
unsigned long getDurationTotalSeconds(TIME_T* timeOne, TIME_T* timeTwo);
int compareTimes(TIME_T* timeOne, TIME_T* timeTwo);
System::String^ getDurationString(double floatSeconds, int printed);
System::String^ getPCLocalTimeString(void);
System::String^ getTimeFileString(void);
void getLocalTimePC(TIME_T* secondSystemTime);
System::String^ getFileNameRoot(System::String^ infilename);
int WriteFileFromString(System::String^ fileName, System::String^ instring);
int WriteFile(System::String^ fileName, unsigned int offset, unsigned char* ptr, unsigned int size, unsigned int* done);
int ReadFile(System::String^ fileName, unsigned int offset, unsigned char* ptr, unsigned int size, unsigned int* done);
System::String^ WriteFileFromStringWithDialog(int* result, System::String^ instring);
System::String^ OpenFileToString(int* result, System::String^ *outfilename);
System::String^ internalAscTimeString(TIME_T* timet, unsigned char normal);
unsigned char* ascTimeNormal(unsigned char* outptr, TIME_T* ttime);
unsigned char* internalAscTime(unsigned char* instr, TIME_T* timet, unsigned char normal);
unsigned char* showDataLogger(DATA_LOGGER* dl, unsigned char* outstr);
System::String^ showBuffer(unsigned char* ptr, unsigned int size);
int compareCopy(unsigned char* oneptr, unsigned char* twoptr, unsigned int size);
int WriteFileCreate(System::String^ fileName, unsigned int offset, unsigned char* ptr, unsigned int size, unsigned int* done);
int TruncateFileAt(System::String^ fileName, unsigned int offset);
void setDefaultSettings(DATA_LOGGER* dl);
int restoreSettings(DATA_LOGGER* dl, std::string&, System::String^);
int saveSettings(DATA_LOGGER* dl, std::string&, System::String^); 
int compareCopyScripts(VIRTUAL_MACHINE_ENVIRONMENT* ven1, VIRTUAL_MACHINE_ENVIRONMENT* ven2);
System::String^ deviceGetTextFunction(unsigned char id);
unsigned char getFreeVMIDConsideringNames(VIRTUAL_MACHINE_ENVIRONMENT* ven, System::String^ instring);
System::String^ getScriptName(unsigned char id);
System::String^ getFullMemoryCardInfoString(CARD_INFO* cInfo);
unsigned long getFileSize(System::String^ instring);
void convertEpoch2TimeInternal(unsigned long epochTime, TIME_T* dest);
int setAlarmTimeVM(VIRTUAL_MACHINE* vm, TIME_T* sysTime);
int goToSleep(int on);
void memoryCardTask(void);
System::String^ myultoabaseString(unsigned long Value, unsigned char setprinted, unsigned char base, unsigned char spaceChar);
int compareCopyCardInfo(CARD_INFO* oneptr, CARD_INFO* twoptr);
System::String^ printAddress(unsigned long input, unsigned char bytes);
unsigned long StringToHex(System::String^ s);
unsigned long StringToDecimal(System::String^ s);
System::String^ getBufferString(unsigned long j, unsigned char* inptr, unsigned int bytes);
System::String^ writeMapFile(System::String^ fileName, unsigned long address, unsigned long endAddress, unsigned char* inptr);
System::String^ writeMapDifferencesFile(System::String^ fileName, System::String^ infoString, unsigned long address, unsigned long endAddress, unsigned char* inptr, unsigned char* inptr2);
int setDefaultsLocalSettings(LOCAL_SETTINGS* lS);
int saveLocalSettings(LOCAL_SETTINGS* lS, System::String^ fileName);
int restoreLocalSettings(LOCAL_SETTINGS* lS, System::String^ fileName, int* defaultsLoaded);
double avgPut(AVERAGED_OBJECT *aO, double g, int full);
int initLocalSettings(LOCAL_SETTINGS* lS, System::String^ fileName);
int restoreDefaultsLocalSettings(LOCAL_SETTINGS* lS, System::String^ fileName);
System::String^ getSaveFileName(System::String^ fileName, System::String^ extString, System::String^ fileExtension, int* ok);
System::String^ getOpenFileName(System::String^ fileName, System::String^ extString, System::String^ fileExtension, int* ok);
double avgInit(AVERAGED_OBJECT* aO, int maxAvgs);
extern "C" void deleteLocalFile(unsigned char* filename);
System::String^ formatStringHex(unsigned long x);
System::String^ formatStringConstant(double f, int numdec);
void receiveCharGPS(VIRTUAL_MACHINE*);
System::String^ getTimeFileStringDate(void);
System::String^ getTimeFileStringDate(void);
unsigned char isFileChar(unsigned char c);
unsigned char* copyFileStringString(unsigned char* first, unsigned char* second);
std::string showPipeBufferLocal();
unsigned char serialPipeGetLocal(void);
void serialPipePutLocal(unsigned char g);
std::string flushSerialUSBLocal(void);
void sendCharSerialUSBLocal(unsigned char c);
void sendRamStringSerialUSBLocal(unsigned char* ramString);
void sendRomStringSerialUSBLocal(unsigned const char* romString);
void initSerialUSBLocal(void);
unsigned long scaleTimeSeconds(double timeSpeed, unsigned long offset, unsigned long timeToScale);
void scaleTime(double timeSpeed, unsigned long offset, TIME_T* timeToScale);
void getLocalTimePCScaled(double timeSpeed, unsigned long offset, TIME_T* secondSystemTime);
void getTimeScaled(double timeSpeed, unsigned long offset, TIME_T* sTime);
System::String^ ReadStringFromFile(System::String^ fileName);
System::String^ getHelpText(unsigned long maskid, unsigned int header, unsigned int windowCharacterWidth);

#endif
