/* 

	Global Functions, by Mauro Grassi, 2009-2010...

*/

const unsigned int monthDayLimits[12]=
{
	31, 
	28, 
	31, 
	30, 
	31, 
	30, 
	31, 
	31, 
	30, 
	31, 
	30,
	31 
};

System::String^ showCache(CACHE_OBJECT* cObj)
{
	System::String^ outputString;

	outputString="";
	outputString+="Cache Sz: 0x"+HexToString(cObj->cacheSize, 2)+" Max: 0x"+HexToString(cObj->cacheMaxAddress, 2)+" B: 0x"+HexToString(cObj->bottomAddress, 2)+" T: 0x"+HexToString(cObj->topAddress, 2)+" \r\n";
	outputString+="H: "+formatStringFloat((double)cObj->cacheHits, 0)+" M: "+formatStringFloat((double)cObj->cacheTotal-(double)cObj->cacheHits, 0)+" P: "+formatStringFloat((double)cObj->cachePerformance, 2)+"%\r\n";
	return outputString;
}

System::String^ showArgument(VM_ARGUMENT* varg)
{
	System::String^ outputString;

	outputString="";
	outputString+="Arg. Opcode: 0x"+HexToString(varg->opcode, 1)+" Type: 0x"+HexToString(varg->type, 1)+" bArg: 0x"+HexToString(varg->arg.bArg, 1)+" nArg: 0x"+HexToString(varg->arg.nArg, 2)+" \r\n";
	outputString+="fArg: "+formatStringFloat((double)varg->arg.fArg, 3)+"\r\n";
	return outputString;
}

System::String^ showVM(VIRTUAL_MACHINE* vm)
{
	System::String^ outputString;

	outputString="";
	outputString+="VM ID: 0x"+HexToString(vm->execID, 1)+" State: 0x"+HexToString(vm->execState, 1)+" Error: 0x"+HexToString(vm->lastError, 1)+"\r\n";
	outputString+="PC: 0x"+HexToString(vm->PC, 2)+" W: "+formatStringFloat((double)vm->W, 4)+" IR: 0x"+HexToString(vm->IR, 1)+" ST: 0x"+HexToString(vm->StackSizePtr, 2)+"\r\n";
	outputString+="ExecLimit: 0x"+HexToString(vm->execLimit, 2)+" ExecDone: "+formatStringFloat((double)vm->execDone, 0)+"\r\n";
	outputString+=showArgument(&argument);
	outputString+="Stack Cache: \r\n";
	outputString+=showCache(&vm->STACKImage);
	outputString+="RAM Cache: \r\n";
	outputString+=showCache(&vm->RAMImage);
	outputString+="ROM Cache: \r\n";
	outputString+=showCache(&vm->ROMImage);
	return outputString;
}

System::String^ HexToString(unsigned long input, unsigned char bytes)
{
	System::String^ returnString;
	wchar_t returnArray[9];

	unsigned char i;
	unsigned char c;

	for(i=0;i<9;i++)
	{
		returnArray[i]='0';
	}

	for(i=0;i<bytes*2;i++)
	{
		c = (unsigned char)(input & 0x0000000F);

		if(c <= 9)
		{
			returnArray[7-i]=c+'0';
		}
		else 
		{
			returnArray[7-i]=c+'A'-10;
		}

		input >>= 4;
	}
	returnArray[9] = 0;
	returnString = gcnew System::String(returnArray);
	returnString = returnString->Substring(8-(bytes*2),bytes*2);
	return returnString;
}

System::String^ formatStringFloat(double f, int numdec)
{
	int j, i, n, padding;
	System::String^ resultString;
	float rounding;

	if(numdec<0)
	{
		numdec=-numdec;
		padding=1;
	} else padding=0;
	if(numdec>5)numdec=5; 
	if(numdec<=3)
	{
		rounding=0.5;
		i=numdec;
		while(i>0)
		{
			rounding/=10.0;
			i--;
		}
		f+=rounding;
	}

	if((f<(double)MIN_F)&&(f>-(double)MIN_F))f=0.0;
	resultString=System::Convert::ToString(f);
	if(resultString=="Infinity")return resultString;
	j=resultString->IndexOf(".");
	n=resultString->Length;
	if(j<0)
	{ 
		if(numdec>0)
		{
			resultString=resultString->Insert(n, "."); 
			n++; 
		}
		j=n-1; 
	}
	i=n-j-1;
	if(i>numdec)
	{
		// delete some characters from the end of the string...
		if(numdec>0)n-=(i-numdec); else n-=(1+i);
		resultString=resultString->Substring(0, n);
	}
	else
		if(i<numdec)
		{
			// add zeros to the end of the string...
			resultString=resultString->PadRight(n+numdec-i, '0');	
		}
		if(padding)
		{   
			while(resultString->Length<5)
			{
				// assumes 4+1 (the 1 for the '.')
				resultString=resultString->Insert(0, "0");
			}
		}
		return resultString;
}

System::String^ getStringFromUnsignedCharArray(unsigned char* inarray, unsigned int numchars)
{
	 wchar_t internalArray[2];
	 System::String^ response;
	 response="";
	 while(numchars--)
	 {
		 internalArray[0]=(wchar_t)*inarray++;
		 internalArray[1]=(wchar_t)'\0';
		 response+=gcnew System::String((wchar_t*)&internalArray[0]);
	 }
	 return response;
}
			
System::String^ getStringFromUnsignedCharArrayUpTo(unsigned char* inarray, unsigned int numchars)
{
	 wchar_t internalArray[2];
	 System::String^ response;
	 response="";
	 internalArray[0]=1;
	 while((numchars--)&&(internalArray[0]!='\0'))
	 {
		 internalArray[0]=(wchar_t)*inarray++;
		 internalArray[1]=(wchar_t)'\0';
		 response+=gcnew System::String((wchar_t*)&internalArray[0]);
	 }
	 return response;
}

unsigned char* getUnsignedCharArrayFromString(unsigned char* outarray, System::String^ instring)
{
	 unsigned char c;
	 int i;
	 i=0;
	 while(i<instring->Length)
	 {
		 c=(unsigned char)instring[i];
		 *outarray++=c;
		 i++;
	 }
	 *outarray='\0';
	 return outarray;
}
			
unsigned char* getUnsignedCharArrayFromStringMax(unsigned char* outarray, System::String^ instring, int maximum)
{
	 unsigned char c;
	 int i;
	 i=0;
	 while((i<instring->Length)&&(i<maximum))
	 {
		c=(unsigned char)instring[i];
		*outarray++=c;
		i++;
	 }
	 *outarray='\0';
	 return outarray;
}

System::String^ getStringFromUnsignedCharArrayAuto(unsigned char* inarray)
{
	 wchar_t internalArray[2];
	 System::String^ response;
	 response="";
	 while((*inarray)!='\0')
	 {
		 internalArray[0]=(wchar_t)*inarray++;
		 internalArray[1]=(wchar_t)'\0';
		 response+=gcnew System::String((wchar_t*)&internalArray[0]);
	 }
	 return response;
}

System::String^ getStringFromStdString(std::string* instring)
{
	 wchar_t internalArray[2];
	 System::String^ response;
	 int i;
	 i=0;
	 internalArray[0]=(wchar_t)(*instring)[i++];
	 internalArray[1]=(wchar_t)'\0';
	 response="";
	 while((internalArray[0])!='\0')
	 {
		 response+=gcnew System::String((wchar_t*)&internalArray[0]);
		 internalArray[0]=(wchar_t)(*instring)[i++];
	 }
	 return response;
}

std::string getStdStringFromString(System::String^ instring)
{
	 std::string result;
	 char c;
	 int i;
	 i=0;
	 result="";
	 while(i<instring->Length)
	 {
		 c=(char)instring[i];
		 result+=(char)c;
		 i++;
	 }
	 result[i]='\0';
	 return result;
}

void outputCharVM(unsigned char c)
{
	myVMOutput+=(char)c;
}

void outputFVM(float f, unsigned short numdec)
{
	myVMOutput+=getStdStringFromString(formatStringFloat((double)f, numdec));
}

System::String^ digitString(int digit)
{
	System::String^ response;

	switch(digit)
	{
	case 0:
		response="0";
		break;

	case 1:
		response="1";
		break;

	case 2:
		response="2";
		break;

	case 3:
		response="3";
		break;

	case 4:
		response="4";
		break;

	case 5:
		response="5";
		break;

	case 6:
		response="6";
		break;

	case 7:
		response="7";
		break;

	case 8:
		response="8";
		break;

	case 9:
		response="9";
		break;
	}
	return response;
}

System::String^ myultoa(DWORD Value, unsigned int setprinted)
{
	System::String^ response;
	BYTE i;
	DWORD Digit;
	DWORD Divisor;
	BOOL  Printed;

	response="";
	Printed=FALSE;
	for(i=0, Divisor=1000000000; i<10; i++)
	{
		if(((10-i)==setprinted)||(i==9))Printed=TRUE;
		Digit = Value/Divisor;
		if(Digit||Printed)
		{
			response+=digitString(Digit);
			Value-=Digit*Divisor;
			Printed=TRUE;
		}
		Divisor/=10;
	}
	return response;
}

int stringLength(unsigned char* instr)
{
	int i;
	i=0;
	while((*instr)!='\0')
	{
		i++;
		instr++;
	}
	return i;
}

unsigned char* pointEndString(unsigned char* instr)
{
	// returns pointer to the end of the string
	while((*instr)!='\0')
	{
		instr++;
	}
	return instr;
}

int compareString(unsigned char* first, unsigned char* second, int maxsize)
{
	unsigned char c1, c2;
	int v;
	int i;

	i=0;
	do 
	{
		c1=*first++;
		c2=*second++;
		v=(unsigned int)c1-(unsigned int)c2;
		i++;
	} while ((v==0)&&(c1!='\0')&&(i<maxsize));
	return v;
}

int findInString(unsigned char* first, unsigned char* second, int lengthOfSecondString, int maxsize)
{
	/* find first occurrence in first string of second string up to maxsize chars */
	int i, j;

	i=0;
	j=-1;
	while((first[i]!='\0')&&(i<maxsize))
	{
		if(!compareString(&first[i], second, lengthOfSecondString))
		{
			j=i;
			break;
		}
		i++;
	}
	return j;	
}

unsigned char convertToUpper(unsigned char in)
{
	if((in>='a')&&(in<='z'))return in-0x20; 
	return in;
}

int compareStringCaseInsensitive(unsigned char* first, unsigned char* second, int maxsize)
{
	unsigned char c1, c2;
	int v;
	int i;
	i=0;
	do 
	{
		c1=convertToUpper(*first);
		c2=convertToUpper(*second);
		first++;
		second++;
		v=(unsigned int)c1-(unsigned int)c2;
		i++;
	} while ((v==0)&&(c1!='\0')&&(i<maxsize));
	return v;
}

unsigned char* appendString(unsigned char* first, unsigned char* second, int maxsize)
{
	// append second string to the end of first string (maximum maxsize characters)
	unsigned char* outstr;
	int i;

	outstr=pointEndString(first);
	i=(outstr-first);
	while((i<maxsize)&&((*second)!='\0'))
	{
		*outstr++=*second++;
		i++;
	}
	*outstr='\0';
	return first;
}

unsigned char* copyString(unsigned char* first, unsigned char* second)
{
	// copy second string to first
	while((*second)!='\0')
	{
		*first++=*second++;
	}
	*first='\0';
	return first;
}

unsigned char* copyStringRom(unsigned char* first, const unsigned char* second)
{
	// copy second string to first
	while((*second)!='\0')
	{
		*first++=*second++;
	}
	*first='\0';
	return first;
}

unsigned char* copyStringLimited(unsigned char* first, unsigned char* second, int maxsize)
{
	// copy second string to first up to maxsize characters
	int i;

	i=0;
	while((i<maxsize)&&((*second)!='\0'))
	{
		*first++=*second++;
		i++;
	}
	*first='\0';
	return first;
}

unsigned long myatol(unsigned char* instr)
{
	unsigned long l;
	char c;

	l=0;
	while(*instr!='\0')
	{
		c=*instr++;
		if((c>='0')&&(c<='9'))
		{
			l*=10;
			l+=c-'0';
		}
	}
	return l;
}

long extractNumberBinary(unsigned char* inbuffer, int sizeInBytes)
{
	/* assumes little endian */
	unsigned long n;
	unsigned int bitshift;
	n=0;
	bitshift=0;
	while(sizeInBytes>0)
	{
		n+=(((unsigned long)(*inbuffer))<<bitshift);
		bitshift+=8;
		inbuffer++;
		sizeInBytes--;
	}
	return n;
}

unsigned char* putNumberBinary(unsigned char* outbuffer, long x, int sizeInBytes)
{
	/* assumes little endian */
	unsigned int bitshift;
	bitshift=0;
	while(sizeInBytes>0)
	{
		*(outbuffer)=(unsigned char)(x>>bitshift);
		bitshift+=8;
		outbuffer++;
		sizeInBytes--;
	}
	return outbuffer;
}

long extractNumber(char* instring)
{
	// returns a number from a string, including an IP address in X.X.X.X format.
	int i, f;
	char c;
	long result;
	int sign;

	i=0;
	f=0;
	iBuffer[0]='\0';
	result=0;
	sign=0;

	while((*instring)!='\0')
	{
		c=*instring;
		if((c>='0')&&(c<='9'))break;
		if((*instring)=='-')sign^=1;
		instring++;
	}

	while(*instring!='\0')
	{
		c=*instring++;
		if((c>='0')&&(c<='9'))
		{
			iBuffer[i++]=c;
			f=1;
		}
		else
		{
			iBuffer[i]='\0';
			if(f==1)
			{
				result=result<<8;
				result+=(myatol(iBuffer));
			}
			f=0;
			i=0;
			iBuffer[0]='\0';
		}
	}
	iBuffer[i]='\0';
	if(f==1)
	{
		result=result<<8;
		result+=(myatol(iBuffer));
	}
	if(sign)result=-result;
	return result;
}

float extractFloat(char* instring)
{
	// returns a number from a string, including an IP address in X.X.X.X format.
	int i, f;
	char c;
	float result, g;
	int sign;

	result=0;
	sign=0;

	while((*instring)!='\0')
	{
		c=*instring;
		if((c>='0')&&(c<='9'))break;
		if((*instring)=='-')sign^=1;
		instring++;
	}

	f=0;
	i=0;
	iBuffer[0]='\0';
	while(*instring!='\0')
	{
		c=*instring++;
		if((c>='0')&&(c<='9'))
		{
			iBuffer[i++]=c;
		}
		else
		{
			iBuffer[i]='\0';
			if(f==0)
			{
				result=(float)myatol(iBuffer);
			}
			else
			{
				g=(float)(myatol(iBuffer));
				while(i--)g/=10.0;
				result+=g;
			}
			f++;
			i=0;
			iBuffer[0]='\0';
		}
	}

	iBuffer[i]='\0';
	if(f==0)result=(float)(myatol(iBuffer));
	else
	{
		g=(float)(myatol(iBuffer));
		while(i--)g/=10.0;
		result+=g;
	}
	if(sign)result=-result;
	return result;
}

unsigned int convertBCDToDecimal(unsigned int bcdValue)
{
	unsigned int x;
	x=0;
	x=((bcdValue>>4)&0x0F)*10;
	x+=(bcdValue&0x0F);
	return x;
}

unsigned int convertDecimalToBCD(unsigned int decValue)
{
	unsigned int x;

	x=0x0F & (decValue/10);
	x=x<<4;
	x+=(decValue % 10);
	return (x & 0xFF);
}

unsigned int isLeapYear(unsigned int iyear)
{
	// returns TRUE if iyear is a leap year, FALSE otherwise
	int i, j;

	if(iyear>=EPOCH_YEAR)
	{
		i=(iyear%4);
		if(i!=0)return 0;	// since not divisible by 4
		i=(iyear%100);
		if(i!=0)return 1;
		/* here it is divisible by 4 and 100 but not necessarily by 400! */
		j=(iyear%400);
		if(j==0)return 1; else return 0;
	}
	return 0;
}

unsigned int daysInMonth(unsigned int month, unsigned int year)
{
	unsigned int i;

	if(month<1)month=1; else if(month>12)month=12;
	if(isLeapYear(year)&&(month==2))i=1; else i=0;
	return i+monthDayLimits[month-1];
}

void convertToHoursMins(TIME_T* inTime, float f, int base)
{
	int i;
	int h, m;

	i=(int)f;
	if(i<0)i=0; else if(i>=9999)i=9999;
	h=(i/base);
	m=(i%base);
	inTime->hours=h;
	inTime->mins=m;	
}

float convertFromHoursMins(TIME_T* inTime, int base)
{
	return (float)((inTime->hours*base)+(inTime->mins));
}

unsigned long getTotalDays(unsigned int day, unsigned int month, unsigned int year)
{
	/* 
	return the day of the week from the day, month and year information 
	We know that 1 January 1970 was a Thursday
	We need to know how many days have elapsed since 1 January 1970...		
	*/
	unsigned int N4, N100, N400, j, i;
	unsigned long totalDays;
	if(year>=1970)
	{
		N4=(unsigned int)((year-1969)/4);
		N100=(unsigned int)((year-1901)/100);
		N400=(unsigned int)((year-1601)/400);
		totalDays=(year-1970)*365+N4-N100+N400;
		month=month-1;
		i=isLeapYear(year);
		while(month>0)
		{
			if(month==2)j=monthDayLimits[1]+i; else if(month<=12)j=monthDayLimits[month-1]; else return 0;
			totalDays+=j;
			month--;
		}	
		totalDays+=(day-1);
		return totalDays;
	}
	return 0;
}

unsigned int getWeekDay(unsigned int day, unsigned int month, unsigned int year)
{
	return ((getTotalDays(day, month, year)+3)%7);
}

unsigned long getTotalSeconds(TIME_T* timet)
{
	/* get total seconds from the EPOCH time */
	unsigned long days;
	unsigned long totalSeconds;

	days=getTotalDays(timet->day, timet->month, timet->year);
	totalSeconds=86400*days;
	totalSeconds+=(3600*timet->hours);
	totalSeconds+=(60*timet->mins);
	totalSeconds+=timet->secs;
	return totalSeconds;
}

System::String^ getMonthString(int month)
{
	System::String^ response;

	response="";
	switch(month)
	{
	default:
	case 0:
		response="Jan";
		break;
	case 1:
		response="Feb";
		break;
	case 2:
		response="Mar";
		break;
	case 3:
		response="Apr";
		break;
	case 4:
		response="May";
		break;
	case 5:
		response="Jun";
		break;
	case 6:
		response="Jul";
		break;

	case 7:
		response="Aug";
		break;

	case 8:
		response="Sep";
		break;

	case 9:
		response="Oct";
		break;

	case 10:
		response="Nov";
		break;

	case 11:
		response="Dec";
		break;
	}
	return response;
}

System::String^ getWeekDayString(int wday)
{
	System::String^ response;

	response="";
	switch(wday)
	{
	default:
	case 0:
		response="Mon";
		break;
	case 1:
		response="Tue";
		break;
	case 2:
		response="Wed";
		break;
	case 3:
		response="Thu";
		break;
	case 4:
		response="Fri";
		break;
	case 5:
		response="Sat";
		break;
	case 6:
		response="Sun";
		break;
	}
	return response;
}

System::String^ ascTime(TIME_T* timet)
{
	System::String^ outstr;

	/* 
	convert a TIME_T structure to a string...

	*/

	/*
	Note: while stopping T6 may cause inaccuraccies in the local time keeping over a long time (after accumulation of many small errors), we rely
	on regular scheduled time syncs with radio time to maintain good time accuracy 
	*/

	outstr="";

	if(timet->f.flags.showWDay)
	{
		timet->wday=getWeekDay(timet->day, timet->month, timet->year);
		if(timet->wday<0)timet->wday=0;
		else
			if(timet->wday>6)timet->wday=6;
		outstr+=getWeekDayString(timet->wday);
	}
	if(timet->f.flags.showDay)
	{
		outstr+=" ";
		outstr+=formatStringFloat((double)timet->day, 0);
	}
	if(timet->f.flags.showMonth)
	{
		outstr+=" ";
		if(timet->month<1)timet->month=1;
		else
			if(timet->month>12)timet->month=12;	
		outstr+=getMonthString(timet->month-1);
	}
	if(timet->f.flags.showYear)
	{
		outstr+=" ";
		outstr+=formatStringFloat((double)timet->year, 0);
	}
	if(timet->f.flags.showHours)
	{
		outstr+=" ";
		outstr+=myultoa(timet->hours, 2);
	}
	if(timet->f.flags.showMinutes)
	{
		outstr+=":";
		outstr+=myultoa(timet->mins, 2);
	}
	if(timet->f.flags.showSeconds)
	{
		outstr+=":";
		outstr+=myultoa(timet->secs, 2);
	}
	return outstr;
}

System::String^ getTimeString(TIME_T* sysTime)
{
	return ascTime(sysTime); 
}

unsigned long getDuration(TIME_T* timeOne, TIME_T* timeTwo)
{
	/* get seconds between two times disregarding dates */
	long total;
	int x;

	total=0;
	if(timeTwo)
	{
		if(timeOne->hours>=timeTwo->hours)x=(timeOne->hours-timeTwo->hours); else x=24+(timeOne->hours-timeTwo->hours);
		total+=(long)(x*24*60);
		x=(timeOne->mins-timeTwo->mins);
		total+=(long)(x*60);
		x=(timeOne->secs-timeTwo->secs);
		total+=(long)x;
	}
	else
	{
		x=(timeOne->hours);
		total+=(long)(x*24*60);
		x=(timeOne->mins);
		total+=(long)(x*60);
		x=(timeOne->secs);
		total+=(long)x;	
	}
	if(total<0)total=-total;
	return (unsigned long)total;
}

unsigned long getDurationTotalSeconds(TIME_T* timeOne, TIME_T* timeTwo)
{
	unsigned long seconds1;
	unsigned long seconds2;

	seconds1=getTotalSeconds(timeOne);
	seconds2=getTotalSeconds(timeTwo);
	if(seconds1>=seconds2)
	{
		return seconds1-seconds2;
	}
	else
	{
		return seconds2-seconds1;
	}
	return 0;
}

int compareTimes(TIME_T* timeOne, TIME_T* timeTwo)
{
	/* returns 0 if equal, 1 if timeOne is after timeTwo, -1 if timeTwo is after timeOne */
	if(timeOne->f.flags.showYear)
	{
		/* compare years */
		if(timeOne->year>timeTwo->year)return 1;
		else
			if(timeTwo->year>timeOne->year)return -1;	
	}

	if(timeOne->f.flags.showMonth)
	{
		/* compare months */
		if(timeOne->month>timeTwo->month)return 1;	
		else
			if(timeTwo->month>timeOne->month)return -1;	
	}

	if(timeOne->f.flags.showDay)
	{
		/* compare days */
		if(timeOne->day>timeTwo->day)return 1;	
		else
			if(timeTwo->day>timeOne->day)return -1;	
	}

	if(timeOne->f.flags.showHours)
	{
		/* compare hours */
		if(timeOne->hours>timeTwo->hours)return 1;	
		else
			if(timeTwo->hours>timeOne->hours)return -1;	
	}

	if(timeOne->f.flags.showMinutes)
	{
		/* compare mins */
		if(timeOne->mins>timeTwo->mins)return 1;
		else
			if(timeTwo->mins>timeOne->mins)return -1;	
	}

	if(timeOne->f.flags.showSeconds)
	{
		/* compare seconds */
		if(timeOne->secs>timeTwo->secs)return 1;	
		else
			if(timeTwo->secs>timeOne->secs)return -1;	
	}
	return 0;
}

System::String^ getDurationString(double floatSeconds, int printed)
{
	/* 

	update the time string with minutes in double...

	*/
	System::String^ outstr;
	unsigned long days;
	unsigned int hours;
	unsigned int minutes;
	unsigned int seconds;

	outstr="";
	if(floatSeconds<0.0)floatSeconds=0.0;
	days=(unsigned long)(floatSeconds/86400.0);
	floatSeconds-=((double)days*86400.0);
	hours=(unsigned int)(floatSeconds/3600.0);
	floatSeconds-=((double)hours*3600.0);
	minutes=(unsigned int)(floatSeconds/60.0);
	floatSeconds-=((double)minutes*60.0);
	seconds=(unsigned int)(floatSeconds);
	if((days>0)||(printed))
	{
		outstr=myultoa((long)days, 0);
		outstr+="d ";
		printed=1;
	}

	if((hours>0)||(printed))
	{
		outstr+=myultoa((long)hours, 0);
		outstr+="h ";
		printed=1;
	}

	if((minutes>0)||(printed))
	{
		outstr+=myultoa((long)minutes, 0);
		outstr+="m ";
		printed=1;
	}
	outstr+=myultoa((long)seconds, 0);
	outstr+="s";
	return outstr;
}

System::String^ getPCLocalTimeString(void)
			 {
				 System::String^ result;
				 System::DateTime d1=System::DateTime::Now;

				 result+=formatStringFloat((float)d1.Hour, 0);
				 result+=".";
				 result+=formatStringFloat((float)d1.Minute, 0);
				 result+=".";
				 result+=formatStringFloat((float)d1.Second, 0);
				 result+=".";
				 result+=formatStringFloat((float)d1.Millisecond, 0);
				 return result;
			 }

				  	 System::String^ getTimeFileString(void)
			 {
				 System::String^ result;
				 System::DateTime d1=System::DateTime::Now;

				 result+=formatStringFloat((float)d1.Day, 0);
				 result+=formatStringFloat((float)d1.Month, 0);
				 result+=formatStringFloat((float)d1.Year, 0);
				 result+=".";
				 result+=formatStringFloat((float)d1.Hour, 0);
				 result+=formatStringFloat((float)d1.Minute, 0);
				 result+=formatStringFloat((float)d1.Second, 0);
				 return result;
			 }

					 			 void getLocalTimePC(TIME_T* secondSystemTime)
			 {
				 SYSTEMTIME	mySystemTime;
				 GetLocalTime(&mySystemTime);			
				 secondSystemTime->secs=(unsigned char)mySystemTime.wSecond;
				 secondSystemTime->mins=(unsigned char)mySystemTime.wMinute;
				 secondSystemTime->hours=(unsigned char)mySystemTime.wHour;
				 secondSystemTime->day=(unsigned char)mySystemTime.wDay;
				 secondSystemTime->month=(unsigned char)mySystemTime.wMonth;
				 secondSystemTime->year=mySystemTime.wYear;
				 secondSystemTime->wday=(unsigned char)mySystemTime.wDayOfWeek;
			}

								 				System::String^ getFileNameRoot(System::String^ infilename)
				{
					int index;

					index=infilename->IndexOf(".");
					if(index>=0)
					{
						return infilename->Substring(0, index);
					 }
					 else
					 {	
						return infilename;
					 }
					 return infilename;
				}

			 int WriteFile(System::String^ fileName, unsigned char* ptr, unsigned int size) 
			 {			
			 	 
				 FileStream ^fileSupportStreamWriter;		
				 try
				 {
					 fileSupportStreamWriter = gcnew FileStream(fileName, FileMode::Create);
				 }
				 catch(char*)
				 {
						 if(fileSupportStreamWriter)
						 {
							 delete fileSupportStreamWriter;
						 }
						 return 0;
				 }
				 while(size--)
				 {
					 fileSupportStreamWriter->WriteByte(*ptr++);
				 }
				 fileSupportStreamWriter->Close();
				 return 1;
			 }

			 int WriteFileFromString(System::String^ fileName, System::String^ instring) 
			 {			
				 FileStream ^fileSupportFileStream;
				 StreamWriter ^fileSupportStreamWriter;		
				 try
				 {
					 fileSupportStreamWriter = gcnew StreamWriter(fileName, false);
				 }
				 catch(char*)
				 {
						 if(fileSupportFileStream)
						 {
							 delete fileSupportFileStream;
						 }
						 return 0;
				 }
				 fileSupportStreamWriter->Write(instring);
				 fileSupportStreamWriter->Close();
				 return 1;
			 }

			 System::String^ WriteFileFromStringWithDialog(int* result, System::String^ instring) 
			 {			
				 System::String^ responseString;
				 
				 FileStream ^fileSupportFileStream;
				 StreamWriter ^fileSupportStreamWriter;
				 SaveFileDialog^ dialog_ExportHex;

				 *result=0;			
				 responseString="Export Memory Map File ";
				 dialog_ExportHex= gcnew(SaveFileDialog);
				 dialog_ExportHex->Filter= "Text files (*.txt)|*.txt|All files (*.*)|*.*";
				 //Open a show dialog box for the "Save As" for the hex file
				 if (dialog_ExportHex->ShowDialog() == ::System::Windows::Forms::DialogResult::OK)
				 {
					 try
					 {
						 //Try to create a write stream to the specified file
						 fileSupportStreamWriter = gcnew StreamWriter(dialog_ExportHex->FileName,false);
					 }
					 catch(char*)
					 {
						 //If there was an error, print it out and delete any created 
						 //  objects
						 //PRINT_STATUS(gcnew String(str));

						 if(fileSupportFileStream)
						 {
							 delete fileSupportFileStream;
						 }
						 //There was an error
						 responseString+="Error.";
						 return responseString;
					 }

					 fileSupportStreamWriter->Write(instring);
					 responseString+=dialog_ExportHex->FileName;
					 // Write the end of file command, close the file, and notify the user
					 fileSupportStreamWriter->Close();
					 responseString+=": Ok!";
					 return responseString;
				 }
				 else
				 {
					 responseString+="Cancelled.\r\n";
					 return responseString;
				 }
				 return responseString;
			 }

			 System::String^ OpenFileToString(int* result, System::String^ *outfilename) 
			 {
				 String^ responseString;
				 String ^fileSupportBuffer;
				 FileStream ^fileSupportFileStream;
				 StreamReader ^fileSupportStreamReader;
				 Stream^ myStream;

				 *result=0;
				 responseString="";
				 *outfilename="";
				 OpenFileDialog^ openFileDialog1 = gcnew OpenFileDialog;
				 openFileDialog1->Filter = "All Text files (*.txt)|*.txt";
				 openFileDialog1->FilterIndex = 1;
				 openFileDialog1->RestoreDirectory = true;

				 // Try to delete any previous file objects if they exist
				 try
				 {
					 if(fileSupportFileStream)
					 {
						 delete fileSupportFileStream;
					 }
				 }catch(...){}

				 try
				 {
					 if ( fileSupportStreamReader )
					 {
						 fileSupportStreamReader->Close();
						 delete (IDisposable^)fileSupportStreamReader;
					 }
				 }catch(...){}

				 // Open the dialog
				 if (openFileDialog1->ShowDialog() == ::System::Windows::Forms::DialogResult::OK)
				 {
					 //if they pressed OK and a file was selected
					 if ( (myStream = openFileDialog1->OpenFile()) != nullptr )
					 {
						 //If there was a file selected
						 try
						 {
							 //Try to open the file to read
							 fileSupportFileStream = gcnew FileStream(openFileDialog1->FileName, FileMode::Open, FileAccess::Read);
							 fileSupportStreamReader = gcnew StreamReader(fileSupportFileStream);
						 }catch(...)
						 {
							 //If we couldn't open the file then destroy any of the file
							 //  support variables that may exist
							 if(fileSupportFileStream)
							 {
								 fileSupportFileStream->Close();
								 delete fileSupportFileStream;
							 }

						 }
						 *outfilename=openFileDialog1->FileName;
						 while ((!fileSupportStreamReader->EndOfStream) && (fileSupportBuffer = fileSupportStreamReader->ReadLine()))
						 {
							responseString+=(fileSupportBuffer+"\r\n");
						 }
					 }
					 fileSupportFileStream->Close();
				 }
				 return responseString;
			 }

