// $Id: driver.cc 39 2008-08-03 10:07:15Z tb $
/** \file driver.cc Implementation of the example::Driver class. */

#include <fstream>
#include <sstream>
#include "driver.h"
#include "scanner.h"
#include "global.h"

System::String^		formatStringFloat(double f, int numdec);
std::string			getStdStringFromString(System::String^ instring);

unsigned char lastMovRNum=0;
unsigned char lastMovROpcode[MAX_LAST_MOVRS];
unsigned char lastMovRIndex[MAX_LAST_MOVRS];
unsigned char lastMovRData[MAX_LAST_MOVRS][16];

unsigned char lastOpcode=OPCODE_NOP;
unsigned char lastIndex=0;
unsigned char lastData[16];
unsigned char lastNonMovROpcode=OPCODE_NOP;
unsigned char lastNonMovRIndex=0;
unsigned char lastNonMovRData[16];
unsigned long bytesKilled=0;
unsigned char copyPropagation=0;
	
namespace example {

Driver::Driver(class CalcContext& _calc)
    : trace_scanning(false),
      trace_parsing(false),
      calc(_calc)
{
	this->errorOutput="Error.\r\n";
	this->compileOutput.clear();
	this->maxLine=0;
	this->errorCount=0;
	this->warningCount=0;
}

bool Driver::parse_stream(std::istream& in, const std::string& sname)
{
    bool result;
	unsigned int i;
	streamname = sname;
    Scanner scanner(&in);
    scanner.set_debug(trace_scanning);
    this->lexer = &scanner;
    Parser parser(*this);
    parser.set_debug_level(trace_parsing);
	
	this->errorOutput.clear();
	result=(parser.parse()==0);
	i=0;
	while(i<this->warningCount)
	{
		this->errorOutput.append(this->compileOutputWarnings[i]->message);
		i++;
	}

	i=0;
	while(i<this->errorCount)
	{
		this->errorOutput.append(this->compileOutput[i]->message);
		i++;
	}
	return result;
}

bool Driver::parse_file(const std::string &filename)
{
    std::ifstream in(filename.c_str());
    if (!in.good()) return false;
    return parse_stream(in, filename);
}

bool Driver::parse_string(const std::string &input, const std::string& sname)
{
	if(input.length()>0)
	{
		std::istringstream iss(input);
		return parse_stream(iss, sname);
	}
	else
	{
		return false;
	}
}

void Driver::error(const class location& l,
		   const std::string& m)
{
	unsigned int    currentLineS;
	unsigned int	currentColS;
	unsigned int    currentLineE;
	unsigned int	currentColE;
	std::string		tempString;
	
	if(m[0]!='W')
	{
		currentLineS=(unsigned int)l.begin.line;
		currentColS=(unsigned int)l.begin.column;
		currentLineE=(unsigned int)l.end.line;
		currentColE=(unsigned int)l.end.column;	
		tempString="";
		tempString+="Line : "+getStdStringFromString(myultoabaseString(currentLineS, 5, 10, ' '))+" Col: "+getStdStringFromString(myultoabaseString(currentColS, 5, 10, ' '))+" "+m+"\r\n";
		if(currentLineS>this->maxLine)this->maxLine=currentLineS;	
		this->compileOutput.insert(std::pair<unsigned int, CompileOutputObject*>(this->errorCount++, new CompileOutputObject(currentLineS, currentColS, currentLineE, currentColE, tempString)));
	}
	else
	{
		warning(l, m);	
	}
}

void Driver::warning(const class location& l,
		   const std::string& m)
{
	unsigned int    currentLineS;
	unsigned int	currentColS;
	unsigned int    currentLineE;
	unsigned int	currentColE;
	std::string		tempString;

	currentLineS=(unsigned int)l.begin.line;
	currentColS=(unsigned int)l.begin.column;
	currentLineE=(unsigned int)l.end.line;
	currentColE=(unsigned int)l.end.column;	
	tempString="";
	tempString+="Line : "+getStdStringFromString(myultoabaseString(currentLineS, 5, 10, ' '))+" Col: "+getStdStringFromString(myultoabaseString(currentColS, 5, 10, ' '))+" "+m+"\r\n";
	if(currentLineS>this->maxLine)this->maxLine=currentLineS;	
	this->compileOutputWarnings.insert(std::pair<unsigned int, CompileOutputObject*>(this->warningCount++, new CompileOutputObject(currentLineS, currentColS, currentLineE, currentColE, tempString)));
	
	//    std::cerr << l << ": " << m << std::endl;
}


void Driver::error(const std::string& m)
{
	this->errorOutput.append(m);
	this->errorOutput.append("\r\n");
	//std::cerr << m << std::endl;
}

} // namespace example
