/* 

	Global Functions, by Mauro Grassi, 2009-2010...

*/

#include <windows.h>
#include <errno.h>
#include <stdio.h>
#include "usb.h"
#include "driver.h"
#include "expression.h"
#include "common.h"
#include <streambuf>
#include <iostream>
#include "global.h"
#include "opcodes.h"
#include "vm.h"

using std::cout;
using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;
using namespace System::IO;
using namespace System::Text;
using namespace System::Runtime::InteropServices;	//Need this to support "unmanaged" code.
using namespace System::Threading;

std::string		myVMOutput;
TIME_T			systemTime;
unsigned char   tempString[SIZE_OF_TEMPSTRING];
unsigned char   tempStringPtr;
unsigned char	timeUp=1;
unsigned short	alarmEvent=0xFFFF;
unsigned short	keyFull=0;
TIME_T			alarmTime;

unsigned char 	serialPipe[MAX_SERIAL_PIPE_LENGTH];
unsigned char	serialPipePutPtr;
unsigned char 	serialPipeGetPtr;
unsigned char	serialPipeStatus;

const unsigned short vmSizes[]
=
{
	/* Start */
	0 +						sizeof(VIRTUAL_MACHINE),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.execID),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.execState),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.execMode),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.CRC),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.lastError),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.IR),
	SIZE_MASK_FOR_FLOAT	+	sizeof(thisUDL.dataLogger.ven.cVM.W),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.time),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.time.secs),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.time.mins),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.time.hours),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.time.day),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.time.month),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.time.year),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.time.wday),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.time.show),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.time.updated),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.DSLIMIT),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.DS),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.SS),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.addressModes),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.PC),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.StackSizePtr),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.lastIndirect),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.execLimit),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.execDone),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.execPriority),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.resetVector),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.RAMImage),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.ROMImage),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.STACKImage),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.FILEImage),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.pipeMode),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.sleepMode),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.fName),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.temp),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.typeMode),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState.serialPort),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState.serialPort.mode),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState.serialPort.txrxpin),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState.serialPort.baudRate),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState.oneWireSerialPort),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState.oneWireSerialPort.mode),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState.oneWireSerialPort.txrxpin),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState.oneWireSerialPort.baudRate),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState.i2cPort),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState.i2cPort.busRate),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState.i2cPort.I2CBuffer),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState.oneWirePort),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState.oneWirePort.mode),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState.oneWirePort.romCode),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.hardwareState.oneWirePort.oneWireBuffer),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSLastRx),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSTxCRC),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSPipe),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSTempString),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSTempPtr),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSNewRx),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSPipePutPtr),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSPipeGetPtr),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSRxCRC),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSPipeState),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSError),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSOutput),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSOutPtr),
	SIZE_MASK_FOR_FLOAT	+	sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSLongitude),
	SIZE_MASK_FOR_FLOAT	+	sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSLatitude),
	SIZE_MASK_FOR_FLOAT	+	sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSSpeed),
	SIZE_MASK_FOR_FLOAT	+	sizeof(thisUDL.dataLogger.ven.cVM.GPS.GPSCourse),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.SPI),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.SPI.mode),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.SPI.ckdidocspin),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.SPI.SPIBuffer),
	SIZE_MASK_FOR_FLOAT	 +	sizeof(thisUDL.dataLogger.ven.cVM.timeSpeed),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.timeOffset),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.timeScaling),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.firstPor),
	0 +						sizeof(thisUDL.dataLogger.ven.cVM.tempPipe),
	0,
};

unsigned char* globalVariablesAddresses[NUM_GLOBAL_VARS]
=
{
	(unsigned char*)INDIRECT_OFFSET,
	(unsigned char*)&tempString[0],
	(unsigned char*)&returnGlobal,
	(unsigned char*)&localUDL.dataLogger.ven,
	(unsigned char*)&localUDL.dataLogger.ven.vmPtr,
	(unsigned char*)&localUDL.dataLogger.ven.vmNum,
	(unsigned char*)&localUDL.dataLogger.ven.vmState,
	(unsigned char*)&localUDL.dataLogger.ven.vmMode,
	(unsigned char*)&localUDL.dataLogger.ven.vmID,
	(unsigned char*)&localUDL.dataLogger.ven.vmSelected,
	(unsigned char*)&localUDL.dataLogger.ven.vmLogFileCache,
	(unsigned char*)&localUDL.dataLogger.ven.vmLogFileName,
	(unsigned char*)&localUDL.dataLogger.ven.vmSleepPeriod,
	(unsigned char*)&localUDL.dataLogger.ven.vmMinimumPeriod,
	(unsigned char*)&localUDL.dataLogger.ven.vmExecLimit,
	(unsigned char*)&localUDL.dataLogger.ven.vmRecoveryTime,
	(unsigned char*)&localUDL.dataLogger.ven.vmMinimumSleepPeriod,
	0
};

const unsigned int monthDayLimits[12]=
{
	31, 
	28, 
	31, 
	30, 
	31, 
	30, 
	31, 
	31, 
	30, 
	31, 
	30,
	31 
};

const char monthNames[12][4]
={ 	
"Jan",
"Feb",
"Mar",
"Apr",
"May",
"Jun",
"Jul",
"Aug",
"Sep",
"Oct",
"Nov",
"Dec"
};

const char weekDays[7][4]={ 	
	"Mon",
	"Tue",
	"Wed",
	"Thu",
	"Fri",
	"Sat",
	"Sun",
};

const int monthDays[11]=
{
31, 
59, 
90, 
120, 
151, 
181, 
212, 
243, 
273, 
304, 
334, 
};


BYTE* myultoa(DWORD Value, BYTE* Buffer, unsigned int setprinted)
{
	BYTE i;
	DWORD Digit;
	DWORD Divisor;
	BOOL  Printed;

	Printed=FALSE;	
	for(i=0, Divisor=1000000000; i<10; i++)
	{
		if(((10-i)==setprinted)||(i==9))Printed=TRUE;
		Digit = Value/Divisor;
		if(Digit||Printed)
		{
			*Buffer++=(BYTE)'0'+(BYTE)Digit;
			Value-=Digit*Divisor;
			Printed=TRUE;
		}
		Divisor/=10;
	}
	*Buffer = '\0';
	return Buffer;
}

unsigned char* uftoa(unsigned char* outstr, float f, int numdec)
{
	int i;
	int j;
	unsigned long k;
	unsigned char iBuffer[16];

	if(numdec>6)numdec=6; else if(numdec<0)numdec=0;
	if(f>=0)
	{ 

	} 
	else 
	{ 
		*outstr++='-'; 
		f=-f; 
	}

	j=numdec;
	while(j>0)
	{
		f*=10.0;
		j--;
	}
	f+=0.5;
	k=(unsigned long)f;
	if(k==0){ iBuffer[0]='0'; iBuffer[1]='\0'; } else myultoa(k, (BYTE*)iBuffer, 0);
	j=stringLength((unsigned char*)iBuffer);
	j-=numdec;
	i=0;
	if(j<1)
	{
		*outstr++='0';
		*outstr++='.';
		j++;
		while(j<1)
		{
			*outstr++='0';
			j++;
		}   
		j=-1; 
	}

	while(iBuffer[i]!='\0')
	{
		if(i==j)*outstr++='.';
		*outstr++=iBuffer[i++];
	}
	*outstr='\0';
	return outstr;
}

unsigned char* ftoa(unsigned char* outstr, float f, int numdec)
{
	int i;
	int j;
	unsigned long k;
	unsigned char iBuffer[16];

	if(numdec>6)numdec=6; else if(numdec<0)numdec=0;
	if(f>=0)
	{ 
		*outstr++='+';
	} 
	else 
	{ 
		*outstr++='-'; 
		f=-f; 
	}

	j=numdec;
	while(j>0)
	{
		f*=10.0;
		j--;
	}

	f+=0.5;
	k=(unsigned long)f;
	if(k==0){ iBuffer[0]='0'; iBuffer[1]='\0'; } else myultoa(k, (BYTE*)iBuffer, 0);
	j=stringLength((unsigned char*)iBuffer);

	j-=numdec;
	i=0;
	if(j<1)
	{
		*outstr++='0';
		*outstr++='.';
		j++;
		while(j<1)
		{
			*outstr++='0';
			j++;
		}   
		j=-1; 
	}

	while(iBuffer[i]!='\0')
	{
		if(i==j)*outstr++='.';
		*outstr++=iBuffer[i++];
	}
	*outstr='\0';
	return outstr;
}

System::String^ myultoabaseString(unsigned long Value, unsigned char setprinted, unsigned char base, unsigned char spaceChar)
{
	unsigned char iBuffer[16];
	System::String^ mString;
								
	myultoabase(Value, iBuffer, setprinted, base, 16, spaceChar);
	mString=getStringFromUnsignedCharArrayAuto(iBuffer);
	return mString;
}

unsigned char* myultoabase(unsigned long Value, unsigned char* Buffer, unsigned char setprinted, unsigned char base, unsigned char maxDigits, unsigned char spaceChar)
{
	unsigned char num;
	unsigned char i;
	unsigned long Digit;
	unsigned long Divisor;
	unsigned char Printed;
	
	switch(base)
	{
		case 2:
			Divisor=0x40000000;
			num=31;
			break;
			
		case 8:
			Divisor=0x40000000;
			num=11;
			break;
		
		default:
		case 10:
			Divisor=100000000;
			num=9;	
			break;
			
		case 16:
			Divisor=0x10000000;
			num=8;
			break;
	}	
	Printed=0;
	i=0;
	while((i<num)&&(i<maxDigits))
	{
		if((num-i)==setprinted)Printed=1;
		if(i==(num-1))Printed=2;
		Digit=Value/Divisor;
		if((Digit==0)&&(Printed==1))
		{
			*Buffer++=spaceChar;
		}
		else
		if(Digit||Printed)
		{
			if((Digit>=0)&&(Digit<=9))
			{
				*Buffer++='0'+(BYTE)Digit;
			}
			else
			if((Digit>=10)&&(Digit<=15))
			{
				*Buffer++='A'+(BYTE)Digit-10;
			}
			Value-=Digit*Divisor;
			Printed=2;
		}
		Divisor/=base;
		i++;
	}
	*Buffer='\0';
	return Buffer;
}

System::String^ showCache(CACHE_OBJECT* cObj)
{
	System::String^ outputString;

	outputString="";
	//outputString+="Cache Sz: 0x"+HexToString(cObj->cacheSize, 2)+" Max: 0x"+HexToString(cObj->cacheMaxAddress, 2)+" B: 0x"+HexToString(cObj->bottomAddress, 2)+" T: 0x"+HexToString(cObj->topAddress, 2)+" \r\n";
	outputString+="H: "+formatStringFloat((double)cObj->cacheHits, 0)+" M: "+formatStringFloat((double)cObj->cacheTotal-(double)cObj->cacheHits, 0)+" P: "+formatStringFloat((double)cObj->cacheArgs.cachePerformance, 2)+"%\r\n";
	return outputString;
}

System::String^ showArgument(VM_ARGUMENT* varg)
{
	System::String^ outputString;

	outputString="";
	outputString+="Arg. Opcode: 0x"+HexToString(varg->opcode, 1)+" Type: 0x"+HexToString(varg->type, 1)+" bArg: 0x"+HexToString(varg->arg.bArg, 1)+" nArg: 0x"+HexToString(varg->arg.nArg, 2)+" \r\n";
	outputString+="fArg: "+formatStringFloat((double)varg->arg.fArg, 3)+"\r\n";
	return outputString;
}

System::String^ showVM(VIRTUAL_MACHINE* vm)
{
	System::String^ outputString;

	outputString="";
	outputString+="VM ID: 0x"+HexToString(vm->execID, 1)+" State: 0x"+HexToString(vm->execState, 1)+" Error: 0x"+HexToString(vm->lastError, 1)+"\r\n";
	outputString+="PC: 0x"+HexToString(vm->PC, 4)+" W: "+formatStringFloat((double)vm->W, 5)+" IR: 0x"+HexToString(vm->IR, 1)+" ST: 0x"+HexToString(vm->StackSizePtr, 2)+"\r\n";
	outputString+="ExecLimit: 0x"+HexToString(vm->execLimit, 2)+" ExecDone: "+formatStringFloat((double)vm->execDone, 0)+"\r\n";
	outputString+=showArgument(&argument);
	outputString+="Stack Cache: \r\n";
	outputString+=showCache(&vm->STACKImage);
	outputString+="RAM Cache: \r\n";
	outputString+=showCache(&vm->RAMImage);
	outputString+="ROM Cache: \r\n";
	outputString+=showCache(&vm->ROMImage);
	return outputString;
}

System::String^ HexToString(unsigned long input, unsigned char bytes)
{
	System::String^ returnString;
	wchar_t returnArray[9];

	unsigned char i;
	unsigned char c;

	for(i=0;i<9;i++)
	{
		returnArray[i]='0';
	}

	for(i=0;i<bytes*2;i++)
	{
		c = (unsigned char)(input & 0x0000000F);

		if(c <= 9)
		{
			returnArray[7-i]=c+'0';
		}
		else 
		{
			returnArray[7-i]=c+'A'-10;
		}

		input >>= 4;
	}
	returnArray[9] = 0;
	returnString = gcnew System::String(returnArray);
	returnString = returnString->Substring(8-(bytes*2),bytes*2);
	return returnString;
}

System::String^ formatStringFloat(double f, int numdec)
{
	int j, i, n, padding;
	System::String^ resultString;
	float rounding;

	if(numdec<0)
	{
		numdec=-numdec;
		padding=1;
	} else padding=0;
	if(numdec>5)numdec=5; 
	if((numdec>0)&&(numdec<=3))
	{
		rounding=0.5;
		i=numdec;
		while(i>0)
		{
			rounding/=10.0;
			i--;
		}
		f+=rounding;
	}

	if((f<(double)MIN_F)&&(f>-(double)MIN_F))f=0.0;
	resultString=System::Convert::ToString(f);
	if(resultString=="Infinity")return resultString;
	j=resultString->IndexOf(".");
	n=resultString->Length;
	if(j<0)
	{ 
		if(numdec>0)
		{
			resultString=resultString->Insert(n, "."); 
			n++; 
		}
		j=n-1; 
	}
	i=n-j-1;
	if(i>numdec)
	{
		// delete some characters from the end of the string...
		if(numdec>0)n-=(i-numdec); else n-=(1+i);
		resultString=resultString->Substring(0, n);
	}
	else
		if(i<numdec)
		{
			// add zeros to the end of the string...
			resultString=resultString->PadRight(n+numdec-i, '0');	
		}
		if(padding)
		{   
			while(resultString->Length<5)
			{
				// assumes 4+1 (the 1 for the '.')
				resultString=resultString->Insert(0, "0");
			}
		}
		return resultString;
}

System::String^ formatStringHex(unsigned long x)
{
	if((x>=0)&&(x<=0xFF))
	{
	 return HexToString(x, 1);
	
	}
	else
	if((x>=0x100)&&(x<=0xFFFF))
	{
	 return HexToString(x, 2);
	}
	else
	{
	 return HexToString(x, 4);
	}
}

System::String^ formatStringConstant(double f, int numdec)
{
	long x;
	
	x=(long)f;
	
	if((double)x==f)
	{	
		return formatStringFloat(f, 0)+", 0x"+formatStringHex((unsigned long)x);
	}
	else
	{
		return formatStringFloat(f, numdec);	
	}
}

System::String^ formatStringFileSize(double f)
{
	System::String^ resultString;

	if((f>=0)&&(f<1000))
	{
		resultString=formatStringFloat(f, 0)+" B";
	}
	else
		if(f<(1000*1000))
		{
			resultString=formatStringFloat(f/1000.0, 2)+" KB";
		}
		else
			if(f<(1000*1000*1000))
			{
				resultString=formatStringFloat(f/(1000.0*1000.0), 2)+" MB";
			}
			else
			{
				resultString=formatStringFloat(f/(1000.0*1000.0*1000.0), 2)+" GB";
			}
			return resultString;
}

System::String^ getStringFromUnsignedCharArray(unsigned char* inarray, unsigned int numchars)
{
	wchar_t internalArray[2];
	System::String^ response;
	response="";
	while(numchars--)
	{
		internalArray[0]=(wchar_t)*inarray++;
		internalArray[1]=(wchar_t)'\0';
		response+=gcnew System::String((wchar_t*)&internalArray[0]);
	}
	return response;
}

System::String^ getStringFromUnsignedCharArrayUpTo(unsigned char* inarray, unsigned int numchars)
{
	wchar_t internalArray[2];
	System::String^ response;
	response="";
	internalArray[0]=1;
	while((numchars--)&&(internalArray[0]!='\0'))
	{
		internalArray[0]=(wchar_t)*inarray++;
		internalArray[1]=(wchar_t)'\0';
		response+=gcnew System::String((wchar_t*)&internalArray[0]);
	}
	return response;
}

unsigned char* getUnsignedCharArrayFromString(unsigned char* outarray, System::String^ instring)
{
	unsigned char c;
	int i;

	i=0;
	while(i<instring->Length)
	{
		c=(unsigned char)instring[i];
		*outarray++=c;
		i++;
	}
	*outarray='\0';
	return outarray;
}

unsigned char* getUnsignedCharPathFromString(unsigned char* outpath, unsigned char* outfilename, System::String^ instring, int index, int maxChars)
{
	unsigned char c;
	int i;
	int li;
	int max;

	if(instring->Length>=index)
		max=instring->Length-index;
	else
		max=instring->Length;

	i=0;
	li=0;
	c=' ';
	while((i<max)&&(maxChars>0))
	{
		c=(unsigned char)instring[i];
		if((c!='[')&&(c!=']'))
		{
			*outpath++=c;
			maxChars--;
			if(c=='\\')
			{
				li=0;
			}
			else
			{
				outfilename[li++]=c;
			}
		}
		i++;
	}
	if((c=='\\')&&(i>0))outpath--;
	*outpath='\0';
	outfilename[li]='\0';
	return outpath;
}

System::String^ getFileNameFromPath(System::String^ path)
{
	int i;

	i=path->IndexOf("\\");
	while(i>=0)
	{	
		path=path->Substring(i+1);
		i=path->IndexOf("\\");
	}
	return path;
}

System::String^ getPathOnly(System::String^ path)
{	
	int i, j;
	System::String^ instring;

	instring=path;
	i=path->IndexOf("\\");
	j=0;
	while(i>=0)
	{
		j+=(i+1);
		path=path->Substring(i+1);
		i=path->IndexOf("\\");
	}
	return instring->Substring(0, j);
}

int getUnsignedCharArrayFromStringMax(unsigned char* outarray, System::String^ instring, int maximum)
{
	unsigned char c;
	int i;
	i=0;
	while((i<instring->Length)&&(i<maximum))
	{
		c=(unsigned char)instring[i];
		*outarray++=c;
		i++;
	}
	*outarray='\0';
	return i;
}

System::String^ getStringFromUnsignedCharArrayAuto(unsigned char* inarray)
{
	wchar_t internalArray[2];
	System::String^ response;
	response="";
	while((*inarray)!='\0')
	{
		internalArray[0]=(wchar_t)*inarray++;
		internalArray[1]=(wchar_t)'\0';
		response+=gcnew System::String((wchar_t*)&internalArray[0]);
	}
	return response;
}

System::String^ getStringFromStdString(std::string* instring)
{
	wchar_t internalArray[2];
	System::String^ response;
	int i;
	i=0;
	internalArray[0]=(wchar_t)(*instring)[i++];
	internalArray[1]=(wchar_t)'\0';
	response="";
	while((internalArray[0])!='\0')
	{
		response+=gcnew System::String((wchar_t*)&internalArray[0]);
		internalArray[0]=(wchar_t)(*instring)[i++];
	}
	return response;
}

std::string getStdStringFromString(System::String^ instring)
{
	std::string result;
	char c;
	int i;
	i=0;
	result="";
	while(i<instring->Length)
	{
		c=(char)instring[i];
		result+=(char)c;
		i++;
	}
	result[i]='\0';
	return result;
}

System::String^ digitString(int digit)
{
	System::String^ response;

	switch(digit)
	{
	case 0:
		response="0";
		break;

	case 1:
		response="1";
		break;

	case 2:
		response="2";
		break;

	case 3:
		response="3";
		break;

	case 4:
		response="4";
		break;

	case 5:
		response="5";
		break;

	case 6:
		response="6";
		break;

	case 7:
		response="7";
		break;

	case 8:
		response="8";
		break;

	case 9:
		response="9";
		break;
	}
	return response;
}

System::String^ myultoa(DWORD Value, unsigned int setprinted)
{
	System::String^ response;
	BYTE i;
	DWORD Digit;
	DWORD Divisor;
	BOOL  Printed;

	response="";
	Printed=FALSE;
	for(i=0, Divisor=1000000000; i<10; i++)
	{
		if(((10-i)==setprinted)||(i==9))Printed=TRUE;
		Digit = Value/Divisor;
		if(Digit||Printed)
		{
			response+=digitString(Digit);
			Value-=Digit*Divisor;
			Printed=TRUE;
		}
		Divisor/=10;
	}
	return response;
}

int stringLength(unsigned char* instr)
{
	int i;
	i=0;
	while((*instr)!='\0')
	{
		i++;
		instr++;
	}
	return i;
}

unsigned char* pointEndString(unsigned char* instr)
{
	// returns pointer to the end of the string
	while((*instr)!='\0')
	{
		instr++;
	}
	return instr;
}

int compareString(unsigned char* first, unsigned char* second, int maxsize)
{
	unsigned char c1, c2;
	int v;
	int i;

	i=0;
	do 
	{
		c1=*first++;
		c2=*second++;
		v=(unsigned int)c1-(unsigned int)c2;
		i++;
	} while ((v==0)&&(c1!='\0')&&(i<maxsize));
	return v;
}

int findInString(unsigned char* first, unsigned char* second, int lengthOfSecondString, int maxsize)
{
	/* find first occurrence in first string of second string up to maxsize chars */
	int i, j;

	i=0;
	j=-1;
	while((first[i]!='\0')&&(i<maxsize))
	{
		if(!compareString(&first[i], second, lengthOfSecondString))
		{
			j=i;
			break;
		}
		i++;
	}
	return j;	
}

unsigned char convertToUpper(unsigned char in)
{
	if((in>='a')&&(in<='z'))return in-0x20; 
	return in;
}

int compareStringCaseInsensitive(unsigned char* first, unsigned char* second, int maxsize)
{
	unsigned char c1, c2;
	int v;
	int i;
	i=0;
	do 
	{
		c1=convertToUpper(*first);
		c2=convertToUpper(*second);
		first++;
		second++;
		v=(unsigned int)c1-(unsigned int)c2;
		i++;
	} while ((v==0)&&(c1!='\0')&&(i<maxsize));
	return v;
}

unsigned char* appendString(unsigned char* first, unsigned char* second, int maxsize)
{
	// append second string to the end of first string (maximum maxsize characters)
	unsigned char* outstr;
	int i;

	outstr=pointEndString(first);
	i=(int)(outstr-first);
	while((i<maxsize)&&((*second)!='\0'))
	{
		*outstr++=*second++;
		i++;					  
	}
	*outstr='\0';
	return first;
}

unsigned char* copyString(unsigned char* first, unsigned char* second)
{
	// copy second string to first
	while((*second)!='\0')
	{
		*first++=*second++;
	}
	*first='\0';
	return first;
}

unsigned char* copyStringRom(unsigned char* first, const unsigned char* second)
{
	// copy second string to first
	while((*second)!='\0')
	{
		*first++=*second++;
	}
	*first='\0';
	return first;
}

unsigned char* copyStringLimited(unsigned char* first, unsigned char* second, int maxsize)
{
	// copy second string to first up to maxsize characters
	int i;

	i=0;
	while((i<maxsize)&&((*second)!='\0'))
	{
		*first++=*second++;
		i++;
	}
	*first='\0';
	return first;
}

unsigned long myatol(unsigned char* instr)
{
	unsigned long l;
	char c;

	l=0;
	while(*instr!='\0')
	{
		c=*instr++;
		if((c>='0')&&(c<='9'))
		{
			l*=10;
			l+=c-'0';
		}
	}
	return l;
}

unsigned int convertBCDToDecimal(unsigned int bcdValue)
{
	unsigned int x;
	x=0;
	x=((bcdValue>>4)&0x0F)*10;
	x+=(bcdValue&0x0F);
	return x;
}

unsigned int convertDecimalToBCD(unsigned int decValue)
{
	unsigned int x;

	x=0x0F & (decValue/10);
	x=x<<4;
	x+=(decValue % 10);
	return (x & 0xFF);
}

unsigned int isLeapYear(unsigned int iyear)
{
	// returns TRUE if iyear is a leap year, FALSE otherwise
	int i, j;

	if(iyear>=1970)
	{
		i=(iyear%4);
		if(i!=0)return 0;	// since not divisible by 4
		i=(iyear%100);
		if(i!=0)return 1;
		/* here it is divisible by 4 and 100 but not necessarily by 400! */
		j=(iyear%400);
		if(j==0)return 1; else return 0;
	}
	return 0;
}

unsigned int daysInMonth(unsigned int month, unsigned int year)
{
	unsigned int i;

	if(month<1)month=1; else if(month>12)month=12;
	if(isLeapYear(year)&&(month==2))i=1; else i=0;
	return i+monthDayLimits[month-1];
}

void convertToHoursMins(TIME_T* inTime, float f, int base)
{
	int i;
	int h, m;

	i=(int)f;
	if(i<0)i=0; else if(i>=9999)i=9999;
	h=(i/base);
	m=(i%base);
	inTime->hours=h;
	inTime->mins=m;	
}

float convertFromHoursMins(TIME_T* inTime, int base)
{
	return (float)((inTime->hours*base)+(inTime->mins));
}

unsigned long getTotalDays(unsigned int day, unsigned int month, unsigned int year)
{
	/* 
	return the day of the week from the day, month and year information 
	We know that 1 January 1970 was a Thursday
	We need to know how many days have elapsed since 1 January 1970...		
	*/
	unsigned int N4, N100, N400, j, i;
	unsigned long totalDays;
	if(year>=1970)
	{
		N4=(unsigned int)((year-1969)/4);
		N100=(unsigned int)((year-1901)/100);
		N400=(unsigned int)((year-1601)/400);
		totalDays=(year-1970)*365+N4-N100+N400;
		month=month-1;
		i=isLeapYear(year);
		while(month>0)
		{
			if(month==2)j=monthDayLimits[1]+i; else if(month<=12)j=monthDayLimits[month-1]; else return 0;
			totalDays+=j;
			month--;
		}	
		totalDays+=(day-1);
		return totalDays;
	}
	return 0;
}

unsigned int getWeekDay(unsigned int day, unsigned int month, unsigned int year)
{
	return ((getTotalDays(day, month, year)+3)%7);
}

unsigned long getTotalSeconds(TIME_T* timet)
{
	/* get total seconds from the EPOCH time */
	unsigned long days;
	unsigned long totalSeconds;

	days=getTotalDays(timet->day, timet->month, timet->year);
	totalSeconds=86400*days;
	totalSeconds+=(3600*timet->hours);
	totalSeconds+=(60*timet->mins);
	totalSeconds+=timet->secs;
	return totalSeconds;
}

System::String^ getMonthString(int month)
{
	System::String^ response;

	response="";
	switch(month)
	{
	default:
	case 0:
		response="Jan";
		break;
	case 1:
		response="Feb";
		break;
	case 2:
		response="Mar";
		break;
	case 3:
		response="Apr";
		break;
	case 4:
		response="May";
		break;
	case 5:
		response="Jun";
		break;
	case 6:
		response="Jul";
		break;

	case 7:
		response="Aug";
		break;

	case 8:
		response="Sep";
		break;

	case 9:
		response="Oct";
		break;

	case 10:
		response="Nov";
		break;

	case 11:
		response="Dec";
		break;
	}
	return response;
}

System::String^ getWeekDayString(int wday)
{
	System::String^ response;

	response="";
	switch(wday)
	{
	default:
	case 0:
		response="Mon";
		break;
	case 1:
		response="Tue";
		break;
	case 2:
		response="Wed";
		break;
	case 3:
		response="Thu";
		break;
	case 4:
		response="Fri";
		break;
	case 5:
		response="Sat";
		break;
	case 6:
		response="Sun";
		break;
	}
	return response;
}

System::String^ ascTimeString(TIME_T* timet)
{
	return internalAscTimeString(timet, 0);
}

System::String^ getTimeString(TIME_T* sysTime)
{
	return ascTimeString(sysTime); 
}

unsigned char* ascTimeFileName(unsigned char* instr, TIME_T* timet)
{
	BYTE* outstr;
	/* 
		convert a TIME_T structure to a string suitable for a filename...
	*/
	
	outstr=instr;
	if(timet->show & SHOW_YEAR)outstr=myultoa(timet->year, outstr, 4);
	if(timet->show & SHOW_MONTH)outstr=myultoa(timet->month, outstr, 2);
	if(timet->show & SHOW_DAY)outstr=myultoa(timet->day, outstr, 2);
	if(timet->show & SHOW_HOURS)outstr=myultoa(timet->hours, outstr, 2);
	if(timet->show & SHOW_MINUTES)outstr=myultoa(timet->mins, outstr, 2);
	if(timet->show & SHOW_SECONDS)outstr=myultoa(timet->secs, outstr, 2);
	*outstr='\0';
	return outstr;
}

unsigned long getDuration(TIME_T* timeOne, TIME_T* timeTwo)
{
	/* get seconds between two times disregarding dates */
	long total;
	int x;

	total=0;
	if(timeTwo)
	{
		if(timeOne->hours>=timeTwo->hours)x=(timeOne->hours-timeTwo->hours); else x=24+(timeOne->hours-timeTwo->hours);
		total+=(long)(x*24*60);
		x=(timeOne->mins-timeTwo->mins);
		total+=(long)(x*60);
		x=(timeOne->secs-timeTwo->secs);
		total+=(long)x;
	}
	else
	{
		x=(timeOne->hours);
		total+=(long)(x*24*60);
		x=(timeOne->mins);
		total+=(long)(x*60);
		x=(timeOne->secs);
		total+=(long)x;	
	}
	if(total<0)total=-total;
	return (unsigned long)total;
}

unsigned long getDurationTotalSeconds(TIME_T* timeOne, TIME_T* timeTwo)
{
	unsigned long seconds1;
	unsigned long seconds2;

	seconds1=getTotalSeconds(timeOne);
	seconds2=getTotalSeconds(timeTwo);
	if(seconds1>=seconds2)
	{
		return seconds1-seconds2;
	}
	else
	{
		return seconds2-seconds1;
	}
	return 0;
}

int compareTimes(TIME_T* timeOne, TIME_T* timeTwo)
{
	/* returns 0 if equal, 1 if timeOne is after timeTwo, -1 if timeTwo is after timeOne */
	if(timeOne->show & SHOW_YEAR)
	{
		/* compare years */
		if(timeOne->year>timeTwo->year)return 1;
		else
			if(timeTwo->year>timeOne->year)return -1;	
	}

	if(timeOne->show & SHOW_MONTH)
	{
		/* compare months */
		if(timeOne->month>timeTwo->month)return 1;	
		else
			if(timeTwo->month>timeOne->month)return -1;	
	}

	if(timeOne->show & SHOW_DAY)
	{
		/* compare days */
		if(timeOne->day>timeTwo->day)return 1;	
		else
			if(timeTwo->day>timeOne->day)return -1;	
	}

	if(timeOne->show & SHOW_HOURS)
	{
		/* compare hours */
		if(timeOne->hours>timeTwo->hours)return 1;	
		else
			if(timeTwo->hours>timeOne->hours)return -1;	
	}

	if(timeOne->show & SHOW_MINUTES)
	{
		/* compare mins */
		if(timeOne->mins>timeTwo->mins)return 1;
		else
			if(timeTwo->mins>timeOne->mins)return -1;	
	}

	if(timeOne->show & SHOW_SECONDS)
	{
		/* compare seconds */
		if(timeOne->secs>timeTwo->secs)return 1;	
		else
			if(timeTwo->secs>timeOne->secs)return -1;	
	}
	return 0;
}

System::String^ getDurationString(double floatSeconds, int printed)
{
	/* 

		Update the time string with seconds in double...

	*/
	
	System::String^ outstr;
	unsigned long days;
	unsigned int hours;
	unsigned int minutes;
	unsigned int seconds;
	unsigned char sign;
	
	outstr="";
	
	if(floatSeconds<0.0)
	{
		floatSeconds=-floatSeconds;
		sign=1;
	}  
	else
	{
		sign=0;
	}
	
	days=(unsigned long)(floatSeconds/86400.0);
	floatSeconds-=((double)days*86400.0);
	hours=(unsigned int)(floatSeconds/3600.0);
	floatSeconds-=((double)hours*3600.0);
	minutes=(unsigned int)(floatSeconds/60.0);
	floatSeconds-=((double)minutes*60.0);
	seconds=(unsigned int)(floatSeconds);
	if((days>0)||(printed))
	{
		if(sign)
		{
		outstr+="-";
		sign=0;
		}
		outstr=myultoa((long)days, 0);
		outstr+="d ";
		printed=1;
	}

	if((hours>0)||(printed))
	{
		if(sign)
		{
		outstr+="-";
		sign=0;
		}
		outstr+=myultoa((long)hours, 0);
		outstr+="h ";
		printed=1;
	}

	if((minutes>0)||(printed))
	{
		if(sign)
		{
		outstr+="-";
		sign=0;
		}
		outstr+=myultoa((long)minutes, 0);
		outstr+="m ";
		printed=1;
	}
	if(sign)
	{
	outstr+="-";
	sign=0;
	}
	outstr+=myultoa((long)seconds, 0);
	outstr+="s";
	return outstr;
}


System::Void createPath(System::String^ pathName)
{
	System::String^ pathOnly;

	pathOnly=getPathOnly(pathName);
	if(Directory::Exists(pathOnly))
	{

	}
	else
	{
		try
		{
			Directory::CreateDirectory(pathOnly);
		}
		catch(...)
		{

		}
	}
}

System::String^ getPCLocalTimeString(void)
{
	System::String^ result;
	System::DateTime d1=System::DateTime::Now;

	result+=myultoa((DWORD)d1.Hour, 2);
	result+=":";
	result+=myultoa((DWORD)d1.Minute, 2);
	result+=":";
	result+=myultoa((DWORD)d1.Second, 2);
	//result+=".";
	//result+=formatStringFloat((float)d1.Millisecond, 0);
	result+=": ";
	return result;
}

System::String^ getTimeFileString(void)
{
	System::String^ result;
	System::DateTime d1=System::DateTime::Now;

	result="";
	result+=myultoabaseString((unsigned long)d1.Year, 4, 10, '0');
	result+=myultoabaseString((unsigned long)d1.Month % 100, 2, 10, '0');
	result+=myultoabaseString((unsigned long)d1.Day % 100, 2, 10, '0');
	result+=".";
	result+=myultoabaseString((unsigned long)d1.Hour, 2, 10, '0');
	result+=myultoabaseString((unsigned long)d1.Minute, 2, 10, '0');
	result+=myultoabaseString((unsigned long)d1.Second, 2, 10, '0');

	return result;
}

System::String^ getTimeFileStringDate(void)
{
	System::String^ result;
	System::DateTime d1=System::DateTime::Now;

	result="";
	result+=myultoabaseString((unsigned long)d1.Year % 100, 2, 10, '0');
	result+=myultoabaseString((unsigned long)d1.Month % 100, 2, 10, '0');
	result+=myultoabaseString((unsigned long)d1.Day % 100, 2, 10, '0');
	return result;
}

void getLocalTimePC(TIME_T* secondSystemTime)
{
	SYSTEMTIME	mySystemTime;
	GetLocalTime(&mySystemTime);			
	secondSystemTime->secs=(unsigned char)mySystemTime.wSecond;
	secondSystemTime->mins=(unsigned char)mySystemTime.wMinute;
	secondSystemTime->hours=(unsigned char)mySystemTime.wHour;
	secondSystemTime->day=(unsigned char)mySystemTime.wDay;
	secondSystemTime->month=(unsigned char)mySystemTime.wMonth;
	secondSystemTime->year=mySystemTime.wYear;
	secondSystemTime->wday=(unsigned char)mySystemTime.wDayOfWeek;
}

unsigned long scaleTimeSeconds(double timeSpeed, unsigned long offset, unsigned long timeToScale)
{
	double x;
	
	x=(((double)timeToScale-(double)offset)*(double)timeSpeed)+(double)offset;
	return (unsigned long)x;
}

void convertEpoch2TimeInternal(unsigned long epochTime, TIME_T* dest)
{
    int correction;
    int i;
    int years;
    char month;
    unsigned long day;
    int hours;
    int mins;
    int secs;
    unsigned long x;
    int yday;
    int monthday;
        
    // this function only works for 1970 epoch and only for years before 2100...
    // day is the number of days elapsed

    day = (unsigned long)((unsigned long)epochTime/(unsigned long)86400);
    // x is the remainder
    x = (unsigned long)((unsigned long)epochTime - (unsigned long)86400*(unsigned long)day);
    hours = (int) (x/3600);
    x = x - (unsigned long)3600 * (unsigned long)hours;
    mins = (int) (x/60);
    secs = (int) (x - (unsigned long)60 * (unsigned long)mins);
    years = (int)(((float)day)/(float)365.0);
    // first approximation for years...
    // yday is the day of the year...
    yday=(int)((unsigned long)day - (unsigned long)(((float)365.25*(float)years)+(float)0.25))+1;
    if(years>=131)yday++; // correction for the year 2100 which is not a leap year...
    if(yday<=0)
    { 
    years--; 
    yday+=365; 
    if(isLeapYear(1970+years))yday++;
    }
    if(isLeapYear(1970+years))correction=1; else correction=0;  
    i=10;
    while(i>0)
    {
        if(yday>(monthDays[i]+correction))break;
        i--;
    }    
    month=2+i;
    if(yday<=31)month=1;
    if(i==0)correction=0;
    if(month>1)monthday=yday-monthDays[i]-correction; else monthday=yday;
    dest->wday =(int)(((long)day+3)%7);
	dest->year= years+1970;
	dest->month = month;
	dest->day = monthday;
	dest->hours = hours;
	dest->mins = mins;
	dest->secs = secs;
}

void scaleTime(double timeSpeed, unsigned long offset, TIME_T* timeToScale)
{
	unsigned long absolute;
	
	absolute=getTotalSeconds(timeToScale);
	absolute=scaleTimeSeconds(timeSpeed, offset, absolute);
	convertEpoch2TimeInternal(absolute, timeToScale);
}

void getLocalTimePCScaled(double timeSpeed, unsigned long offset, TIME_T* secondSystemTime)
{
	SYSTEMTIME	mySystemTime;
	GetLocalTime(&mySystemTime);	
	secondSystemTime->secs=(unsigned char)mySystemTime.wSecond;
	secondSystemTime->mins=(unsigned char)mySystemTime.wMinute;
	secondSystemTime->hours=(unsigned char)mySystemTime.wHour;
	secondSystemTime->day=(unsigned char)mySystemTime.wDay;
	secondSystemTime->month=(unsigned char)mySystemTime.wMonth;
	secondSystemTime->year=mySystemTime.wYear;
	secondSystemTime->wday=(unsigned char)mySystemTime.wDayOfWeek;
	scaleTime(timeSpeed, offset, secondSystemTime);		

}

void getTimeScaled(double timeSpeed, unsigned long offset, TIME_T* sTime)
{
	SYSTEMTIME	mySystemTime;
	GetLocalTime(&mySystemTime);			
	sTime->secs=(unsigned char)mySystemTime.wSecond;
	sTime->mins=(unsigned char)mySystemTime.wMinute;
	sTime->hours=(unsigned char)mySystemTime.wHour;
	sTime->day=(unsigned char)mySystemTime.wDay;
	sTime->month=(unsigned char)mySystemTime.wMonth;
	sTime->year=mySystemTime.wYear;
	sTime->wday=(unsigned char)mySystemTime.wDayOfWeek;
	scaleTime(timeSpeed, offset, sTime);		
}	

System::String^ getFileNameRoot(System::String^ infilename)
{
	int index;

	index=infilename->IndexOf(".");
	if(index>=0)
	{
		return infilename->Substring(0, index);
	}
	else
	{	
		return infilename;
	}
}

System::String^ getFileNameExtension(System::String^ infilename)
{
	int index;

	index=0;
	while(index>=0)
	{
		index=infilename->IndexOf(".");
		infilename=infilename->Substring(index+1, infilename->Length-index-1);
	}
	infilename=getFileNameFromPath(infilename);
	if(infilename=="")infilename="*";
	return infilename;
}

int ReadFile(System::String^ fileName, unsigned int offset, unsigned char* ptr, unsigned int size, unsigned int* done)
{
	FileStream ^fileSupportStreamReader;
	long long aoffset;

	*done=0;
	if(File::Exists(fileName))
	{
		try
		{
			fileSupportStreamReader = gcnew FileStream(fileName, FileMode::Open);
		}
		catch(...)
		{
			if(fileSupportStreamReader)
			{
				delete fileSupportStreamReader;
			}
			return 0;
		}
		aoffset=(long long)offset;
		aoffset=fileSupportStreamReader->Seek(aoffset, System::IO::SeekOrigin::Begin);
		while((ptr)&&(size--)&&(aoffset<(long long)fileSupportStreamReader->Length))
		{
			*ptr++=(unsigned char)fileSupportStreamReader->ReadByte();
			(*done)++;
			aoffset++;
		}
		fileSupportStreamReader->Close();
	}
	else
	{
		return 0;
	}
	return 1;
}

int WriteFile(System::String^ fileName, unsigned int offset, unsigned char* ptr, unsigned int size, unsigned int* done) 
{			

	*done=0;
	FileStream ^fileSupportStreamWriter;

	createPath(fileName);
	try
	{
		fileSupportStreamWriter = gcnew FileStream(fileName, FileMode::OpenOrCreate);
	}
	catch(...)
	{
		if(fileSupportStreamWriter)
		{
			delete fileSupportStreamWriter;
		}
		return 0;
	}
	fileSupportStreamWriter->Seek(offset, System::IO::SeekOrigin::Begin);
	while((ptr)&&(size--))
	{
		fileSupportStreamWriter->WriteByte(*ptr++);
		(*done)++;
	}
	fileSupportStreamWriter->Close();
	return 1;
}

int WriteFileCreate(System::String^ fileName, unsigned int offset, unsigned char* ptr, unsigned int size, unsigned int* done) 
{			
	/* same as Write File but delete the file if it exists first */
	*done=0;
	createPath(fileName);
	if(System::IO::File::Exists(fileName))
	{
		try
		{
			System::IO::File::Delete(fileName);
		}
		catch(...)
		{
		
		
		}
	}
	return WriteFile(fileName, offset, ptr, size, done);
}

int TruncateFileAt(System::String^ fileName, unsigned int offset)
{
	FileStream ^fileSupportStreamWriter;

	createPath(fileName);
	try
	{
		fileSupportStreamWriter = gcnew FileStream(fileName, FileMode::OpenOrCreate);
	}
	catch(...)
	{
		if(fileSupportStreamWriter)
		{
			delete fileSupportStreamWriter;
		}
		return 0;
	}
	fileSupportStreamWriter->SetLength((System::Int64)offset);
	fileSupportStreamWriter->Close();
	return 1;
}

unsigned long getFileSize(System::String^ instring)
{
	unsigned long result;
	
	result=0;
	if(System::IO::File::Exists(instring))
	{
		System::IO::FileInfo^ fileInfo=gcnew System::IO::FileInfo(instring);
		result=(unsigned long)fileInfo->Length;
	}
	return result;
}

int WriteFileFromString(System::String^ fileName, System::String^ instring) 
{			
	StreamWriter ^fileSupportStreamWriter;

	createPath(fileName);
	try
	{
		fileSupportStreamWriter = gcnew StreamWriter(fileName, false);
	}
	catch(...)
	{
		return 0;
	}
	try
	{
	fileSupportStreamWriter->Write(instring);
	fileSupportStreamWriter->Close();
	}
	catch(...)
	{
	
	}
	return 1;
}

System::String^ ReadStringFromFile(System::String^ fileName) 
{			
	System::String^ resultString;	
	StreamReader ^fileSupportStreamReader;

	resultString="";
	try
	{
		fileSupportStreamReader = gcnew StreamReader(fileName, false);
	}
	catch(...)
	{
		return resultString;
	}
	
	while(!fileSupportStreamReader->EndOfStream)
	{
		try
		{
			resultString+=fileSupportStreamReader->ReadLine()+"\r\n";
		}
		catch(...)
		{
			break;	
		}
	}

	try
	{
		fileSupportStreamReader->Close();
	}
	catch(...)
	{
	
	}
	return resultString;
}

System::String^ WriteFileFromStringWithDialog(int* result, System::String^ instring) 
{			
	FileStream ^fileSupportFileStream;
	StreamWriter ^fileSupportStreamWriter;
	SaveFileDialog^ dialog_ExportHex;

	*result=0;			
	dialog_ExportHex= gcnew(SaveFileDialog);
	dialog_ExportHex->Filter= "Text files (*.txt)|*.txt|All files (*.*)|*.*";
	//Open a show dialog box for the "Save As" for the hex file
	if (dialog_ExportHex->ShowDialog() == ::System::Windows::Forms::DialogResult::OK)
	{
		try
		{
			//Try to create a write stream to the specified file
			createPath(dialog_ExportHex->FileName);
			fileSupportStreamWriter = gcnew StreamWriter(dialog_ExportHex->FileName,false);
		}
		catch(...)
		{
			//If there was an error, print it out and delete any created 
			//  objects
			//PRINT_STATUS(gcnew String(str));

			if(fileSupportFileStream)
			{
				delete fileSupportFileStream;
			}
			//There was an error
			return "";
		}

		fileSupportStreamWriter->Write(instring);
		// Write the end of file command, close the file, and notify the user
		fileSupportStreamWriter->Close();
		*result=1;
		return dialog_ExportHex->FileName;
	}
	else
	{
		return "";
	}
	return "";
}

System::String^ OpenFileToString(int* result, System::String^ *outfilename) 
{
	String^ responseString;
	String ^fileSupportBuffer;
	FileStream ^fileSupportFileStream;
	StreamReader ^fileSupportStreamReader;
	Stream^ myStream;

	*result=0;
	responseString="";
	*outfilename="";
	OpenFileDialog^ openFileDialog1 = gcnew OpenFileDialog;
	openFileDialog1->Filter = "All Text files (*.txt)|*.txt";
	openFileDialog1->FilterIndex = 1;
	openFileDialog1->RestoreDirectory = true;

	// Try to delete any previous file objects if they exist
	try
	{
		if(fileSupportFileStream)
		{
			delete fileSupportFileStream;
		}
	}catch(...){}

	try
	{
		if ( fileSupportStreamReader )
		{
			fileSupportStreamReader->Close();
			delete (IDisposable^)fileSupportStreamReader;
		}
	}catch(...){}

	// Open the dialog
	if (openFileDialog1->ShowDialog() == ::System::Windows::Forms::DialogResult::OK)
	{
		//if they pressed OK and a file was selected
		if ( (myStream = openFileDialog1->OpenFile()) != nullptr )
		{
			//If there was a file selected
			try
			{
				//Try to open the file to read
				fileSupportFileStream = gcnew FileStream(openFileDialog1->FileName, FileMode::Open, FileAccess::Read);
				fileSupportStreamReader = gcnew StreamReader(fileSupportFileStream);
			}catch(...)
			{
				//If we couldn't open the file then destroy any of the file
				//  support variables that may exist
				if(fileSupportFileStream)
				{
					fileSupportFileStream->Close();
					delete fileSupportFileStream;
				}

			}
			*outfilename=openFileDialog1->FileName;
			while ((!fileSupportStreamReader->EndOfStream) && (fileSupportBuffer = fileSupportStreamReader->ReadLine()))
			{
				responseString+=(fileSupportBuffer+"\r\n");
			}
		}
		fileSupportFileStream->Close();
		*result=1;
	}
	return responseString;
}

unsigned char* getMemoryCardPNM(CARD_INFO* cInfo, unsigned char* outstr)
{
	unsigned int i;

	if(cInfo->cERROR==ERROR_ALL_OK)
	{
		i=0;
		while(i<7)
		{
			if(cInfo->cid.PNM[i]!='\0')*outstr++=cInfo->cid.PNM[i];
			else break;
			i++;
		}
	}
	*outstr='\0';
	return outstr;
}

unsigned char* getMemoryCardPSN(CARD_INFO* cInfo, unsigned char* outstr)
{
	long l;
	if(cInfo->cERROR==ERROR_ALL_OK)
	{
		l=(((long)cInfo->cid.PSN[3])<<24)+(((long)cInfo->cid.PSN[2])<<16)+(((long)cInfo->cid.PSN[1])<<8)+((long)cInfo->cid.PSN[0]);
	} else
		l=0;
	return myultoa(l, outstr, 0);
}

unsigned char* getMemoryCardPRV(CARD_INFO* cInfo, unsigned char* outstr)
{
	long l;
	if(cInfo->cERROR==ERROR_ALL_OK)
	{
		l=(long)cInfo->cid.PRV;
	}
	else
		l=0;
	return myultoa(l, outstr, 0);
}

unsigned char* getMemoryCardType(CARD_INFO* cInfo, unsigned char* outstr)
{
	if(cInfo->cERROR==ERROR_ALL_OK)
	{
	}
	else
	{
		cInfo->CARD_TYPE=0;
	}
	switch(cInfo->CARD_TYPE)
	{
	case 1:
		outstr=copyStringRom(outstr, (const unsigned char*)"MMC");
		break;

	case 2:
		outstr=copyStringRom(outstr, (const unsigned char*)"SDv1");
		break;

	case 4:
		outstr=copyStringRom(outstr, (const unsigned char*)"SDv2");
		break;

	case 6:
		outstr=copyStringRom(outstr, (const unsigned char*)"SDHC");
		break;

	default:
		outstr=copyStringRom(outstr, (const unsigned char*)"None");
		break;
	}
	*outstr='\0';
	return outstr;
}

unsigned char* getMemoryCardFreeSizeMB(CARD_INFO* cInfo, unsigned char* outstr)
{
	if(cInfo->cERROR==ERROR_ALL_OK)
	{
	}
	else
	{
		cInfo->SIZEFREE=0;
	}
	outstr=getUnsignedCharArrayFromString(outstr, formatStringFileSize((double)cInfo->SIZEFREE));
	*outstr='\0';
	return outstr;
}

unsigned char* getMemoryCardTotalSizeMB(CARD_INFO* cInfo, unsigned char* outstr)
{
	if(cInfo->cERROR==ERROR_ALL_OK)
	{
	}
	else
	{
		cInfo->SIZE=0;
	}
	outstr=getUnsignedCharArrayFromString(outstr, formatStringFileSize((double)cInfo->SIZE*1024.0));
	*outstr='\0';
	return outstr;
}

System::String^ getMemoryCardInfoString(CARD_INFO* cInfo)
{
	unsigned char tempString[32];
	unsigned char* ptr;
	unsigned char* pptr;
	System::String^ resultString;

	if(cInfo->cERROR==ERROR_ALL_OK)
	{
	ptr=(unsigned char*)&tempString[0];
	pptr=getMemoryCardPNM(cInfo, ptr);
	if(pptr!=ptr)
	{
		ptr=pptr;
		*ptr++=',';
		*ptr++=' ';
	}
	ptr=getMemoryCardType(cInfo, ptr);
	*ptr++=' ';
	*ptr++='(';
	ptr=getMemoryCardTotalSizeMB(cInfo, ptr);
	*ptr++=')';
	*ptr='\0';
	resultString=getStringFromUnsignedCharArrayAuto((unsigned char*)&tempString[0]);
	}
	else
	{
	 resultString="None";	
	}
	return resultString;
}

System::String^ getFullMemoryCardInfoString(CARD_INFO* cInfo)
{
	unsigned char	tempString[128];
	unsigned char*	ptr;
	System::String^ resultString;

	if(cInfo->cERROR==ERROR_ALL_OK)
	{
	resultString="";
	resultString+="Memory Card Name:\t\t";
	ptr=getMemoryCardPNM(cInfo, (unsigned char*)&tempString[0]);
	resultString+=getStringFromUnsignedCharArrayAuto(&tempString[0])+"\r\n";
	
	resultString+="Memory Card Type:\t\t";
	ptr=getMemoryCardType(cInfo, (unsigned char*)&tempString[0]);
	resultString+=getStringFromUnsignedCharArrayAuto(&tempString[0])+"\r\n";
	
	resultString+="Serial Number:\t\t";
	ptr=getMemoryCardPSN(cInfo, (unsigned char*)&tempString[0]);
	resultString+=getStringFromUnsignedCharArrayAuto(&tempString[0])+"\r\n";
	
	resultString+="Product Version:\t\t";
	ptr=getMemoryCardPRV(cInfo, (unsigned char*)&tempString[0]);
	resultString+=getStringFromUnsignedCharArrayAuto(&tempString[0])+"\r\n";
	
	resultString+="Memory Free Size:\t\t";
	resultString+=formatStringFileSize((double)cInfo->SIZEFREE*1024)+"\r\n";

	resultString+="Memory Total Size:\t\t";
	resultString+=formatStringFileSize((double)cInfo->SIZE*1024)+"\r\n";
	}
	else resultString="Memory Card Information Unavailable!\r\n";
	return resultString;
}

void getTime(TIME_T* sTime)
{
	SYSTEMTIME	mySystemTime;
	GetLocalTime(&mySystemTime);			
	sTime->secs=(unsigned char)mySystemTime.wSecond;
	sTime->mins=(unsigned char)mySystemTime.wMinute;
	sTime->hours=(unsigned char)mySystemTime.wHour;
	sTime->day=(unsigned char)mySystemTime.wDay;
	sTime->month=(unsigned char)mySystemTime.wMonth;
	sTime->year=mySystemTime.wYear;
	sTime->wday=(unsigned char)mySystemTime.wDayOfWeek;
}				 

unsigned char* getTimeStringSystemTime(unsigned char* outptr)
{
	outptr=getUnsignedCharArrayFromString(outptr, ascTimeString(&systemTime));
	*outptr='\0';
	return outptr;
}

unsigned char* ascTime(unsigned char* outptr, TIME_T* ttime)
{
	outptr=getUnsignedCharArrayFromString(outptr, ascTimeString(ttime));
	*outptr='\0';
	return outptr;
}

unsigned char* ascTimeNormal(unsigned char* outptr, TIME_T* ttime)
{
	outptr=getUnsignedCharArrayFromString(outptr, internalAscTimeString(ttime, 1));
	*outptr='\0';
	return outptr;
}

void addMonth(TIME_T* argTimeOutput)
{
	/* adds and roughly clips the output */
	if((argTimeOutput->month>=1)&&(argTimeOutput->month<12))
	{
		argTimeOutput->month++;
	}
	else
	{
		if(argTimeOutput->month==12)argTimeOutput->year++;
		argTimeOutput->month=1;
	}
}

void addDay(TIME_T* argTimeOutput)
{
	if((argTimeOutput->day>=1)&&(argTimeOutput->day<(daysInMonth(argTimeOutput->month, argTimeOutput->year))))
	{
		argTimeOutput->day++;
	}
	else
	{
		argTimeOutput->day=1;
		addMonth(argTimeOutput);	
	}
}

void addHour(TIME_T* argTimeOutput)
{
	if((argTimeOutput->hours>=0)&&(argTimeOutput->hours<23))
	{
		argTimeOutput->hours++;
	}
	else
	{
		argTimeOutput->hours=0;
		addDay(argTimeOutput);
	}
}

void addMinute(TIME_T* argTimeOutput)
{
	if((argTimeOutput->mins>=0)&&(argTimeOutput->mins<59))
	{
		argTimeOutput->mins++;
	}
	else
	{
		argTimeOutput->mins=0;
		addHour(argTimeOutput);
	}
}

void addSecond(TIME_T* argTimeOutput)
{
	if((argTimeOutput->secs>=0)&&(argTimeOutput->secs<59))
	{
		argTimeOutput->secs++;
	}
	else
	{
		argTimeOutput->secs=0;
		addHour(argTimeOutput);
	}	
}

void getFutureArgumentTime(TIME_T* argTimeOutput, TIME_T* currentTimeInput)
{
	/* Within up to a year in the future */

	int i;

	if(argTimeOutput->show & SHOW_MONTH)
	{

	}
	else
	{
		argTimeOutput->month=currentTimeInput->month;	
	}

	if(argTimeOutput->show & SHOW_DAY)
	{

	}
	else
	{
		argTimeOutput->day=currentTimeInput->day;
	}

	if(argTimeOutput->show & SHOW_HOURS)
	{

	}
	else
	{
		argTimeOutput->hours=currentTimeInput->hours;
	}

	if(argTimeOutput->show & SHOW_MINUTES)
	{

	}
	else
	{
		argTimeOutput->mins=currentTimeInput->mins;
	}

	if(argTimeOutput->show & SHOW_SECONDS)
	{

	}
	else
	{
		argTimeOutput->secs=currentTimeInput->secs;
	}

	argTimeOutput->year=currentTimeInput->year;
	argTimeOutput->show&=~SHOW_YEAR;

	/* Now we need to compute whether the argTime is in the future or not, and add carry over time if not */

	/* The following returns 0 if equal, 1 if timeOne is after timeTwo, -1 if timeTwo is after timeOne */
	i=compareTimes(argTimeOutput, currentTimeInput);
	if(i>0)
	{
		/* if strictly in the future, ok */

	}
	else
	{
		/* not in the future, so we must carry over until it is... */
		if(argTimeOutput->show & SHOW_MONTH)
		{
			/* the month was specified, but still it was in the past, so we must add a year! */
			argTimeOutput->year++;
		}
		else
			if(argTimeOutput->show & SHOW_DAY)
			{
				/* the day was specified, but the month was not, and still in the past, so add a month */
				addMonth(argTimeOutput);
			}
			else
				if(argTimeOutput->show & SHOW_HOURS)
				{
					/* the hour was specified, but the day and month were not, so add a day */
					addDay(argTimeOutput);
				}
				else
					if(argTimeOutput->show & SHOW_MINUTES)
					{
						/* the minutes were specified, but the day, month and hour were not, so add an hour */
						addHour(argTimeOutput);
					}
					else
						if(argTimeOutput->show & SHOW_SECONDS)
						{
							/* the seconds were specified, but the day, month, hour and minutes were not, so add a minute */
							addMinute(argTimeOutput);		
						}
						else
						{
							/* nothing was specified, so return one more second than the currentInputTime */
							addSecond(argTimeOutput);			
						}
	}	
}

void igetTime(TIME_T* secondSystemTime)
{
	getLocalTimePC(secondSystemTime);
}

int setTime(TIME_T* sysTime)
{
	/* It's supposed to set the Local Time */
	return 0;
}

void addMonths(TIME_T* argTimeOutput, long n)
{
	/* adds and roughly clips the output */
	if(n>0)
	{
	n+=(long)argTimeOutput->month;
	if(n>0)n--;
	argTimeOutput->year+=(unsigned short)(n/12);
	argTimeOutput->month=(n % 12)+1;
	}
}

void addDays(TIME_T* argTimeOutput, long n)
{
	if(n>0)
	{
	n+=(long)argTimeOutput->day;
	if((n>=1)&&(n<(long)daysInMonth(argTimeOutput->month, argTimeOutput->year)))
	{

	}
	else
	if(n<1)
	{
		n=1;
	}
	else
	{
		n=daysInMonth(argTimeOutput->month, argTimeOutput->year);
	}
	argTimeOutput->day=(unsigned char)n;
	}
}

void addHours(TIME_T* argTimeOutput, long n)
{
	if(n>0)
	{
	n+=(long)argTimeOutput->hours;
	argTimeOutput->hours=(n % 24);
	addDays(argTimeOutput, (n/24));
	}
}

void addMinutes(TIME_T* argTimeOutput, long n)
{
	if(n>0)
	{
	n+=(long)argTimeOutput->mins;
	argTimeOutput->mins=(n % 60);
	addHours(argTimeOutput, (n/60));
	}
}

void addSeconds(TIME_T* argTimeOutput, long n)
{
	if(n>0)
	{
	n+=(long)argTimeOutput->secs;
	argTimeOutput->secs=(n % 60);
	addMinutes(argTimeOutput, (n/60));
	}
}

unsigned char checkTime(TIME_T* argTimeOutput)
{
	unsigned char result;
	
	result=1;
	/* Checks that the time makes sense! */
	if(argTimeOutput->year<1970)
	{
		argTimeOutput->year=1970;
		result=0;
	}	

	if((argTimeOutput->secs>=0)&&(argTimeOutput->secs<60))
	{

	}
	else
	{
		argTimeOutput->secs=(argTimeOutput->secs % 60);
		result=0;
	}

	if((argTimeOutput->mins>=0)&&(argTimeOutput->mins<60))
	{

	}
	else
	{
		argTimeOutput->mins=(argTimeOutput->mins % 60);
		result=0;
	}

	if((argTimeOutput->hours>=0)&&(argTimeOutput->hours<24))
	{

	}
	else
	{
		argTimeOutput->hours=(argTimeOutput->hours % 24);
		result=0;
	}

	if((argTimeOutput->month>=1)&&(argTimeOutput->month<=12))
	{

	}
	else
	{
		argTimeOutput->month=(argTimeOutput->month % 12)+1;
		result=0;
	}

	if((argTimeOutput->day>=1)&&(argTimeOutput->month<=daysInMonth(argTimeOutput->month, argTimeOutput->year)))
	{

	}
	else
	{
		argTimeOutput->day=(argTimeOutput->day % (daysInMonth(argTimeOutput->month, argTimeOutput->year)))+1;
		result=0;
	}	
	return result;
}

System::String^ internalAscTimeString(TIME_T* timet, unsigned char normal)
{
	System::String^ outstr;
	unsigned char tempString[64];
	
	internalAscTime(tempString, timet, normal);
	outstr=getStringFromUnsignedCharArrayAuto(tempString);
	return outstr;
}

unsigned char* internalAscTime(unsigned char* instr, TIME_T* timet, unsigned char normal)
{
	BYTE* outstr;

	/* 
	
		Convert a TIME_T structure to a string...

	*/

	outstr=instr;

	if(checkTime(timet))
	{	
	
	if(timet->show & SHOW_WDAY)
	{
		timet->wday=getWeekDay(timet->day, timet->month, timet->year);
		if(timet->wday<0)timet->wday=0;
		else
			if(timet->wday>6)timet->wday=6;
		*outstr++=weekDays[timet->wday][0];
		*outstr++=weekDays[timet->wday][1];
		*outstr++=weekDays[timet->wday][2];
	}

	if((normal)||(timet->show & SHOW_DAY))
	{
		*outstr++=' ';
		outstr=myultoa(timet->day, outstr, 0);
	}

	if((normal)||(timet->show & SHOW_MONTH))
	{
		*outstr++=' ';
		if(timet->month<1)timet->month=1;
		else
			if(timet->month>12)timet->month=12;	
		*outstr++=monthNames[timet->month-1][0];
		*outstr++=monthNames[timet->month-1][1];
		*outstr++=monthNames[timet->month-1][2];
	}

	if((normal)||(timet->show & SHOW_YEAR))
	{
		*outstr++=' ';
		outstr=(BYTE*)myultoa(timet->year, outstr, 0);
	}

	if((normal)||(timet->show & SHOW_HOURS))
	{
		*outstr++=' ';
		outstr=(BYTE*)myultoa(timet->hours, outstr, 2);
	}
	if((normal)||(timet->show & SHOW_MINUTES))
	{
		*outstr++=':';
		outstr=(BYTE*)myultoa(timet->mins, outstr, 2);
	}
	if((normal)||(timet->show & SHOW_SECONDS))
	{
		*outstr++=':';
		outstr=(BYTE*)myultoa(timet->secs, outstr, 2);
	}
	}
	else
	{
	 outstr=copyStringRom(outstr, (const unsigned char*)"Time Unavailable");	
	}
	*outstr='\0';
	return outstr;
}


unsigned char* showDataLogger(DATA_LOGGER* dl, unsigned char* outstr)
{
	outstr=copyStringRom(outstr, (const unsigned char*)"Dirty: ");
	outstr=uftoa(outstr, (float)dl->dirty, 0);
	outstr=copyStringRom(outstr, (const unsigned char*)" CRC: ");
	outstr=uftoa(outstr, (float)dl->CRC, 0);
	outstr=copyStringRom(outstr, (const unsigned char*)" Modes: ");
	outstr=uftoa(outstr, (float)dl->modes, 0);
	outstr=copyStringRom(outstr, (const unsigned char*)" PORs: ");
	outstr=uftoa(outstr, (float)dl->pors, 0);
	outstr=copyStringRom(outstr, (const unsigned char*)" BattV: ");
	outstr=uftoa(outstr, (float)dl->batteryProtectionVoltage, 2);
	outstr=copyStringRom(outstr, (const unsigned char*)" LastSync: ");
	outstr=internalAscTime(outstr, (TIME_T*)&dl->lastSyncTime, 1);
	*outstr='\0';
	return outstr;
}

System::String^ showBuffer(unsigned char* ptr, unsigned int size)
{
	System::String^ response;
	int i;

	response=" "+HexToString(0, 1)+": ";
	i=0;
	while(size>0)
	{
		response+="0x"+HexToString(*ptr++, 1)+".";
		i++;
		if((i % 8)==0)response+="\r\n "+HexToString(i, 1)+": ";
		size--;
	}
	response+="\r\n";
	return response;
}

int compareCopy(unsigned char* oneptr, unsigned char* twoptr, unsigned int size)
{
	/* returns 1 if non equal, 0 otherwise */
	int result;
	
	result=0;
	while(size--)
	{
		if((*oneptr)!=(*twoptr))
		{
			*oneptr=*twoptr;
			result=1;
		}
		oneptr++;
		twoptr++;
	}
	return result;
}

int compareCopyCardInfo(CARD_INFO* onec, CARD_INFO* twoc)
{
	/* returns 1 if non equal, 0 otherwise */
	int result;
	result=compareCopy((unsigned char*)onec, (unsigned char*)twoc, sizeof(CARD_INFO));
	return result;
}

int compareCopyScripts(VIRTUAL_MACHINE_ENVIRONMENT* ven1, VIRTUAL_MACHINE_ENVIRONMENT* ven2)
{
	/* returns 1 if non equal, 0 otherwise */
	int result;
	int i;

	if(ven1->vmNum!=ven2->vmNum)result=1;
	else
	{
		result=0;
		i=0;
		while((result==0)&&(i<ven1->vmNum))
		{
			if(ven1->vmID[i]!=ven2->vmID[i])result=1;
			i++;
		}
	}
	return result;
}

void setDefaultSettings(DATA_LOGGER* dl)
{
	initVMEnvironment(&dl->ven);
}

System::String^ getSaveFileName(System::String^ fileName, System::String^ extString, System::String^ fileExtension, int* ok)
{
			System::Windows::Forms::SaveFileDialog^	dialog_ExportHex;
			
			*ok=0;
			if(fileName=="")
			{
				 dialog_ExportHex= gcnew(System::Windows::Forms::SaveFileDialog);
				 dialog_ExportHex->Filter= extString+"|"+fileExtension+"|All files (*.*)|*.*";
				 //Open a show dialog box for the "Save As" for the hex file
				 if (dialog_ExportHex->ShowDialog() == ::System::Windows::Forms::DialogResult::OK)
				 {
					*ok=1;
					fileName=dialog_ExportHex->FileName; 
				 }
				 else
				 {
				 
				 }
			}
			else
			{
				*ok=1;
			}
			return fileName;
}

System::String^ getOpenFileName(System::String^ fileName, System::String^ extString, System::String^ fileExtension, int* ok)
{
			System::Windows::Forms::OpenFileDialog^	dialog_ExportHex;
			
			*ok=0;
			if(fileName=="")
			{
				 dialog_ExportHex= gcnew(System::Windows::Forms::OpenFileDialog);
				 dialog_ExportHex->Filter= extString+"|"+fileExtension+"|All files (*.*)|*.*";
				 //Open a show dialog box for the "Save As" for the hex file
				 if (dialog_ExportHex->ShowDialog() == ::System::Windows::Forms::DialogResult::OK)
				 {
					*ok=1;
					fileName=dialog_ExportHex->FileName; 
				 }
				 else
				 {
				 
				 }
			}
			else
			{
				*ok=1;
			}
			return fileName;
}

int restoreSettings(DATA_LOGGER* dl, std::string& output, System::String^ fileName)
{
	int				result;
	unsigned int 	i;
	unsigned char* 	ptr;
	unsigned char  	CRC;
	unsigned int   	numWriteSettings;
	unsigned char   buffer[sizeof(DATA_LOGGER)];
	unsigned int	done;
	std::string     another;
	OpenFileDialog^ dialog;

	if(fileName=="")
	{
	dialog=gcnew(OpenFileDialog);
	dialog->Filter="Binary Files |*.bin |All files (*.*)|*.*";
	dialog->FileName="*.bin";
	/* Open a show dialog box for the "Put As" for the hex file */
	if (dialog->ShowDialog() == ::System::Windows::Forms::DialogResult::OK)
	{
		fileName=dialog->FileName;		
	
	
	}
	else
	{

	}
	}

	result=0;
	if(fileName!="")
	{
	numWriteSettings=sizeof(DATA_LOGGER);
	ReadFile(fileName, 0, buffer, sizeof(DATA_LOGGER), &done);
	if(done==sizeof(DATA_LOGGER))
	{
		output="Restoring Settings: ";
		CRC=0;
		ptr=(unsigned char*)dl;
		for(i=0; i<numWriteSettings; i++)
		{
			*ptr=buffer[i];
			CRC^=(unsigned char)(*ptr);
			ptr++;
		}
		if(CRC!=0)
		{
			/* There Was a CRC Error ! */
			output+="CRC Error.\r\n";
			setDefaultSettings(dl);
			dl->dirty|=DL_DIRTY;
			saveSettings(dl, another, fileName);
			output+=another;
			CRC=0;
		}
		else
		{
			output+="Ok!\r\n";
			result=1;
		}
		dl->CRC=CRC;
	}
	else
	{
		output="Creating Settings...\r\n";
		setDefaultSettings(dl);
		dl->dirty|=DL_DIRTY;
		saveSettings(dl, another, fileName);
		dl->CRC=0;
		output+=another;
	}
	}
	return result;
}

int saveSettings(DATA_LOGGER* dl, std::string &output, System::String^ fileName)
{
	int			   result;
	unsigned int   i;
	unsigned char* ptr;
	unsigned char  CRC;
	unsigned int   numWriteSettings;
	unsigned char  buffer[sizeof(DATA_LOGGER)];
	unsigned int   done;
	SaveFileDialog^ dialog;
	
	if(fileName=="")
	{
	dialog=gcnew(SaveFileDialog);
	dialog->Filter="Binary Files |*.bin |All files (*.*)|*.*";
	dialog->FileName="*.bin";
	/* Open a show dialog box for the "Put As" for the hex file */
	if (dialog->ShowDialog() == ::System::Windows::Forms::DialogResult::OK)
	{
		fileName=dialog->FileName;
	}
	else
	{

	}
	}

	result=0;
	if(fileName!="")
	{
	result=0;
	if(dl->dirty)
	{
		output="Saving Settings... ";
		numWriteSettings=sizeof(DATA_LOGGER);
		CRC=0;
		ptr=(unsigned char*)dl;
		for(i=0; i<(numWriteSettings-1); i++)
		{
			buffer[i]=*ptr;
			CRC^=(unsigned char)(*ptr);
			ptr++;
		}
		buffer[numWriteSettings-1]=CRC;
		output+="CRC: 0x"+getStdStringFromString(HexToString(CRC, 1))+".\r\n";
		WriteFileCreate(fileName, 0, buffer, sizeof(DATA_LOGGER), &done);
		result=1;
		dl->CRC=0;
		dl->dirty&=~DL_DIRTY;
	}
	else
	{
		output="";
	}
	}
	return result;
}

System::String^ getScriptName(unsigned char id)
{
			System::String^ response;
			System::String^ fileName;
			unsigned int	done;
			unsigned char	textBuffer[32];

			response="";
			fileName="nm"+HexToString((unsigned long)id & VM_ID_MASK, 1)+".txt";
			if(File::Exists(fileName))
			{
				ReadFile(fileName, 0, textBuffer, 32, &done);
				response=getStringFromUnsignedCharArray(textBuffer, done);
			}
			else
			{
		
			}
			return response;
}

unsigned char getFreeVMIDConsideringNames(VIRTUAL_MACHINE_ENVIRONMENT* ven, System::String^ instring)
{
	/* 

		Get a new VM ID, taking into account the names of scripts too... 
		
		If a script with the same name already exists, we replace that one.
		Otherwise, we get a free VM ID in the conventional way.

	*/
	
	System::String^ stringToCompare;
	unsigned char   index;
	unsigned char   result;
	
	result=VM_ID_MASK+1;
	index=0;
	while((result>VM_ID_MASK)&&(index<(ven->vmNum)))
	{
		stringToCompare=getScriptName(ven->vmID[index]);
		if(stringToCompare==instring)
		{
			result=ven->vmID[index];
		}
		index++;
	}

	if(result<=VM_ID_MASK)
	{
		
	}
	else
	{
		result=getFreeVMID(ven);
	}
	return result;
}

int goToSleep(int on)
{
	return on;
}

void memoryCardTask(void)
{

}

			 System::String^ printAddress(unsigned long input, unsigned char bytes)
			 {
				 System::String^ returnString;
				 wchar_t returnArray[9];

				 unsigned char i;
				 unsigned char c;

				 for(i=0;i<9;i++)
				 {
					 returnArray[i]='0';
				 }

				 for(i=0;i<bytes;i++)
				 {
					 c = (unsigned char)(input & 0x0000000F);

					 if(c <= 9)
					 {
						 returnArray[7-i]=c+'0';
					 }
					 else 
					 {
						 returnArray[7-i]=c+'A'-10;
					 }
					 input >>= 4;
				 }
				 returnArray[9] = 0;
				 returnString = gcnew String(returnArray);
				 returnString = returnString->Substring(8-(bytes),bytes);
				 return returnString;
			 }
			
			 unsigned long StringToDecimal(System::String^ s)
			 {
				 unsigned long returnAddress;
				 unsigned long placeMultiplier;
				 unsigned char i;
				 wchar_t c;

				 returnAddress = 0;
				 placeMultiplier = 1;

				 for(i=0;i<s->Length;i++)
				 {
					 c = s[s->Length-1-i];
					 if((c >= '0') && (c <= '9'))
					 {
						 c = c - '0';
						 returnAddress += (c * placeMultiplier);
						 placeMultiplier *= 10;
					 }
				 }
				 return returnAddress;
			 }


			 unsigned long StringToHex(System::String^ s)
			 {
				 unsigned long returnAddress;
				 unsigned long placeMultiplier;
				 unsigned char i;
				 wchar_t c;

				 returnAddress = 0;
				 placeMultiplier = 1;

				 for(i=0;i<s->Length;i++)
				 {
					 c = s[s->Length-1-i];
					 if((c >= 'A') && (c <= 'F'))
					 {
						 c = 10 + (c - 'A');
					 }
					 else if((c >= 'a') && (c <= 'f'))
					 {
						 c = 10 + (c - 'a');
					 }
					 else
					 {
						 c = c - '0';
					 }

					 returnAddress += (c * placeMultiplier);
					 placeMultiplier *= 16;
				 }

				 return returnAddress;
			 }


System::String^ getBufferString(unsigned long j, unsigned char* inptr, unsigned int bytes)
{
			unsigned int k;
			System::String^ result;
			
			result="";
			k=0;
			while(j<(unsigned long)bytes)
			{
			 if(k==0)
			 {
			 result+="0x"+HexToString((unsigned long)j, 4);
			 result+=": ";
			 }
			 result+=HexToString((unsigned long)*inptr++, 1);
			 if(k<15)
			 {
			 result+=".";
			 k++;
			 }
			 else
			 {
				 result+="\r\n";
				 k=0;
			 }
		 	 j++;
			 }
			 result+="\r\nTotal Size: "+formatStringFloat((double)bytes, 0)+" B.\r\n";	
	return result;			
}		 

System::String^ writeMapFile(System::String^ fileName, unsigned long address, unsigned long endAddress, unsigned char* inptr)
{
		unsigned char dataByte;
		unsigned char dataByte2;
		System::String^ printString;
		unsigned int m;
		System::IO::FileStream^		fileSupportFileStream;
		System::IO::StreamWriter^	fileSupportStreamWriter;
		System::String^ argString;
		
		try
		{
			 //Try to create a write stream to the specified file
			 fileSupportStreamWriter = gcnew System::IO::StreamWriter(fileName, false);
		}
		catch(...)
		{
			 if(fileSupportFileStream)
			 {
				 delete fileSupportFileStream;
			 }
			 return "Error.";
		 }
		
		argString=" Address                                     ";
		fileSupportStreamWriter->WriteLine(argString);
		while(address<endAddress)
		{
		 printString="";
		 for(m=0; m<8; m++)
		 {
			 dataByte=(unsigned char)*inptr++;
			 dataByte2=(unsigned char)*inptr++;
			 address+=2;
			 if(m!=7)printString=String::Concat(printString, HexToString(dataByte2,1),HexToString(dataByte,1),"   ");
			 else
			 printString=String::Concat(printString, HexToString(dataByte2,1),HexToString(dataByte,1)," ");
		 }
		 argString=String::Concat("  ", printAddress(address-16, 5),"    ", printString);
		 fileSupportStreamWriter->WriteLine(argString);

		}
		fileSupportStreamWriter->Close();
		// Write the end of file command, close the file, and notify the user
		return "Ok.";
}	

System::String^ writeMapDifferencesFile(System::String^ fileName, System::String^ infoString, unsigned long address, unsigned long endAddress, unsigned char* inptr, unsigned char* inptr2)
{
		unsigned char dataByte;
		unsigned char dataByte2;

		unsigned char dataByte21;
		unsigned char dataByte22;
		bool			lineEqual;
		System::String^ printString;
		System::String^ printString2;
		System::String^ mstring;
		unsigned int m;
		System::IO::FileStream^		fileSupportFileStream;
		System::IO::StreamWriter^	fileSupportStreamWriter;
		System::String^ argString;
		
		try
		{
			 //Try to create a write stream to the specified file
			 fileSupportStreamWriter = gcnew System::IO::StreamWriter(fileName, false);
		}
		catch(...)
		{
			 if(fileSupportFileStream)
			 {
				 delete fileSupportFileStream;
			 }
			 return "Error.";
		 }
		
		argString=infoString;
		argString+=" Address                                                 ";
		mstring="....";
		fileSupportStreamWriter->WriteLine(argString);
		while(address<endAddress)
		{
		 printString="";
		 printString2="";
		 lineEqual=true;
		 for(m=0; m<8; m++)
		 {
			 dataByte=(unsigned char)*inptr++;
			 dataByte2=(unsigned char)*inptr++;
			 dataByte21=(unsigned char)*inptr2++;
			 dataByte22=(unsigned char)*inptr2++;
			 address+=2;
			 
			 if((dataByte==dataByte21)&&(dataByte2==dataByte22))
			 {
				 if(m!=7)printString=String::Concat(printString, mstring+"   ");
				 else    printString=String::Concat(printString, mstring+" ");

	
				 if(m!=7)printString2=String::Concat(printString2, mstring+"   ");
				 else    printString2=String::Concat(printString2, mstring+" ");
			 }
			 else
			 {
				 lineEqual=false;
				 if(m!=7)printString=String::Concat(printString, HexToString(dataByte2,1),HexToString(dataByte,1),"   ");
				 else    printString=String::Concat(printString, HexToString(dataByte2,1),HexToString(dataByte,1)," ");

				 if(m!=7)printString2=String::Concat(printString2, HexToString(dataByte21,1),HexToString(dataByte22,1),"   ");
				 else    printString2=String::Concat(printString2, HexToString(dataByte21,1),HexToString(dataByte22,1)," ");
			}
		 }
		 if(lineEqual)
		 {
		 
		 }
		 else
		 {
			 argString=String::Concat("  ", printAddress(address-16, 5), "    ", printString, "\r\n");
			 argString+=String::Concat("  ", printAddress(address-16, 5),"    ", printString2);
			 fileSupportStreamWriter->WriteLine(argString);
		 }
		}
		fileSupportStreamWriter->Close();
		// Write the end of file command, close the file, and notify the user
		return "Ok.";
}	

double avgInit(AVERAGED_OBJECT* aO, int maxAvgs)
{
	int i;
	if(maxAvgs<=AVGS)aO->avgsMax=maxAvgs;
	else
	{
		aO->avgsMax=AVGS;
	}
	aO->avgsIndex=0;
	aO->avgsNum=0;
	for(i=0; i<aO->avgsMax; i++)aO->avgs[i]=0;
	return 0;
}

double avgPut(AVERAGED_OBJECT *aO, double g, int fullAvg)
{
	int i;

	aO->avgs[aO->avgsIndex]=g;
	if((aO->avgsIndex)<(aO->avgsMax-1))
	{
		aO->avgsIndex++;
	}
	else
	{
		aO->avgsIndex=0;
	}

	if((aO->avgsNum)<(aO->avgsMax))aO->avgsNum++;

	i=0;
	g=0;
	while(i<(aO->avgsNum))
	{
	 g+=(double)aO->avgs[i];
	 i++;
	}
	
	if((fullAvg)&&(aO->avgsNum<aO->avgsMax))
	{
		return 0;
	}
	
	return (double)(g/(double)(aO->avgsNum));	
}

void deleteLocalFile(unsigned char* filename)
{
	if(System::IO::File::Exists(getStringFromUnsignedCharArrayAuto(filename)))
	{
		try
		{
		System::IO::File::Delete(getStringFromUnsignedCharArrayAuto(filename));	
		}
		catch(...)
		{
		
		}
	}	 
}

void receiveCharGPS(VIRTUAL_MACHINE* vm)
{


}

unsigned char isFileChar(unsigned char c)
{
	unsigned char result;
	
	result=1;
	switch(c)
	{
		default:
			break;
		
		case '(':
		case ')':
		case '*':
		case '?':
		case ':':
		case '<':
		case '>':
		case '|':
		case '"':
		case ' ':
			result=0;
			break;
	}
	return result;
}

unsigned char* copyFileStringString(unsigned char* first, unsigned char* second)
{
	unsigned char c;
	// copy second string to first
	while((*second)!='\0')
	{
		c=*second;
		if(isFileChar(c))*first++=c;
		second++;
	}
	*first='\0';
	return first;
}

std::string showPipeBufferLocal()
{
	unsigned int  i;
	unsigned char g;
	std::string response;
	
	response=" Pipe: [";
	i=serialPipeGetPtr;
	while(i!=serialPipePutPtr)
	{
		g=serialPipe[i];
		if(i<(MAX_SERIAL_PIPE_LENGTH-1))i++; else i=0;
		if(g=='\r')
		{
		response+="\\r";
		}
		else
		if(g=='\n')
		{
		response+="\\n";
		}
		else
		{
			response+=g;
		}
	}
	response+="]\r\n";
	return response;
}

unsigned char serialPipeGetLocal(void)
{
	unsigned char g;
	
	if(serialPipeGetPtr!=serialPipePutPtr)
	{
		g=serialPipe[serialPipeGetPtr];
		if(serialPipeGetPtr<(MAX_SERIAL_PIPE_LENGTH-1))serialPipeGetPtr++; else serialPipeGetPtr=0;
	}
	else
	{
		/* nothing to get */
		serialPipeStatus|=SERIAL_PIPE_UNDERFLOW;
		g='\0';
	}
	return g;
}

void serialPipePutLocal(unsigned char g)
{
	unsigned char x;
	
	x=serialPipePutPtr;
	if(x<(MAX_SERIAL_PIPE_LENGTH-1))x++; else x=0;

	if(x==serialPipeGetPtr)
	{
		serialPipeGetLocal();
		serialPipeStatus|=SERIAL_PIPE_OVERFLOW;
	}
	
	/* Make Room If Possible */	
	/* adds another char */
	serialPipe[serialPipePutPtr]=g;
	//if(g=='\n')serialPipeGetLimit=x;
	serialPipePutPtr=x;
}

std::string flushSerialUSBLocal(void)
{
	unsigned int length;
	unsigned char c;
	std::string response;
	
	/* reset the buffer */
        
    response="";
    length=0;
	c=serialPipeGetLocal();
	while(c!='\0')
	{
		response+=c;
		//INPacket.data[length+4]=c;
		length++;
		c=serialPipeGetLocal();
	}
	response+=c;
	//INPacket.data[1]=serialPipeStatus;
	serialPipeStatus=SERIAL_PIPE_OK;
	//INPacket.data[2]=(unsigned char)(length);
	//INPacket.data[3]=(unsigned char)(length>>8);
	return response;
}

void sendCharSerialUSBLocal(unsigned char c)
{
	serialPipePutLocal(c);
}

void sendRamStringSerialUSBLocal(unsigned char* ramString)
{
	while((*ramString)!='\0')
	{
		sendCharSerialUSBLocal(*ramString++);
	}
}

void sendRomStringSerialUSBLocal(unsigned char* romString)
{
	while((*romString)!='\0')
	{
		sendCharSerialUSBLocal(*romString++);
	}
}

void initSerialUSBLocal(void)
{
	/* initialize the serial pipe */
	serialPipeStatus=SERIAL_PIPE_OK;
	serialPipePutPtr=0;
	serialPipeGetPtr=0;
}

System::String^ getHelpText(unsigned long maskid, unsigned int header, unsigned int windowCharacterWidth)
{
	System::String^ response;
	System::String^ endResult;
	System::String^ nextWord;
	
	unsigned int mask;
	unsigned int id;
	unsigned int i;
	unsigned int j;
	wchar_t      currentCharacter;
		
	id=maskid & MASK_TAG;
	mask=(maskid & ~(MASK_TAG));

	response="";	
	switch(mask)
	{
		default:
			response+="No Help Available";
			break;
			
		case HEADER_OBJECTS_TAG:
			if(header)response+="Header Object\r\n";
			response+="Syntax:\t"+getStringFromStdString((std::string*)&headerObjectNameTable[id]);
			response+="\r\nEffect:\t"+getStringFromStdString((std::string*)&headerObjectsHelpTable[id])+"\r\n";
			break;
			
		
		case GLOBAL_FUNCTIONS_TAG:
			if(header)response+="Global Function\r\n";
			response+="Syntax:\t"+getStringFromStdString((std::string*)&globalFunctionNameTable[id]);
			response+="(";
			i=0;
			j=globalFunctionArgTable[(int)globalFunctionIDTable[id]];
			while(i<j)
			{
			  response+="$"+formatStringFloat((double)i+1, 0);
			  i++;
			  if(i<j)response+=", ";
			}
			response+=")\r\n"+getStringFromStdString((std::string*)&globalFunctionHelpTable[id])+"\r\n";
			break;

		case GLOBAL_VARIABLES_TAG:
			if(header)response+="Global Variable\r\n";
			response+="Syntax:\t"+getStringFromStdString((std::string*)&globalVariableNameTable[id]);
			response+="\r\nEffect:\t"+getStringFromStdString((std::string*)&globalVariableHelpTable[id])+"\r\n";
			break;
		
		case GLOBAL_VARIABLES_VM_OFFSET_TAG:
			if(header)response+="Global Variable (relative to local script)\r\n";
			response+="Syntax:\t"+getStringFromStdString((std::string*)&vmOffsetGlobalVariableNameTable[id]);
			response+="\r\nEffect:\t"+getStringFromStdString((std::string*)&vmOffsetGlobalVariableHelpTable[id])+"\r\n";
			break;
		
		case DEFINE_CONSTANTS_TAG:
			if(header)response+="Define Constant\r\n";
			response+="Syntax:\t"+getStringFromStdString((std::string*)&definesNameTable[id]);
			response+="\r\nValue :\t"+formatStringConstant((double)definesValueTable[id], 6);
			response+="\r\nEffect:\t"+getStringFromStdString((std::string*)&definesHelpTable[id])+"\r\n";
			break;
	}

	/* 

		Now Slightly Format The String To Implement Word Wrapping 

	*/

	i=0;
	j=0;
	nextWord="";
	

	while(i<(unsigned int)response->Length)
	{
			
			currentCharacter=(wchar_t)response[i];
			i++;
			
			switch(currentCharacter)
			{
			   case ' ':
					nextWord+=currentCharacter;
					if((j+(unsigned int)nextWord->Length)<windowCharacterWidth)
					{
					   endResult+=nextWord;
					   j+=(unsigned int)nextWord->Length;
					}
					else
					{
					   endResult+="\r\n\t"+nextWord;
					   j=8+(unsigned int)nextWord->Length;					
					}
					nextWord="";
					break;
			
			   case '\t':
					endResult+=nextWord+"\t";
					j+=(8+(unsigned int)nextWord->Length);
					nextWord="";
					break;
			   
			   case '\n':		
			   		endResult+=nextWord+currentCharacter;
					nextWord="";
					j=0;
					break;
					
			    case '\r':
				default:
					nextWord+=currentCharacter;
					break;
			}
	}
	
	if((j+nextWord->Length)<windowCharacterWidth)
	{
	   endResult+=nextWord;
	}
	else
	{
	   endResult+="\r\n\t"+nextWord;
	}
	return endResult;
}
