#ifndef __COMMON_H
#define __COMMON_H

#include <windows.h>
#include "vm.h"
#include "clock.h"

#define	HOST_VERSION							9.90

#define COMPILE_TASK_PERIOD						64
									
#define MY_VID									0x04D8	// 0x04D8 = Microchip Vendor ID
#define MY_PID									0xFCE9	// Sublicenced to me (Mauro Grassi) by Microchip...
									
#define	AVGS									4

#define LOCAL_SYS_LOG_TXT						("localsyslog.txt")
#define HELP_FILE_NAME							("help.pdf")
#define HELP_TXT_FILE_NAME						("help.txt")

#define GLOBAL_VARIABLES_VM_OFFSET_TAG			0x00080000
#define GLOBAL_VARIABLES_TAG					0x00040000
#define GLOBAL_FUNCTIONS_TAG					0x00020000
#define DEFINE_CONSTANTS_TAG					0x00010000
#define HEADER_OBJECTS_TAG						0x00100000
#define MASK_TAG								0x0000FFFF

/* BootLoader Specific Constants */

#define MAX_PROGRAM_MEMORY						((128*1024)-8)
#define MAX_CONFIG_MEMORY						(8)
#define CONFIG_MEMORY_START						(0x1FFF8)
#define PROGRAM_ADDRESS_TOP						(0x20000)
#define BOOTLOADER_ADDRESS						(0x1DC00)
#define SERIAL_BOOTLOADER_ADDRESS				(0x1D400)
#define BOOTLOADER_SIZE_BYTES					(PROGRAM_ADDRESS_TOP-BOOTLOADER_ADDRESS)
#define BOOTLOADER_SIZE_BYTES_CHECK				(CONFIG_MEMORY_START-BOOTLOADER_ADDRESS)

/* The Programming proceeds in two steps, the first page contains the reset vector */

#define FIRST_PAGE_PROGRAM_ADDRESS				(0x00000)
#define REST_PAGE_PROGRAM_ADDRESS				(0x00400)

#define HEX_FILE_EXTENDED_LINEAR_ADDRESS		0x04
#define HEX_FILE_EOF							0x01
#define HEX_FILE_DATA							0x00

/* End BootLoader Specific Constants */

#define BASE_TEXT_FILENAME						("text.txt")

#define DL_EE_DIRTY								0x01
#define DL_FILE_DIRTY							0x02
#define DL_DIRTY								(DL_EE_DIRTY | DL_FILE_DIRTY)

#define	DEFAULT_MEMORY_VALUE					0xFF
#define MEMORY_NUM_COLS							16
#define MEMORY_NUM_ROWS							6
			
#define ADCP_THRESHOLD_USB_POWER				(2.85)

#define MAX_SYNC_PERIOD_SECS_DIFFERENT_TIME		(30*60)			/* 30 minutes, time window within which times are considered similar */
#define MAX_SYNC_PERIOD_SECS					(7*24*3600)		/* a week, time to allow before sync is needed */
								
#define NO_DATA_LOGGER_MODES					0x00
#define TIME_AUTO_SYNC_MODE						0x01
#define BATTERY_PROTECTION_MODE					0x02
#define SYSTEM_LOGGING_MODE						0x04
#define SYSTEM_LOGGING_TO_UART					0x08
#define SYSTEM_LOGGING_TO_SERIAL_USB			0x10

#define MAX_SERIAL_PIPE_UNIT_LENGTH				(SIZE_USB_PACKET-4)
#define MAX_SERIAL_PIPE_LENGTH					120
#define SERIAL_PIPE_OK							0x00
#define	SERIAL_PIPE_OVERFLOW					0x01
#define SERIAL_PIPE_UNDERFLOW					0x02  

#define IDLE_MODE								0x00
#define SIMULATE_RUN_MODE						0x01
#define STEP_RUN_MODE							0x02
									
#define USB_TIMEOUT_LONG						5000
#define USB_TIMEOUT								200
#define USB_TIMEOUT_BOOT						5000
#define USB_TIMEOUT_BOOT_QUICK					500
#define USB_TIMEOUT_FILE						10000
#define USB_TIMEOUT_TRANSFERS					1000

#define TITLE_MIDDLE_STRING						(" ")
#define LOCAL_SAVE_SETTINGS_FILE				("ldl.bin")
#define LOCAL_SETTINGS_FILENAME					("lsettings.bin")
	
#define FILE_BLOCK_SIZE							1673

#define MAXIMUM_TEXT_BUFFER_SIZE				64000
#define SIZE_USB_PACKET							64
#define	SLOW_UPDATE_PERIOD_MS					850
#define SLOW_UPDATE_PERIOD_RECOVERY_MS			100
#define VERY_SLOW_UPDATE_PERIOD_MS				(SLOW_UPDATE_PERIOD_MS*4)
#define SLOW_SIMULATION_UPDATE_PERIOD_MS		1200

#define OK_COLOUR							(System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(128)),static_cast<System::Int32>(static_cast<System::Byte>(255)), static_cast<System::Int32>(static_cast<System::Byte>(128))))
#define BAD_COLOUR							(System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(255)),static_cast<System::Int32>(static_cast<System::Byte>(128)), static_cast<System::Int32>(static_cast<System::Byte>(128))))
#define NEUTRAL_COLOUR						(System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(0)),static_cast<System::Int32>(static_cast<System::Byte>(0)), static_cast<System::Int32>(static_cast<System::Byte>(0))))
#define BAD_DARK_COLOUR						(System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(255)),static_cast<System::Int32>(static_cast<System::Byte>(0)), static_cast<System::Int32>(static_cast<System::Byte>(32))))
#define OK_DARK_COLOUR						(System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(0)),static_cast<System::Int32>(static_cast<System::Byte>(0)), static_cast<System::Int32>(static_cast<System::Byte>(0))))

#define NORMAL_COLOUR						(System::Drawing::SystemColors::Control)
#define GREYED_COLOUR						(System::Drawing::SystemColors::WindowFrame)
	
#define TABLE_NO_CHANGE_COLOUR				(System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(0)),static_cast<System::Int32>(static_cast<System::Byte>(255)), static_cast<System::Int32>(static_cast<System::Byte>(32))))
#define TABLE_CHANGE_COLOUR					(System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(255)),static_cast<System::Int32>(static_cast<System::Byte>(0)), static_cast<System::Int32>(static_cast<System::Byte>(32))))

#define MSGBOX_ICON_INFORMATION				(System::Windows::Forms::MessageBoxIcon::Information)
#define MSGBOX_ICON_WARNING					(System::Windows::Forms::MessageBoxIcon::Warning)
#define MSGBOX_ICON_ERROR					(System::Windows::Forms::MessageBoxIcon::Error)

#define USE_MUTEX_USB				1
#define USE_MUTEX_TRANSFERS			1

#define EPOCH_YEAR 					2000
#define EPOCH_LIMIT					32000

#define	MIN_F						0.00005

#define MAX_PATH_LENGTH				57

#define CONNECTED					1

/* USB Command Set */

#define CMD_SET_CAPTIVE_DEVICE					0x08
#define CMD_GET_CAPTIVE_DEVICE					0x09

#define CMD_GET_VERSION							0x10
#define CMD_POR_RESET							0x13
#define CMD_RESET								0x14
#define CMD_SET_TIME							0x15
#define CMD_GET_TIME							0x16

#define CMD_OPEN_READ_FILE						0x20
#define CMD_OPEN_WRITE_FILE						0x21
#define CMD_READ_FILE							0x22
#define CMD_WRITE_FILE							0x23
#define CMD_CLOSE_FILE							0x24
#define CMD_OPEN_DIR							0x25
#define CMD_READ_DIR							0x26
#define CMD_UNLINK_FILE							0x27
#define CMD_READ_DIR_REWIND						0x28
#define CMD_MKDIR								0x29

#define CMD_INIT_TRANSFERS						0x40
#define CMD_GET_TRANSFER_STATS					0x41
#define CMD_CONTINUE_BULK_TRANSFER_WRITE		0x44 	
#define CMD_CONTINUE_BULK_TRANSFER_READ			0x45
#define	CMD_INIT_DATA_LOGGER_TRANSFER			0x50
#define CMD_INIT_CARDINFO_TRANSFER				0x51
#define CMD_UPDATE_CARD_INFO					0x52
#define CMD_SET_FIRST_POR						0x53

#define CMD_CALL_GLOBAL_FUNCTION_IMMEDIATE		0x70
#define CMD_GET_SERIAL_USB_BUFFER				0x80
#define CMD_INIT_SERIAL_USB_BUFFER				0x81

#define CMD_LOGSTRING							0x90
#define CMD_FLUSH_LOG							0x91
#define CMD_RESTART_LOG							0x92
#define CMD_RESTORE_DEFAULTS					0x94
#define CMD_GET_SIZES							0x95
#define CMD_FLUSH_SETTINGS						0x96
#define CMD_DELETE_LOG							0x97
#define CMD_RECONNECT_MEMORYCARD				0x98
#define CMD_ENTER_SERIAL_BOOTLOADER				0x99
#define CMD_ENTER_USB_BOOTLOADER				0x9A

/* Bootloader related commands */

#define SERIAL_BOOTLOADER_VERSION				1.00

#define CMD_GET_PROGRAM_MEMORY_AT				0xA0
#define CMD_PUT_PROGRAM_MEMORY_AT				0xA1
#define CMD_ERASE_PROGRAM_MEMORY_AT				0xA2
#define CMD_BOOT_RESET							0xA3
#define CMD_GET_BOOTLOADER_STATUS				0xA4
#define CMD_SET_FLASH_ADDRESS					0xA5
#define CMD_WRITE_WORD_FLASH					0xA6

/* Serial BootLoader Commands */

#define CMD_BW_SET_FLASH_ADDRESS			0xC0
#define CMD_BW_SET_END_ADDRESS				0xC1
#define CMD_BW_READ_MEMORY					0xC2
#define CMD_BW_WRITE_MEMORY					0xC3
#define CMD_BW_ERASE_MEMORY					0xC4
#define CMD_BW_BOOT_RESET					0xC5
#define CMD_BW_RESYNC						0xC6
#define CMD_BW_GET_DONE						0xC7	
#define CMD_BW_WRITE_WORD					0xC8

#define INCREMENTAL_SERIAL						0
#define USE_LEGACY_SERIAL_PORT					0

#if(USE_LEGACY_SERIAL_PORT)

#define PC_BOOT_BAUD_QUICK						CBR_115200
#define PC_BOOT_BAUD_SLOW						CBR_4800
#define BW_SERIAL_MODE							0
/* Do not make the BW_BLOCK_SIZE lower than about 2048 if using the LEGACY serial port mode */
#define BW_BLOCK_SIZE							8192
#define BW_BLOCK_SIZE_WRITE						64

#else

#define PC_BOOT_BAUD_QUICK						115200
#define PC_BOOT_BAUD_SLOW						4800
#define BW_SERIAL_MODE							0
#define BW_BLOCK_SIZE							2048
#define BW_BLOCK_SIZE_WRITE						64

#endif

/* the following should be different to all commands */	
#define MAGIC_BYTE_COMMAND_ECHO					0x76

/* Ideally, the resync reties should be larger than the block size */
#define RESYNC_RETRIES							16

#define MAXIMUM_SERIAL_PORT_NUMBER				16

	
#define SIZE_USB_PACKET							64
#define USB_FDIR_NAME_SIZE						(SIZE_USB_PACKET-12)

/* File attribute bits for directory entry */

#define	AM_RDO	0x01	/* Read only */
#define	AM_HID	0x02	/* Hidden */
#define	AM_SYS	0x04	/* System */
#define	AM_VOL	0x08	/* Volume label */
#define AM_LFN	0x0F	/* LFN entry */
#define AM_DIR	0x10	/* Directory */
#define AM_ARC	0x20	/* Archive */
#define AM_MASK	0x3F	/* Mask of defined bits */

#define	FA_READ				0x01
#define	FA_OPEN_EXISTING	0x00
#if _FS_READONLY == 0
#define	FA_WRITE			0x02
#define	FA_CREATE_NEW		0x04
#define	FA_CREATE_ALWAYS	0x08
#define	FA_OPEN_ALWAYS		0x10
#define FA__WRITTEN			0x20
#define FA__DIRTY			0x40
#endif
#define FA__ERROR			0x80

/* File function return code (FRESULT) */

typedef enum {
	FR_OK = 0,			/* 0 */
	FR_DISK_ERR,		/* 1 */
	FR_INT_ERR,			/* 2 */
	FR_NOT_READY,		/* 3 */
	FR_NO_FILE,			/* 4 */
	FR_NO_PATH,			/* 5 */
	FR_INVALID_NAME,	/* 6 */
	FR_DENIED,			/* 7 */
	FR_EXIST,			/* 8 */
	FR_INVALID_OBJECT,	/* 9 */
	FR_WRITE_PROTECTED,	/* 10 */
	FR_INVALID_DRIVE,	/* 11 */
	FR_NOT_ENABLED,		/* 12 */
	FR_NO_FILESYSTEM,	/* 13 */
	FR_MKFS_ABORTED,	/* 14 */
	FR_TIMEOUT			/* 15 */
} FRESULT;

#pragma pack(push, 1)

#define ERROR_ALL_OK			  	0x00
#define ERROR_NOT_SDMMC_CARD		0x01
#define ERROR_BAD_VOLTAGE_RANGE	  	0x02
#define ERROR_SDMMC_CARD_TIMEOUT	0x04
#define ERROR_CLOSED_CARD			0x10

typedef struct
{
	unsigned char	fresult;
	WORD 			lfsize;
	DWORD			fsize;
	WORD  			fdate;
	WORD			ftime;
	unsigned char	fattrib;
	unsigned char   fname[USB_FDIR_NAME_SIZE];
} DIR_ENTRY;

typedef union
{
	unsigned char data[SIZE_USB_PACKET];
	DIR_ENTRY	  fdir;
} USB_PACKET;

typedef struct 
{
	unsigned char	TAAC;
	unsigned char	NSAC;
	unsigned char 	TRAN_SPEED;
	unsigned short	CCC;
	unsigned char	READ_BL_LEN;
	unsigned long	C_SIZE;
	unsigned char	C_SIZE_MULT;
	unsigned char	SECTOR_SIZE;
	unsigned char	FILE_FORMAT;
} CSD_REGISTER;

typedef struct
{
	unsigned char	MID;		// Manufacturer ID
	unsigned short	OID;		// OEM ID
	unsigned char 	PNM[7];		// Product Name
	unsigned char	PRV;		// Product Revision
	unsigned char	PSN[4];		// Serial Number
	unsigned short	MDT;		// Manufacture Date M/Y from 2000
} CID_REGISTER;

typedef struct
{
	unsigned char	OCR[4];
} OCR_REGISTER;

typedef struct
{
	unsigned char		CARD_TYPE;		// 0: not SD/MMC, 1: MMC , 2: SD v1 4: SD v2 6: SDHC
	unsigned char		VOLTAGE_RANGE;	// 0: not supported 1: supported (3.3V)
	unsigned long       SIZE;			// size in Bytes (filled in when CSD is read)
	unsigned char		cERROR;			// 0: no errors >0: errors
	CID_REGISTER		cid;			// CID Register
	CSD_REGISTER		csd;			// CSD Register
	OCR_REGISTER		ocr;			// OCR Register
	unsigned short		checkCRC;		// 1: enable CRC checking...
	unsigned long		SIZEFREE;		// root size free
} CARD_INFO;

typedef struct
{
	/* contains all the relevant persistent settings of the data logger */
	unsigned char					dirty;
	unsigned char 					modes;
	unsigned short					pors;
	float							batteryProtectionVoltage;
	TIME_T							lastSyncTime;
	VIRTUAL_MACHINE_ENVIRONMENT		ven;	
	unsigned char					cardLED;
	unsigned char					CRC;
} DATA_LOGGER;

typedef union
{
	DATA_LOGGER 	dataLogger;
	unsigned char  	generalMemory[GENERAL_MEMORY_SIZE];
} DATA_LOGGER_CONTAINER;

typedef struct
{
   double  avgs[AVGS];
   int     avgsIndex;
   int     avgsNum;
   int     avgsMax;
} AVERAGED_OBJECT;

/* These are Persistent Local Settings to the PC Host! */

typedef struct
{
   unsigned int    timeShowMode;
   unsigned long   lastSyncDuration;
   unsigned int	   voltageShowMode;
   float		   fontSize;
   AVERAGED_OBJECT relError;
   int			   optimizeCode;
   unsigned long   lastSyncDifference;		/* In seconds, the last difference in time between PC and device, just before it was synchronised */
   float		   timeSpeed;
   unsigned long   timeOffset;
   unsigned char   timeScaling;
   float		   effectiveSpeed;
   TIME_T		   timeHostStarted;
   unsigned int    serialPortNum;
   unsigned char   verboseMode;
   unsigned char   persistentLog;
   unsigned char   wideEditorWindow;
   unsigned char   checkDeletes;
   /* This must be last */
   unsigned char CRC;
} LOCAL_SETTINGS;

#pragma pack(pop)

/* File status structure */
extern DATA_LOGGER_CONTAINER thisUDL;
extern DATA_LOGGER_CONTAINER localUDL;

unsigned char* 	pointEndString(unsigned char*);
unsigned char* 	appendString(unsigned char*, unsigned char*, int);
unsigned char* 	copyString(unsigned char*, unsigned char*);
unsigned char* 	copyStringLimited(unsigned char*, unsigned char*, int);
int 			stringLength(unsigned char* instr);
unsigned char* 	copyStringRom(unsigned char* first, const unsigned char* second);
int 			compareString(unsigned char* first, unsigned char* second, int maxsize);
unsigned char 	convertToUpper(unsigned char in);
int 			compareStringCaseInsensitive(unsigned char* first, unsigned char* second, int maxsize);
int 			findInString(unsigned char* first, unsigned char* second, int lengthOfSecondString, int maxsize);
unsigned long 	myatol(unsigned char* instr); 
long 			extractNumber(char* instring);
float 			extractFloat(char* instring);
long 			extractNumberBinary(unsigned char* inbuffer, int sizeInBytes);
unsigned char* 	putNumberBinary(unsigned char* outbuffer, long x, int sizeInBytes);
double			getRawValue(int);
int				putDataLogger(DATA_LOGGER* dl);
int				getDataLogger(DATA_LOGGER* dl);
extern unsigned char   firstPor;

#endif
