;********************************************************************
;                                                                   *
;    FILENAME:	    PAVTSG.ASM										*
;    DATE:          10/02/2006                                      *
;    FILE VERSION:  20MHZ; PortB input; Pulse & Bar; LED            *
;                                                                   *
;    AUTHOR:   	MICK GERGOS	                                      	*
; 		                                                      		*
;********************************************************************

		list      p=16f84a     	; list directive to define processor
		#include <p16f84a.inc>  ; processor specific variable definitions

		__CONFIG   _CP_ON & _WDT_OFF & _PWRTE_ON & _HS_OSC

;**************** variable definitions *******************************************

cnt1	equ	0x0e			; variable address used for default Vtimer
cnt2	equ	0x0f			; variable address used for video
cnt3	equ	0x10			; variable address used for counting dots & bars
cnt4	equ	0x11			; variable address used for key timer (rotate)
cnt5	equ	0x12			; variable address used for crosshatch and dot
cnt6	equ	0x13			; variable address used to divide 15625Hz to 1562.5Hz
cnt7	equ	0x14			; variable to time audio on
cnt8	equ	0x15			; variable to time audio break
IDEn	equ	0x16			; variable for enabling audio outputs bits 0 & 1

;**************** Constant definitions *******************************************

SYNC	equ	0x10			; sync level
BLACK	equ	0x00			; black level
BLUE	equ	0x01			; blue
RED		equ	0x02			; red
MAGENTA	equ	0x03			; magenta
GREEN	equ	0x04			; green
CYAN	equ 0x05			; cyan
YELLOW	equ	0x06			; yellow
WHITE	equ 0x07			; white level

AUD_ON	equ	0x32			; ID audio on time in fields. Beware of phase!!
AUD_OFF	equ 0x04			; ID audio off time in fields

;*********************************************************************************

		org     0x000     	; processor reset vector

;**************** initialize ports ***********************************************

		bsf		STATUS,RP0	; switch to bank1
		movlw	0xdf		; set option reg [11011111] PORTB pullups-dis,
		movwf	0x81		; tmr0 clk/s internal clk, ps ass to wdt,ps rate/128
		movlw	b'11100000'	; Set PORTA to all output
		movwf	TRISA		; 
		movlw	b'10000000'	; Set bits 0-6 PORTB to outputs
		movwf	TRISB		; Set MSB (bit7) to input
		bcf		STATUS,RP0	; switch to bank0

		clrf	PORTA		;
		clrf	PORTB		;
		bsf		PORTA,2		; configure PORTA ready for pluge

		clrf	IDEn		; Clear audio ID Enable

		movlw	AUD_ON		; Prepare audio break times
		movwf	cnt7		;
		movlw	AUD_OFF		;
		movwf	cnt8		;

;***************  Test code ************************************************



;***************  Colour bars   ************************************************

ColourBars
		call	F1			; vertical block F1

		movlw	0x90		; do 144 times
		movwf	cnt2		; group of lines
		
colf1	call	Hsync		; generate horizontal sync pulse	23
		call	Col
		call	Timer4		; 4 nops
		call	Hsync		; generate horizontal sync pulse
		call	Col
		nop					; 62.6us
		decfsz	cnt2,1		; next
		goto	colf1		; group of lines
		
		call	F2			; vertical block F2

		movlw	0x90		; do 144 times
		movwf	cnt2		; group of lines

colf2	call	Hsync		; generate horizontal sync pulse
		call	Col
		call	Timer4		; 4 nops
		call	Hsync		; generate horizontal sync pulse
		call	Col
		nop
		decfsz	cnt2,1		; next
		goto	colf2		; group of lines
		nop
		call	Hsync		; first half of 623 used for input sense
		movlw	0x27		;
		movwf	cnt1		;
		call	Vtimer		;
		btfsc	cnt4,3		; check if key counter has reached 127
		goto	col3		; 
		incf	cnt4,1		; rotate cnt4
		call	Timer4
		goto	ColourBars	; next frame of colour

col3	btfsc	PORTB,7		; check for button press?
		goto	col4
		nop
		nop
		goto	ColourBars	; next frame of colour

col4	clrf	cnt4		; reload key counter
		goto	White		; goto next pattern

;***************   Full flat field (white) ************************************************

White	call	F1			; vertical block F1

		movlw	0x90		; do 144 times
		movwf	cnt2		; group of lines
		
whtf1	call	Hsync		; generate horizontal sync pulse
		call	Wht
		call	Timer4		; 4 nops
		call	Hsync		; generate horizontal sync pulse
		call	Wht
		nop					; 62.6us
		decfsz	cnt2,1		; next
		goto	whtf1		; group of lines
		
		call	F2			; vertical block F2

		movlw	0x90		; do 144 times
		movwf	cnt2		; group of lines

whtf2	call	Hsync		; generate horizontal sync pulse
		call	Wht
		call	Timer4		; 4 nops
		call	Hsync		; generate horizontal sync pulse
		call	Wht
		nop
		decfsz	cnt2,1		; next
		goto	whtf2		; group of lines
		nop
		call	Hsync		; first half of 623 used for input sense
		movlw	0x27		;
		movwf	cnt1		;
		call	Vtimer		;
		btfsc	cnt4,3		; check if cnt4 has rotated 8 times
		goto	wht3		; 
		incf	cnt4,1		; rotate cnt4
		call	Timer4
		goto	White		; next frame of colour

wht3	btfsc	PORTB,7		; check for button press?
		goto	wht4
		nop
		nop
		goto	White		; next frame of colour

wht4	clrf	cnt4		; reload key counter (rotator)
		goto	Green		; goto next pattern

;***************   Full flat field (green) ************************************************

Green	call	F1			; vertical block F1

		movlw	0x90		; do 144 times
		movwf	cnt2		; group of lines
		
grnf1	call	Hsync		; generate horizontal sync pulse
		call	Grn
		call	Timer4		; 4 nops
		call	Hsync		; generate horizontal sync pulse
		call	Grn
		nop					; 62.6us
		decfsz	cnt2,1		; next
		goto	grnf1		; group of lines
		
		call	F2			; vertical block F2

		movlw	0x90		; do 144 times
		movwf	cnt2		; group of lines

grnf2	call	Hsync		; generate horizontal sync pulse
		call	Grn
		call	Timer4		; 4 nops
		call	Hsync		; generate horizontal sync pulse
		call	Grn
		nop
		decfsz	cnt2,1		; next
		goto	grnf2		; group of lines
		nop
		call	Hsync		; first half of 623 used for input sense
		movlw	0x27		;
		movwf	cnt1		;
		call	Vtimer		;
		btfsc	cnt4,3		; check if cnt4 has rotated 8 times
		goto	grn3		; 
		incf	cnt4,1		; rotate cnt4
		call	Timer4
		goto	Green		; next frame of colour

grn3	btfsc	PORTB,7		; check for button press?
		goto	grn4
		nop
		nop
		goto	Green		; next frame of colour

grn4	clrf	cnt4		; reload key counter (rotator)
		goto	Red			; goto next pattern

;***************   Full flat field (Red) ************************************************

Red		call	F1			; vertical block F1

		movlw	0x90		; do 144 times
		movwf	cnt2		; group of lines
		
redf1	call	Hsync		; generate horizontal sync pulse
		call	Rd
		call	Timer4		; 4 nops
		call	Hsync		; generate horizontal sync pulse
		call	Rd
		nop					; 62.6us
		decfsz	cnt2,1		; next
		goto	redf1		; group of lines
		
		call	F2			; vertical block F2

		movlw	0x90		; do 144 times
		movwf	cnt2		; group of lines

redf2	call	Hsync		; generate horizontal sync pulse
		call	Rd
		call	Timer4		; 4 nops
		call	Hsync		; generate horizontal sync pulse
		call	Rd
		nop
		decfsz	cnt2,1		; next
		goto	redf2		; group of lines
		nop
		call	Hsync		; first half of 623 used for input sense
		movlw	0x27		;
		movwf	cnt1		;
		call	Vtimer		;
		btfsc	cnt4,3		; check if cnt4 has rotated 8 times
		goto	red3		; 
		incf	cnt4,1		; rotate cnt4
		call	Timer4
		goto	Red			; next frame of colour

red3	btfsc	PORTB,7		; check for button press?
		goto	red4
		nop
		nop
		goto	Red		; next frame of colour

red4	clrf	cnt4		; reload key counter (rotator)
		goto	Blue		; goto next pattern

;***************   Full flat field (Blue) ************************************************

Blue	call	F1			; vertical block F1

		movlw	0x90		; do 144 times
		movwf	cnt2		; group of lines
		
bluf1	call	Hsync		; generate horizontal sync pulse
		call	Blu
		call	Timer4		; 4 nops
		call	Hsync		; generate horizontal sync pulse
		call	Blu
		nop					; 62.6us
		decfsz	cnt2,1		; next
		goto	bluf1		; group of lines
		
		call	F2			; vertical block F2

		movlw	0x90		; do 144 times
		movwf	cnt2		; group of lines

bluf2	call	Hsync		; generate horizontal sync pulse
		call	Blu
		call	Timer4		; 4 nops
		call	Hsync		; generate horizontal sync pulse
		call	Blu
		nop
		decfsz	cnt2,1		; next
		goto	bluf2		; group of lines
		nop
		call	Hsync		; first half of 623 used for input sense
		movlw	0x27		;
		movwf	cnt1		;
		call	Vtimer		;
		btfsc	cnt4,3		; check if cnt4 has rotated 8 times
		goto	blu3		; 
		incf	cnt4,1		; rotate cnt4
		call	Timer4
		goto	Blue		; next frame of colour

blu3	btfsc	PORTB,7		; check for button press?
		goto	blu4
		nop
		nop
		goto	Blue		; next frame of colour

blu4	clrf	cnt4		; reload key counter (rotator)
		goto	Black		; goto next pattern

;***************   Full flat field (Black) ************************************************

Black	call	F1			; vertical block F1

		movlw	0x90		; do 144 times
		movwf	cnt2		; group of lines
		
blkf1	call	Hsync		; generate horizontal sync pulse
		call	Blk
		call	Timer4		; 4 nops
		call	Hsync		; generate horizontal sync pulse
		call	Blk
		nop					; 62.6us
		decfsz	cnt2,1		; next
		goto	blkf1		; group of lines
		
		call	F2			; vertical block F2

		movlw	0x90		; do 144 times
		movwf	cnt2		; group of lines

blkf2	call	Hsync		; generate horizontal sync pulse
		call	Blk
		call	Timer4		; 4 nops
		call	Hsync		; generate horizontal sync pulse
		call	Blk
		nop
		decfsz	cnt2,1		; next
		goto	blkf2		; group of lines
		nop
		call	Hsync		; first half of 623 used for input sense
		movlw	0x27		;
		movwf	cnt1		;
		call	Vtimer		;
		btfsc	cnt4,3		; check if cnt4 has rotated 8 times
		goto	blk3		; 
		incf	cnt4,1		; rotate cnt4
		call	Timer4
		goto	Black		; next frame of colour

blk3	btfsc	PORTB,7		; check for button press?
		goto	blk4
		nop
		nop
		goto	Black		; next frame of colour

blk4	clrf	cnt4		; reload key counter (rotator)
		goto	Crosshatch	; goto next pattern

;********************* Crosshatch ************************************************

Crosshatch	
		call	F1			; vertical block f1

		movlw	0x0f		; do 15 times
		movwf	cnt2		; group of lines

		call	Hsync		; First line is Dtln
		call	Dtln		;
		call	Timer4		;
		call	Hsync		; Second line Wht line
		call	Wht			;
		call	Timer4		;
		
crossf1	call	Hsync		; generate horizontal sync pulse	22
		call	Dtln
		movlw	0x11		; prep for crosshatch / dot
		movwf	cnt5		; sets vertical spacing to (17+2) lines
		nop					; 
crs1	nop
		call	Hsync		; generate horizontal sync pulse
		call	Dtln
		decfsz	cnt5,1		; count lines
		goto	crs1
		nop
		nop
		call	Hsync		; generate horizontal sync pulse
		call	Wht
		nop					; 62.6us
		decfsz	cnt2,1		; next
		goto	crossf1		; group of lines
		nop

		call	Hsync		; Last line Dtln
		call	Dtln		;
		nop
		nop
		nop
		
		call	F2			; vertical block f2

		movlw	0x0f		; do 15 times
		movwf	cnt2		; group of lines

		call	Hsync		; First line is Dtln
		call	Dtln		;
		call	Timer4		;
		call	Hsync		; Second line Wht line
		call	Wht			;
		call	Timer4		;

crossf2	call	Hsync		; generate horizontal sync pulse	336
		call	Dtln
		movlw	0x11		; prep for crosshatch / dot
		movwf	cnt5		; sets vertical spacing to (17+2) lines
		nop					; 
crs2	nop
		call	Hsync		; generate horizontal sync pulse
		call	Dtln
		decfsz	cnt5,1		; count lines
		goto	crs2
		nop
		nop
		call	Hsync		; generate horizontal sync pulse
		call	Wht
		nop
		decfsz	cnt2,1		; next
		goto	crossf2		; group of lines
		nop

		call	Hsync		; Last line Dtln
		call	Dtln		;
		call	Timer4		;

		call	Hsync		; first half of 623 used for input sense
		movlw	0x27		;
		movwf	cnt1		;
		call	Vtimer		;
		btfsc	cnt4,3		; check if cnt4 has rotated 8 times
		goto	crs3		; 
		incf	cnt4,1		; rotate cnt4
		call	Timer4
		goto	Crosshatch	; next frame of colour

crs3	btfsc	PORTB,7		; check for button press?
		goto	crs4
		nop
		nop
		nop
		goto	Crosshatch	; next frame of colour

crs4	clrf	cnt4		; reload key counter (rotator)
		goto	Dot			; goto next pattern

;********************* Dot pattern ************************************************

Dot	
		call	F1			; vertical block f1

		movlw	0x0f		; do 15 times
		movwf	cnt2		; group of lines

		call	Hsync		; First line is Dtln
		call	Blk		;
		call	Timer4		;
		call	Hsync		; Second line Wht line
		call	Dtln		;
		call	Timer4		;
		
dotf1	call	Hsync		; generate horizontal sync pulse	22
		call	Blk
		movlw	0x11		; prep for crosshatch / dot
		movwf	cnt5		; sets vertical spacing to (17+2) lines
		nop					; 
dot1	nop
		call	Hsync		; generate horizontal sync pulse
		call	Blk
		decfsz	cnt5,1		; count lines
		goto	dot1
		nop
		nop
		call	Hsync		; generate horizontal sync pulse
		call	Dtln
		nop					; 62.6us
		decfsz	cnt2,1		; next
		goto	dotf1		; group of lines
		nop

		call	Hsync		; Last line Dtln
		call	Blk		;
		nop
		nop
		nop
		
		call	F2			; vertical block f2

		movlw	0x0f		; do 15 times
		movwf	cnt2		; group of lines

		call	Hsync		; First line is Dtln
		call	Blk		;
		call	Timer4		;
		call	Hsync		; Second line Wht line
		call	Dtln		;
		call	Timer4		;

dotf2	call	Hsync		; generate horizontal sync pulse	336
		call	Blk
		movlw	0x11		; prep for crosshatch / dot
		movwf	cnt5		; sets vertical spacing to (17+2) lines
		nop					; 
dot2	nop
		call	Hsync		; generate horizontal sync pulse
		call	Blk
		decfsz	cnt5,1		; count lines
		goto	dot2
		nop
		nop
		call	Hsync		; generate horizontal sync pulse
		call	Dtln
		nop
		decfsz	cnt2,1		; next
		goto	dotf2		; group of lines
		nop

		call	Hsync		; Last line Dtln
		call	Blk			;
		call	Timer4		;

		call	Hsync		; first half of 623 used for input sense
		movlw	0x27		;
		movwf	cnt1		;
		call	Vtimer		;
		btfsc	cnt4,3		; check if cnt4 has rotated 8 times
		goto	dot3		; 
		incf	cnt4,1		; rotate cnt4
		call	Timer4
		goto	Dot			; next frame of colour

dot3	btfsc	PORTB,7		; check for button press?
		goto	dot4
		nop
		nop
		nop
		goto	Dot			; next frame of colour

dot4	clrf	cnt4		; reload key counter (rotator)
		goto	Pluge		; goto next pattern

;********************* Pluge Pattern ************************************************

Pluge	call	F1			; vertical block F1

		movlw	0x90		; do 144 times
		movwf	cnt2		; group of lines
		
pluf1	call	Hsync		; generate horizontal sync pulse
		call	Plu
		call	Timer4		; 4 nops
		call	Hsync		; generate horizontal sync pulse
		call	Plu
		nop					; 62.6us
		decfsz	cnt2,1		; next
		goto	pluf1		; group of lines
		
		call	F2			; vertical block F2

		movlw	0x90		; do 144 times
		movwf	cnt2		; group of lines

pluf2	call	Hsync		; generate horizontal sync pulse
		call	Plu
		call	Timer4		; 4 nops
		call	Hsync		; generate horizontal sync pulse
		call	Plu
		nop
		decfsz	cnt2,1		; next
		goto	pluf2		; group of lines
		nop
		call	Hsync		; first half of 623 used for input sense
		movlw	0x27		;
		movwf	cnt1		;
		call	Vtimer		;
		btfsc	cnt4,3		; check if cnt4 has rotated 8 times
		goto	plu3		; 
		incf	cnt4,1		; rotate cnt4
		call	Timer4
		goto	Pluge		; next frame of colour

plu3	btfsc	PORTB,7		; check for button press?
		goto	plu4
		nop
		nop
		goto	Pluge		; next frame of colour

plu4	clrf	cnt4		; reload key counter (rotator)
		goto	ColourBars	; goto next pattern

;***************  Colourbar line  ******************************

Col		movlw	0x05		; back porch Vtimer
		movwf	cnt1		; 
		call	Vtimer		; back porch = 10us from neg edge of Hsync
		nop
		movlw	WHITE		; 
		movwf	PORTB		; start with white bar
		movwf	cnt3		; 7 coulour bars
		call	Timer4
col1	movlw	0x07		; Vtimer
		movwf	cnt1		;
		call 	Vtimer		; Each colour bar 6.4us
		nop
		nop
		decf	PORTB,1		; Next bar
		decfsz	cnt3,1		; 
		goto	col1		;

		movlw	0x09		; Vtimer
		movwf	cnt1		;
		call 	Vtimer		; end of active video line/start back porch 52.0us

		return				; back porch = 2us duration

;***************  White line  ******************************

Wht		movlw	0x05		; back porch Vtimer
		movwf	cnt1		; 
		call 	Vtimer		; back porch = 10us from neg edge of Hsync
		nop
		movlw	WHITE		; load value of rgb
		movwf	PORTB		; start of active video line
		
		movlw	0x54		;
		movwf	cnt1		;
		call	Vtimer		; active video line = 52us duration
		nop
		
		movlw	BLACK		;
		movwf	PORTB		; end of active video line/start back porch

		return				; back porch = 2us duration

;***************  Green line  ******************************

Grn		movlw	0x05		; back porch Vtimer
		movwf	cnt1		; 
		call 	Vtimer		; back porch = 10us from neg edge of Hsync
		nop
		movlw	GREEN		; load value of rgb
		movwf	PORTB		; start of active video line
		
		movlw	0x54		;
		movwf	cnt1		;
		call	Vtimer		; active video line = 52us duration
		nop
		
		movlw	BLACK		;
		movwf	PORTB		; end of active video line/start back porch

		return				; back porch = 2us duration

;***************  Red line  ******************************

Rd		movlw	0x05		; back porch Vtimer
		movwf	cnt1		; 
		call 	Vtimer		; back porch = 10us from neg edge of Hsync
		nop
		movlw	RED			; load value of rgb
		movwf	PORTB		; start of active video line
		
		movlw	0x54		;
		movwf	cnt1		;
		call	Vtimer		; active video line = 52us duration
		nop
		
		movlw	BLACK		;
		movwf	PORTB		; end of active video line/start back porch

		return				; back porch = 2us duration

;***************  Blue line  ******************************

Blu		movlw	0x05		; back porch Vtimer
		movwf	cnt1		; 
		call 	Vtimer		; back porch = 10us from neg edge of Hsync
		nop
		movlw	BLUE		; load value of rgb
		movwf	PORTB		; start of active video line
		
		movlw	0x54		;
		movwf	cnt1		;
		call	Vtimer		; active video line = 52us duration
		nop
		
		movlw	BLACK		;
		movwf	PORTB		; end of active video line/start back porch

		return				; back porch = 2us duration

;***************  Black line  ******************************

Blk		movlw	0x5c		; Blk line timer only
		movwf	cnt1		; 
		call 	Vtimer		; 
		nop					;
		nop					;
		return				; 

;***************  Dot line  ******************************

Dtln	movlw	0x04		; back porch Vtimer
		movwf	cnt1		; 
		call 	Vtimer		; back porch = 10us from neg edge of Hsync
		nop
		nop
		movlw	0x14		; No. of dots
		movwf	cnt3		; 

dtln1	movlw	WHITE		; load white for first dot
		movwf	PORTB		; step to white. Start of active video line 0us
		clrf	PORTB		; step to black
		call	Timer4		;
		nop
		nop
		nop
		decfsz	cnt3,1		;
		goto	dtln1		;
		movlw	WHITE		; Last dot
		movwf	PORTB		;
		clrf	PORTB		; 52.0us
		return				; 52.2us

;***************  Pluge line  ******************************

Plu		movlw	0x05		; back porch Vtimer
		movwf	cnt1		; 
		call	Vtimer		; back porch = 10us from neg edge of Hsync
		nop
		movlw	BLACK		; 
		movwf	PORTB		; 0us - Start of active video line
		movlw	0x0d		;
		movwf	cnt1		;
		call	Vtimer		; 
		nop

		bsf		PORTA,3		; 18.8us - Lighter than black
		movlw	0x06		;
		movwf	cnt1		;
		call	Vtimer		;

		bcf		PORTA,3		; 23.6 - Black
		movlw	0x06		;
		movwf	cnt1		;
		call	Vtimer		;

		bcf		PORTA,2		; 9.2us - Blacker than black 
		movlw	0x06		;
		movwf	cnt1		;
		call	Vtimer		;

		bsf		PORTA,2		; 14us - Black
		movlw	0x05		; 
		movwf	cnt1		;
		call	Vtimer		;
		nop
		nop

		movlw	WHITE		;
		movwf	PORTB		; 28.4 - 2T Pulse
		clrf	PORTB		;
		movlw	0x05		; 
		movwf	cnt1		;
		call	Vtimer		;
		nop
		movlw	WHITE		;
		movwf	PORTB		; 33.2 - Bar
		movlw	0x05		;
		movwf	cnt1		;
		call	Vtimer		;
		nop
		nop
		movlw	WHITE
		clrf	PORTB		; 38us - !2T Pulse
		movwf	PORTB
		movlw	0x05		; 
		movwf	cnt1		;
		call	Vtimer		;
		nop
		nop
		clrf	PORTB		; 42.8us - End in black 
		movlw	0x0d		; 
		movwf	cnt1		;
		call	Vtimer		; 
		nop
		nop					; 52us - End of line

		return				; back porch = 2us duration

;***************  Vertical block, field 1  ******************************

F1		movlw	SYNC		;
		movwf	PORTB		; low = 32us	last half of 623
		call	Timer8
		nop
		nop
		movlw	BLACK		;
		movwf	PORTB		; high = 34.4us
		movlw	0x2f		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	SYNC		;
		movwf	PORTB		; low = 64us			624
		call	Timer4		;
		movf	IDEn,0		;
		xorwf	PORTA,1		; Toggle ID audio
		call	Timer4
		movlw	BLACK		;
		movwf	PORTB		; high = 66.4us
		movlw	0x2f		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	SYNC		;
		movwf	PORTB		; low = 96us		
		call	Timer8
		nop
		nop
		movlw	BLACK		;
		movwf	PORTB		; high = 98.4us
		movlw	0x2f		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	SYNC		;
		movwf	PORTB		; low = 128us			625
		call	Timer4		;
		movf	IDEn,0		;
		xorwf	PORTA,1		; Toggle ID audio
		call	Timer4
		movlw	BLACK		;
		movwf	PORTB		; high = 130.4us
		movlw	0x2f		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	SYNC		;
		movwf	PORTB		; low = 160us	
		call	Timer8
		nop
		nop
		movlw	BLACK		;
		movwf	PORTB		; high = 162.4us
		movlw	0x2e		;
		movwf	cnt1		;
		call	Vtimer		;
		nop					; Field 1 ID
		nop					; Field 1 ID
		nop					; Field 1 ID
		movlw	SYNC		;
		movwf	PORTB		; low = 192us			1
		nop
		nop	
		movlw	0x2a		; Load value for Vtimer
		movwf	cnt1		;
		movlw	0x03		; 
		xorwf	PORTA,1		; Toggle audio
		call	Vtimer		;
		movlw	BLACK		;
		movwf	PORTB		; high = 219.4us
		movlw	0x04		;
		movwf	cnt1		;
		call	Vtimer		;
		call	Timer4
		movlw	SYNC		;
		movwf	PORTB		; low = 224us
		movlw	0x2b		;
		movwf	cnt1		;
		call	Vtimer		;
		nop
		movlw	BLACK		;
		movwf	PORTB		; high = 251.4us
		movlw	0x04		;
		movwf	cnt1		;
		call	Vtimer		;
		call	Timer4
		movlw	SYNC		;
		movwf	PORTB		; low = 256us			2
		nop
		nop	
		movlw	0x2a		; Load value for Vtimer
		movwf	cnt1		;
		movf	IDEn,0		;
		xorwf	PORTA,1		; Toggle ID audio
		call	Vtimer		;
		movlw	BLACK		;
		movwf	PORTB		; high = 283.4us
		movlw	0x04		;
		movwf	cnt1		;
		call	Vtimer		;
		call	Timer4
		movlw	SYNC		;
		movwf	PORTB		; low = 288us
		movlw	0x2b		;
		movwf	cnt1		;
		call	Vtimer		;
		nop
		movlw	BLACK		;
		movwf	PORTB		; high = 315.4us
		movlw	0x04		;
		movwf	cnt1		;
		call	Vtimer		;
		call	Timer4
		movlw	SYNC		;
		movwf	PORTB		; low = 320us			3
		nop
		nop	
		movlw	0x2a		; Load value for Vtimer
		movwf	cnt1		;
		movf	IDEn,0		;
		xorwf	PORTA,1		; Toggle ID audio
		call	Vtimer		;
		movlw	BLACK		;
		movwf	PORTB		; high = 347.4us
		movlw	0x04		;
		movwf	cnt1		;
		call	Vtimer		;
		call	Timer4
		movlw	SYNC		;
		movwf	PORTB		; low = 352us
		call	Timer8
		nop
		nop
		movlw	BLACK		;
		movwf	PORTB		; high = 354.4us
		movlw	0x2f		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	SYNC		;
		movwf	PORTB		; low = 384us			4
		call	Timer4		;
		movf	IDEn,0		;
		xorwf	PORTA,1		; Toggle ID audio
		call	Timer4
		movlw	BLACK		;
		movwf	PORTB		; high = 386.4us
		movlw	0x2f		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	SYNC		;
		movwf	PORTB		; low = 416us
		call	Timer8
		nop
		nop
		movlw	BLACK		;
		movwf	PORTB		; high = 418.4us
		movlw	0x2f		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	SYNC		;
		movwf	PORTB		; low = 448us			5
		call	Timer4		;
		movf	IDEn,0		;
		xorwf	PORTA,1		; Toggle ID audio
		call	Timer4
		movlw	BLACK		;
		movwf	PORTB		; high = 450.4us
		movlw	0x2f		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	SYNC		;
		movwf	PORTB		; low = 480us			
		call	Timer8
		nop
		nop
		movlw	BLACK		;
		movwf	PORTB		; high = 482.4us

		movlw	0x28		;
		movwf	cnt1		;
		call	Vtimer		;

		call	AudBrk		; 15 instruction cycles

		movlw	0x01		; Prepare audio counter
		movwf	cnt6		; 
		movlw	0x10		; do 16 black lines
		movwf	cnt2		; 

vblank1	call	Hsync		; generate Hsync pulse			6-21
		call	Blk			; first full line of vblank period
		nop
		decfsz	cnt2,1		; next
		goto	vblank1		; group of lines
		nop
		call	Hsync		; last full line of blank period	21
		call	Blk			;

		return				; 

;***************  Vertical block, field 2  ***********************************

F2		nop
		movlw	SYNC
		movwf	PORTB		; low = 0us			311
		call	Timer4
		movlw	0x03
		xorwf	PORTA,1		; Toggle audio
		call	Timer4
		movlw	BLACK		;
		movwf	PORTB		; high = 2.4us
		movlw	0x2f		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	SYNC		;
		movwf	PORTB		; low = 32us
		call	Timer8
		nop
		nop
		movlw	BLACK		;
		movwf	PORTB		; high = 34.4us
		movlw	0x2f		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	SYNC		;
		movwf	PORTB		; low = 64us			312
		call	Timer4		;
		movf	IDEn,0		;
		xorwf	PORTA,1		; Toggle ID audio
		call	Timer4
		movlw	BLACK		;
		movwf	PORTB		; high = 66.4us
		movlw	0x2f		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	SYNC		;
		movwf	PORTB		; low = 96us
		call	Timer8
		nop
		nop
		movlw	BLACK		;
		movwf	PORTB		; high = 98.4us
		movlw	0x2e		;
		movwf	cnt1		;
		call	Vtimer		;
		nop
		nop
		nop					; Field 2 ID
		movlw	SYNC		;
		movwf	PORTB		; low = 128us			313
		call	Timer4		;
		movf	IDEn,0		;
		xorwf	PORTA,1		; Toggle ID audio
		call	Timer4
		movlw	BLACK		;
		movwf	PORTB		; high = 130.4us
		movlw	0x2f		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	SYNC		;
		movwf	PORTB		; low = 160us  start vsync pulse F2
		movlw	0x2b		;
		movwf	cnt1		;
		call	Vtimer		;
		nop
		movlw	BLACK		;
		movwf	PORTB		; high = 187.4us
		movlw	0x04		;
		movwf	cnt1		;
		call	Vtimer		;
		call	Timer4
		movlw	SYNC		;
		movwf	PORTB		; low = 192us			314
		nop
		nop	
		movlw	0x2a		; Load value for Vtimer
		movwf	cnt1		;
		movf	IDEn,0		;
		xorwf	PORTA,1		; Toggle ID audio
		call	Vtimer		;
		movlw	BLACK		;
		movwf	PORTB		; high = 219.4us
		movlw	0x04		;
		movwf	cnt1		;
		call	Vtimer		;
		call	Timer4
		movlw	SYNC		;
		movwf	PORTB		; low = 224us			
		movlw	0x2b		;
		movwf	cnt1		;
		call	Vtimer		;
		nop
		movlw	BLACK		;
		movwf	PORTB		; high = 251.4us
		movlw	0x04		;
		movwf	cnt1		;
		call	Vtimer		;
		call	Timer4
		movlw	SYNC		;
		movwf	PORTB		; low = 256us			315
		nop
		nop	
		movlw	0x2a		; Load value for Vtimer
		movwf	cnt1		;
		movf	IDEn,0		;
		xorwf	PORTA,1		; Toggle ID audio
		call	Vtimer		;
		movlw	BLACK		;
		movwf	PORTB		; high = 283.4us
		movlw	0x04		;
		movwf	cnt1		;
		call	Vtimer		;
		call	Timer4
		movlw	SYNC		;
		movwf	PORTB		; low = 288us			
		movlw	0x2b		;
		movwf	cnt1		;
		call	Vtimer		;
		nop
		movlw	BLACK		;
		movwf	PORTB		; high = 315.4us
		movlw	0x04		;
		movwf	cnt1		;
		call	Vtimer		;
		call	Timer4
		movlw	SYNC		;
		movwf	PORTB		; low = 320us			316
		call 	Timer4		;
		movlw	0x03
		xorwf	PORTA,1		; Toggle audio
		call	Timer4
		movlw	BLACK		;
		movwf	PORTB		; high = 322.4us
		movlw	0x2f		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	SYNC		;
		movwf	PORTB		; low = 352us			
		call	Timer8
		nop
		nop
		movlw	BLACK		;
		movwf	PORTB		; high = 354.4us
		movlw	0x2f		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	SYNC		;
		movwf	PORTB		; low = 384us			317
		call	Timer4		;
		movf	IDEn,0		;
		xorwf	PORTA,1		; Toggle ID audio
		call	Timer4
		movlw	BLACK		;
		movwf	PORTB		; high = 386.4us
		movlw	0x2f		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	SYNC		;
		movwf	PORTB		; low = 416us	
		call	Timer8
		nop
		nop
		movlw	BLACK		;
		movwf	PORTB		; high = 418.4us
		movlw	0x2d		;
		movwf	cnt1		;
		call	Vtimer		;
		movlw	0x04		; Prepare audio counter
		movwf	cnt6		; 
		movlw	0x10		; do 16 black lines
		movwf	cnt2		; 

vblank2	call	Hsync		; generate Hsync pulse			318-334
		call	Blk			; first full line of vblank period
		nop
		decfsz	cnt2,1		; next
		goto	vblank2		; group of lines
		nop
		call	Hsync		; last full line of blank period	335
		call	Blk			;

		return				;

;***************   Timer subroutines   *******************************

Vtimer	decfsz	cnt1,1		; Variable timer
		goto	Vtimer		
		return

Timer4	return				; 4 nop timer

Timer8	call	Timer4		; 8 nop timer
		return

;***************  Horizontal sync pulse  ******************************

Hsync	movlw	SYNC		; 
		movwf	PORTB		; neg edge    !!!!!timing reference!!!!!

Audio	decfsz	cnt6,1		; cnt6=0?
		goto	aud1		; If not, do nothing
		nop					;
		nop					;
		movlw	0x03		;
		xorwf	PORTA,1		; Toggle audio outputs
		movlw	0x05		; Reload audio divider (%5)
		movwf	cnt6		; register
		goto	aud2

aud1	nop
		movf	IDEn,0		; Toggle ID audio
		xorwf	PORTA,1		;
		call	Timer4		;
aud2	call	Timer8
		nop
		nop
		nop					; horizontal sync tip = 4.6us
		movlw	BLACK		;
		movwf	PORTB		; pos edge
		return

;***************  Audio break routine  ******************************

AudBrk	btfsc	IDEn,1		; Is ID on?
		goto	brk2		; yes, goto brk2
		nop					; no, goto brk1
brk1	decfsz	cnt7,1		; Tone ended?
		goto	brk3		; no, 
		bsf		IDEn,1		; yes, enable ID
		bcf		PORTA,4		; Power LED on
		movlw	AUD_ON		; Reset audio on counter
		movwf	cnt7		;
		goto	brk4		;

brk2	decfsz	cnt8,1		; ID ended?
		goto	brk3		; no,
		bcf		IDEn,1		; yes, disable ID
		bsf		PORTA,4		; Power LED off
		movlw	AUD_OFF		; Reset audio off counter
		movwf	cnt8		;
		goto	brk4		;

brk3	call	Timer4		;
		nop					;
brk4	return				;

;***************  End of program  ***********************************

		end                 ; directive 'end of program'





		

