/* 
  Based on Silicon Chip IR_Helper.ino by Tim Blythman, Silicon Chip September 2024, page 66-67.
  uses a Jaycar XC4431 Leonardo Tiny board ATmega32u4 module. Run my IR_HELPER_with_Case.ino first to 
  obtain each remote's IrSender.sendremotename(address, Command, number of repeats) for use below.
  This has been tested with remotes from a Denon Amplifier, Panasonic TV and an old Sony TV.
  Serial.println() = is for Serial Monitor (debugging).
  Serial.print(command); shows case number of IR data received.
  The two sketches and PCB are by Robbie Adams, Tauranga, NZ. 
*/

#include <IRremote.hpp> //very essential library by Ken Shirriff and other contributers
			//containing 35 files and 1000's of code lines to compile this sketch.

#define IR_RX_PIN 11
#define IR_SEND_PIN A0
#define LED_PIN 13
#define ON_DELAY 5000
#define RX_ADDRESS 0xEF00    //NEC address.   If you change these two lines, I found
#define RX_COMMAND 7         //NEC command.   that board does not receive IR signals. 

void powerOnAction(void){  // TV power up function sending 2 commands to Denon amplifier.
  flashLED();
  IrSender.sendKaseikyo_Denon(0x514, 0x0,2); //Denon raw data 0x11005140
  Serial.println("Denon POWER Up Done");   //Denon remote POWER code sent.
  delay(3000);                 //3 seconds time for amplifier to settle on power up.
  IrSender.sendKaseikyo_Denon(0x214, 0x2D,2);//raw data 0x4C2D2140 
  Serial.println("Denon input TV AUDIO selected, ready for use"); //Set Denon input to TV AUDIO.
  delay(100);               
  IrReceiver.resume();  // Important, resets to receive the next IR signal.  
}

void setup() {
  Serial.begin(115200);
  IrReceiver.begin(IR_RX_PIN,false);        
  IrSender.begin(IR_SEND_PIN,false,0);  
  delay(ON_DELAY);
  powerOnAction();
}

void loop() {
  if (IrReceiver.decode()) {
    uint16_t command = IrReceiver.decodedIRData.command;// Used by Panasonic & Sharp [16-bits]
    Serial.print(command);//debug line to shown case number received, for use below.
    switch (command) { 
      flashLED(); 
      case 61: //Panasonic POWER code 0xBD3D //case = which Panasonic COMMAND received
        Serial.println(" POWER");            // turns TV and amplifier off
        IrSender.sendKaseikyo_Denon(0x514, 0x0,2);//raw data 0x11005140 (Denon POWER button)
        // In IRsend = public: void IRsend::sendKaseikyo_Denon(uint16_t aAddress, uint8_t aCommand,
        // int_fast8_t aNumberOfRepeats)
        break;
      case 50:     //Panasonic MUTE code 0xB232
        Serial.println(" MUTE");             
        IrSender.sendKaseikyo_Denon(0x214, 0x17,2); //raw data 0x76172140 (Denon MUTE button) 
        break;     //---------------------- start of volume control ------------------
      case 32: // Pansonic VOL+ code 0xA020 
        Serial.println(" VOL+");
        uint8_t k;        // this counting loop provides more outgoing pulses for each button push,           
        for (k = 0; k < 10; k++) // no need to hold button down. Note more flashes of visible LED.
        {
        IrSender.sendKaseikyo_Denon(0x14, 0x17,3); // raw data 0x56170140 (Denon VOL+ button).
        delay(100);                       // the VOL+ and VOL- sections of code was contributed by
        }		                  // kmin of the Arduino Forum.			
        break;		
      case 33: // Pansonic VOL- code 0xA121 
        Serial.println(" VOL-");  //note value "10" x number of repeats changes rate of volume up/down.
        uint8_t j;             
        for (j = 0; j < 10; j++)
        { 
        IrSender.sendKaseikyo_Denon(0x114, 0x17,3);// raw data 0x46171140 (Denon VOL- button).
        delay(100);  // adjust number of repeats - 3 x 10 was best for my amplifier, 5 x 10 repeats
        }            // caused too much volume up/down change for my setup.
        break;     //   --------------- end of volume control ------------------------
      default:
        Serial.println(" = Case, use of UNDEFINED, sending received code out anyway");	
       	//if not any case used above then output received command as a IR Repeater using -
        IrSender.write(IrReceiver.read(), 1); 	
        //this line was contibuted by Matthew Taylor, Silicon Chip Admin.
        } 	   
	delay(100);
        IrReceiver.resume(); // Important, enables to receive the next IR signal.
  }
}

void flashLED(void){    //turn on IR LED.
  digitalWrite(LED_PIN,HIGH);
  delay(200);
  digitalWrite(LED_PIN,LOW);
}
