/* Modified Silicon Chip IR_Helper.ino by Tim Blythman, Silicon Chip September 2024, page 66-67. 
 Save the Case and Send with: outputted lines for use in IR_Convertor-Repeater.ino by 
Robbie Adams, Tauranga, NZ.
*/

#include <IRremote.hpp>

#define IR_RX_PIN 11
#define IR_SEND_PIN A0
#define LED_PIN 13
#define ON_DELAY 5000
#define RX_ADDRESS 0xEF00 
#define RX_COMMAND 7

void powerOnAction(void){
  flashLED();
  IrSender.sendNEC(0xEF00, 0x2,3);
  Serial.println("SEND OFF");      
}

void triggeredAction(void){
  flashLED();
  IrSender.sendNEC(0xEF00, 0x3,3);
  Serial.println("SEND ON");      
}

void setup() {
  Serial.begin(115200);
  IrReceiver.begin(IR_RX_PIN,false); //no feedback LED as the module has a LED
  IrSender.begin(IR_SEND_PIN,false,0);  
  delay(ON_DELAY);
  powerOnAction();
}

void loop() {
  if (IrReceiver.decode()) {
    uint16_t command = IrReceiver.decodedIRData.command;
    Serial.println("Save Case number and line IrSender.sendremotename(address, Command, number of repeats);");
    Serial.print(command);// debug line to shown case number received, save to Notepad.
    Serial.println( " = case number. Button pressed was - in Notepad, write here -> ");
    }

  int d;
  pinMode(LED_PIN,OUTPUT);
  if(IrReceiver.decode()){    
    Serial.println();
    if(IrReceiver.decodedIRData.protocol==UNKNOWN){
      Serial.println("Unknown Protocol");
      IrReceiver.printIRResultRawFormatted(&Serial, true);
    }else{
      IrReceiver.printIRResultShort(&Serial);
      IrReceiver.printIRSendUsage(&Serial);
      IrSender.write(IrReceiver.read(), 1);//this line contributed by Matthew Taylor, Silicon Chip Admin
      if((IrReceiver.decodedIRData.address==RX_ADDRESS)&&(IrReceiver.decodedIRData.command==RX_COMMAND)){
        Serial.println("Trigger signal received");
        delay(1000);
        triggeredAction();
      }
    }
    IrReceiver.resume();
    Serial.println(" ");
  }
  if(Serial.available()){
    d=Serial.read();                //send a t from Serial Monitor test.
    if((d=='T')||(d=='t')){         
      Serial.println("Testing triggered action");
      triggeredAction();
    }
    if((d=='P')||(d=='p')){         //send a p from Serial Monitor test.
      Serial.println("Testing power-on action");
      powerOnAction();
    }
  }
}

void flashLED(void){
  digitalWrite(LED_PIN,HIGH);
  delay(200);
  digitalWrite(LED_PIN,LOW);
}
