	; -----------------------------------------------------------------------------------------
	; general purpose register allocations
	; -----------------------------------------------------------------------------------------
	cblock 0x70
		; -----------------------------------------------------------------------------------------
		; most commonly used registers
		; -----------------------------------------------------------------------------------------
		A 			; general purpose
		X 			; .	.
		D 			; .	.
		E 			; .	.
		H			; .	.
		L			; .	.
		D1 			; .	. 
		E1 			; .	. 
		H1			; .	.
		L1			; .	.
		err			; error codes
		flags		; flags register (gp)
		tmrcon		; flags register (timer control)
		tmrflags	; flags register (timeouts)
		motorcon	; flags register (motor control)
	endc
	cblock	0x20
		batt		; battery voltage
		pot			; speed pot setting
		ampslo		; motor current (low byte
		ampshi		; motor current (high byte)
		duty		; duty cycle
		maxduty		; maximum duty cycle
		mask		; general purpose mask byte
		eastlo		; east sense input value (low byte)
		easthi		; east sense input value (high byte)
		eastup		; east sense input value (upper byte)
		westlo		; west sense input value (low byte)
		westhi		; west sense input value (high byte)
		westup		; west sense input value (upper byte)
		; ------------------------------------------------------------
		; general purpose timers
		; ------------------------------------------------------------
		tmrlo		; master timer, low byte
		tmrhi		; master timer, high (middle) byte
		tmrup		; master timer, upper byte			
		tmr1lo		; timer 1, general purpose, low byte
		tmr1hi		; timer 1, general purpose, high byte
		tmr2lo		; timer 2, general purpose, low byte
		tmr2hi		; timer 2, general purpose, high byte
		tmr3lo		; timer 3, general purpose, low byte
		tmr3hi		; timer 3, general purpose, high byte
		tmr4lo		; timer 4, general purpose, low byte
		tmr4hi		; timer 4, general purpose, high byte
		tmr5lo		; timer 5, general purpose, low byte
		tmr5hi		; timer 5, general purpose, high byte
		tmr6lo		; timer 6, general purpose, low byte
		tmr6hi		; timer 6, general purpose, high byte
		tmr7lo		; timer 7, general purpose, low byte
		tmr7hi		; timer 7, general purpose, high byte
		tmr8lo		; timer 8, general purpose, low byte
		tmr8hi		; timer 8, general purpose, high byte
		tmr8up		; timer 8, general purpose, upper byte
	endc

