; File:		macros.inc
; -----------------------------------------------------------------------------
; macro:		preset	<xtmr_lo>, <arg> (ms)
; description:	preset slave timer register to timeout after <arg> milliseconds
; registers:	tmrcon
;				tmrflags
;				FSR
;				mask
; -----------------------------------------------------------------------------
preset	macro	xtmr,t0
	if t0 < 1
		exitm
	endif

	local		n, t
	variable	n = 1 << ((xtmr - timers)/ 2)
	variable	t = t0 * d'125' / d'128'

	banksel	timers

	if xtmr == tmr8
		movlw	upper t
		movwf	tmr8up
		if t > (d'65535' * d'256')
			error"argument exceeds range of timer"
		endif
	else
		if t > d'65535'
			error"argument exceeds range of timer"
		endif
	endif

	if t<1
		variable t = 1
	endif

	movlw	high t
	movwf	xtmr+1			; offset, high -> high byte, xtmr
	movlw	low t
	movwf	xtmr			; offset, low -> low byte, xtmr
	movlw	n
	movwf	mask
	movlw	low xtmr
	call	init_tmrx
	endm
; --------------------------------------------------------------
sel_pot		macro		; ------------------
	banksel	ADCON1
	bcf		ADCON1,ADFM	; left justify (8-bit resolution)	
	banksel	ADCON0		; select (speed) pot input
	movlw	0x41		;
	movwf	ADCON0		; sel. RA0, adc = ON
	endm				; ------------------
; --------------------------------------------------------------
sel_trimpot	macro	; ------------------	
	banksel	ADCON1
	bcf		ADCON1,ADFM	; left justify (8-bit resolution)	
	banksel	ADCON0		
	movlw	0x49		; sel. RA1, adc = ON
	movwf	ADCON0		
	endm				; ------------------
; --------------------------------------------------------------
sel_amps	macro
	banksel	ADCON1
	bsf		ADCON1,ADFM	; right justify (10-bit resolution)	
	banksel	ADCON0		
	movlw	0x51		; sel. RA2, adc = ON
	movwf	ADCON0		
	endm				; ------------------
; --------------------------------------------------------------
sel_east	macro
	banksel	ADCON1
	bcf		ADCON1,ADFM	; left justify
	banksel	ADCON0		
	movlw	0x59		; sel. RA3, adc = ON
	movwf	ADCON0		
	endm				; ------------------
; --------------------------------------------------------------
sel_west	macro
	banksel	ADCON1
	bcf		ADCON1,ADFM	; left justify
	banksel	ADCON0		
	movlw	0x61		; sel. RA4, adc = ON
	movwf	ADCON0		
	endm				; ------------------
