/******************************************************************************
 *
 *		D I G I T A L   I N C L I N O M E T E R   M A I N   P R O G R A M 
 *
 */
#pragma config  FOSC = IRC, PLLEN = OFF, PCLKEN = OFF, IESO = OFF, FCMEN = OFF, HFOFST = OFF, LVP = OFF, WDTEN = OFF
#include "accel.h"
#include "display.h"
#include "p18lf14k22.h"

void main(void) {
    uchar event;

    // Configure System
    OSCCONbits.IDLEN = 0;           // SLEEP instruction enters sleep
    OSCCONbits.IRCF = 7;            // 16 MHz Clock
    OSCCONbits.SCS = 2;             // Primary clock only
    ANSEL = 0b00000000;             // No analogue inputs
    RCONbits.IPEN = 1;              // Two-level interrupt priority
    INTCONbits.GIEH = 1;            // Enable hi-priority ints
    INTCONbits.GIEL = 1;            // Enable lo-priority interrupts
    // Initialise drivers
    accInitialise();
    // Configure Accelerometer
    accSet(F_SETUP, 0);             // FIFO disabled
    accSet(XYZ_DATA_CFG, 0);        // 2g, HPF disabled
    accSet(CTRL_REG1, 0x3c);        // 2-byte read, lo noise, 1.56Hz awake & 50Hz asleep
    accSet(CTRL_REG2, 0x1a);        // Hi res awake, no auto sleep, lo res asleep
    accSet(CTRL_REG3, 0x08);        // Int PP, active lo, wake-up on move
    accSet(CTRL_REG4, 0x05);        // Data rdy & move int enabled
    accSet(CTRL_REG5, 0x01);        // Data rdy int ->int1, rest -> int2

    // Config Motion Detect
    accSet(FF_MT_CFG, 0x78);        // noLatch, motion detect all axes
    accSet(FF_MT_THS, 17);          //(0.063g per step, 4g max)
    accSet(FF_MT_COUNT, 2);         //(2.5ms per step, max 0.638s)
    accStart();

    // Loop forever
    while (1);
}

/**********************************************************************
 *     Interrupt service routine - low
 */
#pragma interruptlow isrlo 

void isrlo(void) {
    if (INTCON3bits.INT1IF == 1) {          // accelerometer INT1
        INTCON3bits.INT1IF = 0;
        accInt1isr();
    } else if (INTCONbits.RABIF == 1) {     // accelerometer Cal Button
        INTCONbits.RABIF = 0;
        accCalisr();
    } else if (INTCONbits.TMR0IF == 1) {    // accelerometer Cal Button Timeout
        INTCONbits.TMR0IF = 0;
        accT0isr();
    }
}
/**********************************************************************
 *     Interrupt service routine - high
 */
#pragma interrupt isrhi nosave=FSR0, TBLPTRL, TBLPTRH, TBLPTRU, TABLAT, PCLATH, PCLATU, PROD, section(".tmpdata"), section("MATH_DATA")

void isrhi(void) {
    if (PIR1bits.TMR1IF == 1) { // Timer 1 interrupt
        PIR1bits.TMR1IF = 0;
        dispMux();
    }
    if (PIR1bits.SSPIF == 1) { // I2C interrupt
        PIR1bits.SSPIF = 0;
        i2cStateMachine();
    }
}
#pragma	code
#pragma code invectlo = 0x18

void intvectlo(void) {
    _asm goto isrlo _endasm
}
#pragma code
#pragma code intvecthi = 0x08

void intvecthi(void) {
    _asm goto isrhi _endasm
}