#include "config.h"
#include <xc.h>
#include "io.h"

#define _XTAL_FREQ (32000000UL)
//thresholds (mV) with hysteresis for operation
#define VCC_LOWER 4000
#define VCC_UPPER 4500

__eeprom int cvDefault=0;   //starting DAC CV

void main(void) {
    unsigned int a,i,vcc;  
    char blank=0;       //blanking cycle counter
    int cv=cvDefault;   //this value gets loaded into the DAC to set the voltage
    if(cv<0){cv=0;}     //catch any errors in saved value
    if(cv>255){cv=0;}   
    ioInit();
    boostInit();
    DAC1DATL=(unsigned char)cv;
    tmr2init();
    GIE=1;
    doTouch();
    while(1){      
        doTouch();    
        vcc=getVCC();
        if(vcc<VCC_LOWER){trisbits.SWPIN=1;}   //off
        if(vcc>VCC_UPPER){trisbits.SWPIN=0;}   //on
        if(t[2]){       //if pressed display, set CV
            if(t[0]){cv=cv-1;}  //down
            if(t[1]){cv=cv+1;}  //up
            if(cv<0){cv=0;}
            if(cv>255){cv=255;}
            DAC1DATL=(unsigned char)cv;
            //display
            if(blank){
                LEDimage[0]=0;
                LEDimage[1]=0;
                LEDimage[2]=0;
                LEDimage[3]=0;
            }else{                
                a=adjust((unsigned int)cv*176,dacref);    //176=(4096/256)* 11
                getDigits(a);
                if(digits[4]){  //leading zero blank
                    LEDimage[0]=LEDbm[digits[4]];}
                else{
                    LEDimage[0]=0;
                }
                LEDimage[1]=LEDbm[digits[3]]|0x80;
                LEDimage[2]=LEDbm[digits[2]];
                LEDimage[3]=LEDbm[digits[1]];
            }
        }else{        
            if(t[0]&t[1]){
                getDigits(vcc);
                LEDimage[0]=LEDbm[0xb];  //display 'b'
                LEDimage[1]=0;           //blank
                LEDimage[2]=LEDbm[digits[3]]|0x80;
                LEDimage[3]=LEDbm[digits[2]];                
            }else{
                initADC();
                a=0;
                for(i=0;i<11;i++){a=a+getADC(FBPIN);}
                a=adjust(a,adcref);
                getDigits(a);
                if(digits[4]){  //leading zero blank
                    LEDimage[0]=LEDbm[digits[4]];}
                else{
                    LEDimage[0]=0;
                }
                LEDimage[1]=LEDbm[digits[3]]|0x80;
                LEDimage[2]=LEDbm[digits[2]];
                LEDimage[3]=LEDbm[digits[1]];
            }
        }
        if(t[0]&t[1]&t[2]){         //save current cv when all three buttons pressed
            if(cvDefault != cv){    //don't write if no change
                cvDefault=cv;
                LEDimage[0]=0xFF;   //flash all segments on
                LEDimage[1]=0xFF;
                LEDimage[2]=0xFF;
                LEDimage[3]=0xFF;
            }
        }        
        __delay_ms(150);
        blank=blank^1;
    }
    return;
}

void __interrupt() isr(){
    if(PIR2bits.TMR2IF && PIE2bits.TMR2IE){
        PIR2bits.TMR2IF=0;
        updateLED();  
    }
}