#include "io.h"

char t[3],tOld[3];  //touch pad states
char digits[5];     //for an int, actual values
unsigned int adcref,dacref;

const unsigned char LEDbm[]={
    0b00111111, // 0
    0b00000110, // 1
    0b01011011, // 2
    0b01001111, // 3
    0b01100110, // 4
    0b01101101, // 5
    0b01111101, // 6
    0b00000111, // 7
    0b01111111, // 8
    0b01101111, // 9
    0b01110111, // A
    0b01111100, // b
    0b00111001, // C
    0b01011110, // d
    0b01111001, // E
    0b01110001, // F
};

unsigned char LEDimage[4];

void ioInit(void){
    LEDimage[0]=LEDbm[7];
    LEDimage[1]=LEDbm[6];
    LEDimage[2]=LEDbm[5];
    LEDimage[3]=LEDbm[4];
    trisbits.SEGA=1;
    trisbits.SEGB=1;
    trisbits.SEGC=1;
    trisbits.SEGD=1;
    trisbits.SEGE=1;
    trisbits.SEGF=1;
    trisbits.SEGG=1;
    trisbits.SEGDP=1;
    trisbits.COM1=1;
    trisbits.COM2=1;
    trisbits.COM3=1;
    trisbits.COM4=1;

    latbits.SEGA=SEGS;
    latbits.SEGB=SEGS;
    latbits.SEGC=SEGS;
    latbits.SEGD=SEGS;
    latbits.SEGE=SEGS;
    latbits.SEGF=SEGS;
    latbits.SEGG=SEGS;
    latbits.SEGDP=SEGS;
    latbits.COM1=COMS;
    latbits.COM2=COMS;
    latbits.COM3=COMS;
    latbits.COM4=COMS;    

    adcref=readNVM(DIA_FVRA2X);
    dacref=readNVM(DIA_FVRC2X);
}

void updateLED(void){
    //show last DP if output is on
    if(0==trisbits.SWPIN){LEDimage[3]=LEDimage[3]|0x80;}    
    static char com=0;
    unsigned char a=LEDimage[com];
    //clear all
    trisbits.SEGA=1;
    trisbits.SEGB=1;
    trisbits.SEGC=1;
    trisbits.SEGD=1;
    trisbits.SEGE=1;
    trisbits.SEGF=1;
    trisbits.SEGG=1;
    trisbits.SEGDP=1;
    trisbits.COM1=1;
    trisbits.COM2=1;
    trisbits.COM3=1;
    trisbits.COM4=1;
    if(a&128){trisbits.SEGDP=0;}
    if(a& 64){trisbits.SEGG=0;}
    if(a& 32){trisbits.SEGF=0;}
    if(a& 16){trisbits.SEGE=0;}
    if(a&  8){trisbits.SEGD=0;}
    if(a&  4){trisbits.SEGC=0;}
    if(a&  2){trisbits.SEGB=0;}
    if(a&  1){trisbits.SEGA=0;}
    com++;
    if(com==1){trisbits.COM1=0;}
    if(com==2){trisbits.COM2=0;}
    if(com==3){trisbits.COM3=0;}
    if(com==4){trisbits.COM4=0;com=0;}  //loop back
}

void boostInit(void){
    //passive boost reg    
    //PCB has SW on RA2, FB on RC1/C1IN1-
    anselbits.FBPIN=1;  //analog
    //PPS
    INTCONbits.GIE=0; //Suspend interrupts
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 0; //clear PPSLOCKED bit
    RA2PPS=0x1;     //CLC1_OUT
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 1; //set PPSLOCKED bit   
    //FVR
    FVRCONbits.CDAFVR=2;    //2.048V nominal
    FVRCONbits.EN=1;        //on    
    //DAC
    DAC1CON=0;      //reset=off, low range, OUT disabled, VDD/VSS ref    
    DAC1CONbits.PSS=2;  //FVR buffer 2
    DAC1CONbits.EN=1;   //on
    DAC1DATL=0;       //set    
    //T1 for comparator sync
    T1CON=0;    //off, PS=1, sync on, 8bit writes
    T1GCON=0;   //no gate
    T1CLK=1;    //FOSC/4
    T1CONbits.CKPS=1;       //2=>250ns gating
    T1CONbits.ON=1; //start    
    //COMPARATOR
    CM1CON0=0;      //reset=not inverted, no hysteresis, T1 ASYNC
    CM1CON1=0;      //no interrupts
    CM1NCH=1;       //C1IN1- = RC1
    CM1PCH=4;       //DAC
    //CM1CON0bits.C1HYS=1;    //hysteresis on
    CM1CON0bits.C1SYNC=1;   //sync to T1
    CM1CON0bits.C1EN=1;     //on
    //CLC1
    CLCSELECT=0;    //set up CLC1
    CLCnCON=0;      //off, no interrupts, cell in AND-OR
    CLCnPOL=0;      //all non-inverted
    CLCnSEL0=31;    //C1OUT
    CLCnSEL1=22;    //PWM1S1P1_OUT
    CLCnGLS0=2;     //gate SEL0 to D1
    CLCnGLS1=8;     //gate SEL1 to D2
    CLCnGLS2=0;     //logic 0 to D3
    CLCnGLS3=0;     //logic 0 to D4
    CLCnCONbits.EN=1;   //on
    //PWM1S1
    PWM1CON=0;          //reset
    PWM1ERS=0;
    PWM1CLK=2;          //FOSC (FOSC/4 not available)
    PWM1LDS=0;
    PWM1PR=60;          //short period
    PWM1CPRE=0;         //no prescale
    PWM1S1CFG=0;        //left aligned, normal polarity
    PWM1S1P1=48;        //80% duty
    PWM1GIE=0;          //no ints    
    PWM1CONbits.LD=1;   //load
    PWM1CONbits.EN=1;   //run
    //OUTPUT to SW
    anselbits.SWPIN=0;
    //turn off for now, can turn on in main
    trisbits.SWPIN=1;   //output off
}

void initADC(void){
    ADCON0=0;           //reset ADC, single ended
    ADCON1=0;
    ADCON2=0;           //legacy mode
    ADCON3=0;
    ADPRE=0;
    ADACQ=0;
    ADCAP=0;            //extra capacitance
    ADCON0bits.CS=1;    //ADCRC
    ADCON0bits.ADFM0=1; //right justify
    ADCON2=0;           //legacy mode
    //ADREF=0;            //VDD    
    ADREF=3;            //FVR
    ADCON0bits.ADON=1;  //turn on, ready
    //FVR
    FVRCONbits.ADFVR=2;    //2.048V nominal
    FVRCONbits.EN=1;        //on    
}

void initADCcvd(void){
    anselbits.TOUCH1=1;
    anselbits.TOUCH2=1;
    anselbits.TOUCH3=1;
    trisbits.TOUCH1=1;
    trisbits.TOUCH2=1;
    trisbits.TOUCH3=1;
    ADCON0=0;           //reset ADC, single ended
    ADCON0bits.CS=1;    //ADCRC
    ADCON0bits.ADFM0=1; //right justify
    ADCON0bits.ADCONT=1;//double sample
    ADCON1=0b01000001;  //PPOL=0,DSEN=1, IPEN=1    
    ADCON2=0;           //legacy mode, ADRES>ADPREV, 
    ADCON3=0b00001111;  //SOI set, regardless
    ADREF=0;            //VDD    
    ADPRE=10;
    ADACQ=10;
    ADCAP=1;            //extra capacitance
    ADCON0bits.ADON=1;  //turn on, ready    
    ADPCH=0b111010;     //ground
    //FVR
    FVRCONbits.ADFVR=2;    //2.048V nominal
    FVRCONbits.EN=1;        //on    
}

unsigned int getVCC(void){  //
    unsigned long r;
    ADCON0=0;           //reset ADC, single ended
    ADCON1=0;
    ADCON2=0;           //legacy mode
    ADCON3=0;
    ADPRE=0;
    ADACQ=0;
    ADCAP=0;            //extra capacitance
    ADCON0bits.CS=1;    //ADCRC
    ADCON0bits.ADFM0=1; //right justify
    ADCON2=0;           //legacy mode
    //ADREF=0;            //VDD    
    ADREF=0;            //VCC
    ADCON0bits.ADON=1;  //turn on, ready
    //FVR
    FVRCONbits.ADFVR=2;    //2.048V nominal
    FVRCONbits.EN=1;        //on    
    r=getADC(FVRBUF1);      //ADC FVR
    if(r<1000){return 9000;}    //possible overflow/error
    return (unsigned int)((4096*((unsigned long)adcref))/r);
}

unsigned int getADC(char c){
    ADPCH=c;
    ADCON0bits.GO=1;
    while(ADCON0bits.GO){}    
    return ADRES;
}

unsigned int getADCcvd(char c){
    ADPCH=c;
    ADCON0bits.GO=1;
    while(ADCON0bits.GO){}    
    ADPCH=0b111010;     //ground
    return ADERR;    
}

unsigned int readNVM(unsigned int add){ //maps top bit to NVMREGS
    NVMREGS=0;
    if(add&0x8000){NVMREGS=1;}
    NVMADR=add;
    NVMCON1bits.RD=1;   //start read
    return NVMDAT;    
}

void tmr2init(void){
    //TIMER2
    T2CON=0;    //reset
    T2CONbits.T2CKPS=7;     //128
    T2CONbits.T2OUTPS=0;    //1
    T2CLKCON=1;             //FOSC/4
    T2HLT=0;                //free running
    TMR2=0;
    PR2=255;                //full period
    PIR2bits.TMR2IF=0;
    PIE2bits.TMR2IE=1;
    INTCONbits.PEIE=1;
    T2CONbits.TMR2ON=1;    
}

void doTouch(void){
    unsigned int tt;
    initADCcvd();
    tOld[0]=t[0];
    tOld[1]=t[1];
    tOld[2]=t[2];
    tt=getADCcvd(TOUCH1);
    if(tt>TOUCH_DOWN){t[0]=1;}
    if(tt<TOUCH_UP){t[0]=0;}    
    tt=getADCcvd(TOUCH2);
    if(tt>TOUCH_DOWN){t[1]=1;}
    if(tt<TOUCH_UP){t[1]=0;}    
    tt=getADCcvd(TOUCH3);
    if(tt>TOUCH_DOWN){t[2]=1;}
    if(tt<TOUCH_UP){t[2]=0;}    
}

void getDigits(unsigned int n){
    digits[0]=0;
    digits[1]=0;
    digits[2]=0;
    digits[3]=0;
    digits[4]=0;
    char p=4;
    unsigned int d=10000;
    while(n){
        if(n>=d){
            n=n-d;
            digits[p]++;
        }else{
            d=d/10;
            p--;
        }
    }
}

unsigned int adjust(unsigned int v,unsigned int m){
    unsigned long t;
    t=(unsigned long)v * (unsigned long)m;
    t=t/4096;
    return (unsigned int)t;
}