#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "portbits.h"

extern unsigned char LEDimage[4];
extern const unsigned char LEDbm[];
extern char t[3],tOld[3];  //touch pad states
extern char digits[5];     //for an int, actual values
extern unsigned int adcref,dacref;

#define TOUCH_DOWN (0x480)
#define TOUCH_UP (0x580)

#define LED_IS_CA
//#define LED_IS_CC
//these are just set once with tris used to turn on/off
#ifdef LED_IS_CA
#define COMS (1)
#define SEGS (0)
#endif
#ifdef LED_IS_CC
#define COMS (0)
#define SEGS (1)
#endif

#define SEGA c5
#define SEGB a0
#define SEGC c6
#define SEGD a4
#define SEGE a5
#define SEGF c3
#define SEGG c7
#define SEGDP c4
#define COM1 b4
#define COM2 c2
#define COM3 c0
#define COM4 a1

#define TOUCH1 b7
#define TOUCH2 b6
#define TOUCH3 b5

#define FBPIN c1
#define SWPIN a2

//ADC channels
#define DAC2OUT 0b111101
#define DAC1OUT 0b111100
#define FVRBUF1 0b111110 
#define FVRBUF2 0b111111 

void boostInit(void);
void ioInit(void);
void initADCcvd(void);
void updateLED(void);
void initADC(void);
unsigned int getVCC(void);
unsigned int getADC(char c);
unsigned int getADCcvd(char c);
unsigned int readNVM(unsigned int add);
void tmr2init(void);
void doTouch(void);
void getDigits(unsigned int n);
unsigned int adjust(unsigned int v,unsigned int m);

#endif	/* IO_H */

