//IO setup and interfaces

//pinout for RevA PCB:
//1     RC7 DCINSENSE
//2     RD4 LCDD7
//3     RD5 LCDD6
//4     RD6 LCDD5
//5     RD7 LCDD4
//8     RB0 LCDEN
//9     RB1 LCDRS
//10    RB2 VIN1
//11    RB3 VIN2
//14    RB4 VIN3
//15    RB5 VIN4
//16    RB6 PGC
//17    RB7 PGD
//23    RA4 LED2A
//24    RA5 LED1A
//25    RE0 LED1B
//26    RE1 LED2B
//27    RE2 S3
//30    RA7 S2
//31    RA6 S1
//32    RC0 I2FB
//35    RC1 I2SET
//36    RC2 V2SET
//37    RC3 V2FB
//38    RD0 PIEZO
//39    RD1 IIN2
//40    RD2 IIN1
//41    RD3 V1FB
//42    RC4 V1SET
//43    RC5 I1SET
//44    RC6 I1FB

#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  

#define _XTAL_FREQ 32000000
#define LED1A LATAbits.LATA5
#define LED1B LATEbits.LATE0
#define LED2A LATAbits.LATA4
#define LED2B LATEbits.LATE1
#define S1 (!PORTAbits.RA6)
#define S2 (!PORTAbits.RA7)
#define S3 (!PORTEbits.RE2)
#define LED_OFF (0)
#define LED_GREEN (1)
#define LED_RED (2)
#define DCINSENSE (23)
#define VIN1 (10)
#define VIN2 (11)
#define VIN3 (12)
#define VIN4 (13)
#define I2FB (16)
#define I2SET (17)
#define V2SET (18)
#define V2FB (19)
#define IIN2 (25)
#define IIN1 (26)
#define V1FB (27)
#define V1SET (20)
#define I1SET (21)
#define I1FB (22)
#define PIEZO LATDbits.LATD0

void ioinit(void);
int getADC(char channel);
void LED1(char s);
void LED2(char s);
unsigned int adjust(unsigned int raw,unsigned int scale);//scale is effectively a 8.8 fixed point multiplier presented as uint

#endif	/* IO_H */

