#include "io.h"

void ioinit(void){
    //GPIO analog
    //B2,B3,B4,B5,
    //C0,C1,C2,C3,C4,C5,C6,C7
    //D1,D2,D3,    
    ANSELA=0;
    ANSELB=0b00111100;
    ANSELC=0b11111111;
    ANSELD=0b00001110;
    ANSELE=0;
    //LEDs
    TRISAbits.TRISA5=0;
    LED1A=0;
    TRISEbits.TRISE0=0;
    LED1B=0;
    TRISAbits.TRISA4=0;
    LED2A=0;
    TRISEbits.TRISE1=0;
    LED2B=0;
    //Switches
    WPUAbits.WPUA6=1;
    WPUAbits.WPUA7=1;
    WPUEbits.WPUE2=1;    
    //ADC
    ADCON0=0;   //reset ADC
    ADFRM0=1;   //right-justify
    ADCLK=63; //FOSC/128 (2n+2)
    //ADCLK=15; //FOSC/32 (2n+2)
    //ADREF=3;    //FVR ADC reference
    ADREF=0;    //VCC ADC reference
    ADCON0bits.ADON=1;  //turn on ADC    
    //FVR for battery check reference and higher precision measurements
    FVRCON=0b10000001;  //on, ADCx1=1.024V
    //Assumes active device on piezo pin (no PWM needed)
    PIEZO=0;
    TRISD0=0;
}

int getADC(char channel){           //get ADC result from channel
    ADPCH=channel;
    ADGO=1;         //go
    while(ADGO){};  //wait for conversion
    return ADRES;
}

void LED1(char s){
    if(s&1){LED1A=1;}else{LED1A=0;}
    if(s&2){LED1B=1;}else{LED1B=0;}
}

void LED2(char s){
    if(s&1){LED2A=1;}else{LED2A=0;}
    if(s&2){LED2B=1;}else{LED2B=0;}
}

unsigned int adjust(unsigned int raw,unsigned int scale){
    //scale is effectively a 8.8 fixed point multiplier presented as uint
    unsigned long temp;
    temp=((long)raw)*((long)scale);
    temp=temp>>8;
    return temp;
}

