
 
; Clifford Cricket (Crazy Cricket)
; incorporating Ferdinand Frog (Freaky Frog)
; Cricket and Frog sounds are alternated from one to the other at power up
; one time its Freaky, Crazy the next.

;	ERRORLEVEL -302
;	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_OFF & _PWRTE_ON & _WDT_ON & _INTRC_OSC_NOCLKOUT	

; EEPROM
EEPROM0			equ	H'00'	; non-volatile storage for frog/cricket sound alternative

; RAM 

STORE1			equ	H'20'	; delay counter	
STORE2			equ	H'21'	; delay counter
STORE3			equ	H'22'	; delay counter
ON_FLG			equ	H'23'	; chirp on flag
TIMER1			equ	H'24'	; run timer
TIMER2			equ	H'25'	; run timer
FLASH			equ	H'26'	; LED flash
CHECK_COUNT		equ	H'27'	; counter for LDR checking
SOFT_START		equ	H'28'	; soft start timer
SOFT_STORE		equ	H'29'	; store soft start
SOFT_END		equ	H'2A'	; subtraction value
ALTERNATE		equ	H'2B'	; frog alternate chirp
TEMP			equ	H'2C'	; temporary
CRICK_FROG		equ	H'2D'	; alternate sound flag
QUIET_TIMER		equ	H'2E'	; timer for quieting
QUIET_TIM0		equ	H'2F'	; multiplier
QUIET			equ	H'30'	; quiet flag
				
; random number generator registers
BARGB0			equ	H'31'	; random number generator
BARGB1			equ	H'32'	; random number generator
BARGB2			equ	H'33'	; random number generator
AARGB0			equ	H'34'	; random number gen
AARGB1			equ	H'35'	; random number gen
AARGB2			equ	H'36'	; random number gen
AARGB3			equ	H'37'	; random number gen
AARGB4			equ	H'38'	; random number gen
AARGB5			equ	H'39'	; random number gen
AARGB6			equ	H'3A'	; random number gen
RANDB0			equ	H'3B'	; random number seed
RANDB1			equ	H'3C'	; random number seed
RANDB2			equ	H'3D'	; random number seed
RANDB3			equ	H'3E'	; random number seed
TEMPB0			equ	H'3F'	; random gen temp files
TEMPB1			equ	H'40'	; random gen temp files
TEMPB2			equ	H'41'	; random gen temp files
TEMPB3			equ	H'42'	; random gen temp files
LOOPCOUNT		equ	H'43'	; loop counter in random gen


; preprogram EEPROM DATA 
	
	ORG     H'2100'
	DE		H'00'

; ******************************************************************

; start at memory 0

	org		0			; reset vector
	goto	MAIN
	    			; interrupt vector (not used)
	
; **********************************************************
	
; Lookup tables for cricket chirp

GAP			; gap between individual bursts
	addwf	PCL,f		; add w to program counter (8max)
	retlw	D'45'
	retlw	D'40'		; 40= 18ms
	retlw	D'41'
	retlw	D'40'
	retlw	D'41'
	retlw	D'39'
	retlw	D'38'
	retlw	D'41'
	retlw	D'40'
	
BURST		; individual burst length within triplet
	addwf	PCL,f		; add w to program counter (16max)
	retlw	D'71'		; 70 = 20ms
	retlw	D'70'
	retlw	D'71'
	retlw	D'70'
	retlw	D'71'
	retlw	D'70'
	retlw	D'73'
	retlw	D'71'
	retlw	D'71'
	retlw	D'70'
	retlw	D'72'
	retlw	D'70'
	retlw	D'70'
	retlw	D'70'
	retlw	D'70'
	retlw	D'70'
	retlw	D'70'

SEPARATION			; separation between the triple burst
	addwf	PCL,f		; add w to program counter (32max)
	retlw	D'75'	
	retlw	D'71'	; 80 = 320ms
	retlw	D'70'
	retlw	D'72'
	retlw	D'77'
	retlw	D'75'	
	retlw	D'100'	
	retlw	D'80'
	retlw	D'100'
	retlw	D'76'
	retlw	D'77'
	retlw	D'75'
	retlw	D'72'	
	retlw	D'75'
	retlw	D'78'
	retlw	D'75'
	retlw	D'77'
	retlw	D'50'
	retlw	D'60'
	retlw	D'41'
	retlw	D'65'
	retlw	D'71'
	retlw	D'75'
	retlw	D'72'
	retlw	D'73'
	retlw	D'75'	
	retlw	D'70'
	retlw	D'76'
	retlw	D'77'
	retlw	D'76'	
	retlw	D'75'
	retlw	D'70'
	retlw	D'75'


; Lookup tables for frog sounds

GAP_F			; gap between individual bursts
	addwf	PCL,f		; add w to program counter (8max)
	retlw	D'5'
	retlw	D'4'		; 4= 1.8ms
	retlw	D'4'
	retlw	D'4'
	retlw	D'4'
	retlw	D'3'
	retlw	D'3'
	retlw	D'4'
	retlw	D'4'
	
BURST_F		; individual burst length within triplet
	addwf	PCL,f		; add w to program counter (16max)
	retlw	D'36'		; 35 = 10ms
	retlw	D'35'
	retlw	D'36'
	retlw	D'35'
	retlw	D'36'
	retlw	D'35'
	retlw	D'37'
	retlw	D'36'
	retlw	D'36'
	retlw	D'35'
	retlw	D'37'
	retlw	D'35'
	retlw	D'35'
	retlw	D'35'
	retlw	D'35'
	retlw	D'35'
	retlw	D'35'

SEPARATION_F			; separation between the triple burst
	addwf	PCL,f		; add w to program counter (32max)
	retlw	D'100'
	retlw	D'10'
	retlw	D'14'
	retlw	D'12'
	retlw	D'10'
	retlw	D'10'
	retlw	D'14'
	retlw	D'14'
	retlw	D'12'
	retlw	D'10'
	retlw	D'10'
	retlw	D'14'
	retlw	D'12'
	retlw	D'75'	
	retlw	D'71'	; 80 ~ 1s
	retlw	D'70'
	retlw	D'72'
	retlw	D'77'
	retlw	D'75'	
	retlw	D'100'	
	retlw	D'80'
	retlw	D'100'
	retlw	D'76'
	retlw	D'77'
	retlw	D'75'
	retlw	D'72'	
	retlw	D'10'
	retlw	D'10'
	retlw	D'14'
	retlw	D'12'
	retlw	D'50'
	retlw	D'15'
	retlw	D'41'

; ***********************************************************
		
MAIN
; set oscillator calibration
	bsf		STATUS,RP0	; bank 1
	call	H'3FF'		; oscillator calibration value
	movwf	OSCCAL
	bcf		STATUS,RP0	; select memory bank 0

; delay to allow device verify after programming
; start up delay ~3s
	movlw	D'20'		; delay extension
	movwf 	STORE3
DEL_CONT
	clrwdt
	movlw	H'FF'		; delay routine
	call	DELAYX
	decfsz	STORE3,f	; when 0, exit delay
	goto	DEL_CONT

; set inputs/outputs
	clrf	GPIO		; outputs low
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	clrf	ANSEL		; digital I/O
	movlw	B'00000000'	; pullups off
	movwf	WPU
	movlw	B'00001000'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'10001101'	; settings (pullups disabled) wdt prescaler/32 (18ms x 32 timeout)
	movwf	OPTION_REG
	bcf		STATUS,RP0	; select memory bank 0

; initial conditions
	clrf	GPIO
; set initial seed value
	movlw	0x27			; random seed value
	movwf	RANDB0
	movlw	0xF1
	movwf	RANDB1
	movlw	0x20			; random seed value
	movwf	RANDB2
	movlw	0x49
	movwf	RANDB3
	call	RAND32			; random number generator
	clrf	ON_FLG			; chirp on flag
	clrf	TIMER1			; run timer
	movlw	D'90'			; 90 = 90 minutes
	movwf	TIMER2			; run timer
	clrf	ALTERNATE

; set on time period
	movlw	D'50'			; preset multiplier 
	movwf	QUIET_TIM0
	call	RANDOM			; random number
	movf	AARGB0,w		; random time
	iorlw	B'00000111'		; sets minimum of 7
	movwf	QUIET_TIMER
	clrf	QUIET			; sound initially on 

; flash LEDs as a power up acknowledgement
	call	ACKNOWLEDGE

; alternate sound from cricket to frog to cricket to frog etc
	
	call	EEPROM_READ		; read current value
	movwf	CRICK_FROG		; alternate sound flag
; alternate bit 0
	btfss	CRICK_FROG,0
	goto	SET_CF
	clrf	CRICK_FROG
	goto	WRITE_CF
SET_CF
	bsf		CRICK_FROG,0
WRITE_CF	
	movf	CRICK_FROG,w
	btfss	PIR1,EEIF		; when set already writen (will write new value directly after programming)
	call	EEPROM_WRITE	; write to EEPROM
	
; check LDR for light/darkness
CK_LDR
	bcf		GPIO,1			; switch on LDR divider
	nop
	nop
	nop						; settling time
	btfsc	GPIO,3
	goto	CRICKET_SOUND	; when GPIO is high then darkness
	btfss	ON_FLG,0		; if cricket was on add hysteresis
	goto 	STOP
; add hysteresis
	bsf		GPIO,1			; LDR off. set high to set LDR input higher, then test again for a low
	bcf		GPIO,1			; LDR on
	nop
	nop
	btfsc	GPIO,3	
	goto	CRICKET_SOUND	; when GPIO is high then darkness  
STOP
	bsf		GPIO,1			; LDR off
	bcf		GPIO,5			; LED1 off
	bcf		GPIO,0			; LED2 off
	clrf	ON_FLG			; chirp off flag
; run timers reset
	clrf	TIMER1			; run timer
	movlw	D'90'
	movwf	TIMER2			; run timer

; SLEEP, low power mode

	sleep					; stop operations
	nop
; awakes with watchdog timeout

	goto	CK_LDR			; check LDR level
	
CRICKET_SOUND
	
	bsf		GPIO,1			; LDR off
; if already started chirping bypass startup delay
	btfsc	ON_FLG,0		; started flag
	goto	STARTED
; flash LEDs
	call	ACKNOWLEDGE		; flash low light detected acknowledgement
	clrf	ALTERNATE

; start up delay ~2.5 -38s random

	movf	AARGB3,w		; random value for delay
	iorlw	B'00001000'		; ensure minimum delay
	movwf 	STORE3			; delay extension
	movlw	D'10'
	movwf	CHECK_COUNT		; counter to check LDR
	
DEL_CONT1
	clrwdt
	movf	CHECK_COUNT,w
	btfsc	STATUS,Z
	goto	LDR_CK
	decf	CHECK_COUNT,f
	goto	DELAY_CONT
LDR_CK
	movlw	D'10'
	movwf	CHECK_COUNT		; counter to check LDR
; check LDR
	bcf		GPIO,1			; switch on LDR divider
	nop
	nop
	nop						; settling time
	btfsc	GPIO,3
	goto	DELAY_CONT		; when GPIO is high then darkness
	btfss	ON_FLG,0		; if cricket is already on add hysteresis
	goto 	STOP
; add hysteresis
	bsf		GPIO,1			; LDR off. set high to set LDR input higher, then test again for a low
	bcf		GPIO,1			; LDR on
	nop
	nop
	btfss	GPIO,3	
	goto	STOP			; when GPIO is high then darkness so continue delay
DELAY_CONT
	movlw	H'FF'			; delay routine
	call	DELAYX
	decfsz	STORE3,f		; when 0, exit delay
	goto	DEL_CONT1
	bsf		ON_FLG,0		; set on flag 
	goto	CK_LDR			; make sure LDR is still in darkness after delay

STARTED ; continuation of chirping

; check delays and randomly set chirping on or off during timeout period
	decfsz	QUIET_TIM0,f	; multiplier
	goto	SOUND
	movlw	D'5'			; different multiplier when off
	btfss	QUIET,0			; on or off flag
	movlw	D'50'			; preset multiplier
	movwf	QUIET_TIM0
	decfsz	QUIET_TIMER,f	; timer for quieting
	goto	SOUND
	movf	AARGB0,w		; random time
	iorlw	B'00000111'		; sets minimum of 7
	movwf	QUIET_TIMER
	btfss	QUIET,0			; when bit 0 is set, clear
	goto	SET_QUIET
	bcf		QUIET,0			; sound on
	goto	SOUND

SET_QUIET
	bsf		QUIET,0			; no sound	
	
SOUND
; check if cricket or frog
	btfsc	CRICK_FROG,0
	goto	FROG			; Frog
; Cricket
	clrwdt
	bsf		GPIO,1			; LDR off
	movlw	D'3'			; burst triplet 
	movwf	STORE3			; 3 x 4kHz bursts per chirp
CHIRP
	btfsc	QUIET,7			; if quiet required stop LEDs flashing
	goto	Q_LEDS
	btfss	AARGB1,7
	bsf		GPIO,5			; LED1 on
	btfsc	AARGB1,7
	bsf		GPIO,0			; LED2 on
Q_LEDS
	movf	AARGB0,w		; random value
	andlw	B'00001111'		; 16 max
	call	BURST			; get burst length
	movwf	STORE2			; individual burst length
	call	GENERATOR		; 4kHz tone (uses STORE1)

CHIRP_GAP
	bcf		GPIO,0			; LED2 off
	bcf		GPIO,5			; LED1 off
	call	RAND32			; random number
	movf	AARGB1,w		; random value
	andlw	B'00000111'		; 8 max
	call	GAP	
	call	DELAYX

	decfsz	STORE3,f		; run 3 bursts
	goto	CHIRP

; check LDR
	bcf		GPIO,1			; switch on LDR divider
	nop
	nop
	nop						; settling time
	btfsc	GPIO,3
	goto	TONE_GAP		; when GPIO is high then darkness
	btfss	ON_FLG,0		; if cricket is already on add hysteresis
	goto 	STOP
; add hysteresis
	bsf		GPIO,1			; LDR off. set high to set LDR input higher, then test again for a low
	bcf		GPIO,1			; LDR on
	nop
	nop
	btfss	GPIO,3	
	goto	STOP			; when GPIO is high then darkness so continue sounding 

TONE_GAP
	bsf		GPIO,1			; LDR off
	bcf		GPIO,0			; LED2 off
	bcf		GPIO,5			; LED1 off

; initial tone gap multiplier to give spacing between the triplets 
	movlw	D'8'
	movwf	STORE3

TONE_GAP1
	call	RAND32			; random number
	movf	AARGB2,w
	andlw	B'00011111'		; max of 32
	call	SEPARATION			
 	call	DELAYX			; delay set by separation value
	decfsz	STORE3,f
	goto	TONE_GAP1
	incf	ALTERNATE,f		; alternate

; check timeout timers
CK_TIMEOUT
; first check for Quiet
	btfss	QUIET,0			; if set then quiet required
	goto	CK_TIMEOUT1
; check if sequence correct
	btfsc	ALTERNATE,0		; start frog off on correct sequence
	goto	CK_TIMEOUT2	
	bsf		QUIET,7
	goto	CK_TIMEOUT2		; bypass clearing Quiet
CK_TIMEOUT1

; check if sequence correct
	btfsc	ALTERNATE,0		; stop frog on correct sequence
	goto	CK_TIMEOUT2
	clrf	QUIET			; clear bit 7
CK_TIMEOUT2
	decfsz	TIMER1,f
	goto	CRICKET_SOUND
	decfsz	TIMER2,f	
	goto	CRICKET_SOUND

TIMEOUT_TEST
; timeout, wait till light returns to reset
; run timers reset
	clrf	TIMER1			; run timer
	movlw	D'150'			; 150 minutes
	movwf	TIMER2			; run timer
; sleep when dark as timeout. Return to normal run mode when light detected to reset timeout
LDR_TIMEOUT
	bcf		GPIO,1			; switch on LDR divider
	nop
	nop
	nop						; settling time
	btfsc	GPIO,3			; LDR level
	goto	DARK			; when GPIO,3 is high then still in darkness
; add hysteresis
	bsf		GPIO,1			; LDR off. set high to set LDR input higher, then test again for a low
	bcf		GPIO,1			; LDR on
	nop
	nop
	btfss	GPIO,3			; LDR level
; when GPIO,3 is high then still in darkness
; when low then light so reset and start at normal run mode  
	goto	CK_LDR			; check LDR level

DARK
	bsf		GPIO,1			; LDR off
	bcf		GPIO,5			; LED1 off
	bcf		GPIO,0			; LED2 off

; SLEEP, low power mode

	sleep					; stop operations
	nop
; awakes with watchdog timeout

	goto	LDR_TIMEOUT		; check LDR level	

; ********************************************
; Frog sounds
FROG ; continuation of Frog 

	clrwdt
	bsf		GPIO,1			; LDR off
	movlw	D'10'
	btfsc	ALTERNATE,0
	movlw	D'3'			; burst modulation 
	movwf	STORE3			; 10 or 3 x 2kHz bursts per chirp
CHIRP_F
	btfsc	QUIET,7			; if quiet required stop LEDs flashing
	goto	Q_LEDS_F
	btfss	AARGB1,7
	bsf		GPIO,5			; LED1 on
	btfsc	AARGB1,7
	bsf		GPIO,0			; LED2 on
Q_LEDS_F
	movf	AARGB0,w		; random value
	andlw	B'00001111'		; 16 max
	call	BURST_F			; get burst length
	movwf	STORE2			; individual burst length
	bcf		STATUS,C
	rrf		STORE2,f
	call	GENERATOR_F		; 2kHz tone (uses STORE1)

CHIRP_GAP_F
	bcf		GPIO,0			; LED2 off
	bcf		GPIO,5			; LED1 off
	call	RAND32			; random number
	movf	AARGB1,w		; random value
	andlw	B'00000111'		; 8 max
	call	GAP_F	
	call	DELAYX
	decfsz	STORE3,f		; run 10 bursts
	goto	CHIRP_F

; check LDR
	bcf		GPIO,1			; switch on LDR divider
	nop
	nop
	nop						; settling time
	btfsc	GPIO,3
	goto	TONE_GAP_F		; when GPIO is high then darkness
	btfss	ON_FLG,0		; if cricket is already on add hysteresis
	goto 	STOP
; add hysteresis
	bsf		GPIO,1			; LDR off. set high to set LDR input higher, then test again for a low
	bcf		GPIO,1			; LDR on
	nop
	nop
	btfss	GPIO,3	
	goto	STOP			; when GPIO is high then darkness so continue sounding 

TONE_GAP_F
	bsf		GPIO,1			; LDR off
	bcf		GPIO,0			; LED2 off
	bcf		GPIO,5			; LED1 off

; initial tone gap multiplier to give spacing between the chirp sets 
	movlw	D'40'
	movwf	STORE3

TONE_GAP1_F
	call	RAND32			; random number
	btfss	ALTERNATE,0
	goto	SHORT_F

	movf	AARGB2,w
	andlw	B'00011111'		; max of 32
	call	SEPARATION_F			
 	call	DELAYX			; delay set by separation value
	decfsz	STORE3,f
	goto	TONE_GAP1_F
	goto	CK_TIMERS_F

SHORT_F
	movlw	D'3'
	movwf	STORE3
SHORT1_F
	movf	AARGB1,w		; random value
	andlw	B'00000111'		; 8 max
	call	BURST_F
	movwf	TEMP
; divide by 2

	bcf		STATUS,C
	rrf		TEMP,w
	
	call	DELAYX
	decfsz	STORE3,f
	goto	SHORT1_F

; check timeout timers
CK_TIMERS_F
	incf	ALTERNATE,f		; 3 or 10 
	goto	CK_TIMEOUT

; *********************************************
; subroutines

; flash LEDs as acknowledgement
ACKNOWLEDGE
	movlw	D'50'
	movwf	FLASH
ACK
	bsf		GPIO,0			; LED2
	call	DELAY_FLASH
	bcf		GPIO,0
	bsf		GPIO,5			; LED1
	call	DELAY_FLASH
	bcf		GPIO,5
	decfsz	FLASH,f
	goto	ACK
	return

; 4kHz generator (set STORE2 before routine for burst length)	
GENERATOR
	btfsc	QUIET,7			; if set quiet
	goto	SILENT
; divide burst length by 4
	bcf		STATUS,C
	rrf		STORE2,w		; /2
	movwf	SOFT_START		; soft start timer

	bcf		STATUS,C
	rrf		SOFT_START,f	; /4
	bcf		STATUS,C
	rrf		SOFT_START,f	; /8
	movf	SOFT_START,w
	movwf	SOFT_STORE
	subwf	STORE2,w
	movwf	SOFT_END		; soft end timer
	goto	GENERATOR1
GENERATOR2
	bsf		GPIO,2
	bcf		GPIO,4
	clrwdt
	movlw	D'40'			; frequency value 
	movwf	STORE1
DEC1
	decfsz	STORE1,f
	goto	DEC1	
	bcf		GPIO,2
	bsf		GPIO,4
	clrwdt
	movlw	D'40'			;  frequency value
	movwf	STORE1
DEC2
	decfsz	STORE1,f
	goto	DEC2
	decfsz	SOFT_END,f		; 4kHz burst length
	goto	GENERATOR2
	movf	SOFT_STORE,w
	movwf	SOFT_START
	goto	GENERATOR3

GENERATOR1
	bsf		GPIO,2
	clrwdt
	movlw	D'60'			; frequency value 
	movwf	STORE1
DEC5
	decfsz	STORE1,f
	goto	DEC5	
	bcf		GPIO,2
	clrwdt
	movlw	D'60'			;  frequency value
	movwf	STORE1
DEC6
	decfsz	STORE1,f
	goto	DEC6
	decfsz	SOFT_START,f	; 4kHz burst length
	goto	GENERATOR1		; softer burst at half drive
	goto	GENERATOR2		; full burst drive

GENERATOR3
	bsf		GPIO,2
	clrwdt
	movlw	D'60'			; frequency value 
	movwf	STORE1
DEC3
	decfsz	STORE1,f
	goto	DEC3	
	bcf		GPIO,2
	clrwdt
	movlw	D'60'			;  frequency value
	movwf	STORE1
DEC4
	decfsz	STORE1,f
	goto	DEC4
	decfsz	SOFT_START,f	; 4kHz burst length
	goto	GENERATOR3		; softer burst at half drive
	return

SILENT
	
	call	DELAYms			; use delay instead
	return
; frog generator

; 2kHz generator (set STORE2 before routine for burst length)	
GENERATOR_F
	btfsc	QUIET,7			; if set quiet
	goto	SILENT
; divide burst length by 4
	bcf		STATUS,C
	rrf		STORE2,w		; /2
	movwf	SOFT_START		; soft start timer

	bcf		STATUS,C
	rrf		SOFT_START,f	; /4
	bcf		STATUS,C
	rrf		SOFT_START,f	; /8
	movf	SOFT_START,w
	movwf	SOFT_STORE
	subwf	STORE2,w
	movwf	SOFT_END		; soft end timer
	goto	GENERATOR1_F
GENERATOR2_F ; full drive burst
	bsf		GPIO,2
	bcf		GPIO,4
	clrwdt
	movlw	D'65'			; frequency value 
	movwf	STORE1
DEC1_F
	decfsz	STORE1,f
	goto	DEC1_F	
	bcf		GPIO,2
	bsf		GPIO,4
	clrwdt
	movlw	D'65'			;  frequency value
	movwf	STORE1
DEC2_F
	decfsz	STORE1,f
	goto	DEC2_F
	decfsz	SOFT_END,f		; 2kHz burst length
	goto	GENERATOR2_F
	movf	SOFT_STORE,w
	movwf	SOFT_START
	goto	GENERATOR3_F

GENERATOR1_F
	bsf		GPIO,2
	clrwdt
	movlw	D'40'			; frequency value 
	movwf	STORE1
DEC5_F
	decfsz	STORE1,f
	goto	DEC5_F	
	bcf		GPIO,2
	clrwdt
	movlw	D'40'			;  frequency value
	movwf	STORE1
DEC6_F
	decfsz	STORE1,f
	goto	DEC6_F
	decfsz	SOFT_START,f	; 4kHz burst length
	goto	GENERATOR1_F	; softer burst at half drive
	goto	GENERATOR2_F	; full burst drive

GENERATOR3_F
	bsf		GPIO,2
	clrwdt
	movlw	D'40'			; frequency value 
	movwf	STORE1
DEC3_F
	decfsz	STORE1,f
	goto	DEC3_F	
	bcf		GPIO,2
	clrwdt
	movlw	D'40'			;  frequency value
	movwf	STORE1
DEC4_F
	decfsz	STORE1,f
	goto	DEC4_F
	decfsz	SOFT_START,f	; 4kHz burst length
	goto	GENERATOR3_F	; softer burst at half drive
	return

; delay loop 

DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	D'117'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	clrwdt
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

DELAY_FLASH
	movlw	D'10'		; delay value
	movwf	STORE1		; STORE1 is number of loops value
LOOP10	
	movlw	D'11'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP11
	clrwdt
	decfsz	STORE2,f
	goto	LOOP11
	decfsz	STORE1,f
	goto	LOOP10
	return

; Subroutines

; read mode
EEPROM_READ
	bsf 	STATUS,RP0 	; Bank 1
	movlw 	EEPROM0		;
	movwf 	EEADR 		; Address to read
	bsf 	EECON1,RD 	; EE Read
	movf 	EEDATA,w 	; Move data to w
	bcf		STATUS,RP0	; Bank 0
	return

; EEPROM write
EEPROM_WRITE
	clrwdt
	bsf 	STATUS,RP0 	; Bank 1
	movwf 	EEDATA		; data
;	movlw 	EEPROM0		;
;	movwf 	EEADR 		; Address
	bsf 	EECON1,WREN ; Enable write
;	bcf 	INTCON,GIE 	; Disable Interrupts
	movlw 	H'55'		; Unlock write
	movwf 	EECON2 		;
	movlw 	H'AA' 		;
	movwf 	EECON2 ;
	bsf 	EECON1,WR 	; Start the write
	bcf		STATUS,RP0	; Bank 0
	bcf		PIR1,EEIF	; clear end of write bit
WRITE
	btfsc	PIR1,EEIF
	goto	READY_RETURN
	clrwdt
	goto	WRITE
READY_RETURN
	bsf 	STATUS,RP0 	; Bank 1
	bcf 	EECON1,WREN ; disable write
	bcf		STATUS,RP0	; Bank 0
	return

; Random number generator

;	Input:	32 bit initial integer seed in AARGB0, AARGB1, AARGB2, AARGB3

;	Use:	CALL	RAND32

;	Output:	32 bit random integer in AARGB0, AARGB1, AARGB2, AARGB3

;	Result:	AARG  <--  RAND32( AARG )

;	

;		min	max	mean
;	Timing:	487	487	487	clks



;	Linear congruential random number generator

;		X <- (a * X + c) mod m

;	The calculation is performed exactly, with multiplier a, increment c, and
;	modulus m, selected to achieve high ratings from standard spectral tests.
RANDOM
RAND32
		MOVF		RANDB0,W
		MOVWF		AARGB0
		MOVF		RANDB1,W
		MOVWF		AARGB1
		MOVF		RANDB2,W
		MOVWF		AARGB2
		MOVF		RANDB3,W
		MOVWF		AARGB3

		MOVLW		0x0D			; multiplier a = 1664525
		MOVWF		BARGB2
		MOVLW		0x66
		MOVWF		BARGB1
		MOVLW		0x19
		MOVWF		BARGB0

		CALL		FXM3224U

        INCF        AARGB6,F		; c = 1
        BTFSC       STATUS,Z
        INCF        AARGB5,F
		BTFSC		STATUS,Z
		INCF		AARGB4,F
		BTFSC		STATUS,Z
		INCF		AARGB3,F
		BTFSC       STATUS,Z
        INCF        AARGB2,F
		BTFSC		STATUS,Z
		INCF		AARGB1,F
		BTFSC		STATUS,Z
		INCF		AARGB0,F

		MOVF		AARGB3,W
		MOVWF		RANDB0			; m = 2**32
		MOVF		AARGB4,W
		MOVWF		RANDB1
		MOVF		AARGB5,W
		MOVWF		RANDB2
		MOVF		AARGB6,W
		MOVWF		RANDB3

		RETLW		0x00

;       32x24 Bit Unsigned Fixed Point Multiply 32x24 -> 56

;       Input:  32 bit unsigned fixed point multiplicand in AARGB0, AARGB1,
;               AARGB2, AARGB3

;               24 bit unsigned fixed point multiplier in BARGB0, BARGB1,
;               BARGB2

;       Use:    CALL    FXM3224U

;       Output: 56 bit unsigned fixed point product in AARGB0

;       Result: AARG  <--  AARG x BARG

;       Max Timing:     11+617+2 = 630 clks

;       Min Timing:     11+151 = 162 clks

;       PM: 11+139+1 = 151              DM: 15

FXM3224U
                CLRF    AARGB4          ; clear partial product
                CLRF    AARGB5
                CLRF    AARGB6
                MOVF  	AARGB0,W
                MOVWF   TEMPB0
                MOVF   	AARGB1,W
                MOVWF   TEMPB1
                MOVF   	AARGB2,W
                MOVWF   TEMPB2
                MOVF   	AARGB3,W
                MOVWF   TEMPB3

                CALL 	UMUL3224L

                RETLW           0x00

; UMUL3224L        macro

;       Max Timing:     2+15+6*25+24+2+7*26+25+2+7*27+26 = 617 clks

;       Min Timing:     2+7*6+5+1+7*6+5+1+7*6+5+6 = 151 clks

;       PM: 31+24+2+25+2+26+2+27 = 139            DM: 15

UMUL3224L       MOVLW   0x08
                MOVWF   LOOPCOUNT

LOOPUM3224A
                RRF     BARGB2,F
                BTFSC   STATUS,C
                GOTO    ALUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224A

                MOVWF   LOOPCOUNT

LOOPUM3224B
                RRF     BARGB1,F
                BTFSC   STATUS,C
                GOTO    BLUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224B

                MOVWF   LOOPCOUNT

LOOPUM3224C
                RRF     BARGB0,F
                BTFSC   STATUS,C
                GOTO    CLUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224C

                CLRF    AARGB0
                CLRF    AARGB1
                CLRF    AARGB2
                CLRF    AARGB3
                RETLW   0x00
                
ALUM3224NAP     BCF     STATUS,C
                GOTO    ALUM3224NA
                
BLUM3224NAP     BCF     STATUS,C
                GOTO    BLUM3224NA
                
CLUM3224NAP     BCF     STATUS,C
                GOTO    CLUM3224NA

ALOOPUM3224
                RRF     BARGB2,F
                BTFSS   STATUS,C
                GOTO    ALUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF    TEMPB2,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB2,W
                ADDWF   AARGB2,F
                MOVF    TEMPB1,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB1,W
                ADDWF   AARGB1,F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0,F

ALUM3224NA
                RRF     AARGB0,F
                RRF     AARGB1,F
                RRF     AARGB2,F
                RRF     AARGB3,F
                RRF     AARGB4,F
                DECFSZ  LOOPCOUNT,F
                GOTO    ALOOPUM3224

                MOVLW   0x08
                MOVWF   LOOPCOUNT

BLOOPUM3224
                RRF     BARGB1,F
                BTFSS   STATUS,C
                GOTO    BLUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF    TEMPB2,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB2,W
                ADDWF   AARGB2,F
                MOVF    TEMPB1,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB1,W
                ADDWF   AARGB1,F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0,F

BLUM3224NA
                RRF    	AARGB0,F
                RRF     AARGB1,F
                RRF     AARGB2,F
                RRF     AARGB3,F
                RRF     AARGB4,F
                RRF     AARGB5,F
                DECFSZ  LOOPCOUNT,F
                GOTO    BLOOPUM3224

                MOVLW   0x08
                MOVWF   LOOPCOUNT

CLOOPUM3224
                RRF     BARGB0,F
                BTFSS   STATUS,C
                GOTO    CLUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF    TEMPB2,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB2,W
                ADDWF   AARGB2,F
                MOVF    TEMPB1,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB1,W
                ADDWF   AARGB1,F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0,F

CLUM3224NA
                RRF     AARGB0,F
                RRF     AARGB1,F
                RRF     AARGB2,F
                RRF     AARGB3,F
                RRF     AARGB4,F
                RRF     AARGB5,F
                RRF     AARGB6,F
                DECFSZ  LOOPCOUNT,F
                GOTO    CLOOPUM3224
				RETURN	
                

	end
