  '  ' ***** uMitePi *****
  ' *******************************
  '    Filename: uMitePi.bas
  '    Date: Aug 2021
  '    File Version:
  '     Written by: M.Ogden
  '    Function: uMitePi controller
  '   Device: micromite mx170
  '    Last Revision:
  '    Initial v0.6
  '   MMBasic Ver 5.05.04 ,raspberry Pi running  Node Red
  'adds some LED indicators, Fan control and Shutdown signaling
  'plus user code
  ''V2 PCB adds access to all unused MX170 IO pins, adds RTC connector
  'V0.7 release
  'v0.8 add I/O changes for version 2 PCB
  'v0.9 add standby state retention
  
  ' *******************************
  'IO Pin List
  'D1 Led (Button)
  'D5 Button
  'D6 Sig pi-running
  'D8 Out shutdown-Pi
  'D9 Out pi-power
  'Pin 4 Fan Ctrl
  'Pin 6 Fan Ctrl  on v2 pcb
  
  option explicit
  
  dim integer D1=10,D5=16,D8=15,D6=18,D9=17  'mx170 IO pins V1 pcb
  'dim integer D1=10,D5=16,D8=15,D6=9,D9=14  'mx170 IO pins V2 pcb
  'Variables
  dim q$=chr$(34),J$="&",temp$="",lastline$,newline$
  dim integer lotemp=45,hitemp=50
  'set lfan=0 if no low fan req'd
  dim integer lfan=0,hfan=95,ffan=60   'fan speeds,pwm
  dim integer secs=0,flag=0 'periods
  dim integer uptime=0  'time up in seconds
  dim integer upspower=0  'ups power on
  dim integer upstime=0 'time on battery
  Dim Integer userprocessflag
  'user variables
  dim integer pi.temp=0
  dim integer standby
  'LEDs & Outputs
  setpin d1, dout 'Led 1
  setpin D8, dout   'pi-shutdown
  setpin d9, dout 'pi-power
  pin(d8)=1 'pi-shutdown not-shutdown
  pin(d1)=0 'Led(button) off
  'Inputs
  setpin D5, intl,buttonpress,PULLUP  'S2 Button
  setpin D6, din  'pi running
  
  '*********************************************************************************
  'initialise
  var restore
  if standby=1 then
    print "Standby"
    cpu 5
    led3 d1,0
    pin(d9)=1  'shutdown power supply
  else
    pin(d9)=0 'take control of power supply On
    'Run Fan High
    'for v2 pcb change format to PWM 1,,,100,hfan etc
    PWM 1,ffan,hfan  'Run fan high
    pause 3000  'run fan
    PWM 1,ffan,lfan 'Run fan low
  end if
  
  
  
  'serial Com1
  open "com1:9600,,rec1" as #5
  settick 1000, T1,1  '1 sec timer
  'settick 60000,runonce,2
  
  'main loop processing
  do
    Watchdog 20000 ' set the WDT at 20 secs
    'process data from RPI
    if userprocessflag=1 then
      UserProcess
      UserProcessFlag=0
    end if
    'run periodic tasks
    if uptime mod 30 = 0 then fanctrl
    pause 1000 'restrict loop to 1 second minimum
  loop
  
  
  'core routines
sub runonce
  settick 0,0,2 'disable timer
end sub
  
  'Heartbeat
sub T1
  uptime=uptime+1
end sub
  
  
  'Led1 pulse p=pin
sub led1(p,d)
  if d=0 then d=50
  pulse p,d
end sub
  
  'Led2 toggle
sub led2(p)
  if pin(p)=1 then
    pin(p)=0
  else
    pin(p)=1
  end if
end sub
  
  'Led3 set
sub led3(p,hl)
  pin(p)=hl
end sub
  
sub fanctrl
  'for v2 pcb change format to PWM 1,,,100,hfan  etc
  if pi.temp=0 then exit sub  'exit if no pi.temp
  if pi.temp>hitemp then
    PWM 1,ffan,hfan
  endif
  if pi.temp<lotemp then
    PWM 1,ffan,lfan
  endif
end sub
  
Sub rec1
  'reads bytes from comms buffer , data terminated by CR will output a NewLine$ and set the UserFlag
  'also checks for block data transmissions , start with SOH (Dec 1)
  local a$
  local integer p,l
  'print "Buffer:";loc(5)
  a$=Input$(20,#5)  'user supplied processing routine
  'print a$;
  on error skip
  lastline$=lastline$ + a$    'add to data packet
packet:
  l=len(lastline$)
  p=instr(lastline$,chr$(13))
  if p>0 then   'CR found so process
    Newline$=left$(Lastline$,p-1)
    if l>p+1 then
      lastline$=mid$(lastline$,p+1) 'save the rest of the line
    else
      lastline$=""
    end if
    UserProcessFlag=1  'set process data flag
    'print "newline:"+newline$
  endif
End Sub
  
  'process json strings from RPI
Sub userprocess
  'print newline$
  pi.temp=val(jsonvalue$(newline$,"pi-temp"))
  print pi.temp
end sub
  
sub buttonpress
  pause 50  'debounce
  if pin(d5)=0 then presstime
end sub
  
sub presstime
  pause 1000
  if pin(d5)=0 then
    if pin(d6)=1 then   'is pi running
      print "Shutdown"
      led3 d1,1
      pin(d8)=0  'shutdown RPI
      pause 1000
      pin(d8)=1
      pause 10000' Wait for pi to shutdown
      led3 d1,0
      print "shutdown supply"
      pin(d9)=1  'shutdown power supply
      print "Standby"
      standby=1
      var save standby
      cpu 5
      
    else
      print "Restart"
      cpu 48
      led3 d1,1
      uptime=0
      pin(d9)=0  'power supply on
      standby=0
      var save standby
      pause 1000
      led3 d1,0
    end if
  else
    print "shortpress"
    
  end if
end sub
  
  
  
function jsonValue$(Jstring$,jParam$)
  local a,c,s$,d$,b,json$
  json$=jstring$
  s$=":"
  d$=","
  'locate parameter
  a=instr(JSON$,jparam$)
  'print "A is:";a
  json$=replace$(json$,chr$(34),"")  'strip quotes
  json$=replace$(json$,"}",",")  'replace closing curly brackets with comma
  if a>0 then 'retrieve value
    'look for separator :
    b=instr(a,json$,s$)
    if b>0 then
      'look for deliminator
      c=instr(b,JSON$,d$)
      if c>0 then
        jsonvalue$=mid$(JSON$,b+1,c-(b+1))
      endif
    endif
  endif
end function
  
  'replaceString$(string$, replaceWhat$, replaceWith$)
FUNCTION REPLACE$(R$, a$, b$)
  local integer i,j,c,d
  d=1
  REPLACE$=R$
  i = LEN(a$) : j = LEN(b$)
  do while INSTR(d,REPLACE$, a$) > 0
    c = INSTR(d,REPLACE$, a$)
    REPLACE$ = LEFT$(REPLACE$, c-1) + b$ + MID$(REPLACE$, c+i)
    d = c+j
  loop
END FUNCTION
  
  '**************** End Core routines and functions ********
  
  'user subs and tasks
  '*** User subs and other code here ***
  
  
  'End user subs and tasks