
/* USB Sound Effects Generator Module source code, Copyright 2012 SILICON CHIP Publications Pty. Ltd.
   Written by Nicholas Vinen, based on the Microchip CDC (serial) USB sample code.
   Target device: PIC18F27J53 */

#ifndef _AUDIO_H_
#define _AUDIO_H_

#include "config.h"

void audio_init(void);
void two_thirds(unsigned short long* value);
void three_quarters(unsigned short long* value);
unsigned short long audio_get_sound_memory_total(void);
unsigned short long audio_get_sound_memory_used(void);
unsigned short long audio_get_sound_memory_free(void);
unsigned short long audio_get_first_free_address(void);
audio_info* audio_get_available_slot(unsigned char* pindex);
void audio_play(unsigned char index, unsigned char portBmask, unsigned char portBval, unsigned char portBendmask, unsigned char portBendval, unsigned char loop);
unsigned char get_flash_chip(csl* pAddr);

#endif//_AUDIO_H_
