
/* USB Sound Effects Generator Module source code, Copyright 2012 SILICON CHIP Publications Pty. Ltd.
   Written by Nicholas Vinen, based on the Microchip CDC (serial) USB sample code.
   Target device: PIC18F27J53 */

#include "wav.h"
#define _CRT_SECURE_NO_WARNINGS
#include <string.h>

static unsigned char WAVgetInt(unsigned char* inPtr, unsigned int* x) {
	*x = *((unsigned int*)inPtr);
	return 2;
}

static unsigned char WAVgetLong(unsigned char* inPtr, unsigned long* x) {
	*x = *((unsigned long*)inPtr);
	return 4;
}

typedef union {
  unsigned long l;
  unsigned char c[4];
} cl;

static char mytoupper(char c) {
	if( c >= 'a' && c <= 'z' )
		c += 'A' - 'a';
	return c;
}

static unsigned char WAVgetID(unsigned char* inPtr, unsigned long* x) {
	cl l;
	l.c[0] = mytoupper(*inPtr++);
	l.c[1] = mytoupper(*inPtr++);
	l.c[2] = mytoupper(*inPtr++);
	l.c[3] = mytoupper(*inPtr++);
	*x=l.l;
	return 4;
}

static unsigned char WAVreadRiffChunk(unsigned char* inPtr, RiffHeader* riffHeader) {
	inPtr+=WAVgetID((unsigned char*)inPtr, (unsigned long*)&riffHeader->riff.chunkID);
	inPtr+=WAVgetLong((unsigned char*)inPtr, (unsigned long*)&riffHeader->riff.chunkSize);
	inPtr+=WAVgetID((unsigned char*)inPtr, (unsigned long*)&riffHeader->WAVID);
	return 12;
}

static unsigned char WAVreadDataChunk(unsigned char* inPtr, DataHeader* dataHeader) {
	inPtr+=WAVgetID((unsigned char*)inPtr, (unsigned long*)&dataHeader->data.chunkID);
	inPtr+=WAVgetLong((unsigned char*)inPtr, (unsigned long*)&dataHeader->data.chunkSize);
	dataHeader->dataPtr=inPtr;
	return 8;
}

unsigned char WAVreadFmtChunk(unsigned char* inPtr, FmtHeader* fmtHeader) {
	inPtr+=WAVgetID((unsigned char*)inPtr, (unsigned long*)&fmtHeader->fmt.chunkID);
	inPtr+=WAVgetLong((unsigned char*)inPtr, (unsigned long*)&fmtHeader->fmt.chunkSize);
	inPtr+=WAVgetInt((unsigned char*)inPtr, (unsigned int*)&fmtHeader->audioFormat);
	inPtr+=WAVgetInt((unsigned char*)inPtr, (unsigned int*)&fmtHeader->numChannels);
	inPtr+=WAVgetLong((unsigned char*)inPtr, (unsigned long*)&fmtHeader->sampleRate);
	inPtr+=WAVgetLong((unsigned char*)inPtr, (unsigned long*)&fmtHeader->byteRate);
	inPtr+=WAVgetInt((unsigned char*)inPtr, (unsigned int*)&fmtHeader->blockAlign);
	inPtr+=WAVgetInt((unsigned char*)inPtr, (unsigned int*)&fmtHeader->bitsPerSample);		
	return 24;
}
/*
unsigned int WAVreadListChunk(unsigned char* inPtr, ListHeader* listHeader, unsigned int skipIt)
{
	unsigned long x, s;
	unsigned char* u, limit;
	unsigned int k;
	
	u=inPtr;
	inPtr+=WAVgetID((unsigned char*)inPtr, (unsigned long*)&listHeader->list.chunkID);
	inPtr+=WAVgetLong((unsigned char*)inPtr, (unsigned long*)&listHeader->list.chunkSize);
	limit=inPtr+listHeader->list.chunkSize;
	inPtr+=WAVgetID((unsigned char*)inPtr, (unsigned long*)&listHeader->INFOID);
	if((listHeader->INFOID==LIST_INFO_ID)&&(skipIt==0))
	{
			while(inPtr<limit)
			{
				inPtr+=WAVgetID((unsigned char*)inPtr, (unsigned long*)&x);
				inPtr+=WAVgetLong((unsigned char*)inPtr, (unsigned long*)&s);
				switch(x)
				{
					default:
						// skip it
						inPtr+=s;
						break;
					
					case ARTIST_INFO_ID:
						k=0;
						while(s>0)
						{
							if(k<(MAX_ARTIST_LENGTH-1))listHeader->trackArtist[k++]=*inPtr;
							else break;
						
							inPtr++;
							s--;	
						}
						inPtr+=s;
						listHeader->trackArtist[k]='\0';
						break;
						
					case TRACK_INFO_ID:
						k=0;
						while(s>0)
						{							
							if(k<(MAX_TITLE_LENGTH-1))listHeader->trackTitle[k++]=*inPtr;
							else break;
							inPtr++;
							s--;
						}
						inPtr+=s;
						listHeader->trackTitle[k]='\0';
						break;
				
					case DATE_INFO_ID:
						k=0;
						while(s>0)
						{							
							if(k<(MAX_DATE_LENGTH-1))listHeader->trackDate[k++]=*inPtr;
							else break;
							inPtr++;
							s--;
						}
						inPtr+=s;
						listHeader->trackDate[k]='\0';
						break;
				
					case COMMENT_INFO_ID:
						k=0;
						while(s>0)
						{
							if(k<(MAX_COMMENT_LENGTH-1))listHeader->trackComment[k++]=*inPtr;
							else break;
							inPtr++;
							s--;
						}
						inPtr+=s;
						listHeader->trackComment[k]='\0';
						break;
				}
			}
	}		
	else
	{
			inPtr+=listHeader->list.chunkSize;
	}
	return inPtr-u;
}
*/

unsigned char WAVreadWAVHeader(unsigned char* inPtr, WAVHeader* header, unsigned maxBytes) {
	unsigned char* limit;
	
	limit=inPtr+maxBytes;
	inPtr+=WAVgetID((unsigned char*)inPtr, (unsigned long*)&header->riffHeader.riff.chunkID);
	inPtr+=WAVgetLong((unsigned char*)inPtr, (unsigned long*)&header->riffHeader.riff.chunkSize);
	inPtr+=WAVgetID((unsigned char*)inPtr, (unsigned long*)&header->riffHeader.WAVID);
	if((header->riffHeader.riff.chunkID==RIFF_HEADER_ID)&&(header->riffHeader.WAVID==WAV_HEADER_ID)) {
			while(inPtr<limit) {
				unsigned long chunkID;
				WAVgetID((unsigned char*)inPtr, &chunkID);

				if( chunkID == RIFF_HEADER_ID ) {
					inPtr+=WAVreadRiffChunk(inPtr, (RiffHeader*)&header->riffHeader);
				} else if( chunkID == DATA_HEADER_ID ) {
					WAVreadDataChunk(inPtr, (DataHeader*)&header->dataHeader);
					return 1;
				} else if( chunkID == FMT_HEADER_ID ) {
	 				inPtr+=WAVreadFmtChunk(inPtr, (FmtHeader*)&header->fmtHeader);
				} else {
					inPtr+=*((unsigned long*)(inPtr+4));
				}
			}
	}
	return 0;
}
