/************************************************************************
	usb_config.c
************************************************************************/

#ifndef USBCONFIG_H
#define USBCONFIG_H

// Definitions
#define USB_EP0_BUFF_SIZE		64	// Valid Options are 8, 16, 32, or 64 bytes.								
#define USB_MAX_NUM_INT     	2

// USB device descriptor
#define USB_USER_DEVICE_DESCRIPTOR &device_dsc
#define USB_USER_DEVICE_DESCRIPTOR_INCLUDE extern ROM USB_DEVICE_DESCRIPTOR device_dsc

// Configuration descriptors
#define USB_USER_CONFIG_DESCRIPTOR USB_CD_Ptr
#define USB_USER_CONFIG_DESCRIPTOR_INCLUDE extern ROM BYTE *ROM USB_CD_Ptr[]

// Set the USB ping pong mode
#define USB_PING_PONG_MODE USB_PING_PONG__FULL_PING_PONG

#define self_power 0

// Uncomment USB_INTERRUPT to set to polling
#define USB_INTERRUPT
//#define USB_POLLING

// Set the USB pullup option for usb_device.h
#define USB_PULLUP_OPTION USB_PULLUP_ENABLE
//#define USB_PULLUP_OPTION USB_PULLUP_DISABLED

// Use the internal USB transceiver module
#define USB_TRANSCEIVER_OPTION USB_INTERNAL_TRANSCEIVER

// Set either full-speed or low-speed USB device mode
#define USB_SPEED_OPTION USB_FULL_SPEED
//#define USB_SPEED_OPTION USB_LOW_SPEED

// Option to enable auto-arming of the status stage of control transfers
#define USB_ENABLE_STATUS_STAGE_TIMEOUTS

// Section 9.2.6 of the USB 2.0 specifications state that:
// Control transfers with no data stage must complete within 50ms of the start of the control transfer.
// Control transfers with (IN) data stage must complete within 50ms of sending the last IN data packet in fullfilment of the data stage.
// Control transfers with (OUT) data stage have no specific status stage timing (but must not exceed 5 seconds)
#define USB_STATUS_STAGE_TIMEOUT     (BYTE)45

#define USB_SUPPORT_DEVICE

#define USB_NUM_STRING_DESCRIPTORS 3

// Enable/disable event handlers
//#define USB_INTERRUPT_LEGACY_CALLBACKS
#define USB_ENABLE_ALL_HANDLERS
//#define USB_ENABLE_SUSPEND_HANDLER
//#define USB_ENABLE_WAKEUP_FROM_SUSPEND_HANDLER
//#define USB_ENABLE_SOF_HANDLER
//#define USB_ENABLE_ERROR_HANDLER
//#define USB_ENABLE_OTHER_REQUEST_HANDLER
//#define USB_ENABLE_SET_DESCRIPTOR_HANDLER
//#define USB_ENABLE_INIT_EP_HANDLER
//#define USB_ENABLE_EP0_DATA_HANDLER
//#define USB_ENABLE_TRANSFER_COMPLETE_HANDLER

// Set device type to USB HID
#define USB_USE_CDC

#define USB_MAX_EP_NUMBER	    2

/* CDC */
#define CDC_COMM_INTF_ID        0x0
#define CDC_COMM_EP             1
#define CDC_COMM_IN_EP_SIZE     10

#define CDC_DATA_INTF_ID        0x01
#define CDC_DATA_EP             2
#define CDC_DATA_OUT_EP_SIZE    64
#define CDC_DATA_IN_EP_SIZE     64

//------------------------------------------------------------------------------                                                
//Uncomment the "extra UART signals" that are desired to be enabled/supported.  
//These items are optional and none of them are required for basic RX and TX
//USB to UART translator devices.
//If one or more of the below options is enabled however, make sure that the
//polarity is selected correctly, and that the respective pin definitions 
//(ex: UART_RTS) and initialization macros (ex: mInitRTSPin()) are present and 
//defined correctly in the HardwareProfile - [platform name].h file.  
//------------------------------------------------------------------------------                                                
//#define USB_CDC_SUPPORT_DSR_REPORTING   //Signal from UART peripheral device, to CDC/USB host.  Indicates UART peripheral is ready to receive data and/or commands.
//#define USB_CDC_SUPPORT_DTR_SIGNALING   //Signal sent from the USB/CDC host, down to the UART peripheral device
//#define USB_CDC_SUPPORT_HARDWARE_FLOW_CONTROL   //Implements RTS/CTS UART flow control.

//RTS is GPIO output signal from CDC/USB host micro (indicates UART Rx buffer 
//   space available, and that the UART peripheral device is free to send data to the USB CDC micro)
//CTS is GPIO input on CDC/USB host micro (allows UART peripheral to tell the 
//   UART host [the USB micro] not to send anymore Tx data to it for awhile)

//Define the logic level for the "active" state.  Setting is only relevant if 
//the respective function is enabled.  Allowed options are:
//1 = active state logic level is Vdd
//0 = active state logic level is Vss
#define USB_CDC_CTS_ACTIVE_LEVEL    0
#define USB_CDC_RTS_ACTIVE_LEVEL    0
#define USB_CDC_DSR_ACTIVE_LEVEL    0
#define USB_CDC_DTR_ACTIVE_LEVEL    0                                      

//#define USB_CDC_SUPPORT_ABSTRACT_CONTROL_MANAGEMENT_CAPABILITIES_D2 //Send_Break command
#define USB_CDC_SUPPORT_ABSTRACT_CONTROL_MANAGEMENT_CAPABILITIES_D1 //Set_Line_Coding, Set_Control_Line_State, Get_Line_Coding, and Serial_State commands
/** DEFINITIONS ****************************************************/

#endif //USBCFG_H
