
; USB Sound Effects Generator Module source code, Copyright 2012 SILICON CHIP Publications Pty. Ltd.
; Written by Nicholas Vinen, based on the Microchip CDC (serial) USB sample code.
; Target device: PIC18F27J53

#include "P18CXXX.INC"
#include "P18MACRO.INC"

STRING CODE
mystrcpypgm2ram
  global mystrcpypgm2ram


 messg "mystrcpypgm2ram - LARGE"


; Proceedure: Three byte rom pointer.
;         Use FSR0 for 'dest' and TBLPTR for 'src' 

  ; Load TBLPTR with the 'src' pointer

          Stk3CpyToReg -5,TBLPTRL

  ; Load FSR0 with the 'dest' pointer

          Stk2CpyToReg -2,FSR0L

jLoop:
          tblrd     *+                  ; read & increment
          movff     TABLAT, INDF0

  ; Test for '\0'
          tstfsz    POSTINC0,ACCESS
          bra       jLoop

jEnd
  ; Make a copy for the return value
	  movff FSR0L, PRODL
	  movff FSR0H, PRODH

          return

  end
