
/* USB Sound Effects Generator Module source code, Copyright 2012 SILICON CHIP Publications Pty. Ltd.
   Written by Nicholas Vinen, based on the Microchip CDC (serial) USB sample code.
   Target device: PIC18F27J53 */

#pragma config WDTEN	= OFF		// wdt off
#pragma config PLLDIV   = 2      	// divide by 2
#pragma config CFGPLLEN	= ON		// pll enable
#pragma config STVREN	= OFF   	// reset on stack overflow
#pragma config XINST	= ON		// extended instructions off	
#pragma config CPUDIV	= OSC1		// no division on clock
#pragma config CP0	= OFF			// code protect off
#pragma config OSC	= INTOSCPLL		// allow clock output on RA6
//#pragma config SOSCSEL
#pragma config CLKOEC	= OFF		// clock output on RA6
#pragma config FCMEN	= ON		// fail safe clock monitor
//#pragma config IESO
//#pragma config WDTPS
#pragma config DSBOREN 	= OFF
#pragma config DSWDTEN  = OFF
//#pragma config DSWDTPS 
//#pragma config IOL1WAY 
//#pragma config ADCSEL 
//#pragma config MSSP7B_EN
//#pragma config WPFP 
//#pragma config WPCFG 
//#pragma config WPDIS 
//#pragma config WPEND 
#pragma config LS48MHZ 	= SYS48X8   // system clock is 48 MHz

#define RESET_VECTOR_ADDRESS		0x00
#define HIGH_INTERRUPT_VECTOR_ADDRESS	0x08
#define LOW_INTERRUPT_VECTOR_ADDRESS	0x18

// Function prototypes
void processUSBCommands(void);
void applicationInit(void);
void USBCBSendResume(void);
void highPriorityISRCode(void);
void lowPriorityISRCode(void);
